/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.avalon.base;

import com.ibm.nzna.projects.common.quest.oa.ActionDraft;
import com.ibm.nzna.projects.common.quest.oa.ExternalLinkDraft;
import com.ibm.nzna.projects.common.quest.oa.LinkGroupDraft;
import com.ibm.nzna.projects.common.quest.oa.QuestLinkDraft;
import com.ibm.nzna.projects.common.quest.oa.QuestionDraft;
import com.ibm.nzna.projects.common.quest.oa.SymptomDraft;
import com.ibm.nzna.projects.common.storedProc.oaValidate.FailureRec;
import com.ibm.nzna.projects.common.storedProc.oaValidate.UsageRec;
import com.ibm.nzna.projects.common.storedProc.oaValidate.ValidationRec;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.DateSystem;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.avalon.gui.PublishPanel;
import com.ibm.nzna.shared.util.FileUtil;
import com.ibm.nzna.shared.util.Text;
import java.io.File;

public class OAObjectValidator
implements AppConst {
    private PublishPanel publishPanel = null;
    private Object oaObject = null;
    private ValidationRec validationRec = null;
    private boolean errorOddLine = false;
    private boolean errorWarnLine = false;
    private boolean error = false;

    public void validate() {
        String string = Str.getStr(828) + " " + this.getObjectName();
        if (this.oaObject instanceof QuestionDraft) {
            this.publishPanel.setStatusText(string + " (" + ((QuestionDraft)this.oaObject).getInd() + ")");
            this.validationRec = ((QuestionDraft)this.oaObject).validate();
        } else if (this.oaObject instanceof ActionDraft) {
            this.publishPanel.setStatusText(string + " (" + ((ActionDraft)this.oaObject).getInd() + ")");
            this.validationRec = ((ActionDraft)this.oaObject).validate();
        } else if (this.oaObject instanceof SymptomDraft) {
            this.publishPanel.setStatusText(string + " (" + ((SymptomDraft)this.oaObject).getInd() + ")");
            this.validationRec = ((SymptomDraft)this.oaObject).validate();
        } else if (this.oaObject instanceof QuestLinkDraft) {
            this.publishPanel.setStatusText(string + " (" + ((QuestLinkDraft)this.oaObject).getInd() + ")");
            this.validationRec = ((QuestLinkDraft)this.oaObject).validate();
        } else if (this.oaObject instanceof ExternalLinkDraft) {
            this.publishPanel.setStatusText(string + " (" + ((ExternalLinkDraft)this.oaObject).getInd() + ")");
            this.validationRec = ((ExternalLinkDraft)this.oaObject).validate();
        } else if (this.oaObject instanceof LinkGroupDraft) {
            this.publishPanel.setStatusText(string + " (" + ((LinkGroupDraft)this.oaObject).getInd() + ")");
            this.validationRec = ((LinkGroupDraft)this.oaObject).validate();
        } else {
            GUISystem.printBox("Info", "OAObjectValidator does not know how to validate the object type passed!");
        }
        this.publishPanel.setStatusText(" ");
    }

    private String getObjectName() {
        String string = "Unknown";
        if (this.oaObject instanceof QuestionDraft) {
            string = Str.getStr(8);
        } else if (this.oaObject instanceof ActionDraft) {
            string = Str.getStr(793);
        } else if (this.oaObject instanceof SymptomDraft) {
            string = Str.getStr(920);
        } else if (this.oaObject instanceof QuestLinkDraft || this.oaObject instanceof ExternalLinkDraft) {
            string = Str.getStr(922);
        } else if (this.oaObject instanceof LinkGroupDraft) {
            string = Str.getStr(921);
        }
        return string;
    }

    public String getHTML() {
        String string = null;
        try {
            string = FileUtil.readFile("skins" + File.separator + PropertySystem.getString(21) + File.separator + "avalon" + File.separator + "ValidationPreview.html");
            string = Text.replaceInStr(string, "STR_VALIDATION", Str.getStr(1151));
            string = Text.replaceInStr(string, "STR_ERRORS", Str.getStr(761));
            string = Text.replaceInStr(string, "STR_WARNINGS", Str.getStr(1182));
            string = Text.replaceInStr(string, "STR_DEPENDENCIES", Str.getStr(1181));
            string = Text.replaceInStr(string, "STR_QUESTION", Str.getStr(8));
            string = Text.replaceInStr(string, "STR_SYMPTOM", Str.getStr(920));
            string = Text.replaceInStr(string, "STR_ACTION", Str.getStr(793));
            string = Text.replaceInStr(string, "STR_OBJECT", this.getObjectName());
            string = Text.replaceInStr(string, "STR_DEPENDENCIES", Str.getStr(1181));
            string = Text.replaceInStr(string, "DATE", DateSystem.prettyDateFromStamp(DateSystem.getCurrentTimestamp()));
            this.validate();
            if (this.validationRec != null) {
                int n = this.validationRec.failureVec == null ? 0 : this.validationRec.failureVec.size();
                int n2 = this.validationRec.usageVec == null ? 0 : this.validationRec.usageVec.size();
                int n3 = this.validationRec.symptomCoreqVec == null ? 0 : this.validationRec.symptomCoreqVec.size();
                this.publishPanel.setStatusText(Str.getStr(828));
                this.publishPanel.setMaximum(n + n2 + n3);
                string = this.logErrors(string);
                string = this.logWarnings(string);
                string = this.getDeps(string);
            } else {
                string = Text.replaceInStr(string, "STR_VALIDATION:", Str.getStr(1180));
                string = Text.replaceInStr(string, "WARNING_TABLE", Str.getStr(198));
                string = Text.replaceInStr(string, "ERROR_TABLE", Str.getStr(198));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            string = "<html><body><font size=2 face=\"Helvetica\">" + Str.getStr(1234) + "</font></body></html>";
            this.error = true;
        }
        this.publishPanel.setStatusText("");
        this.publishPanel.setValue(0);
        return string;
    }

    private String logErrors(String string) {
        if (this.validationRec.failureVec != null && this.validationRec.failureVec.size() > 0) {
            int n = 0;
            int n2 = this.validationRec.failureVec.size();
            FailureRec failureRec = null;
            StringBuffer stringBuffer = new StringBuffer("<TABLE WIDTH=\"100%\">");
            while (n < n2) {
                failureRec = (FailureRec)this.validationRec.failureVec.elementAt(n);
                stringBuffer.append(this.logErrorLine(failureRec));
                ++n;
                this.publishPanel.bumpProgress();
            }
            stringBuffer.append("</TABLE>");
            this.error = true;
            string = Text.replaceInStr(string, "ERROR_TABLE", stringBuffer.toString());
        } else {
            string = Text.replaceInStr(string, "ERROR_TABLE", Str.getStr(198));
        }
        return string;
    }

    private String logWarnings(String string) {
        if (this.validationRec.usageVec != null && this.validationRec.usageVec.size() > 0) {
            int n = 0;
            int n2 = this.validationRec.usageVec.size();
            UsageRec usageRec = null;
            StringBuffer stringBuffer = new StringBuffer("<table width=\"100%\" border=0>");
            while (n < n2) {
                usageRec = (UsageRec)this.validationRec.usageVec.elementAt(n);
                stringBuffer.append(this.logWarningLine(usageRec.objectInd, usageRec.usageType));
                ++n;
                this.publishPanel.bumpProgress();
            }
            stringBuffer.append("</TABLE>");
            string = Text.replaceInStr(string, "WARNING_TABLE", stringBuffer.toString());
        } else {
            string = Text.replaceInStr(string, "WARNING_TABLE", Str.getStr(198));
        }
        return string;
    }

    private String logErrorLine(FailureRec failureRec) {
        String string = "#FFFFFF";
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.errorOddLine) {
            this.errorOddLine = false;
            string = "#FFC0C0";
        } else {
            this.errorOddLine = true;
        }
        stringBuffer.append("<tr valign=\"top\" bgcolor=\"");
        stringBuffer.append(string);
        stringBuffer.append("><td width=\"13%\">");
        stringBuffer.append("<font face=\"Arial, Helvetica, sans-serif\" size=\"2\" color=\"#000000\">");
        stringBuffer.append(failureRec.objectInd + (failureRec.activeObject ? "" : "(" + Str.getStr(1066) + ")"));
        stringBuffer.append("</font></td><td width=\"84%\">");
        stringBuffer.append("<font face=\"Arial, Helvetica, sans-serif\" size=\"2\" color=\"#000000\">");
        stringBuffer.append(this.getErrorString(failureRec));
        stringBuffer.append("</font></td></tr>");
        stringBuffer.append("<tr bgcolor=\"");
        stringBuffer.append(string);
        stringBuffer.append("><td width=\"13%\">");
        stringBuffer.append("<font face=\"Arial, Helvetica, sans-serif\" size=\"2\" color=\"#000000\">");
        stringBuffer.append("&nbsp;&nbsp");
        stringBuffer.append("</font></td><td width=\"84%\">");
        stringBuffer.append("<font face=\"Arial, Helvetica, sans-serif\" size=\"2\" color=\"#000000\">");
        stringBuffer.append(failureRec.title);
        if (failureRec.answerInd > 0) {
            stringBuffer.append("<br><i>");
            stringBuffer.append(Str.getStr(987));
            stringBuffer.append(": ");
            stringBuffer.append(failureRec.answerTitle);
            stringBuffer.append("</i>");
        }
        stringBuffer.append("</font></td></tr>");
        return stringBuffer.toString();
    }

    private String logWarningLine(int n, int n2) {
        String string = "#FFFFFF";
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.errorWarnLine) {
            this.errorWarnLine = false;
            string = "#FFFFCO";
        } else {
            this.errorWarnLine = true;
        }
        stringBuffer.append("<tr valign=\"top\" bgcolor=\"");
        stringBuffer.append(string);
        stringBuffer.append("><td width=\"13%\">");
        stringBuffer.append("<font face=\"Arial, Helvetica, sans-serif\" size=\"2\" color=\"#000000\">");
        stringBuffer.append(n);
        stringBuffer.append("</font></td><td width=\"84%\">");
        stringBuffer.append("<font face=\"Arial, Helvetica, sans-serif\" size=\"2\" color=\"#000000\">");
        stringBuffer.append(this.getWarningString(n2));
        stringBuffer.append("</font></td></tr>");
        return stringBuffer.toString();
    }

    private String getErrorString(FailureRec failureRec) {
        String string = "Unknown error ind:" + failureRec.failureReason;
        switch (failureRec.failureReason) {
            case 907: {
                string = Str.getStr(1152);
                break;
            }
            case 908: {
                string = Str.getStr(1153);
                break;
            }
            case 909: {
                string = Str.getStr(1154);
                break;
            }
            case 915: {
                string = Str.getStr(1155);
                break;
            }
            case 913: {
                string = Str.getStr(1156);
                break;
            }
            case 914: {
                string = Str.getStr(1157);
                break;
            }
            case 917: {
                string = Str.getStr(1158);
                break;
            }
            case 916: {
                string = Str.getStr(1159);
                break;
            }
            case 918: {
                string = Str.getStr(1160);
                break;
            }
            case 906: {
                string = Str.getStr(1161);
                break;
            }
            case 910: {
                string = Str.getStr(1162);
                break;
            }
            case 911: {
                string = Str.getStr(1163);
                break;
            }
            case 912: {
                string = Str.getStr(1164);
                break;
            }
            case 919: {
                string = Str.getStr(1209);
                string = string + " " + UserSystem.getNameFromUserId(failureRec.dbUser) + ".";
                break;
            }
        }
        return string;
    }

    private String getWarningString(int n) {
        String string = "Unkown Warning:" + n;
        switch (n) {
            case 500: {
                string = Str.getStr(1165);
                break;
            }
            case 507: {
                string = Str.getStr(1166);
                break;
            }
            case 508: {
                string = Str.getStr(1167);
                break;
            }
            case 509: {
                string = Str.getStr(1168);
                break;
            }
            case 513: {
                string = Str.getStr(1169);
                break;
            }
            case 514: {
                string = Str.getStr(1170);
                break;
            }
            case 506: {
                string = Str.getStr(1171);
                break;
            }
            case 504: {
                string = Str.getStr(1172);
                break;
            }
            case 505: {
                string = Str.getStr(1173);
                break;
            }
            case 502: {
                string = Str.getStr(1174);
                break;
            }
            case 501: {
                string = Str.getStr(1175);
                break;
            }
            case 510: {
                string = Str.getStr(1176);
                break;
            }
            case 511: {
                string = Str.getStr(1177);
                break;
            }
            case 512: {
                string = Str.getStr(1178);
                break;
            }
            case 503: {
                string = Str.getStr(1179);
                break;
            }
            case 515: {
                string = Str.getStr(1169);
                break;
            }
        }
        return string;
    }

    public boolean getError() {
        return this.error;
    }

    public ValidationRec getValidationRec() {
        return this.validationRec;
    }

    public String getDeps(String string) {
        int n = this.validationRec.questionCoreqVec.size();
        int n2 = this.validationRec.actionCoreqVec.size();
        int n3 = this.validationRec.symptomCoreqVec.size();
        string = Text.replaceInStr(string, "QUESTION_COREQ", "" + n);
        string = Text.replaceInStr(string, "ACTION_COREQ", "" + n2);
        string = Text.replaceInStr(string, "SYMPTOM_COREQ", "" + n3);
        return string;
    }

    public OAObjectValidator(PublishPanel publishPanel, Object object) {
        this.publishPanel = publishPanel;
        this.oaObject = object;
    }
}

