/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.avalon.base;

import com.ibm.nzna.projects.common.quest.oa.Question;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.DateSystem;
import com.ibm.nzna.projects.qit.app.DisplayRec;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.MainWindow;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.avalon.base.AvalonConst;
import com.ibm.nzna.projects.qit.avalon.base.OAObjectDisplayRec;
import com.ibm.nzna.projects.qit.avalon.cache.AvalonCache;
import com.ibm.nzna.shared.gui.MultiListRow;
import com.ibm.nzna.shared.sort.IQuickSort;
import com.ibm.nzna.shared.util.CDate;
import java.io.Serializable;
import java.util.Vector;

public class QuestionDisplayRec
extends OAObjectDisplayRec
implements IQuickSort,
DisplayRec,
MultiListRow,
Serializable,
AvalonConst,
AppConst {
    static final long serialVersionUID = 1000000L;
    private int questionInd = 0;
    private int docClassInd = 0;
    private String title = null;
    private String changedTime = null;
    private String dbUser = null;
    private String prettyChangedTime = null;
    private String prettyDBUser = null;
    private Question question = null;

    public int getQuestionInd() {
        return this.questionInd;
    }

    public Object getColumnData(int n) {
        Object object = null;
        switch (n) {
            case 0: {
                if (this.docClassInd == 1) {
                    object = ImageSystem.getImage((Object)MainWindow.getInstance(), 102);
                    break;
                }
                if (this.docClassInd == 2) {
                    object = ImageSystem.getImage((Object)MainWindow.getInstance(), 103);
                    break;
                }
                object = ImageSystem.getImage((Object)MainWindow.getInstance(), 104);
                break;
            }
            case 1: {
                object = "";
                break;
            }
            case 2: {
                object = "" + this.questionInd;
                break;
            }
            case 3: {
                if (this.getTitleArray() == null) {
                    this.createTitleArray(this.title);
                }
                object = this.getTitleArray();
                break;
            }
            case 4: {
                if (this.prettyChangedTime == null) {
                    this.prettyChangedTime = DateSystem.prettyDateFromStamp(this.changedTime);
                }
                object = this.prettyChangedTime;
                break;
            }
            case 5: {
                if (this.prettyDBUser == null) {
                    this.prettyDBUser = UserSystem.getNameFromUserId(this.dbUser);
                }
                object = this.prettyDBUser;
                break;
            }
            default: {
                object = "";
                break;
            }
        }
        return object;
    }

    public Object getData() {
        return this.question;
    }

    public String toString() {
        return this.title;
    }

    public static Vector convert(Vector vector) {
        int n = vector.size();
        Vector<QuestionDisplayRec> vector2 = new Vector<QuestionDisplayRec>(n);
        int n2 = 0;
        while (n2 < n) {
            vector2.addElement(new QuestionDisplayRec((Question)vector.elementAt(n2)));
            ++n2;
        }
        return vector2;
    }

    public void setQuestion(Question question) {
        this.question = question;
    }

    public void readQuestion() {
        if (this.question == null) {
            this.setQuestion(AvalonCache.readQuestion(this.getQuestionInd()));
        }
    }

    public int compareTo(IQuickSort iQuickSort) {
        int n = 0;
        if (iQuickSort instanceof QuestionDisplayRec) {
            QuestionDisplayRec questionDisplayRec = (QuestionDisplayRec)iQuickSort;
            switch (this.getSort()) {
                case 1: {
                    n = CDate.compareDate(this.changedTime, questionDisplayRec.changedTime, 1);
                    break;
                }
                case 2: {
                    n = CDate.compareDate(questionDisplayRec.changedTime, this.changedTime, 1);
                    break;
                }
                case 3: {
                    n = this.title.compareTo(questionDisplayRec.title);
                    break;
                }
                case 4: {
                    n = questionDisplayRec.title.compareTo(this.title);
                    break;
                }
                case 8: {
                    n = this.dbUser.compareTo(questionDisplayRec.dbUser);
                    break;
                }
                case 9: {
                    n = questionDisplayRec.dbUser.compareTo(this.dbUser);
                    break;
                }
                case 5: {
                    if (this.docClassInd < questionDisplayRec.docClassInd) {
                        n = -1;
                        break;
                    }
                    if (this.docClassInd > questionDisplayRec.docClassInd) {
                        n = 1;
                        break;
                    }
                    n = 0;
                    break;
                }
                case 6: {
                    if (this.questionInd < questionDisplayRec.questionInd) {
                        n = -1;
                        break;
                    }
                    if (this.questionInd > questionDisplayRec.questionInd) {
                        n = 1;
                        break;
                    }
                    n = 0;
                    break;
                }
                case 7: {
                    if (this.questionInd < questionDisplayRec.questionInd) {
                        n = 1;
                        break;
                    }
                    if (this.questionInd > questionDisplayRec.questionInd) {
                        n = -1;
                        break;
                    }
                    n = 0;
                    break;
                }
            }
        }
        if (n > 0) {
            n = 1;
        } else if (n < 0) {
            n = -1;
        }
        return n;
    }

    public QuestionDisplayRec() {
    }

    public QuestionDisplayRec(int n, int n2, String string, String string2, String string3) {
        this.questionInd = n;
        this.docClassInd = n2;
        this.title = string;
        this.changedTime = string2;
        this.dbUser = string3;
    }

    public QuestionDisplayRec(Question question) {
        this.question = question;
        this.questionInd = question.getInd();
        this.docClassInd = question.getDocClass().getInd();
        this.title = question.getTitles().elementAt(question.getTitles().size() - 1).toString();
        this.changedTime = question.getChangedTime();
        this.dbUser = question.getDbUser();
    }
}

