/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.avalon.cache;

import com.ibm.nzna.projects.common.quest.oa.Action;
import com.ibm.nzna.projects.common.quest.oa.ActionDraft;
import com.ibm.nzna.projects.common.quest.oa.ExternalLinkDraft;
import com.ibm.nzna.projects.common.quest.oa.Link;
import com.ibm.nzna.projects.common.quest.oa.LinkDraft;
import com.ibm.nzna.projects.common.quest.oa.LinkGroup;
import com.ibm.nzna.projects.common.quest.oa.LinkGroupDraft;
import com.ibm.nzna.projects.common.quest.oa.OAInterface;
import com.ibm.nzna.projects.common.quest.oa.QuestLinkDraft;
import com.ibm.nzna.projects.common.quest.oa.Question;
import com.ibm.nzna.projects.common.quest.oa.QuestionDraft;
import com.ibm.nzna.projects.common.quest.oa.Symptom;
import com.ibm.nzna.projects.common.quest.oa.SymptomDraft;
import com.ibm.nzna.projects.qit.app.CacheSystem;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.avalon.base.AddtlInfoGraphicFTP;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.util.CDate;
import com.ibm.nzna.shared.util.LogSystem;
import java.sql.ResultSet;
import java.sql.Statement;

public class AvalonCache {
    public static Question readQuestion(int n) {
        return AvalonCache.readQuestion(n, false);
    }

    public static Question readQuestion(int n, boolean bl) {
        String string = null;
        Question question = null;
        String string2 = null;
        try {
            int n2 = PropertySystem.getInt(1);
            String string3 = "QUESTION_" + n2 + "_" + n + ".avalon";
            boolean bl2 = false;
            question = (Question)CacheSystem.getCachedObject(string3);
            if (question == null) {
                question = Question.readFromDatabase(n, n2);
                bl2 = true;
            } else if (!bl) {
                string2 = AvalonCache.getDatabaseTimestamp("SELECT CHANGEDTIME FROM OA.QUESTION WHERE QUESTIONIND = " + n);
                string = CacheSystem.getCacheTime(string3);
                if (CDate.compareDate(string, string2, 1) != 1) {
                    question = Question.readFromDatabase(n, n2);
                    bl2 = true;
                }
            }
            if (bl2) {
                CacheSystem.cacheObject(string3, question);
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
        return question;
    }

    public static QuestionDraft readQuestionDraft(int n) {
        return AvalonCache.readQuestionDraft(n, false);
    }

    public static QuestionDraft readQuestionDraft(int n, boolean bl) {
        String string = null;
        QuestionDraft questionDraft = null;
        String string2 = null;
        try {
            int n2 = PropertySystem.getInt(1);
            String string3 = "QUESTION_DRAFT_" + n2 + "_" + n + ".avalon";
            boolean bl2 = false;
            questionDraft = (QuestionDraft)CacheSystem.getCachedObject(string3);
            if (questionDraft == null) {
                questionDraft = (QuestionDraft)QuestionDraft.readFromDatabase(n, n2);
                bl2 = true;
            } else if (!bl) {
                string2 = AvalonCache.getDatabaseTimestamp("SELECT CHANGEDTIME FROM OADRAFT.QUESTION WHERE QUESTIONIND = " + n);
                string = CacheSystem.getCacheTime(string3);
                if (CDate.compareDate(string, string2, 1) != 1) {
                    questionDraft = (QuestionDraft)QuestionDraft.readFromDatabase(n, n2);
                    bl2 = true;
                }
            }
            if (bl2) {
                CacheSystem.cacheObject(string3, questionDraft);
            }
            AddtlInfoGraphicFTP.getGraphicsDraft(null, questionDraft.getAdditionalInfo());
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
        return questionDraft;
    }

    public static ActionDraft readActionDraft(int n) {
        return AvalonCache.readActionDraft(n, false);
    }

    public static ActionDraft readActionDraft(int n, boolean bl) {
        String string = null;
        ActionDraft actionDraft = null;
        String string2 = null;
        try {
            int n2 = PropertySystem.getInt(1);
            String string3 = "ACTION_DRAFT_" + n2 + "_" + n + ".avalon";
            boolean bl2 = false;
            actionDraft = (ActionDraft)CacheSystem.getCachedObject(string3);
            if (actionDraft == null) {
                actionDraft = (ActionDraft)ActionDraft.readFromDatabase(n, n2);
                bl2 = true;
            } else if (!bl) {
                string2 = AvalonCache.getDatabaseTimestamp("SELECT CHANGEDTIME FROM OADRAFT.ACTION WHERE ACTIONIND = " + n);
                string = CacheSystem.getCacheTime(string3);
                if (CDate.compareDate(string, string2, 1) != 1) {
                    actionDraft = (ActionDraft)ActionDraft.readFromDatabase(n, n2);
                    bl2 = true;
                }
            }
            if (bl2) {
                CacheSystem.cacheObject(string3, actionDraft);
            }
            AddtlInfoGraphicFTP.getGraphicsDraft(null, actionDraft.getAdditionalInfo());
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
        return actionDraft;
    }

    private static String getDatabaseTimestamp(String string) {
        SQLMethod sQLMethod = new SQLMethod(1, "AvalonCache.getDatabaseTimestamp", 5);
        String string2 = "";
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery(string);
            if (resultSet.next()) {
                string2 = resultSet.getString(1).trim();
            }
            resultSet.close();
            statement.close();
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception);
        }
        sQLMethod.close();
        return string2;
    }

    public static LinkGroup readLinkGroup(int n) {
        return AvalonCache.readLinkGroup(n, false);
    }

    public static LinkGroup readLinkGroup(int n, boolean bl) {
        String string = null;
        LinkGroup linkGroup = null;
        String string2 = null;
        try {
            int n2 = PropertySystem.getInt(1);
            String string3 = "LINKGROUP_" + n2 + "_" + n + ".avalon";
            boolean bl2 = false;
            linkGroup = (LinkGroup)CacheSystem.getCachedObject(string3);
            if (linkGroup == null) {
                linkGroup = LinkGroup.readFromDatabase(n, n2);
                bl2 = true;
            } else if (!bl) {
                string2 = AvalonCache.getDatabaseTimestamp("SELECT CHANGEDTIME FROM OA.LINKGROUP WHERE LINKGROUPIND = " + n);
                string = CacheSystem.getCacheTime(string3);
                if (CDate.compareDate(string, string2, 1) != 1) {
                    linkGroup = LinkGroup.readFromDatabase(n, n2);
                    bl2 = true;
                }
            }
            if (bl2) {
                CacheSystem.cacheObject(string3, linkGroup);
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
        return linkGroup;
    }

    public static Object readLink(int n) {
        return AvalonCache.readLink(n, false);
    }

    public static Object readLink(int n, boolean bl) {
        String string = null;
        Link link = null;
        String string2 = null;
        try {
            int n2 = PropertySystem.getInt(1);
            String string3 = "LINK_" + n2 + "_" + n + ".avalon";
            boolean bl2 = false;
            link = (Link)CacheSystem.getCachedObject(string3);
            if (link == null) {
                link = Link.readFromDatabase(n, n2);
                bl2 = true;
            } else if (!bl) {
                string2 = AvalonCache.getDatabaseTimestamp("SELECT CHANGEDTIME FROM OA.LINK WHERE LINKIND = " + n);
                string = CacheSystem.getCacheTime(string3);
                if (CDate.compareDate(string, string2, 1) != 1) {
                    link = Link.readFromDatabase(n, n2);
                    bl2 = true;
                }
            }
            if (bl2) {
                CacheSystem.cacheObject(string3, link);
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
        return link;
    }

    public static Object readLinkDraft(int n, int n2) {
        return AvalonCache.readLinkDraft(n, n2, false);
    }

    public static Object readLinkDraft(int n, int n2, boolean bl) {
        String string = null;
        OAInterface oAInterface = null;
        String string2 = null;
        try {
            int n3 = PropertySystem.getInt(1);
            String string3 = "LINKDRAFT_" + n3 + "_" + n + ".avalon";
            boolean bl2 = false;
            oAInterface = (LinkDraft)CacheSystem.getCachedObject(string3);
            if (oAInterface == null) {
                switch (n2) {
                    case 0: {
                        oAInterface = (QuestLinkDraft)QuestLinkDraft.readFromDatabase(n, n3);
                        break;
                    }
                    case 1: {
                        oAInterface = (ExternalLinkDraft)ExternalLinkDraft.readFromDatabase(n, n3);
                        break;
                    }
                }
                bl2 = true;
            } else if (!bl) {
                string2 = AvalonCache.getDatabaseTimestamp("SELECT CHANGEDTIME FROM OA.LINK WHERE LINKIND = " + n);
                string = CacheSystem.getCacheTime(string3);
                if (CDate.compareDate(string, string2, 1) != 1) {
                    oAInterface = Link.readFromDatabase(n, n3);
                    bl2 = true;
                }
            }
            if (bl2) {
                CacheSystem.cacheObject(string3, oAInterface);
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
        return oAInterface;
    }

    public static Symptom readSymptom(int n) {
        return AvalonCache.readSymptom(n, false);
    }

    public static Symptom readSymptom(int n, boolean bl) {
        String string = null;
        Symptom symptom = null;
        String string2 = null;
        try {
            int n2 = PropertySystem.getInt(1);
            String string3 = "SYMPTOM_" + n2 + "_" + n + ".avalon";
            boolean bl2 = false;
            symptom = (Symptom)CacheSystem.getCachedObject(string3);
            if (symptom == null) {
                symptom = Symptom.readFromDatabase(n, n2);
                bl2 = true;
            } else if (!bl) {
                string2 = AvalonCache.getDatabaseTimestamp("SELECT CHANGEDTIME FROM OA.SYMPTOM WHERE SYMPTOMIND = " + n);
                string = CacheSystem.getCacheTime(string3);
                if (CDate.compareDate(string, string2, 1) != 1) {
                    symptom = Symptom.readFromDatabase(n, n2);
                    bl2 = true;
                }
            }
            if (bl2) {
                CacheSystem.cacheObject(string3, symptom);
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
        return symptom;
    }

    public static SymptomDraft readSymptomDraft(int n) {
        return AvalonCache.readSymptomDraft(n, false);
    }

    public static SymptomDraft readSymptomDraft(int n, boolean bl) {
        String string = null;
        SymptomDraft symptomDraft = null;
        String string2 = null;
        try {
            int n2 = PropertySystem.getInt(1);
            String string3 = "SYMPTOM_DRAFT_" + n2 + "_" + n + ".avalon";
            boolean bl2 = false;
            symptomDraft = (SymptomDraft)CacheSystem.getCachedObject(string3);
            if (symptomDraft == null) {
                symptomDraft = (SymptomDraft)SymptomDraft.readFromDatabase(n, n2);
                bl2 = true;
            } else if (!bl) {
                string2 = AvalonCache.getDatabaseTimestamp("SELECT CHANGEDTIME FROM OADRAFT.SYMPTOM WHERE SYMPTOMIND = " + n);
                string = CacheSystem.getCacheTime(string3);
                if (CDate.compareDate(string, string2, 1) != 1) {
                    symptomDraft = (SymptomDraft)SymptomDraft.readFromDatabase(n, n2);
                    bl2 = true;
                }
            }
            if (bl2) {
                CacheSystem.cacheObject(string3, symptomDraft);
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
        return symptomDraft;
    }

    public static Action readAction(int n) {
        return AvalonCache.readAction(n, false);
    }

    public static Action readAction(int n, boolean bl) {
        String string = null;
        Action action = null;
        String string2 = null;
        try {
            int n2 = PropertySystem.getInt(1);
            String string3 = "ACTION_" + n2 + "_" + n + ".avalon";
            boolean bl2 = false;
            action = (Action)CacheSystem.getCachedObject(string3);
            if (action == null) {
                action = Action.readFromDatabase(n, n2);
                bl2 = true;
            } else if (!bl) {
                string2 = AvalonCache.getDatabaseTimestamp("SELECT CHANGEDTIME FROM OA.ACTION WHERE ACTIONIND = " + n);
                string = CacheSystem.getCacheTime(string3);
                if (CDate.compareDate(string, string2, 1) != 1) {
                    action = Action.readFromDatabase(n, n2);
                    bl2 = true;
                }
            }
            if (bl2) {
                CacheSystem.cacheObject(string3, action);
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
        return action;
    }

    public static LinkGroupDraft readLinkGroupDraft(int n) {
        return AvalonCache.readLinkGroupDraft(n, false);
    }

    public static LinkGroupDraft readLinkGroupDraft(int n, boolean bl) {
        String string = null;
        LinkGroupDraft linkGroupDraft = null;
        String string2 = null;
        try {
            int n2 = PropertySystem.getInt(1);
            String string3 = "LINKGROUPDRAFT_" + n2 + "_" + n + ".avalon";
            boolean bl2 = false;
            linkGroupDraft = (LinkGroupDraft)CacheSystem.getCachedObject(string3);
            if (linkGroupDraft == null) {
                linkGroupDraft = (LinkGroupDraft)LinkGroupDraft.readFromDatabase(n, n2);
                bl2 = true;
            } else if (!bl) {
                string2 = AvalonCache.getDatabaseTimestamp("SELECT CHANGEDTIME FROM OADRAFT.LINKGROUP WHERE LINKGROUPIND = " + n);
                string = CacheSystem.getCacheTime(string3);
                if (CDate.compareDate(string, string2, 1) != 1) {
                    linkGroupDraft = (LinkGroupDraft)LinkGroupDraft.readFromDatabase(n, n2);
                    bl2 = true;
                }
            }
            if (bl2) {
                CacheSystem.cacheObject(string3, linkGroupDraft);
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
        return linkGroupDraft;
    }
}

