/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.avalon.editors;

import com.ibm.nzna.projects.common.quest.oa.Node;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.FontSystem;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.MainWindow;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.avalon.base.AvalonConst;
import com.ibm.nzna.projects.qit.avalon.editors.FlowNode;
import com.ibm.nzna.projects.qit.avalon.editors.ObjectNode;
import com.ibm.nzna.projects.qit.avalon.editors.VisioPanel;
import com.ibm.nzna.projects.qit.gui.AppDefaultWin;
import com.ibm.nzna.shared.gui.MultiListRow;
import com.ibm.nzna.shared.util.FontUtil;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.Text;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.MemoryImageSource;
import java.util.Vector;

public class ComponentNode
extends Component
implements Runnable,
FlowNode,
FocusListener,
AppConst,
AvalonConst,
MouseListener,
MouseMotionListener,
MultiListRow {
    private static final String THREAD_FIRE_ACTION_EVENT = "FIREACTION";
    private static final int RESIZE_SE = 1;
    private static final int RESIZE_NE = 2;
    private static final int RESIZE_E = 3;
    private static final int RESIZE_SW = 4;
    private static final int RESIZE_NW = 5;
    private static final int RESIZE_W = 6;
    private static final int RESIZE_N = 7;
    private static final int RESIZE_S = 8;
    private Node node = null;
    private Rectangle nodeBounds = null;
    private int width = 0;
    private int height = 0;
    private boolean sizeDrag = false;
    private int dragX = 0;
    private int dragY = 0;
    private int x = 0;
    private int y = 0;
    private int tailNodeTextY = 0;
    private int sizeDir = 0;
    private Rectangle oldBounds = new Rectangle(-1, -1, -1, -1);
    private String[] nodeDescriptionArray = null;
    private char[] nodeIndArray = null;
    private char[] draftArray = null;
    private FontUtil fontUtil = null;
    private Vector listeners = null;
    private boolean isDraft = false;
    private AppDefaultWin parentWin = null;
    private String nodeDescription = null;
    private FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(FontSystem.defaultFont);
    private int charWidth = this.fm.stringWidth("li");
    private boolean root = false;
    private ObjectNode objectNode = null;
    private VisioPanel visioPanel = null;
    private String nodeIndString = null;
    private Image focusImage = null;

    private void initialize() {
        this.fontUtil = GUISystem.getFontUtil();
        this.refreshProperties();
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.addFocusListener(this);
        this.draftArray = Str.getStr(1066).toCharArray();
    }

    public void paint(Graphics graphics) {
        int n = 15;
        int n2 = GUISystem.getRowHeight();
        int n3 = 5;
        graphics.setColor(this.getBackground());
        if (this.node != null) {
            switch (this.node.getNodeType()) {
                case 0: {
                    graphics.fillRoundRect(0, 0, this.width, this.height, 28, 28);
                    graphics.setColor(Color.yellow);
                    graphics.drawRoundRect(0, 0, this.width, this.height, 28, 28);
                    graphics.setColor(this.getForeground());
                    break;
                }
                case 2: {
                    Polygon polygon = new Polygon();
                    polygon.addPoint(this.width / 2, 0);
                    polygon.addPoint(this.width, this.height / 2);
                    polygon.addPoint(this.width / 2, this.height);
                    polygon.addPoint(0, this.height / 2);
                    polygon.addPoint(this.width / 2, 0);
                    graphics.fillPolygon(polygon);
                    graphics.setColor(Color.yellow);
                    graphics.drawPolygon(polygon);
                    graphics.setColor(this.getForeground().darker());
                    graphics.drawRect(0, 0, this.width - 1, this.height - 1);
                    graphics.setColor(this.getForeground());
                    n3 = this.width / 3;
                    break;
                }
                default: {
                    graphics.fillRect(0, 0, this.width, this.height);
                    if (this.focusImage == null) {
                        this.createFocusImage();
                    }
                    if (this.sizeDir == 0) {
                        graphics.drawImage(this.focusImage, 0, 0, this);
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else {
            graphics.fillRect(this.x, n, this.width, this.height);
            graphics.setColor(this.getForeground());
            graphics.drawRect(this.x, n, this.width, this.height);
        }
        graphics.setColor(this.getForeground());
        if (this.objectNode != null) {
            this.objectNode.paintText(graphics, 0, 0, this.width, this.height);
        }
    }

    public void setNode(Node node) {
        this.node = node;
        this.isDraft = node.getDraftObjectInd() != 0;
        this.nodeDescriptionArray = this.objectNode.getNodeDescriptionArray();
        this.nodeBounds = new Rectangle(node.getXPos(), node.getYPos(), node.getWidth(), node.getHeight());
        this.setBounds(this.nodeBounds);
        this.nodeIndArray = this.isDraft() ? new String("" + node.getDraftObjectInd()).toCharArray() : new String("" + node.getActiveObjectInd()).toCharArray();
        this.refreshProperties();
    }

    protected Rectangle getNodeBounds() {
        this.nodeBounds.x = this.node.getXPos();
        this.nodeBounds.y = this.node.getYPos();
        this.nodeBounds.width = this.node.getWidth();
        this.nodeBounds.height = this.node.getHeight();
        return this.nodeBounds;
    }

    public void setSize(int n, int n2) {
        if (n > 25 && n2 > 25) {
            boolean bl = false;
            boolean bl2 = false;
            this.oldBounds.width = n;
            this.oldBounds.height = n2;
            this.width = n;
            this.height = n2;
            if (this.node.valid()) {
                this.node.setGuiData(this.x, this.y, n, n2, this.node.getZOrder());
            }
            bl = this.oldBounds.width != n;
            boolean bl3 = bl2 = this.oldBounds.height != n2;
            if (bl || bl2) {
                this.setNodeDescription(this.nodeDescription);
            }
            super.setSize(n, n2);
        }
    }

    public void setSize(Dimension dimension) {
        if (dimension.width > 25 && dimension.height > 25) {
            boolean bl = false;
            boolean bl2 = false;
            this.oldBounds.width = dimension.width;
            this.oldBounds.height = dimension.height;
            this.width = dimension.width;
            this.height = dimension.height;
            if (this.node.valid()) {
                this.node.setGuiData(this.x, this.y, this.width, this.height, this.node.getZOrder());
            }
            bl = this.oldBounds.width != this.width;
            boolean bl3 = bl2 = this.oldBounds.height != this.height;
            if (bl || bl2) {
                this.setNodeDescription(this.nodeDescription);
            }
            super.setSize(dimension);
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (n >= 0 && n2 >= 0 && n3 > 25 && n4 > 25) {
            boolean bl = false;
            boolean bl2 = false;
            this.oldBounds.x = this.oldBounds.x == -1 ? n : this.x;
            this.oldBounds.y = this.oldBounds.y == -1 ? n2 : this.y;
            this.oldBounds.width = this.width;
            this.oldBounds.height = this.height;
            this.width = n3;
            this.height = n4;
            this.y = n2;
            this.x = n;
            bl = this.oldBounds.width != this.width;
            boolean bl3 = bl2 = this.oldBounds.height != this.height;
            if (this.objectNode != null) {
                this.objectNode.setBounds(n, n2, this.width, this.height);
            }
            if (bl || bl2) {
                this.setNodeDescription(this.nodeDescription);
            }
            super.setBounds(n, n2, n3, n4);
        }
        if (this.visioPanel != null) {
            this.visioPanel.revalidate();
            this.visioPanel.ensureVisible(this.getBounds());
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.drag(mouseEvent.getX(), mouseEvent.getY(), this.dragX, this.dragY);
    }

    public void drag(int n, int n2, int n3, int n4) {
        this.sizeDrag = true;
        this.dragX = n3;
        this.dragY = n4;
        if (this.sizeDir == 0) {
            this.setLocation((n += this.x) - n3, (n2 += this.y) - n4);
        } else {
            switch (this.sizeDir) {
                case 8: {
                    this.setBounds(this.x, this.y, this.width, n2 + 3);
                    break;
                }
                case 3: {
                    this.setBounds(this.x, this.y, n + 3, this.height);
                    break;
                }
                case 1: {
                    this.setBounds(this.x, this.y, n + 3, n2 + 3);
                    break;
                }
                case 7: {
                    this.setBounds(this.x, this.y + n2, this.width, this.height - n2);
                    break;
                }
                case 6: {
                    this.setBounds(this.x + n, this.y, this.width - n, this.height);
                    break;
                }
                case 5: {
                    this.setBounds(this.x + n, this.y + n2, this.width - n, this.height - n2);
                    break;
                }
                case 2: {
                    this.setBounds(this.x, this.y + n2, n + 3, this.height - n2);
                    break;
                }
                case 4: {
                    this.setBounds(this.x + n, this.y, this.width - n, n2 + 3);
                    break;
                }
            }
        }
    }

    public void setLocation(int n, int n2) {
        if (n >= 0 && n2 >= 0) {
            this.oldBounds.x = this.oldBounds.x == -1 ? n : this.x;
            this.oldBounds.y = this.oldBounds.y == -1 ? n2 : this.y;
            this.x = n;
            this.y = n2;
            if (this.objectNode != null) {
                this.objectNode.setLocation(n, n2);
            }
            this.node.updateRecStatus(1);
            super.setLocation(n, n2);
        }
        if (this.visioPanel != null) {
            this.visioPanel.revalidate();
            this.visioPanel.ensureVisible(this.getBounds());
        }
    }

    public void setLocation(Point point) {
        if (this.x >= 0 && this.y >= 0) {
            this.oldBounds.x = this.oldBounds.x == -1 ? point.x : this.x;
            this.oldBounds.y = this.oldBounds.y == -1 ? point.y : this.y;
            this.x = point.x;
            this.y = point.y;
            if (this.objectNode != null) {
                this.objectNode.setLocation(this.x, this.y);
            }
            super.setLocation(point);
        }
        if (this.visioPanel != null) {
            this.visioPanel.revalidate();
            this.visioPanel.ensureVisible(this.getBounds());
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (n < 5 && n2 < 5) {
            this.setCursor(Cursor.getPredefinedCursor(6));
            this.sizeDir = 5;
        } else if (n < 5 && n2 > this.height - 5) {
            this.setCursor(Cursor.getPredefinedCursor(4));
            this.sizeDir = 4;
        } else if (n > this.width - 5 && n2 < 5) {
            this.setCursor(Cursor.getPredefinedCursor(7));
            this.sizeDir = 2;
        } else if (n > this.width - 5 && n2 > this.height - 5) {
            this.setCursor(Cursor.getPredefinedCursor(5));
            this.sizeDir = 1;
        } else if (n < 5) {
            this.setCursor(Cursor.getPredefinedCursor(10));
            this.sizeDir = 6;
        } else if (n2 < 5) {
            this.setCursor(Cursor.getPredefinedCursor(8));
            this.sizeDir = 7;
        } else if (n2 > this.height - 5) {
            this.setCursor(Cursor.getPredefinedCursor(9));
            this.sizeDir = 8;
        } else if (n > this.width - 5) {
            this.setCursor(Cursor.getPredefinedCursor(11));
            this.sizeDir = 3;
        } else {
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.sizeDir = 0;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.sizeDrag = false;
        this.sizeDir = 0;
        this.setBounds(this.x, this.y, this.width, this.height);
        if (this.focusImage != null) {
            this.focusImage.flush();
            this.focusImage = null;
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.sizeDrag = true;
        this.requestFocus();
        this.dragX = mouseEvent.getX();
        this.dragY = mouseEvent.getY();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 1) {
            new Thread((Runnable)this, THREAD_FIRE_ACTION_EVENT).start();
        }
        this.sizeDrag = false;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
        this.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.repaint();
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public Node getNode() {
        return this.node;
    }

    public String getTitle() {
        if (this.nodeDescription == null) {
            if (this.objectNode != null) {
                this.setNodeDescription(this.objectNode.getTitle());
            } else {
                this.setNodeDescription("????");
            }
        }
        return this.nodeDescription;
    }

    public boolean isDraft() {
        return this.isDraft;
    }

    public void run() {
        String string = Thread.currentThread().getName();
        if (string.equals(THREAD_FIRE_ACTION_EVENT)) {
            this.objectNode.fireActionEvent();
        }
    }

    public void addActionListener(ActionListener actionListener) {
        if (this.listeners == null) {
            this.listeners = new Vector(1);
        }
        this.listeners.addElement(actionListener);
    }

    public Object getDraftObject() {
        return this.objectNode.getDraftObject();
    }

    public Object getObject() {
        if (this.objectNode != null) {
            return this.objectNode.getObject();
        }
        return null;
    }

    public String toString() {
        return this.getTitle();
    }

    protected void refreshProperties() {
        try {
            this.setBackground((Color)PropertySystem.get(124));
            this.setForeground((Color)PropertySystem.get(131));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setNodeDescription(String string) {
        try {
            int n = PropertySystem.getInt(122);
            if (string.length() > n) {
                string = string.substring(0, n);
                string = string + "...";
            }
            this.nodeDescription = string;
            if (this.width > 0) {
                this.nodeDescriptionArray = Text.formatStringLines(string, this.width / this.charWidth);
                if (this.objectNode != null) {
                    this.objectNode.setNodeDescriptionArray(this.nodeDescriptionArray);
                }
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
        }
    }

    private void setStatus(String string) {
        if (this.parentWin == null) {
            this.parentWin = GUISystem.getParentDefWin(this);
        }
        if (this.parentWin == null) {
            this.parentWin = MainWindow.getInstance();
        }
        if (this.parentWin != null) {
            this.parentWin.setStatus(string);
        }
    }

    public Vector getCountryList() {
        return this.objectNode.getCountryList();
    }

    public int getDocClass() {
        return this.objectNode.getDocClass();
    }

    protected void setRoot(boolean bl) {
        this.root = bl;
    }

    protected boolean getRoot() {
        return this.root;
    }

    public Object getColumnData(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = "" + this.node.getInd();
                break;
            }
            case 1: {
                string = this.nodeDescription;
                break;
            }
        }
        return string;
    }

    public void setTailNodeTextY(int n) {
        this.tailNodeTextY = n;
    }

    public int getTailNodeTextY() {
        return this.tailNodeTextY;
    }

    protected ObjectNode getObjectNode() {
        return this.objectNode;
    }

    protected void setObjectNode(ObjectNode objectNode) {
        if (this.objectNode != null) {
            this.objectNode.setPaint(true);
        }
        this.nodeDescriptionArray = objectNode.getNodeDescriptionArray();
        this.objectNode = objectNode;
        this.root = objectNode.getRoot();
        this.focusImage = null;
        this.nodeDescription = objectNode.getTitle();
        this.oldBounds.x = -1;
        this.oldBounds.y = -1;
        objectNode.setPaint(false);
        objectNode.setComponentNode(this);
        this.setNode(objectNode.getNode());
    }

    protected void setVisioPanel(VisioPanel visioPanel) {
        this.visioPanel = visioPanel;
    }

    private void createFocusImage() {
        Dimension dimension = this.getSize();
        if (dimension.height >= 0) {
            int n = 0;
            MemoryImageSource memoryImageSource = null;
            int[] nArray = new int[dimension.width * dimension.height];
            int n2 = -100;
            while (n < dimension.width) {
                nArray[n] = n2;
                nArray[n + dimension.width * (dimension.height - 1)] = n2;
                n += 2;
            }
            n = 0;
            while (n < dimension.height * (dimension.width - 1)) {
                nArray[n] = n2;
                nArray[n + dimension.width - 1] = n2;
                n += dimension.width * 2;
            }
            memoryImageSource = new MemoryImageSource(dimension.width, dimension.height, nArray, 0, dimension.width);
            this.focusImage = this.createImage(memoryImageSource);
        }
    }

    public boolean getSizeDrag() {
        return this.sizeDrag;
    }

    public ComponentNode(Node node) {
        this.setNode(node);
        this.initialize();
    }

    public ComponentNode(ObjectNode objectNode) {
        this.setObjectNode(objectNode);
        this.initialize();
    }
}

