/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.avalon.editors;

import com.ibm.nzna.projects.common.quest.oa.Action;
import com.ibm.nzna.projects.common.quest.oa.ActionDraft;
import com.ibm.nzna.projects.common.quest.oa.Edge;
import com.ibm.nzna.projects.common.quest.oa.EdgeGroup;
import com.ibm.nzna.projects.common.quest.oa.Node;
import com.ibm.nzna.projects.common.quest.oa.OAObject;
import com.ibm.nzna.projects.common.quest.oa.Question;
import com.ibm.nzna.projects.common.quest.oa.QuestionDraft;
import com.ibm.nzna.projects.common.quest.oa.Symptom;
import com.ibm.nzna.projects.common.quest.oa.SymptomDraft;
import com.ibm.nzna.projects.common.quest.oa.SymptomTitle;
import com.ibm.nzna.projects.common.quest.type.TypeCountryCodeRec;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.WindowSystem;
import com.ibm.nzna.projects.qit.app.util.QuestUtil;
import com.ibm.nzna.projects.qit.avalon.base.ActionDisplayRec;
import com.ibm.nzna.projects.qit.avalon.base.ActionDraftDisplayRec;
import com.ibm.nzna.projects.qit.avalon.base.AvalonConst;
import com.ibm.nzna.projects.qit.avalon.base.AvalonUtil;
import com.ibm.nzna.projects.qit.avalon.base.QuestionDisplayRec;
import com.ibm.nzna.projects.qit.avalon.base.QuestionDraftDisplayRec;
import com.ibm.nzna.projects.qit.avalon.base.SymptomDisplayRec;
import com.ibm.nzna.projects.qit.avalon.base.SymptomDraftDisplayRec;
import com.ibm.nzna.projects.qit.avalon.cache.AvalonCache;
import com.ibm.nzna.projects.qit.avalon.editors.ActionEditorPanel;
import com.ibm.nzna.projects.qit.avalon.editors.ActionNodePanel;
import com.ibm.nzna.projects.qit.avalon.editors.DraftEditPanel;
import com.ibm.nzna.projects.qit.avalon.editors.FlowEditorFilter;
import com.ibm.nzna.projects.qit.avalon.editors.OAEditorPanel;
import com.ibm.nzna.projects.qit.avalon.editors.OASaveListener;
import com.ibm.nzna.projects.qit.avalon.editors.ObjectNode;
import com.ibm.nzna.projects.qit.avalon.editors.QuestionEditorPanel;
import com.ibm.nzna.projects.qit.avalon.editors.QuestionNodePanel;
import com.ibm.nzna.projects.qit.avalon.editors.SymptomEditorPanel;
import com.ibm.nzna.projects.qit.avalon.editors.SymptomNodePanel;
import com.ibm.nzna.projects.qit.avalon.editors.VisioListener;
import com.ibm.nzna.projects.qit.avalon.editors.VisioPanel;
import com.ibm.nzna.projects.qit.avalon.gui.CreateObjectDlg;
import com.ibm.nzna.projects.qit.avalon.gui.SelectOADlg;
import com.ibm.nzna.projects.qit.avalon.gui.SelectOAListener;
import com.ibm.nzna.projects.qit.avalon.sql.OASQL;
import com.ibm.nzna.projects.qit.gui.JTitle;
import com.ibm.nzna.projects.qit.gui.QuestPanel;
import com.ibm.nzna.shared.gui.ButtonPanel;
import com.ibm.nzna.shared.gui.HotLinkLabel;
import com.ibm.nzna.shared.gui.ToolBarSeparator;
import com.ibm.nzna.shared.util.LogSystem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;

public class FlowEditPanel
extends JPanel
implements OASaveListener,
Runnable,
VisioListener,
AvalonConst,
SelectOAListener,
AppConst,
ActionListener {
    private static final String THREAD_PROCESS_NODE_FOCUS_RECEIVED = "TPNFR";
    private JScrollPane dataScrollPanel = null;
    private JTitle st_TITLE = null;
    private VisioPanel visioPanel = null;
    private JMenuItem mnu_ADD_ACTION = null;
    private JMenuItem mnu_ADD_QUESTION = null;
    private JMenuItem mnu_ADD_SYMPTOM = null;
    private JMenuItem mnu_ADD_RESOLVED = null;
    private JMenuItem mnu_ADD_UNRESOLVED = null;
    private JMenuItem mnu_ADD_ACTION_LIST = null;
    private JMenuItem mnu_ADD_RETURN = null;
    private JMenuItem mnu_SET_ROOT = null;
    private HotLinkLabel pb_ACTIONS = null;
    private HotLinkLabel pb_REMOVE = null;
    private HotLinkLabel pb_ADD = null;
    private ButtonPanel buttonPanel = null;
    private ButtonPanel nodeOutputPanel = null;
    private ButtonPanel edgePanel = null;
    private JLabel st_NODES = null;
    private JLabel stt_NODES = null;
    private JLabel st_EDGES = null;
    private JLabel stt_EDGES = null;
    private SymptomEditorPanel questPanel = null;
    private JScrollPane nodeScrollPanel = null;
    private JPanel nodePanel = null;
    private QuestionNodePanel questionNodePanel = null;
    private ActionNodePanel actionNodePanel = null;
    private SymptomNodePanel symptomNodePanel = null;
    private JPopupMenu popupMenu = null;
    private SymptomDraft symptom = null;
    private ObjectNode focusNode = null;
    private DraftEditPanel draftPanel = null;

    private void initialize() {
        Color color = new Color(128, 0, 128);
        this.visioPanel = new VisioPanel();
        this.dataScrollPanel = new JScrollPane(this.visioPanel);
        this.st_TITLE = new JTitle();
        this.pb_ADD = new HotLinkLabel(Str.getStr(95));
        this.pb_REMOVE = new HotLinkLabel(Str.getStr(96));
        this.pb_ACTIONS = new HotLinkLabel(Str.getStr(862));
        this.buttonPanel = new ButtonPanel();
        this.nodeOutputPanel = new ButtonPanel();
        this.edgePanel = new ButtonPanel();
        this.st_EDGES = new JLabel(Str.getStr(943) + ":");
        this.st_NODES = new JLabel(Str.getStr(942) + ":");
        this.stt_EDGES = new JLabel("0");
        this.stt_NODES = new JLabel("0");
        this.actionNodePanel = new ActionNodePanel();
        this.setNodePanel(null, false);
        this.dataScrollPanel.getViewport().putClientProperty("EnableWindowBlit", Boolean.TRUE);
        this.setBackground(Color.white);
        this.st_EDGES.setOpaque(false);
        this.st_NODES.setOpaque(false);
        this.stt_NODES.setOpaque(false);
        this.stt_EDGES.setOpaque(false);
        this.st_EDGES.setForeground(color);
        this.st_NODES.setForeground(color);
        this.buttonPanel.setBackground(new Color(250, 250, 250));
        this.nodeOutputPanel.setBackground(Color.white);
        this.edgePanel.setBackground(Color.white);
        this.buttonPanel.setBorder(GUISystem.grayBorder);
        this.buttonPanel.setBackground(new Color(230, 230, 230));
        this.buttonPanel.setArrowImage(ImageSystem.getImageIcon((Object)this, 146), ImageSystem.getImageIcon((Object)this, 147));
        this.edgePanel.setArrowImage(ImageSystem.getImageIcon((Object)this, 146), ImageSystem.getImageIcon((Object)this, 147));
        this.nodeOutputPanel.setArrowImage(ImageSystem.getImageIcon((Object)this, 146), ImageSystem.getImageIcon((Object)this, 147));
        this.pb_ADD.addActionListener(this);
        this.pb_REMOVE.addActionListener(this);
        this.pb_ACTIONS.addActionListener(this);
        this.visioPanel.addVisioListener(this);
        this.buttonPanel.add(this.pb_ADD);
        this.buttonPanel.add(new ToolBarSeparator(new Dimension(1, GUISystem.getRowHeight())));
        this.buttonPanel.add(this.pb_REMOVE);
        this.buttonPanel.add(new ToolBarSeparator(new Dimension(1, GUISystem.getRowHeight())));
        this.buttonPanel.add(this.pb_ACTIONS);
        this.buttonPanel.add(new ToolBarSeparator(new Dimension(1, GUISystem.getRowHeight())));
        this.setLayout(null);
        this.add(this.buttonPanel);
        this.add(this.nodeOutputPanel);
        this.add(this.edgePanel);
        this.add(this.st_TITLE);
        this.nodeOutputPanel.add(this.st_NODES);
        this.nodeOutputPanel.add(this.stt_NODES);
        this.edgePanel.add(this.st_EDGES);
        this.edgePanel.add(this.stt_EDGES);
        this.setDataPanel(this.visioPanel, false);
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        int n = GUISystem.getRowHeight();
        int n2 = 5;
        int n3 = 15;
        super.doLayout();
        this.buttonPanel.setBounds(n3, n2, dimension.width - n3 * 2, n);
        this.dataScrollPanel.setBounds(n3 + 205, n2 += n + 5, dimension.width - n3 * 2 - 205, dimension.height - n2 - n);
        if (this.nodeScrollPanel != null) {
            this.nodeScrollPanel.setBounds(n3, n2, 200, dimension.height - n2 - n);
        }
        this.nodeOutputPanel.setBounds(n3 + 205, dimension.height - n, 100, n);
        this.edgePanel.setBounds(n3 + 315, dimension.height - n, 100, n);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.pb_ADD) {
            this.popupAddActions();
        } else if (actionEvent.getSource() == this.mnu_SET_ROOT) {
            this.setRoot(this.focusNode);
        } else if (actionEvent.getSource() == this.pb_ACTIONS) {
            this.popupActions();
        } else if (actionEvent.getSource() == this.mnu_ADD_QUESTION) {
            this.addQuestion();
        } else if (actionEvent.getSource() == this.mnu_ADD_ACTION) {
            this.addAction();
        } else if (actionEvent.getSource() == this.mnu_ADD_SYMPTOM) {
            this.addSymptom();
        } else if (actionEvent.getSource() == this.mnu_ADD_ACTION_LIST) {
            this.addNode(null, new Node(6), false);
        } else if (actionEvent.getSource() == this.mnu_ADD_RESOLVED) {
            this.addNode(null, new Node(3), false);
        } else if (actionEvent.getSource() == this.mnu_ADD_UNRESOLVED) {
            this.addNode(null, new Node(4), false);
        } else if (actionEvent.getSource() == this.mnu_ADD_RETURN) {
            this.addNode(null, new Node(5), false);
        } else if (actionEvent.getSource() == this.pb_REMOVE) {
            this.removeNode(this.focusNode);
        } else if (actionEvent.getSource() instanceof ObjectNode) {
            boolean bl = true;
            if (this.questPanel.getFullScreen() && (bl = GUISystem.printBox((Frame)GUISystem.getParentDefWin(this), Str.getStr(8), Str.getStr(1356)))) {
                this.questPanel.closeFullScreen();
            }
            if (bl) {
                if (((ObjectNode)actionEvent.getSource()).getDraftObject() != null) {
                    this.edit(((ObjectNode)actionEvent.getSource()).getDraftObject());
                } else {
                    this.edit(((ObjectNode)actionEvent.getSource()).getObject());
                }
            }
        }
    }

    public ObjectNode addNode(OAObject oAObject, Node node, boolean bl) {
        ObjectNode objectNode = null;
        boolean bl2 = true;
        if (oAObject != null && bl) {
            FlowEditorFilter flowEditorFilter = (FlowEditorFilter)PropertySystem.get(127);
            boolean bl3 = false;
            boolean bl4 = bl3 = flowEditorFilter.showCountry(oAObject.getCountryList()) && flowEditorFilter.showDocClass(oAObject.getDocClass().getInd());
            if (!bl3) {
                bl2 = GUISystem.printBox(8, 1332);
            }
        }
        if (bl2) {
            objectNode = this.visioPanel.addNode(node);
            objectNode.addActionListener(this);
            if (oAObject instanceof Question || oAObject instanceof Action || oAObject instanceof Symptom) {
                objectNode.setOAObject(oAObject);
            }
            if (oAObject instanceof Question && this.symptom.getRootNode() == null && GUISystem.printBox(Str.getStr(8), Str.getStr(1393))) {
                this.symptom.setRootNode(node);
                objectNode.setRoot(true);
            }
            this.refreshData();
            this.invalidate();
            this.repaint();
        }
        return objectNode;
    }

    public void addNodes(Vector vector) {
        Vector vector2 = null;
        vector2 = this.visioPanel.addNodes(vector);
        if (vector2 != null) {
            int n = 0;
            int n2 = vector2.size();
            ObjectNode objectNode = null;
            while (n < n2) {
                objectNode = (ObjectNode)vector2.elementAt(n);
                objectNode.addActionListener(this);
                ++n;
            }
        }
        this.refreshData();
        this.invalidate();
        this.repaint();
    }

    public boolean getPaintGrid() {
        return this.visioPanel.getPaintGrid();
    }

    public void setPaintGrid(boolean bl) {
        this.visioPanel.setPaintGrid(bl);
    }

    public void refreshData() {
        this.refreshCounters();
    }

    private void addQuestion() {
        CreateObjectDlg createObjectDlg = new CreateObjectDlg(GUISystem.getParentDefWin(this));
        int n = createObjectDlg.getResult();
        switch (n) {
            case 1: {
                QuestionEditorPanel questionEditorPanel = new QuestionEditorPanel(this.questPanel);
                questionEditorPanel.addOASaveListener(this);
                WindowSystem.createPanel(questionEditorPanel);
                break;
            }
            case 3: {
                SelectOADlg selectOADlg = new SelectOADlg();
                selectOADlg.getInstance().setView(3);
                selectOADlg.getInstance().addSelectOAListener(this);
                break;
            }
            case 2: {
                Question question = AvalonCache.readQuestion(createObjectDlg.getExistingInd());
                Node node = new Node(question);
                if (question == null) break;
                this.addNode(question, new Node(question), true);
                break;
            }
        }
    }

    private void addAction() {
        CreateObjectDlg createObjectDlg = new CreateObjectDlg(GUISystem.getParentDefWin(this));
        int n = createObjectDlg.getResult();
        switch (n) {
            case 1: {
                ActionEditorPanel actionEditorPanel = new ActionEditorPanel(this.questPanel);
                actionEditorPanel.addOASaveListener(this);
                WindowSystem.createPanel(actionEditorPanel);
                break;
            }
            case 3: {
                SelectOADlg selectOADlg = new SelectOADlg();
                selectOADlg.getInstance().setView(0);
                selectOADlg.getInstance().addSelectOAListener(this);
                break;
            }
            case 2: {
                Action action = AvalonCache.readAction(createObjectDlg.getExistingInd());
                if (action == null) break;
                this.addNode(action, new Node(action), true);
                break;
            }
        }
    }

    private void addSymptom() {
        CreateObjectDlg createObjectDlg = new CreateObjectDlg(GUISystem.getParentDefWin(this));
        int n = createObjectDlg.getResult();
        switch (n) {
            case 1: {
                SymptomEditorPanel symptomEditorPanel = new SymptomEditorPanel(this.questPanel);
                symptomEditorPanel.addOASaveListener(this);
                WindowSystem.createPanel(symptomEditorPanel);
                break;
            }
            case 3: {
                SelectOADlg selectOADlg = new SelectOADlg();
                selectOADlg.getInstance().setView(4);
                selectOADlg.getInstance().addSelectOAListener(this);
                break;
            }
            case 2: {
                Symptom symptom = AvalonCache.readSymptom(createObjectDlg.getExistingInd());
                if (symptom == null) break;
                this.addNode(symptom, new Node(symptom), true);
                break;
            }
        }
    }

    public void selectOAComplete(Vector vector) {
        if (vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            Vector<ObjectNode> vector2 = new Vector<ObjectNode>(n2);
            while (n < n2) {
                OAObject oAObject;
                if (vector.elementAt(n) instanceof QuestionDisplayRec) {
                    oAObject = AvalonCache.readQuestion(((QuestionDisplayRec)vector.elementAt(n)).getQuestionInd());
                    vector2.addElement(this.addNode(oAObject, new Node(oAObject), true));
                } else if (vector.elementAt(n) instanceof QuestionDraftDisplayRec) {
                    oAObject = AvalonCache.readQuestionDraft(((QuestionDraftDisplayRec)vector.elementAt(n)).getQuestionInd());
                    vector2.addElement(this.addNode(oAObject, new Node(oAObject), true));
                } else if (vector.elementAt(n) instanceof ActionDisplayRec) {
                    oAObject = AvalonCache.readAction(((ActionDisplayRec)vector.elementAt(n)).getActionInd());
                    vector2.addElement(this.addNode(oAObject, new Node(oAObject), true));
                } else if (vector.elementAt(n) instanceof ActionDraftDisplayRec) {
                    oAObject = AvalonCache.readActionDraft(((ActionDraftDisplayRec)vector.elementAt(n)).getActionInd());
                    vector2.addElement(this.addNode(oAObject, new Node(oAObject), true));
                } else if (vector.elementAt(n) instanceof SymptomDisplayRec) {
                    oAObject = AvalonCache.readSymptom(((SymptomDisplayRec)vector.elementAt(n)).getSymptomInd());
                    vector2.addElement(this.addNode(oAObject, new Node(oAObject), true));
                } else if (vector.elementAt(n) instanceof SymptomDraftDisplayRec) {
                    oAObject = AvalonCache.readSymptomDraft(((SymptomDraftDisplayRec)vector.elementAt(n)).getSymptomInd());
                    vector2.addElement(this.addNode(oAObject, new Node(oAObject), true));
                }
                ++n;
            }
            this.cascadeObjectNodes(vector2);
        }
    }

    public void removeAll() {
        this.visioPanel.removeAll();
        this.refreshData();
    }

    public void setSymptom(SymptomDraft symptomDraft) {
        this.symptom = symptomDraft;
        symptomDraft.assignDatabaseKeys();
        this.visioPanel.removeAll();
        this.visioPanel.setSymptom(symptomDraft);
        this.addActionListenerToObjectNodes(this.visioPanel.getObjectNodes());
    }

    private String getDefaultTitle() {
        String string = "";
        if (this.symptom != null) {
            Vector vector = this.symptom.getSymptomTitles();
            string = ((SymptomTitle)vector.elementAt(vector.size() - 1)).getTitle();
        }
        return string;
    }

    private void setNodePanel(JComponent jComponent, boolean bl) {
        if (this.nodeScrollPanel != null) {
            this.remove(this.nodeScrollPanel);
            this.nodeScrollPanel = null;
        }
        this.nodeScrollPanel = jComponent != null ? new JScrollPane(jComponent) : new JScrollPane();
        this.nodeScrollPanel.setBorder(GUISystem.blackBorder);
        this.add(this.nodeScrollPanel);
        if (bl) {
            this.revalidate();
        }
    }

    protected void setDataPanel(Component component, boolean bl) {
        if (this.dataScrollPanel != null) {
            this.remove(this.dataScrollPanel);
            this.dataScrollPanel = null;
        }
        this.dataScrollPanel = component != null ? new JScrollPane(component) : new JScrollPane();
        this.dataScrollPanel.setBorder(GUISystem.blackBorder);
        this.dataScrollPanel.setOpaque(false);
        this.add(this.dataScrollPanel);
        if (bl) {
            this.revalidate();
        }
        this.pb_ADD.setEnabled(component == this.visioPanel);
        this.pb_REMOVE.setEnabled(component == this.visioPanel);
        this.pb_ACTIONS.setEnabled(component == this.visioPanel);
        if (this.getParent() != null) {
            this.getParent().setEnabled(component == this.visioPanel);
        }
    }

    public void nodeFocusReceived(ObjectNode objectNode) {
        if (objectNode != this.focusNode) {
            this.focusNode = objectNode;
            new Thread((Runnable)this, THREAD_PROCESS_NODE_FOCUS_RECEIVED).start();
        }
    }

    private void processNodeFocusReceived() {
        switch (this.focusNode.getNode().getNodeType()) {
            case 1: {
                if (this.questionNodePanel == null) {
                    this.questionNodePanel = new QuestionNodePanel(this, this.visioPanel, this.symptom);
                }
                this.questionNodePanel.setNode(this.focusNode);
                this.setNodePanel(this.questionNodePanel, true);
                this.questionNodePanel.refresh();
                break;
            }
            case 0: {
                this.actionNodePanel.setNode(this.focusNode);
                this.setNodePanel(this.actionNodePanel, true);
                this.actionNodePanel.refresh();
                break;
            }
            case 2: {
                if (this.symptomNodePanel == null) {
                    this.symptomNodePanel = new SymptomNodePanel(this, this.focusNode, this.symptom);
                }
                this.setNodePanel(this.symptomNodePanel, true);
                this.symptomNodePanel.refresh();
                break;
            }
            default: {
                this.setNodePanel(null, true);
                break;
            }
        }
    }

    protected Vector getNodes() {
        return this.visioPanel.getNodes();
    }

    protected Vector getObjectNodes() {
        return (Vector)this.visioPanel.getObjectNodes().clone();
    }

    public void saveComplete(OAEditorPanel oAEditorPanel, Object object, boolean bl) {
        this.addNode((OAObject)object, new Node((OAObject)object), true);
    }

    public Vector getNodesFromActiveInd(int n, int n2) {
        Vector<ObjectNode> vector = new Vector<ObjectNode>(1);
        Vector vector2 = this.visioPanel.getObjectNodes();
        if (vector2 != null && vector2.size() > 0) {
            int n3 = 0;
            int n4 = vector2.size();
            Node node = null;
            ObjectNode objectNode = null;
            short s = 0;
            while (n3 < n4) {
                objectNode = (ObjectNode)vector2.elementAt(n3);
                node = objectNode.getNode();
                s = node.getNodeType();
                if (s == 1 || s == 0 || s == 2) {
                    switch (n) {
                        case 1: {
                            if (node.getActiveObjectInd() != n2) break;
                            vector.addElement(objectNode);
                            break;
                        }
                        case 3: {
                            if (node.getActiveObjectInd() != n2) break;
                            vector.addElement(objectNode);
                            break;
                        }
                        case 2: {
                            if (node.getActiveObjectInd() != n2) break;
                            vector.addElement(objectNode);
                            break;
                        }
                    }
                }
                ++n3;
            }
        }
        return vector;
    }

    public Vector getNodesFromDraftInd(int n, int n2) {
        Vector<ObjectNode> vector = new Vector<ObjectNode>(1);
        Vector vector2 = this.visioPanel.getObjectNodes();
        if (vector2 != null && vector2.size() > 0) {
            int n3 = 0;
            int n4 = vector2.size();
            Node node = null;
            ObjectNode objectNode = null;
            short s = 0;
            while (n3 < n4) {
                objectNode = (ObjectNode)vector2.elementAt(n3);
                node = objectNode.getNode();
                s = node.getNodeType();
                if (s == 1 || s == 0 || s == 2) {
                    switch (n) {
                        case 7: {
                            if (node.getDraftObjectInd() != n2) break;
                            vector.addElement(objectNode);
                            break;
                        }
                        case 9: {
                            if (node.getDraftObjectInd() != n2) break;
                            vector.addElement(objectNode);
                            break;
                        }
                        case 8: {
                            if (node.getDraftObjectInd() != n2) break;
                            vector.addElement(objectNode);
                            break;
                        }
                    }
                }
                ++n3;
            }
        }
        return vector;
    }

    public boolean getPaintTitles() {
        return this.visioPanel.getPaintTitles();
    }

    public void setPaintTitles(boolean bl) {
        this.visioPanel.setPaintTitles(bl);
    }

    public void setDefaultDataPanel() {
        this.setDataPanel(this.visioPanel, true);
    }

    public void printToPrinter(PrintJob printJob) {
        this.visioPanel.printToPrinter(printJob);
    }

    private void removeNode(ObjectNode objectNode) {
        if (this.symptom.getRootNode() != objectNode.getNode()) {
            objectNode.getNode().updateRecStatus(3);
            this.removeEdgeGroups(AvalonUtil.getHeadEdgeGroups(objectNode.getNode(), this.symptom));
            this.removeEdgeGroups(AvalonUtil.getTailEdgeGroups(objectNode.getNode(), this.symptom));
            this.visioPanel.remove(objectNode);
            objectNode.setPaint(false);
            this.refreshCounters();
            this.invalidate();
            this.repaint();
        } else {
            GUISystem.printBox((Frame)GUISystem.getParentDefWin(this), 7, 1358);
        }
    }

    private void removeEdgeGroups(Vector vector) {
        if (vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                ((EdgeGroup)vector.elementAt(n)).updateRecStatus(3);
                ++n;
            }
        }
    }

    protected void refreshCounters() {
        this.stt_EDGES.setText("" + this.visioPanel.getEdgeGroupCount());
        this.stt_NODES.setText("" + this.visioPanel.getNodeCount());
        this.st_TITLE.setText(this.getDefaultTitle());
    }

    private void edit(Object object) {
        try {
            if (object instanceof QuestionDraft || object instanceof Question) {
                this.editQuestion(object);
            } else if (object instanceof ActionDraft || object instanceof Action) {
                this.editAction(object);
            } else if (object instanceof Symptom || object instanceof SymptomDraft) {
                this.editSymptom(object);
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
        }
    }

    private void editQuestion(Object object) {
        try {
            if (object instanceof QuestionDraft) {
                QuestionEditorPanel questionEditorPanel = new QuestionEditorPanel((QuestPanel)this.questPanel, ((QuestionDraft)object).getInd());
                questionEditorPanel.addOASaveListener(this.focusNode);
                WindowSystem.createPanel(questionEditorPanel);
            } else if (object instanceof Question) {
                QuestionDraft questionDraft = null;
                int n = ((Question)object).getInd();
                questionDraft = OASQL.getQuestionDraft(GUISystem.getParentDefWin(this), n, 2);
                if (questionDraft != null) {
                    QuestionEditorPanel questionEditorPanel = new QuestionEditorPanel((QuestPanel)this.questPanel, questionDraft);
                    questionEditorPanel.addOASaveListener(this.focusNode);
                    WindowSystem.createPanel(questionEditorPanel);
                }
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
    }

    private void editAction(Object object) {
        try {
            if (object instanceof ActionDraft) {
                ActionEditorPanel actionEditorPanel = new ActionEditorPanel((QuestPanel)this.questPanel, ((ActionDraft)object).getInd());
                actionEditorPanel.addOASaveListener(this.focusNode);
                WindowSystem.createPanel(actionEditorPanel);
            } else if (object instanceof Action) {
                ActionDraft actionDraft = null;
                int n = ((Action)object).getInd();
                actionDraft = OASQL.getActionDraft(GUISystem.getParentDefWin(this), n, 2);
                if (actionDraft != null) {
                    ActionEditorPanel actionEditorPanel = new ActionEditorPanel((QuestPanel)this.questPanel, actionDraft);
                    actionEditorPanel.addOASaveListener(this.focusNode);
                    WindowSystem.createPanel(actionEditorPanel);
                }
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
    }

    private void editSymptom(Object object) {
        try {
            if (object instanceof SymptomDraft) {
                SymptomEditorPanel symptomEditorPanel = new SymptomEditorPanel((QuestPanel)this.questPanel, ((SymptomDraft)object).getInd());
                symptomEditorPanel.addOASaveListener(this.focusNode);
                WindowSystem.createPanel(symptomEditorPanel);
            } else if (object instanceof Symptom) {
                SymptomDraft symptomDraft = null;
                int n = ((Symptom)object).getInd();
                symptomDraft = OASQL.getSymptomDraft(GUISystem.getParentDefWin(this), n, 2);
                if (symptomDraft != null) {
                    SymptomEditorPanel symptomEditorPanel = new SymptomEditorPanel((QuestPanel)this.questPanel, symptomDraft);
                    symptomEditorPanel.addOASaveListener(this.focusNode);
                    WindowSystem.createPanel(symptomEditorPanel);
                }
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
    }

    private void popupAddActions() {
        Dimension dimension = this.pb_ADD.getSize();
        Point point = this.pb_ADD.getLocation();
        Color color = new Color(230, 230, 230);
        this.mnu_ADD_ACTION = new JMenuItem(Str.getStr(793), ImageSystem.getImageIcon((Object)this, 122));
        this.mnu_ADD_QUESTION = new JMenuItem(Str.getStr(8), ImageSystem.getImageIcon((Object)this, 121));
        this.mnu_ADD_SYMPTOM = new JMenuItem(Str.getStr(920), ImageSystem.getImageIcon((Object)this, 145));
        this.mnu_ADD_RESOLVED = new JMenuItem(Str.getStr(1220));
        this.mnu_ADD_UNRESOLVED = new JMenuItem(Str.getStr(1221));
        this.mnu_ADD_ACTION_LIST = new JMenuItem(Str.getStr(1134));
        this.mnu_ADD_RETURN = new JMenuItem(Str.getStr(1222));
        this.mnu_ADD_QUESTION.setBackground(color);
        this.mnu_ADD_ACTION.setBackground(color);
        this.mnu_ADD_SYMPTOM.setBackground(color);
        this.mnu_ADD_RESOLVED.setBackground(color);
        this.mnu_ADD_UNRESOLVED.setBackground(color);
        this.mnu_ADD_ACTION_LIST.setBackground(color);
        this.mnu_ADD_RETURN.setBackground(color);
        this.mnu_ADD_QUESTION.addActionListener(this);
        this.mnu_ADD_ACTION.addActionListener(this);
        this.mnu_ADD_SYMPTOM.addActionListener(this);
        this.mnu_ADD_ACTION_LIST.addActionListener(this);
        this.mnu_ADD_RETURN.addActionListener(this);
        this.mnu_ADD_RESOLVED.addActionListener(this);
        this.mnu_ADD_UNRESOLVED.addActionListener(this);
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add(this.mnu_ADD_ACTION);
        this.popupMenu.add(this.mnu_ADD_ACTION_LIST);
        this.popupMenu.add(this.mnu_ADD_QUESTION);
        this.popupMenu.add(this.mnu_ADD_SYMPTOM);
        this.popupMenu.add(this.mnu_ADD_RESOLVED);
        this.popupMenu.add(this.mnu_ADD_RETURN);
        this.popupMenu.add(this.mnu_ADD_UNRESOLVED);
        this.popupMenu.setLightWeightPopupEnabled(true);
        this.popupMenu.setBorder(GUISystem.grayBorder);
        this.popupMenu.setBackground(new Color(230, 230, 230));
        this.popupMenu.show(this.buttonPanel, point.x - 5, dimension.height - 1);
    }

    private void popupActions() {
        Dimension dimension = this.pb_ACTIONS.getSize();
        Point point = this.pb_ACTIONS.getLocation();
        Color color = new Color(230, 230, 230);
        this.mnu_SET_ROOT = new JMenuItem(Str.getStr(1244));
        this.mnu_SET_ROOT.setBackground(color);
        this.mnu_SET_ROOT.addActionListener(this);
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add(this.mnu_SET_ROOT);
        this.popupMenu.setLightWeightPopupEnabled(true);
        this.popupMenu.setBorder(GUISystem.grayBorder);
        this.popupMenu.setBackground(new Color(230, 230, 230));
        this.popupMenu.show(this.buttonPanel, point.x - 5, dimension.height - 1);
    }

    protected boolean saveData() {
        boolean bl = false;
        if (this.symptom.getRootNode() == null) {
            GUISystem.printBox((Component)this, (int)7, (int)1243);
        } else {
            bl = true;
        }
        return bl;
    }

    private void clearRoots() {
        Vector vector = this.getObjectNodes();
        if (vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                ((ObjectNode)vector.elementAt(n)).setRoot(false);
                ++n;
            }
        }
    }

    private void setRoot(ObjectNode objectNode) {
        Vector vector = AvalonUtil.getTailEdgeGroups(objectNode.getNode(), this.symptom);
        if ((vector = QuestUtil.getValidData(vector)) == null || vector.size() == 0 || QuestUtil.containsValid(vector)) {
            this.clearRoots();
            this.symptom.setRootNode(objectNode.getNode());
            objectNode.setRoot(true);
            this.repaint();
        } else {
            GUISystem.printBox(7, 1245);
        }
    }

    protected VisioPanel getVisioPanel() {
        return this.visioPanel;
    }

    private void cascadeObjectNodes(Vector vector) {
        int n = 0;
        int n2 = vector.size();
        int n3 = 0;
        int n4 = 0;
        while (n < n2) {
            ((ObjectNode)vector.elementAt(n)).setLocation(n3, n4);
            n3 += 15;
            n4 += 15;
            ++n;
        }
    }

    public Vector getSymptoms() {
        Vector<Object> vector = new Vector<Object>(1, 1);
        Vector vector2 = this.visioPanel.getObjectNodes();
        if (vector2 != null && vector2.size() > 0) {
            int n = 0;
            int n2 = vector2.size();
            ObjectNode objectNode = null;
            while (n < n2) {
                objectNode = (ObjectNode)vector2.elementAt(n);
                if (objectNode.isObjectRead() && objectNode.getObject() instanceof Symptom) {
                    vector.addElement(objectNode.getObject());
                }
                ++n;
            }
        }
        return vector;
    }

    public Vector getActions() {
        Vector<Object> vector = new Vector<Object>(1, 1);
        Vector vector2 = this.visioPanel.getObjectNodes();
        if (vector2 != null && vector2.size() > 0) {
            int n = 0;
            int n2 = vector2.size();
            ObjectNode objectNode = null;
            while (n < n2) {
                objectNode = (ObjectNode)vector2.elementAt(n);
                if (objectNode.isObjectRead() && objectNode.getObject() instanceof Action) {
                    vector.addElement(objectNode.getObject());
                }
                ++n;
            }
        }
        return vector;
    }

    public Vector getQuestions() {
        Vector<Object> vector = new Vector<Object>(1, 1);
        Vector vector2 = this.visioPanel.getObjectNodes();
        if (vector2 != null && vector2.size() > 0) {
            int n = 0;
            int n2 = vector2.size();
            ObjectNode objectNode = null;
            while (n < n2) {
                objectNode = (ObjectNode)vector2.elementAt(n);
                if (objectNode.isObjectRead() && objectNode.getObject() instanceof Question) {
                    vector.addElement(objectNode.getObject());
                }
                ++n;
            }
        }
        return vector;
    }

    private void addActionListenerToObjectNodes(Vector vector) {
        int n = 0;
        int n2 = vector.size();
        while (n < n2) {
            ((ObjectNode)vector.elementAt(n)).addActionListener(this);
            ++n;
        }
    }

    public void run() {
        String string = Thread.currentThread().getName();
        if (string.equals(THREAD_PROCESS_NODE_FOCUS_RECEIVED)) {
            this.processNodeFocusReceived();
        }
    }

    public void free() {
        this.visioPanel.free();
    }

    protected void setDraftEditPanel(DraftEditPanel draftEditPanel) {
        this.draftPanel = draftEditPanel;
    }

    protected DraftEditPanel getDraftEditPanel() {
        return this.draftPanel;
    }

    protected void removeCountryFromPanel(TypeCountryCodeRec typeCountryCodeRec) {
        this.removeCountryFromEdges(typeCountryCodeRec);
    }

    protected void removeCountryFromEdges(TypeCountryCodeRec typeCountryCodeRec) {
        Vector vector = this.symptom.getEdgeGroups();
        if (vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                Vector vector2 = ((EdgeGroup)vector.elementAt(n)).getEdges();
                if (vector2 != null && vector2.size() > 0) {
                    int n3 = 0;
                    int n4 = vector2.size();
                    while (n3 < n4) {
                        ((Edge)vector2.elementAt(n3)).removeCountry(typeCountryCodeRec);
                        ++n3;
                    }
                }
                ++n;
            }
        }
    }

    public FlowEditPanel(SymptomEditorPanel symptomEditorPanel) {
        this.questPanel = symptomEditorPanel;
        this.initialize();
    }
}

