/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.avalon.editors;

import com.ibm.nzna.projects.common.quest.oa.Edge;
import com.ibm.nzna.projects.common.quest.oa.EdgeGroup;
import com.ibm.nzna.projects.common.quest.oa.Symptom;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.FontSystem;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.util.QuestUtil;
import com.ibm.nzna.projects.qit.avalon.base.AvalonUtil;
import com.ibm.nzna.projects.qit.avalon.editors.DraftEditPanel;
import com.ibm.nzna.projects.qit.avalon.editors.EdgeDlg;
import com.ibm.nzna.projects.qit.avalon.editors.EdgeEditPanel;
import com.ibm.nzna.projects.qit.avalon.editors.EditPanel;
import com.ibm.nzna.projects.qit.avalon.editors.EditPanelListener;
import com.ibm.nzna.projects.qit.avalon.editors.FlowEditPanel;
import com.ibm.nzna.projects.qit.avalon.editors.FlowNode;
import com.ibm.nzna.projects.qit.avalon.editors.NodePanel;
import com.ibm.nzna.projects.qit.avalon.editors.ObjectNode;
import com.ibm.nzna.projects.qit.avalon.editors.VisioPanel;
import com.ibm.nzna.projects.qit.gui.JTitle;
import com.ibm.nzna.shared.gui.ButtonPanel;
import com.ibm.nzna.shared.gui.HotLinkLabel;
import com.ibm.nzna.shared.gui.ToolBarSeparator;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.StoreUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class QuestionNodePanel
extends JPanel
implements MouseListener,
EditPanelListener,
ActionListener,
NodePanel,
AppConst {
    private JTitle st_QUESTION = null;
    private JLabel st_TITLE = null;
    private JScrollPane scrollPane = null;
    private JList lb_EDGES = null;
    private HotLinkLabel pb_ADD_EDGE = null;
    private HotLinkLabel pb_REMOVE_EDGE = null;
    private HotLinkLabel pb_EDIT_EDGE = null;
    private JLabel st_EDGES = null;
    private JLabel st_QUESTIONIND = null;
    private ButtonPanel buttonPanel = null;
    private int questionInd = 0;
    private boolean showingDraft = false;
    private ObjectNode objectNode = null;
    private FlowEditPanel flowPanel = null;
    private Symptom symptom = null;
    private VisioPanel visioPanel = null;
    private Vector edges = null;

    private void initialize() {
        this.st_QUESTION = new JTitle(Str.getStr(8));
        this.st_QUESTIONIND = new JLabel("");
        this.st_TITLE = new JLabel("");
        this.st_EDGES = new JLabel(Str.getStr(943));
        this.lb_EDGES = new JList();
        this.scrollPane = new JScrollPane(this.lb_EDGES);
        this.pb_ADD_EDGE = new HotLinkLabel(Str.getStr(95));
        this.pb_REMOVE_EDGE = new HotLinkLabel(Str.getStr(96));
        this.pb_EDIT_EDGE = new HotLinkLabel(Str.getStr(50));
        this.buttonPanel = new ButtonPanel();
        this.setOpaque(false);
        this.st_QUESTION.setOpaque(false);
        this.st_TITLE.setOpaque(false);
        this.st_QUESTION.setFont(FontSystem.largeTitleFont);
        this.st_EDGES.setFont(FontSystem.smallTitleFont);
        this.scrollPane.setBorder(GUISystem.blackBorder);
        this.buttonPanel.setBorder(GUISystem.grayBorder);
        this.buttonPanel.setBackground(new Color(240, 240, 240));
        this.pb_ADD_EDGE.addActionListener(this);
        this.pb_EDIT_EDGE.addActionListener(this);
        this.pb_REMOVE_EDGE.addActionListener(this);
        this.lb_EDGES.addMouseListener(this);
        this.setLayout(null);
        this.add(this.st_QUESTION);
        this.add(this.st_TITLE);
        this.add(this.st_QUESTIONIND);
        this.add(this.st_EDGES);
        this.add(this.scrollPane);
        this.add(this.buttonPanel);
        this.buttonPanel.add(this.pb_ADD_EDGE);
        this.buttonPanel.add(new ToolBarSeparator(new Dimension(1, GUISystem.getRowHeight())));
        this.buttonPanel.add(this.pb_EDIT_EDGE);
        this.buttonPanel.add(new ToolBarSeparator(new Dimension(1, GUISystem.getRowHeight())));
        this.buttonPanel.add(this.pb_REMOVE_EDGE);
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        int n = GUISystem.getRowHeight();
        int n2 = 5;
        int n3 = 0;
        this.st_QUESTION.setBounds(n2, n3, dimension.width - n2 * 2, n + 8);
        this.st_TITLE.setBounds(n2, n3 += n + 10, dimension.width - n2 * 2, n);
        this.st_QUESTIONIND.setBounds(n2, n3 += n, dimension.width - n2 * 2, n);
        this.st_EDGES.setBounds(n2, n3 += n + 5, dimension.width - n2 * 2, n);
        this.scrollPane.setBounds(n2, n3 += n + 5, dimension.width - n2 * 2, n * 5);
        this.buttonPanel.setBounds(n2, n3 += n * 5 + 5, dimension.width - n2 * 2, n);
    }

    public void setNode(FlowNode flowNode) {
        if (flowNode instanceof ObjectNode) {
            this.objectNode = (ObjectNode)flowNode;
        }
    }

    public void refresh() {
        this.st_TITLE.setText(this.getDefaultTitle());
        if (this.objectNode.isDraft()) {
            this.st_QUESTIONIND.setText("" + this.objectNode.getNode().getDraftObjectInd());
        } else {
            this.st_QUESTIONIND.setText("" + this.objectNode.getNode().getActiveObjectInd());
        }
        Vector vector = this.symptom.getEdgeGroups();
        this.setEdges(AvalonUtil.getEdgesFromNode(this.symptom.getEdgeGroups(), this.objectNode.getNode()));
    }

    private String getDefaultTitle() {
        if (this.objectNode != null) {
            return this.objectNode.getTitle();
        }
        return "Unknown";
    }

    protected void setEdges(Vector vector) {
        this.edges = QuestUtil.getValidData(vector);
        this.lb_EDGES.setListData(this.edges);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.pb_EDIT_EDGE) {
            this.editEdge();
        } else if (actionEvent.getSource() == this.pb_REMOVE_EDGE) {
            Edge edge = (Edge)this.lb_EDGES.getSelectedValue();
            EdgeGroup edgeGroup = null;
            Vector vector = this.symptom.getEdgeGroups();
            int n = 0;
            boolean bl = false;
            if (vector != null) {
                int n2 = vector.size();
                while (n < n2 && !bl) {
                    if (((EdgeGroup)vector.elementAt(n)).getEdges().contains(edge)) {
                        edgeGroup = (EdgeGroup)vector.elementAt(n);
                        edge.updateRecStatus(3);
                        if (!QuestUtil.containsValid(edgeGroup.getEdges())) {
                            edgeGroup.updateRecStatus(3);
                        }
                        bl = true;
                    }
                    ++n;
                }
            }
            this.edges.removeElement(edge);
            this.lb_EDGES.setListData(this.edges);
            this.symptom.setEdgeGroups(vector);
            this.flowPanel.getVisioPanel().refreshEdgeReturns();
            this.flowPanel.refreshData();
            this.flowPanel.repaint();
        } else if (actionEvent.getSource() == this.pb_ADD_EDGE) {
            Vector<EdgeGroup> vector = this.symptom.getEdgeGroups();
            EdgeGroup edgeGroup = null;
            EdgeDlg edgeDlg = new EdgeDlg(GUISystem.getParentDefWin(this), this.symptom, this.objectNode, this.flowPanel.getObjectNodes(), !this.containsEdgeOther());
            if (edgeDlg.getResult()) {
                DraftEditPanel draftEditPanel = this.flowPanel.getDraftEditPanel();
                Edge edge = edgeDlg.getEdge();
                Vector<Edge> vector2 = null;
                if (draftEditPanel != null) {
                    edge.setDocClass(draftEditPanel.getDocClass());
                    edge.setCountryList(draftEditPanel.getCountrySelectPanel().getCountryList());
                } else {
                    LogSystem.log(1, "Could not get DraftEditPanel in Edge Creation. Defaulting DocClass and Countries");
                }
                edgeGroup = AvalonUtil.getEdgeGroup(vector, this.objectNode.getNode(), edgeDlg.getTailNode().getNode());
                if (edgeGroup == null) {
                    if (vector == null) {
                        vector = new Vector<EdgeGroup>(1);
                    }
                    edgeGroup = new EdgeGroup(this.objectNode.getNode(), edgeDlg.getTailNode().getNode());
                    vector.addElement(edgeGroup);
                }
                if ((vector2 = edgeGroup.getEdges()) == null) {
                    vector2 = new Vector<Edge>(1);
                }
                vector2.addElement(edge);
                this.edges.addElement(edge);
                edgeGroup.setEdges(vector2);
                edgeGroup.updateRecStatus(1);
                this.setEdges(this.edges);
                this.symptom.setEdgeGroups(vector);
                this.flowPanel.getVisioPanel().addEdgeGroup(edgeGroup);
                this.flowPanel.refreshCounters();
                this.flowPanel.repaint();
            }
        }
    }

    public void editPanelChanged(EditPanel editPanel) {
        this.flowPanel.setDefaultDataPanel();
        this.setControlsEnabled(true);
        this.flowPanel.getVisioPanel().refreshEdgeReturns();
    }

    private void setControlsEnabled(boolean bl) {
        this.pb_ADD_EDGE.setEnabled(bl);
        this.pb_REMOVE_EDGE.setEnabled(bl);
        this.pb_EDIT_EDGE.setEnabled(bl);
        this.scrollPane.setEnabled(bl);
        this.lb_EDGES.setEnabled(bl);
    }

    private boolean containsEdgeOther() {
        boolean bl = false;
        if (this.edges != null && this.edges.size() > 0) {
            int n = this.edges.size();
            int n2 = 0;
            while (!bl && n2 < n) {
                bl = ((Edge)this.edges.elementAt(n2)).getEdgeType() == 1;
                ++n2;
            }
        }
        return bl;
    }

    public void spellCheckComplete(EditPanel editPanel, boolean bl) {
    }

    private void editEdge() {
        Edge edge = (Edge)this.lb_EDGES.getSelectedValue();
        if (edge != null) {
            EdgeGroup edgeGroup = AvalonUtil.getEdgeGroup(this.symptom.getEdgeGroups(), edge);
            boolean bl = edgeGroup.getTailNode().getNodeType() == 2;
            Vector vector = (Vector)this.visioPanel.getObjectNodes().clone();
            EdgeEditPanel edgeEditPanel = null;
            StoreUtil.removeFromVector(vector, this.symptom.getRootNode());
            StoreUtil.removeFromVector(vector, edgeGroup.getTailNode());
            StoreUtil.removeFromVector(vector, this.objectNode.getNode());
            edgeEditPanel = new EdgeEditPanel(edge, vector, bl);
            edgeEditPanel.addEditPanelListener(this);
            this.flowPanel.setDataPanel(edgeEditPanel, true);
            this.setControlsEnabled(false);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 1) {
            this.editEdge();
        }
    }

    public QuestionNodePanel(FlowEditPanel flowEditPanel, VisioPanel visioPanel, Symptom symptom) {
        this.flowPanel = flowEditPanel;
        this.symptom = symptom;
        this.visioPanel = visioPanel;
        this.initialize();
    }

    public QuestionNodePanel(FlowNode flowNode) {
        this.initialize();
        if (flowNode instanceof ObjectNode) {
            this.setNode((ObjectNode)flowNode);
        }
    }
}

