/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.avalon.editors;

import com.ibm.nzna.projects.common.quest.oa.SymptomTitle;
import com.ibm.nzna.projects.common.quest.type.TypeCountryCodeRec;
import com.ibm.nzna.projects.common.quest.type.TypeDocClassRec;
import com.ibm.nzna.projects.common.quest.type.TypeLanguageRec;
import com.ibm.nzna.projects.common.quest.type.TypeList;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.FontSystem;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.app.util.QuestUtil;
import com.ibm.nzna.projects.qit.avalon.base.AvalonConst;
import com.ibm.nzna.projects.qit.avalon.editors.EditPanel;
import com.ibm.nzna.projects.qit.avalon.editors.SymptomKeywordDlg;
import com.ibm.nzna.projects.qit.dbgui.CountrySelectPanel;
import com.ibm.nzna.projects.qit.gui.AppDefaultWin;
import com.ibm.nzna.projects.qit.gui.JTitle;
import com.ibm.nzna.projects.qit.gui.SingleEntryDlg;
import com.ibm.nzna.shared.gui.ButtonPanel;
import com.ibm.nzna.shared.gui.HotLinkLabel;
import com.ibm.nzna.shared.gui.MaskDocument;
import com.ibm.nzna.shared.gui.ToolBarSeparator;
import com.ibm.nzna.shared.spell.SpellPanel;
import com.ibm.nzna.shared.spell.SpellPanelListener;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.Text;
import com.ibm.nzna.shared.util.WinUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SymptomTitleEditPanel
extends EditPanel
implements SpellPanelListener,
Runnable,
ListSelectionListener,
AppConst,
AvalonConst,
ActionListener,
KeyListener {
    private Dimension prefSize = new Dimension(400, 700);
    private JList lb_TITLES = null;
    private JTextField ef_TITLE = null;
    private JScrollPane scr_TITLES = null;
    private JTitle st_TITLES = null;
    private JTitle st_DOC_CLASS = null;
    private JComboBox cb_DOC_CLASS = null;
    private JTitle st_TITLE_TEXT = null;
    private HotLinkLabel pb_ADD_TITLE = null;
    private HotLinkLabel pb_REMOVE_TITLE = null;
    private HotLinkLabel pb_SET_DEFAULT = null;
    private HotLinkLabel pb_TITLE_UP = null;
    private HotLinkLabel pb_TITLE_DOWN = null;
    private HotLinkLabel pb_ADD_KEYWORDS = null;
    private HotLinkLabel pb_REMOVE_KEYWORDS = null;
    private ButtonPanel buttonPanel = null;
    private ButtonPanel titleButtonPanel = null;
    private JTextArea mle_KEYWORDS = null;
    private JTitle st_KEYWORDS = null;
    private JScrollPane scr_KEYWORDS = null;
    private CountrySelectPanel countryPanel = null;
    private DefaultListModel listModel = null;
    private Vector titles = null;
    private SymptomTitle defaultTitle = null;
    private SymptomTitle currentTitle = null;
    private SymptomTitle spellCheckTitle = null;
    private int spellIndex = 0;
    private JTabbedPane tabbedPane = null;
    private SpellPanel spellPanel = null;
    private int brandInd = 0;

    private void initialize() {
        this.ef_TITLE = new JTextField(new MaskDocument(0, 1024), "", 0);
        this.st_TITLES = new JTitle(Str.getStr(642));
        this.st_TITLE_TEXT = new JTitle(Str.getStr(967));
        this.pb_ADD_TITLE = new HotLinkLabel(Str.getStr(968));
        this.pb_REMOVE_TITLE = new HotLinkLabel(Str.getStr(969));
        this.pb_SET_DEFAULT = new HotLinkLabel(Str.getStr(976));
        this.pb_ADD_KEYWORDS = new HotLinkLabel(Str.getStr(1413));
        this.pb_REMOVE_KEYWORDS = new HotLinkLabel(Str.getStr(1414));
        this.buttonPanel = new ButtonPanel();
        this.lb_TITLES = new JList();
        this.pb_TITLE_UP = new HotLinkLabel(Str.getStr(1044));
        this.pb_TITLE_DOWN = new HotLinkLabel(Str.getStr(1045));
        this.scr_TITLES = new JScrollPane(this.lb_TITLES);
        this.st_DOC_CLASS = new JTitle(Str.getStr(269));
        this.cb_DOC_CLASS = new JComboBox(TypeList.getInstance().getTypeList(5));
        this.titleButtonPanel = new ButtonPanel();
        this.st_KEYWORDS = new JTitle(Str.getStr(830));
        this.mle_KEYWORDS = new JTextArea(new MaskDocument(0, 1024));
        this.scr_KEYWORDS = new JScrollPane(this.mle_KEYWORDS);
        this.countryPanel = new CountrySelectPanel();
        this.setBackground(Color.white);
        this.listModel = new DefaultListModel();
        this.lb_TITLES.setModel(this.listModel);
        this.st_TITLE_TEXT.setFont(FontSystem.smallTitleFont);
        this.st_DOC_CLASS.setFont(FontSystem.smallTitleFont);
        this.st_TITLES.setFont(FontSystem.smallTitleFont);
        GUISystem.setPreferredButton(this.pb_SET_DEFAULT);
        GUISystem.setPreferredButton(this.pb_ADD_TITLE);
        GUISystem.setPreferredButton(this.pb_REMOVE_TITLE);
        this.scr_TITLES.setBorder(GUISystem.blackBorder);
        this.buttonPanel.setBorder(GUISystem.grayBorder);
        this.st_KEYWORDS.setFont(FontSystem.smallTitleFont);
        this.buttonPanel.setBackground(new Color(230, 230, 230));
        this.buttonPanel.setArrowImage(ImageSystem.getImageIcon((Object)this, 146), ImageSystem.getImageIcon((Object)this, 147));
        this.titleButtonPanel.setBorder(GUISystem.grayBorder);
        this.titleButtonPanel.setBackground(new Color(230, 230, 230));
        this.titleButtonPanel.setArrowImage(ImageSystem.getImageIcon((Object)this, 146), ImageSystem.getImageIcon((Object)this, 147));
        this.lb_TITLES.setSelectionBackground(new Color(170, 170, 255));
        this.pb_ADD_TITLE.addActionListener(this);
        this.pb_REMOVE_TITLE.addActionListener(this);
        this.pb_SET_DEFAULT.addActionListener(this);
        this.lb_TITLES.addListSelectionListener(this);
        this.ef_TITLE.addKeyListener(this);
        this.pb_TITLE_UP.addActionListener(this);
        this.pb_TITLE_DOWN.addActionListener(this);
        this.pb_ADD_KEYWORDS.addActionListener(this);
        this.pb_REMOVE_KEYWORDS.addActionListener(this);
        this.setLayout(null);
        this.add(this.st_TITLES);
        this.add(this.scr_TITLES);
        this.titleButtonPanel.add(this.pb_TITLE_UP);
        this.titleButtonPanel.add(new ToolBarSeparator(new Dimension(1, GUISystem.getRowHeight())));
        this.titleButtonPanel.add(this.pb_TITLE_DOWN);
        this.add(this.titleButtonPanel);
        this.add(this.st_TITLE_TEXT);
        this.add(this.ef_TITLE);
        this.add(this.st_DOC_CLASS);
        this.add(this.cb_DOC_CLASS);
        this.add(this.buttonPanel);
        this.add(this.st_KEYWORDS);
        this.add(this.scr_KEYWORDS);
        this.add(this.countryPanel);
        if (UserSystem.getLoggedUserRec().isBPM()) {
            this.buttonPanel.add(this.pb_SET_DEFAULT);
            this.buttonPanel.add(new ToolBarSeparator(new Dimension(1, GUISystem.getRowHeight())));
        }
        this.buttonPanel.add(this.pb_ADD_TITLE);
        this.buttonPanel.add(new ToolBarSeparator(new Dimension(1, GUISystem.getRowHeight())));
        this.buttonPanel.add(this.pb_REMOVE_TITLE);
        this.buttonPanel.add(new ToolBarSeparator(new Dimension(1, GUISystem.getRowHeight())));
        this.buttonPanel.add(this.pb_ADD_KEYWORDS);
        this.buttonPanel.add(new ToolBarSeparator(new Dimension(1, GUISystem.getRowHeight())));
        this.buttonPanel.add(this.pb_REMOVE_KEYWORDS);
        if (this.titles != null) {
            this.getDefaultTitle();
            this.refreshData(null);
            this.refreshTitles();
        }
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        int n = 15;
        int n2 = GUISystem.getRowHeight();
        int n3 = 5;
        this.buttonPanel.setBounds(n, n3, dimension.width - n * 2, n2);
        this.st_TITLES.setBounds(n, n3 += n2 + 5, dimension.width - n * 2, n2);
        this.scr_TITLES.setBounds(n, n3 += n2, dimension.width - n * 2, n2 * 5);
        this.titleButtonPanel.setBounds(n, n3 += n2 * 5 + 5, dimension.width - n * 2, n2);
        this.st_TITLE_TEXT.setBounds(n, n3 += n2 + 10, dimension.width - n * 2 - 170, n2);
        this.st_DOC_CLASS.setBounds(dimension.width - n * 2 - 150, n3, 150, n2);
        this.ef_TITLE.setBounds(n, n3 += n2, dimension.width - n * 2 - 170, n2);
        this.cb_DOC_CLASS.setBounds(dimension.width - n * 2 - 150, n3, 150, n2);
        this.st_KEYWORDS.setBounds(n, n3 += n2, dimension.width - n * 2, n2);
        this.scr_KEYWORDS.setBounds(n, n3 += n2, dimension.width - n * 2, n2 * 5);
        this.countryPanel.setBounds(n, n3 += n2 * 5, dimension.width - n * 2, n2 * 7);
    }

    private void refreshData(SymptomTitle symptomTitle) {
        this.ef_TITLE.setText("");
        this.mle_KEYWORDS.setText("");
        if (symptomTitle != null) {
            this.ef_TITLE.setText(symptomTitle.getTitle());
            this.cb_DOC_CLASS.setSelectedItem(symptomTitle.getDocClass());
            this.mle_KEYWORDS.setText(symptomTitle.getKeywords());
            this.countryPanel.setCountryList(symptomTitle.getCountryList());
        }
        if (this.currentTitle == this.getDefaultTitle()) {
            this.cb_DOC_CLASS.setVisible(false);
            this.st_DOC_CLASS.setVisible(false);
            this.ef_TITLE.setEnabled(UserSystem.getLoggedUserRec().isBPM(this.brandInd));
            this.pb_TITLE_UP.setEnabled(false);
            this.pb_TITLE_DOWN.setEnabled(false);
            this.countryPanel.setEnabled(false);
        } else {
            this.ef_TITLE.setEnabled(true);
            this.countryPanel.setEnabled(true);
            this.cb_DOC_CLASS.setVisible(true);
            this.st_DOC_CLASS.setVisible(true);
            this.pb_TITLE_UP.setEnabled(true);
            this.pb_TITLE_DOWN.setEnabled(true);
        }
    }

    protected SymptomTitle getDefaultTitle() {
        this.defaultTitle = this.titles != null ? (SymptomTitle)this.titles.elementAt(this.titles.size() - 1) : null;
        return this.defaultTitle;
    }

    private SymptomTitle addTitle(AppDefaultWin appDefaultWin) {
        SymptomTitle symptomTitle = null;
        String string = new SingleEntryDlg((Frame)appDefaultWin, this.titles == null ? Str.getStr(974) : Str.getStr(318), this.titles == null ? Str.getStr(975) : Str.getStr(318), "", new MaskDocument(0, 1024)).getResult();
        if (string != null && string.length() > 0) {
            try {
                symptomTitle = new SymptomTitle(string);
                symptomTitle.setDocClass((TypeDocClassRec)TypeList.getInstance().objectFromInd(1, 5));
                symptomTitle.setLanguage((TypeLanguageRec)TypeList.getInstance().objectFromInd(PropertySystem.getInt(1), 8));
                symptomTitle.setCountryList(UserSystem.getUserCountries(UserSystem.getUserId()));
                if (this.titles == null) {
                    this.titles = new Vector(1, 1);
                }
                this.titles.insertElementAt(symptomTitle, 0);
                this.refreshTitles();
                this.lb_TITLES.setSelectedValue(symptomTitle, true);
                this.refreshData(symptomTitle);
            }
            catch (Exception exception) {
                LogSystem.log(1, exception);
            }
        }
        return symptomTitle;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.pb_ADD_TITLE) {
            this.refreshData(this.addTitle(GUISystem.getParentDefWin(this)));
            return;
        } else if (actionEvent.getSource() == this.pb_REMOVE_TITLE) {
            if (this.currentTitle == null) return;
            this.currentTitle.updateRecStatus(3);
            this.currentTitle = null;
            this.refreshTitles();
            return;
        } else if (actionEvent.getSource() == this.pb_SET_DEFAULT) {
            this.setDefault();
            return;
        } else if (actionEvent.getSource() == this.pb_TITLE_UP) {
            if (this.currentTitle == null) return;
            this.moveTitleUp();
            return;
        } else if (actionEvent.getSource() == this.pb_TITLE_DOWN) {
            if (this.currentTitle == null) return;
            this.moveTitleDown();
            return;
        } else if (actionEvent.getSource() == this.pb_ADD_KEYWORDS) {
            SymptomKeywordDlg symptomKeywordDlg = new SymptomKeywordDlg(GUISystem.getParentDefWin(this));
            this.saveData();
            if (symptomKeywordDlg.getResults() == 3) return;
            switch (symptomKeywordDlg.getResults()) {
                case 1: {
                    this.addKeywords(symptomKeywordDlg.getKeywords(), this.titles);
                    return;
                }
                case 2: {
                    Object[] objectArray = this.lb_TITLES.getSelectedValues();
                    Vector<Object> vector = new Vector<Object>(10);
                    if (objectArray == null) return;
                    int n = 0;
                    while (n < objectArray.length) {
                        vector.addElement(objectArray[n]);
                        ++n;
                    }
                    this.addKeywords(symptomKeywordDlg.getKeywords(), vector);
                    return;
                }
            }
            return;
        } else {
            if (actionEvent.getSource() != this.pb_REMOVE_KEYWORDS) return;
            SymptomKeywordDlg symptomKeywordDlg = new SymptomKeywordDlg((Frame)GUISystem.getParentDefWin(this), this.mle_KEYWORDS.getSelectedText());
            this.saveData();
            if (symptomKeywordDlg.getResults() == 3) return;
            switch (symptomKeywordDlg.getResults()) {
                case 1: {
                    this.removeKeywords(symptomKeywordDlg.getKeywords(), this.titles);
                    return;
                }
                case 2: {
                    Object[] objectArray = this.lb_TITLES.getSelectedValues();
                    Vector<Object> vector = new Vector<Object>(10);
                    if (objectArray == null) return;
                    int n = 0;
                    while (n < objectArray.length) {
                        vector.addElement(objectArray[n]);
                        ++n;
                    }
                    this.removeKeywords(symptomKeywordDlg.getKeywords(), vector);
                    return;
                }
            }
        }
    }

    private void refreshTitles() {
        Vector vector = QuestUtil.getValidData(this.titles);
        this.listModel.removeAllElements();
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                ((SymptomTitle)vector.elementAt(n)).setToStringType(0);
                ++n;
            }
            this.getDefaultTitle();
            if (this.defaultTitle != null) {
                this.defaultTitle.setToStringType(2);
            }
            if (vector != null) {
                n = 0;
                int n2 = vector.size();
                while (n < n2) {
                    this.listModel.add(this.listModel.getSize(), vector.elementAt(n));
                    ++n;
                }
            }
        }
        this.ef_TITLE.setText("");
        this.revalidate();
    }

    private void setDefault() {
        if (this.currentTitle != this.getDefaultTitle()) {
            this.titles.removeElement(this.currentTitle);
            this.titles.addElement(this.currentTitle);
            this.defaultTitle = this.currentTitle;
            this.refreshTitles();
        }
    }

    public void setTitles(Vector vector) {
        if (vector != null && vector.size() > 0) {
            this.titles = vector;
            this.getDefaultTitle();
            this.refreshTitles();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            if (this.currentTitle != null) {
                this.saveData();
            }
            this.currentTitle = (SymptomTitle)this.lb_TITLES.getSelectedValue();
            new Thread(this).start();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.saveTitle();
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.saveTitle();
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.saveTitle();
    }

    private void saveTitle() {
        if (this.currentTitle != null) {
            if (this.currentTitle == this.defaultTitle) {
                this.fireChangedEvent();
            }
            this.currentTitle.setTitle(this.ef_TITLE.getText());
            this.lb_TITLES.repaint();
        }
    }

    protected boolean saveData() {
        if (this.currentTitle != null) {
            this.currentTitle.setDocClass((TypeDocClassRec)this.cb_DOC_CLASS.getSelectedItem());
            this.currentTitle.setKeywords(this.mle_KEYWORDS.getText());
            this.currentTitle.setCountryList(this.countryPanel.getCountryList());
        }
        return true;
    }

    public void run() {
        this.fireChangedEvent();
        this.refreshData(this.currentTitle);
    }

    public Dimension getPreferredSize() {
        return this.prefSize;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    protected Vector getTitleVec() {
        return this.titles;
    }

    private void moveTitleUp() {
        this.moveTitleInList(false);
    }

    public void moveTitleDown() {
        this.moveTitleInList(true);
    }

    public void moveTitleInList(boolean bl) {
        int n = this.titles.indexOf(this.currentTitle);
        n = bl ? ++n : --n;
        if (n >= 0 && n < this.titles.size() - 1) {
            boolean bl2 = false;
            int n2 = this.titles.size();
            this.titles.removeElement(this.currentTitle);
            this.titles.insertElementAt(this.currentTitle, n);
            this.listModel.removeElement(this.currentTitle);
            this.listModel.add(n, this.currentTitle);
            this.lb_TITLES.setSelectedValue(this.currentTitle, true);
        }
    }

    protected boolean spellCheck(JTabbedPane jTabbedPane, SpellPanel spellPanel) {
        boolean bl = false;
        if (this.titles.size() > 0) {
            this.tabbedPane = jTabbedPane;
            this.spellPanel = spellPanel;
            spellPanel.addSpellPanelListener(this);
            this.spellIndex = 0;
            this.spellCheck((SymptomTitle)this.titles.elementAt(this.spellIndex));
        } else {
            this.fireSpellCheckEvent(false);
        }
        return bl;
    }

    private boolean spellCheck(SymptomTitle symptomTitle) {
        boolean bl = false;
        this.spellCheckTitle = symptomTitle;
        this.spellPanel.spellCheck(this.spellCheckTitle.getTitle());
        return bl;
    }

    public void spellCheckComplete(boolean bl) {
        ++this.spellIndex;
        if (this.spellIndex >= this.titles.size() - 1) {
            this.spellPanel.removeSpellPanelListener(this);
            this.fireSpellCheckEvent(bl);
        } else {
            this.spellCheck((SymptomTitle)this.titles.elementAt(this.spellIndex));
        }
    }

    public void spellCheckWord(String string, int n, int n2) {
        this.tabbedPane.setSelectedComponent(WinUtil.getParentJScrollPane(this));
        this.saveData();
        this.currentTitle = this.spellCheckTitle;
        this.refreshData(this.currentTitle);
        this.lb_TITLES.setSelectedValue(this.currentTitle, true);
        this.ef_TITLE.setSelectionStart(n);
        this.ef_TITLE.setSelectionEnd(n2);
        this.revalidate();
    }

    public void replaceWord(String string, String string2, int n) {
        int n2 = this.ef_TITLE.getSelectionStart();
        String string3 = this.spellCheckTitle.getTitle();
        string3 = string3.substring(0, n) + string2 + string3.substring(n + string.length());
        this.spellCheckTitle.setTitle(string3);
        this.refreshData(this.spellCheckTitle);
        this.revalidate();
    }

    public void setBrandInd(int n) {
        this.brandInd = n;
        this.pb_SET_DEFAULT.setEnabled(UserSystem.getLoggedUserRec().isBPM(n));
    }

    public void addKeywords(String string, Vector vector) {
        int n = 0;
        int n2 = vector.size();
        String string2 = null;
        Vector<String> vector2 = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            vector2.addElement(stringTokenizer.nextToken().trim());
        }
        n4 = vector2.size();
        while (n < n2) {
            bl = vector.elementAt(n) == this.defaultTitle ? UserSystem.getLoggedUserRec().isBPM(this.brandInd) : true;
            if (!bl) continue;
            string2 = ((SymptomTitle)vector.elementAt(n)).getKeywords().trim();
            n3 = 0;
            while (n3 < n4) {
                if (string2.indexOf(vector2.elementAt(n3).toString()) == -1) {
                    string2 = string2 + " " + vector2.elementAt(n3);
                }
                ++n3;
            }
            ((SymptomTitle)vector.elementAt(n)).setKeywords(string2);
            ++n;
        }
        this.refreshData(this.currentTitle);
    }

    public void removeKeywords(String string, Vector vector) {
        int n = 0;
        int n2 = vector.size();
        String string2 = null;
        Vector<String> vector2 = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            vector2.addElement(stringTokenizer.nextToken().trim());
        }
        n4 = vector2.size();
        while (n < n2) {
            bl = vector.elementAt(n) == this.defaultTitle ? UserSystem.getLoggedUserRec().isBPM(this.brandInd) : true;
            if (!bl) continue;
            string2 = ((SymptomTitle)vector.elementAt(n)).getKeywords().trim();
            n3 = 0;
            while (n3 < n4) {
                if (string2.indexOf(vector2.elementAt(n3).toString()) >= 0) {
                    string2 = Text.replaceAllStrInStr(string2, vector2.elementAt(n3).toString(), "");
                }
                ++n3;
            }
            ((SymptomTitle)vector.elementAt(n)).setKeywords(string2.trim());
            ++n;
        }
        this.refreshData(this.currentTitle);
    }

    protected CountrySelectPanel getCountrySelectPanel() {
        return this.countryPanel;
    }

    protected void removeCountryFromPanel(TypeCountryCodeRec typeCountryCodeRec) {
        this.saveData();
        if (this.titles != null && this.titles.size() > 0) {
            int n = 0;
            int n2 = this.titles.size();
            Vector vector = null;
            while (n < n2) {
                vector = ((SymptomTitle)this.titles.elementAt(n)).getCountryList();
                vector.removeElement(typeCountryCodeRec);
                ((SymptomTitle)this.titles.elementAt(n)).setCountryList(vector);
                ++n;
            }
        }
        if (this.currentTitle != null) {
            this.countryPanel.setCountryList(this.currentTitle.getCountryList());
        }
    }

    public SymptomTitleEditPanel(int n, Vector vector) {
        this.brandInd = n;
        this.titles = vector;
        this.initialize();
    }

    public SymptomTitleEditPanel(int n) {
        this.brandInd = n;
        this.initialize();
    }
}

