/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.avalon.editors;

import com.ibm.nzna.projects.common.quest.brand.Brands;
import com.ibm.nzna.projects.common.quest.oa.Symptom;
import com.ibm.nzna.projects.common.quest.type.TypeBrandRec;
import com.ibm.nzna.projects.common.quest.type.TypeCountryCodeRec;
import com.ibm.nzna.projects.common.quest.type.TypeList;
import com.ibm.nzna.projects.oa.engine.LogicAPI;
import com.ibm.nzna.projects.oa.engine.OAEngine;
import com.ibm.nzna.projects.oa.engine.OAReturnVars;
import com.ibm.nzna.projects.oa.engine.OASubmitVars;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.FontSystem;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.MainWindow;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.avalon.base.AvalonConst;
import com.ibm.nzna.projects.qit.avalon.base.AvalonMemoryInterface;
import com.ibm.nzna.projects.qit.avalon.editors.BrandFamilyMachineModelDlg;
import com.ibm.nzna.projects.qit.avalon.editors.SymptomEditorPanel;
import com.ibm.nzna.projects.qit.gui.AppDefaultWin;
import com.ibm.nzna.projects.qit.gui.Browser;
import com.ibm.nzna.projects.qit.gui.JTitle;
import com.ibm.nzna.projects.qit.product.MachineRec;
import com.ibm.nzna.projects.qit.product.ProductConstants;
import com.ibm.nzna.projects.qit.product.ProductRec;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.gui.ButtonPanel;
import com.ibm.nzna.shared.gui.DButton;
import com.ibm.nzna.shared.gui.HotLinkLabel;
import com.ibm.nzna.shared.gui.JListDlg;
import com.ibm.nzna.shared.gui.MaskDocument;
import com.ibm.nzna.shared.gui.ToolBarSeparator;
import com.ibm.nzna.shared.util.LogSystem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.sql.ResultSet;
import java.util.Properties;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SymptomValidatorPanel
extends JPanel
implements AvalonConst,
AppConst,
ProductConstants,
ActionListener,
ListSelectionListener {
    private JTextField ef_MODEL = null;
    private JTitle st_MODEL = null;
    private HotLinkLabel pb_CHANGE = null;
    private JList lb_HISTORY = null;
    private JList lb_ANSWERS = null;
    private JTitle st_HISTORY = null;
    private Browser browser = null;
    private JTextArea mle_SOURCE = null;
    private ButtonPanel buttonPanel = null;
    private HotLinkLabel pb_EDIT = null;
    private HotLinkLabel pb_REMOVE = null;
    private JTitle st_WEBSITE = null;
    private JTitle st_GEOGRAPHY = null;
    private JTitle st_ANSWERS = null;
    private JComboBox cb_WEBSITE = null;
    private JComboBox cb_COUNTRY = null;
    private JScrollPane historyScroll = null;
    private JScrollPane answerScroll = null;
    private DButton pb_START = null;
    private DefaultListModel historyListModel = null;
    private DefaultListModel answerListModel = null;
    private JTabbedPane outputPane = null;
    private boolean started = false;
    private SymptomEditorPanel symptomEditorPanel = null;
    private LogicAPI logicAPI = null;
    private OAEngine oaEngine = null;
    private TypeBrandRec brandRec = null;
    private OASubmitVars oaSubmitVars = null;
    private OAReturnVars oaReturnVars = null;
    private Properties countryProp = new Properties();
    private Properties countryProp2 = new Properties();
    private Properties langProp = new Properties();
    private AvalonMemoryInterface memoryInterface = null;
    private Symptom symptom = null;
    private String machineModel = null;

    public void setSymptom(Symptom symptom) {
        this.symptom = symptom;
    }

    private void initialize() {
        Vector<String> vector = new Vector<String>(3);
        AppDefaultWin appDefaultWin = GUISystem.getParentDefWin(this);
        Color color = new Color(240, 240, 240);
        if (appDefaultWin != null) {
            appDefaultWin = MainWindow.getInstance();
        }
        vector.addElement(Str.getStr(117));
        vector.addElement(Str.getStr(119));
        vector.addElement(Str.getStr(118));
        this.st_HISTORY = new JTitle(Str.getStr(1206));
        this.lb_HISTORY = new JList();
        this.historyScroll = new JScrollPane(this.lb_HISTORY);
        this.browser = new Browser();
        this.pb_REMOVE = new HotLinkLabel(Str.getStr(96));
        this.pb_EDIT = new HotLinkLabel(Str.getStr(50));
        this.st_WEBSITE = new JTitle(Str.getStr(1207));
        this.st_GEOGRAPHY = new JTitle(Str.getStr(148));
        this.cb_COUNTRY = new JComboBox(TypeList.getInstance().getTypeList(3));
        this.cb_WEBSITE = new JComboBox(vector);
        this.lb_ANSWERS = new JList();
        this.answerScroll = new JScrollPane(this.lb_ANSWERS);
        this.st_ANSWERS = new JTitle(Str.getStr(966));
        this.buttonPanel = new ButtonPanel();
        this.pb_START = new DButton(Str.getStr(1263));
        this.historyListModel = new DefaultListModel();
        this.answerListModel = new DefaultListModel();
        this.pb_CHANGE = new HotLinkLabel(Str.getStr(1272));
        this.st_MODEL = new JTitle(Str.getStr(341));
        this.ef_MODEL = new JTextField();
        this.outputPane = new JTabbedPane();
        this.mle_SOURCE = new JTextArea();
        this.ef_MODEL.setDocument(new MaskDocument(4, "XXXX-XXX", this.ef_MODEL));
        this.browser.setBorder(GUISystem.blackBorder);
        this.historyScroll.setBorder(GUISystem.blackBorder);
        this.pb_REMOVE.setOpaque(false);
        this.pb_EDIT.setOpaque(false);
        this.buttonPanel.setBorder(GUISystem.grayBorder);
        this.buttonPanel.setBorder(GUISystem.grayBorder);
        this.buttonPanel.setBackground(new Color(230, 230, 230));
        this.buttonPanel.setArrowImage(ImageSystem.getImageIcon((Object)this, 146), ImageSystem.getImageIcon((Object)this, 147));
        this.setStartButton(true);
        this.pb_START.setFocusPainted(false);
        this.st_GEOGRAPHY.setFont(FontSystem.smallTitleFont);
        this.st_HISTORY.setFont(FontSystem.smallTitleFont);
        this.st_WEBSITE.setFont(FontSystem.smallTitleFont);
        this.st_ANSWERS.setFont(FontSystem.smallTitleFont);
        this.st_MODEL.setFont(FontSystem.smallTitleFont);
        this.setBackground(Color.white);
        this.browser.showZoom(false);
        this.lb_HISTORY.setModel(this.historyListModel);
        this.lb_ANSWERS.setModel(this.answerListModel);
        this.pb_CHANGE.setBackground(new Color(230, 230, 230));
        this.pb_CHANGE.setBorder(GUISystem.grayBorder);
        this.outputPane.setBorder(GUISystem.grayBorder);
        this.pb_EDIT.addActionListener(this);
        this.pb_REMOVE.addActionListener(this);
        this.pb_START.addActionListener(this);
        this.pb_CHANGE.addActionListener(this);
        this.lb_ANSWERS.addListSelectionListener(this);
        this.add(this.st_HISTORY);
        this.add(this.st_GEOGRAPHY);
        this.add(this.cb_COUNTRY);
        this.add(this.st_WEBSITE);
        this.add(this.cb_WEBSITE);
        this.add(this.pb_START);
        this.add(this.historyScroll);
        this.add(this.outputPane);
        this.outputPane.addTab(Str.getStr(1291), (Component)((Object)this.browser));
        this.outputPane.addTab(Str.getStr(283), new JScrollPane(this.mle_SOURCE));
        this.add(this.st_ANSWERS);
        this.add(this.answerScroll);
        this.add(this.buttonPanel);
        this.add(this.st_MODEL);
        this.add(this.ef_MODEL);
        this.add(this.pb_CHANGE);
        this.buttonPanel.add(this.pb_EDIT);
        this.buttonPanel.add(new ToolBarSeparator(new Dimension(1, GUISystem.getRowHeight())));
        this.buttonPanel.add(this.pb_REMOVE);
        try {
            this.countryProp.load(new FileInputStream(new File("countryProperties.prop")));
            this.countryProp2.load(new FileInputStream(new File("countryProperties2.prop")));
            this.langProp.load(new FileInputStream(new File("languageProperties.prop")));
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            GUISystem.printBox((Frame)appDefaultWin, 7, 1267);
            this.countryProp = null;
            this.langProp = null;
        }
        if (PropertySystem.getString(132) != null) {
            this.ef_MODEL.setText(PropertySystem.getString(132));
        }
        if (PropertySystem.getInt(133) > 0) {
            this.cb_COUNTRY.setSelectedItem(TypeList.getInstance().objectFromInd(PropertySystem.getInt(133), 3));
        }
        if (PropertySystem.getString(134) != null) {
            this.cb_WEBSITE.setSelectedItem(PropertySystem.getString(134));
        }
        this.outputPane.setBackgroundAt(0, color);
        this.outputPane.setBackgroundAt(1, color);
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        int n = GUISystem.getRowHeight();
        int n2 = 15;
        int n3 = 5;
        this.st_MODEL.setBounds(n2, n3, 200, n);
        this.st_GEOGRAPHY.setBounds(n2 + 205, n3, 200, n);
        this.st_WEBSITE.setBounds(n2 + 410, n3, 200, n);
        this.pb_START.setBounds(n2 + 615, n3, 70, n * 2);
        this.ef_MODEL.setBounds(n2, n3 += n, 125, n);
        this.pb_CHANGE.setBounds(n2 + 128, n3, 72, n);
        this.cb_COUNTRY.setBounds(n2 + 205, n3, 200, n);
        this.cb_WEBSITE.setBounds(n2 + 410, n3, 200, n);
        this.buttonPanel.setBounds(n2, dimension.height - 25, 200, n);
        this.st_HISTORY.setBounds(n2, n3 += n + 5, 200, n);
        this.outputPane.setBounds(n2 + 205, n3, dimension.width - n2 * 3 - 205, dimension.height - 180 - n3 - n);
        this.historyScroll.setBounds(n2, n3 += n, 200, dimension.height - 30 - n3);
        n3 = dimension.height - 130 - n3;
        this.st_ANSWERS.setBounds(n2 + 205, n3, dimension.width - n2 * 3 - 205, n);
        this.answerScroll.setBounds(n2 + 205, n3 += n, dimension.width - n2 * 3 - 205, dimension.height - n3 - 5);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() != this.pb_REMOVE) {
            if (actionEvent.getSource() == this.pb_CHANGE) {
                ProductRec productRec = new BrandFamilyMachineModelDlg(GUISystem.getParentDefWin(this)).getResults();
                if (productRec != null) {
                    this.ef_MODEL.setText(((MachineRec)productRec.getFieldData(2)).toString() + (String)productRec.getFieldData(3));
                }
            } else if (actionEvent.getSource() != this.pb_EDIT && actionEvent.getSource() == this.pb_START) {
                if (this.started) {
                    this.stopSymptom();
                } else {
                    this.startSymptom();
                }
            }
        }
    }

    private void setStartButton(boolean bl) {
        if (bl) {
            this.pb_START.setBackground(new Color(192, 252, 192));
            this.pb_START.setBorder(new LineBorder(new Color(0, 128, 0)));
            this.pb_START.setForeground(new Color(0, 128, 0));
            this.pb_START.setText(Str.getStr(1263));
        } else {
            this.pb_START.setBackground(new Color(255, 192, 192));
            this.pb_START.setBorder(new LineBorder(new Color(128, 0, 0)));
            this.pb_START.setForeground(new Color(128, 0, 0));
            this.pb_START.setText(Str.getStr(1063));
        }
    }

    private void startSymptom() {
        AppDefaultWin appDefaultWin = GUISystem.getParentDefWin(this);
        try {
            this.machineModel = this.ef_MODEL.getText();
            if (this.machineModel == null || this.machineModel.trim().length() < 5) {
                GUISystem.printBox((Frame)appDefaultWin, 7, 1290);
            } else {
                this.cb_COUNTRY.setEnabled(false);
                this.cb_WEBSITE.setEnabled(false);
                this.setStartButton(false);
                this.started = true;
                PropertySystem.putString(132, this.machineModel);
                PropertySystem.putInt(133, ((TypeCountryCodeRec)this.cb_COUNTRY.getSelectedItem()).getInd());
                PropertySystem.putString(134, this.cb_WEBSITE.getSelectedItem().toString());
                if (this.getBrandFromMachineModel(this.machineModel)) {
                    appDefaultWin.setStatus(Str.getStr(1266));
                    this.logicAPI = new LogicAPI(0, 0, (String)PropertySystem.get(30) + File.separator, this.countryProp, this.langProp);
                    this.logicAPI.setQuestNames("quest", "d04rdb001", "5703", "quest", "j0hnny");
                    this.createOASubmitVars();
                    if (this.symptomEditorPanel != null) {
                        this.memoryInterface.initialize(this.symptomEditorPanel);
                    } else {
                        this.memoryInterface.initialize(this.symptom);
                    }
                    this.processNextValidatorNode();
                } else {
                    this.stopSymptom();
                }
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            GUISystem.printBox((Frame)appDefaultWin, 7, 1265);
        }
        appDefaultWin.setStatus(null);
    }

    private void stopSymptom() {
        this.cb_COUNTRY.setEnabled(true);
        this.cb_WEBSITE.setEnabled(true);
        this.historyListModel.removeAllElements();
        this.answerListModel.removeAllElements();
        this.browser.setPageContent("<html><body>&nbsp;&nbsp;&nbsp;</body></html>");
        this.mle_SOURCE.setText("");
        this.setStartButton(true);
        this.started = false;
        this.oaReturnVars = null;
        this.brandRec = null;
        this.machineModel = null;
    }

    private void createOASubmitVars() {
        this.oaSubmitVars = new OASubmitVars(0);
        this.oaSubmitVars.country = this.getSelectedCountryFromProperties();
        this.oaSubmitVars.qitMemory = this.memoryInterface;
        this.oaSubmitVars.typeModel = this.ef_MODEL.getText();
        this.oaSubmitVars.command = "GetNextNode";
        this.oaSubmitVars.docClass = 3;
        this.oaSubmitVars.brand = this.brandRec.toString();
    }

    private String getSelectedCountryFromProperties() {
        TypeCountryCodeRec typeCountryCodeRec;
        String string = null;
        if (this.countryProp2 != null && (typeCountryCodeRec = (TypeCountryCodeRec)this.cb_COUNTRY.getSelectedItem()) != null) {
            int n = typeCountryCodeRec.getInd();
            string = this.countryProp2.getProperty("" + n, "USA");
        }
        System.out.println("PASSING COUNTRY:" + string + "\n\n\n\n\n");
        return string;
    }

    private void refreshOutput(OAReturnVars oAReturnVars) {
        String string = "<html>\n   <body bgcolor=#FFFFFF>\n      <h1>" + oAReturnVars.title + "</h1>\n      <br>" + oAReturnVars.addInfo + "\n   </body>\n</html>";
        this.browser.setPageContent(string);
        this.mle_SOURCE.setText(string);
        this.answerListModel.removeAllElements();
        if (oAReturnVars.answerTitles != null) {
            int n = 0;
            int n2 = oAReturnVars.answerTitles.size();
            while (n < n2) {
                this.answerListModel.addElement(oAReturnVars.answerTitles.elementAt(n));
                ++n;
            }
        }
    }

    private void refreshHistory() {
        this.oaSubmitVars.command = "GetHistory";
        this.oaReturnVars = this.logicAPI.dispatch(this.oaSubmitVars, this.symptom.getInd());
        System.out.println("History Count:" + this.oaReturnVars.answerTitles.size());
    }

    public boolean getBrandFromMachineModel(String string) {
        Object object;
        boolean bl = false;
        SQLMethod sQLMethod = new SQLMethod(1, "getBrandFromMachineModel", 5);
        try {
            object = sQLMethod.createStatement();
            ResultSet resultSet = null;
            if (object != null) {
                String string2 = string.substring(0, string.indexOf("-"));
                String string3 = string.substring(string.indexOf("-") + 1);
                resultSet = object.executeQuery("SELECT BRANDGROUPIND " + "FROM TIGRIS.PRODUCTS " + "WHERE MACHINE = '" + string2 + "' AND " + "MODEL = '" + string3 + "' FOR FETCH ONLY");
                if (resultSet.next()) {
                    this.brandRec = Brands.brandRecFromBrandGroupInd((int)resultSet.getInt(1));
                    bl = true;
                }
                resultSet.close();
            }
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception, false);
        }
        sQLMethod.close();
        if (!bl && GUISystem.printBox((Frame)GUISystem.getParentDefWin(this), 8, 1292) && (object = new JListDlg((Frame)GUISystem.getParentDefWin(this), Str.getStr(376), TypeList.getInstance().getTypeList(2)).getResult()) != null && ((Vector)object).size() > 0) {
            this.brandRec = (TypeBrandRec)((Vector)object).elementAt(0);
            bl = true;
        }
        return bl;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting() && listSelectionEvent.getSource() == this.lb_ANSWERS) {
            this.processNextValidatorNode();
        }
    }

    private void processNextValidatorNode() {
        AppDefaultWin appDefaultWin = GUISystem.getParentDefWin(this);
        int n = this.symptom.getInd();
        if (this.oaReturnVars != null) {
            if (this.oaReturnVars.objectInd != 0) {
                n = this.oaReturnVars.objectInd;
            }
            this.oaSubmitVars.nodeInd = this.oaReturnVars.nodeInd;
        }
        if (this.answerListModel.size() > 0) {
            try {
                String string = (String)this.lb_ANSWERS.getSelectedValue();
                int n2 = this.oaReturnVars.answerTitles.indexOf(string);
                this.oaSubmitVars.response = (Integer)this.oaReturnVars.answerInds.elementAt(n2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.oaSubmitVars.command = "GetNextNode";
        appDefaultWin.setStatus(Str.getStr(14));
        this.oaReturnVars = this.logicAPI.dispatch(this.oaSubmitVars, n);
        appDefaultWin.setStatus(null);
        this.refreshOutput(this.oaReturnVars);
    }

    public SymptomValidatorPanel(AvalonMemoryInterface avalonMemoryInterface, SymptomEditorPanel symptomEditorPanel) {
        this.symptomEditorPanel = symptomEditorPanel;
        this.memoryInterface = avalonMemoryInterface;
        this.initialize();
    }
}

