/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.avalon.editors;

import com.ibm.nzna.projects.common.quest.oa.Title;
import com.ibm.nzna.projects.common.quest.type.TypeCountryCodeRec;
import com.ibm.nzna.projects.common.quest.type.TypeDocClassRec;
import com.ibm.nzna.projects.common.quest.type.TypeLanguageRec;
import com.ibm.nzna.projects.common.quest.type.TypeList;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.FontSystem;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.app.util.QuestUtil;
import com.ibm.nzna.projects.qit.avalon.base.AvalonConst;
import com.ibm.nzna.projects.qit.avalon.editors.EditPanel;
import com.ibm.nzna.projects.qit.avalon.gui.ConditionList;
import com.ibm.nzna.projects.qit.dbgui.CountrySelectPanel;
import com.ibm.nzna.projects.qit.dbgui.DocClassPanel;
import com.ibm.nzna.projects.qit.gui.AppDefaultWin;
import com.ibm.nzna.projects.qit.gui.JTitle;
import com.ibm.nzna.projects.qit.gui.SingleEntryDlg;
import com.ibm.nzna.shared.gui.ButtonPanel;
import com.ibm.nzna.shared.gui.HotLinkLabel;
import com.ibm.nzna.shared.gui.MaskDocument;
import com.ibm.nzna.shared.gui.ToolBarSeparator;
import com.ibm.nzna.shared.pom.PersistentRec;
import com.ibm.nzna.shared.spell.SpellPanel;
import com.ibm.nzna.shared.spell.SpellPanelListener;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.WinUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TitleEditPanel
extends EditPanel
implements SpellPanelListener,
Runnable,
ListSelectionListener,
AppConst,
AvalonConst,
ActionListener,
KeyListener {
    private Dimension prefSize = new Dimension(400, 400);
    private JList lb_TITLES = null;
    private JTextField ef_TITLE = null;
    private JScrollPane scr_TITLES = null;
    private JTitle st_TITLES = null;
    private DocClassPanel docClassPanel = null;
    private JTitle st_TITLE_TEXT = null;
    private HotLinkLabel pb_ADD_TITLE = null;
    private HotLinkLabel pb_REMOVE_TITLE = null;
    private ButtonPanel buttonPanel = null;
    private HotLinkLabel pb_TITLE_UP = null;
    private HotLinkLabel pb_TITLE_DOWN = null;
    private CountrySelectPanel countrySelectPanel = null;
    private HotLinkLabel pb_SET_DEFAULT = null;
    private DefaultListModel listModel = null;
    private Vector titles = null;
    private Title defaultTitle = null;
    private Title currentTitle = null;
    private ConditionList conditionList = null;
    private ButtonPanel titleButtonPanel = null;
    private Title spellCheckTitle = null;
    private JTabbedPane tabbedPane = null;
    private int spellIndex = 0;
    private SpellPanel spellPanel = null;
    private int brandInd = 0;

    private void initialize() {
        this.ef_TITLE = new JTextField(new MaskDocument(0, 1024), "", 0);
        this.st_TITLES = new JTitle(Str.getStr(642));
        this.st_TITLE_TEXT = new JTitle(Str.getStr(967));
        this.pb_ADD_TITLE = new HotLinkLabel(Str.getStr(968));
        this.pb_REMOVE_TITLE = new HotLinkLabel(Str.getStr(969));
        this.buttonPanel = new ButtonPanel();
        this.lb_TITLES = new JList();
        this.pb_TITLE_UP = new HotLinkLabel(Str.getStr(1044));
        this.pb_TITLE_DOWN = new HotLinkLabel(Str.getStr(1045));
        this.scr_TITLES = new JScrollPane(this.lb_TITLES);
        this.docClassPanel = new DocClassPanel();
        this.conditionList = new ConditionList();
        this.titleButtonPanel = new ButtonPanel();
        this.countrySelectPanel = new CountrySelectPanel();
        this.pb_SET_DEFAULT = new HotLinkLabel(Str.getStr(976));
        this.setBackground(Color.white);
        this.listModel = new DefaultListModel();
        this.lb_TITLES.setModel(this.listModel);
        this.st_TITLE_TEXT.setFont(FontSystem.smallTitleFont);
        this.st_TITLES.setFont(FontSystem.smallTitleFont);
        GUISystem.setPreferredButton(this.pb_ADD_TITLE);
        GUISystem.setPreferredButton(this.pb_REMOVE_TITLE);
        this.scr_TITLES.setBorder(GUISystem.blackBorder);
        this.buttonPanel.setBorder(GUISystem.grayBorder);
        this.buttonPanel.setBackground(new Color(230, 230, 230));
        this.buttonPanel.setArrowImage(ImageSystem.getImageIcon((Object)this, 146), ImageSystem.getImageIcon((Object)this, 147));
        this.titleButtonPanel.setBorder(GUISystem.grayBorder);
        this.titleButtonPanel.setBackground(new Color(230, 230, 230));
        this.titleButtonPanel.setArrowImage(ImageSystem.getImageIcon((Object)this, 146), ImageSystem.getImageIcon((Object)this, 147));
        this.lb_TITLES.setSelectionBackground(new Color(209, 210, 253));
        this.lb_TITLES.setSelectionForeground(Color.black);
        this.pb_ADD_TITLE.addActionListener(this);
        this.pb_REMOVE_TITLE.addActionListener(this);
        this.lb_TITLES.addListSelectionListener(this);
        this.ef_TITLE.addKeyListener(this);
        this.pb_TITLE_UP.addActionListener(this);
        this.pb_TITLE_DOWN.addActionListener(this);
        this.pb_SET_DEFAULT.addActionListener(this);
        this.setLayout(null);
        this.add(this.st_TITLES);
        this.add(this.scr_TITLES);
        this.titleButtonPanel.add(this.pb_TITLE_UP);
        this.titleButtonPanel.add(new ToolBarSeparator(new Dimension(1, GUISystem.getRowHeight())));
        this.titleButtonPanel.add(this.pb_TITLE_DOWN);
        this.add(this.titleButtonPanel);
        this.add(this.st_TITLE_TEXT);
        this.add(this.ef_TITLE);
        this.add(this.docClassPanel);
        this.add(this.buttonPanel);
        this.add(this.conditionList);
        this.add(this.countrySelectPanel);
        this.setBrandInd(this.brandInd);
        this.buttonPanel.add(this.pb_SET_DEFAULT);
        this.buttonPanel.add(new ToolBarSeparator(new Dimension(1, GUISystem.getRowHeight())));
        this.buttonPanel.add(this.pb_ADD_TITLE);
        this.buttonPanel.add(new ToolBarSeparator(new Dimension(1, GUISystem.getRowHeight())));
        this.buttonPanel.add(this.pb_REMOVE_TITLE);
        if (this.titles != null) {
            this.refreshTitles();
            new Thread(this).start();
        }
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        int n = 15;
        int n2 = GUISystem.getRowHeight();
        int n3 = dimension.width / 2;
        int n4 = 5;
        this.buttonPanel.setBounds(n, n4, dimension.width - n * 2, n2);
        this.st_TITLES.setBounds(n, n4 += n2 + 5, dimension.width - n * 2, n2);
        this.scr_TITLES.setBounds(n, n4 += n2, dimension.width - n * 2, n2 * 5);
        this.titleButtonPanel.setBounds(n, n4 += n2 * 5 + 5, dimension.width - n * 2, n2);
        this.st_TITLE_TEXT.setBounds(n, n4 += n2 + 10, dimension.width - n * 2 - 170, n2);
        this.docClassPanel.setBounds(dimension.width - n * 2 - 150, n4, 150, n2 * 2);
        this.ef_TITLE.setBounds(n, n4 += n2, dimension.width - n * 2 - 170, n2);
        this.conditionList.setBounds(n, n4 += n2, n3 - n - 5, dimension.height - n4 - 5);
        this.countrySelectPanel.setBounds(n3, n4, n3 - n - 5, dimension.height - n4 - 5);
    }

    private void refreshData(Title title) {
        if (title != null) {
            this.ef_TITLE.setText(title.toString(1));
            this.docClassPanel.setDocClass(title.getDocClass());
            this.conditionList.setConditions(title.getConditions());
            this.countrySelectPanel.setCountryList(title.getCountryList());
        } else {
            this.ef_TITLE.setText("");
            this.conditionList.setConditions(null);
            this.countrySelectPanel.setCountryList(null);
        }
        this.getDefaultTitle();
    }

    protected Title getDefaultTitle() {
        this.defaultTitle = this.titles != null ? (Title)this.titles.elementAt(this.titles.size() - 1) : null;
        if (this.defaultTitle != null) {
            this.defaultTitle.setToStringType(4);
        }
        return this.defaultTitle;
    }

    private Title addTitle(AppDefaultWin appDefaultWin) {
        Title title = null;
        String string = null;
        this.saveData();
        string = new SingleEntryDlg((Frame)appDefaultWin, this.titles == null ? Str.getStr(974) : Str.getStr(318), this.titles == null ? Str.getStr(975) : Str.getStr(318), "", new MaskDocument(0, 1024)).getResult();
        if (string != null && string.length() > 0) {
            try {
                title = new Title(string);
                title.setDocClass((TypeDocClassRec)TypeList.getInstance().objectFromInd(1, 5));
                title.setLanguage((TypeLanguageRec)TypeList.getInstance().objectFromInd(PropertySystem.getInt(1), 8));
                title.setCountryList(UserSystem.getUserCountries(UserSystem.getUserId()));
                if (this.titles == null) {
                    this.titles = new Vector(1, 1);
                }
                this.titles.insertElementAt(title, 0);
                this.listModel.insertElementAt(title, 0);
                this.setCurrentTitle(title);
                this.lb_TITLES.setSelectedValue(title, true);
            }
            catch (Exception exception) {
                LogSystem.log(1, exception);
            }
        }
        return title;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.pb_ADD_TITLE) {
            this.addTitle(GUISystem.getParentDefWin(this));
        } else if (actionEvent.getSource() == this.pb_REMOVE_TITLE) {
            if (this.currentTitle != null) {
                this.currentTitle.updateRecStatus(3);
                this.currentTitle = null;
                this.refreshTitles();
                new Thread(this).start();
            }
        } else if (actionEvent.getSource() == this.pb_TITLE_UP) {
            if (this.currentTitle != null) {
                this.moveTitleUp();
            }
        } else if (actionEvent.getSource() == this.pb_TITLE_DOWN) {
            if (this.currentTitle != null) {
                this.moveTitleDown();
            }
        } else if (actionEvent.getSource() == this.pb_SET_DEFAULT && this.currentTitle != null) {
            this.getDefaultTitle();
            this.defaultTitle.setToStringType(3);
            this.titles.removeElement(this.currentTitle);
            this.titles.addElement(this.currentTitle);
            this.refreshTitles();
        }
    }

    private void refreshTitles() {
        Vector vector = QuestUtil.getValidData(this.titles);
        this.listModel.removeAllElements();
        if (vector != null) {
            this.getDefaultTitle();
            if (vector != null) {
                int n = 0;
                int n2 = vector.size();
                while (n < n2) {
                    if (vector.elementAt(n) != this.defaultTitle) {
                        ((Title)vector.elementAt(n)).setToStringType(1);
                    }
                    this.listModel.add(this.listModel.getSize(), vector.elementAt(n));
                    ++n;
                }
            }
        }
        this.ef_TITLE.setText("");
        this.revalidate();
    }

    public void setTitles(Vector vector) {
        if (vector != null && vector.size() > 0) {
            this.titles = vector;
            this.refreshTitles();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.setCurrentTitle((Title)this.lb_TITLES.getSelectedValue());
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.saveTitle();
        this.fireChangedEvent();
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.saveTitle();
        this.fireChangedEvent();
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.saveTitle();
        this.fireChangedEvent();
    }

    private void saveTitle() {
        if (this.currentTitle != null) {
            this.currentTitle.setTitle(this.ef_TITLE.getText());
            this.lb_TITLES.repaint();
        }
    }

    public boolean bookmark() {
        return false;
    }

    protected boolean saveData() {
        if (this.currentTitle != null) {
            this.currentTitle.setDocClass(this.docClassPanel.getDocClass());
            this.conditionList.saveConditions();
            this.currentTitle.setCountryList(this.countrySelectPanel.getCountryList());
        }
        return true;
    }

    public void run() {
        this.fireChangedEvent();
        this.refreshData(this.currentTitle);
    }

    public Dimension getPreferredSize() {
        return this.prefSize;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    protected Vector getTitleVec() {
        return this.titles;
    }

    private void moveTitleUp() {
        this.moveTitleInList(false);
    }

    public void moveTitleDown() {
        this.moveTitleInList(true);
    }

    public void moveTitleInList(boolean bl) {
        int n = this.titles.indexOf(this.currentTitle);
        this.defaultTitle = this.getDefaultTitle();
        if (this.currentTitle != this.defaultTitle) {
            n = bl ? ++n : --n;
            if (n >= 0 && n < this.titles.size() - 1) {
                int n2 = 0;
                int n3 = this.titles.size();
                this.titles.removeElement(this.currentTitle);
                this.titles.insertElementAt(this.currentTitle, n);
                this.listModel.removeAllElements();
                while (n2 < n3) {
                    if (((PersistentRec)this.titles.elementAt(n2)).valid()) {
                        this.listModel.add(this.listModel.getSize(), this.titles.elementAt(n2));
                    }
                    ++n2;
                }
                this.lb_TITLES.setSelectedValue(this.currentTitle, true);
            }
        }
    }

    protected void removeCountryFromPanel(TypeCountryCodeRec typeCountryCodeRec) {
        if (this.titles != null && this.titles.size() > 0) {
            int n = 0;
            int n2 = this.titles.size();
            Vector vector = null;
            while (n < n2) {
                vector = ((Title)this.titles.elementAt(n)).getCountryList();
                vector.removeElement(typeCountryCodeRec);
                ((Title)this.titles.elementAt(n)).setCountryList(vector);
                ++n;
            }
        }
        if (this.currentTitle != null) {
            this.countrySelectPanel.setCountryList(this.currentTitle.getCountryList());
        }
    }

    protected CountrySelectPanel getCountrySelectPanel() {
        return this.countrySelectPanel;
    }

    protected boolean spellCheck(JTabbedPane jTabbedPane, SpellPanel spellPanel) {
        boolean bl = false;
        if (this.titles.size() > 0) {
            this.tabbedPane = jTabbedPane;
            this.spellPanel = spellPanel;
            spellPanel.addSpellPanelListener(this);
            this.spellIndex = 0;
            this.spellCheck((Title)this.titles.elementAt(this.spellIndex));
        } else {
            this.fireSpellCheckEvent(false);
        }
        return bl;
    }

    private boolean spellCheck(Title title) {
        boolean bl = false;
        this.spellCheckTitle = title;
        this.spellPanel.spellCheck(this.spellCheckTitle.toString(1));
        return bl;
    }

    public void spellCheckComplete(boolean bl) {
        ++this.spellIndex;
        if (this.spellIndex >= this.titles.size() - 1) {
            this.spellPanel.removeSpellPanelListener(this);
            this.fireSpellCheckEvent(bl);
        } else {
            this.spellCheck((Title)this.titles.elementAt(this.spellIndex));
        }
    }

    public void spellCheckWord(String string, int n, int n2) {
        this.tabbedPane.setSelectedComponent(WinUtil.getParentJScrollPane(this));
        this.saveData();
        this.currentTitle = this.spellCheckTitle;
        this.refreshData(this.currentTitle);
        this.lb_TITLES.setSelectedValue(this.currentTitle, true);
        try {
            this.ef_TITLE.setSelectionStart(n);
            this.ef_TITLE.setSelectionEnd(n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.revalidate();
    }

    public void replaceWord(String string, String string2, int n) {
        int n2 = this.ef_TITLE.getSelectionStart();
        String string3 = this.spellCheckTitle.toString(1);
        string3 = string3.substring(0, n) + string2 + string3.substring(n + string.length());
        this.spellCheckTitle.setTitle(string3);
        this.refreshData(this.spellCheckTitle);
        this.revalidate();
    }

    private void setCurrentTitle(Title title) {
        if (this.currentTitle != null) {
            this.saveData();
        }
        this.currentTitle = title;
        this.getDefaultTitle();
        if (title == this.defaultTitle) {
            this.ef_TITLE.setEnabled(UserSystem.getLoggedUserRec().isBPM(this.brandInd));
            this.docClassPanel.setEnabled(false);
            this.pb_TITLE_UP.setEnabled(false);
            this.pb_TITLE_DOWN.setEnabled(false);
            this.countrySelectPanel.setEnabled(false);
            this.conditionList.setEnabled(false);
            this.pb_SET_DEFAULT.setEnabled(false);
            this.pb_REMOVE_TITLE.setEnabled(false);
        } else {
            this.docClassPanel.setEnabled(true);
            this.pb_TITLE_UP.setEnabled(true);
            this.pb_TITLE_DOWN.setEnabled(true);
            this.countrySelectPanel.setEnabled(true);
            this.conditionList.setEnabled(true);
            this.pb_REMOVE_TITLE.setEnabled(true);
            this.pb_SET_DEFAULT.setEnabled(UserSystem.getLoggedUserRec().isBPM(this.brandInd));
        }
        new Thread(this).start();
    }

    public void setBrandInd(int n) {
        boolean bl = UserSystem.getLoggedUserRec().isBPM(n);
        this.brandInd = n;
        this.pb_SET_DEFAULT.setEnabled(bl);
    }

    public TitleEditPanel(int n, Vector vector) {
        this.brandInd = n;
        this.titles = vector;
        this.initialize();
    }

    public TitleEditPanel(int n) {
        this.brandInd = n;
        this.initialize();
    }
}

