/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.avalon.editors;

import com.ibm.nzna.projects.common.quest.oa.Edge;
import com.ibm.nzna.projects.common.quest.oa.EdgeGroup;
import com.ibm.nzna.projects.common.quest.oa.Node;
import com.ibm.nzna.projects.common.quest.oa.Symptom;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.PropertyListener;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.avalon.base.AvalonConst;
import com.ibm.nzna.projects.qit.avalon.base.AvalonUtil;
import com.ibm.nzna.projects.qit.avalon.base.EdgeReturnDisplayRec;
import com.ibm.nzna.projects.qit.avalon.editors.ComponentNode;
import com.ibm.nzna.projects.qit.avalon.editors.FlowEditorFilter;
import com.ibm.nzna.projects.qit.avalon.editors.ObjectNode;
import com.ibm.nzna.projects.qit.avalon.editors.VisioListener;
import com.ibm.nzna.projects.qit.avalon.editors.VisioPanelReader;
import com.ibm.nzna.shared.pom.PersistentRec;
import com.ibm.nzna.shared.util.LogSystem;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JViewport;

public class VisioPanel
extends Container
implements MouseMotionListener,
MouseListener,
PropertyListener,
AvalonConst,
Runnable,
AppConst {
    private static final String THREAD_FIRE_NODE_FOCUS_RECEIVED = "FIREFOCUS";
    private Vector listeners = null;
    private Vector visibleEdges = new Vector(1, 1);
    private Vector visibleObjectNodes = new Vector(1, 1);
    private Vector focusEdgeGroups = new Vector(1, 1);
    private Vector edgeReturns = new Vector(1, 1);
    private Vector objectNodes = null;
    private Dimension prefSize = new Dimension(9999, 9999);
    private int nodeWidth = 100;
    private int nodeHeight = 100;
    private int gridSize = 10;
    private boolean paintGrid = false;
    private boolean paintEdgeTitle = false;
    private ObjectNode focusNode = null;
    private Symptom symptom = null;
    private ComponentNode componentNode = null;
    private JViewport parentViewport = null;
    private Point newScrollPt = new Point(0, 0);
    private int[] edgeTitleY = null;
    private int lengthEdgeText = 50;
    private Color gridColor = null;
    private Color edgeFocusColor = null;
    private Color edgeColor = null;
    private Color edgeReturnColor = null;

    private void initialize() {
        this.objectNodes = new Vector(1, 1);
        PropertySystem.addPropertyListener(123, this);
        PropertySystem.addPropertyListener(122, this);
        PropertySystem.addPropertyListener(137, this);
        PropertySystem.addPropertyListener(136, this);
        PropertySystem.addPropertyListener(135, this);
        PropertySystem.addPropertyListener(127, this);
        PropertySystem.addPropertyListener(138, this);
        this.setLayout(null);
        this.setBackground((Color)PropertySystem.get(138));
        this.gridColor = (Color)PropertySystem.get(123);
        this.edgeFocusColor = (Color)PropertySystem.get(137);
        this.edgeColor = (Color)PropertySystem.get(135);
        this.edgeReturnColor = (Color)PropertySystem.get(136);
        this.lengthEdgeText = PropertySystem.getInt(122);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public ObjectNode addNode(Node node) {
        ObjectNode objectNode = new ObjectNode(this.symptom, node);
        this.addObjectNode(objectNode);
        this.resetFilter();
        return objectNode;
    }

    public Vector addNodes(Vector vector) {
        Vector<ObjectNode> vector2 = new Vector<ObjectNode>(1);
        if (vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                ObjectNode objectNode = new ObjectNode(this.symptom, (Node)vector.elementAt(n));
                this.addObjectNode(objectNode);
                vector2.addElement(objectNode);
                ++n;
            }
        }
        this.resetFilter();
        return vector2;
    }

    private void addObjectNode(ObjectNode objectNode) {
        try {
            FlowEditorFilter flowEditorFilter = (FlowEditorFilter)PropertySystem.get(127);
            Rectangle rectangle = objectNode.getNodeBounds();
            if (rectangle.width == 0) {
                rectangle.width = 100;
            }
            if (rectangle.height == 0) {
                rectangle.height = 100;
            }
            objectNode.setSize(rectangle.width, rectangle.height);
            if (this.symptom != null && this.symptom.getRootNode() == objectNode.getNode()) {
                objectNode.setRoot(true);
            }
            this.objectNodes.addElement(objectNode);
            objectNode.setVisible(flowEditorFilter.showCountry(objectNode.getCountryList()) && flowEditorFilter.showDocClass(objectNode.getDocClass()));
            if (objectNode.getVisible()) {
                this.visibleObjectNodes.addElement(objectNode);
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
        }
    }

    private void addObjectNodes(Vector vector) {
        if (vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                this.addObjectNode((ObjectNode)vector.elementAt(n));
                ++n;
            }
        }
    }

    protected void setSymptom(Symptom symptom) {
        this.symptom = symptom;
        this.addObjectNodes(VisioPanelReader.readNodeData(symptom));
        this.resetFilter();
    }

    protected void addEdgeGroup(EdgeGroup edgeGroup) {
        ObjectNode objectNode = this.tailObjectNodeFromEdgeGroup(edgeGroup);
        ObjectNode objectNode2 = this.headObjectNodeFromEdgeGroup(edgeGroup);
        if (objectNode != null && objectNode2 != null && objectNode.getVisible() && objectNode2.getVisible()) {
            try {
                if (!this.visibleEdges.contains(edgeGroup)) {
                    this.visibleEdges.addElement(edgeGroup);
                }
            }
            catch (Exception exception) {
                this.visibleEdges.addElement(edgeGroup);
            }
            this.refreshEdgeReturns();
        } else {
            GUISystem.printBox(7, 1246);
        }
    }

    public Dimension getPreferredSize() {
        return this.prefSize;
    }

    public Dimension getMinimumSize() {
        return this.prefSize;
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void update(Graphics graphics) {
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.paintGrid) {
            graphics.setColor(this.gridColor);
            int n = this.gridSize;
            while (n < dimension.width) {
                graphics.drawLine(n, 0, n, dimension.height);
                n += this.gridSize;
            }
            n = this.gridSize;
            while (n < dimension.height) {
                graphics.drawLine(0, n, dimension.width, n);
                n += this.gridSize;
            }
        }
        this.paintEdges(graphics);
        this.paintNodes(graphics);
        super.paint(graphics);
    }

    public boolean getPaintGrid() {
        return this.paintGrid;
    }

    private void paintNodes(Graphics graphics) {
        int n = 0;
        if (this.objectNodes != null) {
            int n2 = this.visibleObjectNodes.size();
            Rectangle rectangle = (Rectangle)graphics.getClip();
            while (n < n2) {
                ObjectNode objectNode = (ObjectNode)this.visibleObjectNodes.elementAt(n);
                if (objectNode.isInClip(rectangle)) {
                    ((ObjectNode)this.visibleObjectNodes.elementAt(n)).paint(graphics);
                }
                ++n;
            }
        }
    }

    public void setPaintGrid(boolean bl) {
        this.paintGrid = bl;
        this.repaint();
    }

    public void paintEdges(Graphics graphics) {
        Serializable serializable;
        int n;
        int n2;
        if (this.visibleEdges.size() > 0) {
            n2 = 0;
            n = this.visibleEdges.size();
            serializable = null;
            ObjectNode objectNode = null;
            this.resetEdgeTitleY(n);
            graphics.setColor(this.edgeColor);
            if (this.paintEdgeTitle) {
                while (n2 < n) {
                    serializable = (EdgeGroup)this.visibleEdges.elementAt(n2);
                    objectNode = this.tailObjectNodeFromEdgeGroup((EdgeGroup)serializable);
                    objectNode.setEdgeTitleY(0);
                    ++n2;
                }
            }
            n2 = 0;
            while (n2 < n) {
                serializable = (EdgeGroup)this.visibleEdges.elementAt(n2);
                if (((PersistentRec)serializable).valid()) {
                    this.paintSingleEdgeGroup(graphics, ((EdgeGroup)serializable).getHeadNode(), ((EdgeGroup)serializable).getTailNode(), ((EdgeGroup)serializable).getEdges(), (EdgeGroup)serializable, true);
                }
                ++n2;
            }
        }
        if (this.focusEdgeGroups.size() > 0) {
            n2 = 0;
            n = this.focusEdgeGroups.size();
            serializable = null;
            graphics.setColor(this.edgeFocusColor);
            while (n2 < n) {
                serializable = (EdgeGroup)this.focusEdgeGroups.elementAt(n2);
                if (((PersistentRec)serializable).valid()) {
                    this.paintSingleEdgeGroup(graphics, ((EdgeGroup)serializable).getHeadNode(), ((EdgeGroup)serializable).getTailNode(), ((EdgeGroup)serializable).getEdges(), (EdgeGroup)serializable, false);
                }
                ++n2;
            }
        }
        if (this.edgeReturns.size() > 0) {
            n2 = 0;
            n = this.edgeReturns.size();
            serializable = null;
            graphics.setColor(this.edgeReturnColor);
            while (n2 < n) {
                serializable = (EdgeReturnDisplayRec)this.edgeReturns.elementAt(n2);
                this.paintSingleEdgeGroup(graphics, ((EdgeReturnDisplayRec)serializable).getHeadNode(), ((EdgeReturnDisplayRec)serializable).getTailNode(), null, null, false);
                ++n2;
            }
        }
    }

    private void resetEdgeTitleY(int n) {
        this.edgeTitleY = new int[n];
        int n2 = 0;
        while (n2 < n) {
            this.edgeTitleY[n2] = 0;
            ++n2;
        }
    }

    private int getEdgeGroupIndex(EdgeGroup edgeGroup) {
        return this.visibleEdges.indexOf(edgeGroup);
    }

    private void paintSingleEdgeGroup(Graphics graphics, Node node, Node node2, Vector vector, EdgeGroup edgeGroup, boolean bl) {
        boolean bl2 = false;
        Point point = new Point(0, 0);
        Point point2 = new Point(0, 0);
        Point point3 = new Point(0, 0);
        Point point4 = new Point(0, 0);
        int n = 0;
        int n2 = 0;
        String string = null;
        int n3 = 0;
        int n4 = 0;
        Rectangle rectangle = (Rectangle)graphics.getClip();
        if (node != null && node2 != null) {
            point.y = node.getYPos() + node.getHeight() + 10;
            point.x = node.getXPos() + node.getWidth() / 2;
            point4.y = node2.getYPos() - 10;
            point4.x = node2.getXPos() + node2.getWidth() / 2;
            n = Math.abs(point.x - point4.x);
            n2 = Math.abs(point.y - point4.y);
            point2.x = point4.x < point.x ? point.x - n : point4.x - n;
            point2.y = point.y;
            point3.y = point4.y;
            point3.x = point2.x;
            bl2 = rectangle.contains(point) || rectangle.contains(point4) || rectangle.contains(point2) || rectangle.contains(point3);
            if (bl2) {
                graphics.drawLine(point.x, node.getYPos() + node.getHeight(), point.x, point.y);
                graphics.drawLine(point.x, point.y, point2.x, point2.y);
                graphics.drawLine(point2.x, point2.y, point3.x, point3.y);
                graphics.drawLine(point3.x, point3.y, point4.x, point4.y);
                graphics.drawLine(point4.x, point4.y, point4.x, node2.getYPos());
                if (edgeGroup != null && this.paintEdgeTitle && bl && vector != null && vector.size() > 0) {
                    ObjectNode objectNode = this.tailObjectNodeFromEdgeGroup(edgeGroup);
                    int n5 = objectNode.getEdgeTitleY();
                    int n6 = GUISystem.getRowHeight();
                    if (n5 == 0) {
                        n5 = point4.y;
                    }
                    n4 = vector.size();
                    while (n3 < n4) {
                        if (((PersistentRec)vector.elementAt(n3)).valid() && (string = vector.elementAt(n3).toString()) != null) {
                            if (string.length() > this.lengthEdgeText) {
                                string = string.substring(0, this.lengthEdgeText) + "...";
                            }
                            graphics.drawString(string, point4.x + 3, n5 - 10);
                            n5 -= n6;
                        }
                        ++n3;
                    }
                    objectNode.setEdgeTitleY(n5);
                }
                graphics.drawImage(ImageSystem.getImageIcon((Object)this, 144).getImage(), point4.x - 5, node2.getYPos() - 10, this);
            }
        }
    }

    private void focusGained() {
        Vector vector = AvalonUtil.getHeadEdgeGroups(this.focusNode.getNode(), this.symptom);
        this.focusEdgeGroups.removeAllElements();
        this.focusEdgeGroups = vector;
        new Thread((Runnable)this, THREAD_FIRE_NODE_FOCUS_RECEIVED).start();
        this.repaint();
        this.revalidate();
    }

    protected int getEdgeGroupCount() {
        if (this.visibleEdges != null) {
            return this.visibleEdges.size();
        }
        return 0;
    }

    protected int getNodeCount() {
        int n = 1;
        int n2 = 0;
        int n3 = this.objectNodes.size();
        while (n2 < n3) {
            if (((ObjectNode)this.objectNodes.elementAt(n2)).getPaint()) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public void removeAll() {
        super.removeAll();
        this.objectNodes.removeAllElements();
        this.visibleEdges.removeAllElements();
        this.edgeReturns.removeAllElements();
        this.revalidate();
    }

    public void addVisioListener(VisioListener visioListener) {
        if (this.listeners == null) {
            this.listeners = new Vector(1);
        }
        this.listeners.addElement(visioListener);
    }

    public void removeVisioListener(VisioListener visioListener) {
        if (this.listeners != null) {
            this.listeners.removeElement(visioListener);
        }
    }

    private void fireNodeFocusReceived() {
        if (this.listeners != null) {
            int n = 0;
            int n2 = this.listeners.size();
            while (n < n2) {
                ((VisioListener)this.listeners.elementAt(n)).nodeFocusReceived(this.focusNode);
                ++n;
            }
        }
    }

    public void run() {
        String string = Thread.currentThread().getName();
        if (string.equals(THREAD_FIRE_NODE_FOCUS_RECEIVED)) {
            this.fireNodeFocusReceived();
        }
    }

    protected Vector getNodes() {
        Vector<Node> vector = null;
        if (this.objectNodes.size() > 0) {
            int n = this.objectNodes.size();
            int n2 = 0;
            vector = new Vector<Node>(n);
            while (n2 < n) {
                vector.addElement(((ObjectNode)this.objectNodes.elementAt(n2)).getNode());
                ++n2;
            }
        }
        return vector;
    }

    protected Vector getObjectNodes() {
        return this.objectNodes;
    }

    public void propertyChanged(int n, Object object) {
        this.refreshComponentProperties();
        if (n == 123) {
            this.gridColor = (Color)PropertySystem.get(123);
        } else if (n == 122) {
            this.lengthEdgeText = PropertySystem.getInt(122);
        } else if (n == 137) {
            this.edgeFocusColor = (Color)object;
        } else if (n == 135) {
            this.edgeColor = (Color)object;
        } else if (n == 136) {
            this.edgeReturnColor = (Color)object;
        } else if (n == 138) {
            this.setBackground((Color)object);
        } else if (n == 127) {
            this.resetFilter();
        }
        this.invalidate();
        this.revalidate();
    }

    private void refreshComponentProperties() {
        try {
            int n = 0;
            int n2 = this.objectNodes.size();
            while (n < n2) {
                ((ObjectNode)this.objectNodes.elementAt(n++)).refreshProperties();
            }
            if (this.componentNode != null) {
                this.componentNode.refreshProperties();
            }
            this.revalidate();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean getPaintTitles() {
        return this.paintEdgeTitle;
    }

    public void setPaintTitles(boolean bl) {
        this.paintEdgeTitle = bl;
        this.repaint();
    }

    protected void printToPrinter(PrintJob printJob) {
        Dimension dimension = this.getSize();
        Dimension dimension2 = printJob.getPageDimension();
        int n = 15;
        int n2 = 90;
        Graphics graphics = null;
        Image image = this.createImage(dimension.width, dimension.height);
        this.paint(image.getGraphics());
        while (n2 < dimension.height) {
            n = 0;
            while (n < dimension.width) {
                graphics = printJob.getGraphics();
                graphics.translate(n - n * 2, n2 - n2 * 2);
                graphics.drawImage(image, n, n2, this);
                graphics.translate(0, 0);
                graphics.dispose();
                n += dimension2.width;
            }
            n2 += dimension2.height;
        }
        image.flush();
        image = null;
        System.gc();
    }

    protected void resetFilter() {
        try {
            FlowEditorFilter flowEditorFilter = (FlowEditorFilter)PropertySystem.get(127);
            int n = 0;
            int n2 = this.objectNodes.size();
            ObjectNode objectNode = null;
            this.visibleObjectNodes.removeAllElements();
            this.visibleEdges.removeAllElements();
            if (this.componentNode != null) {
                this.componentNode.setVisible(false);
            }
            while (n < n2) {
                objectNode = (ObjectNode)this.objectNodes.elementAt(n);
                objectNode.setPaint(true);
                if (objectNode.getPaint()) {
                    this.visibleObjectNodes.addElement(objectNode);
                    this.resetFilterOnEdges(AvalonUtil.getHeadEdgeGroups(objectNode.getNode(), this.symptom));
                    this.resetFilterOnEdges(AvalonUtil.getTailEdgeGroups(objectNode.getNode(), this.symptom));
                }
                ++n;
            }
            this.refreshEdgeReturns();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void resetFilterOnEdges(Vector vector) {
        if (vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            ObjectNode objectNode = null;
            ObjectNode objectNode2 = null;
            while (n < n2) {
                objectNode = this.tailObjectNodeFromEdgeGroup((EdgeGroup)vector.elementAt(n));
                objectNode2 = this.headObjectNodeFromEdgeGroup((EdgeGroup)vector.elementAt(n));
                if (objectNode != null && objectNode2 != null) {
                    if (objectNode.getPaint() && objectNode2.getPaint()) {
                        try {
                            if (!this.visibleEdges.contains(vector.elementAt(n))) {
                                this.visibleEdges.addElement(vector.elementAt(n));
                            }
                        }
                        catch (Exception exception) {
                            this.visibleEdges.addElement(vector.elementAt(n));
                        }
                    }
                } else if (!this.visibleEdges.contains(vector.elementAt(n))) {
                    this.visibleEdges.addElement(vector.elementAt(n));
                }
                ++n;
            }
        }
    }

    private ObjectNode tailObjectNodeFromEdgeGroup(EdgeGroup edgeGroup) {
        ObjectNode objectNode = null;
        Vector vector = this.getObjectNodes();
        int n = 0;
        int n2 = vector.size();
        while (objectNode == null && n < n2) {
            if (((ObjectNode)vector.elementAt(n)).getNode() == edgeGroup.getTailNode()) {
                objectNode = (ObjectNode)vector.elementAt(n);
            }
            ++n;
        }
        return objectNode;
    }

    private ObjectNode headObjectNodeFromEdgeGroup(EdgeGroup edgeGroup) {
        ObjectNode objectNode = null;
        Vector vector = this.getObjectNodes();
        int n = 0;
        int n2 = vector.size();
        while (objectNode == null && n < n2) {
            if (((ObjectNode)vector.elementAt(n)).getNode() == edgeGroup.getTailNode()) {
                objectNode = (ObjectNode)vector.elementAt(n);
            }
            ++n;
        }
        return objectNode;
    }

    public void revalidate() {
        this.repaint();
        this.invalidate();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.processMouseClick(mouseEvent);
    }

    public void processMouseClick(MouseEvent mouseEvent) {
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        ObjectNode objectNode = this.objectNodeFromPoint(point);
        if (objectNode != null) {
            this.focusNode = objectNode;
            this.setComponentNode(this.focusNode);
            this.componentNode.requestFocus();
            this.focusGained();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    private ObjectNode objectNodeFromPoint(Point point) {
        int n = 0;
        ObjectNode objectNode = null;
        if (this.visibleObjectNodes != null) {
            int n2 = this.visibleObjectNodes.size();
            while (objectNode == null && n < n2) {
                if (((ObjectNode)this.visibleObjectNodes.elementAt(n)).containsPoint(point)) {
                    objectNode = (ObjectNode)this.visibleObjectNodes.elementAt(n);
                }
                ++n;
            }
        }
        return objectNode;
    }

    private void setComponentNode(ObjectNode objectNode) {
        if (this.componentNode == null) {
            this.componentNode = new ComponentNode(objectNode);
            super.add(this.componentNode);
            this.parentViewport = (JViewport)this.getParent();
            this.componentNode.setVisioPanel(this);
            this.componentNode.setVisible(true);
            this.componentNode.setBounds(objectNode.getNodeBounds());
        } else {
            this.componentNode.setObjectNode(objectNode);
        }
        if (this.componentNode != null) {
            this.componentNode.requestFocus();
        }
        this.componentNode.setVisible(true);
    }

    protected void ensureVisible(Rectangle rectangle) {
        Rectangle rectangle2 = this.parentViewport.getViewRect();
        this.newScrollPt.x = rectangle2.x;
        this.newScrollPt.y = rectangle2.y;
        if (rectangle2.x + rectangle2.width < rectangle.x) {
            this.newScrollPt.x += rectangle2.x + rectangle2.width - rectangle.x;
        } else if (rectangle2.x > rectangle.x) {
            this.newScrollPt.x = rectangle.x;
        } else if (rectangle2.x + rectangle2.width < rectangle.x + rectangle.width) {
            this.newScrollPt.x += rectangle.x + rectangle.width - (rectangle2.x + rectangle2.width);
        }
        if (rectangle2.y + rectangle2.height < rectangle.y) {
            this.newScrollPt.y = rectangle.y;
        } else if (rectangle2.y > rectangle.y) {
            this.newScrollPt.y = rectangle.y;
        } else if (rectangle2.y + rectangle2.height < rectangle.y + rectangle.height) {
            this.newScrollPt.y += rectangle.y + rectangle.height - (rectangle2.y + rectangle2.height);
        }
        this.parentViewport.setViewPosition(this.newScrollPt);
    }

    public void remove(ObjectNode objectNode) {
        objectNode.getNode().updateRecStatus(3);
        this.visibleObjectNodes.removeElement(objectNode);
        this.componentNode.setVisible(false);
    }

    public void free() {
        PropertySystem.removePropertyListener(123, this);
        PropertySystem.removePropertyListener(122, this);
        PropertySystem.removePropertyListener(137, this);
        PropertySystem.removePropertyListener(136, this);
        PropertySystem.removePropertyListener(135, this);
        PropertySystem.removePropertyListener(127, this);
        PropertySystem.removePropertyListener(138, this);
    }

    protected void refreshEdgeReturns() {
        int n = 0;
        int n2 = this.visibleEdges.size();
        Vector vector = null;
        EdgeGroup edgeGroup = null;
        this.edgeReturns.removeAllElements();
        while (n < n2) {
            edgeGroup = (EdgeGroup)this.visibleEdges.elementAt(n);
            if (edgeGroup.valid()) {
                int n3 = 0;
                int n4 = 0;
                vector = edgeGroup.getEdges();
                n4 = vector.size();
                n3 = 0;
                while (n3 < n4) {
                    try {
                        if (((Edge)vector.elementAt(n3)).getReturnNode() != null && ((Edge)vector.elementAt(n3)).valid()) {
                            this.edgeReturns.addElement(new EdgeReturnDisplayRec((Edge)vector.elementAt(n3), edgeGroup));
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    ++n3;
                }
            }
            ++n;
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.componentNode.setLocation(mouseEvent.getX(), mouseEvent.getY());
    }

    public VisioPanel() {
        this.initialize();
    }
}

