/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.avalon.gui;

import com.ibm.nzna.projects.common.quest.oa.ConditionTerm;
import com.ibm.nzna.projects.common.quest.oa.Conditions;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.FontSystem;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.util.QuestUtil;
import com.ibm.nzna.projects.qit.avalon.base.ConditionTermDisplayRec;
import com.ibm.nzna.projects.qit.avalon.gui.ConditionDlg;
import com.ibm.nzna.projects.qit.avalon.gui.ConditionDlgListener;
import com.ibm.nzna.projects.qit.gui.JTitle;
import com.ibm.nzna.shared.gui.ButtonPanel;
import com.ibm.nzna.shared.gui.HotLinkLabel;
import com.ibm.nzna.shared.gui.MultiList;
import com.ibm.nzna.shared.gui.ToolBarSeparator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JPanel;

public class ConditionList
extends JPanel
implements ActionListener,
ConditionDlgListener,
AppConst {
    private static final String[] condTitles = new String[]{Str.getStr(354), Str.getStr(8), Str.getStr(987)};
    private JTitle st_TITLE = new JTitle(Str.getStr(972));
    private MultiList cnr_CONDITIONS = new MultiList(GUISystem.getFontUtil());
    private ButtonPanel buttonPanel = new ButtonPanel();
    private HotLinkLabel pb_UP = new HotLinkLabel(Str.getStr(1044));
    private HotLinkLabel pb_DOWN = new HotLinkLabel(Str.getStr(1045));
    private HotLinkLabel pb_ADD = new HotLinkLabel(Str.getStr(95));
    private HotLinkLabel pb_REMOVE = new HotLinkLabel(Str.getStr(96));
    private HotLinkLabel pb_EDIT = new HotLinkLabel(Str.getStr(50));
    private Conditions conditions = null;

    public void doLayout() {
        Dimension dimension = this.getSize();
        int n = 0;
        int n2 = 0;
        int n3 = GUISystem.getRowHeight();
        this.st_TITLE.setBounds(n, n2, dimension.width, n3);
        this.cnr_CONDITIONS.setBounds(n, n2 += n3, dimension.width, dimension.height - n3 * 2 - 5);
        this.buttonPanel.setBounds(n, n2 += dimension.height - n3 * 2 - 3, dimension.width, n3);
    }

    public void setConditions(Conditions conditions) {
        this.conditions = conditions;
        this.refreshList();
    }

    private void refreshList() {
        Vector vector;
        this.cnr_CONDITIONS.removeAll();
        if (this.conditions != null && (vector = ConditionTermDisplayRec.convert(this.conditions.getConditionTerms())) != null) {
            this.cnr_CONDITIONS.add(vector);
        }
    }

    public Conditions saveConditions() {
        if (this.conditions != null) {
            Vector vector = QuestUtil.getDataFromDisplay(this.cnr_CONDITIONS.getData());
            this.conditions.clear();
            if (vector != null) {
                int n = 0;
                while (n < vector.size()) {
                    this.conditions.addTerm((ConditionTerm)vector.elementAt(n));
                    ++n;
                }
            }
        }
        return this.conditions;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.pb_UP) {
            this.moveConditionInList((ConditionTermDisplayRec)this.cnr_CONDITIONS.getSelectedItem(), false);
        } else if (actionEvent.getSource() == this.pb_DOWN) {
            this.moveConditionInList((ConditionTermDisplayRec)this.cnr_CONDITIONS.getSelectedItem(), true);
        } else if (actionEvent.getSource() == this.pb_ADD) {
            this.addCondition();
        } else if (actionEvent.getSource() == this.pb_REMOVE) {
            this.removeCondition();
        } else if (actionEvent.getSource() == this.pb_EDIT) {
            this.editCondition();
        }
    }

    public void addCondition() {
        if (this.conditions != null) {
            new ConditionDlg(GUISystem.getParentDefWin(this)).setConditionDlgListener(this);
        }
    }

    public void removeCondition() {
        Vector vector = this.cnr_CONDITIONS.getSelection();
        if (vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                this.removeCondition((ConditionTermDisplayRec)vector.elementAt(n));
                ++n;
            }
        }
    }

    private void editCondition() {
        Vector vector = this.cnr_CONDITIONS.getSelection();
        if (vector != null && vector.size() > 0) {
            new ConditionDlg(GUISystem.getParentDefWin(this), (ConditionTermDisplayRec)vector.elementAt(0)).setConditionDlgListener(this);
        } else {
            GUISystem.printBox(7, 358);
        }
    }

    private void removeCondition(ConditionTermDisplayRec conditionTermDisplayRec) {
        if (conditionTermDisplayRec != null) {
            this.cnr_CONDITIONS.remove(conditionTermDisplayRec);
        }
    }

    public void conditionDlgClosed(ConditionTerm conditionTerm, boolean bl) {
        if (conditionTerm != null) {
            if (bl) {
                this.conditions.addTerm(conditionTerm);
                this.cnr_CONDITIONS.add(new ConditionTermDisplayRec(conditionTerm));
            } else {
                this.revalidate();
            }
        }
    }

    public void moveConditionInList(ConditionTermDisplayRec conditionTermDisplayRec, boolean bl) {
        Vector vector = this.cnr_CONDITIONS.getData();
        int n = vector.indexOf(conditionTermDisplayRec);
        n = bl ? ++n : --n;
        if (n >= 0 && n < vector.size()) {
            vector.removeElement(conditionTermDisplayRec);
            this.cnr_CONDITIONS.removeAll();
            vector.insertElementAt(conditionTermDisplayRec, n);
            this.cnr_CONDITIONS.add(vector);
            this.cnr_CONDITIONS.setSelectedItem(conditionTermDisplayRec, true);
        }
    }

    public void clear() {
        this.cnr_CONDITIONS.removeAll();
        this.conditions = null;
    }

    public Conditions getConditions() {
        return this.conditions;
    }

    public void setEnabled(boolean bl) {
        this.cnr_CONDITIONS.setEnabled(bl);
        this.pb_UP.setEnabled(bl);
        this.pb_DOWN.setEnabled(bl);
        this.pb_ADD.setEnabled(bl);
        this.pb_REMOVE.setEnabled(bl);
        this.pb_EDIT.setEnabled(bl);
    }

    public ConditionList() {
        this.pb_UP.setOpaque(false);
        this.pb_DOWN.setOpaque(false);
        this.pb_EDIT.setOpaque(false);
        this.st_TITLE.setFont(FontSystem.smallTitleFont);
        this.buttonPanel.setBorder(GUISystem.grayBorder);
        this.buttonPanel.setBackground(new Color(230, 230, 230));
        this.buttonPanel.setArrowImage(ImageSystem.getImageIcon((Object)this, 146), ImageSystem.getImageIcon((Object)this, 147));
        this.setOpaque(false);
        this.cnr_CONDITIONS.setBorder(GUISystem.blackBorder);
        this.cnr_CONDITIONS.setColumnHeadings(condTitles);
        this.cnr_CONDITIONS.setColumnWidth(0, 50);
        this.cnr_CONDITIONS.setColumnWidth(1, 150);
        this.cnr_CONDITIONS.setColumnWidth(2, 150);
        this.pb_UP.addActionListener(this);
        this.pb_DOWN.addActionListener(this);
        this.pb_ADD.addActionListener(this);
        this.pb_REMOVE.addActionListener(this);
        this.pb_EDIT.addActionListener(this);
        this.setLayout(null);
        this.add(this.st_TITLE);
        this.add(this.cnr_CONDITIONS);
        this.add(this.buttonPanel);
        this.buttonPanel.add(this.pb_ADD);
        this.buttonPanel.add(new ToolBarSeparator(new Dimension(1, GUISystem.getRowHeight())));
        this.buttonPanel.add(this.pb_EDIT);
        this.buttonPanel.add(new ToolBarSeparator(new Dimension(1, GUISystem.getRowHeight())));
        this.buttonPanel.add(this.pb_REMOVE);
        this.buttonPanel.add(new ToolBarSeparator(new Dimension(1, GUISystem.getRowHeight())));
        this.buttonPanel.add(this.pb_UP);
        this.buttonPanel.add(new ToolBarSeparator(new Dimension(1, GUISystem.getRowHeight())));
        this.buttonPanel.add(this.pb_DOWN);
    }
}

