/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.bookmark;

import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.bookmark.Bookmark;
import com.ibm.nzna.projects.qit.bookmark.BookmarkSystem;
import com.ibm.nzna.projects.qit.bookmark.BookmarkTreeCellRenderer;
import com.ibm.nzna.projects.qit.gui.SingleEntryDlg;
import com.ibm.nzna.shared.gui.ButtonPanel;
import com.ibm.nzna.shared.gui.DButton;
import com.ibm.nzna.shared.gui.DTree;
import com.ibm.nzna.shared.gui.StringTreeNode;
import com.ibm.nzna.shared.util.WinUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.tree.DefaultTreeModel;

public class AddBookmarkDlg
extends JDialog
implements ActionListener,
AppConst {
    private JLabel st_IMAGE = null;
    private JLabel st_DESCRIPT = null;
    private JTextField ef_DESCRIPT = null;
    private JLabel st_FOLDER = null;
    private DTree cnr_TREE = null;
    private ButtonPanel buttonPanel = null;
    private JScrollPane scrollPane = null;
    private DButton pb_OK = null;
    private DButton pb_CREATEFOLDER = null;
    private DButton pb_CANCEL = null;
    private JCheckBox ck_USE_FOLDER_FOR_MULTIPLE = null;
    private boolean move = false;
    private Bookmark bookmark = null;
    private ImageIcon wizardImage = null;
    private StringTreeNode initialSelectNode = null;
    private String folderUsed = null;
    private boolean multiple = false;

    private void initialize() {
        Container container = this.getContentPane();
        this.wizardImage = ImageSystem.getImageIcon((Object)this, 157);
        this.st_IMAGE = new JLabel(this.wizardImage);
        this.st_DESCRIPT = new JLabel(Str.getStr(100));
        this.st_FOLDER = new JLabel(Str.getStr(1024));
        this.ef_DESCRIPT = new JTextField(this.bookmark.getDescript());
        this.cnr_TREE = new DTree();
        this.scrollPane = new JScrollPane(this.cnr_TREE);
        this.buttonPanel = new ButtonPanel();
        this.pb_OK = new DButton(Str.getStr(1));
        this.pb_CANCEL = new DButton(Str.getStr(2));
        this.pb_CREATEFOLDER = new DButton(Str.getStr(1018));
        this.ck_USE_FOLDER_FOR_MULTIPLE = new JCheckBox(Str.getStr(1298));
        this.pb_OK.addActionListener(this);
        this.pb_CANCEL.addActionListener(this);
        this.pb_CREATEFOLDER.addActionListener(this);
        container.setLayout(null);
        this.buttonPanel.add(this.pb_OK);
        this.buttonPanel.add(this.pb_CANCEL);
        this.buttonPanel.add(this.pb_CREATEFOLDER);
        container.add(this.st_IMAGE);
        container.add(this.st_DESCRIPT);
        container.add(this.ef_DESCRIPT);
        container.add(this.st_FOLDER);
        container.add(this.scrollPane);
        container.add(this.ck_USE_FOLDER_FOR_MULTIPLE);
        container.add(this.buttonPanel);
        GUISystem.setPropertiesOnPanel(container);
        this.cnr_TREE.setCellRenderer(new BookmarkTreeCellRenderer());
        this.st_IMAGE.setBorder(GUISystem.loweredBorder);
        this.refreshBookmarkList();
        this.ck_USE_FOLDER_FOR_MULTIPLE.setEnabled(this.multiple);
        if (this.initialSelectNode != null) {
            WinUtil.selectTreeNode(this.cnr_TREE, this.initialSelectNode);
        }
        ((Component)this).setSize(495, 325);
        WinUtil.centerWindow(this);
        ((Component)this).setVisible(true);
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        int n = this.wizardImage.getImage().getWidth(this) + 10;
        int n2 = (dimension.height - 40) / 2 - this.wizardImage.getImage().getHeight(this) / 2;
        int n3 = GUISystem.getRowHeight();
        super.doLayout();
        this.st_IMAGE.setBounds(5, n2, this.wizardImage.getImage().getWidth(this), this.wizardImage.getImage().getHeight(this));
        this.st_DESCRIPT.setBounds(n, n2, dimension.width - n - 10, n3);
        this.ef_DESCRIPT.setBounds(n, n2 += n3, dimension.width - n - 10, n3);
        this.st_FOLDER.setBounds(n, n2 += n3 + 5, dimension.width - n - 10, n3);
        this.scrollPane.setBounds(n, n2 += n3, dimension.width - n - 10, dimension.height - n2 - 87 - n3);
        this.ck_USE_FOLDER_FOR_MULTIPLE.setBounds(n, this.scrollPane.getSize().height + this.scrollPane.getLocation().y + 5, dimension.width - n - 10, n3);
        this.buttonPanel.setBounds(n, dimension.height - 78, dimension.width - n, 25);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.pb_CANCEL) {
            this.dispose();
            this.folderUsed = null;
        } else if (actionEvent.getSource() == this.pb_OK) {
            if (this.move) {
                this.move();
            } else {
                this.add();
            }
            if (this.ck_USE_FOLDER_FOR_MULTIPLE.isSelected()) {
                this.folderUsed = PropertySystem.getString(58);
            }
            ((Component)this).setVisible(false);
        } else if (actionEvent.getSource() == this.pb_CREATEFOLDER) {
            this.createFolder();
        }
    }

    private void refreshBookmarkList() {
        DefaultTreeModel defaultTreeModel = null;
        StringTreeNode stringTreeNode = null;
        Vector vector = BookmarkSystem.getFolders();
        String string = PropertySystem.getString(58);
        stringTreeNode = new StringTreeNode(BookmarkSystem.getRootFolderName());
        defaultTreeModel = new DefaultTreeModel(stringTreeNode);
        this.insertBookmarkFolder(defaultTreeModel, stringTreeNode, BookmarkSystem.getRootFolder(), string);
        this.cnr_TREE.setModel(defaultTreeModel);
        this.cnr_TREE.setRootVisible(false);
        this.cnr_TREE.expandRow(0);
    }

    private void insertBookmarkFolder(DefaultTreeModel defaultTreeModel, StringTreeNode stringTreeNode, Bookmark bookmark, String string) {
        Vector vector = BookmarkSystem.getFolders(bookmark.getDescript());
        StringTreeNode stringTreeNode2 = stringTreeNode;
        stringTreeNode = new StringTreeNode(bookmark.getDescript(), bookmark);
        stringTreeNode2.add(stringTreeNode);
        if (string != null && bookmark.getDescript().equals(string)) {
            this.initialSelectNode = stringTreeNode;
        }
        if (vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                this.insertBookmarkFolder(defaultTreeModel, stringTreeNode, (Bookmark)vector.elementAt(n), string);
                ++n;
            }
        }
    }

    private void createFolder() {
        StringTreeNode stringTreeNode = null;
        try {
            Bookmark bookmark = BookmarkSystem.getRootFolder();
            Bookmark bookmark2 = new Bookmark();
            String string = new SingleEntryDlg(WinUtil.getParentFrame(this), Str.getStr(100), Str.getStr(100), "", "").getResult();
            try {
                stringTreeNode = (StringTreeNode)this.cnr_TREE.getSelectionPath().getLastPathComponent();
            }
            catch (Exception exception) {
                stringTreeNode = null;
            }
            if (string != null && string.length() > 0) {
                if (stringTreeNode != null) {
                    bookmark = (Bookmark)stringTreeNode.getData();
                }
                if (!bookmark.isFolder()) {
                    bookmark = BookmarkSystem.getBookmark(bookmark.getDescript());
                }
                if (BookmarkSystem.getBookmark(string) == null) {
                    bookmark2.setDescript(string);
                    bookmark2.setParentFolder(bookmark.getDescript());
                    bookmark2.updateRecStatus(2);
                    BookmarkSystem.addBookmark(bookmark2);
                    this.refreshBookmarkList();
                } else {
                    GUISystem.printBox(WinUtil.getParentFrame(this), Str.getStr(7), Str.getStr(1019));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void add() {
        StringTreeNode stringTreeNode = null;
        Bookmark bookmark = null;
        String string = this.ef_DESCRIPT.getText();
        try {
            stringTreeNode = (StringTreeNode)this.cnr_TREE.getSelectionPath().getLastPathComponent();
        }
        catch (Exception exception) {
            stringTreeNode = null;
        }
        if (string != null && string.length() > 0) {
            if (BookmarkSystem.getBookmark(string) == null) {
                bookmark = stringTreeNode == null ? BookmarkSystem.getRootFolder() : (Bookmark)stringTreeNode.getData();
                this.bookmark.setParentFolder(bookmark.getDescript());
                this.bookmark.updateRecStatus(2);
                this.bookmark.setDescript(string);
                PropertySystem.put(58, bookmark.getDescript());
                BookmarkSystem.addBookmark(this.bookmark);
            } else {
                GUISystem.printBox(WinUtil.getParentFrame(this), Str.getStr(7), Str.getStr(1019));
            }
        } else {
            GUISystem.printBox(WinUtil.getParentFrame(this), Str.getStr(7), Str.getStr(411));
        }
    }

    private void move() {
        StringTreeNode stringTreeNode = null;
        Bookmark bookmark = null;
        String string = this.ef_DESCRIPT.getText();
        try {
            stringTreeNode = (StringTreeNode)this.cnr_TREE.getSelectionPath().getLastPathComponent();
        }
        catch (Exception exception) {
            stringTreeNode = null;
        }
        if (string != null && string.length() > 0) {
            bookmark = stringTreeNode == null ? BookmarkSystem.getRootFolder() : (Bookmark)stringTreeNode.getData();
            PropertySystem.put(58, bookmark.getDescript());
            this.bookmark.setParentFolder(bookmark.getDescript());
            this.bookmark.updateRecStatus(1);
            this.bookmark.setDescript(string);
            BookmarkSystem.updateBookmark(this.bookmark);
        } else {
            GUISystem.printBox(WinUtil.getParentFrame(this), Str.getStr(7), Str.getStr(411));
        }
    }

    public String getFolderUsed() {
        return this.folderUsed;
    }

    public AddBookmarkDlg(Frame frame, Bookmark bookmark) {
        super(frame, Str.getStr(1023), true);
        this.bookmark = bookmark;
        this.initialize();
    }

    public AddBookmarkDlg(Frame frame, Bookmark bookmark, boolean bl) {
        super(frame, Str.getStr(1023), true);
        this.bookmark = bookmark;
        this.move = bl;
        this.initialize();
    }

    public AddBookmarkDlg(Frame frame, Bookmark bookmark, boolean bl, boolean bl2) {
        super(frame, Str.getStr(1023), true);
        this.bookmark = bookmark;
        this.move = bl;
        this.multiple = bl2;
        this.initialize();
    }
}

