/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.bookmark;

import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserRec;
import com.ibm.nzna.projects.qit.bookmark.Bookmark;
import com.ibm.nzna.projects.qit.bookmark.BookmarkDlgListener;
import com.ibm.nzna.projects.qit.bookmark.BookmarkSystem;
import com.ibm.nzna.projects.qit.bookmark.BookmarkTree;
import com.ibm.nzna.projects.qit.gui.SelectUserDlg;
import com.ibm.nzna.projects.qit.gui.SingleEntryDlg;
import com.ibm.nzna.shared.gui.ButtonPanel;
import com.ibm.nzna.shared.gui.DButton;
import com.ibm.nzna.shared.gui.StringTreeNode;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.WinUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

public class BookmarkDlg
extends JDialog
implements ActionListener,
AppConst {
    private JLabel st_IMAGE = null;
    private JScrollPane scrollPane = null;
    private BookmarkTree cnr_TREE = null;
    private ButtonPanel buttonPanel = null;
    private DButton pb_EDIT = null;
    private DButton pb_DELETE = null;
    private DButton pb_CANCEL = null;
    private DButton pb_CREATEFOLDER = null;
    private DButton pb_MOVE = null;
    private DButton pb_SELECT = null;
    private DButton pb_SEND = null;
    private ImageIcon wizardImage = null;
    private BookmarkDlgListener listener = null;
    private Vector selectedVec = null;

    private void initializeAndShow() {
        Container container = this.getContentPane();
        this.wizardImage = ImageSystem.getImageIcon((Object)this, 157);
        this.st_IMAGE = new JLabel(this.wizardImage);
        this.cnr_TREE = new BookmarkTree();
        this.scrollPane = new JScrollPane(this.cnr_TREE);
        this.pb_DELETE = new DButton(Str.getStr(172));
        this.pb_EDIT = new DButton(Str.getStr(50));
        this.pb_CANCEL = new DButton(Str.getStr(28));
        this.pb_CREATEFOLDER = new DButton(Str.getStr(1018));
        this.pb_MOVE = new DButton(Str.getStr(1037));
        this.pb_SELECT = new DButton(Str.getStr(404));
        this.pb_SEND = new DButton(Str.getStr(516));
        this.buttonPanel = new ButtonPanel();
        this.buttonPanel.add(this.pb_SELECT);
        this.buttonPanel.add(this.pb_CREATEFOLDER);
        this.buttonPanel.add(this.pb_EDIT);
        this.buttonPanel.add(this.pb_DELETE);
        this.buttonPanel.add(this.pb_MOVE);
        this.buttonPanel.add(this.pb_CANCEL);
        container.setLayout(null);
        container.add(this.st_IMAGE);
        container.add(this.scrollPane);
        container.add(this.buttonPanel);
        this.pb_EDIT.addActionListener(this);
        this.pb_DELETE.addActionListener(this);
        this.pb_CANCEL.addActionListener(this);
        this.pb_CREATEFOLDER.addActionListener(this);
        this.pb_MOVE.addActionListener(this);
        this.pb_SELECT.addActionListener(this);
        this.pb_SEND.addActionListener(this);
        this.st_IMAGE.setBorder(GUISystem.loweredBorder);
        GUISystem.setPropertiesOnPanel(container);
        ((Component)this).setSize(680, 325);
        WinUtil.centerWindow(this);
        ((Component)this).setVisible(true);
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        int n = this.wizardImage.getImage().getWidth(this) + 10;
        int n2 = (dimension.height - 40) / 2 - this.wizardImage.getImage().getHeight(this) / 2;
        super.doLayout();
        this.st_IMAGE.setBounds(5, n2, this.wizardImage.getImage().getWidth(this), this.wizardImage.getImage().getHeight(this));
        this.scrollPane.setBounds(n, n2, dimension.width - n - 10, dimension.height - 95);
        this.buttonPanel.setBounds(n, dimension.height - 78, dimension.width - n, 25);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Vector vector;
        if (actionEvent.getSource() == this.pb_CANCEL) {
            this.dispose();
        } else if (actionEvent.getSource() == this.pb_EDIT) {
            this.edit();
        } else if (actionEvent.getSource() == this.pb_CREATEFOLDER) {
            this.createFolder();
        } else if (actionEvent.getSource() == this.pb_DELETE) {
            this.delete();
        } else if (actionEvent.getSource() == this.pb_MOVE) {
            this.move();
        } else if (actionEvent.getSource() == this.pb_SELECT) {
            if (this.performSelect()) {
                this.dispose();
                this.notifyBookmarkDlgListener();
            }
        } else if (actionEvent.getSource() == this.pb_SEND && this.performSelect() && (vector = new SelectUserDlg((Frame)GUISystem.getParentDefWin(this), false).getResult()) != null && vector.size() > 0) {
            BookmarkSystem.sendBookmarks(this.selectedVec, (UserRec)vector.elementAt(0));
        }
    }

    private void edit() {
        try {
            String string;
            Bookmark bookmark;
            StringTreeNode stringTreeNode = (StringTreeNode)this.cnr_TREE.getSelectionPath().getLastPathComponent();
            if (stringTreeNode != null && !(bookmark = (Bookmark)stringTreeNode.getData()).getDescript().equals(BookmarkSystem.getRootFolderName()) && (string = new SingleEntryDlg(WinUtil.getParentFrame(this), Str.getStr(100), Str.getStr(100), bookmark.getDescript(), "").getResult()) != null && string.length() > 0) {
                if (BookmarkSystem.getBookmark(string) == null) {
                    bookmark.setDescript(string);
                    bookmark.updateRecStatus(1);
                } else {
                    GUISystem.printBox(WinUtil.getParentFrame(this), Str.getStr(7), Str.getStr(1019));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.repaint();
    }

    private void createFolder() {
        try {
            StringTreeNode stringTreeNode = (StringTreeNode)this.cnr_TREE.getSelectionPath().getLastPathComponent();
            Bookmark bookmark = BookmarkSystem.getRootFolder();
            Bookmark bookmark2 = new Bookmark();
            String string = new SingleEntryDlg(WinUtil.getParentFrame(this), Str.getStr(100), Str.getStr(100), "", "").getResult();
            if (string != null && string.length() > 0) {
                if (stringTreeNode != null) {
                    bookmark = (Bookmark)stringTreeNode.getData();
                }
                if (!bookmark.isFolder()) {
                    bookmark = BookmarkSystem.getBookmark(bookmark.getParentFolder());
                }
                if (BookmarkSystem.getBookmark(string) == null) {
                    bookmark2.setDescript(string);
                    bookmark2.setParentFolder(bookmark.getDescript());
                    bookmark2.updateRecStatus(2);
                    BookmarkSystem.addBookmark(bookmark2);
                } else {
                    GUISystem.printBox(WinUtil.getParentFrame(this), Str.getStr(7), Str.getStr(1019));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void delete() {
        try {
            StringTreeNode stringTreeNode = (StringTreeNode)this.cnr_TREE.getSelectionPath().getLastPathComponent();
            if (stringTreeNode != null) {
                Bookmark bookmark = (Bookmark)stringTreeNode.getData();
                boolean bl = false;
                if (!bookmark.getDescript().equals(BookmarkSystem.getRootFolderName())) {
                    bl = bookmark.isFolder() ? GUISystem.printBox(WinUtil.getParentFrame(this), Str.getStr(8), Str.getStr(1021)) : GUISystem.printBox(WinUtil.getParentFrame(this), Str.getStr(8), Str.getStr(1022));
                    if (bl) {
                        int[] nArray = this.cnr_TREE.getSelectionRows();
                        Vector<Bookmark> vector = new Vector<Bookmark>(1, 1);
                        int n = 0;
                        while (n < nArray.length) {
                            stringTreeNode = (StringTreeNode)this.cnr_TREE.getPathForRow(nArray[n]).getLastPathComponent();
                            bookmark = (Bookmark)stringTreeNode.getData();
                            bookmark.updateRecStatus(3);
                            vector.addElement(bookmark);
                            ++n;
                        }
                        BookmarkSystem.removeBookmarks(vector);
                    }
                } else {
                    GUISystem.printBox(WinUtil.getParentFrame(this), Str.getStr(7), Str.getStr(1020));
                }
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
        }
    }

    private void move() {
        try {
            StringTreeNode stringTreeNode = (StringTreeNode)this.cnr_TREE.getSelectionPath().getLastPathComponent();
            if (stringTreeNode != null) {
                Bookmark bookmark = (Bookmark)stringTreeNode.getData();
                boolean bl = false;
                int[] nArray = this.cnr_TREE.getSelectionRows();
                Vector<Bookmark> vector = new Vector<Bookmark>(nArray.length);
                int n = 0;
                while (n < nArray.length) {
                    bookmark = (Bookmark)((StringTreeNode)this.cnr_TREE.getPathForRow(nArray[n]).getLastPathComponent()).getData();
                    if (!bookmark.getDescript().equals(BookmarkSystem.getRootFolderName())) {
                        vector.addElement(bookmark);
                    } else {
                        GUISystem.printBox(WinUtil.getParentFrame(this), Str.getStr(7), Str.getStr(1020));
                    }
                    ++n;
                }
                BookmarkSystem.guiMoveBookmarks(vector);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setBookmarkDlgListener(BookmarkDlgListener bookmarkDlgListener) {
        this.listener = bookmarkDlgListener;
    }

    private void notifyBookmarkDlgListener() {
        if (this.listener != null) {
            this.listener.bookmarkSelected(this.selectedVec);
        }
    }

    private boolean performSelect() {
        int[] nArray = this.cnr_TREE.getSelectionRows();
        this.selectedVec = null;
        if (nArray != null && nArray.length > 0) {
            StringTreeNode stringTreeNode = null;
            this.selectedVec = new Vector(nArray.length);
            int n = 0;
            while (n < nArray.length) {
                stringTreeNode = (StringTreeNode)this.cnr_TREE.getPathForRow(nArray[n]).getLastPathComponent();
                if (stringTreeNode != null) {
                    this.addSelectedItem((Bookmark)stringTreeNode.getData());
                }
                ++n;
            }
        }
        return this.selectedVec != null;
    }

    private void addSelectedItem(Bookmark bookmark) {
        if (bookmark != null) {
            if (!bookmark.isFolder()) {
                this.selectedVec.addElement(bookmark);
            } else {
                Vector vector = BookmarkSystem.getBookmarks(bookmark.getDescript());
                if (vector != null && vector.size() > 0) {
                    int n = 0;
                    int n2 = vector.size();
                    while (n < n2) {
                        this.addSelectedItem((Bookmark)vector.elementAt(n));
                        ++n;
                    }
                }
            }
        }
    }

    public BookmarkDlg(Frame frame) {
        super(frame, Str.getStr(1017), true);
        this.initializeAndShow();
    }

    public BookmarkDlg(Frame frame, BookmarkDlgListener bookmarkDlgListener) {
        super(frame, Str.getStr(1017), true);
        this.setBookmarkDlgListener(bookmarkDlgListener);
        this.initializeAndShow();
    }
}

