/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.bookmark;

import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.bookmark.Bookmark;
import com.ibm.nzna.projects.qit.bookmark.BookmarkListener;
import com.ibm.nzna.projects.qit.bookmark.BookmarkSystem;
import com.ibm.nzna.projects.qit.gui.NavList;
import com.ibm.nzna.projects.qit.gui.NavListExpandListener;
import com.ibm.nzna.projects.qit.gui.NavListGroup;
import com.ibm.nzna.shared.gui.HotLinkLabel;
import com.ibm.nzna.shared.util.LogSystem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JPanel;

public class BookmarkHotLinkTree
extends JPanel
implements NavListExpandListener,
AppConst,
ActionListener,
BookmarkListener {
    private boolean folderOnly = false;
    private NavList navList = null;
    private Vector listeners = new Vector(1);

    private void refreshBookmarkList() {
        Object var1_1 = null;
        Vector vector = BookmarkSystem.getFolders();
        if (this.navList != null) {
            this.remove(this.navList);
        }
        this.navList = new NavList();
        this.navList.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.navList, "Center");
        this.insertBookmarkFolder(this.navList, BookmarkSystem.getRootFolder());
    }

    private void insertBookmarkFolder(JPanel jPanel, Bookmark bookmark) {
        try {
            int n;
            int n2;
            Vector vector = BookmarkSystem.getFolders(bookmark.getDescript());
            Vector vector2 = BookmarkSystem.getBookmarks(bookmark.getDescript());
            NavListGroup navListGroup = null;
            navListGroup = new NavListGroup(bookmark.getDescript(), ImageSystem.getImageIcon((Object)this, 140));
            jPanel.add(navListGroup);
            navListGroup.setExpandedIcon(ImageSystem.getImageIcon((Object)this, 139));
            navListGroup.setData(bookmark);
            navListGroup.addExpandListener(this);
            navListGroup.setOpaque(false);
            if (vector != null && vector.size() > 0) {
                n2 = 0;
                n = vector.size();
                while (n2 < n) {
                    this.insertBookmarkFolder(navListGroup, (Bookmark)vector.elementAt(n2));
                    ++n2;
                }
            }
            if (!this.folderOnly && vector2 != null && vector2.size() > 0) {
                n2 = 0;
                n = vector2.size();
                HotLinkLabel hotLinkLabel = null;
                while (n2 < n) {
                    if (!((Bookmark)vector2.elementAt(n2)).isFolder()) {
                        hotLinkLabel = new HotLinkLabel(((Bookmark)vector2.elementAt(n2)).getDescript(), ((Bookmark)vector2.elementAt(n2)).getIcon(), 0, vector2.elementAt(n2));
                        navListGroup.add(hotLinkLabel);
                        hotLinkLabel.setOpaque(false);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
        }
    }

    public void finalize() {
        try {
            super.finalize();
            BookmarkSystem.removeBookmarkListener(this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void bookmarkAdded(Bookmark bookmark) {
        this.refreshBookmarkList();
    }

    public void bookmarkRemoved(Bookmark bookmark) {
        this.refreshBookmarkList();
    }

    public void setFolderOnly(boolean bl) {
        this.folderOnly = bl;
        this.refreshBookmarkList();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof HotLinkLabel && this.listeners != null) {
            ActionEvent actionEvent2 = new ActionEvent(((HotLinkLabel)actionEvent.getSource()).getData(), 0, "Bookmark");
            int n = 0;
            int n2 = this.listeners.size();
            while (n < n2) {
                ((ActionListener)this.listeners.elementAt(n)).actionPerformed(actionEvent2);
                ++n;
            }
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.listeners.addElement(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listeners.removeElement(actionListener);
    }

    public void expanded(NavListGroup navListGroup, boolean bl) {
        if (bl && this.listeners != null) {
            ActionEvent actionEvent = new ActionEvent(navListGroup.getData(), 0, "Bookmark");
            int n = 0;
            int n2 = this.listeners.size();
            while (n < n2) {
                ((ActionListener)this.listeners.elementAt(n)).actionPerformed(actionEvent);
                ++n;
            }
        }
    }

    public BookmarkHotLinkTree() {
        BookmarkSystem.addBookmarkListener(this);
        this.refreshBookmarkList();
    }

    public BookmarkHotLinkTree(boolean bl) {
        this.folderOnly = bl;
        BookmarkSystem.addBookmarkListener(this);
        this.refreshBookmarkList();
    }
}

