/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.bookmark;

import com.ibm.nzna.projects.common.storedProc.StoredProcUtil;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.MainWindow;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserRec;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.bookmark.AddBookmarkDlg;
import com.ibm.nzna.projects.qit.bookmark.Bookmark;
import com.ibm.nzna.projects.qit.bookmark.BookmarkListener;
import com.ibm.nzna.projects.qit.bookmark.BookmarkThread;
import com.ibm.nzna.projects.qit.gui.StatusWin;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.util.FileUtil;
import com.ibm.nzna.shared.util.LogSystem;
import java.awt.Frame;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;

public class BookmarkSystem
implements AppConst {
    private static Vector bookmarks = null;
    private static Vector listeners = null;
    private static boolean newUser = true;
    private static BookmarkSystem instance = null;

    protected static void fireBookmarkRemoved(Bookmark bookmark) {
        if (listeners != null && listeners.size() > 0) {
            int n = 0;
            int n2 = listeners.size();
            while (n < n2) {
                ((BookmarkListener)listeners.elementAt(n)).bookmarkRemoved(bookmark);
                ++n;
            }
        }
    }

    public void finalize() {
        try {
            super.finalize();
            System.out.println("Bookmark System FINALIZED!");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected static void fireBookmarkAdded(Bookmark bookmark) {
        if (listeners != null && listeners.size() > 0) {
            int n = 0;
            int n2 = listeners.size();
            while (n < n2) {
                ((BookmarkListener)listeners.elementAt(n)).bookmarkAdded(bookmark);
                ++n;
            }
        }
    }

    public static Vector getBookmarks(String string) {
        Vector vector = new Vector(10, 1);
        int n = 0;
        int n2 = bookmarks.size();
        while (n < n2) {
            if (((Bookmark)bookmarks.elementAt(n)).getParentFolder() != null && ((Bookmark)bookmarks.elementAt(n)).getParentFolder().equals(string)) {
                vector.addElement(bookmarks.elementAt(n));
            }
            ++n;
        }
        return vector;
    }

    public static Vector getFolders(String string) {
        Vector vector = new Vector(10, 1);
        int n = 0;
        int n2 = bookmarks.size();
        while (n < n2) {
            if (((Bookmark)bookmarks.elementAt(n)).getParentFolder() != null && ((Bookmark)bookmarks.elementAt(n)).getParentFolder().equals(string) && ((Bookmark)bookmarks.elementAt(n)).isFolder()) {
                vector.addElement(bookmarks.elementAt(n));
            }
            ++n;
        }
        return vector;
    }

    public static Vector getFolders() {
        return BookmarkSystem.getFolders(BookmarkSystem.getRootFolderName());
    }

    public static String getRootFolderName() {
        return UserSystem.getLoggedUserRec().getName() + Str.getStr(1015);
    }

    public static Bookmark createFolder(String string) {
        return BookmarkSystem.createFolder(string, BookmarkSystem.getRootFolderName());
    }

    public static Bookmark createFolder(String string, String string2) {
        Bookmark bookmark = new Bookmark();
        bookmark.setDescript(string);
        bookmark.setParentFolder(string2);
        bookmark.updateRecStatus(2);
        BookmarkSystem.addBookmark(bookmark);
        return bookmark;
    }

    public static void addBookmark(Bookmark bookmark) {
        bookmarks.addElement(bookmark);
        new Thread((Runnable)new BookmarkThread(bookmark), "BA").start();
    }

    public static void addBookmarks(Vector vector) {
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            bookmarks.addElement(vector.elementAt(n2));
            BookmarkSystem.fireBookmarkAdded((Bookmark)vector.elementAt(n2));
            ++n2;
        }
        new Thread((Runnable)new BookmarkThread(null), "SA").start();
    }

    public static void removeBookmarks(Vector vector) {
        int n = vector.size();
        Bookmark bookmark = null;
        int n2 = 0;
        while (n2 < n) {
            bookmark = (Bookmark)vector.elementAt(n2);
            if (bookmark.isFolder()) {
                BookmarkSystem.removeAllBookmarksFromFolder(bookmark.getDescript());
            }
            bookmarks.removeElement(bookmark);
            BookmarkSystem.fireBookmarkRemoved(bookmark);
            ++n2;
        }
        new Thread((Runnable)new BookmarkThread(null), "SA").start();
    }

    public static void updateBookmark(Bookmark bookmark) {
        new Thread((Runnable)new BookmarkThread(bookmark), "BA").start();
    }

    public static void removeBookmark(Bookmark bookmark) {
        if (bookmark.isFolder()) {
            BookmarkSystem.removeFolder(bookmark.getDescript());
        } else {
            bookmarks.removeElement(bookmark);
            new Thread((Runnable)new BookmarkThread(bookmark), "BR").start();
        }
    }

    public static void removeFolder(String string) {
        BookmarkSystem.removeAllBookmarksFromFolder(string);
        bookmarks.removeElement(BookmarkSystem.getBookmark(string));
        new Thread((Runnable)new BookmarkThread(null), "BR").start();
    }

    private static void removeAllBookmarksFromFolder(String string) {
        int n = 0;
        Bookmark bookmark = null;
        while (n < bookmarks.size()) {
            bookmark = (Bookmark)bookmarks.elementAt(n);
            if (bookmark != null && bookmark.getParentFolder() != null) {
                if (bookmark.getParentFolder().equals(string) && bookmark.isFolder()) {
                    BookmarkSystem.removeAllBookmarksFromFolder(bookmark.getDescript());
                    bookmarks.removeElement(bookmark);
                    n = 0;
                } else if (bookmark.getParentFolder().equals(string)) {
                    bookmarks.removeElement(bookmarks.elementAt(n));
                    n = 0;
                }
            }
            ++n;
        }
    }

    public static void addBookmarkListener(BookmarkListener bookmarkListener) {
        if (listeners == null) {
            listeners = new Vector(1, 1);
        }
        if (listeners != null) {
            listeners.addElement(bookmarkListener);
        }
    }

    public static void removeBookmarkListener(BookmarkListener bookmarkListener) {
        if (listeners != null) {
            listeners.removeElement(bookmarkListener);
        }
    }

    public static boolean writeBookmarks() {
        boolean bl = false;
        SQLMethod sQLMethod = new SQLMethod(1, "BookmarkSystem.writeBookmarks", 5);
        try {
            PreparedStatement preparedStatement = null;
            String string = null;
            string = newUser ? "INSERT INTO QIT.USERDATA " + "( USERID, BOOKMARKS, DBUSER, CHANGEDTIME ) " + "values " + "( '" + UserSystem.getUserId() + "', " + "  ?, " + " '" + UserSystem.getUserId() + "', " + " CURRENT TIMESTAMP )" : "UPDATE QIT.USERDATA " + "SET BOOKMARKS         = ?, " + "    DBUSER            = '" + UserSystem.getUserId() + "', " + "    CHANGEDTIME       = CURRENT TIMESTAMP " + "WHERE USERID = '" + UserSystem.getUserId() + "'";
            if (string != null) {
                FileUtil.writeObjectToDisk("tempbookmark.ser", bookmarks);
                File file = new File("tempbookmark.ser");
                FileInputStream fileInputStream = new FileInputStream(file);
                byte[] byArray = FileUtil.readBytesFromFile("tempbookmark.ser");
                preparedStatement = sQLMethod.createPreparedStatement(string);
                preparedStatement.setBinaryStream(1, (InputStream)new ByteArrayInputStream(byArray), byArray.length);
                fileInputStream.close();
                FileUtil.deleteFile("tempbookmark.ser");
                preparedStatement.execute();
                preparedStatement.close();
                preparedStatement = null;
                bl = true;
            }
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception, false);
        }
        sQLMethod.close();
        return bl;
    }

    public static void readBookmarks() {
        Vector vector = BookmarkSystem.readBookmarks(UserSystem.getUserId());
        if (vector != null) {
            bookmarks = vector;
        } else {
            BookmarkSystem.createRootBookmark();
        }
    }

    public static Vector readBookmarks(String string) {
        SQLMethod sQLMethod = new SQLMethod(1, "BookmarkSystem.readBookmarks", 5);
        Vector vector = new Vector(1, 1);
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = null;
            resultSet = statement.executeQuery("SELECT USERID, BOOKMARKS " + "FROM QIT.USERDATA " + "WHERE USERID = '" + string + "'");
            if (resultSet.next()) {
                vector = (Vector)StoredProcUtil.getObjectFromResultSet(resultSet, 2);
                newUser = false;
            } else {
                newUser = true;
                BookmarkSystem.createRootBookmark();
            }
            resultSet.close();
            statement.close();
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception, false);
            newUser = false;
            vector = null;
        }
        if (vector != null && vector.size() < 1) {
            vector = null;
        }
        sQLMethod.close();
        return vector;
    }

    public static Bookmark getRootFolder() {
        Bookmark bookmark = null;
        int n = 0;
        int n2 = bookmarks.size();
        String string = BookmarkSystem.getRootFolderName();
        while (n < n2 && bookmark == null) {
            if (((Bookmark)bookmarks.elementAt(n)).getDescript().equals(string)) {
                bookmark = (Bookmark)bookmarks.elementAt(n);
            }
            ++n;
        }
        return bookmark;
    }

    public static Bookmark getBookmark(String string) {
        Bookmark bookmark = null;
        int n = 0;
        int n2 = bookmarks.size();
        while (n < n2 && bookmark == null) {
            if (((Bookmark)bookmarks.elementAt(n)).getDescript().equals(string)) {
                bookmark = (Bookmark)bookmarks.elementAt(n);
            }
            ++n;
        }
        return bookmark;
    }

    private static void createRootBookmark() {
        Bookmark bookmark = new Bookmark();
        Bookmark bookmark2 = null;
        LogSystem.log(1, "Creating ROOT Bookmarks");
        bookmark.setDescript(UserSystem.getLoggedUserRec().getName() + Str.getStr(1015));
        bookmarks = new Vector(1, 1);
        BookmarkSystem.addBookmark(bookmark);
        bookmark2 = new Bookmark();
        bookmark2.setDescript(Str.getStr(1062));
        bookmark2.setParentFolder(bookmark.getDescript());
        bookmark2.updateRecStatus(2);
        bookmarks.addElement(bookmark2);
        bookmark2 = new Bookmark();
        bookmark2.setDescript("eSupport");
        bookmark2.setObject("http://www.ibm.com/pc/support", 10);
        bookmark2.setParentFolder(Str.getStr(1062));
        bookmark2.updateRecStatus(2);
        bookmarks.addElement(bookmark2);
        bookmark2 = new Bookmark();
        bookmark2.setDescript("Business Partner");
        bookmark2.setObject("http://www.ibm.com/pc/support", 10);
        bookmark2.setParentFolder(Str.getStr(1062));
        bookmark2.updateRecStatus(2);
        bookmarks.addElement(bookmark2);
        bookmark2 = new Bookmark();
        bookmark2.setDescript("Info Tips");
        bookmark2.setObject("http://w3.pc.ibm.com/helpcenter/infotips", 10);
        bookmark2.setParentFolder(Str.getStr(1062));
        bookmark2.updateRecStatus(2);
        bookmarks.addElement(bookmark2);
        new Thread((Runnable)new BookmarkThread(bookmark2), "BA").start();
    }

    private static BookmarkSystem getInstance() {
        return instance;
    }

    public static void guiAddBookmarks(Vector vector) {
        int n = 0;
        int n2 = vector.size();
        Vector<Bookmark> vector2 = new Vector<Bookmark>(n2);
        String string = null;
        AddBookmarkDlg addBookmarkDlg = null;
        Bookmark bookmark = null;
        Frame frame = new Frame();
        while (n < n2) {
            bookmark = (Bookmark)vector.elementAt(n);
            if (string == null) {
                addBookmarkDlg = new AddBookmarkDlg(frame, bookmark, false, n2 > 1);
                string = addBookmarkDlg.getFolderUsed();
                addBookmarkDlg.dispose();
            } else {
                bookmark.setParentFolder(string);
                if (BookmarkSystem.getBookmark(bookmark.getDescript()) == null) {
                    vector2.addElement(bookmark);
                } else {
                    GUISystem.printBox(frame, Str.getStr(7), Str.getStr(1019));
                    new AddBookmarkDlg(frame, bookmark).dispose();
                }
            }
            ++n;
        }
        if (vector2.size() > 0) {
            BookmarkSystem.addBookmarks(vector2);
        }
        frame.dispose();
    }

    public static void guiMoveBookmarks(Vector vector) {
        int n = 0;
        int n2 = vector.size();
        Vector vector2 = new Vector(n2);
        String string = null;
        AddBookmarkDlg addBookmarkDlg = null;
        Bookmark bookmark = null;
        Frame frame = new Frame();
        while (n < n2) {
            bookmark = (Bookmark)vector.elementAt(n);
            if (string == null) {
                addBookmarkDlg = new AddBookmarkDlg(frame, bookmark, true, n2 > 1);
                string = addBookmarkDlg.getFolderUsed();
                addBookmarkDlg.dispose();
            } else {
                bookmark.setParentFolder(string);
            }
            BookmarkSystem.fireBookmarkAdded(bookmark);
            ++n;
        }
        new Thread((Runnable)new BookmarkThread(null), "SA").start();
        frame.dispose();
    }

    public static void sendBookmarks(Vector vector, UserRec userRec) {
        StatusWin statusWin = new StatusWin(MainWindow.getInstance());
        try {
            int n = 0;
            int n2 = vector.size();
            Vector vector2 = BookmarkSystem.readBookmarks(userRec.getUserId());
            Bookmark bookmark = null;
            statusWin.setText(Str.getStr(1579));
            while (n < n2) {
                bookmark = (Bookmark)((Bookmark)vector.elementAt(n)).clone();
                if (bookmark.isFolder()) {
                    // empty if block
                }
                ++n;
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            GUISystem.printBox(7, 202);
        }
        statusWin.dispose();
    }

    public BookmarkSystem() {
        if (instance == null) {
            instance = this;
        }
    }
}

