/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.customer.custedit;

import com.ibm.nzna.projects.common.quest.brand.Brands;
import com.ibm.nzna.projects.common.quest.type.TypeCategory;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.DataLengths;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.customer.CustomerMachineRec;
import com.ibm.nzna.shared.gui.DButton;
import com.ibm.nzna.shared.gui.MaskDocument;
import com.ibm.nzna.shared.util.WinUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class MachineDlg
extends JDialog
implements DataLengths,
AppConst,
ActionListener {
    private JLabel st_MACHINETYPE = null;
    private JLabel st_MODEL = null;
    private JLabel st_SERIALNUMBER = null;
    private JLabel st_BRAND = null;
    private JLabel st_FAMILY = null;
    private JLabel st_OPERATINGSYS = null;
    private JLabel st_MACHINENUM = null;
    private JLabel st_RECNUM = null;
    private JTextField ef_MACHINETYPE = null;
    private JTextField ef_MODEL = null;
    private JTextField ef_SERIALNUMBER = null;
    private JTextField ef_OPERATINGSYS = null;
    private JComboBox cb_BRAND = null;
    private JComboBox cb_FAMILY = null;
    private JCheckBox ck_DEFAULTMACH = null;
    private DButton pb_OK = null;
    private DButton pb_CANCEL = null;
    private CustomerMachineRec machineRec = null;

    public CustomerMachineRec getResult() {
        this.refreshData();
        ((Component)this).setVisible(true);
        return this.machineRec;
    }

    private void createControls() {
        Container container = this.getContentPane();
        this.st_MACHINETYPE = new JLabel(Str.getStr(340));
        this.st_MODEL = new JLabel(Str.getStr(341));
        this.st_SERIALNUMBER = new JLabel(Str.getStr(1551));
        this.st_BRAND = new JLabel(Str.getStr(145));
        this.st_FAMILY = new JLabel(Str.getStr(149));
        this.st_OPERATINGSYS = new JLabel(Str.getStr(1550));
        this.st_MACHINENUM = new JLabel(Str.getStr(1571));
        this.st_RECNUM = new JLabel(Str.getStr(1572));
        this.ef_MACHINETYPE = new JTextField(new MaskDocument(1, 4), "", 0);
        this.ef_MODEL = new JTextField(new MaskDocument(1, 3), "", 0);
        this.ef_SERIALNUMBER = new JTextField(new MaskDocument(0, 25), "", 0);
        this.ef_OPERATINGSYS = new JTextField(new MaskDocument(0, 12), "", 0);
        this.cb_BRAND = new JComboBox(Brands.getBrands());
        this.cb_FAMILY = new JComboBox(TypeCategory.getCategories("family"));
        this.pb_OK = new DButton(Str.getStr(1));
        this.pb_CANCEL = new DButton(Str.getStr(2));
        this.ck_DEFAULTMACH = new JCheckBox(Str.getStr(1573));
        container.setLayout(null);
        container.add(this.st_MACHINENUM);
        container.add(this.st_RECNUM);
        container.add(this.st_MACHINETYPE);
        container.add(this.ef_MACHINETYPE);
        container.add(this.st_MODEL);
        container.add(this.ef_MODEL);
        container.add(this.st_SERIALNUMBER);
        container.add(this.ef_SERIALNUMBER);
        container.add(this.st_OPERATINGSYS);
        container.add(this.ef_OPERATINGSYS);
        container.add(this.st_BRAND);
        container.add(this.cb_BRAND);
        container.add(this.st_FAMILY);
        container.add(this.cb_FAMILY);
        container.add(this.pb_OK);
        container.add(this.pb_CANCEL);
        this.pb_OK.addActionListener(this);
        this.pb_CANCEL.addActionListener(this);
    }

    public void doLayout() {
        int n = 0;
        int n2 = 0;
        int n3 = GUISystem.getRowHeight();
        Dimension dimension = this.getSize();
        super.doLayout();
        this.st_MACHINENUM.setBounds(n, n2, dimension.width, n3);
        this.st_RECNUM.setBounds(n, n2 += n3, dimension.width, n3);
        this.st_MACHINETYPE.setBounds(n, n2 += n3, 130, n3);
        this.ef_MACHINETYPE.setBounds(n + 130, n2, 130, n3);
        this.st_MODEL.setBounds(n, n2 += n3, 130, n3);
        this.ef_MODEL.setBounds(n + 130, n2, 130, n3);
        this.st_SERIALNUMBER.setBounds(n, n2 += n3, 130, n3);
        this.ef_SERIALNUMBER.setBounds(n + 130, n2, 130, n3);
        this.st_OPERATINGSYS.setBounds(n, n2 += n3, 130, n3);
        this.ef_OPERATINGSYS.setBounds(n + 130, n2, 130, n3);
        this.st_BRAND.setBounds(n, n2 += n3, 130, n3);
        this.cb_BRAND.setBounds(n + 130, n2, 130, n3);
        this.st_FAMILY.setBounds(n, n2 += n3, 130, n3);
        this.cb_FAMILY.setBounds(n + 130, n2, 130, n3);
        this.pb_OK.setBounds(n, n2 += n3 + 5, 70, 25);
        this.pb_CANCEL.setBounds(n + 75, n2, 80, 25);
    }

    private void refreshData() {
        this.st_MACHINENUM.setText(Str.getStr(340) + ": " + this.machineRec.getMachineNum());
        this.st_RECNUM.setText(Str.getStr(1572) + ": " + this.machineRec.getRecNum());
        this.ef_MACHINETYPE.setText(this.machineRec.getMachineType());
        this.ef_MODEL.setText(this.machineRec.getModel());
        this.ef_OPERATINGSYS.setText(this.machineRec.getOperatingSystem());
        this.ef_SERIALNUMBER.setText(this.machineRec.getSerialNumber());
        try {
            this.cb_BRAND.setSelectedItem(Brands.getBrand(this.machineRec.getBrand()));
            this.cb_FAMILY.setSelectedItem(Brands.getFamily(this.machineRec.getFamily()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.pb_OK) {
            if (this.saveData()) {
                this.dispose();
            }
        } else if (actionEvent.getSource() == this.pb_CANCEL) {
            this.machineRec = null;
            this.dispose();
        }
    }

    private boolean saveData() {
        boolean bl = false;
        String string = this.ef_MACHINETYPE.getText();
        String string2 = this.ef_MODEL.getText();
        String string3 = this.ef_OPERATINGSYS.getText();
        String string4 = this.ef_SERIALNUMBER.getText();
        String string5 = null;
        String string6 = null;
        String string7 = null;
        boolean bl2 = false;
        JComponent jComponent = null;
        if (this.cb_BRAND.getSelectedItem() != null) {
            string5 = this.cb_BRAND.getSelectedItem().toString();
        }
        if (this.cb_FAMILY.getSelectedItem() != null) {
            string6 = this.cb_FAMILY.getSelectedItem().toString();
        }
        if (string == null || string.length() == 0) {
            string7 = Str.getStr(740);
            jComponent = this.ef_MACHINETYPE;
        } else if (string2 == null || string2.length() == 0) {
            string7 = Str.getStr(741);
            jComponent = this.ef_MODEL;
        } else if (string3 == null || string3.length() == 0) {
            string7 = Str.getStr(1574);
            jComponent = this.ef_OPERATINGSYS;
        } else if (string5 == null || string5.length() == 0) {
            string7 = Str.getStr(466);
            jComponent = this.cb_BRAND;
        } else if (string6 == null || string6.length() == 0) {
            string7 = Str.getStr(467);
            jComponent = this.cb_FAMILY;
        }
        if (string7 != null) {
            GUISystem.printBox(Str.getStr(6), string7);
            ((Component)jComponent).requestFocus();
        } else {
            bl = true;
            this.machineRec.setMachineType(string);
            this.machineRec.setModel(string2);
            this.machineRec.setSerialNumber(string4);
            this.machineRec.setOperatingSystem(string3);
            this.machineRec.setBrand(string5);
            this.machineRec.setFamily(string6);
            this.machineRec.updateRecStatus(1);
        }
        return bl;
    }

    public MachineDlg(Frame frame, CustomerMachineRec customerMachineRec) {
        super(frame, Str.getStr(340), true);
        this.machineRec = customerMachineRec;
        this.createControls();
        ((Component)this).setSize(300, 210);
        WinUtil.centerChildInParent(this, frame);
    }
}

