/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.dbgui;

import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.PropertyListener;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.gui.AppDefaultWin;
import com.ibm.nzna.shared.db.Database;
import com.ibm.nzna.shared.db.DatabaseStatusListener;
import com.ibm.nzna.shared.db.DatabaseSystem;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class DBStatusLight
extends JComponent
implements PropertyListener,
AppConst,
DatabaseStatusListener {
    private AppDefaultWin parentWin = null;
    private int status = 4;
    private ImageIcon currentImage = null;

    public void databaseStatusChange(int n, Database database) {
        if (database.getDatabaseId() == 1 && !database.getSecondaryConnection()) {
            this.status = n;
            this.refreshIcon();
        }
        switch (n) {
            case 1: {
                this.setStatus(Str.getStr(625) + " " + database.getName());
                break;
            }
            default: {
                this.setStatus(null);
                break;
            }
        }
    }

    private void setStatus(String string) {
        if (this.parentWin == null) {
            this.parentWin = GUISystem.getParentDefWin(this);
        }
        if (this.parentWin != null) {
            this.parentWin.setStatus(string);
        }
    }

    public void propertyChanged(int n, Object object) {
        this.refreshIcon();
    }

    private void refreshIcon() {
        switch (this.status) {
            case 2: {
                this.currentImage = ImageSystem.getImageIcon((Object)this, 178);
                this.setToolTipText(Str.getStr(1282));
                break;
            }
            case 1: {
                this.currentImage = ImageSystem.getImageIcon((Object)this, 179);
                this.setToolTipText(Str.getStr(1284));
                break;
            }
            default: {
                this.setToolTipText(Str.getStr(1283));
                this.currentImage = ImageSystem.getImageIcon((Object)this, 180);
                break;
            }
        }
    }

    public void paintComponent(Graphics graphics) {
        Dimension dimension = this.getSize();
        --dimension.width;
        --dimension.height;
        graphics.drawImage(this.currentImage.getImage(), 2, 2, this);
    }

    public DBStatusLight() {
        DatabaseSystem.addStatusListener(this);
        if (DatabaseSystem.isDatabaseConnected(1)) {
            this.status = 2;
        }
        this.refreshIcon();
    }
}

