/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.doc;

import com.ibm.nzna.projects.common.quest.type.TypeBrandRec;
import com.ibm.nzna.projects.common.quest.type.TypeRec;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.MainWindow;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.doc.DocConst;
import com.ibm.nzna.projects.qit.doc.DocFamilyRec;
import com.ibm.nzna.projects.qit.doc.DocFileRec;
import com.ibm.nzna.projects.qit.doc.DocRec;
import com.ibm.nzna.projects.qit.doc.ProdDocRec;
import com.ibm.nzna.projects.qit.ftp.FTPSite;
import com.ibm.nzna.projects.qit.product.MachineRec;
import com.ibm.nzna.projects.qit.product.ProductConstants;
import com.ibm.nzna.projects.qit.product.ProductRec;
import com.ibm.nzna.shared.pom.PersistentRec;
import com.ibm.nzna.shared.util.FileUtil;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.Text;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.Vector;

public class DocFTP
implements DocConst,
AppConst,
ProductConstants {
    public static boolean processFiles(DocRec docRec) {
        Vector vector = null;
        Vector vector2 = null;
        boolean bl = false;
        LogSystem.log(1, "Starting FTP Process now.");
        vector = (Vector)docRec.getFieldData(41);
        vector2 = (Vector)docRec.getFieldData(50);
        if (vector != null && vector.size() > 0 || vector2 != null && vector2.size() > 0) {
            DocFTP.setText(Str.getStr(249));
            if (docRec.isPublishing()) {
                MainWindow.getInstance().setStatus(216);
                bl = vector != null && vector.size() > 0 ? DocFTP.publishMediaFiles(docRec, vector) : true;
                MainWindow.getInstance().setStatus(322);
                if (bl && vector2 != null && vector2.size() > 0 && (bl = DocFTP.transferFilesToServer(vector2, 3))) {
                    bl = DocFTP.deleteFilesFromServer(vector2, 4);
                }
            } else {
                MainWindow.getInstance().setStatus(216);
                bl = vector != null && vector.size() > 0 ? DocFTP.transferFilesToServer(vector, 2) : true;
                MainWindow.getInstance().setStatus(322);
                if (vector2 != null && vector2.size() > 0 && bl) {
                    bl = DocFTP.transferFilesToServer(vector2, 4);
                }
            }
            if (!bl) {
                LogSystem.log(1, "failed to process files");
            }
        } else {
            LogSystem.log(1, "Nothing to FTP");
            bl = true;
        }
        MainWindow.getInstance().setStatus(null);
        return bl;
    }

    public static File createPublishingHeader(String string, DocFileRec docFileRec, DocRec docRec) {
        try {
            PersistentRec persistentRec;
            ProdDocRec prodDocRec = (ProdDocRec)docRec.getFieldData(22);
            Date date = new Date();
            Vector vector = null;
            int n = 0;
            String string2 = "";
            File file = new File(string, Text.stripPath(docFileRec.sFilename) + ".hdr");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            URL uRL = new URL(docFileRec.fileURL);
            String string3 = uRL.getFile().substring(0, uRL.getFile().lastIndexOf("/"));
            if (string3 != null) {
                string3 = string3.substring(string3.lastIndexOf("/", string3.length()));
            }
            fileOutputStream.write(new String("Filename: " + Text.stripPath(docFileRec.sFilename) + "\n").getBytes());
            fileOutputStream.write(new String("filesize: " + docFileRec.fileSize + "\n").getBytes());
            if (docFileRec.getFTPRecStatus() != 1) {
                fileOutputStream.write(new String("filedate: " + date.toString() + "\n").getBytes());
            } else {
                fileOutputStream.write(new String("filedate:").getBytes());
            }
            fileOutputStream.write(new String("filedesc: " + Text.replaceAllStrInStr(docFileRec.descript, "\n", " ") + "\n").getBytes());
            fileOutputStream.write(new String("filearea: " + string3 + "\n").getBytes());
            fileOutputStream.write(new String("ownername: " + UserSystem.getUserName() + "\n").getBytes());
            if (docFileRec.sFilename.endsWith(".txt")) {
                fileOutputStream.write(new String("filetype: ascii \n").getBytes());
            } else {
                fileOutputStream.write(new String("filetype: binary \n").getBytes());
            }
            switch (docFileRec.getFTPRecStatus()) {
                case 3: {
                    fileOutputStream.write(new String("actiontype: delete \n").getBytes());
                    break;
                }
                case 1: {
                    fileOutputStream.write(new String("actiontype: update \n").getBytes());
                    break;
                }
                default: {
                    fileOutputStream.write(new String("actiontype: insert \n").getBytes());
                    break;
                }
            }
            fileOutputStream.write(new String("fileexpdate: \n").getBytes());
            string2 = "brand: ";
            if (prodDocRec != null && prodDocRec.hasFamilies()) {
                persistentRec = null;
                vector = prodDocRec.getDistinctBrands();
                n = 0;
                while (n < vector.size()) {
                    persistentRec = (TypeBrandRec)vector.elementAt(n);
                    string2 = string2 + ((TypeRec)persistentRec).toString() + ", ";
                    ++n;
                }
            }
            if (string2.length() > 3) {
                string2 = string2.substring(0, string2.length() - 2);
            }
            fileOutputStream.write((string2 + "\n").getBytes());
            string2 = "family: ";
            if (prodDocRec != null && prodDocRec.hasFamilies()) {
                persistentRec = null;
                vector = prodDocRec.getAssociatedFamiliesAll();
                n = 0;
                while (n < vector.size()) {
                    persistentRec = ((DocFamilyRec)vector.elementAt(n)).getTypeGroupRec();
                    string2 = string2 + ((TypeRec)persistentRec).toString() + ".ALL, ";
                    ++n;
                }
            }
            if (string2.length() > 3) {
                string2 = string2.substring(0, string2.length() - 2);
            }
            fileOutputStream.write((string2 + "\n").getBytes());
            string2 = "mach: ";
            if (prodDocRec != null && prodDocRec.hasMachines()) {
                persistentRec = null;
                vector = prodDocRec.getAssociatedMachinesAll();
                n = 0;
                while (n < vector.size()) {
                    persistentRec = (MachineRec)vector.elementAt(n);
                    string2 = string2 + ((MachineRec)persistentRec).getMachine() + ".ALL, ";
                    ++n;
                }
            }
            if (string2.length() > 3) {
                string2 = string2.substring(0, string2.length() - 2);
            }
            fileOutputStream.write((string2 + "\n").getBytes());
            string2 = "model: ";
            if (prodDocRec != null && prodDocRec.hasModels()) {
                persistentRec = null;
                vector = prodDocRec.getAssociatedModels();
                n = 0;
                while (n < vector.size()) {
                    persistentRec = (ProductRec)vector.elementAt(n);
                    string2 = string2 + ((ProductRec)persistentRec).getFieldData(4) + ", ";
                    ++n;
                }
            }
            if (string2.length() > 3) {
                string2 = string2.substring(0, string2.length() - 2);
            }
            fileOutputStream.write((string2 + "\n").getBytes());
            fileOutputStream.close();
            LogSystem.log(1, "createPublishingHeader(), " + file.getName());
            return file;
        }
        catch (IOException iOException) {
            LogSystem.log(1, iOException);
            return null;
        }
    }

    private static void setText(String string) {
        MainWindow.getInstance().setStatus(string);
    }

    private static boolean publishMediaFiles(DocRec docRec, Vector vector) {
        boolean bl = true;
        try {
            String string = PropertySystem.getString(30);
            String string2 = null;
            DocFileRec docFileRec = null;
            File file = null;
            int n = 0;
            int n2 = vector.size();
            FTPSite fTPSite = null;
            FTPSite fTPSite2 = null;
            LogSystem.log(1, "Publish Media Files");
            DocFTP.setText(Str.getStr(321));
            fTPSite = FTPSite.getFTPSite(2);
            if (fTPSite.connect()) {
                LogSystem.log(1, "Connected to Server: " + fTPSite.getHost());
                DocFTP.setText(Str.getStr(250));
                if (fTPSite.login()) {
                    fTPSite.setLocalDir(string);
                    LogSystem.log(1, "Work done on Temp Server");
                    LogSystem.log(1, "Source:" + fTPSite.getLocalDir());
                    LogSystem.log(1, "Remote:" + fTPSite.getRemoteDir());
                    while (bl && n < n2) {
                        docFileRec = (DocFileRec)vector.elementAt(n);
                        if (docFileRec != null && docFileRec.getFTPRecStatus() != 0) {
                            LogSystem.log(1, "Processing File:" + docFileRec.sFilename + "  Rec Status:" + docFileRec.getFTPRecStatus());
                            string2 = Text.stripPath(docFileRec.sFilename);
                            if (string2.toUpperCase().endsWith("TXT")) {
                                fTPSite.setAscii();
                            } else {
                                fTPSite.setBinary();
                            }
                            switch (docFileRec.getFTPRecStatus()) {
                                case 0: 
                                case 1: 
                                case 2: {
                                    DocFTP.setText(Str.getStr(323) + " " + string2);
                                    LogSystem.log(1, "Getting file: " + string2);
                                    if (fTPSite.get(string2)) {
                                        LogSystem.log(1, "Get was Ok, deleting file now");
                                        bl = fTPSite.delete(string2, true);
                                        LogSystem.log(1, "Delete returned: " + bl);
                                        break;
                                    }
                                    bl = false;
                                    break;
                                }
                                case 3: {
                                    LogSystem.log(1, "(QITRec.REC_DELETE)Deleting file now. Filename:" + string2);
                                    DocFTP.setText(Str.getStr(239) + " " + string2);
                                    if (!fTPSite.delete(string2, false)) {
                                        fTPSite.delete(string2, true);
                                    }
                                    LogSystem.log(1, "Deleting Complete: " + string2);
                                    break;
                                }
                            }
                        }
                        ++n;
                    }
                    LogSystem.log(1, "Disconnecting from Source FTP Site");
                    fTPSite.disconnect();
                    fTPSite = null;
                    System.gc();
                    if (bl) {
                        n = 0;
                        DocFTP.setText(Str.getStr(321));
                        LogSystem.log(1, "Connecting to Site");
                        fTPSite2 = FTPSite.getFTPSite(1);
                        if (fTPSite2.connect()) {
                            LogSystem.log(1, "Connected to site " + fTPSite2.getHost());
                            DocFTP.setText(Str.getStr(250));
                            if (fTPSite2.login()) {
                                if (fTPSite2.setLocalDir(string)) {
                                    LogSystem.log(1, "FTP SITE (PROD) SOURCE LOCAL DIR:" + fTPSite2.getLocalDir());
                                    LogSystem.log(1, "FTP SITE (PROD) REMOTE LOCAL DIR:" + fTPSite2.getRemoteDir());
                                    while (bl && n < n2) {
                                        docFileRec = (DocFileRec)vector.elementAt(n);
                                        if (docFileRec != null && docFileRec.getFTPRecStatus() != 0) {
                                            string2 = Text.stripPath(docFileRec.sFilename);
                                            LogSystem.log(1, "Processing Media Rec:" + docFileRec.sFilename + "  Rec Status:" + docFileRec.getFTPRecStatus());
                                            if (string2.toUpperCase().endsWith("TXT")) {
                                                fTPSite2.setAscii();
                                            } else {
                                                fTPSite2.setBinary();
                                            }
                                            switch (docFileRec.getFTPRecStatus()) {
                                                case 0: 
                                                case 1: 
                                                case 2: {
                                                    DocFTP.setText(Str.getStr(324) + " " + string2);
                                                    if (FileUtil.exists(string + string2)) {
                                                        if (fTPSite2.move(string2)) {
                                                            file = DocFTP.createPublishingHeader(string, docFileRec, docRec);
                                                            if (fTPSite2.move(file.getName())) {
                                                                bl = DocFTP.validateFile(fTPSite2, string2);
                                                                break;
                                                            }
                                                            LogSystem.log(1, "Move of file:" + string2 + "  failed!");
                                                            bl = false;
                                                            break;
                                                        }
                                                        LogSystem.log(1, "Move of file:" + string2 + "  failed!");
                                                        bl = false;
                                                        break;
                                                    }
                                                    file = DocFTP.createPublishingHeader(string, docFileRec, docRec);
                                                    if (!fTPSite2.move(file.getName())) {
                                                        bl = DocFTP.validateFile(fTPSite2, string2);
                                                        break;
                                                    }
                                                    bl = GUISystem.printBox(Str.getStr(8), Str.getStr(325));
                                                    LogSystem.log(1, "File not on local, Move failed. Filename:" + string2 + " User answered:" + bl);
                                                    break;
                                                }
                                                case 3: {
                                                    DocFTP.setText(Str.getStr(239) + " " + string2);
                                                    file = DocFTP.createPublishingHeader(string, docFileRec, docRec);
                                                    bl = fTPSite2.move(file.getName());
                                                    if (bl) break;
                                                    LogSystem.log(1, "On delete of file, failed to move header up");
                                                    break;
                                                }
                                            }
                                        }
                                        ++n;
                                    }
                                } else {
                                    bl = false;
                                }
                            } else {
                                bl = false;
                            }
                        } else {
                            bl = false;
                        }
                        if (fTPSite2 != null) {
                            fTPSite2.disconnect();
                        }
                    }
                } else {
                    bl = false;
                }
            } else {
                bl = false;
            }
            LogSystem.endLogSection();
            fTPSite2 = null;
            System.gc();
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
        return bl;
    }

    private static boolean transferFilesToServer(Vector vector, int n) {
        FTPSite fTPSite = FTPSite.getFTPSite(n);
        boolean bl = true;
        int n2 = 0;
        int n3 = 0;
        DocFileRec docFileRec = null;
        String string = null;
        try {
            LogSystem.beginLogSection("Transferring Files To Server");
            if (vector != null) {
                LogSystem.log(1, "File Vector Size:" + vector.size());
                n3 = vector.size();
                DocFTP.setText(Str.getStr(321));
                if (fTPSite.connect()) {
                    DocFTP.setText(Str.getStr(250));
                    if (fTPSite.login()) {
                        if (fTPSite.setLocalDir(PropertySystem.getString(30))) {
                            LogSystem.log(1, "inside Transfer: localDir:" + fTPSite.getLocalDir());
                            LogSystem.log(1, "inside Transfer: remoteDir:" + fTPSite.getRemoteDir());
                            while (bl && n2 < n3) {
                                docFileRec = (DocFileRec)vector.elementAt(n2);
                                if (docFileRec != null) {
                                    LogSystem.log(1, "Processing File:" + docFileRec.sFilename + "   recStatus:" + docFileRec.getFTPRecStatus());
                                    if (docFileRec.getFTPRecStatus() != 0) {
                                        string = Text.stripPath(docFileRec.sFilename);
                                        if (string.toUpperCase().endsWith("TXT")) {
                                            fTPSite.setAscii();
                                        } else {
                                            fTPSite.setBinary();
                                        }
                                        switch (docFileRec.getFTPRecStatus()) {
                                            case 3: {
                                                LogSystem.log(1, "Deleting File:" + docFileRec.sFilename + "   recStatus:" + docFileRec.getFTPRecStatus());
                                                DocFTP.setText(Str.getStr(239) + " " + string);
                                                if (fTPSite.delete(string, false)) break;
                                                fTPSite.delete(string, true);
                                                break;
                                            }
                                            default: {
                                                if (FileUtil.exists(PropertySystem.getString(30) + string)) {
                                                    DocFTP.setText(Str.getStr(324) + " " + string);
                                                    if (fTPSite.move(string)) {
                                                        bl = DocFTP.validateFile(fTPSite, string);
                                                        LogSystem.log(1, "Transfer Attempted for:" + string + ":  cont:" + bl);
                                                        break;
                                                    }
                                                    LogSystem.log(1, "Cannot move file:" + docFileRec.sFilename);
                                                    bl = false;
                                                    break;
                                                }
                                                bl = GUISystem.printBox(Str.getStr(7), Str.getStr(326) + " " + string);
                                                LogSystem.log(1, "File " + string + " does not exist on local temp, User answered:" + bl);
                                                break;
                                            }
                                        }
                                    }
                                }
                                ++n2;
                            }
                        } else {
                            bl = false;
                        }
                    } else {
                        bl = false;
                    }
                } else {
                    bl = false;
                }
                fTPSite.disconnect();
                LogSystem.endLogSection();
                fTPSite = null;
                System.gc();
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
        return bl;
    }

    private static boolean deleteFilesFromServer(Vector vector, int n) {
        FTPSite fTPSite = FTPSite.getFTPSite(n);
        boolean bl = true;
        int n2 = 0;
        int n3 = 0;
        DocFileRec docFileRec = null;
        String string = null;
        LogSystem.beginLogSection("Force FTP File Delete");
        if (vector != null) {
            n3 = vector.size();
            LogSystem.log(1, "Going to try and delete " + n3 + " files.");
            DocFTP.setText(Str.getStr(321));
            try {
                if (fTPSite.connect()) {
                    DocFTP.setText(Str.getStr(250));
                    if (fTPSite.login()) {
                        if (fTPSite.setLocalDir(PropertySystem.getString(30))) {
                            LogSystem.log(1, "ftpSiteDest.localDir:" + fTPSite.getLocalDir());
                            LogSystem.log(1, "ftpSiteDest.remoteDir:" + fTPSite.getRemoteDir());
                            while (bl && n2 < n3) {
                                docFileRec = (DocFileRec)vector.elementAt(n2);
                                if (docFileRec != null && docFileRec.getFTPRecStatus() != 0) {
                                    string = Text.stripPath(docFileRec.sFilename);
                                    LogSystem.log(1, "Processing File:" + docFileRec.sFilename + "   recStatus:" + docFileRec.getFTPRecStatus());
                                    DocFTP.setText(Str.getStr(239) + " " + string);
                                    bl = fTPSite.delete(string, true);
                                    LogSystem.log(1, "After delete for the file :" + string + ":  Error:" + bl);
                                }
                                ++n2;
                            }
                        } else {
                            bl = false;
                        }
                    } else {
                        bl = false;
                    }
                    fTPSite.disconnect();
                } else {
                    bl = false;
                }
            }
            catch (Exception exception) {
                LogSystem.log(1, exception);
            }
            LogSystem.log(1, "Disconnecting");
            fTPSite = null;
            System.gc();
        }
        LogSystem.endLogSection();
        return bl;
    }

    private static boolean validateFile(FTPSite fTPSite, String string) {
        boolean bl = false;
        try {
            String[] stringArray = fTPSite.list(string);
            if (stringArray != null && stringArray[0] != null) {
                LogSystem.log(1, "Validated File Exists:" + string + "  List returned:" + stringArray[0]);
                bl = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }
}

