/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.doc;

import com.ibm.nzna.projects.common.quest.Constants;
import com.ibm.nzna.projects.common.quest.Counter;
import com.ibm.nzna.projects.common.quest.type.TypeAuthRec;
import com.ibm.nzna.projects.common.quest.type.TypeBrandRec;
import com.ibm.nzna.projects.common.quest.type.TypeCountryCodeRec;
import com.ibm.nzna.projects.common.quest.type.TypeDocCatRec;
import com.ibm.nzna.projects.common.quest.type.TypeDocClassRec;
import com.ibm.nzna.projects.common.quest.type.TypeDocRec;
import com.ibm.nzna.projects.common.quest.type.TypeGeoRec;
import com.ibm.nzna.projects.common.quest.type.TypeGroupRec;
import com.ibm.nzna.projects.common.quest.type.TypeList;
import com.ibm.nzna.projects.common.quest.type.TypeMetricRec;
import com.ibm.nzna.projects.common.quest.type.TypePubRec;
import com.ibm.nzna.projects.common.quest.type.TypeRec;
import com.ibm.nzna.projects.common.quest.type.TypeResolutionRec;
import com.ibm.nzna.projects.common.quest.type.TypeWorkRec;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.AppSQL;
import com.ibm.nzna.projects.qit.app.Authority;
import com.ibm.nzna.projects.qit.app.DateSystem;
import com.ibm.nzna.projects.qit.app.FieldListener;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.LocaleRec;
import com.ibm.nzna.projects.qit.app.MainWindow;
import com.ibm.nzna.projects.qit.app.ProcessManagerSystem;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.QITRec;
import com.ibm.nzna.projects.qit.app.QuestProcess;
import com.ibm.nzna.projects.qit.app.StatusRec;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserRec;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.app.WindowSystem;
import com.ibm.nzna.projects.qit.bookmark.Bookmark;
import com.ibm.nzna.projects.qit.doc.DocConst;
import com.ibm.nzna.projects.qit.doc.DocFTP;
import com.ibm.nzna.projects.qit.doc.DocFamilyRec;
import com.ibm.nzna.projects.qit.doc.DocFileRec;
import com.ibm.nzna.projects.qit.doc.DocLinkRec;
import com.ibm.nzna.projects.qit.doc.DocPropertyRec;
import com.ibm.nzna.projects.qit.doc.DocStatusRec;
import com.ibm.nzna.projects.qit.doc.DocTemplateSystem;
import com.ibm.nzna.projects.qit.doc.ProdDocRec;
import com.ibm.nzna.projects.qit.doc.PublishingTagsRec;
import com.ibm.nzna.projects.qit.doc.SaveDocRec;
import com.ibm.nzna.projects.qit.doc.docedit.DocEditPanel;
import com.ibm.nzna.projects.qit.doc.docedit.DocLinkDlg;
import com.ibm.nzna.projects.qit.doc.docedit.DocSavingPanel;
import com.ibm.nzna.projects.qit.doc.gui.SaveTemplateDlg;
import com.ibm.nzna.projects.qit.doc.gui.SelectDocTypeDlg;
import com.ibm.nzna.projects.qit.doc.storedProc.docReader.DocReaderBuffer;
import com.ibm.nzna.projects.qit.doc.storedProc.docReader.DocReaderLinkBuffer;
import com.ibm.nzna.projects.qit.doc.storedProc.docReader.DocReaderMediaBuffer;
import com.ibm.nzna.projects.qit.doc.storedProc.docReader.DocReaderProdBuffer;
import com.ibm.nzna.projects.qit.ftp.FTPSite;
import com.ibm.nzna.projects.qit.gui.AppDefaultWin;
import com.ibm.nzna.projects.qit.gui.GlassItem;
import com.ibm.nzna.projects.qit.gui.QuestPanel;
import com.ibm.nzna.projects.qit.gui.SelectUserDlg;
import com.ibm.nzna.projects.qit.gui.SingleEntryDlg;
import com.ibm.nzna.projects.qit.notify.NotificationRec;
import com.ibm.nzna.projects.qit.notify.SendNotifyDlg;
import com.ibm.nzna.projects.qit.product.MachineRec;
import com.ibm.nzna.projects.qit.product.ProductConstants;
import com.ibm.nzna.projects.qit.product.ProductRec;
import com.ibm.nzna.projects.qit.storedProc.sqlRunner.QITSqlRunner;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.db.SQLParse;
import com.ibm.nzna.shared.db.SQLStatement;
import com.ibm.nzna.shared.ftp.FTP.Ftp;
import com.ibm.nzna.shared.ftp.FtpError;
import com.ibm.nzna.shared.gui.ExtendedMultiListRow;
import com.ibm.nzna.shared.gui.JListDlg;
import com.ibm.nzna.shared.gui.MultiListSort;
import com.ibm.nzna.shared.pom.PersistentRec;
import com.ibm.nzna.shared.util.CDate;
import com.ibm.nzna.shared.util.FileUtil;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.StoreUtil;
import com.ibm.nzna.shared.util.Text;
import java.awt.Frame;
import java.awt.Graphics;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URL;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Vector;

public final class DocRec
extends QITRec
implements Serializable,
Runnable,
DocConst,
QuestProcess,
AppConst,
Authority,
ProductConstants,
ExtendedMultiListRow,
MultiListSort {
    static final long serialVersionUID = 1000000L;
    private static final String THREAD_CREATEDOCREQUEST = "CDR";
    private static final String THREAD_READDOCUMENT = "rd";
    private static final String THREAD_SAVEDOCUMENT = "sd";
    private static final String THREAD_READFIELDSET = "rfs";
    private static final String THREAD_READPREVIEWINFO = "rpi";
    private static final String THREAD_FIRECHANGE = "fc";
    private static final String THREAD_SETFOREDIT = "sfe";
    private static QuestPanel parentPanel = null;
    private static AppDefaultWin parentWindow = null;
    private int docInd = 0;
    private int existingDocInd = 0;
    private int templateDocInd = 0;
    private int[] columnData = new int[7];
    private String requestor = null;
    private String title = null;
    private String owner = null;
    private String source = null;
    private String comment = null;
    private String partNumber = null;
    private String notesId = null;
    private String dbUser = null;
    private String changedTime = null;
    private String url = null;
    private String originalComment = null;
    private String queryText = null;
    private String startDate = null;
    private String stopDate = null;
    private String returnEMail = null;
    private String addInfo = null;
    private String body = null;
    private String commentHistory = null;
    private PublishingTagsRec publishingTagsRec = null;
    private TypeDocClassRec docClassRec = null;
    private TypeDocRec docTypeRec = null;
    private TypePubRec publicationRec = null;
    private TypeMetricRec metricRec = null;
    private TypeAuthRec authRec = null;
    private TypeWorkRec workReqRec = null;
    private DocStatusRec statusRec = null;
    private Vector graphicVec = null;
    private Vector mediaVec = null;
    private Vector docCatVec = null;
    private Vector docPropVec = null;
    private Vector docLinksVec = null;
    private Vector refDocLinksVec = null;
    private LocaleRec localeRec = null;
    private ProdDocRec prodDocRec = null;
    private String[] titleArray = null;
    private int charWidth = 0;
    private int editType = 0;
    private boolean previewInfoValid = false;
    private boolean recycled = false;
    private boolean history = false;
    private int startBodyRecNum = 0;
    private boolean request = false;
    private int maxDocBody = 0;
    private boolean publish = false;
    private boolean maintLock = false;
    private boolean show = false;
    private boolean template = false;
    private String prettyChangedTime = null;
    private Object threadReturnObject = null;
    private SaveDocRec saveDocRec = null;
    private int readFieldId = 0;
    private int errorFieldId = 0;
    private Vector fieldListenerVec = null;
    private int lastFieldChange = 0;
    private String prettyRequestor = null;
    private String prettyOwner = null;
    private String prettydbUser = null;
    private Vector origMediaVec = null;
    private boolean initialRead = true;
    private boolean setForEdit = false;
    private Object docEditor = null;
    private boolean newRecord = false;
    private boolean applyCommentSignature = true;
    private String processName = "docRec";
    private boolean continueProcess = true;
    private int lastTitlePixelWidth = 100;
    private boolean previewInfoRead = false;
    private DocSavingPanel savePanel = null;

    private void init() {
        this.columnData[0] = 63;
        this.columnData[1] = 65;
        this.columnData[2] = 70;
        this.columnData[3] = 55;
        this.columnData[4] = 64;
        this.columnData[5] = 62;
        this.columnData[6] = 5;
    }

    public Object getColumnData(int n) {
        if (!this.recycled) {
            return this.getFieldData(this.columnData[n]);
        }
        switch (n) {
            case 0: {
                return "" + this.getDatabaseDocInd();
            }
            case 1: {
                return this.getFieldData(2);
            }
            case 2: {
                return this.getFieldData(62);
            }
            case 3: {
                return this.getFieldData(64);
            }
        }
        return "";
    }

    public int columnCount() {
        return 3;
    }

    public void setData(DocReaderBuffer docReaderBuffer) {
        if (docReaderBuffer != null) {
            TypeList typeList = TypeList.getInstance();
            if (docReaderBuffer.flashDate != null && docReaderBuffer.flashDate.length() > 0) {
                docReaderBuffer.flashDate = DateSystem.prettyDateFromDBDate(docReaderBuffer.flashDate);
            }
            if (docReaderBuffer.emailableDate != null && docReaderBuffer.emailableDate.length() > 0) {
                docReaderBuffer.emailableDate = DateSystem.prettyDateFromDBDate(docReaderBuffer.emailableDate);
            }
            if (docReaderBuffer.startDate != null && docReaderBuffer.startDate.length() > 0) {
                docReaderBuffer.startDate = DateSystem.prettyDateFromDBDate(docReaderBuffer.startDate);
            }
            if (docReaderBuffer.stopDate != null && docReaderBuffer.stopDate.length() > 0) {
                docReaderBuffer.stopDate = DateSystem.prettyDateFromDBDate(docReaderBuffer.stopDate);
            }
            this.setFieldData(2, docReaderBuffer.title);
            this.setFieldData(7, docReaderBuffer.source);
            this.setFieldData(3, docReaderBuffer.requestor);
            this.setFieldData(6, docReaderBuffer.owner);
            this.setFieldData(14, DocReaderBuffer.stringFromVec(docReaderBuffer.bodyVec));
            this.setFieldData(32, "");
            this.setFieldData(34, docReaderBuffer.partNumber);
            this.notesId = docReaderBuffer.lnDocId;
            this.setFieldData(53, docReaderBuffer.dbUser);
            this.setFieldData(54, docReaderBuffer.changedTime);
            this.setFieldData(15, typeList.objectFromInd(docReaderBuffer.docClassInd, 5));
            this.setFieldData(66, typeList.objectFromInd(docReaderBuffer.authInd, 1));
            this.setFieldData(16, typeList.objectFromInd(docReaderBuffer.docTypeInd, 4));
            this.setFieldData(31, typeList.objectFromInd(docReaderBuffer.metricInd, 11));
            this.setFieldData(30, typeList.objectFromInd(docReaderBuffer.pubTypeInd, 13));
            this.setFieldData(29, DocReaderBuffer.stringFromVec(docReaderBuffer.addInfoVec));
            this.setFieldData(67, docReaderBuffer.commentHistory);
            this.setFieldData(68, docReaderBuffer.queryText);
            this.originalComment = docReaderBuffer.comment;
            this.stopDate = docReaderBuffer.stopDate;
            this.startDate = docReaderBuffer.startDate;
            if (this.workReqRec == null) {
                this.workReqRec = (TypeWorkRec)typeList.objectFromInd(docReaderBuffer.workInd, 14);
            }
            this.readDocProducts(docReaderBuffer);
            this.readDocMedia(docReaderBuffer);
            this.readDocProperties(docReaderBuffer);
            this.readDocLocale(docReaderBuffer);
            this.readDocLinks(docReaderBuffer);
            this.readDocCategories(docReaderBuffer);
            if (this.publishingTagsRec == null) {
                this.publishingTagsRec = new PublishingTagsRec();
            }
            this.publishingTagsRec.faq = docReaderBuffer.faq.equals("Y");
            this.publishingTagsRec.eMailable = docReaderBuffer.emailable.equals("Y");
            this.publishingTagsRec.eMailableDate = docReaderBuffer.emailableDate;
            this.publishingTagsRec.hotFlash = docReaderBuffer.flash.equals("Y");
            this.publishingTagsRec.flashDate = docReaderBuffer.flashDate;
            this.publishingTagsRec.webable = docReaderBuffer.webable.equals("Y");
            this.publishingTagsRec.faxable = docReaderBuffer.faxable.equals("Y");
            this.publishingTagsRec.webOnly = docReaderBuffer.webonly.equals("Y");
            this.publishingTagsRec.eMailComments = docReaderBuffer.summary;
            this.publishingTagsRec.knowledgeBase = docReaderBuffer.knowledgeBase.equals("Y");
            this.publishingTagsRec.monthsToReview = docReaderBuffer.reviewPeriod;
            try {
                this.maintLock = docReaderBuffer.maintLock.equals("Y");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setData(DocRec docRec) {
        try {
            if (docRec != null) {
                this.setFieldData(27, docRec.url);
                this.setFieldData(3, docRec.requestor);
                this.setFieldData(2, docRec.title);
                this.setFieldData(6, docRec.owner);
                this.setFieldData(7, docRec.source);
                this.setFieldData(32, docRec.comment);
                this.setFieldData(34, docRec.partNumber);
                this.setFieldData(53, docRec.dbUser);
                this.setFieldData(54, docRec.changedTime);
                this.setFieldData(67, docRec.commentHistory);
                this.setFieldData(68, docRec.queryText);
                this.notesId = docRec.notesId;
                this.templateDocInd = docRec.templateDocInd;
                this.originalComment = docRec.originalComment;
                this.setFieldData(56, docRec.startDate);
                this.setFieldData(61, docRec.stopDate);
                this.returnEMail = docRec.returnEMail;
                this.setFieldData(14, docRec.body);
                this.setFieldData(29, docRec.addInfo);
                this.setFieldData(15, docRec.docClassRec);
                this.setFieldData(16, docRec.docTypeRec);
                this.setFieldData(30, docRec.publicationRec);
                this.setFieldData(31, docRec.metricRec);
                this.setFieldData(52, docRec.workReqRec);
                this.authRec = docRec.authRec;
                if (docRec.localeRec != null) {
                    this.setFieldData(24, docRec.localeRec.clone());
                }
                if (docRec.prodDocRec != null) {
                    this.setFieldData(22, docRec.prodDocRec.clone());
                }
                if (docRec.publishingTagsRec != null) {
                    this.setFieldData(13, docRec.publishingTagsRec.clone());
                }
                if (docRec.statusRec != null) {
                    this.statusRec = new DocStatusRec(docRec.statusRec.getId(), docRec.statusRec.getDate());
                }
                if (docRec.graphicVec != null) {
                    this.graphicVec = (Vector)docRec.graphicVec.clone();
                }
                if (docRec.mediaVec != null) {
                    this.setFieldData(41, docRec.mediaVec.clone());
                }
                if (docRec.docCatVec != null) {
                    this.setFieldData(17, docRec.docCatVec.clone());
                }
                if (docRec.docPropVec != null) {
                    this.docPropVec = (Vector)docRec.docPropVec.clone();
                }
                if (docRec.docLinksVec != null) {
                    this.setFieldData(44, docRec.docLinksVec.clone());
                }
                if (docRec.refDocLinksVec != null) {
                    this.setFieldData(58, docRec.refDocLinksVec.clone());
                }
                this.editType = docRec.editType;
                this.previewInfoValid = docRec.previewInfoValid;
                this.recycled = docRec.recycled;
                this.history = docRec.history;
                this.startBodyRecNum = docRec.startBodyRecNum;
                this.request = docRec.request;
                this.maxDocBody = docRec.maxDocBody;
                this.publish = docRec.publish;
                this.maintLock = docRec.maintLock;
                this.template = docRec.template;
                this.prettyChangedTime = docRec.prettyChangedTime;
                this.readFieldId = docRec.readFieldId;
                this.errorFieldId = docRec.errorFieldId;
                this.threadReturnObject = docRec.threadReturnObject;
                this.saveDocRec = docRec.saveDocRec;
                this.initialRead = docRec.initialRead;
                this.setForEdit = docRec.setForEdit;
                this.docEditor = docRec.docEditor;
                this.lastTitlePixelWidth = docRec.lastTitlePixelWidth;
                this.previewInfoRead = docRec.previewInfoRead;
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
    }

    public boolean isRequestValid() {
        boolean bl = false;
        this.errorFieldId = 0;
        if (this.title == null || this.title.length() < 2) {
            this.errorFieldId = 2;
        } else if (this.docCatVec == null || this.docCatVec.size() == 0) {
            this.errorFieldId = 17;
        } else if (this.prodDocRec != null) {
            if (!this.prodDocRec.hasFamilies()) {
                if (!this.prodDocRec.hasFamilyAll()) {
                    this.errorFieldId = 22;
                }
            } else if (!(this.prodDocRec.hasModels() || this.prodDocRec.hasMachineAll() || this.prodDocRec.hasFamilyAll())) {
                this.errorFieldId = 23;
            }
        } else {
            this.errorFieldId = 22;
        }
        bl = this.errorFieldId == 0;
        return bl;
    }

    public boolean addStatus(DocStatusRec docStatusRec) {
        docStatusRec.setRecNum(2);
        this.statusRec = docStatusRec;
        return true;
    }

    public int getCurrentStatusInd() {
        int n = 0;
        DocStatusRec docStatusRec = this.getCurrentDocStatusRec();
        if (docStatusRec != null) {
            n = docStatusRec.getStatusInd();
        }
        return n;
    }

    public DocStatusRec getCurrentDocStatusRec() {
        return this.statusRec;
    }

    public DocPropertyRec getProperty(int n) {
        DocPropertyRec docPropertyRec = null;
        boolean bl = false;
        if (this.docPropVec != null) {
            int n2 = 0;
            int n3 = this.docPropVec.size();
            while (n2 < n3 && !bl) {
                docPropertyRec = (DocPropertyRec)this.docPropVec.elementAt(n2);
                bl = docPropertyRec.propInd == n;
                ++n2;
            }
        }
        if (bl) {
            return docPropertyRec;
        }
        return null;
    }

    public void setProperty(DocPropertyRec docPropertyRec) {
        DocPropertyRec docPropertyRec2 = this.getProperty(docPropertyRec.propInd);
        if (docPropertyRec2 == null) {
            if (this.docPropVec == null) {
                this.docPropVec = new Vector();
            }
        } else {
            this.docPropVec.removeElement(docPropertyRec2);
        }
        docPropertyRec.updateRecStatus(2);
        this.docPropVec.addElement(docPropertyRec);
    }

    public void setStopDate() {
        if (this.isDocRequest()) {
            this.stopDate = new CDate().today();
        }
    }

    public boolean isPublishable() {
        boolean bl = false;
        Object var2_2 = null;
        if (this.docTypeRec != null) {
            try {
                int n = this.docTypeRec.getInd();
                this.errorFieldId = 0;
                if (this.prodDocRec != null) {
                    if (!this.prodDocRec.hasFamilies()) {
                        if (!this.prodDocRec.hasFamilyAll()) {
                            this.errorFieldId = 22;
                        }
                    } else if (!(this.prodDocRec.hasModels() || this.prodDocRec.hasMachineAll() || this.prodDocRec.hasFamilyAll())) {
                        this.errorFieldId = 23;
                    }
                } else {
                    this.errorFieldId = 22;
                }
                if (this.title == null || this.title.length() < 2) {
                    this.errorFieldId = 2;
                } else if (this.docClassRec == null) {
                    this.errorFieldId = 15;
                } else if (this.docCatVec == null || this.docCatVec.size() == 0) {
                    this.errorFieldId = 17;
                } else if (!(this.prodDocRec.hasModels() || this.prodDocRec.hasFamilyAll() || this.prodDocRec.hasFamilies() || this.prodDocRec.hasMachines())) {
                    this.errorFieldId = 23;
                } else if (this.localeRec == null || this.localeRec.countryCount() == 0) {
                    this.errorFieldId = 24;
                }
                if (n == 4 || n == 3 || n == 10 || n == 2) {
                    if (this.body == null || this.body.length() < 20) {
                        this.errorFieldId = 14;
                    }
                } else if (n == 9) {
                    if (this.getProperty(2) == null) {
                        this.errorFieldId = 26;
                    } else if (this.getProperty(8) == null) {
                        this.errorFieldId = 33;
                    } else if (this.partNumber == null || this.partNumber.length() == 0) {
                        this.errorFieldId = 34;
                    } else if (!(this.hasFileAttachments() || this.url != null && this.url.length() != 0)) {
                        this.errorFieldId = 27;
                    }
                } else if (n == 8) {
                    if (this.getProperty(2) == null) {
                        this.errorFieldId = 26;
                    } else if (this.publicationRec == null) {
                        this.errorFieldId = 30;
                    } else if (this.mediaVec == null && (this.url == null || this.url.length() == 0)) {
                        this.errorFieldId = 27;
                    }
                }
                if (this.body != null && this.body.indexOf("EditorComments") >= 0) {
                    GUISystem.printBox(7, 211);
                    return false;
                }
                if (this.addInfo != null && this.addInfo.indexOf("EditorComments") >= 0) {
                    GUISystem.printBox(7, 211);
                    return false;
                }
                bl = this.errorFieldId == 0;
            }
            catch (Exception exception) {
                LogSystem.log(1, exception);
            }
        }
        return bl;
    }

    public DocLinkRec addDocLink(DocLinkRec docLinkRec) {
        DocLinkRec docLinkRec2 = null;
        if (this.docLinksVec == null || this.docLinksVec.size() == 0) {
            if (this.docLinksVec == null) {
                this.docLinksVec = new Vector(1, 10);
            }
            docLinkRec2 = new DocLinkRec(docLinkRec.docInd, docLinkRec.title, docLinkRec.docClassRec, docLinkRec.notesId);
        } else {
            int n = this.docLinksVec.size();
            int n2 = 0;
            DocLinkRec docLinkRec3 = null;
            boolean bl = false;
            while (n2 < n && !bl) {
                docLinkRec3 = (DocLinkRec)this.docLinksVec.elementAt(n2);
                if (docLinkRec3 != null) {
                    bl = docLinkRec3.docInd == docLinkRec.docInd;
                }
                ++n2;
            }
            if (!bl) {
                docLinkRec2 = new DocLinkRec(docLinkRec.docInd, docLinkRec.title, docLinkRec.docClassRec, docLinkRec.notesId);
            }
        }
        if (docLinkRec2 != null) {
            docLinkRec2.updateRecStatus(2);
            this.docLinksVec.addElement(docLinkRec2);
        }
        docLinkRec = null;
        return docLinkRec2;
    }

    public DocLinkRec addDocLink(DocRec docRec) {
        DocLinkRec docLinkRec = null;
        if (this.docLinksVec == null || this.docLinksVec.size() == 0) {
            if (this.docLinksVec == null) {
                this.docLinksVec = new Vector(1, 10);
            }
            docLinkRec = new DocLinkRec(docRec.docInd, docRec.title, docRec.docClassRec, docRec.notesId);
        } else {
            int n = this.docLinksVec.size();
            int n2 = 0;
            DocLinkRec docLinkRec2 = null;
            boolean bl = false;
            while (n2 < n && !bl) {
                docLinkRec2 = (DocLinkRec)this.docLinksVec.elementAt(n2);
                if (docLinkRec2 != null) {
                    bl = docLinkRec2.docInd == docRec.docInd;
                }
                ++n2;
            }
            if (!bl) {
                docLinkRec = new DocLinkRec(docRec.docInd, docRec.title, docRec.docClassRec, docRec.notesId);
            }
        }
        if (docLinkRec != null) {
            docLinkRec.updateRecStatus(2);
            this.docLinksVec.addElement(docLinkRec);
        }
        return docLinkRec;
    }

    public DocFileRec addGraphic(String string) {
        DocFileRec docFileRec = null;
        boolean bl = false;
        if (this.graphicVec == null || this.graphicVec.size() == 0) {
            if (this.graphicVec == null) {
                this.graphicVec = new Vector(1, 10);
            }
            docFileRec = new DocFileRec(string);
        } else {
            boolean bl2 = bl = this.getGraphic(string) != null;
            if (!bl) {
                docFileRec = new DocFileRec(string);
            }
        }
        if (docFileRec != null) {
            docFileRec.updateRecStatus(2);
            docFileRec.setFTPRecStatus(2);
            docFileRec.fileInd = Counter.getCounter(LogSystem.getInstance(), "GRAPHICIND");
            this.graphicVec.addElement(docFileRec);
        }
        return docFileRec;
    }

    public DocFileRec getGraphic(String string) {
        DocFileRec docFileRec = null;
        try {
            if (this.graphicVec != null && this.graphicVec.size() > 0) {
                int n = this.graphicVec.size();
                int n2 = 0;
                DocFileRec docFileRec2 = null;
                String string2 = string.toLowerCase();
                while (n2 < n && docFileRec == null) {
                    docFileRec2 = (DocFileRec)this.graphicVec.elementAt(n2);
                    if (docFileRec2 != null && docFileRec2.sFilename.toLowerCase().equals(string2)) {
                        docFileRec = docFileRec2;
                    }
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
        }
        return docFileRec;
    }

    public void setAllRecStatus(int n) {
        this.updateRecStatus(n);
        if (this.docCatVec != null) {
            DocRec.updateVecRecStatus(this.docCatVec, n);
        }
        if (this.statusRec != null) {
            this.statusRec.updateRecStatus(n);
        }
        if (this.docLinksVec != null) {
            DocRec.forceUpdateVecRecStatus(this.docLinksVec, n);
        }
        if (this.prodDocRec != null && this.prodDocRec != null) {
            DocRec.updateVecRecStatus(this.prodDocRec.getAssociatedFamilies(), n);
            DocRec.updateVecRecStatus(this.prodDocRec.getAssociatedMachines(), n);
            DocRec.updateVecRecStatus(this.prodDocRec.getAssociatedModels(), n);
        }
    }

    public void forceAllRecStatus(int n) {
        this.updateRecStatus(0);
        this.updateRecStatus(n);
        if (this.docCatVec != null) {
            DocRec.forceUpdateVecRecStatus(this.docCatVec, n);
        }
        if (this.statusRec != null) {
            this.statusRec.updateRecStatus(0);
            this.statusRec.updateRecStatus(n);
        }
        if (this.docLinksVec != null) {
            DocRec.forceUpdateVecRecStatus(this.docLinksVec, n);
        }
        if (this.prodDocRec != null && this.prodDocRec != null) {
            DocRec.forceUpdateVecRecStatus(this.prodDocRec.getAssociatedFamilies(), n);
            DocRec.forceUpdateVecRecStatus(this.prodDocRec.getAssociatedMachines(), n);
            DocRec.forceUpdateVecRecStatus(this.prodDocRec.getAssociatedModels(), n);
        }
    }

    public static void updateVecRecStatus(Vector vector, int n) {
        if (vector != null && vector.size() > 0) {
            PersistentRec persistentRec = null;
            int n2 = 0;
            int n3 = vector.size();
            while (n2 < n3) {
                persistentRec = (PersistentRec)vector.elementAt(n2);
                if (persistentRec != null) {
                    persistentRec.updateRecStatus(0);
                    persistentRec.updateRecStatus(n);
                }
                ++n2;
            }
        }
    }

    private static void forceUpdateVecRecStatus(Vector vector, int n) {
        try {
            if (vector != null && vector.size() > 0) {
                PersistentRec persistentRec = null;
                int n2 = 0;
                int n3 = vector.size();
                while (n2 < n3) {
                    persistentRec = (PersistentRec)vector.elementAt(n2);
                    if (persistentRec != null && persistentRec.getRecStatus() != 3 && persistentRec.getRecStatus() != 4) {
                        persistentRec.updateRecStatus(0);
                        persistentRec.updateRecStatus(n);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
        }
    }

    public void setHistory(boolean bl) {
        this.history = bl;
        if (bl) {
            this.setListColumnData(0, 61);
        }
    }

    public boolean getHistory(boolean bl) {
        return bl;
    }

    public void setRecycled(boolean bl) {
        this.recycled = bl;
        if (bl) {
            this.setListColumnData(0, 65);
            this.setListColumnData(2, 62);
        }
    }

    public boolean getRecycled(boolean bl) {
        return bl;
    }

    public void setPreviewInfoValid(boolean bl) {
        this.previewInfoValid = bl;
    }

    public boolean getPreviewInfoValid() {
        return this.previewInfoValid;
    }

    public Object clone() {
        return new DocRec(this);
    }

    public TypeBrandRec getDocBrand() {
        Vector vector;
        TypeBrandRec typeBrandRec = null;
        if (this.prodDocRec != null && (vector = this.prodDocRec.getAssociatedFamilies()) != null && vector.size() > 0) {
            typeBrandRec = ((DocFamilyRec)vector.elementAt(0)).getTypeBrandRec();
        }
        return typeBrandRec;
    }

    public boolean canSaveTemplate() {
        int n;
        int n2;
        DocFileRec docFileRec;
        boolean bl = true;
        if (this.graphicVec != null && this.graphicVec.size() > 0) {
            docFileRec = null;
            n2 = 0;
            n = this.graphicVec.size();
            while (bl && n2 < n) {
                docFileRec = (DocFileRec)this.graphicVec.elementAt(n2);
                if (docFileRec != null && docFileRec.getRecStatus() != 3 && docFileRec.getRecStatus() != 4) {
                    bl = false;
                }
                ++n2;
            }
        }
        if (this.mediaVec != null && this.mediaVec.size() > 0) {
            docFileRec = null;
            n2 = 0;
            n = this.mediaVec.size();
            while (bl && n2 < n) {
                docFileRec = (DocFileRec)this.mediaVec.elementAt(n2);
                if (docFileRec != null && docFileRec.getRecStatus() != 3 && docFileRec.getRecStatus() != 4) {
                    bl = false;
                }
                ++n2;
            }
        }
        return bl;
    }

    public boolean hasDocLinks() {
        return this.docLinksVec != null && this.docLinksVec.size() > 0 && this.refDocLinksVec != null && this.refDocLinksVec.size() > 0;
    }

    public void free() {
        if (this.docEditor == null && !this.isTemplate()) {
            this.requestor = null;
            this.title = null;
            this.owner = null;
            this.source = null;
            this.comment = null;
            this.partNumber = null;
            this.notesId = null;
            this.dbUser = null;
            this.changedTime = null;
            this.startDate = null;
            this.stopDate = null;
            this.returnEMail = null;
            this.addInfo = null;
            this.body = null;
            this.prettyChangedTime = null;
            this.prettydbUser = null;
            this.prettyOwner = null;
            this.prettyRequestor = null;
            this.publishingTagsRec = null;
            this.docClassRec = null;
            this.docTypeRec = null;
            this.publicationRec = null;
            this.metricRec = null;
            this.authRec = null;
            this.workReqRec = null;
            this.statusRec = null;
            this.localeRec = null;
            this.prodDocRec = null;
            this.threadReturnObject = null;
            this.saveDocRec = null;
            if (this.graphicVec != null) {
                this.graphicVec.removeAllElements();
                this.graphicVec = null;
            }
            if (this.mediaVec != null) {
                this.mediaVec.removeAllElements();
                this.mediaVec = null;
            }
            if (this.docCatVec != null) {
                this.docCatVec.removeAllElements();
                this.docCatVec = null;
            }
            if (this.docPropVec != null) {
                this.docPropVec.removeAllElements();
                this.docPropVec = null;
            }
            if (this.docLinksVec != null) {
                this.docLinksVec.removeAllElements();
                this.docLinksVec = null;
            }
            if (this.refDocLinksVec != null) {
                this.refDocLinksVec.removeAllElements();
                this.refDocLinksVec = null;
            }
            if (this.fieldListenerVec != null) {
                this.fieldListenerVec.removeAllElements();
                this.fieldListenerVec = null;
            }
            try {
                super.finalize();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public boolean saveDocument(SaveDocRec saveDocRec) {
        return this.saveDocument(saveDocRec, true);
    }

    public boolean saveDocument(SaveDocRec saveDocRec, boolean bl) {
        boolean bl2 = false;
        this.saveDocRec = saveDocRec;
        Thread thread = new Thread((Runnable)this, THREAD_SAVEDOCUMENT);
        thread.start();
        try {
            thread.join();
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
        }
        if (this.threadReturnObject instanceof Boolean) {
            bl2 = (Boolean)this.threadReturnObject;
        }
        return bl2;
    }

    private boolean processSaveDocument() {
        boolean bl = false;
        LogSystem.beginLogSection("Save Document");
        if (this.saveDocRec != null) {
            if (this.workReqRec != null && this.workReqRec.ind == 3 && this.saveDocRec.saveType == 1) {
                this.saveDocRec.saveType = 4;
            }
            try {
                switch (this.saveDocRec.saveType) {
                    case 2: {
                        LogSystem.log(1, "Preparing Document for save as REQUEST");
                        bl = this.saveAsRequest();
                        break;
                    }
                    case 6: {
                        LogSystem.log(1, "Preparing Document for save as TEMPLATE");
                        bl = this.saveAsTemplate();
                        break;
                    }
                    case 1: {
                        LogSystem.log(1, "Preparing Document for save as PUBLISH");
                        bl = this.saveAsPublish();
                        break;
                    }
                    case 4: {
                        LogSystem.log(1, "Preparing Document for save as DELETE");
                        bl = this.saveAsDelete();
                        break;
                    }
                    case 7: {
                        LogSystem.log(1, "Preparing Document for save as CLOSEDRAFT, NO PUBLISH");
                        this.setStopDate();
                        DocRec.updateVecRecStatus(this.mediaVec, 3);
                        DocRec.updateVecRecStatus(this.graphicVec, 3);
                        bl = this.saveAsRequest();
                        break;
                    }
                    case 5: {
                        LogSystem.log(1, "Preparing Document for save as CANCEL");
                        bl = this.saveAsCancel();
                        break;
                    }
                    case 8: {
                        LogSystem.log(1, "Preparing Document for save as RECYCLE");
                        if (!DocRec.checkDocLock(this)) {
                            this.setRecycled(true);
                            this.updateRecStatus(0);
                            this.updateRecStatus(1);
                            bl = this.saveToRecycle();
                            break;
                        }
                        GUISystem.printBox(Str.getStr(6), Str.getStr(221) + " " + this.title);
                        break;
                    }
                }
            }
            catch (Exception exception) {
                LogSystem.log(1, exception);
            }
            System.gc();
        }
        LogSystem.endLogSection();
        return bl;
    }

    private boolean saveToDatabase(boolean bl) {
        boolean bl2 = true;
        boolean bl3 = false;
        SQLMethod sQLMethod = new SQLMethod(1, "saveToDatabase (" + bl + ")", 5);
        String string = "";
        boolean bl4 = false;
        String string2 = "saveDocRec";
        PreparedStatement preparedStatement = null;
        Object var9_9 = null;
        if (this.validateOwner()) {
            if (this.savePanel != null) {
                this.savePanel.setStatus(342);
            } else {
                DocRec.getWindow().setStatus(342);
                DocRec.getWindow().setStatusLock(true);
            }
            LogSystem.log(1, "DocRec.saveToDatabase, Validated Owner, Continuing");
            if (sQLMethod != null) {
                try {
                    SQLStatement sQLStatement = null;
                    StringBuffer stringBuffer = new StringBuffer();
                    if (this.originalComment == null) {
                        this.originalComment = "";
                    }
                    this.comment = this.applyCommentSignature ? (this.comment == null || this.comment.length() == 0 ? this.originalComment + "\nOn " + DateSystem.getDate(2) + " " + UserSystem.getUserName() + " saved the document, but made no comments" : this.originalComment + "\n" + Str.getStr(127) + " " + DateSystem.getDate(2) + " " + UserSystem.getUserName() + " " + Str.getStr(724) + ":\n" + this.comment) : this.comment + this.originalComment;
                    if (this.owner == null || this.owner.length() == 0) {
                        this.owner = UserSystem.getUserId();
                    }
                    if (this.notesId == null || this.notesId.length() == 0) {
                        this.generateFilename();
                    }
                    if (this.publishingTagsRec == null) {
                        this.publishingTagsRec = new PublishingTagsRec(false);
                    }
                    if (this.isTemplate()) {
                        this.setFieldData(52, TypeList.getInstance().objectFromInd(1, 14));
                    }
                    LogSystem.log(1, "DocRec.saveToDatabase, Set Field Data, Continuing");
                    sQLStatement = new SQLStatement(this.getDatabaseQualifier() + ".DOCUMENTS");
                    sQLStatement.setColumnNames(50);
                    sQLStatement.setWhereColumnNames(1);
                    sQLStatement.setWhereColumnName(0, "DOCIND", "=");
                    sQLStatement.setWhereData(0, this.getDatabaseDocInd());
                    switch (this.getRecStatus()) {
                        case 1: {
                            LogSystem.log(1, "Saving Document as Update");
                            sQLStatement.setType(2);
                            break;
                        }
                        case 2: {
                            LogSystem.log(1, "Saving Document as Insert");
                            sQLStatement.setType(1);
                            break;
                        }
                        case 3: {
                            LogSystem.log(1, "Saving Document as Delete");
                            sQLStatement.setType(3);
                            break;
                        }
                        default: {
                            LogSystem.log(1, "Saving Document as Default, PROGRAMMER ERROR. recStatus:" + this.getRecStatus());
                            GUISystem.printBox("Program Error", "The following DocRec has no rec status:" + this.title + " -- " + this.getDatabaseDocInd());
                            return false;
                        }
                    }
                    sQLStatement.setColumnData(0, "DOCIND", this.getDatabaseDocInd());
                    if (!this.recycled) {
                        if (this.publishingTagsRec.eMailComments == null || this.publishingTagsRec.eMailComments.length() == 0) {
                            this.publishingTagsRec.eMailComments = "None";
                        }
                        sQLStatement.setColumnData(1, "DOCTYPEIND", this.docTypeRec.getInd());
                        sQLStatement.setColumnData(2, "DOCCLASSIND", this.docClassRec.getInd());
                        sQLStatement.setColumnData(3, "TITLE", this.title);
                        sQLStatement.setColumnData(4, "OWNER", this.owner);
                        sQLStatement.setColumnData(5, "REVIEWPERIOD", this.publishingTagsRec.monthsToReview);
                        sQLStatement.setColumnData(6, "AUTHIND", 0);
                        sQLStatement.setColumnData(7, "KNOWLEDGEBASE", this.publishingTagsRec.knowledgeBase);
                        sQLStatement.setColumnData(8, "WEBABLE", this.publishingTagsRec.webable);
                        sQLStatement.setColumnData(9, "WEBONLY", this.publishingTagsRec.webOnly);
                        sQLStatement.setColumnData(10, "FAXABLE", this.publishingTagsRec.faxable);
                        sQLStatement.setColumnData(11, "FLASHNEWS", this.publishingTagsRec.hotFlash);
                        sQLStatement.setColumnData(12, "FLASHDATE", this.publishingTagsRec.flashDate);
                        sQLStatement.setColumnData(13, "FAQ", this.publishingTagsRec.faq);
                        sQLStatement.setColumnData(14, "EMAILABLE", this.publishingTagsRec.eMailable);
                        sQLStatement.setColumnData(15, "EMAILABLEDATE", this.publishingTagsRec.eMailableDate);
                        sQLStatement.setColumnData(16, "SUMMARY", this.publishingTagsRec.eMailComments);
                        sQLStatement.setColumnData(17, "METRICIND", this.metricRec.getInd());
                        sQLStatement.setColumnData(18, "ADDINFO", "?");
                        sQLStatement.setColumnData(19, "PARTNUM", this.partNumber);
                        sQLStatement.setColumnData(21, "SOURCE", this.source);
                        sQLStatement.setColumnData(22, "MAINTLOCK", false);
                        sQLStatement.setColumnData(23, "SHOW", this.show);
                        sQLStatement.setColumnData(24, "PUBLISH", true);
                        sQLStatement.setColumnData(25, "WORKIND", this.workReqRec.getInd());
                        sQLStatement.setColumnData(26, "RECYCLED", false);
                        sQLStatement.setColumnData(27, "DBUSER", UserSystem.getUserId());
                        sQLStatement.setColumnData(28, "CHANGEDTIME", "CURRENT TIMESTAMP");
                        if (this.isDocRequest() || this.isTemplate()) {
                            if (this.comment == null || this.comment.length() == 0) {
                                this.comment = " ";
                            }
                            sQLStatement.setColumnData(24, "EXISTINGDOCIND", this.existingDocInd);
                            sQLStatement.setColumnData(26, "RECYCLED", this.recycled);
                            sQLStatement.setColumnData(29, "REQUESTOR", this.requestor);
                            sQLStatement.setColumnData(30, "RETURNEMAIL", this.returnEMail);
                            sQLStatement.setColumnData(31, "TEMPLATE", this.template);
                            sQLStatement.setColumnData(32, "COMMENT", this.comment);
                            sQLStatement.setColumnData(33, "STARTDATE", this.startDate);
                            sQLStatement.setColumnData(34, "STOPDATE", this.stopDate);
                            if (!this.isTemplate()) {
                                if (this.notesId != null && this.notesId.length() > 5 && this.getRecStatus() == 2) {
                                    sQLStatement.setColumnData(35, "LNDOCID", this.notesId);
                                }
                            } else {
                                this.notesId = null;
                                sQLStatement.setColumnData(35, "LNDOCID", "NULL");
                            }
                        } else if (this.notesId != null && this.notesId.length() > 4 && this.getRecStatus() == 2) {
                            sQLStatement.setColumnData(29, "LNDOCID", this.notesId);
                        }
                        if (this.publicationRec != null) {
                            sQLStatement.setColumnData(20, "PUBTYPE", this.publicationRec.getInd());
                        } else {
                            sQLStatement.setColumnData(20, "PUBTYPE", "NULL");
                        }
                    }
                    LogSystem.log(1, "Writing Document");
                    LogSystem.log(1, sQLStatement.toString());
                    preparedStatement = sQLMethod.createPreparedStatement(sQLStatement.toString());
                    if (!this.recycled && sQLStatement.getType() != 3) {
                        preparedStatement.setString(1, this.addInfo);
                    }
                    preparedStatement.executeUpdate();
                    sQLMethod.close();
                    this.setFieldData(54, DateSystem.getDate(1));
                    this.setFieldData(53, UserSystem.getUserId());
                    if ((this.isDocRequest() || this.isTemplate() || this.recycled) && !(bl2 = this.saveDocStatusHistory(stringBuffer))) {
                        GUISystem.printBox(6, 224);
                    }
                    if (this.isDocRequest() && this.getRecStatus() == 2 && !(bl2 = this.saveDocCreateDate(stringBuffer))) {
                        GUISystem.printBox(6, 223);
                    }
                    if (bl2 && !(bl2 = this.saveDocProductAssociations(stringBuffer))) {
                        GUISystem.printBox(6, 225);
                    }
                    if (bl2 && !(bl2 = this.saveDocLocale(stringBuffer))) {
                        GUISystem.printBox(6, 226);
                    }
                    if (bl2 && !(bl2 = this.saveDocCategories(stringBuffer))) {
                        GUISystem.printBox(6, 227);
                    }
                    if (bl2 && !(bl2 = this.saveDocGraphics(stringBuffer, !bl))) {
                        GUISystem.printBox(6, 228);
                    }
                    if (bl2 && !(bl2 = this.saveDocLinks(stringBuffer))) {
                        GUISystem.printBox(6, 229);
                    }
                    if (bl2 && !(bl2 = this.saveDocMedia(stringBuffer, !bl))) {
                        GUISystem.printBox(6, 230);
                    }
                    if (bl2 && !(bl2 = this.saveDocProperties(stringBuffer))) {
                        GUISystem.printBox(6, 231);
                    }
                    if (bl2 && !(bl2 = this.saveDocQueryText())) {
                        GUISystem.printBox(6, 1376);
                    }
                    if (bl2) {
                        if (this.docTypeRec.ind != 9) {
                            bl2 = this.saveDocBody();
                        }
                        if (!bl2) {
                            GUISystem.printBox(6, 232);
                        }
                    } else if (bl2 && this.getRecStatus() == 2) {
                        this.setAllRecStatus(1);
                    }
                    LogSystem.log(1, "Ended Document Info Save. rc:" + bl2);
                    bl3 = bl2;
                    if (bl2) {
                        this.setNewRecord(false);
                        if (this.savePanel != null) {
                            this.savePanel.setStatus(233);
                        } else {
                            DocRec.getWindow().setStatus(233);
                            DocRec.getWindow().setStatusLock(true);
                        }
                        QITSqlRunner.sqlRunner(stringBuffer.toString());
                    }
                }
                catch (Exception exception) {
                    LogSystem.log(1, exception);
                    sQLMethod.rollBack();
                }
            }
            sQLMethod.close();
            DocRec.getWindow().setStatusLock(false);
            DocRec.getWindow().setStatus(null);
        } else {
            LogSystem.log(1, "DocRec.saveToDatabase Could not verify owner");
        }
        return bl3;
    }

    public boolean readDocument() {
        return this.readDocument(true);
    }

    public boolean readDocument(boolean bl) {
        boolean bl2 = false;
        Thread thread = new Thread((Runnable)this, THREAD_READDOCUMENT);
        thread.start();
        try {
            thread.join();
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
        if (this.threadReturnObject instanceof Boolean) {
            bl2 = (Boolean)this.threadReturnObject;
        }
        return bl2;
    }

    private boolean processReadDocument() {
        String string = "processReadDocument";
        SQLMethod sQLMethod = new SQLMethod(1, string, 5);
        boolean bl = false;
        int n = 0;
        long l = System.currentTimeMillis();
        Object var7_6 = null;
        if (var7_6 == null && this.continueProcess) {
            block15: {
                LogSystem.beginLogSection("Reading Document");
                LogSystem.log(1, ":param 1-docInd:" + this.docInd);
                LogSystem.log(1, ":param 2-existingDocInd:" + this.existingDocInd);
                LogSystem.log(1, ":param 3-requestFlag:" + (this.isDocRequest() ? 1 : 0));
                LogSystem.log(1, ":-templateFlag:" + this.isTemplate());
                DocRec.getWindow().setStatus(240);
                try {
                    CallableStatement callableStatement = sQLMethod.createStoredProc("QUEST.DocReader", 7);
                    callableStatement.registerOutParameter(1, 4);
                    callableStatement.registerOutParameter(2, 4);
                    callableStatement.registerOutParameter(3, 4);
                    callableStatement.registerOutParameter(4, 4);
                    callableStatement.registerOutParameter(5, -4);
                    callableStatement.registerOutParameter(6, 4);
                    callableStatement.registerOutParameter(7, -1);
                    callableStatement.setInt(1, this.docInd);
                    callableStatement.setInt(2, this.existingDocInd);
                    callableStatement.setInt(3, this.isDocRequest() ? 1 : 0);
                    callableStatement.setInt(4, 0);
                    l = System.currentTimeMillis();
                    if (this.continueProcess) {
                        callableStatement.execute();
                        n = callableStatement.getInt(6);
                        LogSystem.log(1, "SQLCODE from 'docReader': " + n);
                        if (callableStatement.getString(7) != null) {
                            LogSystem.log(1, "'docReader' returned: " + callableStatement.getString(7));
                            break block15;
                        }
                        if (n != 0 || !this.continueProcess) break block15;
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(callableStatement.getBytes(5));
                        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                        DocReaderBuffer docReaderBuffer = null;
                        try {
                            docReaderBuffer = (DocReaderBuffer)objectInputStream.readObject();
                            objectInputStream.close();
                            byteArrayInputStream.close();
                        }
                        catch (InvalidClassException invalidClassException) {
                            docReaderBuffer = null;
                            GUISystem.printBox(7, 219);
                        }
                        sQLMethod.close();
                        if (this.continueProcess && docReaderBuffer != null) {
                            this.setData(docReaderBuffer);
                        }
                        if (docReaderBuffer != null && this.continueProcess) {
                            bl = this.readDocGraphics();
                        } else {
                            LogSystem.log(1, "Cannot read Document Graphics, return code set FALSE");
                            bl = false;
                        }
                        if (this.isDocRequest() && bl) {
                            bl = this.readDocStatus();
                        }
                        this.forceAllRecStatus(1);
                        break block15;
                    }
                    if (n == 100) {
                        GUISystem.printBox(7, 220);
                    } else {
                        GUISystem.printBox(Str.getStr(6), Str.getStr(212) + ": " + n);
                    }
                }
                catch (Exception exception) {
                    sQLMethod.rollBack();
                    LogSystem.log(1, exception, false);
                    bl = false;
                }
            }
            DocRec.getWindow().setStatus(null);
            LogSystem.log(1, "Total Time Taken:" + (System.currentTimeMillis() - l) + "(ms)");
            LogSystem.endLogSection();
        }
        System.gc();
        if (sQLMethod.isOpen()) {
            sQLMethod.close();
        }
        if (!this.continueProcess) {
            bl = false;
        }
        LogSystem.log(1, "processReadDocument return code:" + bl);
        return bl;
    }

    public DocRec createDocRequest() {
        DocRec docRec = null;
        System.out.println("Create Doc request. existingDocInd:" + this.existingDocInd);
        if (this.existingDocInd == 0) {
            this.initFields();
            this.setFieldData(52, TypeList.getInstance().objectFromInd(1, 14));
            this.setFieldData(56, DateSystem.getDate(2));
            this.request = true;
            this.template = false;
            this.recycled = false;
            this.forceAllRecStatus(2);
            if (this.docTypeRec == null) {
                if (this.obtainDocType()) {
                    docRec = this;
                }
            } else {
                docRec = this;
            }
            return docRec;
        }
        if (docRec == null) {
            Thread thread = new Thread((Runnable)this, THREAD_CREATEDOCREQUEST);
            System.out.println("Creating New Document From THREAD_CREATEDOCREQUEST");
            thread.start();
            try {
                thread.join();
            }
            catch (Exception exception) {
                LogSystem.log(1, exception);
            }
            docRec = (DocRec)this.threadReturnObject;
        }
        return docRec;
    }

    private DocRec processCreateDocRequest() {
        DocRec docRec = null;
        boolean bl = false;
        boolean bl2 = false;
        this.continueProcess = true;
        ProcessManagerSystem.addProcess(this);
        DocRec.getWindow().setStatus(Str.getStr(702));
        try {
            int n = 0;
            n = DocRec.checkForDocRequest(this.existingDocInd);
            if (n > 0) {
                boolean bl3 = GUISystem.printBox(8, 1488);
                bl2 = false;
                if (bl3) {
                    this.docInd = n;
                    this.request = true;
                    this.edit();
                }
            } else if (n == 0) {
                this.docInd = 0;
                bl2 = true;
            } else {
                bl2 = false;
                this.docInd = 0;
                this.continueProcess = false;
            }
            if (bl2 && this.continueProcess) {
                if (this.processReadDocument()) {
                    if (this.continueProcess) {
                        if (this.docInd == 0) {
                            DocStatusRec docStatusRec = null;
                            docRec = new DocRec(this);
                            if (!this.maintLock) {
                                this.lockDoc("TIGRIS", true, this.existingDocInd);
                            }
                            docRec.existingDocInd = this.existingDocInd;
                            docRec.docInd = 0;
                            if (docRec.existingDocInd == 0) {
                                docRec.initFields();
                                docRec.docClassRec = (TypeDocClassRec)TypeList.getInstance().objectFromInd(1, 5);
                                docRec.workReqRec = (TypeWorkRec)TypeList.getInstance().objectFromInd(1, 14);
                                docRec.source = UserSystem.getUserName();
                            } else {
                                docRec.workReqRec = (TypeWorkRec)TypeList.getInstance().objectFromInd(2, 14);
                            }
                            docRec.setFieldData(3, UserSystem.getUserId());
                            docRec.setFieldData(56, DateSystem.getDate(2));
                            docRec.request = true;
                            docRec.template = false;
                            docRec.recycled = false;
                            docRec.previewInfoValid = false;
                            docRec.history = false;
                            docRec.stopDate = null;
                            docStatusRec = new DocStatusRec();
                            docStatusRec.setStatusInd(10);
                            docStatusRec.setRecNum(1);
                            docStatusRec.setDate(DateSystem.getDate(2));
                            docStatusRec.setCountry((TypeCountryCodeRec)TypeList.getInstance().objectFromInd(PropertySystem.getInt(2), 3));
                            docRec.addStatus(docStatusRec);
                        } else {
                            docRec = new DocRec(this);
                            docRec.docInd = n;
                        }
                        docRec.forceAllRecStatus(2);
                        DocRec.forceUpdateVecRecStatus(this.mediaVec, 2);
                        DocRec.forceUpdateVecRecStatus(this.graphicVec, 2);
                    } else {
                        docRec = null;
                    }
                } else if (this.continueProcess) {
                    GUISystem.printBox(Str.getStr(6), Str.getStr(234) + " " + this.title);
                }
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            GUISystem.printBox(7, 202);
            docRec = null;
        }
        ProcessManagerSystem.removeProcess(this);
        if (!this.continueProcess) {
            docRec = null;
        }
        DocRec.getWindow().setStatus(null);
        return docRec;
    }

    public void run() {
        String string = Thread.currentThread().getName();
        if (string.equals(THREAD_CREATEDOCREQUEST)) {
            this.threadReturnObject = this.processCreateDocRequest();
        } else if (string.equals(THREAD_READDOCUMENT)) {
            this.threadReturnObject = new Boolean(this.processReadDocument());
        } else if (string.equals(THREAD_SAVEDOCUMENT)) {
            this.threadReturnObject = new Boolean(this.processSaveDocument());
        } else if (string.equals(THREAD_READFIELDSET)) {
            this.threadReturnObject = new Boolean(this.processReadFieldSet());
        } else if (string.equals(THREAD_READPREVIEWINFO)) {
            this.threadReturnObject = new Boolean(this.processReadPreviewInfo());
        } else if (string.equals(THREAD_FIRECHANGE)) {
            this.fireChange(this.lastFieldChange);
        } else if (string.equals(THREAD_SETFOREDIT)) {
            this.processSetForEdit();
        }
    }

    private void readDocProperties(DocReaderBuffer docReaderBuffer) {
        try {
            DocPropertyRec docPropertyRec = null;
            Object var3_4 = null;
            this.docPropVec = new Vector(5, 5);
            docPropertyRec = new DocPropertyRec(docReaderBuffer.descript, 2);
            docPropertyRec.updateRecStatus(1);
            docPropertyRec.updateRecStatus(2);
            this.docPropVec.addElement(docPropertyRec);
            docPropertyRec = new DocPropertyRec(DateSystem.prettyDateFromDBDate(docReaderBuffer.releaseDate), 3);
            if (docPropertyRec.value.equals("00/00/2000")) {
                docPropertyRec.value = DateSystem.getDate(2);
            }
            this.docPropVec.addElement(docPropertyRec);
            this.setFieldData(27, docReaderBuffer.url);
            docPropertyRec = new DocPropertyRec(docReaderBuffer.version, 8);
            this.docPropVec.addElement(docPropertyRec);
        }
        catch (Exception exception) {
            LogSystem.log(1, "readDocProperties, docInd:" + this.docInd + " existingDocInd:" + this.existingDocInd);
            LogSystem.log(1, exception);
        }
    }

    private void readDocProducts(DocReaderBuffer docReaderBuffer) {
        if (docReaderBuffer.prodVec != null) {
            try {
                ProductRec productRec = null;
                DocReaderProdBuffer docReaderProdBuffer = null;
                MachineRec machineRec = null;
                int n = 0;
                int n2 = docReaderBuffer.prodVec.size();
                if (this.prodDocRec == null) {
                    this.prodDocRec = new ProdDocRec();
                }
                while (n < n2) {
                    docReaderProdBuffer = (DocReaderProdBuffer)docReaderBuffer.prodVec.elementAt(n);
                    productRec = new ProductRec();
                    productRec.setFieldData(16, new Integer(docReaderProdBuffer.prodInt));
                    productRec.setFieldData(11, new Integer(docReaderProdBuffer.brandGroupInd));
                    productRec.setFieldData(4, docReaderProdBuffer.productNum);
                    productRec.setFieldData(2, docReaderProdBuffer.machine);
                    productRec.setFieldData(3, docReaderProdBuffer.model);
                    if (productRec.isOption()) {
                        productRec.readOptionInfo();
                    }
                    if (productRec.isAllMachine()) {
                        DocFamilyRec docFamilyRec = new DocFamilyRec((TypeBrandRec)productRec.getFieldData(0), (TypeGroupRec)productRec.getFieldData(1));
                        this.prodDocRec.addFamilyAllAssociation(docFamilyRec);
                    } else if (productRec.isAllModel()) {
                        machineRec = new MachineRec(docReaderProdBuffer.brandGroupInd, productRec.getStrMachine());
                        this.prodDocRec.addMachineAllAssociation(machineRec);
                        productRec = null;
                    } else {
                        machineRec = new MachineRec(docReaderProdBuffer.brandGroupInd, productRec.getStrMachine());
                        productRec.setFieldData(2, machineRec);
                        this.prodDocRec.addModelAssociation(productRec);
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                LogSystem.log(1, exception);
            }
            this.setFieldData(22, this.prodDocRec);
        }
    }

    private void readDocMedia(DocReaderBuffer docReaderBuffer) {
        if (docReaderBuffer.mediaVec != null) {
            try {
                int n = 0;
                int n2 = docReaderBuffer.mediaVec.size();
                DocReaderMediaBuffer docReaderMediaBuffer = null;
                DocFileRec docFileRec = null;
                this.mediaVec = new Vector(n2);
                while (n < n2) {
                    docReaderMediaBuffer = (DocReaderMediaBuffer)docReaderBuffer.mediaVec.elementAt(n);
                    docFileRec = new DocFileRec();
                    docFileRec.fileInd = docReaderMediaBuffer.fileInd;
                    docFileRec.descript = docReaderMediaBuffer.descript;
                    docFileRec.sFilename = docReaderMediaBuffer.sFilename;
                    docFileRec.fileSize = docReaderMediaBuffer.fileSize;
                    docFileRec.fileURL = docReaderMediaBuffer.fileURL;
                    docFileRec.version = docReaderMediaBuffer.version;
                    if (docFileRec.fileSize == 0L) {
                        this.setFieldData(27, docFileRec.fileURL);
                        docFileRec = null;
                    }
                    if (docFileRec != null) {
                        if (docFileRec.fileURL != null && docFileRec.fileURL.length() > 0) {
                            try {
                                String string = docFileRec.fileURL.substring(docFileRec.fileURL.lastIndexOf("/", docFileRec.fileURL.lastIndexOf("/") - 1));
                                docFileRec.fileLoc = string = string.substring(1, string.lastIndexOf("/"));
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                GUISystem.printBox(Str.getStr(6), Str.getStr(241) + docFileRec.fileURL);
                            }
                        }
                        this.mediaVec.addElement(docFileRec);
                    }
                    ++n;
                }
                this.setFieldData(41, this.mediaVec);
            }
            catch (Exception exception) {
                LogSystem.log(1, exception);
            }
        }
        this.initialRead = false;
    }

    private boolean readDocGraphics() {
        String string = "readDocGraphics";
        SQLMethod sQLMethod = new SQLMethod(1, string, 5);
        boolean bl = false;
        boolean bl2 = false;
        DocRec.getWindow().setStatus(242);
        if (sQLMethod != null) {
            String string2 = this.getDatabaseQualifier();
            try {
                DocFileRec docFileRec = null;
                Statement statement = sQLMethod.createStatement();
                ResultSet resultSet = statement.executeQuery("SELECT A.GRAPHICIND, B.FILENAME " + "FROM   " + string2 + ".DOCGRAPHIC A, " + "       TIGRIS.GRAPHICS B " + "WHERE  DOCIND = " + this.getDatabaseDocInd() + " AND " + "       A.GRAPHICIND = B.GRAPHICIND " + "FOR FETCH ONLY ");
                this.graphicVec = new Vector(1, 1);
                while (resultSet.next()) {
                    docFileRec = new DocFileRec();
                    docFileRec.fileInd = resultSet.getInt(1);
                    docFileRec.sFilename = resultSet.getString(2).trim();
                    this.graphicVec.addElement(docFileRec);
                }
                this.graphicVec.trimToSize();
                bl = true;
                if (this.graphicVec != null && this.graphicVec.size() > 0) {
                    String string3 = PropertySystem.getString(23);
                    int n = 0;
                    int n2 = this.graphicVec.size();
                    FTPSite fTPSite = null;
                    boolean bl3 = false;
                    DocRec.getWindow().setStatus(249);
                    fTPSite = this.isDocRequest() ? FTPSite.getFTPSite(4) : FTPSite.getFTPSite(3);
                    boolean bl4 = bl3 = !fTPSite.connect();
                    if (!bl3) {
                        boolean bl5 = bl3 = !fTPSite.login();
                    }
                    if (!bl3) {
                        bl3 = !fTPSite.setLocalDir(PropertySystem.getString(30));
                    }
                    while (n < n2 && !bl3) {
                        docFileRec = (DocFileRec)this.graphicVec.elementAt(n);
                        if (docFileRec != null) {
                            DocRec.getWindow().setStatus(Str.getStr(142) + " " + Text.stripPath(docFileRec.sFilename));
                            boolean bl6 = bl3 = !fTPSite.get(Text.stripPath(docFileRec.sFilename));
                        }
                        if (bl3) {
                            GUISystem.printBox(Str.getStr(6), "FTP Error on file:" + docFileRec.sFilename);
                        }
                        ++n;
                    }
                    fTPSite.disconnect();
                    fTPSite = null;
                    System.gc();
                }
            }
            catch (Exception exception) {
                sQLMethod.rollBack();
                LogSystem.log(1, exception);
            }
        }
        sQLMethod.close();
        return bl;
    }

    private boolean readDocStatus() {
        String string = "readDocStatus";
        SQLMethod sQLMethod = new SQLMethod(1, string, 5);
        boolean bl = false;
        boolean bl2 = false;
        DocRec.getWindow().setStatus(242);
        if (sQLMethod != null) {
            try {
                Statement statement = sQLMethod.createStatement();
                ResultSet resultSet = statement.executeQuery("SELECT STATUSIND, STATUSDATE FROM QUEST.DOCSTATUS WHERE DOCIND = " + this.getDatabaseDocInd() + " ORDER BY RECNUM");
                while (resultSet.next()) {
                    this.addStatus(new DocStatusRec(resultSet.getInt(1), DateSystem.prettyDateFromDBDate(resultSet.getString(2))));
                }
                bl = true;
            }
            catch (Exception exception) {
                sQLMethod.rollBack();
                LogSystem.log(1, string + ", docInd:" + this.docInd + " existingDocInd:" + this.existingDocInd);
                LogSystem.log(1, exception);
            }
        }
        sQLMethod.close();
        return bl;
    }

    private void readDocLinks(DocReaderBuffer docReaderBuffer) {
        if (docReaderBuffer.docLinksVec != null) {
            try {
                int n = 0;
                int n2 = docReaderBuffer.docLinksVec.size();
                DocLinkRec docLinkRec = null;
                DocReaderLinkBuffer docReaderLinkBuffer = null;
                TypeList typeList = TypeList.getInstance();
                if (this.docLinksVec == null) {
                    this.docLinksVec = new Vector(10, 10);
                } else {
                    this.docLinksVec.removeAllElements();
                }
                while (n < n2) {
                    docLinkRec = new DocLinkRec();
                    docReaderLinkBuffer = (DocReaderLinkBuffer)docReaderBuffer.docLinksVec.elementAt(n);
                    docLinkRec.docInd = docReaderLinkBuffer.docInd;
                    docLinkRec.title = docReaderLinkBuffer.title;
                    docLinkRec.docClassRec = (TypeDocClassRec)typeList.objectFromInd(docReaderLinkBuffer.docClassInd, 5);
                    docLinkRec.notesId = docReaderLinkBuffer.lndocInd;
                    this.addDocLink(docLinkRec);
                    ++n;
                }
                if (this.refDocLinksVec == null) {
                    this.refDocLinksVec = new Vector(10, 10);
                } else {
                    this.refDocLinksVec.removeAllElements();
                }
                this.refDocLinksVec = this.readReferencedLinks();
            }
            catch (Exception exception) {
                LogSystem.log(1, "readDocLinks(buffer), docInd:" + this.docInd + " existingDocInd:" + this.existingDocInd);
                LogSystem.log(1, exception);
            }
        }
    }

    public void readDocCategories(DocReaderBuffer docReaderBuffer) {
        if (docReaderBuffer.docCatVec != null) {
            try {
                int n = 0;
                int n2 = docReaderBuffer.docCatVec.size();
                TypeList typeList = TypeList.getInstance();
                this.docCatVec = new Vector(10, 1);
                while (n < n2) {
                    this.docCatVec.addElement(typeList.objectFromInd((Integer)docReaderBuffer.docCatVec.elementAt(n), 10));
                    ++n;
                }
            }
            catch (Exception exception) {
                LogSystem.log(1, "readDocCategories(buffer), docInd:" + this.docInd + " existingDocInd:" + this.existingDocInd);
                LogSystem.log(1, exception);
            }
        }
    }

    private void readDocLocale(DocReaderBuffer docReaderBuffer) {
        this.localeRec = null;
        this.localeRec = new LocaleRec();
        this.localeRec.setDataFromDatabase(docReaderBuffer);
        this.setFieldData(24, this.localeRec);
    }

    private void registerDocParams(CallableStatement callableStatement) throws SQLException {
        if (this.isDocRequest()) {
            callableStatement.setString(3, "" + this.docInd);
            callableStatement.setString(4, "0");
        } else {
            callableStatement.setString(3, "" + this.existingDocInd);
            callableStatement.setString(4, "1");
        }
    }

    public boolean isDocRequest() {
        return this.request;
    }

    public boolean sendNotification() {
        TypeBrandRec typeBrandRec = this.getDocBrand();
        NotificationRec notificationRec = new NotificationRec();
        boolean bl = false;
        if (typeBrandRec != null) {
            UserRec userRec = UserSystem.getBrandProgramManager(typeBrandRec.getInd(), "DOC");
            if (userRec != null) {
                notificationRec.toUser = userRec.getUserId();
            }
        } else {
            notificationRec.toUser = "GET_USER_FROM_BRAND";
        }
        if (notificationRec.toUser != null && !notificationRec.toUser.equals(UserSystem.getUserId())) {
            notificationRec.fromUser = UserSystem.getUserId();
            notificationRec.brandRec = typeBrandRec;
            notificationRec.mustSend = false;
            notificationRec.resolRec = (TypeResolutionRec)TypeList.getInstance().objectFromInd(0, 16);
            notificationRec.openDate = DateSystem.getDate(2);
            this.assignDocInd();
            notificationRec.subject = Str.getStr(667) + " - " + this.docInd;
            notificationRec.docInd = this.docInd;
            notificationRec = new SendNotifyDlg((Frame)DocRec.getWindow(), notificationRec).getResult();
            this.comment = notificationRec.comments;
            bl = notificationRec.notifySent;
        } else {
            bl = true;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean saveAsRequest() {
        boolean bl = false;
        LogSystem.log(1, "Saving Document Request Start");
        if (this.isRequestValid()) {
            TypeBrandRec typeBrandRec = this.getDocBrand();
            boolean bl2 = false;
            bl2 = typeBrandRec == null ? true : !this.prodDocRec.userHasAuth();
            bl = bl2 ? this.sendNotification() : true;
            this.publish = false;
            LogSystem.log(1, "Request is Valid, Checking FTP");
            if (!bl) return false;
            if (this.ftpRequestFileAttachments() && this.ftpRequestGraphics()) {
                String string;
                if (this.template) {
                    this.docInd = 0;
                    this.existingDocInd = 0;
                    this.notesId = null;
                }
                this.template = false;
                this.assignDocInd();
                this.assignExistingDocInd();
                LogSystem.log(1, "Document Indicators set. Doc Ind:" + this.docInd + "  ExistingDocInd:" + this.existingDocInd);
                this.setAllRecStatus(1);
                if (this.publishingTagsRec.eMailable && CDate.isFutureDate(string = this.publishingTagsRec.eMailableDate, 2)) {
                    String string2 = CDate.createDate(CDate.parse(string, 7, 2), CDate.parse(string, 8, 2), CDate.parse(string, 9, 2), 0, 0, 0, 13);
                    this.comment = this.comment + "\nProactive eMail has been set with the date of " + string2;
                }
                LogSystem.log(1, "Request Process Complete");
                bl = this.saveToDatabase(false);
                if (!bl) return bl;
                this.forceAllRecStatus(1);
                this.originalComment = this.comment;
                this.setFieldData(32, "");
                return bl;
            }
            GUISystem.printBox(6, 252);
            return false;
        }
        String string = "Unknown";
        if (this.title != null && this.title.length() > 0) {
            string = this.title;
        }
        GUISystem.printBox(Str.getStr(6), Str.getStr(253) + " " + string + " " + Str.getStr(254) + " " + this.getFieldDescription(this.errorFieldId));
        return false;
    }

    private boolean saveAsTemplate() {
        boolean bl = false;
        if (!this.isRequestValid()) {
            String string = "Unknown";
            if (this.title != null && this.title.length() > 0) {
                string = this.title;
            }
            GUISystem.printBox(Str.getStr(6), Str.getStr(253) + " " + string + " " + Str.getStr(254) + " " + this.getFieldDescription(this.errorFieldId));
            return false;
        }
        if (this.savePanel != null) {
            this.savePanel.setStatus(255);
        } else {
            DocRec.getWindow().setStatus(255);
            DocRec.getWindow().setStatusLock(true);
        }
        if (!this.canSaveTemplate()) {
            GUISystem.printBox(7, 256);
        } else {
            boolean bl2 = false;
            boolean bl3 = false;
            if (this.template) {
                int n = new SaveTemplateDlg((Frame)DocRec.getWindow()).getResult();
                if (n != 0) {
                    if (n == 1) {
                        this.docInd = this.templateDocInd;
                    }
                    this.forceAllRecStatus(n);
                    bl2 = true;
                } else {
                    bl2 = false;
                }
            } else {
                String string = null;
                string = new SingleEntryDlg((Frame)DocRec.getWindow(), Str.getStr(318), Str.getStr(1466), this.title, "").getResult();
                if (string != null && string.length() > 0) {
                    this.title = string;
                }
                this.forceAllRecStatus(2);
                bl2 = true;
            }
            if (bl2) {
                this.lockDoc(false);
                this.setTemplate(true);
                if (this.getRecStatus() == 2) {
                    bl3 = true;
                    this.existingDocInd = 0;
                    this.docInd = 0;
                    this.assignDocInd();
                }
                this.notesId = null;
                this.url = null;
                bl = this.saveToDatabase(true);
                if (bl && bl3) {
                    DocTemplateSystem.addTemplate((DocRec)this);
                } else if (bl && !bl3) {
                    DocTemplateSystem.removeTemplate(this.docInd);
                    DocTemplateSystem.addTemplate((DocRec)this);
                }
            }
        }
        return bl;
    }

    private boolean saveAsPublish() {
        boolean bl;
        boolean bl2 = false;
        int n = 0;
        int n2 = 0;
        if (this.showClassMessage(this.docClassRec.getInd(), this.getExistingDocInd())) {
            bl = GUISystem.printBox(8, 1657);
            if (bl) {
                GUISystem.printBox(7, 1658);
            } else {
                return false;
            }
        }
        LogSystem.log(1, "After showClassMessage, Continuing Save");
        if (!this.isPublishable()) {
            String string = "Unknown";
            LogSystem.log(1, "Is not publishable, returning FALSE");
            if (this.title != null && this.title.length() > 0) {
                string = this.title;
            }
            GUISystem.printBox(Str.getStr(6), Str.getStr(253) + " " + string + " " + Str.getStr(254) + " " + this.getFieldDescription(this.errorFieldId));
            return false;
        }
        bl = true;
        if (this.publishingTagsRec == null || !this.publishingTagsRec.webOnly && !this.publishingTagsRec.webable) {
            bl = GUISystem.printBox(8, 257);
        }
        if (!bl) {
            return false;
        }
        LogSystem.log(1, "After isPublishable, continuing Save");
        this.publish = true;
        if (this.graphicVec != null) {
            n2 = this.graphicVec.size();
            while (n < n2) {
                if (((DocFileRec)this.graphicVec.elementAt(n)).getFTPRecStatus() != 3) {
                    ((DocFileRec)this.graphicVec.elementAt(n)).setFTPRecStatus(2);
                }
                ++n;
            }
        }
        LogSystem.log(1, "AFter setting Graphic Vars, continuing save");
        if (this.docTypeRec.ind == 9 && this.existingDocInd != 0) {
            this.publish = this.syncSSDAttach();
        }
        LogSystem.log(1, "After setting SSD SYnc Attach, continuing to save");
        if (this.ftpPublishFileAttachments() && this.ftpPublishHeaders() && this.ftpPublishGraphics()) {
            this.addStatus(new DocStatusRec(8, DateSystem.getDate(2)));
            if (this.template) {
                this.docInd = 0;
                this.existingDocInd = 0;
                this.template = false;
                this.notesId = null;
            }
            this.assignDocInd();
            this.assignExistingDocInd();
            LogSystem.log(1, "Document Indicators Set, continuing Save");
            this.setStopDate();
            if (this.getRecStatus() != 2) {
                this.forceAllRecStatus(1);
            }
            LogSystem.log(1, "Saving Document to Database");
            bl2 = this.saveToDatabase(false);
            if (bl2) {
                LogSystem.log(1, "After Saving Document Draft, Continuing to Publish");
            } else {
                LogSystem.log(1, "After Saving Document Draft, DIS-Continuing to Publish");
            }
            if (bl2) {
                this.request = false;
                this.template = false;
                this.recycled = false;
                this.docInd = 0;
                if (this.workReqRec.ind == 1) {
                    this.forceAllRecStatus(2);
                    LogSystem.log(1, "Setting recStatus to REC_INSERT because work required is create");
                } else if (this.workReqRec.ind == 2) {
                    this.forceAllRecStatus(1);
                    LogSystem.log(1, "Setting recStatus to REC_UPDATE because work required is edit");
                }
                if (this.workReqRec.ind == 3) {
                    try {
                        this.getSavePanel().setStatus(Str.getStr(239));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.deleteDocument("TIGRIS");
                } else {
                    DocRec.forceUpdateVecRecStatus(this.graphicVec, 2);
                    DocRec.forceUpdateVecRecStatus(this.mediaVec, 2);
                    bl2 = this.saveToDatabase(true);
                }
            }
        } else {
            LogSystem.log(1, "Can't FTP Files");
            GUISystem.printBox(6, 252);
            bl2 = false;
        }
        LogSystem.log(1, "Done save. RC:" + bl2);
        return bl2;
    }

    public void setTemplate(boolean bl) {
        this.template = bl;
        this.publish = false;
        this.request = bl;
        this.notesId = null;
        if (bl && this.docInd != 0) {
            this.templateDocInd = this.docInd;
        }
    }

    public int assignDocInd() {
        if ((this.isDocRequest() || this.isTemplate()) && this.docInd == 0) {
            this.docInd = Counter.getCounter(LogSystem.getInstance(), "DOCREQIND");
        }
        return this.docInd;
    }

    public int assignExistingDocInd() {
        if (this.existingDocInd == 0) {
            this.existingDocInd = Counter.getCounter(LogSystem.getInstance(), "DOCIND");
        }
        if (this.isTemplate()) {
            this.notesId = null;
        }
        return this.existingDocInd;
    }

    private boolean saveAsDelete() {
        boolean bl = false;
        boolean bl2 = false;
        Vector vector = null;
        try {
            this.getSavePanel().setStatus(258);
        }
        catch (Exception exception) {
            // empty catch block
        }
        vector = this.readReferencedLinks();
        if (vector != null) {
            if (this.saveDocRec.saveType != 5) {
                bl2 = GUISystem.printBox(8, 259);
                bl = false;
            } else {
                bl = true;
            }
        } else {
            bl = true;
        }
        if (bl2) {
            new DocLinkDlg(DocRec.getWindow(), vector);
        }
        if (bl && this.saveDocRec.saveType != 5 && this.publishingTagsRec.knowledgeBase) {
            GUISystem.printBox(7, 1545);
            bl = false;
        }
        if (bl) {
            try {
                this.getSavePanel().setStatus(260);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setStopDate();
            this.assignDocInd();
            bl = this.saveToDatabase(false);
        }
        if (bl) {
            this.request = false;
            this.recycled = false;
            this.template = false;
            try {
                this.getSavePanel().setStatus(239);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.deleteDocument("TIGRIS");
        }
        return bl;
    }

    private boolean saveAsCancel() {
        boolean bl = false;
        if (this.isDocRequest() || this.isTemplate()) {
            boolean bl2;
            int n = this.getNotifyInd();
            if (n != 0 && (bl2 = GUISystem.printBox(8, 1325))) {
                SQLMethod sQLMethod = new SQLMethod(1, "deleteNotify", 5);
                try {
                    Statement statement = sQLMethod.createStatement();
                    if (statement != null) {
                        statement.executeQuery("DELETE FROM QUEST.NOTIFICATION " + "WHERE DOCIND = " + this.docInd + " AND " + "      DBUSER = '" + UserSystem.getUserId() + "'");
                    }
                }
                catch (Exception exception) {
                    sQLMethod.rollBack();
                    LogSystem.log(1, exception, false);
                }
                sQLMethod.close();
            }
            try {
                this.getSavePanel().setStatus(261);
            }
            catch (Exception exception) {
                // empty catch block
            }
            bl = this.deleteDocument("QUEST");
        }
        return bl;
    }

    private int getNotifyInd() {
        int n = 0;
        SQLMethod sQLMethod = new SQLMethod(1, "DocRec.notifyInd", 5);
        try {
            Statement statement = sQLMethod.createStatement();
            if (statement != null) {
                ResultSet resultSet = statement.executeQuery("SELECT NOTEIND " + "FROM QUEST.NOTIFICATION " + "WHERE DBUSER = '" + UserSystem.getUserId() + "' AND " + "      DOCIND = " + this.docInd);
                if (resultSet.next()) {
                    n = resultSet.getInt(1);
                }
                resultSet.close();
            }
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception, false);
        }
        sQLMethod.close();
        return n;
    }

    public boolean isTemplate() {
        return this.template;
    }

    public boolean saveDocLocale(StringBuffer stringBuffer) {
        boolean bl = false;
        String string = "saveDocLocale";
        if (this.localeRec != null) {
            try {
                String string2 = this.getDatabaseQualifier() + ".DOCGEO";
                String string3 = this.getDatabaseQualifier() + ".DOCCOUNTRY";
                Object var6_7 = null;
                Object var7_8 = null;
                String string4 = null;
                stringBuffer.append("DELETE FROM " + string2 + " WHERE DOCIND = " + this.getDatabaseDocInd() + QITSqlRunner.END_DELIM);
                stringBuffer.append("DELETE FROM " + string3 + " WHERE DOCIND = " + this.getDatabaseDocInd() + QITSqlRunner.END_DELIM);
                if (this.localeRec.isWorldWide()) {
                    string4 = "INSERT INTO " + string2 + " " + "( DOCIND, GEOIND, DBUSER, CHANGEDTIME )" + "VALUES " + " ( " + this.getDatabaseDocInd() + ", " + "   6, " + "   '" + UserSystem.getUserId() + "', " + "   CURRENT TIMESTAMP )";
                    stringBuffer.append(string4 + QITSqlRunner.END_DELIM);
                } else {
                    int n;
                    Vector vector = this.localeRec.getGeoListContainingAll();
                    Vector vector2 = this.localeRec.getSingleCountryList();
                    int n2 = 0;
                    if (vector != null && vector.size() > 0) {
                        n = vector.size();
                        while (n2 < n) {
                            string4 = "INSERT INTO " + string2 + " " + "(DOCIND, GEOIND, DBUSER, CHANGEDTIME )" + "VALUES " + "( " + this.getDatabaseDocInd() + ", " + "  " + ((TypeGeoRec)vector.elementAt((int)n2)).ind + ", " + "  '" + UserSystem.getUserId() + "', " + "  CURRENT TIMESTAMP )";
                            stringBuffer.append(string4 + QITSqlRunner.END_DELIM);
                            ++n2;
                        }
                    }
                    if (vector2 != null && vector2.size() > 0) {
                        n = vector2.size();
                        n2 = 0;
                        while (n2 < n) {
                            string4 = "INSERT INTO " + string3 + " " + "(DOCIND, COUNTRYCODEIND, DBUSER, CHANGEDTIME )" + "VALUES " + "( " + this.getDatabaseDocInd() + ", " + "  " + ((TypeCountryCodeRec)vector2.elementAt((int)n2)).ind + ", " + "  '" + UserSystem.getUserId() + "', " + "  CURRENT TIMESTAMP )";
                            stringBuffer.append(string4 + QITSqlRunner.END_DELIM);
                            ++n2;
                        }
                    }
                }
                bl = true;
            }
            catch (Exception exception) {
                LogSystem.log(1, exception);
            }
        } else {
            bl = true;
        }
        return bl;
    }

    public boolean saveDocProductAssociations(StringBuffer stringBuffer) {
        boolean bl = false;
        String string = "saveDocProductAssociations";
        if (this.prodDocRec != null) {
            try {
                boolean bl2 = true;
                Vector vector = this.prodDocRec.getAssociatedFamilies();
                Vector vector2 = this.prodDocRec.getAssociatedMachines();
                Vector vector3 = this.prodDocRec.getAssociatedModels();
                int n = 0;
                int n2 = vector.size();
                DocFamilyRec docFamilyRec = null;
                MachineRec machineRec = null;
                ProductRec productRec = null;
                stringBuffer.append("DELETE FROM " + this.getDatabaseQualifier() + ".DOCBRAND WHERE DOCIND = " + this.getDatabaseDocInd() + QITSqlRunner.END_DELIM);
                stringBuffer.append("DELETE FROM " + this.getDatabaseQualifier() + ".PRODDOCS WHERE DOCIND = " + this.getDatabaseDocInd() + QITSqlRunner.END_DELIM);
                while (n < n2) {
                    docFamilyRec = (DocFamilyRec)vector.elementAt(n);
                    stringBuffer.append("INSERT INTO " + this.getDatabaseQualifier() + ".DOCBRAND " + "( BRANDGROUPIND, DOCIND, DBUSER, CHANGEDTIME ) " + "VALUES " + "( " + docFamilyRec.getBrandGroupInd() + ", " + "  " + this.getDatabaseDocInd() + ", " + " '" + UserSystem.getUserId() + "', " + "  CURRENT TIMESTAMP )" + QITSqlRunner.END_DELIM);
                    ++n;
                }
                n = 0;
                while (n < n2) {
                    docFamilyRec = (DocFamilyRec)vector.elementAt(n);
                    if (docFamilyRec.getAll()) {
                        stringBuffer.append("INSERT INTO " + this.getDatabaseQualifier() + ".PRODDOCS " + "( PRODINT, DOCIND, DBUSER, CHANGEDTIME ) " + "VALUES " + "( " + AppSQL.getAllAllProdInt((int)docFamilyRec.getBrandGroupInd()) + ", " + "  " + this.getDatabaseDocInd() + ", " + " '" + UserSystem.getUserId() + "', " + "  CURRENT TIMESTAMP )" + QITSqlRunner.END_DELIM);
                    }
                    ++n;
                }
                n = 0;
                n2 = vector2.size();
                while (n < n2) {
                    machineRec = (MachineRec)vector2.elementAt(n);
                    if (machineRec.getAll()) {
                        if (machineRec.isOption()) {
                            stringBuffer.append("INSERT INTO " + this.getDatabaseQualifier() + ".PRODDOCS " + "( PRODINT, DOCIND, DBUSER, CHANGEDTIME ) " + "VALUES " + "( " + AppSQL.getAllModelOptionInt((String)machineRec.getMachine(), (int)machineRec.getBrandGroupInd()) + ", " + "  " + this.getDatabaseDocInd() + ", " + " '" + UserSystem.getUserId() + "', " + "  CURRENT TIMESTAMP )" + QITSqlRunner.END_DELIM);
                        } else {
                            stringBuffer.append("INSERT INTO " + this.getDatabaseQualifier() + ".PRODDOCS " + "( PRODINT, DOCIND, DBUSER, CHANGEDTIME ) " + "VALUES " + "( " + AppSQL.getAllModelProdInt((String)machineRec.getMachine(), (int)machineRec.getBrandGroupInd()) + ", " + "  " + this.getDatabaseDocInd() + ", " + " '" + UserSystem.getUserId() + "', " + "  CURRENT TIMESTAMP )" + QITSqlRunner.END_DELIM);
                        }
                    }
                    ++n;
                }
                n = 0;
                n2 = vector3.size();
                while (n < n2) {
                    productRec = (ProductRec)vector3.elementAt(n);
                    stringBuffer.append("INSERT INTO " + this.getDatabaseQualifier() + ".PRODDOCS " + "( PRODINT, DOCIND, DBUSER, CHANGEDTIME ) " + "VALUES " + "( " + productRec.getProdInt() + ", " + "  " + this.getDatabaseDocInd() + ", " + " '" + UserSystem.getUserId() + "', " + "  CURRENT TIMESTAMP )" + QITSqlRunner.END_DELIM);
                    ++n;
                }
                bl = true;
            }
            catch (Exception exception) {
                LogSystem.log(1, exception);
            }
        } else {
            bl = true;
        }
        return bl;
    }

    public boolean saveDocStatusHistory(StringBuffer stringBuffer) {
        boolean bl = false;
        String string = "saveDocStatusHistory";
        if ((this.isDocRequest() || this.isTemplate()) && this.statusRec != null) {
            try {
                SQLStatement sQLStatement = new SQLStatement(this.getDatabaseQualifier() + ".DOCSTATUS");
                boolean bl2 = false;
                sQLStatement.setColumnNames(8);
                sQLStatement.setWhereColumnNames(1);
                sQLStatement.setWhereColumnName(0, "DOCIND", "=");
                sQLStatement.setWhereData(0, this.getDatabaseDocInd());
                if (this.statusRec != null && this.statusRec.getRecStatus() != 3) {
                    this.statusRec.setRecNum(2);
                    sQLStatement.setColumnData(0, "DOCIND", this.getDatabaseDocInd());
                    sQLStatement.setColumnData(1, "RECNUM", this.statusRec.getRecNum());
                    sQLStatement.setColumnData(2, "STATUSIND", this.statusRec.getStatusInd());
                    sQLStatement.setColumnData(3, "COUNTRYCODEIND", PropertySystem.getInt(2));
                    sQLStatement.setColumnData(4, "STATUSDATE", this.statusRec.getDate());
                    sQLStatement.setColumnData(5, "REFERENCE", this.statusRec.getComment());
                    sQLStatement.setColumnData(6, "DBUSER", UserSystem.getUserId());
                    sQLStatement.setColumnData(7, "CHANGEDTIME", "CURRENT TIMESTAMP");
                    stringBuffer.append("DELETE FROM QUEST.DOCSTATUS WHERE RECNUM <> 1 AND DOCIND = " + this.getDatabaseDocInd() + QITSqlRunner.END_DELIM);
                    sQLStatement.setType(1);
                    stringBuffer.append(sQLStatement.toString() + QITSqlRunner.END_DELIM);
                    this.statusRec.updateRecStatus(0);
                }
                bl = true;
            }
            catch (Exception exception) {
                LogSystem.log(1, exception);
            }
        } else {
            bl = true;
        }
        return bl;
    }

    public boolean saveDocCategories(StringBuffer stringBuffer) {
        boolean bl = false;
        String string = "DocRec.saveDocCategories";
        if (this.docCatVec != null) {
            try {
                SQLStatement sQLStatement = new SQLStatement(this.getDatabaseQualifier() + ".DOCCATEGORY");
                int n = 0;
                int n2 = this.docCatVec.size();
                TypeDocCatRec typeDocCatRec = null;
                boolean bl2 = false;
                sQLStatement.setColumnNames(4);
                sQLStatement.setWhereColumnNames(1);
                sQLStatement.setWhereColumnName(0, "DOCIND", "=");
                sQLStatement.setWhereData(0, this.getDatabaseDocInd());
                sQLStatement.setType(3);
                stringBuffer.append(sQLStatement.toString() + QITSqlRunner.END_DELIM);
                sQLStatement.setType(1);
                while (n < n2) {
                    typeDocCatRec = (TypeDocCatRec)this.docCatVec.elementAt(n);
                    if (typeDocCatRec != null && typeDocCatRec.getRecStatus() != 3) {
                        sQLStatement.setColumnData(0, "DOCIND", this.getDatabaseDocInd());
                        sQLStatement.setColumnData(1, "DOCCATIND", typeDocCatRec.getInd());
                        sQLStatement.setColumnData(2, "DBUSER", UserSystem.getUserId());
                        sQLStatement.setColumnData(3, "CHANGEDTIME", "CURRENT TIMESTAMP");
                        stringBuffer.append(sQLStatement.toString() + QITSqlRunner.END_DELIM);
                        typeDocCatRec.updateRecStatus(0);
                    }
                    ++n;
                }
                bl = true;
            }
            catch (Exception exception) {
                LogSystem.log(1, exception);
            }
        } else {
            bl = true;
        }
        return bl;
    }

    public boolean saveDocQueryText() throws Exception {
        SQLMethod sQLMethod = new SQLMethod(1, "saveDocQueryText", 5);
        boolean bl = false;
        if (this.savePanel != null) {
            this.savePanel.setStatus(342);
        } else {
            DocRec.getWindow().setStatus(342);
            DocRec.getWindow().setStatusLock(true);
        }
        if (sQLMethod != null) {
            SQLStatement sQLStatement = new SQLStatement(this.getDatabaseQualifier() + ".DOCQUERYTEXT");
            PreparedStatement preparedStatement = null;
            sQLStatement.setColumnNames(5);
            sQLStatement.setWhereColumnNames(1);
            sQLStatement.setWhereColumnName(0, "DOCIND", "=");
            sQLStatement.setWhereData(0, this.getDatabaseDocInd());
            switch (this.getRecStatus()) {
                case 1: 
                case 2: {
                    sQLStatement.setType(3);
                    preparedStatement = sQLMethod.createPreparedStatement(sQLStatement.toString());
                    preparedStatement.execute();
                    sQLStatement.setType(1);
                    sQLStatement.setColumnData(0, "DOCIND", this.getDatabaseDocInd());
                    sQLStatement.setColumnData(1, "QUERYTEXT", "?");
                    sQLStatement.setColumnData(2, "DBUSER", UserSystem.getUserId());
                    sQLStatement.setColumnData(3, "CHANGEDTIME", "CURRENT TIMESTAMP");
                    preparedStatement = sQLMethod.createPreparedStatement(sQLStatement.toString());
                    if (this.queryText == null) {
                        this.queryText = " ";
                    }
                    preparedStatement.setString(1, this.queryText);
                    preparedStatement.execute();
                    break;
                }
                case 3: {
                    sQLStatement.setType(3);
                    preparedStatement = sQLMethod.createPreparedStatement(sQLStatement.toString());
                    preparedStatement.execute();
                    break;
                }
            }
            bl = true;
        } else {
            bl = true;
        }
        sQLMethod.close();
        return bl;
    }

    public boolean saveDocGraphics(StringBuffer stringBuffer, boolean bl) {
        boolean bl2 = false;
        String string = "saveDocGraphics";
        int n = 0;
        if (this.graphicVec != null && this.removeDupGraphics()) {
            try {
                SQLStatement sQLStatement = new SQLStatement(this.getDatabaseQualifier() + ".DOCGRAPHIC");
                int n2 = this.graphicVec.size();
                DocFileRec docFileRec = null;
                sQLStatement.setColumnNames(4);
                sQLStatement.setWhereColumnNames(1);
                sQLStatement.setWhereColumnName(0, "DOCIND", "=");
                sQLStatement.setWhereData(0, this.getDatabaseDocInd());
                stringBuffer.append("DELETE FROM " + this.getDatabaseQualifier() + ".DOCGRAPHIC WHERE DOCIND     = " + this.getDatabaseDocInd() + QITSqlRunner.END_DELIM);
                while (n < n2) {
                    docFileRec = (DocFileRec)this.graphicVec.elementAt(n);
                    if (docFileRec != null) {
                        switch (docFileRec.getRecStatus()) {
                            case 3: {
                                if (docFileRec.fileInd <= 0 || !bl) break;
                                AppSQL.saveGraphic((DocFileRec)docFileRec);
                                break;
                            }
                            default: {
                                if (bl) {
                                    AppSQL.saveGraphic((DocFileRec)docFileRec);
                                }
                                sQLStatement.setType(1);
                                sQLStatement.setColumnData(0, "DOCIND", this.getDatabaseDocInd());
                                sQLStatement.setColumnData(1, "GRAPHICIND", docFileRec.fileInd);
                                sQLStatement.setColumnData(2, "DBUSER", UserSystem.getUserId());
                                sQLStatement.setColumnData(3, "CHANGEDTIME", "CURRENT TIMESTAMP");
                                stringBuffer.append(sQLStatement.toString() + QITSqlRunner.END_DELIM);
                                break;
                            }
                        }
                    }
                    ++n;
                }
                bl2 = true;
            }
            catch (Exception exception) {
                LogSystem.log(1, exception);
            }
        } else {
            bl2 = true;
        }
        return bl2;
    }

    public boolean saveDocBody() throws Exception {
        SQLMethod sQLMethod = new SQLMethod(1, "saveDocBody", 5);
        boolean bl = false;
        String string = "saveDocBody";
        if (this.savePanel != null) {
            this.savePanel.setStatus(262);
        } else {
            DocRec.getWindow().setStatus(262);
            DocRec.getWindow().setStatusLock(true);
        }
        if (sQLMethod != null && this.body != null) {
            SQLStatement sQLStatement = new SQLStatement(this.getDatabaseQualifier() + ".DOCBODY");
            PreparedStatement preparedStatement = null;
            boolean bl2 = false;
            sQLStatement.setColumnNames(5);
            sQLStatement.setWhereColumnNames(1);
            sQLStatement.setWhereColumnName(0, "DOCIND", "=");
            sQLStatement.setWhereData(0, this.getDatabaseDocInd());
            switch (this.getRecStatus()) {
                case 1: 
                case 2: {
                    String string2 = null;
                    int n = 0;
                    int n2 = this.body.length();
                    sQLStatement.setType(3);
                    preparedStatement = sQLMethod.createPreparedStatement(sQLStatement.toString());
                    preparedStatement.execute();
                    sQLStatement.setType(1);
                    if (n2 > 32000) {
                        int n3 = this.body.length() / 32000;
                        ++n3;
                        int n4 = 0;
                        while (n4 < n3) {
                            String string3 = "";
                            string2 = n > n2 - 32000 ? this.body.substring(n, this.body.length()) : this.body.substring(n, n + 32000);
                            n += 32000;
                            string3 = "INSERT INTO " + this.getDatabaseQualifier() + ".DOCBODY " + "( DOCIND, RECNUM, BODY, DBUSER, CHANGEDTIME ) VALUES " + " ( " + this.getDatabaseDocInd() + ", " + "   " + (n4 + 1) + ", " + "   ?, " + "  '" + UserSystem.getUserId() + "', " + "   CURRENT TIMESTAMP)";
                            preparedStatement = sQLMethod.createPreparedStatement(string3);
                            preparedStatement.setString(1, string2);
                            preparedStatement.execute();
                            ++n4;
                        }
                        break;
                    }
                    sQLStatement.setColumnData(0, "DOCIND", this.getDatabaseDocInd());
                    sQLStatement.setColumnData(1, "RECNUM", 1);
                    sQLStatement.setColumnData(2, "BODY", "?");
                    sQLStatement.setColumnData(3, "DBUSER", UserSystem.getUserId());
                    sQLStatement.setColumnData(4, "CHANGEDTIME", "CURRENT TIMESTAMP");
                    preparedStatement = sQLMethod.createPreparedStatement(sQLStatement.toString());
                    preparedStatement.setString(1, this.body);
                    preparedStatement.execute();
                    break;
                }
                case 3: {
                    sQLStatement.setType(3);
                    preparedStatement = sQLMethod.createPreparedStatement(sQLStatement.toString());
                    preparedStatement.execute();
                    break;
                }
            }
            bl = true;
        } else {
            bl = true;
        }
        sQLMethod.close();
        return bl;
    }

    public boolean saveDocDescript(StringBuffer stringBuffer) {
        boolean bl = false;
        String string = "saveDocDescript";
        DocPropertyRec docPropertyRec = this.getProperty(2);
        if (docPropertyRec != null) {
            try {
                String string2 = this.getDatabaseQualifier() + ".DOCPROPERTIES";
                int n = 0;
                int n2 = this.getDatabaseDocInd();
                docPropertyRec.value = Text.cleanDBString(docPropertyRec.value);
                switch (this.getRecStatus()) {
                    case 1: 
                    case 2: {
                        Object var8_9 = null;
                        int n3 = 0;
                        String string3 = docPropertyRec.value;
                        int n4 = string3.length();
                        if (docPropertyRec.value.length() > 254) {
                            boolean bl2 = true;
                            String[] stringArray = new String[docPropertyRec.value.length() / 254 + 1];
                            n3 = 0;
                            while (bl2) {
                                if (n3 > docPropertyRec.value.length() - 254) {
                                    stringArray[n] = docPropertyRec.value.substring(n3);
                                    bl2 = false;
                                    continue;
                                }
                                stringArray[n] = docPropertyRec.value.substring(n3, n3 + 254);
                                ++n;
                                n3 += 254;
                            }
                            int n5 = 0;
                            while (n5 < stringArray.length) {
                                stringBuffer.append("INSERT INTO " + string2 + " (DOCIND, VALUE, PROPERTYIND, ORDERNUM, DBUSER, CHANGEDTIME) " + "values (  " + n2 + ", " + "         '" + stringArray[n5] + "', " + "         2, " + "         " + (n5 + 1) + ", " + "        '" + UserSystem.getUserId() + "', " + "        CURRENT TIMESTAMP)" + QITSqlRunner.END_DELIM);
                                ++n5;
                            }
                            break;
                        }
                        stringBuffer.append("INSERT INTO " + string2 + " (DOCIND, VALUE, PROPERTYIND, ORDERNUM, DBUSER, CHANGEDTIME) " + "values (  " + n2 + ", " + "         '" + docPropertyRec.value + "', " + "         2, " + "         1, " + "        '" + UserSystem.getUserId() + "', " + "        CURRENT TIMESTAMP)" + QITSqlRunner.END_DELIM);
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                bl = true;
            }
            catch (Exception exception) {
                LogSystem.log(1, exception);
            }
        }
        return bl;
    }

    public boolean saveDocLinks(StringBuffer stringBuffer) {
        boolean bl = false;
        String string = "saveDocLinks";
        int n = 0;
        String string2 = this.getDatabaseQualifier();
        if (this.docLinksVec != null && this.removeDupLinks()) {
            try {
                int n2 = this.docLinksVec.size();
                DocLinkRec docLinkRec = null;
                boolean bl2 = true;
                stringBuffer.append("DELETE FROM " + string2 + ".DOCLINKS WHERE DOCIND = " + this.getDatabaseDocInd() + QITSqlRunner.END_DELIM);
                while (bl2 && n < n2) {
                    docLinkRec = (DocLinkRec)this.docLinksVec.elementAt(n);
                    if (docLinkRec != null && docLinkRec.getRecStatus() != 3) {
                        stringBuffer.append("INSERT INTO " + string2 + ".DOCLINKS " + "( DOCIND, DOCLINKIND, DBUSER, CHANGEDTIME ) " + "VALUES " + "( " + this.getDatabaseDocInd() + ", " + "  " + docLinkRec.docInd + ", " + " '" + UserSystem.getUserId() + "', " + "  CURRENT TIMESTAMP )" + QITSqlRunner.END_DELIM);
                        docLinkRec.updateRecStatus(0);
                    }
                    ++n;
                }
                bl = bl2;
            }
            catch (Exception exception) {
                LogSystem.log(1, exception);
            }
        } else {
            bl = true;
        }
        return bl;
    }

    public boolean saveDocMedia(StringBuffer stringBuffer, boolean bl) {
        Object object;
        boolean bl2 = false;
        String string = "DocRec.saveDocMedia";
        int n = 0;
        if (this.mediaVec != null && this.removeDupMedia()) {
            try {
                object = new SQLStatement(this.getDatabaseQualifier() + ".DOCMEDIA");
                int n2 = this.mediaVec.size();
                DocFileRec docFileRec = null;
                boolean bl3 = true;
                ((SQLStatement)object).setColumnNames(4);
                ((SQLStatement)object).setWhereColumnNames(1);
                ((SQLStatement)object).setWhereColumnName(0, "DOCIND", "=");
                ((SQLStatement)object).setWhereData(0, this.getDatabaseDocInd());
                stringBuffer.append("DELETE FROM " + this.getDatabaseQualifier() + ".DOCMEDIA WHERE DOCIND = " + this.getDatabaseDocInd() + QITSqlRunner.END_DELIM);
                while (n < n2 && bl3) {
                    docFileRec = (DocFileRec)this.mediaVec.elementAt(n);
                    if (docFileRec != null) {
                        LogSystem.log(1, "Filename:" + docFileRec.sFilename);
                        LogSystem.log(1, "RecStatus:" + docFileRec.getRecStatus());
                        LogSystem.log(1, "FTP RecStatus:" + docFileRec.getFTPRecStatus());
                        if (docFileRec.fileInd == 0) {
                            docFileRec.fileInd = Counter.getCounter(LogSystem.getInstance(), "MEDIAIND");
                        }
                        if (bl) {
                            AppSQL.saveMedia((DocFileRec)docFileRec);
                        }
                        if (docFileRec.getRecStatus() == 2 || docFileRec.getRecStatus() == 1 || docFileRec.getRecStatus() == 0) {
                            ((SQLStatement)object).setType(1);
                            ((SQLStatement)object).setColumnData(0, "DOCIND", this.getDatabaseDocInd());
                            ((SQLStatement)object).setColumnData(1, "MULTIMEDIAIND", docFileRec.fileInd);
                            ((SQLStatement)object).setColumnData(2, "DBUSER", UserSystem.getUserId());
                            ((SQLStatement)object).setColumnData(3, "CHANGEDTIME", "CURRENT TIMESTAMP");
                            stringBuffer.append(((SQLStatement)object).toString() + QITSqlRunner.END_DELIM);
                        }
                    }
                    ++n;
                }
                bl2 = bl3;
            }
            catch (Exception exception) {
                LogSystem.log(1, exception);
            }
        } else {
            bl2 = true;
        }
        if (bl2 && this.url != null && this.url.length() > 0) {
            object = new SQLMethod(1, "saveDocMedia", 5);
            try {
                String string2 = null;
                int n3 = Counter.getCounter(LogSystem.getInstance(), "MEDIAIND");
                string2 = this.url.indexOf("/") >= 0 ? this.url.substring(this.url.lastIndexOf("/"), this.url.length()) : (this.url.length() > 50 ? this.url.substring(0, 50) : this.url);
                stringBuffer.append("DELETE FROM QUEST.DOCMEDIA " + "WHERE MULTIMEDIAIND IN (SELECT A.MULTIMEDIAIND FROM QUEST.DOCMEDIA A, " + "                        TIGRIS.MULTIMEDIA B WHERE A.DOCIND = " + this.docInd + " AND " + "                        A.MULTIMEDIAIND = B.MULTIMEDIAIND AND B.SIZE = 0) " + QITSqlRunner.END_DELIM);
                stringBuffer.append("DELETE FROM TIGRIS.DOCMEDIA " + "WHERE MULTIMEDIAIND IN (SELECT A.MULTIMEDIAIND FROM TIGRIS.DOCMEDIA A, " + "                        TIGRIS.MULTIMEDIA B WHERE A.DOCIND = " + this.existingDocInd + " AND " + "                        A.MULTIMEDIAIND = B.MULTIMEDIAIND AND B.SIZE = 0) " + QITSqlRunner.END_DELIM);
                stringBuffer.append("INSERT INTO TIGRIS.MULTIMEDIA " + "( MULTIMEDIAIND, MEDIAIND, GENINFO,     FILENAME, " + "  SIZE,          FILEURL,  FILEVERSION, DBUSER, " + "  CHANGEDTIME )" + "VALUES " + "(  " + n3 + ", 0, ' ', '" + ((SQLMethod)object).cleanDBString(string2) + "', 0, " + "  '" + ((SQLMethod)object).cleanDBString(this.url) + "'," + "  ' " + "'," + "  '" + UserSystem.getUserId() + "'," + "  CURRENT TIMESTAMP )" + QITSqlRunner.END_DELIM);
                stringBuffer.append("INSERT INTO " + this.getDatabaseQualifier() + ".DOCMEDIA " + "( DOCIND, MULTIMEDIAIND, DBUSER, CHANGEDTIME ) " + "VALUES " + "( " + this.getDatabaseDocInd() + ", " + n3 + ", '" + UserSystem.getUserId() + "', CURRENT TIMESTAMP )" + QITSqlRunner.END_DELIM);
            }
            catch (Exception exception) {
                ((SQLMethod)object).rollBack();
                bl2 = false;
                LogSystem.log(1, exception);
            }
            ((SQLMethod)object).close();
        }
        LogSystem.endLogSection();
        return bl2;
    }

    public boolean saveDocProperties(StringBuffer stringBuffer) {
        boolean bl = false;
        String string = "saveDocProperties";
        String string2 = this.getDatabaseQualifier();
        if (this.docPropVec != null) {
            boolean bl2 = true;
            try {
                String string3 = string2 + ".DOCPROPERTIES";
                int n = 0;
                int n2 = this.docPropVec.size();
                DocPropertyRec docPropertyRec = null;
                String string4 = "";
                int n3 = this.getDatabaseDocInd();
                stringBuffer.append("DELETE FROM " + string3 + " WHERE PROPERTYIND <> 1 AND DOCIND = " + n3 + QITSqlRunner.END_DELIM);
                if (this.saveDocDescript(stringBuffer)) {
                    while (n < n2) {
                        docPropertyRec = (DocPropertyRec)this.docPropVec.elementAt(n);
                        if (docPropertyRec != null && docPropertyRec.propInd != 2 && docPropertyRec.getRecStatus() != 3) {
                            if (docPropertyRec.propInd == 3) {
                                string4 = CDate.createDate(CDate.parse(docPropertyRec.value, 7, 2), CDate.parse(docPropertyRec.value, 8, 2), CDate.parse(docPropertyRec.value, 9, 2), 0, 0, 0, 10);
                                if (string4.indexOf("/") != -1) {
                                    string4 = Text.replaceAllStrInStr(string4, "/", "-");
                                }
                            } else {
                                string4 = docPropertyRec.value;
                            }
                            string4 = Text.cleanDBString(string4);
                            stringBuffer.append("INSERT INTO " + string3 + " (DOCIND, VALUE, PROPERTYIND, ORDERNUM, DBUSER, CHANGEDTIME) " + "values (  " + n3 + ", " + "         '" + string4 + "', " + "         " + docPropertyRec.propInd + ", " + "         1, " + "        '" + UserSystem.getUserId() + "', " + "        CURRENT TIMESTAMP)" + QITSqlRunner.END_DELIM);
                            docPropertyRec.updateRecStatus(0);
                        }
                        ++n;
                    }
                }
                bl = true;
            }
            catch (Exception exception) {
                LogSystem.log(1, exception);
            }
        } else {
            bl = true;
        }
        return bl;
    }

    private String getDatabaseQualifier() {
        if (this.isDocRequest() || this.isTemplate()) {
            return "QUEST";
        }
        return "TIGRIS";
    }

    public int getDatabaseDocInd() {
        int n = 0;
        n = this.isDocRequest() || this.isTemplate() || this.recycled ? this.docInd : this.existingDocInd;
        return n;
    }

    public boolean isPublishing() {
        return this.publish;
    }

    public boolean readFieldSet(int n) {
        boolean bl = false;
        this.readFieldId = n;
        Thread thread = new Thread((Runnable)this, THREAD_READFIELDSET);
        thread.start();
        try {
            thread.join();
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
        if (this.threadReturnObject instanceof Boolean) {
            bl = (Boolean)this.threadReturnObject;
        }
        return bl;
    }

    private boolean processReadFieldSet() {
        boolean bl = false;
        return bl;
    }

    public boolean readPreviewInfo() {
        boolean bl = false;
        Thread thread = new Thread((Runnable)this, THREAD_READPREVIEWINFO);
        thread.start();
        try {
            thread.join();
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
        if (this.threadReturnObject instanceof Boolean) {
            bl = (Boolean)this.threadReturnObject;
        }
        return bl;
    }

    public boolean processReadPreviewInfo() {
        String string = "processReadPreviewInfo";
        SQLMethod sQLMethod = new SQLMethod(1, string, 5);
        boolean bl = false;
        LogSystem.beginLogSection("Reading Document Preview");
        LogSystem.log(1, ":-docInd:" + this.docInd);
        LogSystem.log(1, ":-existingDocInd:" + this.existingDocInd);
        LogSystem.log(1, ":-requestFlag:" + this.isDocRequest());
        LogSystem.log(1, ":-templateFlag:" + this.isTemplate());
        DocRec.getWindow().setStatus(240);
        try {
            long l = 0L;
            CallableStatement callableStatement = sQLMethod.createStoredProc("QUEST.DocReader", 7);
            callableStatement.registerOutParameter(1, 4);
            callableStatement.registerOutParameter(2, 4);
            callableStatement.registerOutParameter(3, 4);
            callableStatement.registerOutParameter(4, 4);
            callableStatement.registerOutParameter(5, -4);
            callableStatement.registerOutParameter(6, 4);
            callableStatement.registerOutParameter(7, -1);
            callableStatement.setInt(1, this.docInd);
            callableStatement.setInt(2, this.existingDocInd);
            callableStatement.setInt(3, this.isDocRequest() ? 1 : 0);
            callableStatement.setInt(4, 1);
            l = System.currentTimeMillis();
            callableStatement.execute();
            if (callableStatement.getString(7) != null) {
                LogSystem.log(1, "readPreviewInfo got back:\n" + callableStatement.getString(7));
            } else {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(callableStatement.getBytes(5));
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                DocReaderBuffer docReaderBuffer = (DocReaderBuffer)objectInputStream.readObject();
                this.setData(docReaderBuffer);
                this.previewInfoRead = bl = this.readDocGraphics();
            }
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception);
        }
        sQLMethod.close();
        DocRec.getWindow().setStatus(null);
        LogSystem.endLogSection();
        System.gc();
        return bl;
    }

    public boolean obtainDocType() {
        boolean bl = false;
        TypeDocRec typeDocRec = new SelectDocTypeDlg(DocRec.getWindow()).getTypeDocRec();
        if (typeDocRec != null) {
            this.docTypeRec = typeDocRec;
            bl = true;
        }
        return bl;
    }

    public void setFieldData(int n, Object object) {
        DocPropertyRec docPropertyRec = null;
        switch (n) {
            case 71: {
                this.notesId = ((String)object).trim();
                System.out.println("Force Filename to :" + this.notesId);
                break;
            }
            case 68: {
                if (object == null || !(object instanceof String)) break;
                this.queryText = ((String)object).toUpperCase();
                break;
            }
            case 67: {
                if (object == null || !(object instanceof String)) break;
                this.commentHistory = (String)object;
                break;
            }
            case 66: {
                if (!(object instanceof TypeAuthRec)) break;
                this.authRec = (TypeAuthRec)object;
                break;
            }
            case 55: {
                if (object != null) {
                    if (!(object instanceof String)) break;
                    if (!this.checkForDupFilename((String)object)) {
                        String string = ((String)object).trim();
                        if (string.indexOf(" ") >= 0) {
                            GUISystem.printBox(6, 879);
                            break;
                        }
                        if (string.length() <= 2) break;
                        this.notesId = ((String)object).trim();
                        break;
                    }
                    GUISystem.printBox(7, 973);
                    break;
                }
                this.notesId = null;
                break;
            }
            case 49: {
                if (object == null || !(object instanceof String)) break;
                this.notesId = ((String)object).trim();
                break;
            }
            case 56: {
                this.startDate = (String)object;
                break;
            }
            case 2: {
                this.title = (String)object;
                this.titleArray = null;
                break;
            }
            case 61: {
                if (!(object instanceof String)) break;
                this.stopDate = (String)object;
                if (this.stopDate == null || this.stopDate.length() >= 5) break;
                this.stopDate = null;
                break;
            }
            case 3: {
                UserRec userRec = UserSystem.getUserRecFromUserId((String)object);
                this.requestor = (String)object;
                if (userRec != null) {
                    this.prettyRequestor = userRec.getName();
                    break;
                }
                this.prettyRequestor = (String)object;
                break;
            }
            case 52: {
                this.workReqRec = (TypeWorkRec)object;
                break;
            }
            case 16: {
                this.docTypeRec = (TypeDocRec)object;
                break;
            }
            case 17: {
                this.docCatVec = (Vector)object;
                break;
            }
            case 15: {
                this.docClassRec = (TypeDocClassRec)object;
                break;
            }
            case 22: 
            case 23: {
                this.prodDocRec = (ProdDocRec)object;
                this.setOwnerFromBrand();
                break;
            }
            case 24: {
                this.localeRec = (LocaleRec)object;
                break;
            }
            case 25: {
                if (object instanceof DocStatusRec) {
                    this.addStatus((DocStatusRec)object);
                    break;
                }
                if (!(object instanceof StatusRec)) break;
                this.addStatus(new DocStatusRec(((StatusRec)object).getId(), ((StatusRec)object).getDate()));
                break;
            }
            case 26: {
                docPropertyRec = new DocPropertyRec((String)object, 2);
                this.setProperty(docPropertyRec);
                break;
            }
            case 27: {
                if (!(object instanceof String)) break;
                this.url = (String)object;
                break;
            }
            case 30: {
                this.publicationRec = (TypePubRec)object;
                break;
            }
            case 13: 
            case 57: {
                this.publishingTagsRec = (PublishingTagsRec)object;
                break;
            }
            case 31: {
                this.metricRec = (TypeMetricRec)object;
                break;
            }
            case 28: {
                if (object instanceof String) {
                    String string = (String)object;
                    docPropertyRec = new DocPropertyRec(string, 3);
                } else if (object instanceof DocPropertyRec) {
                    docPropertyRec = (DocPropertyRec)object;
                }
                if (docPropertyRec == null) break;
                this.setProperty(docPropertyRec);
                break;
            }
            case 32: {
                this.comment = (String)object;
                break;
            }
            case 33: {
                docPropertyRec = new DocPropertyRec((String)object, 8);
                this.setProperty(docPropertyRec);
                break;
            }
            case 34: {
                this.partNumber = (String)object;
                break;
            }
            case 41: {
                this.mediaVec = (Vector)object;
                if (!this.initialRead || this.mediaVec == null) break;
                int n2 = 0;
                int n3 = this.mediaVec.size();
                this.origMediaVec = new Vector(n3);
                while (n2 < n3) {
                    this.origMediaVec.addElement(((DocFileRec)this.mediaVec.elementAt(n2)).clone());
                    ++n2;
                }
                break;
            }
            case 14: {
                this.body = (String)object;
                break;
            }
            case 29: {
                this.addInfo = (String)object;
                break;
            }
            case 6: {
                UserRec userRec = UserSystem.getUserRecFromUserId((String)object);
                this.owner = (String)object;
                if (userRec != null) {
                    this.prettyOwner = userRec.getName();
                    break;
                }
                this.prettyOwner = (String)object;
                break;
            }
            case 54: {
                this.changedTime = (String)object;
                this.prettyChangedTime = DateSystem.prettyDateFromStamp(this.changedTime);
                break;
            }
            case 44: {
                this.docLinksVec = (Vector)object;
                break;
            }
            case 7: {
                this.source = (String)object;
                break;
            }
            case 53: {
                UserRec userRec = UserSystem.getUserRecFromUserId((String)object);
                this.dbUser = (String)object;
                if (userRec != null) {
                    this.prettydbUser = userRec.getName();
                    break;
                }
                this.prettydbUser = (String)object;
                break;
            }
            case 58: {
                this.refDocLinksVec = (Vector)object;
                break;
            }
            case 5: {
                if (this.publishingTagsRec == null) {
                    this.publishingTagsRec = new PublishingTagsRec();
                }
                this.publishingTagsRec.eMailableDate = (String)object;
                break;
            }
            default: {
                throw new IllegalArgumentException("Something tried to set a field in the DocRec that wasn't caught. The field id is:" + n + ", and the data is:" + object);
            }
        }
        this.lastFieldChange = n;
        if (this.fieldListenerVec != null) {
            new Thread((Runnable)this, THREAD_FIRECHANGE).start();
        }
    }

    public Object getFieldData(int n) {
        Object object = null;
        Object var3_3 = null;
        switch (n) {
            case 68: {
                object = this.queryText;
                break;
            }
            case 69: {
                object = new String(this.originalComment);
                break;
            }
            case 67: {
                object = this.commentHistory;
                break;
            }
            case 70: {
                if (this.titleArray == null) {
                    this.refreshTitleArray();
                }
                object = this.titleArray;
                break;
            }
            case 63: {
                if (this.docClassRec == null) break;
                if (this.docClassRec.ind == 1) {
                    object = ImageSystem.getImage((Object)DocRec.getWindow(), 102);
                    break;
                }
                if (this.docClassRec.ind == 2) {
                    object = ImageSystem.getImage((Object)DocRec.getWindow(), 103);
                    break;
                }
                if (this.docClassRec.ind != 3) break;
                object = ImageSystem.getImage((Object)DocRec.getWindow(), 104);
                break;
            }
            case 5: {
                if (this.publishingTagsRec == null) break;
                object = this.publishingTagsRec.eMailableDate;
                break;
            }
            case 61: {
                object = this.stopDate;
                break;
            }
            case 7: {
                object = this.source;
                break;
            }
            case 2: {
                object = this.title;
                break;
            }
            case 16: {
                object = this.docTypeRec;
                break;
            }
            case 17: {
                object = this.docCatVec;
                break;
            }
            case 15: {
                object = this.docClassRec;
                break;
            }
            case 22: {
                object = this.prodDocRec;
                break;
            }
            case 23: {
                object = this.prodDocRec;
                break;
            }
            case 24: {
                object = this.localeRec;
                break;
            }
            case 25: {
                object = this.getCurrentDocStatusRec();
                break;
            }
            case 12: {
                if (this.publishingTagsRec == null) break;
                object = this.publishingTagsRec.eMailComments;
                break;
            }
            case 26: {
                object = this.getProperty(2);
                break;
            }
            case 27: {
                object = this.url;
                break;
            }
            case 30: {
                object = this.publicationRec;
                break;
            }
            case 13: 
            case 57: {
                object = this.publishingTagsRec;
                break;
            }
            case 31: {
                object = this.metricRec;
                break;
            }
            case 28: {
                object = this.getProperty(3);
                break;
            }
            case 32: {
                object = this.comment;
                break;
            }
            case 33: {
                object = this.getProperty(8);
                break;
            }
            case 34: {
                object = this.partNumber;
                break;
            }
            case 41: {
                object = this.mediaVec;
                break;
            }
            case 14: {
                object = this.body;
                break;
            }
            case 29: {
                object = this.addInfo;
                break;
            }
            case 6: {
                object = this.owner;
                break;
            }
            case 52: {
                object = this.workReqRec;
                break;
            }
            case 54: {
                object = this.changedTime;
                break;
            }
            case 44: {
                object = this.docLinksVec;
                break;
            }
            case 55: {
                object = this.notesId;
                break;
            }
            case 53: {
                object = this.dbUser;
                break;
            }
            case 62: {
                object = this.prettydbUser;
                break;
            }
            case 64: {
                object = this.prettyChangedTime;
                break;
            }
            case 58: {
                object = this.refDocLinksVec;
                break;
            }
            case 3: {
                object = this.requestor;
                break;
            }
            case 59: {
                object = this.prettyRequestor;
                break;
            }
            case 60: {
                object = this.prettyOwner;
                break;
            }
            case 56: {
                object = this.startDate;
                break;
            }
            case 50: {
                object = this.graphicVec;
                break;
            }
            case 65: {
                object = new Integer(this.getDatabaseDocInd()).toString();
                break;
            }
            case 49: {
                object = this.notesId;
                break;
            }
            default: {
                GUISystem.printBox("Programmer Error", "Something tried to get a field in the DocRec that wasn't caught. The field id is:" + n);
                break;
            }
        }
        return object;
    }

    public void copyFieldData(int n, DocRec docRec) {
        this.setFieldData(n, docRec.getFieldData(n));
    }

    public void cleanDBChars(SQLMethod sQLMethod) {
        sQLMethod.cleanDBString(this.requestor);
        sQLMethod.cleanDBString(this.title);
        sQLMethod.cleanDBString(this.owner);
        sQLMethod.cleanDBString(this.source);
        sQLMethod.cleanDBString(this.comment);
        sQLMethod.cleanDBString(this.partNumber);
        sQLMethod.cleanDBString(this.notesId);
        sQLMethod.cleanDBString(this.dbUser);
        sQLMethod.cleanDBString(this.changedTime);
        sQLMethod.cleanDBString(this.startDate);
        sQLMethod.cleanDBString(this.stopDate);
        sQLMethod.cleanDBString(this.returnEMail);
        sQLMethod.cleanDBString(this.addInfo);
    }

    public int getEditType() {
        return this.editType;
    }

    public String getPrettyChangedTime() {
        return this.prettyChangedTime;
    }

    public int getDocInd() {
        if (this.isDocRequest()) {
            return this.docInd;
        }
        return 0;
    }

    public void setExistingDocInd(int n) {
        this.existingDocInd = n;
    }

    public int getExistingDocInd() {
        return this.existingDocInd;
    }

    public void setData(boolean bl, ResultSet resultSet) throws SQLException {
        this.request = bl;
        this.docInd = resultSet.getInt(1);
        this.existingDocInd = resultSet.getInt(2);
        this.setFieldData(2, resultSet.getString(3).trim());
        this.setFieldData(6, resultSet.getString(4).trim());
        this.setFieldData(15, new TypeDocClassRec(resultSet.getInt(5), ""));
        this.setFieldData(54, resultSet.getString(9).trim());
        this.notesId = resultSet.getString(6);
        if (this.notesId != null) {
            this.notesId = this.notesId.trim();
        }
        if (this.isDocRequest()) {
            this.setFieldData(52, new TypeWorkRec(resultSet.getInt(7), ""));
        } else if (!this.isTemplate() && this.isDocRequest()) {
            this.existingDocInd = this.docInd;
            this.docInd = 0;
        } else {
            this.existingDocInd = this.docInd;
        }
    }

    public void setRecycleInfo(SQLParse sQLParse) {
        this.docInd = sQLParse.readInt(0);
        this.setFieldData(2, sQLParse.readString(1));
        this.setFieldData(53, sQLParse.readString(3));
        this.setFieldData(54, sQLParse.readString(4));
        this.setRecycled(true);
        this.request = true;
    }

    public void setData(NotificationRec notificationRec) {
        this.docInd = notificationRec.docInd;
        this.existingDocInd = notificationRec.existingDocInd;
        this.request = true;
    }

    public void initFields() {
        this.docClassRec = (TypeDocClassRec)TypeList.getInstance().objectFromInd(1, 5);
        this.publishingTagsRec = new PublishingTagsRec();
        this.metricRec = (TypeMetricRec)TypeList.getInstance().objectFromInd(4, 11);
        if (this.existingDocInd == 0) {
            this.setFieldData(7, UserSystem.getUserName());
        }
        this.setFieldData(53, UserSystem.getUserId());
        this.setFieldData(3, UserSystem.getUserId());
        this.setFieldData(6, "");
        this.setFieldData(54, DateSystem.getDate(1));
        this.setFieldData(2, Str.getStr(198) + " - " + UserSystem.getUserId());
        this.authRec = (TypeAuthRec)TypeList.getInstance().objectFromInd(0, 1);
        this.statusRec = new DocStatusRec(10, DateSystem.getDate(2));
    }

    private boolean saveToRecycle() {
        SQLMethod sQLMethod = new SQLMethod(1, "saveToRecycled", 5);
        String string = "UPDATE QUEST.DOCUMENTS SET DBUSER      = '" + UserSystem.getUserId() + "', " + "                           CHANGEDTIME = CURRENT TIMESTAMP, " + "                           RECYCLED    = 'Y' WHERE DOCIND = ";
        boolean bl = false;
        this.checkDeleteNotify();
        if (sQLMethod != null && this.isDocRequest() && this.docInd > 0) {
            try {
                Statement statement = sQLMethod.createStatement();
                if (statement != null) {
                    statement.executeUpdate(string + this.docInd);
                }
                bl = true;
            }
            catch (SQLException sQLException) {
                sQLMethod.rollBack();
                LogSystem.log(1, sQLException);
            }
        }
        sQLMethod.close();
        return bl;
    }

    private void checkDeleteNotify() {
        boolean bl;
        int n = this.getNotifyInd();
        if (n != 0 && (bl = GUISystem.printBox(8, 1325))) {
            SQLMethod sQLMethod = new SQLMethod(1, "deleteNotify", 5);
            try {
                Statement statement = sQLMethod.createStatement();
                if (statement != null) {
                    statement.executeQuery("DELETE FROM QUEST.NOTIFICATION " + "WHERE DOCIND = " + this.docInd + " AND " + "      DBUSER = '" + UserSystem.getUserId() + "'");
                }
            }
            catch (Exception exception) {
                sQLMethod.rollBack();
                LogSystem.log(1, exception, false);
            }
            sQLMethod.close();
        }
    }

    public boolean saveFieldDataToDatabase(int n, Object object) {
        Object object2 = this.getFieldData(n);
        Object var4_4 = null;
        boolean bl = false;
        SQLStatement sQLStatement = new SQLStatement();
        String string = "saveFieldToDatabase ( " + n + ", " + object + " ) ";
        boolean bl2 = false;
        SQLMethod sQLMethod = new SQLMethod(1, string, 5);
        this.setFieldData(n, object);
        switch (n) {
            case 2: {
                sQLStatement.setTableName("QUEST.DOCUMENTS");
                sQLStatement.setColumnNames(1);
                sQLStatement.setColumnData(0, "TITLE", this.title);
                bl = true;
                break;
            }
        }
        try {
            if (sQLMethod != null) {
                Statement statement = sQLMethod.createStatement();
                sQLStatement.setWhereColumnNames(1);
                sQLStatement.setWhereColumnName(0, "DOCIND", "=");
                sQLStatement.setWhereData(0, this.getDatabaseDocInd());
                sQLStatement.setType(2);
                statement.executeUpdate(sQLStatement.toString());
                bl2 = true;
            }
        }
        catch (SQLException sQLException) {
            sQLMethod.rollBack();
            LogSystem.log(1, sQLException);
            this.setFieldData(n, object2);
        }
        sQLMethod.close();
        return bl2;
    }

    public String getFieldPreview(int n) {
        String string = "";
        try {
            switch (n) {
                case 1002: {
                    string = "<font face=\"Times New Roman,Times\" color=\"#003399\" size=6>FIELD_TITLE</font>";
                    string = Text.replaceInStr(string, "FIELD_TITLE", this.title);
                    break;
                }
                case 1001: {
                    string = "<p><b><font face=\"Arial,Helvetica\" size=2 color=\"#003399\">STR_DATABASEINFO</font></b><font face=\"Arial,Helvetica\" size=2 color=\"black\"><table BORDER=0 CELLSPACING=0 CELLPADDING=0 COLS=2 WIDTH=\"100%\"><tr><td ><font face=\"Helvetica, Arial\" size=2>STR_DATABASEDOCIND</font></td><td ><font face=\"Helvetica, Arial\" size=2>FIELD_DATABASEDOCIND</font></td></tr><tr><td ><font face=\"Helvetica, Arial\" size=2>STR_LOTUSNOTESID</font></td><td ><font face=\"Helvetica, Arial\" size=2>FIELD_FILENAME</font></td></tr><tr><td ><font face=\"Helvetica, Arial\" size=2>STR_DBUSER</font></td><td ><font face=\"Helvetica, Arial\" size=2>FIELD_DBUSER</font></td></tr><tr><td ><font face=\"Helvetica, Arial\" size=2>STR_CHANGEDTIME</font></td><td ><font face=\"Helvetica, Arial\" size=2>FIELD_CHANGEDTIME</font></td></tr></table></font>";
                    string = Text.replaceInStr(string, "STR_DATABASEINFO", Str.getStr(263));
                    string = Text.replaceInStr(string, "STR_DATABASEDOCIND", Str.getStr(264));
                    string = Text.replaceInStr(string, "STR_LOTUSNOTESID", Str.getStr(265));
                    string = Text.replaceInStr(string, "STR_DBUSER", Str.getStr(266));
                    string = Text.replaceInStr(string, "STR_CHANGEDTIME", Str.getStr(267));
                    string = Text.replaceInStr(string, "FIELD_DATABASEDOCIND", this.getPreviewStr(this.getDatabaseDocInd()));
                    string = Text.replaceInStr(string, "FIELD_FILENAME", this.getPreviewStr(this.notesId));
                    string = Text.replaceInStr(string, "FIELD_DBUSER", this.getPreviewStr(this.prettydbUser));
                    string = Text.replaceInStr(string, "FIELD_CHANGEDTIME", this.getPreviewStr(this.prettyChangedTime));
                    break;
                }
                case 1004: {
                    if (this.publishingTagsRec == null) {
                        this.publishingTagsRec = new PublishingTagsRec();
                    }
                    string = "<p><b><font size=2 face=\"Arial,Helvetica\"><font color=\"#003399\">STR_CLASS</font></font></b><br><font face=\"Arial,Helvetica\" size=2 color=\"black\">FIELD_DOCCLASS<br><br></font><p><b><font size=2 face=\"Arial,Helvetica\"><font color=\"#003399\">STR_PUBLISHINGTAGS</font></font></b><table BORDER=0 CELLSPACING=0 CELLPADDING=0 WIDTH=\"100%\" BGCOLOR=\"#FFFFFF\" ><tr><td VALIGN=\"TOP\"  WIDTH=\"26%\" ><font face=\"Helvetica, Arial\" size=2>STR_WEBABLE</font></td><td VALIGN=\"TOP\"  WIDTH=\"22%\" ><font face=\"Helvetica, Arial\" size=2>P1</font></td><td VALIGN=\"TOP\"  WIDTH=\"30%\" ><font face=\"Helvetica, Arial\" size=2>STR_HOTFLASH</font></td><td VALIGN=\"TOP\"  WIDTH=\"22%\" ><font face=\"Helvetica, Arial\" size=2>P5</font></td></tr><tr><td VALIGN=\"TOP\"  WIDTH=\"26%\" ><font face=\"Helvetica, Arial\" size=2>STR_WEBONLY</font></td><td VALIGN=\"TOP\"  WIDTH=\"22%\" ><font face=\"Helvetica, Arial\" size=2>P2</font></td><td VALIGN=\"TOP\"  WIDTH=\"30%\" ><font face=\"Helvetica, Arial\" size=2>STR_FLASHDATE</font></td><td VALIGN=\"TOP\"  WIDTH=\"22%\" ><font face=\"Helvetica, Arial\" size=2>P6</font></td></tr><tr><td VALIGN=\"TOP\"  WIDTH=\"26%\" ><font face=\"Helvetica, Arial\" size=2>STR_FAXABLE</font></td><td VALIGN=\"TOP\"  WIDTH=\"22%\" ><font face=\"Helvetica, Arial\" size=2>P3</font></td><td VALIGN=\"TOP\"  WIDTH=\"30%\" ><font face=\"Helvetica, Arial\" size=2>STR_EMAILABLE</font></td><td VALIGN=\"TOP\"  WIDTH=\"22%\" ><font face=\"Helvetica, Arial\" size=2>P7</font></td></tr><tr><td VALIGN=\"TOP\"  WIDTH=\"26%\" ><font face=\"Helvetica, Arial\" size=2>STR_KB</font></td><td VALIGN=\"TOP\"  WIDTH=\"22%\" ><font face=\"Helvetica, Arial\" size=2>P4</font></td><td VALIGN=\"TOP\"  WIDTH=\"30%\" ><font face=\"Helvetica, Arial\" size=2>STR_EMAILDATE</font></td><td VALIGN=\"TOP\"  WIDTH=\"22%\" ><font face=\"Helvetica, Arial\" size=2>P8</font></td></tr><tr><td VALIGN=\"TOP\"  WIDTH=\"26%\" ><font face=\"Helvetica, Arial\" size=2>STR_FAQ</font></td><td VALIGN=\"TOP\"  WIDTH=\"22%\" ><font face=\"Helvetica, Arial\" size=2>P10</font></td><td VALIGN=\"TOP\"  WIDTH=\"30%\" ><font face=\"Helvetica, Arial\" size=2>STR_MONTHS</font></td><td VALIGN=\"TOP\"  WIDTH=\"22%\" ><font face=\"Helvetica, Arial\" size=2>P9</font></td></tr></table>";
                    string = Text.replaceInStr(string, "STR_PUBLISHINGTAGS", Str.getStr(268));
                    string = Text.replaceInStr(string, "STR_CLASS", Str.getStr(269));
                    string = Text.replaceInStr(string, "STR_WEBABLE", Str.getStr(270));
                    string = Text.replaceInStr(string, "STR_WEBONLY", Str.getStr(271));
                    string = Text.replaceInStr(string, "STR_FAXABLE", Str.getStr(272));
                    string = Text.replaceInStr(string, "STR_KB", Str.getStr(273));
                    string = Text.replaceInStr(string, "STR_FAQ", Str.getStr(274));
                    string = Text.replaceInStr(string, "STR_HOTFLASH", Str.getStr(275));
                    string = Text.replaceInStr(string, "STR_FLASHDATE", Str.getStr(276));
                    string = Text.replaceInStr(string, "STR_EMAILABLE", Str.getStr(277));
                    string = Text.replaceInStr(string, "STR_EMAILDATE", Str.getStr(280));
                    string = Text.replaceInStr(string, "STR_MONTHS", Str.getStr(278));
                    string = Text.replaceInStr(string, "P1", this.getPreviewStr(this.publishingTagsRec.webable));
                    string = Text.replaceInStr(string, "P2", this.getPreviewStr(this.publishingTagsRec.webOnly));
                    string = Text.replaceInStr(string, "P3", this.getPreviewStr(this.publishingTagsRec.faxable));
                    string = Text.replaceInStr(string, "P4", this.getPreviewStr(this.publishingTagsRec.knowledgeBase));
                    string = Text.replaceInStr(string, "P5", this.getPreviewStr(this.publishingTagsRec.hotFlash));
                    string = Text.replaceInStr(string, "P6", this.getPreviewStr(this.publishingTagsRec.flashDate));
                    string = Text.replaceInStr(string, "P7", this.getPreviewStr(this.publishingTagsRec.eMailable));
                    string = Text.replaceInStr(string, "P8", this.getPreviewStr(this.publishingTagsRec.eMailableDate));
                    string = Text.replaceInStr(string, "P9", this.getPreviewStr(this.publishingTagsRec.monthsToReview));
                    string = Text.replaceInStr(string, "P10", this.getPreviewStr(this.publishingTagsRec.faq));
                    if (this.getFieldData(15) != null) {
                        string = Text.replaceInStr(string, "FIELD_DOCCLASS", this.getFieldData(15).toString());
                        break;
                    }
                    string = Text.replaceInStr(string, "FIELD_DOCCLASS", "");
                    break;
                }
                case 1003: {
                    string = "<p><b><font size=2 face=\"Arial,Helvetica\"><font color=\"#003399\">STR_GENERALINFO</font></font></b><br><table BORDER=0 CELLSPACING=0 CELLPADDING=0 WIDTH=\"700\" BGCOLOR=\"#FFFFFF\" ><tr><td VALIGN=\"TOP\"  WIDTH=\"26%\" BGCOLOR=\"#FFFFFF\"><font face=\"Helvetica, Arial\" size=2>STR_DOCTYPE</font></td><td VALIGN=\"TOP\"  WIDTH=\"22%\" BGCOLOR=\"#FFFFFF\"><font face=\"Helvetica, Arial\" size=2><font color=\"#0000AA\">G1</font></font></td><td VALIGN=\"TOP\"  WIDTH=\"30%\" BGCOLOR=\"#FFFFFF\"><font face=\"Helvetica, Arial\" size=2></font>&nbsp;</td><td VALIGN=\"TOP\"  WIDTH=\"22%\" BGCOLOR=\"#FFFFFF\"><font face=\"Helvetica, Arial\" size=2><font color=\"#0000AA\"></font></font></td></tr><tr BGCOLOR=\"#FFFFFF\"><font face=\"Helvetica, Arial\" size=2><td VALIGN=\"TOP\"  WIDTH=\"26%\" BGCOLOR=\"#FFFFFF\"><font face=\"Helvetica, Arial\" size=2>STR_SOURCE</font></td><td VALIGN=\"TOP\"  WIDTH=\"22%\" BGCOLOR=\"#FFFFFF\"><font face=\"Helvetica, Arial\" size=2><font color=\"#0000AA\">G2</font></font></td><td VALIGN=\"TOP\"  WIDTH=\"30%\" BGCOLOR=\"#FFFFFF\"><font face=\"Helvetica, Arial\" size=2>&nbsp;</font></td><td VALIGN=\"TOP\"  WIDTH=\"22%\" BGCOLOR=\"#FFFFFF\"><font face=\"Helvetica, Arial\" size=2><font color=\"#0000AA\"></font></font></td></tr><tr><td VALIGN=\"TOP\"  WIDTH=\"26%\" BGCOLOR=\"#FFFFFF\"><font face=\"Helvetica, Arial\" size=2>STR_METRIC</font></td><td VALIGN=\"TOP\"  WIDTH=\"22%\" BGCOLOR=\"#FFFFFF\"><font face=\"Helvetica, Arial\" size=2><font color=\"#0000AA\">G3</font></font></td><td VALIGN=\"TOP\"  WIDTH=\"30%\" BGCOLOR=\"#FFFFFF\"><font face=\"Helvetica, Arial\" size=2>&nbsp;</font></td><td VALIGN=\"TOP\"  WIDTH=\"22%\" BGCOLOR=\"#FFFFFF\"><font face=\"Helvetica, Arial\" size=2><font color=\"#0000AA\"></font></font></td></tr><tr><td VALIGN=\"TOP\"  WIDTH=\"26%\" BGCOLOR=\"#FFFFFF\"><font face=\"Helvetica, Arial\" size=2>STR_REQUESTOR</font></td><td VALIGN=\"TOP\"  WIDTH=\"22%\" BGCOLOR=\"#FFFFFF\"><font face=\"Helvetica, Arial\" size=2><font color=\"#0000AA\">G4</font></font></td><td VALIGN=\"TOP\"  WIDTH=\"30%\" BGCOLOR=\"#FFFFFF\"><font face=\"Helvetica, Arial\" size=2>&nbsp;</font></td><td VALIGN=\"TOP\"  WIDTH=\"22%\" BGCOLOR=\"#FFFFFF\"><font face=\"Helvetica, Arial\" size=2><font color=\"#0000AA\"></font></font></td></tr><tr><td VALIGN=\"TOP\"  WIDTH=\"26%\" BGCOLOR=\"#FFFFFF\"><font face=\"Helvetica, Arial\" size=2>STR_OWNER</font></td><td VALIGN=\"TOP\"  WIDTH=\"22%\" BGCOLOR=\"#FFFFFF\"><font face=\"Helvetica, Arial\" size=2><font color=\"#0000AA\">G5</font></font></td><td VALIGN=\"TOP\"  WIDTH=\"30%\" BGCOLOR=\"#FFFFFF\"><font face=\"Helvetica, Arial\" size=2>&nbsp;</font></td><td VALIGN=\"TOP\"  WIDTH=\"22%\" BGCOLOR=\"#FFFFFF\"><font face=\"Helvetica, Arial\" size=2><font color=\"#0000AA\"></font></font></td></tr><tr><td VALIGN=\"TOP\"  WIDTH=\"26%\" BGCOLOR=\"#FFFFFF\"><font face=\"Helvetica, Arial\" size=2>STR_STARTDATE</font></td><td VALIGN=\"TOP\"  WIDTH=\"22%\" BGCOLOR=\"#FFFFFF\"><font face=\"Helvetica, Arial\" size=2><font color=\"#0000AA\">FIELD_STARTDATE</font></font></td><td VALIGN=\"TOP\"  WIDTH=\"30%\" BGCOLOR=\"#FFFFFF\"><font face=\"Helvetica, Arial\" size=2>&nbsp;</font></td><td VALIGN=\"TOP\"  WIDTH=\"22%\" BGCOLOR=\"#FFFFFF\"><font face=\"Helvetica, Arial\" size=2><font color=\"#0000AA\"></font></font></td></tr><tr><td VALIGN=\"TOP\"  WIDTH=\"26%\" BGCOLOR=\"#FFFFFF\"><font face=\"Helvetica, Arial\" size=2>&nbsp;</font></td><td VALIGN=\"TOP\"  WIDTH=\"22%\" BGCOLOR=\"#FFFFFF\"><font face=\"Helvetica, Arial\" size=2><font color=\"#0000AA\"></font></font></td><td VALIGN=\"TOP\"  WIDTH=\"30%\" BGCOLOR=\"#FFFFFF\"><font face=\"Helvetica, Arial\" size=2>&nbsp;</font></td><td VALIGN=\"TOP\"  WIDTH=\"22%\" BGCOLOR=\"#FFFFFF\"><font face=\"Helvetica, Arial\" size=2><font color=\"#0000AA\"></font></font></td></tr></table>";
                    string = Text.replaceInStr(string, "STR_GENERALINFO", Str.getStr(279));
                    string = Text.replaceInStr(string, "STR_DOCTYPE", Str.getStr(282));
                    string = Text.replaceInStr(string, "STR_SOURCE", Str.getStr(283));
                    string = Text.replaceInStr(string, "STR_METRIC", Str.getStr(284));
                    string = Text.replaceInStr(string, "STR_REQUESTOR", Str.getStr(285));
                    string = Text.replaceInStr(string, "STR_OWNER", Str.getStr(304));
                    try {
                        string = Text.replaceInStr(string, "G1", this.getPreviewStr(this.docTypeRec.toString()));
                        string = Text.replaceInStr(string, "G2", this.getPreviewStr(this.source));
                        string = Text.replaceInStr(string, "G3", this.getPreviewStr(this.metricRec.toString()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    string = Text.replaceInStr(string, "G4", this.getPreviewStr(this.prettyRequestor));
                    string = Text.replaceInStr(string, "G5", this.getPreviewStr(this.prettyOwner));
                    string = Text.replaceInStr(string, "STR_STARTDATE", Str.getStr(287));
                    string = Text.replaceInStr(string, "FIELD_STARTDATE", this.getPreviewStr(this.startDate));
                    break;
                }
                case 1005: {
                    String string2 = Str.getStr(198);
                    string = "<table BORDER=0 CELLSPACING=4 CELLPADDING=4 WIDTH=\"100%\" BGCOLOR=\"#FFFFFF\" ><tr><td VALIGN=\"TOP\"  BGCOLOR=\"#FFFFFF\"><b><font color=\"#FFFFFF\">STR_CATEGORY</font></b><table BORDER=0 CELLSPACING=0 CELLPADDING=0 WIDTH=\"100%\" BGCOLOR=\"#FFFFFF\" ><tr><td VALIGN=\"TOP\"  WIDTH=\"100%\" BGCOLOR=\"#FFFFFF\"><font face=\"Helvetica, Arial\" size=2><font color=\"#0000AA\">FIELD_CATEGORY</font></font></td></tr></table></font></td></tr></table>";
                    string2 = this.getAllCategories();
                    string = Text.replaceInStr(string, "FIELD_CATEGORY", string2);
                    string = Text.replaceInStr(string, "STR_CATEGORY", Str.getStr(289));
                    break;
                }
                case 1007: {
                    string = "<p><b><font size=2 face=\"Arial,Helvetica\"><font color=\"#003399\">STR_COMMENTS</font></font></b><br><font face=\"Arial,Helvetica\" size=2 color=\"black\">FIELD_COMMENT<br><br></font>";
                    string = Text.replaceInStr(string, "STR_COMMENTS", Str.getStr(290));
                    string = Text.replaceInStr(string, "FIELD_COMMENT", this.getPreviewStr(this.originalComment) + "<br>" + this.getPreviewStr(this.comment));
                    string = Text.replaceInStr(string, "\n", "<br>");
                    break;
                }
                case 1014: {
                    string = "<p><b><font size=2 face=\"Arial,Helvetica\"><font color=\"#003399\">STR_COMMENTS</font></font></b><br><font face=\"Arial,Helvetica\" size=2 color=\"black\">FIELD_COMMENT<br><br></font>";
                    string = Text.replaceInStr(string, "STR_COMMENTS", Str.getStr(303));
                    string = Text.replaceInStr(string, "FIELD_COMMENT", "<PRE>" + this.getPreviewStr(this.commentHistory) + "</PRE>");
                    string = Text.replaceInStr(string, "\n", "<br>");
                    string = Text.replaceInStr(string, ":", "<br>");
                    break;
                }
                case 1008: {
                    string = "<table BORDER=0 CELLSPACING=4 CELLPADDING=4 WIDTH=\"100%\" BGCOLOR=\"#FFFFFF\" ><tr><td VALIGN=\"TOP\"  BGCOLOR=\"#FFFFFF\"><font face=\"Helvetica, Arial\" size=2><b><font color=\"#FFFFFF\">STR_SUMMARY</font></b><table BORDER=0 CELLSPACING=0 CELLPADDING=0 WIDTH=\"100%\" BGCOLOR=\"#FFFFFF\" ><tr><td VALIGN=\"TOP\"  WIDTH=\"100%\" BGCOLOR=\"#FFFFFF\"><font face=\"Helvetica, Arial\" size=2><font color=\"#0000AA\">FIELD_SUMMARY</font></font></td></tr></table></font></td></tr></table>";
                    string = Text.replaceInStr(string, "STR_SUMMARY", Str.getStr(291));
                    string = Text.replaceInStr(string, "FIELD_SUMMARY", this.getPreviewStr(this.publishingTagsRec.eMailComments));
                    string = Text.replaceInStr(string, "\n", "<br>");
                    break;
                }
                case 1011: {
                    if (this.docTypeRec.getInd() == 9) {
                        DocPropertyRec docPropertyRec = null;
                        string = "<table BORDER=0 CELLSPACING=4 CELLPADDING=4 WIDTH=\"100%\" BGCOLOR=\"#FFFFFF\" ><tr><td VALIGN=\"TOP\"  BGCOLOR=\"#FFFFFF\"><b><font color=\"#FFFFFF\"><font face=\"Helvetica, Arial\" size=2>STR_SSDINFO</font></font></b><table BORDER=0 CELLSPACING=0 CELLPADDING=0 WIDTH=\"100%\" BGCOLOR=\"#FFFFFF\" ><tr><td VALIGN=\"TOP\"  WIDTH=\"41%\" BGCOLOR=\"#FFFFFF\"><font face=\"Helvetica, Arial\" size=2>STR_DESCRIPTION</font></td><td VALIGN=\"TOP\"  WIDTH=\"59%\" BGCOLOR=\"#FFFFFF\"><font face=\"Helvetica, Arial\" size=2>FIELD_DESCRIPTION</font></td></tr><tr><td VALIGN=\"TOP\"  WIDTH=\"41%\" BGCOLOR=\"#FFFFFF\"><font face=\"Helvetica, Arial\" size=2>STR_PARTNUMBER</font></td><td VALIGN=\"TOP\"  WIDTH=\"59%\" BGCOLOR=\"#FFFFFF\"><font face=\"Helvetica, Arial\" size=2>FIELD_PARTNUMBER</font></td></tr><tr><td VALIGN=\"TOP\"  WIDTH=\"41%\" BGCOLOR=\"#FFFFFF\"><font face=\"Helvetica, Arial\" size=2>STR_VERSION</font></td><td VALIGN=\"TOP\"  WIDTH=\"59%\" BGCOLOR=\"#FFFFFF\"><font face=\"Helvetica, Arial\" size=2>FIELD_VERSION</font></td></tr><tr><td VALIGN=\"TOP\"  WIDTH=\"41%\" BGCOLOR=\"#FFFFFF\"><font face=\"Helvetica, Arial\" size=2>STR_URL</font></td><td VALIGN=\"TOP\"  WIDTH=\"59%\" BGCOLOR=\"#FFFFFF\"><font face=\"Helvetica, Arial\" size=2>FIELD_URL</font></td></tr></table></font></td></tr></table>";
                        string = Text.replaceInStr(string, "STR_SSDINFO", "<B>" + Str.getStr(292) + "</B>");
                        string = Text.replaceInStr(string, "STR_DESCRIPTION", "<B>" + Str.getStr(100) + "</B>");
                        string = Text.replaceInStr(string, "STR_PARTNUMBER", "<B>" + Str.getStr(293) + "</B>");
                        string = Text.replaceInStr(string, "STR_VERSION", "<B>" + Str.getStr(294) + "</B>");
                        string = Text.replaceInStr(string, "STR_URL", "<B>" + Str.getStr(111) + "</B>");
                        docPropertyRec = this.getProperty(2);
                        string = docPropertyRec != null ? Text.replaceInStr(string, "FIELD_DESCRIPTION", this.getPreviewStr(docPropertyRec.toString()) + " ...") : Text.replaceInStr(string, "FIELD_DESCRIPTION", "-");
                        string = Text.replaceInStr(string, "FIELD_PARTNUMBER", this.getPreviewStr(this.partNumber));
                        docPropertyRec = this.getProperty(8);
                        string = docPropertyRec != null ? Text.replaceInStr(string, "FIELD_VERSION", this.getPreviewStr(this.getPreviewStr(docPropertyRec.toString()))) : Text.replaceInStr(string, "FIELD_VERSION", "-");
                        docPropertyRec = this.getProperty(7);
                        if (docPropertyRec != null) {
                            string = Text.replaceInStr(string, "FIELD_URL", this.getPreviewStr(docPropertyRec.toString()));
                            break;
                        }
                        string = Text.replaceInStr(string, "FIELD_URL", "-");
                    }
                    break;
                }
                case 1012: {
                    int n2;
                    int n3;
                    String string3 = "<ul><li>" + Str.getStr(198) + "</li></ul>";
                    string = "<table BORDER=0 CELLSPACING=4 CELLPADDING=4 WIDTH=\"100%\" BGCOLOR=\"#FFFFFF\" ><tr><td VALIGN=\"TOP\"  BGCOLOR=\"#FFFFFF\"><b><font color=\"#FFFFFF\"><font face=\"Helvetica, Arial\" size=2>STR_DOCLINKS</font></font></b><table BORDER=0 CELLSPACING=0 CELLPADDING=0 WIDTH=\"100%\" BGCOLOR=\"#FFFFFF\" ><tr><td VALIGN=\"TOP\"  WIDTH=\"100%\" BGCOLOR=\"#FFFFFF\"><font face=\"Helvetica, Arial\" size=2><b>STR_THISDOC</b>FIELD_DOCLINKS<br><b>STR_TOTHISDOC</b>FIELD_REFDOCLINKS</font></td></tr></table></font></td></tr></table>";
                    string = Text.replaceInStr(string, "STR_DOCLINKS", Str.getStr(295));
                    string = Text.replaceInStr(string, "STR_THISDOC", Str.getStr(296));
                    string = Text.replaceInStr(string, "STR_TOTHISDOC", Str.getStr(297));
                    if (this.docLinksVec != null && this.docLinksVec.size() > 0) {
                        n3 = 0;
                        n2 = this.docLinksVec.size();
                        string3 = "<ul>";
                        while (n3 < n2) {
                            string3 = string3 + "<li>" + ((DocLinkRec)this.docLinksVec.elementAt((int)n3)).docInd + " - " + ((DocLinkRec)this.docLinksVec.elementAt((int)n3)).title + "</li>";
                            ++n3;
                        }
                        string3 = string3 + "</ul>";
                    }
                    string = Text.replaceInStr(string, "FIELD_DOCLINKS", string3);
                    string3 = "<ul><li>" + Str.getStr(198) + "</li></ul>";
                    if (this.refDocLinksVec != null && this.refDocLinksVec.size() > 0) {
                        n3 = 0;
                        n2 = this.refDocLinksVec.size();
                        string3 = "<ul>";
                        while (n3 < n2) {
                            string3 = string3 + "<li>" + ((DocLinkRec)this.refDocLinksVec.elementAt((int)n3)).docInd + " - " + ((DocLinkRec)this.refDocLinksVec.elementAt((int)n3)).title + "</li>";
                            ++n3;
                        }
                        string3 = string3 + "</ul>";
                    }
                    string = Text.replaceInStr(string, "FIELD_REFDOCLINKS", string3);
                    break;
                }
                case 1006: {
                    String string4 = Str.getStr(198);
                    string = "<p><b><font size=2 face=\"Arial,Helvetica\"><font color=\"#003399\">STR_LOCALE</font></font></b><br><font face=\"Arial,Helvetica\" size=2 color=\"black\">FIELD_LOCATION<br><br></font>";
                    string = Text.replaceInStr(string, "STR_LOCALE", Str.getStr(298));
                    if (this.localeRec != null) {
                        string = Text.replaceInStr(string, "FIELD_LOCATION", this.localeRec.getLocaleList());
                    }
                    break;
                }
                case 1009: {
                    String string5 = this.createProductStr();
                    if (string5 == null || string5.length() < 2) {
                        string5 = Str.getStr(198);
                    }
                    string = "<p><b><font size=2 face=\"Arial,Helvetica\"><font color=\"#003399\">STR_PRODUCTS</font></font></b><br><font face=\"Arial,Helvetica\" size=2 color=\"black\">FIELD_PRODUCTS<br><br></font>";
                    string = Text.replaceInStr(string, "STR_PRODUCTS", Str.getStr(299));
                    string = Text.replaceInStr(string, "FIELD_PRODUCTS", string5);
                    break;
                }
                case 1010: {
                    if (this.docTypeRec.getInd() == 9 || this.docTypeRec.getInd() == 8) {
                        String string6 = "<ul><li>" + Str.getStr(198) + "</li></ul>";
                        String string7 = "<ul><li>" + Str.getStr(198) + "</li></ul>";
                        string = "<table BORDER=0 CELLSPACING=4 CELLPADDING=4 WIDTH=\"100%\" BGCOLOR=\"#FFFFFF\" ><tr><td VALIGN=\"TOP\"  BGCOLOR=\"#FFFFFF\"><b><font color=\"#FFFFFF\"><font face=\"Helvetica, Arial\" size=2>STR_FILEATTACHMENTS</font></b><table BORDER=0 CELLSPACING=0 CELLPADDING=0 WIDTH=\"100%\" BGCOLOR=\"#FFFFFF\" ><tr><td VALIGN=\"TOP\"  WIDTH=\"41%\" BGCOLOR=\"#FFFFFF\"><font face=\"Helvetica, Arial\" size=2><font color=\"#0000AA\">FIELD_FILENAME</font></font></td><td VALIGN=\"TOP\"  WIDTH=\"59%\" BGCOLOR=\"#FFFFFF\"><font face=\"Helvetica, Arial\" size=2><font color=\"#0000AA\">FIELD_FILEDESCRIPT</font></font></td></tr></table></font></td></tr></table>";
                        string = Text.replaceInStr(string, "STR_FILEATTACHMENTS", Str.getStr(300));
                        if (this.mediaVec != null && this.mediaVec.size() > 0) {
                            int n4 = 0;
                            int n5 = this.mediaVec.size();
                            string6 = "<ul>";
                            string7 = "<ul>";
                            while (n4 < n5) {
                                if (((DocFileRec)this.mediaVec.elementAt(n4)).getRecStatus() != 3) {
                                    string6 = string6 + "<li>" + Text.stripPath(((DocFileRec)this.mediaVec.elementAt((int)n4)).sFilename) + "</li>";
                                    string7 = string7 + "<li>" + ((DocFileRec)this.mediaVec.elementAt((int)n4)).descript + "</li>";
                                }
                                ++n4;
                            }
                            string6 = string6 + "</ul>";
                            string7 = string7 + "</ul>";
                        }
                        string = Text.replaceInStr(string, "FIELD_FILENAME", string6);
                        string = Text.replaceInStr(string, "FIELD_FILEDESCRIPT", string7);
                    }
                    break;
                }
                case 1013: {
                    string = "<table BORDER=0 CELLSPACING=4 CELLPADDING=4 WIDTH=\"600\" BGCOLOR=\"#FFFFFF\" ><tr><td VALIGN=\"TOP\"  BGCOLOR=\"#FFFFFF\"><b><font color=\"#000000\"></font></b><table width=584 BGCOLOR=\"#FFFFFF\" border=0><tr><td><font face=\"Times New Roman, Times Roman\" size=\"5\" color=\"#003399\">FIELD_TITLE</font></font></td></tr><tr><td><br><font face=\"Helvetica\", \"Arial\" size=2>FIELD_BODY</font></font></td></tr></table></font></td></tr></table>";
                    string = Text.replaceInStr(string, "FIELD_TITLE", this.getPreviewStr(this.title));
                    if (this.docTypeRec.getInd() == 9) {
                        string = Text.replaceInStr(string, "FIELD_BODY", this.getPreviewStr(this.addInfo));
                        break;
                    }
                    string = Text.replaceInStr(string, "FIELD_BODY", this.getPreviewStr(this.body));
                    break;
                }
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
        }
        return string;
    }

    private String getPreviewStr(boolean bl) {
        if (bl) {
            return Str.getStr(301);
        }
        return Str.getStr(302);
    }

    private String getPreviewStr(String string) {
        if (string == null || string.length() == 0) {
            return "-&nbsp;";
        }
        return string + "&nbsp;";
    }

    private String getPreviewStr(int n) {
        return "" + n;
    }

    public String createProductStr() {
        Vector vector = null;
        int n = 0;
        String string = "";
        if (this.prodDocRec != null && this.prodDocRec.hasFamilies()) {
            vector = this.prodDocRec.getAssociatedFamilies();
            n = 0;
            while (n < vector.size()) {
                string = string + vector.elementAt(n).toString() + ", ";
                ++n;
            }
            if (string.length() > 3) {
                string = string.substring(0, string.length() - 2) + "\n\n";
            }
        }
        if (this.prodDocRec != null && this.prodDocRec.hasMachines()) {
            vector = this.prodDocRec.getAssociatedMachinesAll();
            n = 0;
            while (n < vector.size()) {
                string = string + vector.elementAt(n).toString() + ", ";
                ++n;
            }
            if (string.length() > 3) {
                string = string.substring(0, string.length() - 2) + "\n\n";
            }
        }
        if (this.prodDocRec != null && this.prodDocRec.hasModels()) {
            ProductRec productRec = null;
            vector = this.prodDocRec.getAssociatedModels();
            n = 0;
            while (n < vector.size() && n < 15) {
                productRec = (ProductRec)vector.elementAt(n);
                string = string + productRec.getFieldData(4) + ", ";
                ++n;
            }
            if (string.length() > 3) {
                string = string.substring(0, string.length() - 2);
            }
            if (n == 15) {
                string = string + " etc...";
            }
        }
        if (string.length() < 1) {
            string = Str.getStr(198);
        }
        return string;
    }

    public int getErrorFieldId() {
        this.isPublishable();
        return this.errorFieldId;
    }

    public String getFieldDescription(int n) {
        String string = null;
        int n2 = 0;
        switch (n) {
            case 68: {
                n2 = 1374;
                break;
            }
            case 67: {
                n2 = 303;
                break;
            }
            case 55: {
                n2 = 265;
                break;
            }
            case 6: {
                n2 = 304;
                break;
            }
            case 13: {
                n2 = 268;
                break;
            }
            case 16: {
                n2 = 282;
                break;
            }
            case 32: {
                n2 = 290;
                break;
            }
            case 15: {
                n2 = 281;
                break;
            }
            case 2: {
                n2 = 318;
                break;
            }
            case 17: {
                n2 = 289;
                break;
            }
            case 25: {
                n2 = 319;
                break;
            }
            case 22: {
                n2 = 305;
                break;
            }
            case 23: {
                n2 = 306;
                break;
            }
            case 7: {
                n2 = 283;
                break;
            }
            case 24: {
                n2 = 298;
                break;
            }
            case 12: {
                n2 = 307;
                break;
            }
            case 31: {
                n2 = 284;
                break;
            }
            case 14: 
            case 43: {
                n2 = 308;
                break;
            }
            case 26: {
                n2 = 100;
                break;
            }
            case 27: {
                n2 = 309;
                break;
            }
            case 28: {
                n2 = 310;
                break;
            }
            case 33: {
                n2 = 294;
                break;
            }
            case 34: {
                n2 = 293;
                break;
            }
            case 29: {
                n2 = 311;
                break;
            }
            case 41: {
                n2 = 300;
                break;
            }
            case 30: {
                n2 = 312;
                break;
            }
            case 57: {
                n2 = 320;
                break;
            }
            case 53: {
                n2 = 266;
                break;
            }
            case 54: {
                n2 = 267;
                break;
            }
            case 3: {
                n2 = 285;
                break;
            }
            case 56: {
                n2 = 287;
                break;
            }
            default: {
                string = "Unknown";
                break;
            }
        }
        if (n2 != 0) {
            string = Str.getStr(n2);
        }
        return string;
    }

    public int getIdFromFieldDescription(String string) {
        int n = -1;
        boolean bl = false;
        if (string.equals(Str.getStr(265))) {
            n = 55;
        } else if (string.equals(Str.getStr(1374))) {
            n = 68;
        } else if (string.equals(Str.getStr(304))) {
            n = 6;
        } else if (string.equals(Str.getStr(268))) {
            n = 13;
        } else if (string.equals(Str.getStr(282))) {
            n = 16;
        } else if (string.equals(Str.getStr(290))) {
            n = 32;
        } else if (string.equals(Str.getStr(281))) {
            n = 15;
        } else if (string.equals(Str.getStr(318))) {
            n = 2;
        } else if (string.equals(Str.getStr(289))) {
            n = 17;
        } else if (string.equals(Str.getStr(319))) {
            n = 25;
        } else if (string.equals(Str.getStr(305))) {
            n = 22;
        } else if (string.equals(Str.getStr(306))) {
            n = 23;
        } else if (string.equals(Str.getStr(283))) {
            n = 7;
        } else if (string.equals(Str.getStr(298))) {
            n = 24;
        } else if (string.equals(Str.getStr(307))) {
            n = 12;
        } else if (string.equals(Str.getStr(284))) {
            n = 31;
        } else if (string.equals(Str.getStr(308))) {
            n = 14;
        } else if (string.equals(Str.getStr(100))) {
            n = 26;
        } else if (string.equals(Str.getStr(309))) {
            n = 27;
        } else if (string.equals(Str.getStr(310))) {
            n = 28;
        } else if (string.equals(Str.getStr(294))) {
            n = 33;
        } else if (string.equals(Str.getStr(293))) {
            n = 34;
        } else if (string.equals(Str.getStr(311))) {
            n = 29;
        } else if (string.equals(Str.getStr(300))) {
            n = 41;
        } else if (string.equals(Str.getStr(312))) {
            n = 30;
        } else if (string.equals(Str.getStr(320))) {
            n = 57;
        } else if (string.equals(Str.getStr(266))) {
            n = 53;
        } else if (string.equals(Str.getStr(267))) {
            n = 54;
        } else if (string.equals(Str.getStr(285))) {
            n = 3;
        } else if (string.equals(Str.getStr(287))) {
            n = 56;
        }
        return n;
    }

    public Vector getEditFieldVec() {
        Vector<GlassItem> vector = null;
        if (this.docTypeRec != null) {
            int n = this.docTypeRec.getInd();
            if (n == 4 || n == 3 || n == 2 || n == 10) {
                vector = new Vector(20);
                vector.addElement(new GlassItem(16, true, this.getFieldDescription(16)));
                vector.addElement(new GlassItem(32, true, this.getFieldDescription(32)));
                vector.addElement(new GlassItem(15, true, this.getFieldDescription(15)));
                vector.addElement(new GlassItem(2, true, this.getFieldDescription(2)));
                vector.addElement(new GlassItem(17, true, this.getFieldDescription(17)));
                vector.addElement(new GlassItem(55, true, this.getFieldDescription(55)));
                if (UserSystem.hasAuthority(5)) {
                    vector.addElement(new GlassItem(25, true, this.getFieldDescription(25)));
                }
                vector.addElement(new GlassItem(22, true, this.getFieldDescription(22)));
                vector.addElement(new GlassItem(23, true, this.getFieldDescription(23)));
                vector.addElement(new GlassItem(7, true, Str.getStr(283)));
                vector.addElement(new GlassItem(24, true, this.getFieldDescription(24)));
                vector.addElement(new GlassItem(13, true, this.getFieldDescription(13)));
                vector.addElement(new GlassItem(57, true, this.getFieldDescription(57)));
                if (UserSystem.hasAuthority(5)) {
                    vector.addElement(new GlassItem(31, true, this.getFieldDescription(31)));
                }
                vector.addElement(new GlassItem(14, true, this.getFieldDescription(14)));
                vector.addElement(new GlassItem(68, true, this.getFieldDescription(68)));
            } else if (n == 9) {
                vector = new Vector(20);
                vector.addElement(new GlassItem(16, true, this.getFieldDescription(16)));
                vector.addElement(new GlassItem(32, true, this.getFieldDescription(32)));
                vector.addElement(new GlassItem(15, true, this.getFieldDescription(15)));
                vector.addElement(new GlassItem(2, true, this.getFieldDescription(2)));
                vector.addElement(new GlassItem(17, true, this.getFieldDescription(17)));
                vector.addElement(new GlassItem(55, true, this.getFieldDescription(55)));
                if (UserSystem.hasAuthority(5)) {
                    vector.addElement(new GlassItem(25, true, this.getFieldDescription(25)));
                }
                vector.addElement(new GlassItem(22, true, this.getFieldDescription(22)));
                vector.addElement(new GlassItem(23, true, this.getFieldDescription(23)));
                vector.addElement(new GlassItem(7, true, Str.getStr(283)));
                vector.addElement(new GlassItem(24, true, this.getFieldDescription(24)));
                vector.addElement(new GlassItem(26, true, this.getFieldDescription(26)));
                vector.addElement(new GlassItem(41, true, this.getFieldDescription(41)));
                vector.addElement(new GlassItem(27, true, this.getFieldDescription(27)));
                vector.addElement(new GlassItem(28, true, this.getFieldDescription(28)));
                vector.addElement(new GlassItem(33, true, this.getFieldDescription(33)));
                vector.addElement(new GlassItem(34, true, this.getFieldDescription(34)));
                vector.addElement(new GlassItem(13, true, this.getFieldDescription(13)));
                vector.addElement(new GlassItem(57, true, this.getFieldDescription(57)));
                if (UserSystem.hasAuthority(5)) {
                    vector.addElement(new GlassItem(31, true, this.getFieldDescription(31)));
                }
                vector.addElement(new GlassItem(29, true, this.getFieldDescription(29)));
                vector.addElement(new GlassItem(68, true, this.getFieldDescription(68)));
            } else if (n == 8) {
                vector = new Vector(20);
                vector.addElement(new GlassItem(16, true, this.getFieldDescription(16)));
                vector.addElement(new GlassItem(32, true, this.getFieldDescription(32)));
                vector.addElement(new GlassItem(15, true, this.getFieldDescription(15)));
                vector.addElement(new GlassItem(2, true, this.getFieldDescription(2)));
                vector.addElement(new GlassItem(17, true, this.getFieldDescription(17)));
                vector.addElement(new GlassItem(55, true, this.getFieldDescription(55)));
                if (UserSystem.hasAuthority(5)) {
                    vector.addElement(new GlassItem(25, true, this.getFieldDescription(25)));
                }
                vector.addElement(new GlassItem(22, true, this.getFieldDescription(22)));
                vector.addElement(new GlassItem(23, true, this.getFieldDescription(23)));
                vector.addElement(new GlassItem(7, true, Str.getStr(283)));
                vector.addElement(new GlassItem(24, true, this.getFieldDescription(24)));
                vector.addElement(new GlassItem(26, true, this.getFieldDescription(26)));
                vector.addElement(new GlassItem(41, true, this.getFieldDescription(41)));
                vector.addElement(new GlassItem(27, true, this.getFieldDescription(27)));
                vector.addElement(new GlassItem(30, true, this.getFieldDescription(30)));
                vector.addElement(new GlassItem(13, true, this.getFieldDescription(13)));
                vector.addElement(new GlassItem(57, true, this.getFieldDescription(57)));
                if (UserSystem.hasAuthority(5)) {
                    vector.addElement(new GlassItem(31, true, this.getFieldDescription(31)));
                }
                vector.addElement(new GlassItem(14, true, this.getFieldDescription(29)));
                vector.addElement(new GlassItem(68, true, this.getFieldDescription(68)));
            }
            return vector;
        }
        vector = new Vector<GlassItem>(20);
        vector.addElement(new GlassItem(16, true, this.getFieldDescription(16)));
        vector.addElement(new GlassItem(15, true, this.getFieldDescription(15)));
        vector.addElement(new GlassItem(17, true, this.getFieldDescription(17)));
        vector.addElement(new GlassItem(55, true, this.getFieldDescription(55)));
        vector.addElement(new GlassItem(25, true, this.getFieldDescription(25)));
        vector.addElement(new GlassItem(22, true, this.getFieldDescription(22)));
        vector.addElement(new GlassItem(23, true, this.getFieldDescription(23)));
        vector.addElement(new GlassItem(24, true, this.getFieldDescription(24)));
        vector.addElement(new GlassItem(13, true, this.getFieldDescription(13)));
        vector.addElement(new GlassItem(31, true, this.getFieldDescription(31)));
        vector.addElement(new GlassItem(43, true, this.getFieldDescription(43)));
        vector.addElement(new GlassItem(27, true, this.getFieldDescription(27)));
        vector.addElement(new GlassItem(30, true, this.getFieldDescription(30)));
        vector.addElement(new GlassItem(28, true, this.getFieldDescription(28)));
        vector.addElement(new GlassItem(34, true, this.getFieldDescription(34)));
        return vector;
    }

    public void setDocInd(DocRec docRec) {
        this.docInd = docRec.docInd;
        this.existingDocInd = docRec.existingDocInd;
    }

    public void setDocInd(int n) {
        this.docInd = n;
    }

    private boolean deleteDocument(String string) {
        String string2 = "deleteDocument";
        SQLMethod sQLMethod = new SQLMethod(1, string2, 5);
        Object var4_4 = null;
        boolean bl = false;
        try {
            DocRec.forceUpdateVecRecStatus(this.mediaVec, 3);
            DocRec.forceUpdateVecRecStatus(this.graphicVec, 3);
            this.publish = false;
            if (DocFTP.processFiles(this)) {
                DocFileRec docFileRec;
                int n = 0;
                int n2 = 0;
                Statement statement = sQLMethod.createStatement();
                statement.executeUpdate("DELETE FROM " + string + ".DOCBODY     WHERE DOCIND = " + this.getDatabaseDocInd());
                statement.executeUpdate("DELETE FROM " + string + ".DOCBRAND    WHERE DOCIND = " + this.getDatabaseDocInd());
                statement.executeUpdate("DELETE FROM " + string + ".DOCCATEGORY WHERE DOCIND = " + this.getDatabaseDocInd());
                statement.executeUpdate("DELETE FROM " + string + ".DOCCOUNTRY  WHERE DOCIND = " + this.getDatabaseDocInd());
                statement.executeUpdate("DELETE FROM " + string + ".DOCGEO      WHERE DOCIND = " + this.getDatabaseDocInd());
                statement.executeUpdate("DELETE FROM " + string + ".DOCGRAPHIC  WHERE DOCIND = " + this.getDatabaseDocInd());
                statement.executeUpdate("DELETE FROM " + string + ".DOCLINKS    WHERE DOCIND = " + this.getDatabaseDocInd());
                statement.executeUpdate("DELETE FROM " + string + ".DOCLINKS    WHERE DOCLINKIND = " + this.getDatabaseDocInd());
                statement.executeUpdate("DELETE FROM " + string + ".DOCMEDIA    WHERE DOCIND = " + this.getDatabaseDocInd());
                statement.executeUpdate("DELETE FROM " + string + ".DOCSTATUS   WHERE DOCIND = " + this.getDatabaseDocInd());
                statement.executeUpdate("DELETE FROM " + string + ".PRODDOCS    WHERE DOCIND = " + this.getDatabaseDocInd());
                if (this.mediaVec != null) {
                    docFileRec = null;
                    n = this.mediaVec.size();
                    n2 = 0;
                    while (n2 < n) {
                        docFileRec = (DocFileRec)this.mediaVec.elementAt(n2);
                        if (docFileRec != null) {
                            statement.executeUpdate("DELETE FROM QUEST.DOCMEDIA WHERE MULTIMEDIAIND = " + docFileRec.fileInd);
                        }
                        statement.executeUpdate("DELETE FROM TIGRIS.MULTIMEDIA WHERE MULTIMEDIAIND = " + docFileRec.fileInd + " AND MULTIMEDIAIND NOT IN (SELECT MULTIMEDIAIND FROM TIGRIS.DOCMEDIA WHERE MULTIMEDIAIND=" + docFileRec.fileInd + ")");
                        ++n2;
                    }
                }
                if (this.graphicVec != null) {
                    docFileRec = null;
                    n = this.graphicVec.size();
                    n2 = 0;
                    while (n2 < n) {
                        docFileRec = (DocFileRec)this.graphicVec.elementAt(n2);
                        if (docFileRec != null) {
                            statement.executeUpdate("DELETE FROM QUEST.DOCGRAPHIC WHERE GRAPHICIND = " + docFileRec.fileInd);
                        }
                        statement.executeUpdate("DELETE FROM TIGRIS.GRAPHICS WHERE GRAPHICIND = " + docFileRec.fileInd + " AND GRAPHICIND NOT IN (SELECT GRAPHICIND FROM TIGRIS.DOCGRAPHIC WHERE GRAPHICIND=" + docFileRec.fileInd + ")");
                        ++n2;
                    }
                }
                if (string.equals("QUEST")) {
                    statement.executeUpdate("DELETE FROM QUEST.DOCPROPERTIES WHERE DOCIND = " + this.getDatabaseDocInd());
                } else {
                    statement.executeUpdate("DELETE FROM QUEST.DOCPROPERTIES WHERE DOCIND = " + this.getDatabaseDocInd() + " AND PROPERTYIND <> 1");
                }
                if (string.equals("QUEST")) {
                    statement.executeUpdate("DELETE FROM " + string + ".DOCUMENTS   WHERE DOCIND = " + this.getDatabaseDocInd());
                } else {
                    statement.executeUpdate("UPDATE TIGRIS.DOCUMENTS SET PUBLISH = 'N', RECYCLED = 'Y', DBUSER = '" + UserSystem.getUserId() + "', CHANGEDTIME = CURRENT TIMESTAMP WHERE DOCIND = " + this.getDatabaseDocInd());
                }
                bl = true;
            }
        }
        catch (SQLException sQLException) {
            sQLMethod.rollBack();
            LogSystem.log(1, sQLException);
        }
        sQLMethod.close();
        return bl;
    }

    public void setRequest(boolean bl) {
        this.request = bl;
    }

    public Vector getAllProducts() {
        Vector vector = null;
        if (this.prodDocRec != null) {
            vector = this.prodDocRec.getAssociatedModels();
        }
        return vector;
    }

    public boolean getLock() {
        boolean bl = false;
        bl = this.maintLock && !this.dbUser.equals(UserSystem.getUserId());
        return bl;
    }

    public boolean getLockFromDatabase() {
        SQLMethod sQLMethod = new SQLMethod(1, "getLockFromDatabase", 5);
        boolean bl = false;
        String string = null;
        int n = 0;
        if (this.docInd == 0 && this.existingDocInd != 0) {
            string = "TIGRIS";
            n = this.existingDocInd;
        } else {
            string = this.getDatabaseQualifier();
            n = this.getDatabaseDocInd();
        }
        try {
            if (n != 0) {
                Statement statement = sQLMethod.createStatement();
                ResultSet resultSet = statement.executeQuery("SELECT MAINTLOCK, DBUSER FROM " + string + ".DOCUMENTS WHERE DOCIND = " + n);
                String string2 = null;
                String string3 = null;
                if (resultSet.next()) {
                    string3 = resultSet.getString(1).trim();
                    string2 = resultSet.getString(2).trim();
                    bl = string3.equals("Y") && !string2.equals(UserSystem.getUserId());
                } else {
                    bl = false;
                }
                resultSet.close();
            } else {
                bl = false;
            }
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception);
        }
        sQLMethod.close();
        return bl;
    }

    public boolean lockDoc(boolean bl) {
        if (this.getDatabaseDocInd() != 0) {
            return this.lockDoc(this.getDatabaseQualifier(), bl, this.getDatabaseDocInd());
        }
        if (this.getDatabaseDocInd() == 0 && !bl) {
            return this.lockDoc("TIGRIS", false, this.existingDocInd);
        }
        return true;
    }

    private boolean lockDoc(String string, boolean bl, int n) {
        String string2 = "lockDoc";
        SQLMethod sQLMethod = new SQLMethod(1, string2, 5);
        boolean bl2 = false;
        String string3 = "UPDATE " + string + ".DOCUMENTS " + " SET MAINTLOCK = '" + (bl ? "Y" : "N") + "', DBUSER = '" + UserSystem.getUserId() + "' " + " WHERE DOCIND = " + n;
        if (bl) {
            DocRec.getWindow().setStatus(313);
        } else {
            DocRec.getWindow().setStatus(314);
        }
        try {
            Statement statement = sQLMethod.createStatement();
            if (statement != null) {
                statement.executeUpdate(string3);
            }
            bl2 = true;
        }
        catch (SQLException sQLException) {
            sQLMethod.rollBack();
            LogSystem.log(1, sQLException);
        }
        sQLMethod.close();
        DocRec.getWindow().setStatus(null);
        return bl2;
    }

    public void setLastTouched() {
        if (this.getDatabaseDocInd() != 0) {
            SQLMethod sQLMethod = new SQLMethod(1, "setLastTouched", 5);
            try {
                Statement statement = sQLMethod.createStatement();
                int n = statement.executeUpdate("UPDATE " + this.getDatabaseQualifier() + ".DOCUMENTS " + "SET DBUSER = '" + this.dbUser + "', " + "    CHANGEDTIME = '" + this.changedTime + "' " + "    WHERE DOCIND = " + this.getDatabaseDocInd());
                if (n == 0) {
                    System.out.println("Updaing Existing");
                    statement.executeUpdate("UPDATE TIGRIS.DOCUMENTS " + "SET DBUSER       = '" + this.dbUser + "', " + "    MAINTLOCK    = 'N', " + "    CHANGEDTIME  = '" + this.changedTime + "' " + "    WHERE DOCIND = " + this.existingDocInd);
                }
            }
            catch (Exception exception) {
                sQLMethod.rollBack();
                LogSystem.log(1, exception, false);
            }
            sQLMethod.close();
        } else if (this.existingDocInd != 0) {
            SQLMethod sQLMethod = new SQLMethod(1, "setLastTouched (Existing)", 5);
            try {
                Statement statement = sQLMethod.createStatement();
                statement.executeUpdate("UPDATE TIGRIS.DOCUMENTS " + "SET DBUSER = '" + this.dbUser + "', " + "    CHANGEDTIME = '" + this.changedTime + "' " + "    WHERE DOCIND = " + this.existingDocInd);
            }
            catch (Exception exception) {
                sQLMethod.rollBack();
                LogSystem.log(1, exception, false);
            }
            sQLMethod.close();
        }
    }

    public void setForEdit(boolean bl) {
        Thread thread = new Thread((Runnable)this, THREAD_SETFOREDIT);
        this.setForEdit = bl;
        thread.start();
        try {
            thread.join();
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
    }

    private void processSetForEdit() {
        this.lockDoc(this.setForEdit);
    }

    public void setOwnerFromBrand() {
        UserRec userRec;
        TypeBrandRec typeBrandRec;
        if ((this.owner == null || this.owner.length() <= 1) && (typeBrandRec = this.getDocBrand()) != null && (userRec = UserSystem.getBrandProgramManager(typeBrandRec.getInd(), "DOC")) != null) {
            this.owner = userRec.getUserId();
        }
    }

    private boolean syncSSDAttach() {
        String string = "syncSSDAttach";
        SQLMethod sQLMethod = new SQLMethod(1, string, 5);
        boolean bl = false;
        LogSystem.beginLogSection("Starting SSD Sync");
        try {
            this.getSavePanel().setStatus(315);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.hasFileAttachments() && sQLMethod != null) {
            Vector<Integer> vector = new Vector<Integer>(2, 1);
            DocFileRec docFileRec = null;
            try {
                Statement statement = sQLMethod.createStatement();
                ResultSet resultSet = null;
                String string2 = null;
                int n = 0;
                int n2 = 0;
                string2 = "SELECT MULTIMEDIAIND " + "FROM TIGRIS.DOCMEDIA " + "WHERE DOCIND = " + this.existingDocInd + " " + "FOR FETCH ONLY";
                resultSet = statement.executeQuery(string2);
                while (resultSet.next()) {
                    vector.addElement(new Integer(resultSet.getInt(1)));
                }
                vector.trimToSize();
                n2 = this.mediaVec.size();
                while (n < n2) {
                    docFileRec = (DocFileRec)this.mediaVec.elementAt(n);
                    if (!StoreUtil.vectorContainsInteger(vector, docFileRec.fileInd)) {
                        LogSystem.log(1, "Could not find file :" + docFileRec.sFilename + " MediaInd:" + docFileRec.fileInd + " in existing files, creating NEW FILE");
                        docFileRec.prepareForProduction();
                    } else if (docFileRec.getRecStatus() == 2) {
                        LogSystem.log(1, "Found " + docFileRec.sFilename + "  MediaInd:" + docFileRec.fileInd + " in existing files, changing from INSERT to UPDATE since it already exists");
                        docFileRec.updateRecStatus(0);
                        docFileRec.updateRecStatus(1);
                    }
                    ++n;
                }
                bl = true;
            }
            catch (Exception exception) {
                sQLMethod.rollBack();
                LogSystem.log(1, exception);
            }
        }
        sQLMethod.close();
        LogSystem.endLogSection();
        return bl;
    }

    private static final DocFileRec getDocFileRecFromFilename(String string, Vector vector) {
        DocFileRec docFileRec = null;
        DocFileRec docFileRec2 = null;
        if (string != null && vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            while (docFileRec == null && n < n2) {
                docFileRec2 = (DocFileRec)vector.elementAt(n);
                if (docFileRec2.sFilename.equals(string)) {
                    docFileRec = docFileRec2;
                }
                ++n;
            }
        }
        return docFileRec;
    }

    public boolean hasFileAttachments() {
        boolean bl = false;
        if (this.mediaVec != null && this.mediaVec.size() > 0) {
            int n = 0;
            int n2 = this.mediaVec.size();
            while (!bl && n < n2) {
                if (((DocFileRec)this.mediaVec.elementAt(n)).getRecStatus() != 3) {
                    bl = true;
                }
                ++n;
            }
        }
        return bl;
    }

    private boolean saveDocCreateDate(StringBuffer stringBuffer) {
        String string = "saveDocCreateDate";
        String string2 = "";
        boolean bl = false;
        try {
            stringBuffer.append("DELETE FROM QUEST.DOCSTATUS WHERE RECNUM = 1 AND DOCIND = " + this.getDatabaseDocInd() + QITSqlRunner.END_DELIM);
            string2 = "INSERT INTO QUEST.DOCSTATUS " + "( DOCIND,     RECNUM,    STATUSIND, COUNTRYCODEIND, " + "  STATUSDATE, REFERENCE, DBUSER,    CHANGEDTIME)    " + "VALUES                                              " + "( " + this.getDatabaseDocInd() + ", " + "  1,   " + "  10,  " + "  110, " + " '" + DateSystem.getDate(2) + "', " + "  NULL, " + " '" + UserSystem.getUserId() + "', " + "  CURRENT TIMESTAMP)";
            stringBuffer.append(string2 + QITSqlRunner.END_DELIM);
            bl = true;
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
        return bl;
    }

    public void addFieldListener(FieldListener fieldListener) {
        if (this.fieldListenerVec == null) {
            this.fieldListenerVec = new Vector(1, 1);
        }
        if (!this.fieldListenerVec.contains(fieldListener)) {
            this.fieldListenerVec.addElement(fieldListener);
        }
    }

    public void removeFieldListener(FieldListener fieldListener) {
        if (this.fieldListenerVec != null) {
            this.fieldListenerVec.removeElement(fieldListener);
        }
    }

    public void removeAllListeners() {
        this.fieldListenerVec = null;
    }

    private void fireChange(int n) {
        if (this.fieldListenerVec != null) {
            int n2 = 0;
            int n3 = this.fieldListenerVec.size();
            while (n2 < n3) {
                ((FieldListener)this.fieldListenerVec.elementAt(n2++)).fieldChanged(this, n);
            }
        }
    }

    public String getAllCategories() {
        String string = Str.getStr(198);
        if (this.docCatVec != null) {
            TypeDocCatRec typeDocCatRec = null;
            StringBuffer stringBuffer = new StringBuffer("");
            int n = 0;
            int n2 = this.docCatVec.size();
            if (n2 > 0) {
                while (n < n2) {
                    typeDocCatRec = (TypeDocCatRec)this.docCatVec.elementAt(n);
                    if (typeDocCatRec != null) {
                        stringBuffer.append(typeDocCatRec.toString() + ", ");
                    }
                    ++n;
                }
                if (stringBuffer.length() > 0) {
                    stringBuffer.setLength(stringBuffer.length() - 2);
                    string = stringBuffer.toString();
                }
                stringBuffer = null;
            }
        }
        return string;
    }

    protected void finalize() {
        this.free();
    }

    public boolean mustPublish() {
        boolean bl = false;
        if (this.origMediaVec != null && this.mediaVec != null) {
            int n;
            int n2 = this.origMediaVec.size();
            if (n2 > (n = this.mediaVec.size())) {
                bl = true;
            } else {
                DocFileRec docFileRec = null;
                DocFileRec docFileRec2 = null;
                int n3 = 0;
                while (!bl && n3 < n2) {
                    docFileRec = (DocFileRec)this.origMediaVec.elementAt(n3);
                    if (this.mediaVec.contains(docFileRec)) {
                        docFileRec2 = (DocFileRec)this.mediaVec.elementAt(this.mediaVec.indexOf(docFileRec));
                        if (!(docFileRec2.fileSize == docFileRec.fileSize && docFileRec2.fileLoc.equals(docFileRec.fileLoc) && docFileRec2.descript.equals(docFileRec.descript) && docFileRec2.sFilename.equals(docFileRec.sFilename) && docFileRec2.getRecStatus() != 3 && docFileRec2.getRecStatus() != 4)) {
                            bl = true;
                        }
                    } else {
                        bl = true;
                    }
                    ++n3;
                }
            }
        }
        return bl;
    }

    public boolean getSSD() {
        boolean bl = false;
        if (this.docTypeRec != null) {
            bl = this.docTypeRec.getInd() == 9;
        }
        return bl;
    }

    public boolean canAttachFiles() {
        boolean bl = false;
        if (this.docTypeRec != null) {
            bl = this.docTypeRec.getInd() == 9 || this.docTypeRec.getInd() == 8;
        }
        return bl;
    }

    public String getProcessName() {
        return Str.getStr(316);
    }

    public void clearDocIndicators() {
        this.docInd = 0;
        this.existingDocInd = 0;
        this.graphicVec = new Vector();
        this.mediaVec = new Vector();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof DocRec) {
            bl = ((DocRec)object).docInd == this.docInd && ((DocRec)object).existingDocInd == this.existingDocInd;
        }
        return bl;
    }

    public void setDocEditor(Object object) {
        this.docEditor = object;
    }

    public static String prepareBodyForPreview(String string) {
        String string2 = PropertySystem.getString(23) + File.separator;
        string = Text.replaceAllStrInStr(string, "\"./", "\"FILE:/" + string2);
        string = Text.replaceAllStrInStr(string, "###IMAGELOC###", "FILE:/" + string2);
        string = Text.replaceAllStrInStr(string, "null", "");
        return string;
    }

    public void prepareForSerialize() {
        if (this.prodDocRec != null) {
            this.prodDocRec.prepareForSerialize();
        }
        if (this.fieldListenerVec != null) {
            this.fieldListenerVec.removeAllElements();
        }
        this.fieldListenerVec = null;
        this.docEditor = null;
        this.changedTime = DateSystem.getDate(1);
    }

    public int getTemplateDocInd() {
        return this.templateDocInd;
    }

    public boolean republish() {
        String string = "republish";
        SQLMethod sQLMethod = new SQLMethod(1, string, 5);
        boolean bl = false;
        DocRec.getWindow().setStatus(Str.getStr(317) + " " + this.existingDocInd);
        if (sQLMethod != null && this.existingDocInd > 0) {
            try {
                Statement statement = sQLMethod.createStatement();
                statement.executeUpdate("UPDATE TIGRIS.DOCUMENTS SET " + "CHANGEDTIME  = CURRENT TIMESTAMP, " + "DBUSER       = '" + UserSystem.getUserId() + "' " + "WHERE DOCIND = " + this.existingDocInd);
                bl = true;
            }
            catch (Exception exception) {
                sQLMethod.rollBack();
                LogSystem.log(1, exception);
            }
        }
        DocRec.getWindow().setStatus(null);
        sQLMethod.close();
        return bl;
    }

    public void showEMailPreview() {
    }

    public boolean readEMailPreview() {
        String string = "readEMailPreview";
        SQLMethod sQLMethod = new SQLMethod(1, string, 5);
        boolean bl = false;
        if (this.existingDocInd > 0) {
            try {
                Statement statement = sQLMethod.createStatement();
                ResultSet resultSet = statement.executeQuery("SELECT SUMMARY, EMAILABLEDATE " + "FROM  TIGRIS.DOCUMENTS " + "WHERE DOCIND    = " + this.existingDocInd + " AND " + "      EMAILABLE = 'Y' " + "FOR FETCH ONLY");
                if (resultSet.next()) {
                    if (this.publishingTagsRec == null) {
                        this.publishingTagsRec = new PublishingTagsRec();
                    }
                    this.publishingTagsRec.eMailComments = resultSet.getString(1);
                    this.publishingTagsRec.eMailableDate = resultSet.getString(2);
                    this.publishingTagsRec.eMailableDate = this.publishingTagsRec.eMailableDate.trim();
                    this.publishingTagsRec.eMailComments = this.publishingTagsRec.eMailComments.trim();
                    this.publishingTagsRec.eMailable = true;
                }
                bl = true;
            }
            catch (Exception exception) {
                sQLMethod.rollBack();
                LogSystem.log(1, exception);
            }
        }
        sQLMethod.close();
        DocRec.getWindow().setStatus(null);
        return bl;
    }

    private boolean removeDupGraphics() {
        DocFileRec docFileRec = null;
        DocFileRec docFileRec2 = null;
        int n = 0;
        if (this.graphicVec != null) {
            int n2 = this.graphicVec.size();
            int n3 = 0;
            while (n < n2) {
                docFileRec = (DocFileRec)this.graphicVec.elementAt(n);
                n3 = n + 1;
                while (n3 < n2) {
                    docFileRec2 = (DocFileRec)this.graphicVec.elementAt(n3);
                    if (docFileRec2.fileInd == docFileRec.fileInd) {
                        this.graphicVec.removeElement(docFileRec2);
                        --n2;
                        n3 = n + 1;
                        continue;
                    }
                    ++n3;
                }
                ++n;
            }
        }
        return true;
    }

    private boolean removeDupMedia() {
        DocFileRec docFileRec = null;
        DocFileRec docFileRec2 = null;
        int n = 0;
        try {
            if (this.mediaVec != null) {
                int n2 = this.mediaVec.size();
                int n3 = 0;
                while (n < n2) {
                    docFileRec = (DocFileRec)this.mediaVec.elementAt(n);
                    n3 = n + 1;
                    while (n3 < n2) {
                        docFileRec2 = (DocFileRec)this.mediaVec.elementAt(n3);
                        if (docFileRec2.fileInd == docFileRec.fileInd && docFileRec2.sFilename.equals(docFileRec.sFilename)) {
                            this.mediaVec.removeElement(docFileRec2);
                            --n2;
                            n3 = n + 1;
                            continue;
                        }
                        ++n3;
                    }
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    private boolean removeDupLinks() {
        DocLinkRec docLinkRec = null;
        DocLinkRec docLinkRec2 = null;
        int n = 0;
        try {
            if (this.docLinksVec != null) {
                int n2 = this.docLinksVec.size();
                int n3 = 0;
                while (n < n2) {
                    docLinkRec = (DocLinkRec)this.docLinksVec.elementAt(n);
                    n3 = n + 1;
                    while (n3 < n2) {
                        docLinkRec2 = (DocLinkRec)this.docLinksVec.elementAt(n3);
                        if (docLinkRec2.docInd == docLinkRec.docInd) {
                            this.docLinksVec.removeElement(docLinkRec2);
                            --n2;
                            n3 = n + 1;
                            continue;
                        }
                        ++n3;
                    }
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    public String getStopDate() {
        return this.stopDate;
    }

    public static int checkForDocRequest(int n) {
        String string = "checkForDocRequest";
        SQLMethod sQLMethod = new SQLMethod(1, string, 5);
        int n2 = 0;
        if (sQLMethod != null) {
            try {
                String string2 = "";
                String string3 = "";
                String string4 = "";
                Statement statement = sQLMethod.createStatement();
                ResultSet resultSet = null;
                resultSet = statement.executeQuery("SELECT DOCIND, RECYCLED, DBUSER, CHANGEDTIME " + "FROM QUEST.DOCUMENTS " + "WHERE EXISTINGDOCIND = " + n + " AND " + "      STOPDATE       IS NULL  AND " + "      TEMPLATE       = 'N'  " + " FETCH FIRST 1 ROWS ONLY");
                if (resultSet.next()) {
                    n2 = resultSet.getInt(1);
                    string3 = resultSet.getString(2).trim();
                    string2 = resultSet.getString(3).trim();
                    string4 = resultSet.getString(4).trim();
                    if (string3.equals("Y")) {
                        GUISystem.printBox(Str.getStr(6), "The document you are editing has an open request in the Recycling Bin. " + UserSystem.getNameFromUserId(string2) + " placed it in the Recycling Bin on " + DateSystem.prettyDateFromStamp(string4) + ". " + "Please either delete the document from the Recycling Bin, or restore the document from the bin.");
                        n2 = -1;
                    }
                }
                resultSet.close();
            }
            catch (Exception exception) {
                sQLMethod.rollBack();
                LogSystem.log(1, exception);
            }
        }
        sQLMethod.close();
        return n2;
    }

    public void edit() {
        this.edit(null);
    }

    public void edit(QuestPanel questPanel) {
        boolean bl = false;
        DocEditPanel docEditPanel = (DocEditPanel)((Object)WindowSystem.findQuestPanel(this));
        parentPanel = questPanel;
        parentWindow = null;
        DocRec.getWindow().setStatus(240);
        DocRec.getWindow().setStatusLock(true);
        if (UserSystem.hasAuthority(20) || UserSystem.hasAuthority(5)) {
            if (docEditPanel != null) {
                WindowSystem.showPanel((QuestPanel)((Object)docEditPanel));
            } else if (!this.isDocRequest()) {
                DocRec docRec = null;
                docRec = this.createDocRequest();
                if (docRec != null) {
                    DocEditPanel docEditPanel2 = null;
                    docRec.setFieldData(52, TypeList.getInstance().objectFromInd(2, 14));
                    docEditPanel2 = new DocEditPanel(docRec, false, questPanel);
                    WindowSystem.createPanel((QuestPanel)((Object)docEditPanel2));
                }
            } else {
                DocEditPanel docEditPanel3 = new DocEditPanel(this, true, questPanel);
                WindowSystem.createPanel((QuestPanel)((Object)docEditPanel3));
            }
        } else {
            GUISystem.printBox(7, 215);
        }
        DocRec.getWindow().setStatusLock(false);
        DocRec.getWindow().setStatus(null);
    }

    private Vector readReferencedLinks() {
        String string = "readDocLinks";
        SQLMethod sQLMethod = new SQLMethod(1, string, 5);
        boolean bl = false;
        String string2 = "";
        Vector<DocLinkRec> vector = null;
        try {
            if (sQLMethod != null) {
                DocLinkRec docLinkRec = null;
                ResultSet resultSet = null;
                Statement statement = sQLMethod.createStatement();
                String string3 = this.getDatabaseQualifier();
                string2 = "SELECT A.DOCIND, B.TITLE, B.DOCCLASSIND, B.LNDOCID " + "FROM   TIGRIS.DOCLINKS A, " + "       TIGRIS.DOCUMENTS B " + "WHERE  A.DOCLINKIND  = " + this.existingDocInd + " AND " + "       A.DOCIND      = B.DOCIND " + "       FOR FETCH ONLY";
                resultSet = statement.executeQuery(string2);
                while (resultSet.next()) {
                    docLinkRec = new DocLinkRec();
                    docLinkRec.docInd = resultSet.getInt(1);
                    docLinkRec.title = resultSet.getString(2).trim();
                    docLinkRec.docClassRec = (TypeDocClassRec)TypeList.getInstance().objectFromInd(resultSet.getInt(3), 5);
                    docLinkRec.notesId = resultSet.getString(4).trim();
                    if (vector == null) {
                        vector = new Vector<DocLinkRec>(10, 10);
                    }
                    vector.addElement(docLinkRec);
                }
            }
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, string + ", docInd:" + this.docInd + " existingDocInd:" + this.existingDocInd);
            LogSystem.log(1, exception);
            vector = null;
        }
        sQLMethod.close();
        DocRec.getWindow().setStatus(null);
        return vector;
    }

    private boolean ftpRequestFileAttachments() {
        boolean bl = false;
        DocFileRec docFileRec = null;
        try {
            Ftp ftp = new Ftp();
            if (this.mediaVec != null && this.mediaVec.size() > 0) {
                int n = 0;
                int n2 = this.mediaVec.size();
                String string = "";
                String string2 = Constants.getStrConst("IT_FILELOCTEMP");
                String string3 = PropertySystem.getString(30) + File.separator;
                if (this.savePanel != null) {
                    this.savePanel.setStatus(216);
                } else {
                    DocRec.getWindow().setStatus(216);
                    DocRec.getWindow().setStatusLock(true);
                }
                LogSystem.beginLogSection("Beginning FTP Process for Document Request");
                LogSystem.log(1, "Connecting To FTP Server");
                ftp.connect(Constants.getStrConst("IT_FILEHOSTTEMP"));
                LogSystem.log(1, "Logging into FTP Server");
                ftp.login("quest", "hgra2l");
                LogSystem.log(1, "Changing Local  Directory to:" + string3);
                LogSystem.log(1, "Changing Remote Directory to:" + string2);
                ftp.cd(string2);
                while (n < n2) {
                    docFileRec = (DocFileRec)this.mediaVec.elementAt(n);
                    string = Text.stripPath(docFileRec.sFilename);
                    switch (docFileRec.getFTPRecStatus()) {
                        case 3: {
                            LogSystem.log(1, "Deleting File:" + string);
                            try {
                                ftp.delete(string);
                            }
                            catch (FtpError ftpError) {
                                if (ftpError.toString().indexOf("No such file") != -1 || ftpError.toString().indexOf("not exist") != -1) break;
                                GUISystem.printBox(6, 217);
                                LogSystem.log(1, ftpError);
                                if (docFileRec != null) {
                                    LogSystem.log(1, "Exception occurred during process of file: " + docFileRec.sFilename);
                                    break;
                                }
                                LogSystem.log(1, "Exception occurred during unknown file process");
                            }
                            break;
                        }
                        case 1: 
                        case 2: {
                            LogSystem.log(1, "Uploading File:" + string);
                            if (string.toUpperCase().endsWith("TXT")) {
                                ftp.setType('A');
                                LogSystem.log(1, "Uploading File in ASCII");
                            } else {
                                ftp.setType('I');
                                LogSystem.log(1, "Uploading File in BINARY");
                            }
                            if (FileUtil.exists(string3 + string)) {
                                if (this.savePanel != null) {
                                    this.savePanel.setStatus(Str.getStr(216) + ": " + string);
                                } else {
                                    DocRec.getWindow().setStatus(Str.getStr(216) + ": " + string);
                                    DocRec.getWindow().setStatusLock(true);
                                }
                                ftp.put(string3 + string, string, false);
                                docFileRec.fileSize = ftp.size(string);
                                System.out.println("Request File Attachments returned size " + docFileRec.fileSize + " For " + string);
                                break;
                            }
                            LogSystem.log(1, "Could not find local file:" + string3 + string);
                            if (!GUISystem.printBox(Str.getStr(8), Str.getStr(343) + ": " + string3 + string)) {
                                LogSystem.log(1, "User answered that they do not want to continue saving");
                                ftp.logout();
                                return false;
                            }
                            LogSystem.log(1, "User answered that they wish to continue saving");
                            break;
                        }
                    }
                    ++n;
                }
                LogSystem.log(1, "Logging out from FTP server");
                LogSystem.endLogSection();
                ftp.logout();
                bl = true;
            } else {
                bl = true;
            }
        }
        catch (Exception exception) {
            GUISystem.printBox(6, 217);
            LogSystem.log(1, exception);
            if (docFileRec != null) {
                LogSystem.log(1, "Exception occurred during process of file: " + docFileRec.sFilename);
            }
            LogSystem.log(1, "Exception occurred during unknown file process");
        }
        return bl;
    }

    private boolean ftpRequestGraphics() {
        boolean bl;
        block17: {
            Ftp ftp = new Ftp();
            bl = false;
            DocFileRec docFileRec = null;
            if (this.graphicVec != null && this.graphicVec.size() > 0) {
                try {
                    int n = 0;
                    int n2 = this.graphicVec.size();
                    String string = "";
                    String string2 = Constants.getStrConst("IT_IMAGELOCTEMP");
                    String string3 = PropertySystem.getString(30) + File.separator;
                    try {
                        this.getSavePanel().setStatus(216);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    LogSystem.beginLogSection("Beginning FTP Process for Document Request");
                    LogSystem.log(1, "Connecting To FTP Server");
                    ftp.connect(Constants.getStrConst("IT_IMAGEHOSTTEMP"));
                    LogSystem.log(1, "Logging into FTP Server");
                    ftp.login("quest", "hgra2l");
                    LogSystem.log(1, "Changing Local  Directory to:" + string3);
                    LogSystem.log(1, "Changing Remote Directory to:" + string2);
                    ftp.cd(string2);
                    ftp.setType('I');
                    while (n < n2) {
                        docFileRec = (DocFileRec)this.graphicVec.elementAt(n);
                        string = Text.stripPath(docFileRec.sFilename);
                        switch (docFileRec.getFTPRecStatus()) {
                            case 3: {
                                LogSystem.log(1, "Deleting Graphic:" + string);
                                try {
                                    ftp.delete(string);
                                }
                                catch (FtpError ftpError) {
                                    if (ftpError.toString().indexOf("No such file") != -1 || ftpError.toString().indexOf("not exist") != -1) break;
                                    GUISystem.printBox(6, 217);
                                    LogSystem.log(1, ftpError);
                                    if (docFileRec != null) {
                                        LogSystem.log(1, "Exception occurred during process of file: " + docFileRec.sFilename);
                                        break;
                                    }
                                    LogSystem.log(1, "Exception occurred during unknown file process");
                                }
                                break;
                            }
                            case 1: 
                            case 2: {
                                LogSystem.log(1, "Uploading Graphic:" + string);
                                if (this.savePanel != null) {
                                    this.savePanel.setStatus(Str.getStr(216) + ": " + string);
                                } else {
                                    DocRec.getWindow().setStatus(Str.getStr(216) + ": " + string);
                                    DocRec.getWindow().setStatusLock(true);
                                }
                                ftp.put(string3 + string, string, false);
                                break;
                            }
                        }
                        ++n;
                    }
                    LogSystem.log(1, "Logging out from FTP server");
                    LogSystem.endLogSection();
                    ftp.logout();
                    bl = true;
                }
                catch (Exception exception) {
                    GUISystem.printBox(6, 217);
                    LogSystem.log(1, exception);
                    if (docFileRec != null) {
                        LogSystem.log(1, "Exception occurred during process of file: " + docFileRec.sFilename);
                        break block17;
                    }
                    LogSystem.log(1, "Exception occurred during unknown file process");
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }

    private boolean ftpPublishFileAttachments() {
        boolean bl;
        block26: {
            Ftp ftp = new Ftp();
            bl = false;
            DocFileRec docFileRec = null;
            if (this.mediaVec != null && this.mediaVec.size() > 0) {
                try {
                    int n = 0;
                    int n2 = this.mediaVec.size();
                    String string = "";
                    String string2 = Constants.getStrConst("IT_FILELOCTEMP");
                    String string3 = Constants.getStrConst("IT_FILELOC");
                    String string4 = PropertySystem.getString(30) + File.separator;
                    LogSystem.log(1, "Connecing to server for initial file download");
                    ftp.connect(Constants.getStrConst("IT_FILEHOSTTEMP"));
                    ftp.login("quest", "hgra2l");
                    LogSystem.log(1, "Changing Remote Directory To:" + string2);
                    LogSystem.log(1, "Changing Local  Directory To:" + string4);
                    ftp.cd(string2);
                    while (n < n2) {
                        docFileRec = (DocFileRec)this.mediaVec.elementAt(n);
                        string = Text.stripPath(docFileRec.sFilename);
                        if (docFileRec.getFTPRecStatus() != 3 && DocRec.validateFTPFile(ftp, string)) {
                            LogSystem.log(1, "Starting download for file:" + string);
                            if (string.toUpperCase().endsWith(".TXT")) {
                                LogSystem.log(1, "Downloading " + string + " in ASCII mode");
                                ftp.setType('A');
                            } else {
                                LogSystem.log(1, "Downloading " + string + " in BINARY mode");
                                ftp.setType('I');
                            }
                            if (this.savePanel != null) {
                                this.savePanel.setStatus(Str.getStr(323) + ": " + string);
                            } else {
                                DocRec.getWindow().setStatus(Str.getStr(323) + ": " + string);
                                DocRec.getWindow().setStatusLock(true);
                            }
                            ftp.get(string, string4 + string);
                            docFileRec.setFTPRecStatus(1);
                        }
                        ++n;
                    }
                    LogSystem.log(1, "Finished downloading from FTP Temp Site, Logging out");
                    ftp.logout();
                    ftp = null;
                    System.gc();
                    LogSystem.log(1, "Connecting to production FTP Site: " + Constants.getStrConst("IT_FILEHOST"));
                    ftp = new Ftp();
                    ftp.connect(Constants.getStrConst("IT_FILEHOST"));
                    ftp.login("quest", "hgra2l");
                    LogSystem.log(1, "Setting Remote Directory To:" + string3);
                    ftp.cd(string3);
                    n = 0;
                    while (n < this.mediaVec.size()) {
                        docFileRec = (DocFileRec)this.mediaVec.elementAt(n);
                        string = Text.stripPath(docFileRec.sFilename);
                        if (FileUtil.exists(string4 + string)) {
                            if (docFileRec.getFTPRecStatus() != 3 && docFileRec.getFTPRecStatus() != 4 && docFileRec.getFTPRecStatus() != 0) {
                                LogSystem.log(1, "Uploading production file (RecStatus):" + docFileRec.getFTPRecStatus() + " from " + string4 + string + " to " + string3 + "/" + string);
                                if (string.toUpperCase().endsWith(".TXT")) {
                                    LogSystem.log(1, "Uploading " + string + " in ASCII mode");
                                    ftp.setType('A');
                                } else {
                                    LogSystem.log(1, "Uploading " + string + " in BINARY mode");
                                    ftp.setType('I');
                                }
                                LogSystem.log(1, "Changing dir to " + string3);
                                ftp.cd(string3);
                                if (this.savePanel != null) {
                                    this.savePanel.setStatus(Str.getStr(323) + ": " + string);
                                } else {
                                    DocRec.getWindow().setStatus(Str.getStr(323) + ": " + string);
                                    DocRec.getWindow().setStatusLock(true);
                                }
                                ftp.put(string4 + string, string, false);
                                docFileRec.fileSize = ftp.size(string);
                                System.out.println("Publish File Attachments returned size " + docFileRec.fileSize + " For " + string);
                            } else {
                                LogSystem.log(1, "Ignoring file " + string + " because it was removed");
                            }
                        } else {
                            LogSystem.log(1, "Could not find local copy of " + string + ".");
                        }
                        ++n;
                    }
                    LogSystem.log(1, "Logging out of ftp site");
                    ftp.logout();
                    ftp = null;
                    System.gc();
                    LogSystem.log(1, "Connecting to TEMP Ftp Site:" + Constants.getStrConst("IT_FILEHOSTTEMP"));
                    ftp = new Ftp();
                    ftp.connect(Constants.getStrConst("IT_FILEHOSTTEMP"));
                    ftp.login("quest", "hgra2l");
                    LogSystem.log(1, "Changing directory to: " + string2);
                    ftp.cd(string2);
                    n = 0;
                    while (n < n2) {
                        docFileRec = (DocFileRec)this.mediaVec.elementAt(n);
                        string = Text.stripPath(docFileRec.sFilename);
                        LogSystem.log(1, "Deleting file from temp ftp sever. Filename:" + string);
                        try {
                            if (this.savePanel != null) {
                                this.savePanel.setStatus(Str.getStr(828) + ": " + string);
                            } else {
                                DocRec.getWindow().setStatus(Str.getStr(828) + ": " + string);
                                DocRec.getWindow().setStatusLock(true);
                            }
                            if (DocRec.validateFTPFile(ftp, string)) {
                                ftp.delete(string);
                            }
                        }
                        catch (Exception exception) {
                            LogSystem.log(1, exception);
                        }
                        ++n;
                    }
                    bl = true;
                }
                catch (Exception exception) {
                    LogSystem.log(1, exception);
                    GUISystem.printBox(6, 217);
                    if (docFileRec != null) {
                        LogSystem.log(1, "Exception occurred during process of file: " + docFileRec.sFilename);
                        break block26;
                    }
                    LogSystem.log(1, "Exception occurred during unknown file process");
                }
            } else {
                bl = true;
            }
        }
        LogSystem.log(1, "Publish process complete. rc = " + bl);
        LogSystem.endLogSection();
        return true;
    }

    private boolean ftpPublishHeaders() {
        block13: {
            Ftp ftp = new Ftp();
            boolean bl = false;
            DocFileRec docFileRec = null;
            if (this.mediaVec != null && this.mediaVec.size() > 0) {
                try {
                    int n = 0;
                    int n2 = this.mediaVec.size();
                    String string = "";
                    String string2 = Constants.getStrConst("IT_FILELOC");
                    String string3 = PropertySystem.getString(30) + File.separator;
                    if (this.savePanel != null) {
                        this.savePanel.setStatus(Str.getStr(216));
                    } else {
                        DocRec.getWindow().setStatus(Str.getStr(216));
                        DocRec.getWindow().setStatusLock(true);
                    }
                    LogSystem.beginLogSection("Beginning FTP Process for Document Header Publish ");
                    LogSystem.log(1, "Connecting To FTP Server");
                    ftp.connect(Constants.getStrConst("IT_FILEHOST"));
                    LogSystem.log(1, "Logging into FTP Server");
                    ftp.login("quest", "hgra2l");
                    LogSystem.log(1, "Changing Local  Directory to:" + string3);
                    LogSystem.log(1, "Changing Remote Directory to:" + string2);
                    ftp.cd(string2);
                    ftp.setType('A');
                    while (n < n2) {
                        docFileRec = (DocFileRec)this.mediaVec.elementAt(n);
                        string = Text.stripPath(docFileRec.sFilename);
                        LogSystem.log(1, "Generating Header File for: " + string3 + string);
                        switch (docFileRec.getFTPRecStatus()) {
                            case 1: 
                            case 2: {
                                if (DocRec.validateFTPFile(ftp, string)) {
                                    if (!this.generateFileAttachmentHeader(docFileRec)) break;
                                    LogSystem.log(1, "FTPing Header file:" + string3 + string + ".hdr");
                                    ftp.put(string3 + string + ".hdr", string + ".hdr", false);
                                    break;
                                }
                                LogSystem.log(1, "Could not generate Header File for: " + string + " because is was not on the ftp server");
                                break;
                            }
                            case 3: {
                                if (!this.generateFileAttachmentHeader(docFileRec)) break;
                                ftp.put(string3 + string + ".hdr", string + ".hdr", false);
                                break;
                            }
                        }
                        ++n;
                    }
                    LogSystem.log(1, "Logging out from FTP server");
                    LogSystem.endLogSection();
                    ftp.logout();
                    bl = true;
                }
                catch (Exception exception) {
                    LogSystem.log(1, exception);
                    GUISystem.printBox(6, 217);
                    if (docFileRec != null) {
                        LogSystem.log(1, "Exception occurred during process of file: " + docFileRec.sFilename);
                        break block13;
                    }
                    LogSystem.log(1, "Exception occurred during unknown file process");
                }
            } else {
                bl = true;
            }
        }
        return true;
    }

    private boolean ftpPublishGraphics() {
        Ftp ftp = new Ftp();
        boolean bl = false;
        DocFileRec docFileRec = null;
        if (this.graphicVec != null && this.graphicVec.size() > 0) {
            LogSystem.beginLogSection("Beginning FTP Process for Document Graphics publish");
            try {
                int n = 0;
                int n2 = this.graphicVec.size();
                String string = "";
                String string2 = Constants.getStrConst("IT_IMAGELOC");
                String string3 = PropertySystem.getString(30) + File.separator;
                if (this.savePanel != null) {
                    this.savePanel.setStatus(Str.getStr(216));
                } else {
                    DocRec.getWindow().setStatus(Str.getStr(216));
                    DocRec.getWindow().setStatusLock(true);
                }
                LogSystem.log(1, "Connecting To FTP Server");
                ftp.connect(Constants.getStrConst("IT_IMAGEHOST"));
                LogSystem.log(1, "Logging into FTP Server");
                if (PropertySystem.getBool(15)) {
                    ftp.login("quest", "hgra2l");
                } else {
                    ftp.login("quest", "k1ngarthur");
                }
                LogSystem.log(1, "Changing Local  Directory to:" + string3);
                LogSystem.log(1, "Changing Remote Directory to:" + string2);
                ftp.cd(string2);
                ftp.setType('I');
                while (n < n2) {
                    docFileRec = (DocFileRec)this.graphicVec.elementAt(n);
                    string = Text.stripPath(docFileRec.sFilename);
                    switch (docFileRec.getFTPRecStatus()) {
                        case 3: {
                            LogSystem.log(1, "Deleting Graphic:" + string);
                            try {
                                if (this.savePanel != null) {
                                    this.savePanel.setStatus(Str.getStr(239) + ": " + string);
                                } else {
                                    DocRec.getWindow().setStatus(Str.getStr(239) + ": " + string);
                                    DocRec.getWindow().setStatusLock(true);
                                }
                                ftp.delete(string);
                                LogSystem.log(1, "Deleted Graphic: " + string);
                            }
                            catch (FtpError ftpError) {
                                if (ftpError.toString().indexOf("understood") >= 0 || ftpError.toString().indexOf("No such file") != -1 || ftpError.toString().indexOf("not exist") != -1) break;
                                GUISystem.printBox(6, 217);
                                LogSystem.log(1, ftpError.toString());
                                if (docFileRec != null) {
                                    LogSystem.log(1, "Exception occurred during process of file: " + docFileRec.sFilename);
                                    break;
                                }
                                LogSystem.log(1, "Exception occurred during unknown file process");
                            }
                            break;
                        }
                        case 1: 
                        case 2: {
                            LogSystem.log(1, "Uploading Graphic:" + string);
                            if (this.savePanel != null) {
                                this.savePanel.setStatus(Str.getStr(216) + ": " + string);
                            } else {
                                DocRec.getWindow().setStatus(Str.getStr(216) + ": " + string);
                                DocRec.getWindow().setStatusLock(true);
                            }
                            ftp.put(string3 + string, string, false);
                            break;
                        }
                    }
                    ++n;
                }
                LogSystem.log(1, "Logging out from FTP server");
                ftp.logout();
                bl = true;
            }
            catch (Exception exception) {
                LogSystem.log(1, exception);
                GUISystem.printBox(6, 217);
                if (docFileRec != null) {
                    LogSystem.log(1, "Exception occurred during process of file: " + docFileRec.sFilename);
                }
                LogSystem.log(1, "Exception occurred during unknown file process");
            }
            LogSystem.endLogSection();
        } else {
            bl = true;
        }
        return bl;
    }

    public boolean generateFileAttachmentHeader(DocFileRec docFileRec) {
        try {
            PersistentRec persistentRec;
            ProdDocRec prodDocRec = (ProdDocRec)this.getFieldData(22);
            Date date = new Date();
            Vector vector = null;
            int n = 0;
            String string = "";
            String string2 = PropertySystem.getString(30);
            File file = new File(string2, Text.stripPath(docFileRec.sFilename) + ".hdr");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            URL uRL = new URL(docFileRec.fileURL);
            String string3 = uRL.getFile().substring(0, uRL.getFile().lastIndexOf("/"));
            if (string3 != null) {
                string3 = string3.substring(string3.lastIndexOf("/", string3.length()));
            }
            fileOutputStream.write(new String("Filename: " + Text.stripPath(docFileRec.sFilename) + "\n").getBytes());
            fileOutputStream.write(new String("filesize: " + docFileRec.fileSize + "\n").getBytes());
            if (docFileRec.getFTPRecStatus() != 1) {
                fileOutputStream.write(new String("filedate: " + date.toString() + "\n").getBytes());
            } else {
                fileOutputStream.write(new String("filedate:").getBytes());
            }
            fileOutputStream.write(new String("filedesc: " + Text.replaceAllStrInStr(docFileRec.descript, "\n", " ") + "\n").getBytes());
            fileOutputStream.write(new String("filearea: " + string3 + "\n").getBytes());
            fileOutputStream.write(new String("ownername: " + UserSystem.getUserName() + "\n").getBytes());
            if (docFileRec.sFilename.toLowerCase().endsWith(".txt")) {
                fileOutputStream.write(new String("filetype: ascii \n").getBytes());
            } else {
                fileOutputStream.write(new String("filetype: binary \n").getBytes());
            }
            switch (docFileRec.getFTPRecStatus()) {
                case 3: {
                    fileOutputStream.write(new String("actiontype: delete \n").getBytes());
                    break;
                }
                case 1: {
                    if (docFileRec.getRecStatus() != 3) {
                        fileOutputStream.write(new String("actiontype: update \n").getBytes());
                        break;
                    }
                    fileOutputStream.write(new String("actiontype: delete \n").getBytes());
                    break;
                }
                default: {
                    fileOutputStream.write(new String("actiontype: insert \n").getBytes());
                    break;
                }
            }
            fileOutputStream.write(new String("fileexpdate: \n").getBytes());
            string = "brand: ";
            if (prodDocRec != null && prodDocRec.hasFamilies()) {
                persistentRec = null;
                vector = prodDocRec.getDistinctBrands();
                n = 0;
                while (n < vector.size()) {
                    persistentRec = (TypeBrandRec)vector.elementAt(n);
                    string = string + ((TypeRec)persistentRec).toString() + ", ";
                    ++n;
                }
            }
            if (string.length() > 3) {
                string = string.substring(0, string.length() - 2);
            }
            fileOutputStream.write((string + "\n").getBytes());
            string = "family: ";
            if (prodDocRec != null && prodDocRec.hasFamilies()) {
                persistentRec = null;
                vector = prodDocRec.getAssociatedFamiliesAll();
                n = 0;
                while (n < vector.size()) {
                    persistentRec = ((DocFamilyRec)vector.elementAt(n)).getTypeGroupRec();
                    string = string + ((TypeRec)persistentRec).toString() + ".ALL, ";
                    ++n;
                }
            }
            if (string.length() > 3) {
                string = string.substring(0, string.length() - 2);
            }
            fileOutputStream.write((string + "\n").getBytes());
            string = "mach: ";
            if (prodDocRec != null && prodDocRec.hasMachines()) {
                persistentRec = null;
                vector = prodDocRec.getAssociatedMachinesAll();
                n = 0;
                while (n < vector.size()) {
                    persistentRec = (MachineRec)vector.elementAt(n);
                    string = string + ((MachineRec)persistentRec).getMachine() + ".ALL, ";
                    ++n;
                }
            }
            if (string.length() > 3) {
                string = string.substring(0, string.length() - 2);
            }
            fileOutputStream.write((string + "\n").getBytes());
            string = "model: ";
            if (prodDocRec != null && prodDocRec.hasModels()) {
                persistentRec = null;
                vector = prodDocRec.getAssociatedModels();
                n = 0;
                while (n < vector.size()) {
                    persistentRec = (ProductRec)vector.elementAt(n);
                    string = string + ((ProductRec)persistentRec).getFieldData(4) + ", ";
                    ++n;
                }
            }
            if (string.length() > 3) {
                string = string.substring(0, string.length() - 2);
            }
            fileOutputStream.write((string + "\n").getBytes());
            fileOutputStream.close();
            LogSystem.log(1, "generateFileAttachmentHeader() - " + file.getName());
            return true;
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            return false;
        }
    }

    private static boolean validateFTPFile(Ftp ftp, String string) {
        boolean bl = false;
        try {
            String[] stringArray = ftp.list(string);
            if (stringArray != null && stringArray[0] != null) {
                LogSystem.log(1, "Validated File Exists:" + string + "  List returned:" + stringArray[0]);
                bl = true;
            } else {
                LogSystem.log(1, "Validated File DOES NOT exist:" + string);
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
        }
        return bl;
    }

    public int compareTo(MultiListSort multiListSort, int n) {
        int n2 = 0;
        if (multiListSort instanceof DocRec) {
            DocRec docRec = (DocRec)multiListSort;
            switch (this.columnData[n]) {
                case 65: {
                    if (this.getDatabaseDocInd() > docRec.getDatabaseDocInd()) {
                        n2 = 1;
                        break;
                    }
                    if (this.getDatabaseDocInd() >= docRec.getDatabaseDocInd()) break;
                    n2 = -1;
                    break;
                }
                case 2: 
                case 53: 
                case 55: 
                case 62: {
                    n2 = ((String)this.getFieldData(this.columnData[n])).compareTo((String)docRec.getFieldData(this.columnData[n]));
                    break;
                }
                case 70: {
                    n2 = ((String)this.getFieldData(2)).compareTo((String)docRec.getFieldData(2));
                    break;
                }
                case 54: 
                case 64: {
                    n2 = CDate.compareDate((String)this.getFieldData(54), (String)docRec.getFieldData(54), 1);
                    break;
                }
                case 5: {
                    n2 = CDate.compareDate((String)this.getFieldData(5), (String)docRec.getFieldData(5), 10);
                    break;
                }
            }
        }
        return n2;
    }

    public static boolean checkDocLock(DocRec docRec) {
        String string = "checkDocLock";
        SQLMethod sQLMethod = new SQLMethod(1, string, 5);
        String string2 = "SELECT MAINTLOCK, DBUSER FROM QUEST.DOCUMENTS WHERE DOCIND = ";
        boolean bl = false;
        DocRec.getWindow().setStatus(331);
        try {
            if (docRec != null && docRec.isDocRequest() && docRec.getDocInd() != 0 && sQLMethod != null) {
                Statement statement = sQLMethod.createStatement();
                ResultSet resultSet = statement.executeQuery(string2 + docRec.getDocInd() + " FOR FETCH ONLY");
                if (resultSet.next()) {
                    bl = resultSet.getString(1).equals("Y") && !resultSet.getString(2).equals(UserSystem.getUserId());
                }
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            sQLMethod.rollBack();
            LogSystem.log(1, sQLException);
        }
        DocRec.getWindow().setStatus(null);
        sQLMethod.close();
        return bl;
    }

    private static AppDefaultWin getWindow() {
        if (parentPanel != null) {
            if (parentWindow == null) {
                parentWindow = GUISystem.getParentDefWin(parentPanel.getJComponent());
            }
        } else {
            return MainWindow.getInstance();
        }
        return parentWindow;
    }

    public boolean getNewRecord() {
        return this.newRecord;
    }

    public void setNewRecord(boolean bl) {
        this.newRecord = bl;
    }

    private void generateFilename() {
        if (this.existingDocInd == 0) {
            this.assignExistingDocInd();
        }
        if (this.notesId == null || this.notesId.length() == 0) {
            this.notesId = "MIGR-" + this.existingDocInd;
        }
        if (this.notesId.length() > 11) {
            this.notesId = this.notesId.substring(0, 11);
        }
    }

    private boolean checkForDupFilename(String string) {
        SQLMethod sQLMethod = new SQLMethod(1, "DocRec.checkForDupFilename ( " + string + " )", 5);
        boolean bl = false;
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT DOCIND FROM TIGRIS.DOCUMENTS WHERE LNDOCID = '" + string + "' FOR FETCH ONLY");
            bl = resultSet.next();
            if (!bl) {
                resultSet.close();
                resultSet = statement.executeQuery("SELECT DOCIND FROM QUEST.DOCUMENTS WHERE LNDOCID = '" + string + "' FOR FETCH ONLY");
                bl = resultSet.next();
                resultSet.close();
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
        sQLMethod.close();
        return bl;
    }

    public String getOriginalComments() {
        return this.originalComment;
    }

    public void setApplyCommentSignature(boolean bl) {
        this.applyCommentSignature = bl;
    }

    private int getReferencedAvalonLink() {
        SQLMethod sQLMethod = new SQLMethod(1, "DocRec.readReferencedAvalonLinks", 5);
        int n = 0;
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT LINKIND FROM OA.LINK " + "WHERE ARCHIVED = 'N' AND " + "      DOCIND   = " + this.existingDocInd + " FOR FETCH ONLY");
            n = resultSet.next() ? resultSet.getInt(1) : 0;
            resultSet.close();
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception, false);
            GUISystem.printBox(7, 202);
            n = -1;
        }
        sQLMethod.close();
        return n;
    }

    public void stopProcess() {
        this.continueProcess = false;
    }

    public void columnSized(int n, int n2) {
        if (n == 2) {
            this.lastTitlePixelWidth = n2;
            this.refreshTitleArray();
        }
    }

    public void adjustColumnGraphics(int n, Graphics graphics) {
    }

    private void refreshTitleArray() {
        if (this.title != null) {
            if (this.charWidth == 0) {
                this.charWidth = 6;
            }
            this.titleArray = Text.formatStringLines(this.title, this.lastTitlePixelWidth / this.charWidth);
        }
    }

    public void setListColumnData(int n, int n2) {
        if (n2 == 2) {
            n2 = 70;
        }
        if (n > this.columnData.length) {
            int[] nArray = new int[n + 1];
            System.arraycopy(this.columnData, 0, nArray, 0, this.columnData.length);
            this.columnData = nArray;
        }
        this.columnData[n] = n2;
    }

    public boolean getPreviewInfoRead() {
        return this.previewInfoRead;
    }

    public boolean validateOwner() {
        boolean bl = false;
        if (this.owner == null || this.owner.length() == 0) {
            if (this.prodDocRec != null) {
                Vector vector = this.prodDocRec.getDistinctBrands();
                if (vector != null && vector.size() > 0) {
                    TypeBrandRec typeBrandRec = null;
                    if (vector.size() > 1) {
                        Vector vector2 = new JListDlg((Frame)DocRec.getWindow(), Str.getStr(1581), vector).getResult();
                        if (vector2 != null && vector2.size() > 0) {
                            typeBrandRec = (TypeBrandRec)vector2.elementAt(0);
                        }
                    } else {
                        typeBrandRec = (TypeBrandRec)vector.elementAt(0);
                    }
                    if (typeBrandRec != null) {
                        this.owner = UserSystem.getBrandProgramManager(typeBrandRec.getInd());
                    }
                    bl = this.owner != null;
                }
            } else {
                Vector vector = new SelectUserDlg((Frame)DocRec.getWindow(), false).getResult();
                if (vector != null && vector.size() > 0) {
                    this.owner = ((UserRec)vector.elementAt(0)).getUserId();
                    bl = true;
                }
            }
        } else {
            bl = true;
        }
        return bl;
    }

    private String getCacheName() {
        String string = "DOC";
        string = this.isDocRequest() ? string + "DRAFT_" + this.docInd : string + "_" + this.existingDocInd;
        return string;
    }

    private String getLastUpdateFromDatabase() {
        SQLMethod sQLMethod = new SQLMethod(1, "getLastUpdateFromDatabase", 5);
        String string = "";
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = null;
            String string2 = "SELECT CHANGEDTIME FROM ";
            string2 = this.isDocRequest() ? string2 + "QUEST.DOCUMENTS " : string2 + "TIGRIS.DOCUMENTS ";
            string2 = string2 + " WHERE DOCIND = ";
            string2 = this.isDocRequest() ? string2 + "" + this.docInd : string2 + "" + this.existingDocInd;
            string2 = string2 + " FOR FETCH ONLY";
            resultSet = statement.executeQuery(string2);
            if (resultSet.next()) {
                string = resultSet.getString(1).trim();
            }
            resultSet.close();
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception, false);
        }
        sQLMethod.close();
        return string;
    }

    public boolean getSetForEdit() {
        return this.setForEdit;
    }

    public void setSaveInfo(DocSavingPanel docSavingPanel) {
        this.savePanel = docSavingPanel;
    }

    private DocSavingPanel getSavePanel() {
        return this.savePanel;
    }

    private boolean showClassMessage(int n, int n2) {
        SQLMethod sQLMethod = new SQLMethod(1, "docRec.showClassMessage", 5);
        boolean bl = false;
        if (n2 != 0) {
            try {
                int n3;
                Statement statement = sQLMethod.createStatement();
                ResultSet resultSet = statement.executeQuery("SELECT DOCCLASSIND FROM TIGRIS.DOCUMENTS WHERE DOCIND = " + n2);
                if (resultSet.next() && (n3 = resultSet.getInt(1)) == 3 && n != 3) {
                    bl = true;
                }
                resultSet.close();
            }
            catch (Exception exception) {
                LogSystem.log(1, exception, false);
                sQLMethod.rollBack();
            }
        }
        LogSystem.log(1, "ShowClassMessage Returning:" + bl);
        sQLMethod.close();
        return bl;
    }

    public DocRec() {
        this.init();
    }

    public DocRec(int n) {
        this.docTypeRec = (TypeDocRec)TypeList.getInstance().objectFromInd(n, 4);
        this.init();
    }

    public DocRec(DocRec docRec) {
        this.setData(docRec);
        this.init();
    }

    public DocRec(Bookmark bookmark) {
        if (bookmark.getBookmarkType() != 3) {
            throw new IllegalArgumentException("Cannot create document from non-document bookmark");
        }
        this.existingDocInd = (Integer)bookmark.getObject();
        this.readPreviewInfo();
    }
}

