/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.doc.docedit;

import com.ibm.nzna.projects.common.quest.Constants;
import com.ibm.nzna.projects.common.quest.doc.Document;
import com.ibm.nzna.projects.common.quest.doc.DocumentDraft;
import com.ibm.nzna.projects.common.quest.doc.DocumentFile;
import com.ibm.nzna.projects.common.quest.doc.DocumentGraphic;
import com.ibm.nzna.projects.common.quest.type.TypeCategoryRec;
import com.ibm.nzna.projects.common.storedProc.sqlRunner.SqlRunner;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.MainWindow;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserRec;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.app.util.QuestUtil;
import com.ibm.nzna.projects.qit.doc.DocConst;
import com.ibm.nzna.projects.qit.doc.docedit.DocSaveStatusPanel;
import com.ibm.nzna.projects.qit.gui.SelectUserDlg;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.ftp.FTP.Ftp;
import com.ibm.nzna.shared.gui.JListDlg;
import com.ibm.nzna.shared.util.CDate;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.WinUtil;
import java.awt.Frame;
import java.io.File;
import java.io.FileOutputStream;
import java.sql.ResultSet;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class DocumentSaver
implements AppConst,
DocConst {
    public static boolean saveDraft(DocumentDraft documentDraft, DocSaveStatusPanel docSaveStatusPanel) {
        boolean bl = false;
        bl = docSaveStatusPanel != null ? DocumentSaver.validateOwner(documentDraft, WinUtil.getParentJDialog(docSaveStatusPanel), null) : DocumentSaver.validateOwner(documentDraft, null, MainWindow.getInstance());
        if (documentDraft.getGraphics() != null && documentDraft.getGraphics().size() > 0) {
            if (bl) {
                if (docSaveStatusPanel != null) {
                    docSaveStatusPanel.enableGraphicsLabel(true);
                    docSaveStatusPanel.setGraphicsSelected(true);
                }
                bl = DocumentSaver.saveDraftGraphics(documentDraft.getGraphics(), docSaveStatusPanel);
            }
        } else {
            bl = true;
        }
        if (bl && documentDraft.getFileAttachments() != null && documentDraft.getFileAttachments().size() > 0) {
            if (docSaveStatusPanel != null) {
                docSaveStatusPanel.enableFilesLabel(true);
                docSaveStatusPanel.setFilesSelected(true);
            }
            bl = DocumentSaver.saveDraftFiles(documentDraft.getFileAttachments(), docSaveStatusPanel);
        } else {
            bl = true;
        }
        if (bl) {
            int n = 0;
            if (docSaveStatusPanel != null) {
                docSaveStatusPanel.enableDocumentsLabel(true);
                docSaveStatusPanel.setDocumentsSelected(true);
                docSaveStatusPanel.setText("Saving Document Draft");
            }
            documentDraft.setLastTouchedBy(UserSystem.getUserId());
            n = documentDraft.writeToDatabase();
            switch (n) {
                case 0: {
                    bl = true;
                    documentDraft.updateRecStatus(0);
                    break;
                }
                default: {
                    LogSystem.log(1, "Cannot write document. SQLCode returned:" + n);
                    bl = false;
                    break;
                }
            }
        }
        if (bl) {
            // empty if block
        }
        return bl;
    }

    private static boolean validateOwner(DocumentDraft documentDraft, JDialog jDialog, JFrame jFrame) {
        boolean bl = false;
        String string = documentDraft.getOwner();
        if (string == null || string.length() == 0) {
            Vector vector = null;
            Vector vector2 = documentDraft.getApplicableBrands();
            Vector vector3 = documentDraft.getBrands();
            vector = vector2 != null && vector2.size() > 0 ? vector2 : vector3;
            if (vector != null) {
                TypeCategoryRec typeCategoryRec = null;
                if (vector.size() > 1) {
                    Vector vector4 = null;
                    vector4 = jDialog != null ? new JListDlg(jDialog, Str.getStr(11064), vector).getResult() : new JListDlg((Frame)jFrame, Str.getStr(11064), vector).getResult();
                    if (vector4 != null && vector4.size() > 0) {
                        typeCategoryRec = (TypeCategoryRec)vector4.elementAt(0);
                    }
                } else {
                    typeCategoryRec = (TypeCategoryRec)vector.elementAt(0);
                }
                if (typeCategoryRec != null) {
                    string = UserSystem.getBrandProgramManager(typeCategoryRec.getInd());
                }
                bl = string != null;
            } else {
                Vector vector5 = null;
                vector5 = jDialog != null ? new SelectUserDlg(jDialog, false).getResult() : new SelectUserDlg((Frame)jFrame, false).getResult();
                if (vector5 != null && vector5.size() > 0) {
                    string = ((UserRec)vector5.elementAt(0)).getUserId();
                    bl = true;
                }
            }
        } else {
            bl = true;
        }
        if (bl) {
            documentDraft.setOwner(string);
        }
        return bl;
    }

    public static boolean publishDraft(DocumentDraft documentDraft, DocSaveStatusPanel docSaveStatusPanel) {
        boolean bl = false;
        Document document = new Document();
        documentDraft.setStopDate(new CDate(2).today());
        bl = DocumentSaver.saveDraft(documentDraft, docSaveStatusPanel);
        if (bl) {
            document.initializeProperties(documentDraft);
            document.updateRecStatus(0);
            if (documentDraft.getWorkRequired() == 2) {
                document.updateRecStatus(1);
            } else if (documentDraft.getWorkRequired() == 1) {
                document.updateRecStatus(2);
            } else if (documentDraft.getWorkRequired() == 3) {
                document.updateRecStatus(3);
            }
            bl = false;
            if (documentDraft.getGraphics() != null && documentDraft.getGraphics().size() > 0) {
                if (docSaveStatusPanel != null) {
                    docSaveStatusPanel.enableGraphicsLabel(true);
                    docSaveStatusPanel.setGraphicsSelected(true);
                    bl = DocumentSaver.syncGraphics(documentDraft, docSaveStatusPanel);
                    if (bl) {
                        bl = DocumentSaver.savePublishGraphics(documentDraft.getGraphics(), docSaveStatusPanel);
                    }
                    if (bl) {
                        DocumentSaver.removeDraftGraphics(documentDraft.getGraphics(), docSaveStatusPanel);
                    }
                }
            } else {
                bl = true;
            }
            if (bl) {
                if (documentDraft.getFileAttachments() != null && documentDraft.getFileAttachments().size() > 0) {
                    if (docSaveStatusPanel != null) {
                        docSaveStatusPanel.enableFilesLabel(true);
                        docSaveStatusPanel.setFilesSelected(true);
                    }
                    bl = DocumentSaver.savePublishFiles(documentDraft, documentDraft.getFileAttachments(), docSaveStatusPanel);
                } else {
                    bl = true;
                }
            }
            if (bl) {
                int n = 0;
                if (docSaveStatusPanel != null) {
                    docSaveStatusPanel.enableDocumentsLabel(true);
                    docSaveStatusPanel.setDocumentsSelected(true);
                    docSaveStatusPanel.setText("Publishing Document Draft");
                }
                document.setLastTouchedBy(UserSystem.getUserId());
                n = document.writeToDatabase();
                switch (n) {
                    case 0: {
                        bl = true;
                        break;
                    }
                    default: {
                        LogSystem.log(1, "Cannot write document. SQLCode returned:" + n);
                        bl = false;
                        break;
                    }
                }
            }
            if (!bl) {
                if (docSaveStatusPanel != null) {
                    docSaveStatusPanel.setText("Opening old draft");
                }
                documentDraft.setStopDate(null);
                documentDraft.writeToDatabase();
            } else {
                if (docSaveStatusPanel != null) {
                    docSaveStatusPanel.setText("Cleaning Draft Servers for Graphics/Files that might be left");
                }
                DocumentSaver.cleanTempFTP(document);
            }
        }
        return bl;
    }

    private static boolean saveDraftGraphics(Vector vector, DocSaveStatusPanel docSaveStatusPanel) {
        boolean bl = false;
        int n = 0;
        int n2 = vector.size();
        Ftp ftp = new Ftp();
        String string = Constants.getStrConst("IT_IMAGEHOSTTEMP");
        String string2 = Constants.getStrConst("IT_IMAGELOCTEMP");
        String string3 = PropertySystem.getString(30);
        ftp.setHost(string);
        ftp.setUser("quest");
        ftp.setPassword("hgra2l");
        LogSystem.beginLogSection("Saving Graphics");
        LogSystem.log(1, "FTP Server:" + string);
        LogSystem.log(1, "User Id:quest");
        LogSystem.log(1, "Directory:" + string2);
        try {
            DocumentGraphic documentGraphic = null;
            docSaveStatusPanel.setText("Connecting to Draft Graphics Server");
            ftp.connect();
            ftp.login();
            ftp.cd(string2);
            ftp.setType('I');
            while (n < n2) {
                documentGraphic = (DocumentGraphic)vector.elementAt(n);
                if (documentGraphic.getRecStatus() == 3) {
                    docSaveStatusPanel.setText("Deleting Graphic " + documentGraphic.getFilename());
                    LogSystem.log(1, "Deleting Graphic: " + documentGraphic.getFilename());
                    try {
                        ftp.delete(documentGraphic.getFilename());
                    }
                    catch (Exception exception) {}
                } else {
                    docSaveStatusPanel.setText("Saving Graphic " + documentGraphic.getFilename());
                    LogSystem.log(1, "FTPing Graphic: " + documentGraphic.getFilename());
                    ftp.put(string3 + File.separator + documentGraphic.getFilename());
                }
                ++n;
            }
            ftp.disconnect();
            bl = true;
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            GUISystem.printBox("Info", "Cannot save graphics");
        }
        LogSystem.endLogSection();
        return bl;
    }

    private static boolean savePublishGraphics(Vector vector, DocSaveStatusPanel docSaveStatusPanel) {
        boolean bl = false;
        int n = 0;
        int n2 = vector.size();
        Ftp ftp = new Ftp();
        String string = Constants.getStrConst("IT_IMAGEHOST");
        String string2 = Constants.getStrConst("IT_IMAGELOC");
        String string3 = PropertySystem.getString(30);
        ftp.setHost(string);
        ftp.setUser("quest");
        ftp.setPassword("hgra2l");
        LogSystem.beginLogSection("Publishing Graphics");
        LogSystem.log(1, "FTP Server:" + string);
        LogSystem.log(1, "User Id:quest");
        LogSystem.log(1, "Directory:" + string2);
        try {
            DocumentGraphic documentGraphic = null;
            docSaveStatusPanel.setText("Connecting to Graphics Server");
            ftp.connect();
            ftp.login();
            ftp.cd(string2);
            ftp.setType('I');
            while (n < n2) {
                documentGraphic = (DocumentGraphic)vector.elementAt(n);
                if (!documentGraphic.valid()) {
                    docSaveStatusPanel.setText("Deleting Graphic " + documentGraphic.getFilename());
                    LogSystem.log(1, "Deleting Graphic: " + documentGraphic.getFilename());
                    try {
                        ftp.delete(documentGraphic.getFilename());
                    }
                    catch (Exception exception) {}
                } else {
                    docSaveStatusPanel.setText("Saving Graphic " + documentGraphic.getFilename());
                    LogSystem.log(1, "FTPing Graphic: " + documentGraphic.getFilename());
                    ftp.put(string3 + File.separator + documentGraphic.getFilename());
                }
                ++n;
            }
            ftp.disconnect();
            bl = true;
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            GUISystem.printBox("Info", "Cannot save graphics");
        }
        LogSystem.endLogSection();
        return bl;
    }

    private static boolean removeDraftGraphics(Vector vector, DocSaveStatusPanel docSaveStatusPanel) {
        boolean bl = false;
        int n = 0;
        int n2 = vector.size();
        Ftp ftp = new Ftp();
        String string = Constants.getStrConst("IT_IMAGEHOSTTEMP");
        String string2 = Constants.getStrConst("IT_IMAGELOCTEMP");
        String string3 = PropertySystem.getString(30);
        ftp.setHost(string);
        ftp.setUser("quest");
        ftp.setPassword("hgra2l");
        LogSystem.beginLogSection("Publishing Graphics");
        LogSystem.log(1, "FTP Server:" + string);
        LogSystem.log(1, "User Id:quest");
        LogSystem.log(1, "Directory:" + string2);
        try {
            DocumentGraphic documentGraphic = null;
            docSaveStatusPanel.setText("Connecting to Draft Graphics Server");
            ftp.connect();
            ftp.login();
            ftp.cd(string2);
            ftp.setType('I');
            while (n < n2) {
                documentGraphic = (DocumentGraphic)vector.elementAt(n);
                docSaveStatusPanel.setText("Deleting Draft Graphic " + documentGraphic.getFilename());
                LogSystem.log(1, "Deleting Graphic: " + documentGraphic.getFilename());
                try {
                    ftp.delete(documentGraphic.getFilename());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n;
            }
            ftp.disconnect();
            bl = true;
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
        }
        LogSystem.endLogSection();
        return bl;
    }

    private static boolean syncGraphics(DocumentDraft documentDraft, DocSaveStatusPanel docSaveStatusPanel) {
        DocumentGraphic documentGraphic;
        Object object;
        SQLMethod sQLMethod = new SQLMethod(1, "syncGraphics", 5);
        boolean bl = false;
        Vector<DocumentGraphic> vector = new Vector<DocumentGraphic>(1, 1);
        try {
            object = sQLMethod.createStatement();
            ResultSet resultSet = null;
            String string = null;
            string = "SELECT FILENAME " + "FROM TIGNEW.GRAPHICS  " + "WHERE DOCIND = " + documentDraft.getExistingDocInd() + " " + "FOR FETCH ONLY";
            resultSet = object.executeQuery(string);
            while (resultSet.next()) {
                documentGraphic = new DocumentGraphic(documentDraft.getDocInd(), resultSet.getString(1).trim());
                vector.addElement(documentGraphic);
            }
            resultSet.close();
            object.close();
            bl = true;
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
        }
        if (bl) {
            object = documentDraft.getGraphics();
            int n = 0;
            int n2 = vector.size();
            documentGraphic = null;
            while (n < n2) {
                documentGraphic = (DocumentGraphic)vector.elementAt(n);
                if (!((Vector)object).contains(documentGraphic)) {
                    documentGraphic.updateRecStatus(0);
                    documentGraphic.updateRecStatus(3);
                    ((Vector)object).addElement(documentGraphic);
                }
                ++n;
            }
            documentDraft.setGraphics((Vector)object);
        }
        sQLMethod.close();
        return bl;
    }

    private static boolean syncFiles(DocumentDraft documentDraft, DocSaveStatusPanel docSaveStatusPanel) {
        DocumentFile documentFile;
        Object object;
        SQLMethod sQLMethod = new SQLMethod(1, "syncFiles", 5);
        boolean bl = false;
        Vector<DocumentFile> vector = new Vector<DocumentFile>(1, 1);
        try {
            object = sQLMethod.createStatement();
            ResultSet resultSet = null;
            String string = null;
            string = "SELECT FILENAME " + "FROM TIGRIS.DOCFILES  " + "WHERE DOCIND = " + documentDraft.getExistingDocInd() + " " + "FOR FETCH ONLY";
            resultSet = object.executeQuery(string);
            while (resultSet.next()) {
                documentFile = new DocumentFile(documentDraft.getDocInd(), resultSet.getString(1).trim());
                vector.addElement(documentFile);
            }
            resultSet.close();
            object.close();
            bl = true;
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
        }
        if (bl) {
            object = documentDraft.getFileAttachments();
            int n = 0;
            int n2 = vector.size();
            documentFile = null;
            while (n < n2) {
                documentFile = (DocumentFile)vector.elementAt(n);
                if (!((Vector)object).contains(documentFile)) {
                    documentFile.updateRecStatus(0);
                    documentFile.updateRecStatus(3);
                    ((Vector)object).addElement(documentFile);
                }
                ++n;
            }
            documentDraft.setFileAttachments((Vector)object);
        }
        sQLMethod.close();
        return bl;
    }

    private static boolean saveDraftFiles(Vector vector, DocSaveStatusPanel docSaveStatusPanel) {
        boolean bl = false;
        int n = 0;
        int n2 = vector.size();
        Ftp ftp = new Ftp();
        String string = Constants.getStrConst("IT_FILEHOSTTEMP");
        String string2 = Constants.getStrConst("IT_FILELOCTEMP");
        String string3 = PropertySystem.getString(30);
        ftp.setHost(string);
        ftp.setUser("quest");
        ftp.setPassword("hgra2l");
        LogSystem.beginLogSection("Saving Files");
        LogSystem.log(1, "FTP Server:" + string);
        LogSystem.log(1, "User Id:quest");
        LogSystem.log(1, "Directory:" + string2);
        try {
            DocumentFile documentFile = null;
            if (docSaveStatusPanel != null) {
                docSaveStatusPanel.setText("Connecting to Draft File Server");
            }
            ftp.connect();
            ftp.login();
            ftp.cd(string2);
            while (n < n2) {
                documentFile = (DocumentFile)vector.elementAt(n);
                if (documentFile.getLocalFilename() != null) {
                    if (documentFile.getRecStatus() == 3) {
                        if (docSaveStatusPanel != null) {
                            docSaveStatusPanel.setText("Deleting File " + documentFile.getLocalFilename());
                        }
                        LogSystem.log(1, "Deleting File: " + documentFile.getLocalFilename());
                        try {
                            ftp.delete(documentFile.getLocalFilename());
                        }
                        catch (Exception exception) {}
                    } else {
                        if (docSaveStatusPanel != null) {
                            docSaveStatusPanel.setText("Saving File " + documentFile.getLocalFilename());
                        }
                        LogSystem.log(1, "FTPing File: " + documentFile.getLocalFilename());
                        ftp.setType(documentFile.getFTPMode() == 0 ? (char)'I' : 'A');
                        ftp.put(documentFile.getLocalFilename());
                    }
                }
                ++n;
            }
            ftp.disconnect();
            bl = true;
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            GUISystem.printBox("Info", "Cannot save files");
        }
        LogSystem.endLogSection();
        return bl;
    }

    private static boolean savePublishFiles(DocumentDraft documentDraft, Vector vector, DocSaveStatusPanel docSaveStatusPanel) {
        Ftp ftp = null;
        Vector<DocumentFile> vector2 = new Vector<DocumentFile>(1);
        int n = 0;
        int n2 = vector.size();
        boolean bl = false;
        String string = Constants.getStrConst("IT_FILELOCTEMP");
        DocumentFile documentFile = null;
        String string2 = PropertySystem.getString(30);
        String string3 = Constants.getStrConst("IT_FILELOC");
        if (docSaveStatusPanel != null) {
            docSaveStatusPanel.setText("Connecting to Draft File Server");
        }
        ftp = QuestUtil.connectToTempFileFTP();
        try {
            if (docSaveStatusPanel != null) {
                docSaveStatusPanel.setText("Downloading changed files");
            }
            if (ftp != null) {
                ftp.cd(string);
                while (n < n2) {
                    documentFile = (DocumentFile)vector.elementAt(n);
                    if (documentFile.valid()) {
                        if (documentFile.getLocalFilename() != null) {
                            vector2.addElement(documentFile);
                        } else {
                            try {
                                if (docSaveStatusPanel != null) {
                                    docSaveStatusPanel.setText("Downloading " + documentFile.getFilename() + "(" + documentFile.getSize() + " bytes) from Draft File Server");
                                }
                                ftp.setType(documentFile.getFTPMode() == 0 ? (char)'I' : 'A');
                                ftp.get(documentFile.getFilename(), string2 + File.separator + documentFile.getFilename());
                                vector2.addElement(documentFile);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    ++n;
                }
                ftp.disconnect();
            }
            if (DocumentSaver.syncFiles(documentDraft, docSaveStatusPanel)) {
                vector = documentDraft.getFileAttachments();
                if (vector != null && vector.size() > 0) {
                    int n3 = vector.size();
                    n = 0;
                    while (n < n3) {
                        if (!vector2.contains(vector.elementAt(n))) {
                            vector2.addElement((DocumentFile)vector.elementAt(n));
                        } else {
                            ((DocumentFile)vector2.elementAt(n)).updateRecStatus(0);
                            ((DocumentFile)vector2.elementAt(n)).updateRecStatus(((DocumentFile)vector.elementAt(n)).getRecStatus());
                        }
                        ++n;
                    }
                }
                n = 0;
                n2 = vector2.size();
                if (docSaveStatusPanel != null) {
                    docSaveStatusPanel.setText("Connecting to Publish File Server");
                }
                ftp = QuestUtil.connectToProductionFileFTP();
                try {
                    ftp.cd(string3);
                    while (n < n2) {
                        documentFile = (DocumentFile)vector2.elementAt(n);
                        if (DocumentSaver.createFileHeader(documentFile)) {
                            ftp.setType('I');
                            if (docSaveStatusPanel != null) {
                                docSaveStatusPanel.setText("Attaching file " + documentFile.getFilename());
                            }
                            ftp.put(string2 + File.separator + documentFile.getFilename() + ".hdr");
                            if (documentFile.valid()) {
                                ftp.setType(documentFile.getFTPMode() == 0 ? (char)'I' : 'A');
                                ftp.put(string2 + File.separator + documentFile.getFilename());
                            }
                        } else {
                            return false;
                        }
                        ++n;
                    }
                    ftp.disconnect();
                    bl = true;
                }
                catch (Exception exception) {
                    LogSystem.log(1, exception, false);
                    GUISystem.printBox("Error", "Cannot publish file attachments. This document will not be published");
                }
            } else {
                bl = false;
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            GUISystem.printBox("Error", "Could not FTP file attachments. The Document will not be published");
        }
        return bl;
    }

    private static boolean createFileHeader(DocumentFile documentFile) {
        String string = PropertySystem.getString(30);
        File file = new File(string + File.separator + documentFile.getFilename() + ".hdr");
        boolean bl = false;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(new String("Filename: " + documentFile.getFilename() + "\n").getBytes());
            fileOutputStream.write(new String("filesize: " + documentFile.getSize() + "\n").getBytes());
            fileOutputStream.write(new String("filearea: " + documentFile.getLocation() + "\n").getBytes());
            fileOutputStream.write(new String("filetype: " + (documentFile.getFTPMode() == 0 ? "binary" : "ascii") + "\n").getBytes());
            if (documentFile.valid()) {
                fileOutputStream.write(new String("actiontype: insert\n").getBytes());
            } else {
                fileOutputStream.write(new String("actiontype: delete\n").getBytes());
            }
            fileOutputStream.flush();
            fileOutputStream.close();
            bl = true;
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            GUISystem.printBox("Error", "The header for file " + documentFile.getFilename() + " could not be created. Please make sure that you have enough Disk Space left for your temp directory");
        }
        return bl;
    }

    private static void cleanTempFTP(Document document) {
        int n;
        int n2;
        String string;
        Ftp ftp;
        Vector vector = document.getGraphics();
        Vector vector2 = document.getFileAttachments();
        if (vector != null && vector.size() > 0) {
            try {
                ftp = QuestUtil.connectToTempGraphicFTP();
                string = Constants.getStrConst("IT_IMAGELOCTEMP");
                if (ftp != null) {
                    n2 = 0;
                    n = vector.size();
                    ftp.cd(string);
                    while (n2 < n) {
                        try {
                            ftp.delete(((DocumentGraphic)vector.elementAt(n2)).getFilename());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++n2;
                    }
                }
                ftp.disconnect();
            }
            catch (Exception exception) {
                LogSystem.log(1, "Could not clean temp graphics");
            }
        }
        if (vector2 != null && vector2.size() > 0) {
            try {
                ftp = QuestUtil.connectToTempFileFTP();
                string = Constants.getStrConst("IT_FILELOCTEMP");
                if (ftp != null) {
                    n2 = 0;
                    n = vector2.size();
                    ftp.cd(string);
                    while (n2 < n) {
                        try {
                            ftp.delete(((DocumentFile)vector2.elementAt(n2)).getFilename());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++n2;
                    }
                }
                ftp.disconnect();
            }
            catch (Exception exception) {
                LogSystem.log(1, "Could not clean temp files");
            }
        }
    }

    public static boolean publishDraftNow(DocumentDraft documentDraft, DocSaveStatusPanel docSaveStatusPanel) {
        boolean bl = false;
        if (DocumentSaver.publishDraft(documentDraft, docSaveStatusPanel)) {
            String string = "DELETE FROM TIGRIS.PUBLISHNOW WHERE DOCIND = " + documentDraft.getExistingDocInd() + SqlRunner.END_DELIM + "INSERT INTO TIGRIS.PUBLISHNOW VALUES ( " + documentDraft.getExistingDocInd() + " )" + SqlRunner.END_DELIM;
            int n = SqlRunner.sqlRunnerCode(1, string);
            if (n != 0) {
                LogSystem.log(1, "Could not execute Publish now. rc:" + n);
                GUISystem.printBox(6, 202);
            } else {
                bl = true;
            }
        }
        return bl;
    }
}

