/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.doc.docedit;

import com.ibm.nzna.projects.common.quest.Counter;
import com.ibm.nzna.projects.common.quest.doc.DocumentBody;
import com.ibm.nzna.projects.common.quest.doc.DocumentDraft;
import com.ibm.nzna.projects.common.quest.doc.DocumentGraphic;
import com.ibm.nzna.projects.common.quest.doc.DocumentLink;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.DataLengths;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.MainWindow;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.doc.DocConst;
import com.ibm.nzna.projects.qit.doc.docedit.ExtBodyEditProcessListener;
import com.ibm.nzna.projects.qit.doc.docedit.ReimportDlg;
import com.ibm.nzna.projects.qit.gui.StatusWin;
import com.ibm.nzna.projects.qit.wordproc.WordProcUtil;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.util.FileUtil;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.Text;
import java.io.File;
import java.io.FileNotFoundException;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;

public class ExtBodyEditProcess
implements DataLengths,
DocConst,
AppConst,
Runnable {
    private String notCreatedByQIT = "<!-- Created by 3rd party editor, NOT QUEST INPUT -->";
    private DocumentDraft document = null;
    private String documentFile = null;
    private ExtBodyEditProcessListener listener = null;
    private boolean reimporting = false;
    private Process extProcess = null;

    public void run() {
        String[] stringArray = new String[2];
        try {
            String string = this.getDocumentBody();
            String string2 = null;
            this.document.generateKeys();
            this.documentFile = PropertySystem.getString(30) + File.separator + this.document.getDocInd() + ".html";
            FileUtil.saveFile(this.documentFile, string);
            stringArray[0] = PropertySystem.getString(45);
            stringArray[1] = this.documentFile;
            this.extProcess = Runtime.getRuntime().exec(stringArray);
            this.extProcess.waitFor();
            this.extProcess = null;
            try {
                string2 = FileUtil.readFile(this.documentFile);
                if (!string2.equals(string) && !this.reimporting && GUISystem.printBox(8, 11052)) {
                    this.reimportBody();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                GUISystem.printBox(6, 11051);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception exception) {
            GUISystem.printBox(7, 453);
        }
    }

    private String getDocumentBody() {
        String string = null;
        if (this.document.getDocumentType() == 9) {
            string = this.document.getAdditionalInfo();
        } else {
            DocumentBody documentBody = this.document.getDocumentBody();
            if (documentBody != null) {
                string = documentBody.getBody();
            }
        }
        if (string == null) {
            string = "<html><body>Erase Me<b>!</b></body></html>";
        }
        return string;
    }

    protected void reimportBody() {
        StatusWin statusWin;
        block16: {
            boolean bl = true;
            statusWin = new StatusWin(MainWindow.getInstance());
            this.reimporting = true;
            LogSystem.beginLogSection("Reimporting Body");
            try {
                String string = FileUtil.readFile(this.documentFile);
                LogSystem.log(1, "Reimporting Body from " + this.documentFile);
                if (string == null) break block16;
                String string2 = string.toUpperCase();
                statusWin.setVisible(true);
                try {
                    int n = this.document.getDocumentType();
                    statusWin.setText(Str.getStr(525));
                    if (string2.indexOf("/BODY") >= 0) {
                        string = string.substring(0, string2.indexOf("/BODY"));
                        string2 = string.toUpperCase();
                    }
                    if (string2.indexOf("<BODY") >= 0) {
                        string = string.substring(string2.indexOf("<BODY"), string.length());
                        string2 = string.toUpperCase();
                    }
                    string = Text.replaceAllStrInStr(string, this.notCreatedByQIT, "");
                    string = this.notCreatedByQIT + string;
                    string2 = string.toUpperCase();
                    LogSystem.log(1, "Parsing Document Links");
                    statusWin.setText("Parsing Doc Links");
                    this.reimportDocLinks(string2, statusWin);
                    statusWin.setText("Parsing Graphics");
                    LogSystem.log(1, "Parsing Graphics");
                    string = this.reimportGraphics(string2, string);
                    LogSystem.log(1, "Setting Field Data");
                    if (n != 9) {
                        this.document.setDocumentBody(new DocumentBody(string));
                    } else if (string.length() < 32000) {
                        this.document.setAdditionalInfo(string);
                    } else {
                        GUISystem.printBox(Str.getStr(7), Str.getStr(1618) + " " + string.length() + " " + Str.getStr(1619));
                        bl = false;
                    }
                }
                catch (Exception exception) {
                    LogSystem.log(1, exception);
                }
                LogSystem.log(1, "Disposing");
                if (PropertySystem.getBool(53) && this.extProcess != null) {
                    this.extProcess.destroy();
                    this.extProcess = null;
                }
                LogSystem.log(1, "Import Complete");
                statusWin.dispose();
                try {
                    if (bl) {
                        new ReimportDlg(MainWindow.getInstance(), this.document.getGraphics(), this.document.getDocumentLinks());
                        if (this.listener != null) {
                            this.listener.bodyReimportComplete();
                        }
                    }
                }
                catch (Exception exception) {
                    LogSystem.log(1, exception, false);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                GUISystem.printBox(6, 11051);
            }
            catch (Exception exception) {
                LogSystem.log(1, exception);
                GUISystem.printBox(6, 202);
            }
        }
        statusWin.dispose();
        LogSystem.endLogSection();
        this.reimporting = false;
    }

    private void reimportDocLinks(String string, StatusWin statusWin) {
        int n = 0;
        String string2 = null;
        Vector<DocumentLink> vector = new Vector<DocumentLink>(1, 1);
        DocumentLink documentLink = null;
        while (n >= 0) {
            if ((n = string.indexOf("<A HREF", n)) >= 0) {
                string2 = string.substring(n, string.indexOf("</A>", n));
                if (string2 != null && string2.indexOf(".HTML") >= 0) {
                    string2 = string2.substring(string2.indexOf("=") + 1);
                    string2 = string2.substring(0, string2.indexOf(".HTML"));
                    if ((string2 = Text.replaceAllStrInStr(string2, "\"", "")).indexOf("./") >= 0) {
                        string2 = Text.replaceAllStrInStr(string2, "./", "");
                    }
                    if ((string2 = string2.trim()).length() > 4 && string2.length() <= 11) {
                        statusWin.setText(Str.getStr(142) + " " + string2);
                        documentLink = this.findDocForLink(string2);
                        if (documentLink != null && !vector.contains(documentLink)) {
                            vector.addElement(documentLink);
                        }
                    }
                }
                ++n;
            }
            this.document.setDocumentLinks(vector);
        }
    }

    private String reimportGraphics(String string, String string2) {
        int n = 0;
        String string3 = null;
        Vector<DocumentGraphic> vector = this.document.getGraphics();
        DocumentGraphic documentGraphic = null;
        String string4 = PropertySystem.getString(30) + File.separator;
        int n2 = 0;
        if (vector != null) {
            int n3 = 0;
            int n4 = vector.size();
            while (n3 < n4) {
                ((DocumentGraphic)vector.elementAt(n3)).updateRecStatus(0);
                ((DocumentGraphic)vector.elementAt(n3)).updateRecStatus(3);
                ++n3;
            }
        } else {
            vector = new Vector<DocumentGraphic>(1);
        }
        while (n >= 0) {
            n2 = n;
            if (((n = string.indexOf("<IMG SRC", n)) > string.indexOf("<EMBED SRC", n2) || n < 0) && string.indexOf("<EMBED SRC", n2) >= 0) {
                n = string.indexOf("<EMBED SRC", n2);
            }
            if (n < 0) continue;
            string3 = string2.substring(n, string2.indexOf(">", n));
            if (string3 != null) {
                string3 = string3.substring(string3.indexOf("=\"") + 2);
                string3 = string3.substring(0, string3.indexOf("\""));
                if ((string3 = Text.replaceAllStrInStr(string3, "\"", "")).length() > 0 && string3.indexOf("###IMAGELOC###") == -1) {
                    if (string3.startsWith("./")) {
                        string3 = string3.substring(2);
                    }
                    if (WordProcUtil.notStampedGraphic(string3)) {
                        DocumentGraphic documentGraphic2;
                        block20: {
                            documentGraphic2 = this.getGraphic(vector, string3);
                            try {
                                if (string3.indexOf("/") >= 0) {
                                    string3 = string3.substring(string3.lastIndexOf("/") + 1, string3.length());
                                }
                                if (string3.indexOf("\\") >= 0) {
                                    string3 = string3.substring(string3.lastIndexOf("\\") + 1, string3.length());
                                }
                            }
                            catch (Exception exception) {
                                if (string3.indexOf("/") >= 0) {
                                    string3 = string3.substring(string3.lastIndexOf("/"), string3.length());
                                }
                                if (string3.indexOf("\\") < 0) break block20;
                                string3 = string3.substring(string3.lastIndexOf("\\"), string3.length());
                            }
                        }
                        FileUtil.rename(string4 + string3, string4 + string3.toLowerCase());
                        string2 = Text.replaceAllStrInStr(string2, string3, string3.toLowerCase());
                        string3 = string3.toLowerCase();
                        if (documentGraphic2 != null) {
                            documentGraphic2.updateRecStatus(0);
                            documentGraphic2.updateRecStatus(2);
                        } else if (!this.verifyGraphic(string3)) {
                            GUISystem.printBox(Str.getStr(7), Str.getStr(1608) + " " + string4 + string3);
                        } else if (string3.length() > 64) {
                            GUISystem.printBox(7, 560);
                        } else {
                            documentGraphic = new DocumentGraphic(Counter.getCounter(LogSystem.getInstance(), "GRAPHICIND"), string3);
                            vector.addElement(documentGraphic);
                            documentGraphic.updateRecStatus(0);
                            documentGraphic.updateRecStatus(2);
                        }
                    }
                }
            }
            ++n;
        }
        this.document.setGraphics(vector);
        return string2;
    }

    private DocumentLink findDocForLink(String string) {
        String string2 = "findDocForLink";
        SQLMethod sQLMethod = new SQLMethod(1, string2, 5);
        Statement statement = null;
        ResultSet resultSet = null;
        DocumentLink documentLink = null;
        try {
            statement = sQLMethod.createStatement();
            resultSet = statement.executeQuery("SELECT DOCIND, TITLE FROM TIGRIS.DOCUMENTS WHERE LNDOCID = '" + string + "' FOR FETCH ONLY");
            if (resultSet.next()) {
                documentLink = new DocumentLink(this.document.getDocInd(), resultSet.getInt(1), resultSet.getString(2));
            }
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
        }
        sQLMethod.close();
        return documentLink;
    }

    private DocumentGraphic getGraphic(Vector vector, String string) {
        DocumentGraphic documentGraphic = null;
        if (vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            while (documentGraphic == null && n < n2) {
                if (((DocumentGraphic)vector.elementAt(n)).getFilename().equals(string)) {
                    documentGraphic = (DocumentGraphic)vector.elementAt(n);
                }
                ++n;
            }
        }
        return documentGraphic;
    }

    private boolean verifyGraphic(String string) {
        String string2 = PropertySystem.getString(30) + File.separator;
        if (string.indexOf(")") >= 0 || string.indexOf(" ") >= 0 || string.indexOf("(") >= 0 || string.indexOf("*") >= 0 || string.indexOf("'") >= 0 || string.indexOf("!") >= 0 || string.indexOf("@") >= 0 || string.indexOf("$") >= 0 || string.indexOf("%") >= 0 || string.indexOf("^") >= 0 || string.indexOf("\"") >= 0) {
            GUISystem.printBox(Str.getStr(7), Str.getStr(1610) + ". Filename:" + string);
            return false;
        }
        return FileUtil.exists(string2 + string);
    }

    public void setExtBodyEditProcessListener(ExtBodyEditProcessListener extBodyEditProcessListener) {
        this.listener = extBodyEditProcessListener;
    }

    public ExtBodyEditProcess(DocumentDraft documentDraft) {
        this.document = documentDraft;
        new Thread(this).start();
    }
}

