/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.doc.docedit;

import com.ibm.nzna.projects.common.quest.doc.DocumentFile;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.DataLengths;
import com.ibm.nzna.projects.qit.app.FontSystem;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.doc.DocConst;
import com.ibm.nzna.shared.gui.ButtonPanel;
import com.ibm.nzna.shared.gui.DButton;
import com.ibm.nzna.shared.gui.MaskDocument;
import com.ibm.nzna.shared.gui.NoTabJTextArea;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.Text;
import com.ibm.nzna.shared.util.WinUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class FileAttachmentDlg
extends JDialog
implements ActionListener,
AppConst,
DocConst,
DataLengths {
    private DocumentFile documentFile = null;
    private JLabel st_FILENAME = new JLabel();
    private JLabel st_SIZE = new JLabel();
    private JLabel st_DESCRIPTION = new JLabel("*" + Str.getStr(100));
    private NoTabJTextArea mle_DESCRIPTION = new NoTabJTextArea(new MaskDocument(0, 254));
    private JLabel st_VERSION = new JLabel("*" + Str.getStr(294));
    private JTextField ef_VERSION = new JTextField(new MaskDocument(0, 25), "", 2);
    private JLabel st_LOCATION = new JLabel("*" + Str.getStr(437));
    private JComboBox cb_LOCATION = new JComboBox<String>(DocumentFile.getLocations());
    private JLabel st_URL = new JLabel("*" + Str.getStr(111));
    private JTextField ef_URL = new JTextField("");
    private DButton pb_OK = new DButton(Str.getStr(1));
    private JRadioButton rb_BINARY = new JRadioButton(Str.getStr(902));
    private JRadioButton rb_ASCII = new JRadioButton(Str.getStr(901));
    private ButtonGroup buttonGroup = new ButtonGroup();
    private JLabel st_FTPMODE = new JLabel(Str.getStr(11036));
    private DButton pb_FILE_REFRESH = new DButton(Str.getStr(11028));
    private DButton pb_CANCEL = new DButton(Str.getStr(2));
    private ButtonPanel buttonPanel = new ButtonPanel();

    private void createGUI() {
        Container container = this.getContentPane();
        this.mle_DESCRIPTION.setFont(this.pb_OK.getFont());
        this.mle_DESCRIPTION.setLineWrap(true);
        this.mle_DESCRIPTION.setWrapStyleWord(true);
        this.mle_DESCRIPTION.setBorder(GUISystem.loweredBorder);
        this.st_FILENAME.setFont(FontSystem.largeTitleFont);
        this.buttonGroup.add(this.rb_ASCII);
        this.buttonGroup.add(this.rb_BINARY);
        this.cb_LOCATION.addActionListener(this);
        this.pb_OK.addActionListener(this);
        this.pb_FILE_REFRESH.addActionListener(this);
        this.pb_CANCEL.addActionListener(this);
        this.ef_VERSION.addActionListener(this);
        this.ef_URL.addActionListener(this);
        container.setLayout(null);
        container.add(this.st_FILENAME);
        container.add(this.st_SIZE);
        container.add(this.st_DESCRIPTION);
        container.add(this.mle_DESCRIPTION);
        container.add(this.st_FTPMODE);
        container.add(this.rb_ASCII);
        container.add(this.rb_BINARY);
        container.add(this.st_VERSION);
        container.add(this.ef_VERSION);
        container.add(this.st_LOCATION);
        container.add(this.cb_LOCATION);
        container.add(this.st_URL);
        container.add(this.ef_URL);
        container.add(this.buttonPanel);
        this.buttonPanel.add(this.pb_OK);
        this.buttonPanel.add(this.pb_FILE_REFRESH);
        this.buttonPanel.add(this.pb_CANCEL);
        GUISystem.setPropertiesOnPanel(container);
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        int n = 5;
        int n2 = 5;
        int n3 = GUISystem.getRowHeight();
        super.doLayout();
        this.st_FILENAME.setBounds(n, n2, dimension.width - n * 4, n3 * 2);
        this.st_SIZE.setBounds(n, n2 += n3 * 2, dimension.width - n * 4, n3);
        this.st_DESCRIPTION.setBounds(n, n2 += n3 * 2, dimension.width - n * 4, n3);
        this.mle_DESCRIPTION.setBounds(n, n2 += n3, dimension.width - n * 4, n3 * 4);
        this.st_FTPMODE.setBounds(n, n2 += n3 * 4, dimension.width - n * 4, n3);
        this.rb_ASCII.setBounds(n, n2 += n3, dimension.width / 2 - n * 4, n3);
        this.rb_BINARY.setBounds(dimension.width / 2, n2, dimension.width / 2 - n * 4, n3);
        this.st_VERSION.setBounds(n, n2 += n3, dimension.width - n * 4, n3);
        this.ef_VERSION.setBounds(n, n2 += n3, dimension.width - n * 4, n3);
        this.st_LOCATION.setBounds(n, n2 += n3, dimension.width - n * 4, n3);
        this.cb_LOCATION.setBounds(n, n2 += n3, dimension.width - n * 4, n3);
        this.st_URL.setBounds(n, n2 += n3, dimension.width - n * 4, n3);
        this.ef_URL.setBounds(n, n2 += n3, dimension.width - n * 4, n3);
        n2 += n3;
        this.buttonPanel.setBounds(n, dimension.height - 55, dimension.width - n * 4, 25);
    }

    private void refreshData() {
        String string = PropertySystem.getString(162);
        if (string == null) {
            string = DocumentFile.getLocations()[0];
        }
        this.st_FILENAME.setText(this.documentFile.getFilename());
        this.st_SIZE.setText(this.documentFile.getSize() + " bytes");
        if (this.documentFile.getFilename().equals("txt")) {
            this.rb_ASCII.setSelected(true);
        } else {
            this.rb_BINARY.setSelected(true);
        }
        if (this.documentFile.getDescription() != null) {
            this.mle_DESCRIPTION.setText(this.documentFile.getDescription());
        }
        if (this.documentFile.getVersion() != null) {
            this.ef_VERSION.setText(this.documentFile.getVersion());
        }
        if (this.documentFile.getLocation() != null) {
            this.cb_LOCATION.setSelectedItem(this.documentFile.getLocation());
        } else {
            this.cb_LOCATION.setSelectedItem(string);
        }
        if (this.documentFile.getURL() != null) {
            this.ef_URL.setText(this.documentFile.getURL());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.cb_LOCATION) {
            String string = (String)this.cb_LOCATION.getSelectedItem();
            String string2 = "";
            string2 = string.indexOf("ate/thinkpad") >= 0 ? "ftp://thinkpad:ftp4tpad@ftp.pc.ibm.com/pub/" + string + "/" + this.documentFile.getFilename() : (string.indexOf("ate/network") >= 0 ? "ftp://network:n3tw0rk@ftp.pc.ibm.com/pub/" + string + "/" + this.documentFile.getFilename() : (string.indexOf("ate/options") >= 0 ? "ftp://options:opt10ns@ftp.pc.ibm.com/pub/" + string + "/" + this.documentFile.getFilename() : "ftp://ftp.pc.ibm.com/pub/" + string + "/" + this.documentFile.getFilename()));
            this.ef_URL.setText(string2);
        } else if (actionEvent.getSource() == this.pb_CANCEL) {
            this.dispose();
        } else if (actionEvent.getSource() == this.pb_OK || actionEvent.getSource() == this.ef_VERSION || actionEvent.getSource() == this.ef_URL) {
            if (this.saveData()) {
                this.dispose();
            }
        } else if (actionEvent.getSource() == this.pb_FILE_REFRESH && this.refreshFile()) {
            this.pb_CANCEL.setEnabled(false);
        }
    }

    private boolean saveData() {
        String string = this.mle_DESCRIPTION.getText();
        String string2 = this.ef_VERSION.getText();
        String string3 = (String)this.cb_LOCATION.getSelectedItem();
        String string4 = this.ef_URL.getText();
        boolean bl = false;
        if (string == null || string.length() == 0) {
            GUISystem.printBox((JDialog)this, 6, 11029);
            this.mle_DESCRIPTION.requestFocus();
        } else if (string2 == null || string2.length() == 0) {
            GUISystem.printBox((JDialog)this, 6, 11030);
            this.ef_VERSION.requestFocus();
        } else if (string4 == null || string4.length() == 0) {
            GUISystem.printBox((JDialog)this, 6, 11031);
            this.ef_URL.requestFocus();
        } else {
            this.documentFile.setURL(string4.trim());
            this.documentFile.setDescription(string.trim());
            this.documentFile.setVersion(string2.trim());
            this.documentFile.setLocation(string3);
            this.documentFile.setFTPMode(this.rb_BINARY.isSelected() ? 0 : 1);
            bl = true;
        }
        return bl;
    }

    private boolean refreshFile() {
        boolean bl = false;
        File[] fileArray = GUISystem.getFileOpen(GUISystem.getParentDefWin(this), Str.getStr(438), PropertySystem.getString(42));
        if (fileArray != null) {
            try {
                File file = new File(fileArray[0].toString());
                String string = Text.stripPath(fileArray[0].toString());
                PropertySystem.putString(42, fileArray[1].toString());
                if (!string.equals(this.documentFile.getFilename())) {
                    GUISystem.printBox(7, 11032);
                } else {
                    if (file.length() == this.documentFile.getSize()) {
                        GUISystem.printBox((JDialog)this, 7, 11033);
                    }
                    this.documentFile.setLocalFilename(file.toString());
                    this.documentFile.setSize(file.length());
                    bl = true;
                }
            }
            catch (Exception exception) {
                LogSystem.log(1, exception, false);
                GUISystem.printBox((JDialog)this, 6, 202);
            }
        }
        return bl;
    }

    public FileAttachmentDlg(Frame frame, DocumentFile documentFile) {
        super(frame, Str.getStr(438), true);
        this.documentFile = documentFile;
        this.createGUI();
        this.refreshData();
        this.setResizable(false);
        ((Component)this).setSize(400, 370);
        WinUtil.centerWindow(this);
        ((Component)this).setVisible(true);
    }
}

