/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.doc.docedit;

import com.ibm.nzna.projects.common.quest.Constants;
import com.ibm.nzna.projects.common.quest.doc.Document;
import com.ibm.nzna.projects.common.quest.doc.DocumentFile;
import com.ibm.nzna.projects.common.quest.doc.DocumentPropertyListener;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.Authority;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.app.util.QuestUtil;
import com.ibm.nzna.projects.qit.doc.DocConst;
import com.ibm.nzna.projects.qit.doc.docedit.FileAttachmentDlg;
import com.ibm.nzna.projects.qit.doc.gui.DocumentFileRenderer;
import com.ibm.nzna.projects.qit.gui.AppDefaultWin;
import com.ibm.nzna.projects.qit.gui.StatusWin;
import com.ibm.nzna.shared.ftp.FTP.Ftp;
import com.ibm.nzna.shared.gui.DButton;
import com.ibm.nzna.shared.gui.DList;
import com.ibm.nzna.shared.gui.DPanel;
import com.ibm.nzna.shared.gui.ListPanel;
import com.ibm.nzna.shared.gui.ValueLabel;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.Text;
import com.ibm.nzna.shared.util.WinUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FileAttachmentPanel
extends DPanel
implements DocumentPropertyListener,
ListSelectionListener,
Authority,
AppConst,
DocConst,
ActionListener {
    private DefaultListModel listModel = new DefaultListModel();
    private ListPanel buttonPanel = new ListPanel();
    private DList lb_FILES = new DList();
    private JScrollPane scr_FILES = new JScrollPane(this.lb_FILES);
    private JLabel st_VERSION = new JLabel();
    private JLabel st_LOCATION = new JLabel();
    private ValueLabel vl_VERSION = new ValueLabel(Str.getStr(294), this.st_VERSION);
    private ValueLabel vl_LOCATION = new ValueLabel(Str.getStr(437), this.st_LOCATION);
    private DButton pb_ADD = new DButton(Str.getStr(95));
    private DButton pb_EDIT = new DButton(Str.getStr(50));
    private DButton pb_REMOVE = new DButton(Str.getStr(96));
    private DButton pb_DOWNLOAD = new DButton(Str.getStr(917));
    private DButton pb_VERIFY = new DButton(Str.getStr(11026));
    private DButton pb_DEASSOC = new DButton(Str.getStr(11027));
    private DButton pb_UP = new DButton(Str.getStr(1044));
    private DButton pb_DOWN = new DButton(Str.getStr(1045));
    private DButton fillerButton = new DButton("");
    private Document document = null;

    public void doLayout() {
        Dimension dimension = this.getSize();
        int n = 0;
        int n2 = 0;
        int n3 = GUISystem.getRowHeight();
        super.doLayout();
        this.scr_FILES.setBounds(n, n2, dimension.width - 100, dimension.height - 40);
        this.buttonPanel.setBounds(dimension.width - 100, n2, 100, dimension.height - 40);
        n2 = dimension.height - 40;
        this.vl_VERSION.setBounds(n, n2, dimension.width - n * 2, n3);
        this.vl_LOCATION.setBounds(n, n2 += n3, dimension.width - n * 2, n3);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isEnabled()) {
            Object[] objectArray;
            if (actionEvent.getSource() == this.pb_EDIT || actionEvent.getSource() == this.lb_FILES) {
                new FileAttachmentDlg((Frame)GUISystem.getParentDefWin(this), (DocumentFile)this.lb_FILES.getSelectedValue());
                this.revalidate();
                this.refreshData();
                this.document.setFileAttachments(WinUtil.getListData(this.lb_FILES));
            } else if (actionEvent.getSource() == this.pb_ADD) {
                this.addFile();
            } else if (actionEvent.getSource() == this.pb_REMOVE) {
                Object[] objectArray2 = this.lb_FILES.getSelectedValues();
                if (objectArray2 != null && objectArray2.length > 0) {
                    int n = 0;
                    while (n < objectArray2.length) {
                        ((DocumentFile)objectArray2[n]).updateRecStatus(3);
                        ++n;
                    }
                    this.refreshList();
                }
            } else if (actionEvent.getSource() == this.pb_UP) {
                WinUtil.moveItemUp(this.lb_FILES);
                this.reorderFiles();
            } else if (actionEvent.getSource() == this.pb_DOWN) {
                WinUtil.moveItemDown(this.lb_FILES);
                this.reorderFiles();
            } else if (actionEvent.getSource() == this.pb_VERIFY) {
                this.verifyFile(this.lb_FILES.getSelectedValues());
            } else if (actionEvent.getSource() == this.pb_DOWNLOAD) {
                DocumentFile documentFile = (DocumentFile)this.lb_FILES.getSelectedValue();
                if (documentFile != null) {
                    this.downloadFiles(documentFile);
                }
            } else if (actionEvent.getSource() == this.pb_DEASSOC && GUISystem.printBox(8, 11041) && (objectArray = this.lb_FILES.getSelectedValues()) != null && objectArray.length > 0) {
                int n = 0;
                while (n < objectArray.length) {
                    ((DocumentFile)objectArray[n]).updateRecStatus(-100);
                    ++n;
                }
                this.refreshList();
            }
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.isEnabled()) {
            DocumentFile documentFile = (DocumentFile)this.lb_FILES.getSelectedValue();
            boolean bl = documentFile != null;
            this.pb_EDIT.setEnabled(bl);
            this.pb_REMOVE.setEnabled(bl);
            this.pb_DOWNLOAD.setEnabled(bl);
            this.pb_VERIFY.setEnabled(bl);
            this.pb_DEASSOC.setEnabled(bl && UserSystem.hasAuthority(5));
            this.pb_UP.setEnabled(bl);
            this.pb_DOWN.setEnabled(bl);
        }
        this.refreshData();
    }

    private void refreshData() {
        DocumentFile documentFile = (DocumentFile)this.lb_FILES.getSelectedValue();
        if (documentFile != null) {
            this.st_VERSION.setText(documentFile.getVersion());
            this.st_LOCATION.setText(documentFile.getLocation());
        } else {
            this.st_VERSION.setText("");
            this.st_LOCATION.setText("");
        }
    }

    public void setDocument(Document document) {
        if (this.document != null) {
            this.document.removeDocumentPropertyListener(this);
        }
        document.addDocumentPropertyListener(this);
        this.document = document;
        this.refreshList();
    }

    private void refreshList() {
        Vector vector = QuestUtil.getValidData(this.document.getFileAttachments());
        if (vector != null && vector.size() > 0 && vector.elementAt(0) != null && ((DocumentFile)vector.elementAt(0)).getOrderNum() == 0) {
            int n = 0;
            while (n < vector.size()) {
                ((DocumentFile)vector.elementAt(n)).setOrderNum(n + 1);
                ++n;
            }
        }
        if (vector != null) {
            WinUtil.setListData(vector, this.listModel);
        }
        this.valueChanged(null);
    }

    private void addFile() {
        File[] fileArray = GUISystem.getFileOpen(GUISystem.getParentDefWin(this), Str.getStr(438), PropertySystem.getString(42));
        if (fileArray != null) {
            try {
                File file = new File(fileArray[0].toString());
                String string = Text.stripPath(fileArray[0].toString().toLowerCase());
                DocumentFile documentFile = null;
                if (file.exists() && file.length() > 0L) {
                    Vector<DocumentFile> vector = new Vector<DocumentFile>();
                    file.renameTo(new File(fileArray[0].toString().toLowerCase()));
                    if (!this.fileAlreadyExists(string)) {
                        this.document.generateKeys();
                        documentFile = new DocumentFile(this.document.getDocInd(), string);
                        documentFile.setSize(file.length());
                        documentFile.setLocalFilename(fileArray[0].toString().toLowerCase());
                        documentFile.updateRecStatus(0);
                        documentFile.updateRecStatus(2);
                        new FileAttachmentDlg((Frame)GUISystem.getParentDefWin(this), documentFile);
                        if (documentFile.getDescription() != null) {
                            this.document.addFileAttachment(documentFile);
                            vector.addElement(documentFile);
                            this.refreshList();
                            WinUtil.selectItems((JList)this.lb_FILES, vector);
                        }
                    } else {
                        GUISystem.printBox(7, 11035);
                    }
                } else {
                    GUISystem.printBox(7, 11034);
                }
            }
            catch (Exception exception) {
                LogSystem.log(1, exception, false);
                GUISystem.printBox(6, 202);
            }
        }
    }

    private boolean fileAlreadyExists(String string) {
        boolean bl = false;
        Vector vector = this.document.getFileAttachments();
        if (vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            while (!bl && n < n2) {
                if (((DocumentFile)vector.elementAt(n)).getFilename().equals(string)) {
                    bl = true;
                }
                ++n;
            }
        }
        return bl;
    }

    private void verifyFile(Object[] objectArray) {
        Ftp ftp = null;
        StatusWin statusWin = new StatusWin(GUISystem.getParentDefWin(this));
        String string = "The following errors were found:<br><br>";
        boolean bl = false;
        String string2 = "/home/ftp/pub/pccbbs";
        statusWin.setVisible(true);
        statusWin.setMaxValue(objectArray.length);
        int n = 0;
        while (n < objectArray.length) {
            String[] stringArray;
            DocumentFile documentFile = (DocumentFile)objectArray[n];
            System.out.println("RecStatus:" + documentFile.getRecStatus());
            if (documentFile.getRecStatus() == 2) {
                stringArray = null;
                statusWin.setText(Str.getStr(11037));
                stringArray = new File(documentFile.getFilename());
                if (stringArray.exists()) {
                    if (stringArray.length() != documentFile.getSize()) {
                        bl = true;
                        string = string + "Local File " + stringArray.toString() + " has byte size of " + stringArray.length() + " while document file attachment has size of " + documentFile.getSize() + " bytes<br><br>";
                    }
                } else {
                    bl = true;
                    string = string + "Local File " + documentFile.getLocalFilename() + " could not be found";
                }
            } else {
                if (ftp == null) {
                    statusWin.setText("Logging into remote FTP");
                    ftp = QuestUtil.connectToProductionFileFTP();
                }
                if (ftp != null) {
                    statusWin.setText("Checking remote file: " + this.document.getFilename());
                    try {
                        ftp.cd(string2 + "/" + documentFile.getLocation());
                    }
                    catch (Exception exception) {
                        LogSystem.log(1, exception, false);
                        string = string + "Cannot change to FTP Directory " + string2 + "/" + documentFile.getLocation() + ". File " + documentFile.getFilename() + " cannot be verified<br><br>";
                        bl = true;
                    }
                    try {
                        long l;
                        stringArray = ftp.list(documentFile.getFilename());
                        if (stringArray != null && stringArray.length > 0 && (l = ftp.size(documentFile.getFilename())) != documentFile.getSize()) {
                            string = string + "The size of " + documentFile.getFilename() + " on the FTP site is " + l + " bytes while the size of the file attachment is " + documentFile.getSize() + " bytes";
                            bl = true;
                        }
                    }
                    catch (Exception exception) {
                        LogSystem.log(1, exception, false);
                        string = string + "Cannot find file " + documentFile.getFilename() + " on ftp site.<br><br>";
                        bl = true;
                    }
                } else {
                    n = objectArray.length + 1;
                    string = "Cannot log into FTP Site for verfication. Please try again later. No Files Verified";
                    bl = true;
                }
            }
            ++n;
        }
        try {
            if (ftp != null) {
                ftp.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        statusWin.dispose();
        if (bl) {
            GUISystem.printBox(Str.getStr(7), string);
        } else {
            GUISystem.printBox(7, 11040);
        }
    }

    private void downloadFiles(DocumentFile documentFile) {
        AppDefaultWin appDefaultWin = GUISystem.getParentDefWin(this);
        File[] fileArray = GUISystem.getFileOpen(GUISystem.getParentDefWin(this), Str.getStr(515), PropertySystem.getString(40), documentFile.getFilename(), false);
        if (fileArray != null && fileArray.length > 0) {
            String string = fileArray[0].toString();
            Ftp ftp = null;
            String string2 = Constants.getStrConst("IT_FILELOCTEMP");
            appDefaultWin.setStatus("Logging into Draft FTP Site");
            ftp = QuestUtil.connectToTempFileFTP();
            if (ftp != null) {
                try {
                    ftp.cd(string2);
                    appDefaultWin.setStatus(Str.getStr(323) + " " + documentFile.getFilename());
                    ftp.get(documentFile.getFilename(), string);
                    ftp.disconnect();
                    GUISystem.printBox(7, 905);
                }
                catch (Exception exception) {
                    LogSystem.log(1, exception, false);
                    GUISystem.printBox(7, 909);
                }
            } else {
                GUISystem.printBox(7, 906);
            }
        }
        appDefaultWin.setStatus(null);
    }

    private void downloadFileFromProduction(DocumentFile documentFile, String string) {
        AppDefaultWin appDefaultWin = GUISystem.getParentDefWin(this);
        Ftp ftp = null;
        appDefaultWin.setStatus("Logging into Production FTP Site");
        try {
            ftp = new Ftp();
            ftp.setHost("ftp.pc.ibm.com");
            ftp.setUser("anonymous");
            ftp.setPassword(UserSystem.getUserId() + "@qit.comd");
            ftp.connect();
            ftp.login();
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            GUISystem.printBox("Error", "Cannot log into production FTP Server. Make sure your machine is socksified");
        }
        if (ftp != null) {
            try {
                ftp.cd("/home/ftp/pub/pccbbs/" + documentFile.getLocation());
                appDefaultWin.setStatus(Str.getStr(323) + " " + documentFile.getFilename());
                ftp.get(documentFile.getFilename(), string);
                ftp.disconnect();
                GUISystem.printBox(7, 905);
            }
            catch (Exception exception) {
                if (exception.toString().indexOf("No such file") >= 0) {
                    this.downloadFileFromProduction(documentFile, string);
                }
                LogSystem.log(1, exception, false);
                GUISystem.printBox(7, 909);
            }
        } else {
            GUISystem.printBox(7, 906);
        }
        appDefaultWin.setStatus(null);
    }

    private void reorderFiles() {
        int n = 0;
        int n2 = this.listModel.size();
        while (n < n2) {
            ((DocumentFile)this.listModel.elementAt(n)).setOrderNum(n + 1);
            ++n;
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.valueChanged(null);
    }

    public void documentChanged(Document document, int n) {
        if (n == 7) {
            this.setDocument(document);
        }
    }

    public FileAttachmentPanel() {
        this.setBackground(Color.white);
        this.pb_EDIT.setEnabled(false);
        this.pb_REMOVE.setEnabled(false);
        this.pb_DOWNLOAD.setEnabled(false);
        this.pb_VERIFY.setEnabled(false);
        this.pb_DEASSOC.setEnabled(false);
        this.pb_UP.setEnabled(false);
        this.pb_DOWN.setEnabled(false);
        this.fillerButton.setEnabled(false);
        this.lb_FILES.setCellRenderer(new DocumentFileRenderer());
        this.lb_FILES.setModel(this.listModel);
        this.st_VERSION.setFont((Font)UIManager.getDefaults().get("Form.valueFont"));
        this.st_VERSION.setForeground((Color)UIManager.getDefaults().get("Form.valueForeground"));
        this.st_LOCATION.setFont((Font)UIManager.getDefaults().get("Form.valueFont"));
        this.st_LOCATION.setForeground((Color)UIManager.getDefaults().get("Form.valueForeground"));
        this.pb_EDIT.setEnabled(false);
        this.pb_REMOVE.setEnabled(false);
        this.pb_DOWNLOAD.setEnabled(false);
        this.pb_VERIFY.setEnabled(false);
        this.pb_DEASSOC.setEnabled(false);
        this.pb_UP.setEnabled(false);
        this.pb_DOWN.setEnabled(false);
        this.pb_ADD.addActionListener(this);
        this.pb_EDIT.addActionListener(this);
        this.pb_REMOVE.addActionListener(this);
        this.pb_DOWNLOAD.addActionListener(this);
        this.pb_VERIFY.addActionListener(this);
        this.pb_DEASSOC.addActionListener(this);
        this.pb_UP.addActionListener(this);
        this.pb_DOWN.addActionListener(this);
        this.lb_FILES.addListSelectionListener(this);
        this.lb_FILES.addActionListener(this);
        this.setPreferredSize(new Dimension(500, 240));
        this.setLayout(new BorderLayout());
        this.buttonPanel.add(this.pb_ADD);
        this.buttonPanel.add(this.pb_EDIT);
        this.buttonPanel.add(this.pb_REMOVE);
        this.buttonPanel.add(this.pb_DOWNLOAD);
        this.buttonPanel.add(this.pb_VERIFY);
        this.buttonPanel.add(this.pb_DEASSOC);
        this.buttonPanel.add(this.fillerButton);
        this.buttonPanel.add(this.pb_UP);
        this.buttonPanel.add(this.pb_DOWN);
        this.add(this.vl_VERSION);
        this.add(this.vl_LOCATION);
        this.add(this.buttonPanel);
        this.add(this.scr_FILES);
        this.buttonPanel.setPreferredSize(new Dimension(75, 200));
    }
}

