/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.doc.docedit;

import com.ibm.nzna.projects.common.quest.brand.Brands;
import com.ibm.nzna.projects.common.quest.doc.Document;
import com.ibm.nzna.projects.common.quest.type.TypeCategory;
import com.ibm.nzna.projects.common.quest.type.TypeCategoryRec;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.doc.DocConst;
import com.ibm.nzna.projects.qit.doc.docedit.ProductSelectDlg;
import com.ibm.nzna.shared.gui.DButton;
import com.ibm.nzna.shared.gui.DList;
import com.ibm.nzna.shared.sort.QuickSort;
import com.ibm.nzna.shared.util.StoreUtil;
import com.ibm.nzna.shared.util.WinUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ProductSelectBrandPanel
extends JPanel
implements ListSelectionListener,
AppConst,
DocConst,
ActionListener {
    private JLabel st_BRAND = new JLabel(Str.getStr(145));
    private JLabel st_ASSOC_FAMILY = new JLabel(Str.getStr(704));
    private JComboBox cb_BRAND = new JComboBox(Brands.getBrands());
    private DList lb_FAMILY = new DList();
    private JScrollPane scr_FAMILY = new JScrollPane(this.lb_FAMILY);
    private DList lb_ASSOC_FAMILY = new DList();
    private JScrollPane scr_ASSOC_FAMILY = new JScrollPane(this.lb_ASSOC_FAMILY);
    private DButton pb_DEASSOC = new DButton("<<--");
    private DButton pb_ASSOC = new DButton("-->>");
    private DButton pb_ASSOC_ALL = new DButton(">>>>");
    private Document document = null;
    private DefaultListModel familyDefaultModel = new DefaultListModel();
    private DefaultListModel assocFamilyDefaultModel = new DefaultListModel();
    private String allStr = "(" + Str.getStr(218) + ")";
    private ProductSelectDlg selectDlg = null;

    public void doLayout() {
        Dimension dimension = this.getSize();
        int n = dimension.width / 2;
        int n2 = 20;
        int n3 = 5;
        int n4 = 5;
        int n5 = GUISystem.getRowHeight();
        super.doLayout();
        this.st_BRAND.setBounds(n3, n4, n - 10 - n2, n5);
        this.st_ASSOC_FAMILY.setBounds(n + 5 + n2, n4, n - 10 - n2, n5);
        this.cb_BRAND.setBounds(n3, n4 += n5, n - 10 - n2, n5);
        this.scr_ASSOC_FAMILY.setBounds(n + 5 + n2, n4, n - 10 - n2, dimension.height - n4 - 5);
        this.scr_FAMILY.setBounds(n3, n4 += n5, n - 10 - n2, dimension.height - n4 - 5);
        n4 = n5 * 4;
        this.pb_DEASSOC.setBounds(n - n2, n4, n2 * 2, 25);
        this.pb_ASSOC.setBounds(n - n2, n4 += 30, n2 * 2, 25);
        this.pb_ASSOC_ALL.setBounds(n - n2, n4 += 30, n2 * 2, 25);
        n4 += 30;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.cb_BRAND) {
            this.lb_FAMILY.setListData(Brands.getFamilies((TypeCategoryRec)this.cb_BRAND.getSelectedItem()));
            PropertySystem.putInt(69, ((TypeCategoryRec)this.cb_BRAND.getSelectedItem()).getInd());
        } else if (actionEvent.getSource() == this.pb_ASSOC_ALL) {
            this.associateFamilyAll();
        } else if (actionEvent.getSource() == this.pb_ASSOC || actionEvent.getSource() == this.lb_FAMILY) {
            this.associateApplicableFamily();
        } else if (actionEvent.getSource() == this.pb_DEASSOC || actionEvent.getSource() == this.lb_ASSOC_FAMILY) {
            this.deassociateFamily();
        }
    }

    protected void setDocument(Document document) {
        this.document = document;
        this.clearData();
        this.selectInitialBrand();
        this.refreshData();
    }

    private void clearData() {
        Vector<String> vector = new Vector<String>(1);
        Vector<String> vector2 = new Vector<String>(1);
        vector.addElement(Str.getStr(11015));
        vector2.addElement(Str.getStr(11014));
        this.lb_FAMILY.setListData(vector);
        this.lb_ASSOC_FAMILY.setListData(vector2);
    }

    private void refreshData() {
        if (this.document != null) {
            int n;
            Vector<TypeCategoryRec> vector = new Vector<TypeCategoryRec>();
            Vector vector2 = null;
            Vector<TypeCategoryRec> vector3 = new Vector<TypeCategoryRec>();
            TypeCategoryRec typeCategoryRec = null;
            TypeCategoryRec typeCategoryRec2 = null;
            vector2 = this.document.getFamilies();
            if (vector2 != null && vector2.size() > 0) {
                int n2 = 0;
                n = vector2.size();
                while (n2 < n) {
                    typeCategoryRec = (TypeCategoryRec)vector2.elementAt(n2);
                    typeCategoryRec2 = TypeCategory.getCategory(typeCategoryRec.getParentCatInd());
                    if (!vector.contains(typeCategoryRec2)) {
                        vector.addElement(typeCategoryRec2);
                    }
                    if (!vector3.contains(typeCategoryRec)) {
                        vector3.addElement(typeCategoryRec);
                    }
                    typeCategoryRec.setToString(typeCategoryRec.getDescript() + " " + this.allStr);
                    ++n2;
                }
            } else {
                Vector<String> vector4 = new Vector<String>(1);
                vector4.addElement(Str.getStr(11014));
                this.lb_ASSOC_FAMILY.setListData(vector4);
            }
            vector2 = this.document.getApplicableFamilies();
            if (vector2 != null && vector2.size() > 0) {
                int n3 = 0;
                n = vector2.size();
                while (n3 < n) {
                    typeCategoryRec = (TypeCategoryRec)vector2.elementAt(n3);
                    typeCategoryRec2 = TypeCategory.getCategory(typeCategoryRec.getParentCatInd());
                    if (!vector.contains(typeCategoryRec2)) {
                        vector.addElement(typeCategoryRec2);
                    }
                    if (!vector3.contains(typeCategoryRec)) {
                        vector3.addElement(typeCategoryRec);
                    }
                    typeCategoryRec.setToString(typeCategoryRec.getDescript());
                    ++n3;
                }
            }
            new QuickSort(vector);
            if (vector.size() > 0) {
                Vector vector5 = new Vector(1);
                n = 0;
                int n4 = vector.size();
                while (n < n4) {
                    typeCategoryRec2 = (TypeCategoryRec)vector.elementAt(n);
                    vector2 = this.getFamiliesFromBrand(typeCategoryRec2, vector3);
                    new QuickSort(vector2);
                    this.addFamilies(vector2, vector5);
                    ++n;
                }
                if (vector5.size() > 0) {
                    this.lb_ASSOC_FAMILY.setListData(vector5);
                } else {
                    Vector<String> vector6 = new Vector<String>(1);
                    vector6.addElement(Str.getStr(11014));
                    this.lb_ASSOC_FAMILY.setListData(vector6);
                }
            }
        }
    }

    private Vector getFamiliesFromBrand(TypeCategoryRec typeCategoryRec, Vector vector) {
        Vector vector2 = new Vector(1);
        int n = 0;
        int n2 = vector.size();
        while (n < n2) {
            if (((TypeCategoryRec)vector.elementAt(n)).getParentCatInd() == typeCategoryRec.getInd()) {
                vector2.addElement(vector.elementAt(n));
            }
            ++n;
        }
        return vector2;
    }

    private void addFamilies(Vector vector, Vector vector2) {
        int n = 0;
        int n2 = vector.size();
        while (n < n2) {
            if (!vector2.contains(vector.elementAt(n))) {
                vector2.addElement(vector.elementAt(n));
            }
            ++n;
        }
    }

    private void selectInitialBrand() {
        TypeCategoryRec typeCategoryRec = TypeCategory.getCategory(PropertySystem.getInt(69));
        TypeCategoryRec typeCategoryRec2 = TypeCategory.getCategory(PropertySystem.getInt(38));
        if (typeCategoryRec == null) {
            typeCategoryRec = typeCategoryRec2;
        }
        if (typeCategoryRec != null) {
            this.cb_BRAND.setSelectedItem(typeCategoryRec);
            this.lb_FAMILY.setListData(Brands.getFamilies(typeCategoryRec));
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        boolean bl = this.lb_FAMILY.getSelectedValue() != null && this.lb_FAMILY.getSelectedValue() instanceof TypeCategoryRec;
        this.pb_DEASSOC.setEnabled(this.lb_ASSOC_FAMILY.getSelectedValue() != null && this.lb_ASSOC_FAMILY.getSelectedValue() instanceof TypeCategoryRec);
        this.pb_ASSOC.setEnabled(bl);
        this.pb_ASSOC_ALL.setEnabled(bl);
    }

    private void associateFamilyAll() {
        Object[] objectArray = this.lb_FAMILY.getSelectedValues();
        Vector<TypeCategoryRec> vector = this.document.getFamilies();
        Vector<TypeCategoryRec> vector2 = new Vector<TypeCategoryRec>(1);
        Vector vector3 = this.document.getApplicableFamilies();
        Vector vector4 = this.document.getMachines();
        Vector vector5 = this.document.getApplicableMachines();
        Vector vector6 = this.document.getModels();
        Vector<TypeCategoryRec> vector7 = this.document.getApplicableBrands();
        if (vector == null) {
            vector = new Vector<TypeCategoryRec>(1);
        }
        if (vector7 == null) {
            vector7 = new Vector<TypeCategoryRec>(1);
        }
        int n = 0;
        while (n < objectArray.length) {
            TypeCategoryRec typeCategoryRec = (TypeCategoryRec)objectArray[n];
            TypeCategoryRec typeCategoryRec2 = TypeCategory.getParentCategory(typeCategoryRec, "brand");
            if (!vector.contains(typeCategoryRec)) {
                vector.addElement(typeCategoryRec);
                vector2.addElement(typeCategoryRec);
                if (!vector7.contains(typeCategoryRec2)) {
                    vector7.addElement(typeCategoryRec2);
                }
            }
            if (vector3 != null && vector3.contains(typeCategoryRec)) {
                vector3.removeElement(typeCategoryRec);
                this.deassociateFamilyChildren(typeCategoryRec, vector4);
                this.deassociateFamilyChildren(typeCategoryRec, vector5);
                this.deassociateFamilyChildren(typeCategoryRec, vector6);
            }
            ++n;
        }
        this.document.setPropertyChangeEnabled(false);
        this.document.setApplicableBrands(vector7);
        this.document.setModels(vector6);
        this.document.setMachines(vector4);
        this.document.setApplicableMachines(vector4);
        this.document.setFamilies(vector);
        this.document.setPropertyChangeEnabled(true);
        this.document.setApplicableFamilies(vector3);
        this.refreshData();
        WinUtil.selectItems((JList)this.lb_ASSOC_FAMILY, vector2);
    }

    private void associateApplicableFamily() {
        Object[] objectArray = this.lb_FAMILY.getSelectedValues();
        Vector<TypeCategoryRec> vector = this.document.getApplicableFamilies();
        Vector<TypeCategoryRec> vector2 = new Vector<TypeCategoryRec>(1);
        Vector vector3 = this.document.getFamilies();
        Vector<TypeCategoryRec> vector4 = this.document.getApplicableBrands();
        if (vector == null) {
            vector = new Vector<TypeCategoryRec>(1);
        }
        if (vector4 == null) {
            vector4 = new Vector<TypeCategoryRec>(1);
        }
        if (vector3 == null) {
            vector3 = new Vector(1);
        }
        this.document.setPropertyChangeEnabled(false);
        int n = 0;
        while (n < objectArray.length) {
            if (!vector.contains(objectArray[n])) {
                TypeCategoryRec typeCategoryRec = (TypeCategoryRec)objectArray[n];
                TypeCategoryRec typeCategoryRec2 = TypeCategory.getParentCategory(typeCategoryRec, "brand");
                if (!vector4.contains(typeCategoryRec2)) {
                    vector4.addElement(typeCategoryRec2);
                }
                if (vector3.contains(typeCategoryRec)) {
                    vector3.removeElement(typeCategoryRec);
                }
                if (!vector.contains(typeCategoryRec)) {
                    vector.addElement(typeCategoryRec);
                    vector2.addElement(typeCategoryRec);
                    this.associateApplicableMachines(typeCategoryRec);
                }
            }
            vector3.removeElement(objectArray[n]);
            ++n;
        }
        this.document.setApplicableBrands(vector4);
        this.document.setPropertyChangeEnabled(true);
        this.document.setFamilies(vector3);
        this.document.setApplicableFamilies(vector);
        this.refreshData();
        WinUtil.selectItems((JList)this.lb_ASSOC_FAMILY, vector2);
    }

    private void associateApplicableMachines(TypeCategoryRec typeCategoryRec) {
        Vector vector = new Vector(1);
        Object var3_3 = null;
        Vector vector2 = this.document.getApplicableMachines();
        this.selectDlg.setText(Str.getStr(142) + " " + typeCategoryRec.getDescript());
        StoreUtil.copyUniqueVector(Brands.getMachinesSubCategoriesFromFamily(typeCategoryRec.getInd()), vector);
        this.selectDlg.setText(null);
        if (vector2 == null) {
            vector2 = new Vector();
        }
        if (vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                if (!vector2.contains(vector.elementAt(n))) {
                    vector2.addElement(vector.elementAt(n));
                }
                ++n;
            }
        }
        this.document.setApplicableMachines(vector2);
    }

    private void addApplicableMachines(TypeCategoryRec typeCategoryRec, Vector vector, String string) {
        Vector vector2 = TypeCategory.getChildCategories(typeCategoryRec.getInd(), string);
        if (vector2 != null && vector2.size() > 0) {
            int n = 0;
            int n2 = vector2.size();
            while (n < n2) {
                if (!vector.contains(vector2.elementAt(n))) {
                    vector.addElement(vector2.elementAt(n));
                }
                ++n;
            }
        }
    }

    private void deassociateFamily() {
        Object[] objectArray = this.lb_ASSOC_FAMILY.getSelectedValues();
        if (objectArray != null && objectArray.length > 0) {
            Vector vector = this.document.getApplicableFamilies();
            Vector vector2 = this.document.getFamilies();
            Vector vector3 = this.document.getApplicableMachines();
            Vector vector4 = this.document.getMachines();
            Vector vector5 = this.document.getModels();
            this.document.setPropertyChangeEnabled(false);
            int n = 0;
            while (n < objectArray.length) {
                vector2.removeElement(objectArray[n]);
                vector.removeElement(objectArray[n]);
                this.deassociateFamilyChildren((TypeCategoryRec)objectArray[n], vector3);
                this.deassociateFamilyChildren((TypeCategoryRec)objectArray[n], vector4);
                this.deassociateFamilyChildren((TypeCategoryRec)objectArray[n], vector5);
                ++n;
            }
            this.document.setModels(vector5);
            this.document.setMachines(vector4);
            this.document.setApplicableMachines(vector3);
            this.document.setApplicableFamilies(vector);
            this.document.setPropertyChangeEnabled(true);
            this.document.setFamilies(vector2);
            this.refreshData();
        }
    }

    private void deassociateFamilyChildren(TypeCategoryRec typeCategoryRec, Vector vector) {
        if (vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                if (TypeCategory.getParentCategory((TypeCategoryRec)vector.elementAt(n), typeCategoryRec.getCategoryLevel()).getInd() == typeCategoryRec.getInd()) {
                    vector.removeElementAt(n);
                    --n2;
                    continue;
                }
                ++n;
            }
        }
    }

    protected void cleanup() {
    }

    public ProductSelectBrandPanel(ProductSelectDlg productSelectDlg) {
        this.selectDlg = productSelectDlg;
        this.pb_ASSOC_ALL.setForeground(Color.blue);
        this.pb_ASSOC_ALL.setEnabled(false);
        this.pb_ASSOC.setEnabled(false);
        this.pb_DEASSOC.setEnabled(false);
        this.lb_FAMILY.setModel(this.familyDefaultModel);
        this.lb_ASSOC_FAMILY.setModel(this.assocFamilyDefaultModel);
        this.pb_ASSOC_ALL.addActionListener(this);
        this.pb_ASSOC.addActionListener(this);
        this.pb_DEASSOC.addActionListener(this);
        this.cb_BRAND.addActionListener(this);
        this.lb_FAMILY.addListSelectionListener(this);
        this.lb_ASSOC_FAMILY.addListSelectionListener(this);
        this.lb_FAMILY.addActionListener(this);
        this.lb_ASSOC_FAMILY.addActionListener(this);
        this.setLayout(null);
        this.add(this.st_BRAND);
        this.add(this.cb_BRAND);
        this.add(this.st_ASSOC_FAMILY);
        this.add(this.scr_FAMILY);
        this.add(this.pb_DEASSOC);
        this.add(this.pb_ASSOC);
        this.add(this.pb_ASSOC_ALL);
        this.add(this.scr_ASSOC_FAMILY);
    }
}

