/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.doc.docedit;

import com.ibm.nzna.projects.common.quest.doc.Document;
import com.ibm.nzna.projects.common.quest.doc.DocumentPropertyListener;
import com.ibm.nzna.projects.common.quest.type.TypeCategory;
import com.ibm.nzna.projects.common.quest.type.TypeCategoryRec;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.doc.DocConst;
import com.ibm.nzna.projects.qit.doc.docedit.ProductSelectDlg;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.gui.DButton;
import com.ibm.nzna.shared.gui.DefaultTreeRenderer;
import com.ibm.nzna.shared.gui.StringTreeNode;
import com.ibm.nzna.shared.sort.QuickSort;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.WinUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class ProductSelectMachinePanel
extends JPanel
implements TreeSelectionListener,
DocumentPropertyListener,
AppConst,
DocConst,
ActionListener {
    private String allStr = "(" + Str.getStr(218) + ")";
    private JTree tre_MACHINES = new JTree();
    private JScrollPane scr_MACHINES = new JScrollPane(this.tre_MACHINES);
    private JTree tre_MODELS = new JTree();
    private JScrollPane scr_MODELS = new JScrollPane(this.tre_MODELS);
    private DButton pb_ASSOC = new DButton("-->>");
    private DButton pb_DEASSOC = new DButton("<<--");
    private DButton pb_ASSOC_ALL = new DButton(">>>>");
    private DButton pb_BOOKMARKS = new DButton(Str.getStr(1017), ImageSystem.getImageIcon((Object)this, 43));
    private JLabel st_MACHINES = new JLabel(Str.getStr(340));
    private DefaultTreeRenderer treeRenderer = null;
    private JLabel st_MODELS = new JLabel(Str.getStr(341));
    private Document document = null;
    private ProductSelectDlg selectDlg = null;
    private boolean refreshingAll = false;

    public void doLayout() {
        Dimension dimension = this.getSize();
        int n = dimension.width / 2;
        int n2 = 20;
        int n3 = 5;
        int n4 = 5;
        int n5 = GUISystem.getRowHeight();
        super.doLayout();
        this.st_MACHINES.setBounds(n3, n4, n - 10 - n2, n5);
        this.st_MODELS.setBounds(n + 5 + n2, n4, n - 10 - n2, n5);
        this.scr_MACHINES.setBounds(n3, n4 += n5, n - 10 - n2, dimension.height - n4 - 5);
        this.scr_MODELS.setBounds(n + 5 + n2, n4, n - 10 - n2, dimension.height - n4 - 5 - 22);
        this.pb_BOOKMARKS.setBounds(n + 5 + n2, dimension.height - 22, n - 5 - n2, 20);
        n4 += n5;
        n4 = n5 * 4;
        this.pb_DEASSOC.setBounds(n - n2, n4, n2 * 2, 25);
        this.pb_ASSOC.setBounds(n - n2, n4 += 30, n2 * 2, 25);
        this.pb_ASSOC_ALL.setBounds(n - n2, n4 += 30, n2 * 2, 25);
        n4 += 30;
    }

    protected void setDocument(Document document) {
        if (this.document != null) {
            this.document.removeDocumentPropertyListener(this);
        }
        this.document = document;
        document.addDocumentPropertyListener(this);
        this.clearData();
        this.refreshData();
    }

    private void clearData() {
        this.tre_MACHINES.setModel(this.createNoMachineTreeModel());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.pb_ASSOC) {
            this.associateMachines();
        } else if (actionEvent.getSource() == this.pb_ASSOC_ALL) {
            this.associateAll();
        } else if (actionEvent.getSource() == this.pb_DEASSOC) {
            this.deassociate();
        }
    }

    protected void cleanup() {
        if (this.document != null) {
            this.document.removeDocumentPropertyListener(this);
        }
    }

    public void documentChanged(Document document, int n) {
        switch (n) {
            case 3: 
            case 4: 
            case 13: 
            case 14: {
                this.refreshData();
                break;
            }
            case 5: {
                if (this.refreshingAll) break;
                this.refreshModels();
                break;
            }
        }
    }

    private void associateMachines() {
        Object[] objectArray = null;
        TreePath[] treePathArray = this.tre_MACHINES.getSelectionPaths();
        if (treePathArray != null && treePathArray.length > 0) {
            Vector<TypeCategoryRec> vector = this.document.getMachines();
            Vector<TypeCategoryRec> vector2 = this.document.getApplicableMachines();
            Vector<TypeCategoryRec> vector3 = new Vector<TypeCategoryRec>(1);
            this.document.setPropertyChangeEnabled(false);
            if (vector == null) {
                vector = new Vector<TypeCategoryRec>(1);
            }
            if (vector2 == null) {
                vector2 = new Vector<TypeCategoryRec>(1);
            }
            int n = 0;
            while (n < treePathArray.length) {
                StringTreeNode stringTreeNode = (StringTreeNode)treePathArray[n].getLastPathComponent();
                TypeCategoryRec typeCategoryRec = (TypeCategoryRec)stringTreeNode.getData();
                if (vector.contains(typeCategoryRec)) {
                    vector.addElement(typeCategoryRec);
                }
                if (!vector2.contains(typeCategoryRec)) {
                    vector2.addElement(typeCategoryRec);
                }
                vector3.addElement(typeCategoryRec);
                ++n;
            }
            this.document.setApplicableMachines(vector2);
            this.document.setPropertyChangeEnabled(true);
            objectArray = new Object[vector3.size()];
            vector3.copyInto(objectArray);
        }
        if (objectArray != null && objectArray.length > 0) {
            this.selectDlg.showModelPanel(objectArray);
        }
    }

    private void refreshData() {
        this.refreshingAll = true;
        this.refreshMachines();
        this.refreshModels();
        this.refreshingAll = false;
    }

    private void refreshMachines() {
        int n;
        int n2;
        int n3;
        Vector<TypeCategoryRec> vector = new Vector<TypeCategoryRec>();
        Vector<TypeCategoryRec> vector2 = new Vector<TypeCategoryRec>();
        TypeCategoryRec typeCategoryRec = null;
        TypeCategoryRec typeCategoryRec2 = null;
        TypeCategoryRec typeCategoryRec3 = null;
        Vector<TypeCategoryRec> vector3 = new Vector<TypeCategoryRec>();
        Vector vector4 = this.document.getMachines();
        Vector vector5 = this.document.getApplicableMachines();
        int n4 = n3 = this.scr_MACHINES.getVerticalScrollBar() != null ? this.scr_MACHINES.getVerticalScrollBar().getValue() : 0;
        if (vector4 != null && vector4.size() > 0) {
            n2 = 0;
            n = vector4.size();
            while (n2 < n) {
                typeCategoryRec3 = (TypeCategoryRec)vector4.elementAt(n2);
                typeCategoryRec3.setToString(typeCategoryRec3.getDescript() + " " + this.allStr);
                if (!vector3.contains(typeCategoryRec3)) {
                    vector3.addElement(typeCategoryRec3);
                    typeCategoryRec = TypeCategory.getParentCategory(typeCategoryRec3, "family");
                    typeCategoryRec2 = TypeCategory.getParentCategory(typeCategoryRec, "brand");
                    if (!vector2.contains(typeCategoryRec)) {
                        vector2.addElement(typeCategoryRec);
                    }
                    if (!vector.contains(typeCategoryRec2)) {
                        vector.addElement(typeCategoryRec2);
                    }
                }
                ++n2;
            }
        }
        if (vector5 != null && vector5.size() > 0) {
            n2 = 0;
            n = vector5.size();
            while (n2 < n) {
                typeCategoryRec3 = (TypeCategoryRec)vector5.elementAt(n2);
                typeCategoryRec3.setToString(typeCategoryRec3.getDescript());
                if (!vector3.contains(typeCategoryRec3)) {
                    vector3.addElement(typeCategoryRec3);
                    typeCategoryRec = TypeCategory.getParentCategory(typeCategoryRec3, "family");
                    typeCategoryRec2 = TypeCategory.getParentCategory(typeCategoryRec3, "brand");
                    if (!vector2.contains(typeCategoryRec)) {
                        vector2.addElement(typeCategoryRec);
                    }
                    if (!vector.contains(typeCategoryRec2)) {
                        vector.addElement(typeCategoryRec2);
                    }
                }
                ++n2;
            }
        }
        if (vector3.size() > 0) {
            new QuickSort(vector);
            new QuickSort(vector2);
            new QuickSort(vector3);
            this.createMachineTreeModel(vector, vector2, vector3);
        } else {
            this.tre_MACHINES.setModel(this.createNoMachineTreeModel());
        }
        if (n3 != 0) {
            this.scr_MACHINES.getVerticalScrollBar().setValue(n3);
        }
    }

    private DefaultTreeModel createMachineTreeModel(Vector vector, Vector vector2, Vector vector3) {
        StringTreeNode stringTreeNode = new StringTreeNode(Str.getStr(11019));
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(stringTreeNode);
        int n = 0;
        int n2 = vector.size();
        TypeCategoryRec typeCategoryRec = null;
        StringTreeNode stringTreeNode2 = null;
        int n3 = 0;
        Vector<StringTreeNode> vector4 = new Vector<StringTreeNode>(1);
        while (n < n2) {
            typeCategoryRec = (TypeCategoryRec)vector.elementAt(n);
            stringTreeNode2 = new StringTreeNode(typeCategoryRec.getDescript());
            defaultTreeModel.insertNodeInto(stringTreeNode2, stringTreeNode, n3++);
            this.insertFamiliesIntoModel(defaultTreeModel, typeCategoryRec, stringTreeNode2, vector2, vector3);
            vector4.addElement(stringTreeNode2);
            ++n;
        }
        this.tre_MACHINES.setModel(defaultTreeModel);
        this.tre_MACHINES.setCellRenderer(new DefaultTreeRenderer());
        WinUtil.expandTree(this.tre_MACHINES);
        return defaultTreeModel;
    }

    private void insertFamiliesIntoModel(DefaultTreeModel defaultTreeModel, TypeCategoryRec typeCategoryRec, StringTreeNode stringTreeNode, Vector vector, Vector vector2) {
        int n = 0;
        int n2 = vector.size();
        StringTreeNode stringTreeNode2 = null;
        int n3 = typeCategoryRec.getInd();
        TypeCategoryRec typeCategoryRec2 = null;
        int n4 = 0;
        while (n < n2) {
            typeCategoryRec2 = (TypeCategoryRec)vector.elementAt(n);
            if (typeCategoryRec2.getParentCatInd() == n3) {
                stringTreeNode2 = new StringTreeNode(typeCategoryRec2.toString());
                defaultTreeModel.insertNodeInto(stringTreeNode2, stringTreeNode, n4++);
                this.insertMachinesIntoModel(defaultTreeModel, typeCategoryRec2, stringTreeNode2, vector2);
            }
            ++n;
        }
    }

    private void insertMachinesIntoModel(DefaultTreeModel defaultTreeModel, TypeCategoryRec typeCategoryRec, StringTreeNode stringTreeNode, Vector vector) {
        int n = 0;
        int n2 = vector.size();
        StringTreeNode stringTreeNode2 = null;
        int n3 = typeCategoryRec.getInd();
        TypeCategoryRec typeCategoryRec2 = null;
        int n4 = 0;
        while (n < n2) {
            typeCategoryRec2 = (TypeCategoryRec)vector.elementAt(n);
            if (TypeCategory.getParentCategory(typeCategoryRec2, "family").getInd() == n3) {
                stringTreeNode2 = new StringTreeNode(typeCategoryRec2.toString(), typeCategoryRec2);
                defaultTreeModel.insertNodeInto(stringTreeNode2, stringTreeNode, n4++);
            }
            ++n;
        }
    }

    private Vector getFamiliesFromBrand(TypeCategoryRec typeCategoryRec, Vector vector) {
        Vector vector2 = new Vector(1);
        if (vector != null) {
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                if (((TypeCategoryRec)vector.elementAt(n)).getParentCatInd() == typeCategoryRec.getInd()) {
                    vector2.addElement(vector.elementAt(n));
                }
                ++n;
            }
        }
        return vector2;
    }

    private Vector getMachinesFromFamily(TypeCategoryRec typeCategoryRec, Vector vector) {
        Vector vector2 = new Vector(1);
        int n = 0;
        int n2 = vector.size();
        TypeCategoryRec typeCategoryRec2 = null;
        while (n < n2) {
            typeCategoryRec2 = TypeCategory.getParentCategory((TypeCategoryRec)vector.elementAt(n), "family");
            if (typeCategoryRec2 != null && typeCategoryRec2.getInd() == typeCategoryRec.getInd()) {
                vector2.addElement(vector.elementAt(n));
            }
            ++n;
        }
        return vector2;
    }

    private void addFamilies(Vector vector, Vector vector2) {
        int n = 0;
        int n2 = vector.size();
        while (n < n2) {
            if (!vector2.contains(vector.elementAt(n))) {
                vector2.addElement(vector.elementAt(n));
            }
            ++n;
        }
    }

    private void refreshModels() {
        Vector<TypeCategoryRec> vector = new Vector<TypeCategoryRec>(1);
        Vector<TypeCategoryRec> vector2 = new Vector<TypeCategoryRec>(1);
        Vector<TypeCategoryRec> vector3 = new Vector<TypeCategoryRec>(1);
        Vector vector4 = this.getModelsAndDescriptions(this.document.getModels());
        if (vector4 != null && vector4.size() > 0) {
            int n = 0;
            int n2 = vector4.size();
            TypeCategoryRec typeCategoryRec = null;
            TypeCategoryRec typeCategoryRec2 = null;
            TypeCategoryRec typeCategoryRec3 = null;
            TypeCategoryRec typeCategoryRec4 = null;
            this.selectDlg.setEnabled(false);
            this.selectDlg.setText("Refreshing Models ...");
            while (n < n2) {
                typeCategoryRec2 = (TypeCategoryRec)vector4.elementAt(n);
                typeCategoryRec4 = TypeCategory.getParentCategory(typeCategoryRec2, "machine");
                if (typeCategoryRec4 == null) {
                    typeCategoryRec4 = TypeCategory.getParentCategory(typeCategoryRec2, "subcategory");
                }
                if (typeCategoryRec4 != null) {
                    typeCategoryRec3 = TypeCategory.getParentCategory(typeCategoryRec4, "family");
                    typeCategoryRec = TypeCategory.getParentCategory(typeCategoryRec3, "brand");
                    if (!vector.contains(typeCategoryRec)) {
                        vector.addElement(typeCategoryRec);
                    }
                    if (!vector2.contains(typeCategoryRec3)) {
                        vector2.addElement(typeCategoryRec3);
                    }
                    if (!vector3.contains(typeCategoryRec4)) {
                        vector3.addElement(typeCategoryRec4);
                    }
                } else {
                    LogSystem.log(1, "Could not find Machine or Sub Categorgy parent for Model:" + typeCategoryRec2.getInd() + " (" + typeCategoryRec2.getDescript() + ")");
                }
                ++n;
            }
            new QuickSort(vector);
            new QuickSort(vector2);
            new QuickSort(vector3);
            new QuickSort(vector4);
            this.createModelTreeModel(vector, vector2, vector3, vector4);
        } else {
            this.tre_MODELS.setModel(this.createNoModelTreeModel());
        }
        this.selectDlg.setText("");
        this.selectDlg.setEnabled(true);
    }

    private DefaultTreeModel createNoModelTreeModel() {
        StringTreeNode stringTreeNode = new StringTreeNode(Str.getStr(11017));
        return new DefaultTreeModel(stringTreeNode);
    }

    private DefaultTreeModel createNoMachineTreeModel() {
        StringTreeNode stringTreeNode = new StringTreeNode(Str.getStr(11013));
        return new DefaultTreeModel(stringTreeNode);
    }

    private DefaultTreeModel createModelTreeModel(Vector vector, Vector vector2, Vector vector3, Vector vector4) {
        StringTreeNode stringTreeNode = new StringTreeNode(Str.getStr(11018));
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(stringTreeNode);
        int n = 0;
        int n2 = vector.size();
        TypeCategoryRec typeCategoryRec = null;
        StringTreeNode stringTreeNode2 = null;
        int n3 = 0;
        Vector<StringTreeNode> vector5 = new Vector<StringTreeNode>(1);
        while (n < n2) {
            typeCategoryRec = (TypeCategoryRec)vector.elementAt(n);
            stringTreeNode2 = new StringTreeNode(typeCategoryRec.getDescript(), typeCategoryRec);
            defaultTreeModel.insertNodeInto(stringTreeNode2, stringTreeNode, n3++);
            this.insertFamiliesIntoModel(defaultTreeModel, stringTreeNode2, vector2, vector3, vector4);
            vector5.addElement(stringTreeNode2);
            ++n;
        }
        this.tre_MODELS.setModel(defaultTreeModel);
        WinUtil.expandTree(this.tre_MODELS);
        this.treeRenderer = new DefaultTreeRenderer();
        this.tre_MODELS.setCellRenderer(this.treeRenderer);
        return defaultTreeModel;
    }

    private void insertFamiliesIntoModel(DefaultTreeModel defaultTreeModel, StringTreeNode stringTreeNode, Vector vector, Vector vector2, Vector vector3) {
        int n = 0;
        int n2 = vector.size();
        StringTreeNode stringTreeNode2 = null;
        int n3 = ((TypeCategoryRec)stringTreeNode.getData()).getInd();
        TypeCategoryRec typeCategoryRec = null;
        int n4 = 0;
        while (n < n2) {
            typeCategoryRec = (TypeCategoryRec)vector.elementAt(n);
            if (typeCategoryRec.getParentCatInd() == n3) {
                stringTreeNode2 = new StringTreeNode(typeCategoryRec.toString(), typeCategoryRec);
                defaultTreeModel.insertNodeInto(stringTreeNode2, stringTreeNode, n4++);
                this.insertMachinesIntoModel(defaultTreeModel, stringTreeNode2, vector2, vector3);
            }
            ++n;
        }
    }

    private void insertMachinesIntoModel(DefaultTreeModel defaultTreeModel, StringTreeNode stringTreeNode, Vector vector, Vector vector2) {
        int n = 0;
        int n2 = vector.size();
        StringTreeNode stringTreeNode2 = null;
        int n3 = ((TypeCategoryRec)stringTreeNode.getData()).getInd();
        TypeCategoryRec typeCategoryRec = null;
        int n4 = 0;
        while (n < n2) {
            typeCategoryRec = (TypeCategoryRec)vector.elementAt(n);
            if (TypeCategory.getParentCategory(typeCategoryRec, "family").getInd() == n3) {
                stringTreeNode2 = new StringTreeNode(typeCategoryRec.toString(), typeCategoryRec);
                defaultTreeModel.insertNodeInto(stringTreeNode2, stringTreeNode, n4++);
                this.insertModelsIntoModel(defaultTreeModel, stringTreeNode2, vector2);
            }
            ++n;
        }
    }

    private void insertModelsIntoModel(DefaultTreeModel defaultTreeModel, StringTreeNode stringTreeNode, Vector vector) {
        int n = 0;
        int n2 = vector.size();
        StringTreeNode stringTreeNode2 = null;
        int n3 = ((TypeCategoryRec)stringTreeNode.getData()).getInd();
        TypeCategoryRec typeCategoryRec = null;
        int n4 = 0;
        while (n < n2) {
            typeCategoryRec = (TypeCategoryRec)vector.elementAt(n);
            if (typeCategoryRec.getParentCatInd() == n3) {
                stringTreeNode2 = new StringTreeNode(typeCategoryRec.toString(), typeCategoryRec);
                defaultTreeModel.insertNodeInto(stringTreeNode2, stringTreeNode, n4);
                ++n4;
            }
            ++n;
        }
    }

    private void associateAll() {
        TreePath[] treePathArray = this.tre_MACHINES.getSelectionPaths();
        if (treePathArray != null && treePathArray.length > 0) {
            Vector<TypeCategoryRec> vector = this.document.getMachines();
            Vector vector2 = this.document.getApplicableMachines();
            this.document.setPropertyChangeEnabled(false);
            if (vector == null) {
                vector = new Vector<TypeCategoryRec>(1);
            }
            if (vector2 == null) {
                vector2 = new Vector(1);
            }
            int n = 0;
            while (n < treePathArray.length) {
                StringTreeNode stringTreeNode = (StringTreeNode)treePathArray[n].getLastPathComponent();
                TypeCategoryRec typeCategoryRec = (TypeCategoryRec)stringTreeNode.getData();
                if (!vector.contains(typeCategoryRec)) {
                    vector.addElement(typeCategoryRec);
                }
                if (vector2.contains(typeCategoryRec)) {
                    vector2.removeElement(typeCategoryRec);
                    this.removeModelsFromParent(typeCategoryRec.getInd(), typeCategoryRec.getCategoryLevel());
                }
                ++n;
            }
            this.document.setApplicableMachines(vector2);
            this.document.setPropertyChangeEnabled(true);
            this.document.setMachines(vector);
        }
    }

    private void removeModels(TypeCategoryRec typeCategoryRec, Vector vector) {
        int n = 0;
        int n2 = vector.size();
        while (n < n2) {
            if (TypeCategory.getParentCategory((TypeCategoryRec)vector.elementAt(n), "machine").getInd() == typeCategoryRec.getInd()) {
                vector.removeElementAt(n);
                --n2;
                continue;
            }
            ++n;
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (treeSelectionEvent.getSource() == this.tre_MODELS) {
            try {
                StringTreeNode stringTreeNode = (StringTreeNode)this.tre_MODELS.getSelectionPath().getLastPathComponent();
                this.pb_DEASSOC.setEnabled(stringTreeNode != null && stringTreeNode.getData() != null);
            }
            catch (Exception exception) {
                this.pb_DEASSOC.setEnabled(false);
            }
        } else if (treeSelectionEvent.getSource() == this.tre_MACHINES) {
            try {
                StringTreeNode stringTreeNode = (StringTreeNode)this.tre_MACHINES.getSelectionPath().getLastPathComponent();
                TypeCategoryRec typeCategoryRec = (TypeCategoryRec)stringTreeNode.getData();
                this.pb_ASSOC.setEnabled(typeCategoryRec != null);
                this.pb_ASSOC_ALL.setEnabled(typeCategoryRec != null);
            }
            catch (Exception exception) {
                this.pb_ASSOC.setEnabled(false);
                this.pb_ASSOC_ALL.setEnabled(false);
            }
        }
    }

    private void deassociate() {
        TreePath[] treePathArray = this.tre_MODELS.getSelectionPaths();
        this.document.setPropertyChangeEnabled(false);
        if (treePathArray != null && treePathArray.length > 0) {
            int n = 0;
            while (n < treePathArray.length) {
                StringTreeNode stringTreeNode = (StringTreeNode)treePathArray[n].getLastPathComponent();
                TypeCategoryRec typeCategoryRec = (TypeCategoryRec)stringTreeNode.getData();
                if (typeCategoryRec.getCategoryLevel().equals("model") || typeCategoryRec.getCategoryLevel().equals("partnum")) {
                    Vector vector = this.document.getModels();
                    vector.removeElement(typeCategoryRec);
                    this.document.setModels(vector);
                } else {
                    this.removeModelsFromParent(typeCategoryRec.getInd(), typeCategoryRec.getCategoryLevel());
                }
                ++n;
            }
            this.refreshData();
        } else {
            GUISystem.printBox(WinUtil.getParentJDialog(this), 7, 358);
        }
        this.document.setPropertyChangeEnabled(true);
    }

    private void removeModelsFromParent(int n, String string) {
        Vector vector = this.document.getModels();
        if (vector != null && vector.size() > 0) {
            int n2 = 0;
            int n3 = vector.size();
            while (n2 < n3) {
                TypeCategoryRec typeCategoryRec = TypeCategory.getParentCategory((TypeCategoryRec)vector.elementAt(n2), string);
                if (typeCategoryRec != null && typeCategoryRec.getInd() == n) {
                    vector.removeElementAt(n2);
                    --n3;
                    n2 = -1;
                }
                ++n2;
            }
        }
        this.document.setModels(vector);
    }

    private Vector getModelsAndDescriptions(Vector vector) {
        Vector<TypeCategoryRec> vector2 = new Vector<TypeCategoryRec>(1);
        if (vector != null && vector.size() > 0) {
            SQLMethod sQLMethod = new SQLMethod(1, "getModelsAndDescriptions", 5);
            try {
                int n = vector.size();
                Statement statement = sQLMethod.createStatement();
                ResultSet resultSet = null;
                String string = "SELECT B.TYPECATIND, A.DESCRIPTION FROM PRODUCT.PRODUCT A,      PRODUCT.CATEGORY B WHERE A.PRODUCTIND = B.PRODUCTIND AND       B.TYPECATIND IN ( ";
                int n2 = 0;
                while (n2 < n) {
                    string = string + "" + ((TypeCategoryRec)vector.elementAt(n2)).getInd();
                    if (n2 < n - 1) {
                        string = string + ",";
                    }
                    ++n2;
                }
                string = string + ") FOR FETCH ONLY";
                resultSet = statement.executeQuery(string);
                while (resultSet.next()) {
                    TypeCategoryRec typeCategoryRec = null;
                    try {
                        typeCategoryRec = (TypeCategoryRec)this.getCategoryRec(resultSet.getInt(1), vector).clone();
                    }
                    catch (NullPointerException nullPointerException) {
                        System.out.println("Huh, could not find category for typeCatInd:" + resultSet.getInt(1));
                    }
                    typeCategoryRec.setToString(typeCategoryRec.getDescript() + " (" + resultSet.getString(2).trim() + ")");
                    vector2.addElement(typeCategoryRec);
                }
                resultSet.close();
            }
            catch (Exception exception) {
                LogSystem.log(1, exception, false);
                sQLMethod.rollBack();
                GUISystem.printBox(WinUtil.getParentJDialog(this), 7, 202);
            }
            sQLMethod.close();
        }
        return vector2;
    }

    private TypeCategoryRec getCategoryRec(int n, Vector vector) {
        TypeCategoryRec typeCategoryRec = null;
        if (vector != null && vector.size() > 0) {
            int n2 = 0;
            int n3 = vector.size();
            while (typeCategoryRec == null && n2 < n3) {
                if (((TypeCategoryRec)vector.elementAt(n2)).getInd() == n) {
                    typeCategoryRec = (TypeCategoryRec)vector.elementAt(n2);
                }
                ++n2;
            }
        }
        return typeCategoryRec;
    }

    public ProductSelectMachinePanel(ProductSelectDlg productSelectDlg) {
        this.selectDlg = productSelectDlg;
        this.pb_ASSOC_ALL.setForeground(Color.blue);
        this.treeRenderer = new DefaultTreeRenderer();
        this.tre_MODELS.setCellRenderer(this.treeRenderer);
        this.tre_MACHINES.setCellRenderer(this.treeRenderer);
        this.pb_ASSOC.setEnabled(false);
        this.pb_DEASSOC.setEnabled(false);
        this.pb_ASSOC_ALL.setEnabled(false);
        this.pb_ASSOC.addActionListener(this);
        this.pb_ASSOC_ALL.addActionListener(this);
        this.pb_DEASSOC.addActionListener(this);
        this.tre_MACHINES.addTreeSelectionListener(this);
        this.tre_MODELS.addTreeSelectionListener(this);
        this.setLayout(null);
        this.add(this.st_MACHINES);
        this.add(this.scr_MACHINES);
        this.add(this.pb_DEASSOC);
        this.add(this.pb_ASSOC);
        this.add(this.pb_ASSOC_ALL);
        this.add(this.st_MODELS);
        this.add(this.scr_MODELS);
        this.add(this.pb_BOOKMARKS);
        this.clearData();
    }
}

