/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.doc.docedit;

import com.ibm.nzna.projects.common.quest.doc.Document;
import com.ibm.nzna.projects.common.quest.doc.DocumentDraft;
import com.ibm.nzna.projects.common.quest.doc.DocumentPropertyListener;
import com.ibm.nzna.projects.common.quest.doc.DocumentSQL;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.gui.DateEntryField;
import com.ibm.nzna.shared.gui.DPanel;
import com.ibm.nzna.shared.gui.MaskDocument;
import com.ibm.nzna.shared.gui.ValueLabel;
import com.ibm.nzna.shared.util.LogSystem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PublishingOptionsPanel
extends DPanel
implements Runnable,
DocumentPropertyListener,
FocusListener,
ActionListener,
AppConst {
    private static final String THREAD_SAVE = "SAVE";
    private FocusEvent lastFocusEvent = null;
    private JCheckBox webable = new JCheckBox(Str.getStr(270));
    private JCheckBox oa = new JCheckBox(Str.getStr(273));
    private JTextField monthsToReview = new JTextField(new MaskDocument(3, 2), "", 0);
    private JTextField filename = new JTextField();
    private ValueLabel filenameLabel = new ValueLabel(Str.getStr(456), this.filename);
    private ValueLabel monthsToReviewLabel = new ValueLabel(Str.getStr(278), this.monthsToReview);
    private ValueLabel hotNewsInfo = null;
    private JPanel hotNewsPanel = new JPanel();
    private JCheckBox hotNews = new JCheckBox("");
    private DateEntryField hotNewsDate = new DateEntryField();
    private Document document = null;
    private boolean filenameCanBeChanged = false;

    public void doLayout() {
        Dimension dimension = this.getSize();
        int n = 0;
        int n2 = GUISystem.getRowHeight();
        super.doLayout();
        this.webable.setBounds(0, n, dimension.width / 2, n2);
        this.hotNewsInfo.setBounds(dimension.width / 2, n, dimension.width / 2, n2);
        this.oa.setBounds(0, n += n2, dimension.width / 2, n2);
        this.monthsToReviewLabel.setBounds(dimension.width / 2, n, dimension.width / 2, n2);
        this.filenameLabel.setBounds(0, n += n2, 300, n2);
    }

    protected void setDocument(Document document) {
        if (this.document != document) {
            if (this.document != null) {
                this.document.removeDocumentPropertyListener(this);
            }
            this.document = document;
            document.addDocumentPropertyListener(this);
        }
        this.refresh();
    }

    private void refresh() {
        this.webable.setSelected(this.document.getWebable());
        this.oa.setSelected(this.document.getKnowledgeBase());
        this.hotNews.setSelected(this.document.getHotNewsDate() != null && this.document.getHotNewsDate().length() > 0);
        if (this.hotNews.isSelected()) {
            this.hotNewsDate.setText(this.document.getHotNewsDate());
        }
        this.monthsToReview.setText("" + this.document.getMonthsToReview());
        if (this.document.getFilename() != null) {
            this.filename.setText(this.document.getFilename());
            if (this.filenameCanBeChanged) {
                this.filename.setEditable(true);
            } else {
                this.filename.setEditable(false);
            }
        } else {
            this.filename.setText("");
            this.filename.setEditable(true);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.hotNews) {
            this.hotNewsDate.setEnabled(this.hotNews.isSelected());
            if (!this.hotNews.isSelected()) {
                this.hotNewsDate.setText("");
            } else {
                this.hotNewsDate.requestFocus();
                this.hotNewsDate.selectAll();
            }
        } else if (actionEvent.getSource() == this.oa) {
            this.document.setKnowledgeBase(this.oa.isSelected());
        } else if (actionEvent.getSource() == this.webable) {
            this.document.setWebable(this.webable.isSelected());
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        this.lastFocusEvent = focusEvent;
        new Thread((Runnable)this, THREAD_SAVE).start();
    }

    public void run() {
        String string = Thread.currentThread().getName();
        if (string.equals(THREAD_SAVE)) {
            if (this.lastFocusEvent.getSource() == this.hotNewsDate) {
                this.document.setHotNewsDate(this.hotNewsDate.getText());
            } else if (this.lastFocusEvent.getSource() == this.monthsToReview) {
                this.document.setMonthsToReview(new Integer(this.monthsToReview.getText()));
            } else if (this.lastFocusEvent.getSource() == this.filename && this.filename.isEditable()) {
                String string2 = this.filename.getText();
                this.filenameCanBeChanged = true;
                if (string2.trim().length() > 4) {
                    try {
                        if (DocumentSQL.getExistingDocInd(string2) == 0 && DocumentSQL.getDraftDocInd(string2) == 0) {
                            ((DocumentDraft)this.document).setFilename(string2);
                        } else {
                            GUISystem.printBox("Info", "That filename is currently in use by another document");
                        }
                    }
                    catch (Exception exception) {
                        LogSystem.log(1, exception, false);
                        this.filename.setDocument(new MaskDocument(4, "VVVV-VVVVVV", this.filename));
                        GUISystem.printBox("Info", "The filename you have entered cannot be checked for duplicates. The filename has been reset");
                    }
                }
            }
        }
    }

    public void documentChanged(Document document, int n) {
        this.refresh();
    }

    public PublishingOptionsPanel() {
        this.hotNewsPanel.setLayout(new BorderLayout());
        this.hotNewsPanel.add((Component)this.hotNews, "West");
        this.hotNewsPanel.add((Component)this.hotNewsDate, "Center");
        this.hotNewsInfo = new ValueLabel(Str.getStr(275), this.hotNewsPanel);
        this.setPreferredSize(new Dimension(490, GUISystem.getRowHeight() * 3));
        this.filename.setDocument(new MaskDocument(4, "VVVV-VVVVVV", this.filename));
        this.hotNewsDate.addFocusListener(this);
        this.hotNews.addActionListener(this);
        this.oa.addActionListener(this);
        this.webable.addActionListener(this);
        this.monthsToReview.addFocusListener(this);
        this.filename.addFocusListener(this);
        this.setLayout(null);
        this.setBackground(Color.white);
        this.webable.setBackground(Color.white);
        this.oa.setBackground(Color.white);
        this.hotNewsInfo.setBackground(Color.white);
        this.hotNewsInfo.setDescriptionWidth(150);
        this.hotNews.setBackground(Color.white);
        this.monthsToReviewLabel.setDescriptionWidth(150);
        this.filenameLabel.setDescriptionWidth(150);
        this.add(this.webable);
        this.add(this.oa);
        this.add(this.hotNewsInfo);
        this.add(this.monthsToReviewLabel);
        this.add(this.filenameLabel);
    }
}

