/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.doc.docmaint;

import com.ibm.nzna.projects.common.quest.brand.Brands;
import com.ibm.nzna.projects.common.quest.doc.DocumentRow;
import com.ibm.nzna.projects.common.quest.type.TypeCategory;
import com.ibm.nzna.projects.common.quest.type.TypeCategoryRec;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.DateSystem;
import com.ibm.nzna.projects.qit.app.FontSystem;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.doc.DocConst;
import com.ibm.nzna.projects.qit.doc.docview.DocViewListener;
import com.ibm.nzna.projects.qit.doc.docview.DocViewRec;
import com.ibm.nzna.projects.qit.help.HelpSystem;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.gui.HotLinkLabel;
import com.ibm.nzna.shared.gui.MultiList;
import com.ibm.nzna.shared.util.CDate;
import com.ibm.nzna.shared.util.LogSystem;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DocReviewPanel
extends JPanel
implements Runnable,
DocConst,
ListSelectionListener,
ActionListener,
AppConst {
    private JLabel st_YEAR = null;
    private JLabel st_MONTH = null;
    private JLabel st_BRAND = null;
    private JComboBox cb_YEAR = null;
    private JComboBox cb_MONTH = null;
    private JComboBox cb_BRAND = null;
    private HotLinkLabel pb_REFRESH = null;
    private DocViewListener viewListener = null;
    private HotLinkLabel pb_HELP = null;
    private JLabel st_REVIEW = null;
    private JLabel st_EXPIRED = null;
    private JLabel st_FILENAME = null;
    private boolean refresh = false;
    private DocumentRow currentDoc = null;

    public void doLayout() {
        Dimension dimension = this.getSize();
        int n = 5;
        int n2 = 5;
        int n3 = GUISystem.getRowHeight();
        super.doLayout();
        this.st_REVIEW.setBounds(n, n2, dimension.width - n * 2, n3 * 2);
        this.st_YEAR.setBounds(n, n2 += n3 * 2, dimension.width - n * 2, n3);
        this.cb_YEAR.setBounds(n, n2 += n3, dimension.width - n * 2, n3);
        this.st_MONTH.setBounds(n, n2 += n3 * 2, dimension.width - n * 2, n3);
        n2 += n3;
        if (this.cb_MONTH != null) {
            this.cb_MONTH.setBounds(n, n2, dimension.width - n * 2, n3);
        }
        this.st_BRAND.setBounds(n, n2 += n3 * 2, dimension.width - n * 2, n3);
        this.cb_BRAND.setBounds(n, n2 += n3, dimension.width - n * 2, n3);
        this.pb_REFRESH.setBounds(n, n2 += n3 * 2, 50, n3);
        this.pb_HELP.setBounds(dimension.width - 70, n2, 65, n3);
        this.st_FILENAME.setBounds(n, n2 += n3 * 3, dimension.width - n * 2, n3);
        this.st_EXPIRED.setBounds(n, n2 += n3, dimension.width - n * 2, n3 * 2);
    }

    private void refreshMonths(String string, boolean bl) {
        CDate cDate = new CDate();
        String string2 = cDate.getDate(7);
        int n = new Integer(cDate.getDate(8));
        boolean bl2 = string2.equals(string);
        Vector<String> vector = new Vector<String>(10);
        if (this.cb_MONTH != null) {
            this.remove(this.cb_MONTH);
            this.cb_MONTH = null;
        }
        vector.addElement(Str.getStr(218));
        if (!bl2 || n >= 1) {
            vector.addElement(Str.getStr(11072));
        }
        if (!bl2 || n >= 2) {
            vector.addElement(Str.getStr(11073));
        }
        if (!bl2 || n >= 3) {
            vector.addElement(Str.getStr(11074));
        }
        if (!bl2 || n >= 4) {
            vector.addElement(Str.getStr(11075));
        }
        if (!bl2 || n >= 5) {
            vector.addElement(Str.getStr(11076));
        }
        if (!bl2 || n >= 6) {
            vector.addElement(Str.getStr(11077));
        }
        if (!bl2 || n >= 7) {
            vector.addElement(Str.getStr(11078));
        }
        if (!bl2 || n >= 8) {
            vector.addElement(Str.getStr(11079));
        }
        if (!bl2 || n >= 9) {
            vector.addElement(Str.getStr(11080));
        }
        if (!bl2 || n >= 10) {
            vector.addElement(Str.getStr(11081));
        }
        if (!bl2 || n >= 11) {
            vector.addElement(Str.getStr(11082));
        }
        if (!bl2 || n >= 12) {
            vector.addElement(Str.getStr(11083));
        }
        this.cb_MONTH = new JComboBox(vector);
        this.add(this.cb_MONTH);
        if (bl) {
            this.revalidate();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.cb_YEAR) {
            this.refreshMonths((String)this.cb_YEAR.getSelectedItem(), true);
        } else if (actionEvent.getSource() == this.pb_REFRESH) {
            DocViewRec docViewRec = new DocViewRec(32);
            TypeCategoryRec typeCategoryRec = null;
            Vector<DocViewListener> vector = new Vector<DocViewListener>(1);
            try {
                typeCategoryRec = (TypeCategoryRec)this.cb_BRAND.getSelectedItem();
                docViewRec.setBrandInd(typeCategoryRec.getInd());
            }
            catch (Exception exception) {
                // empty catch block
            }
            docViewRec.setMonth((String)this.cb_MONTH.getSelectedItem());
            docViewRec.setYear((String)this.cb_YEAR.getSelectedItem());
            vector.addElement(this.viewListener);
            docViewRec.setListeners(vector);
            docViewRec.refresh();
        } else if (actionEvent.getSource() == this.pb_HELP) {
            HelpSystem.showHelp("doc/docmaint_review.html");
        }
    }

    public void setRefresh(boolean bl) {
        this.refresh = bl;
        if (bl) {
            new Thread(this).start();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        DocumentRow documentRow;
        if (listSelectionEvent.getSource() instanceof MultiList && (documentRow = (DocumentRow)((MultiList)listSelectionEvent.getSource()).getSelectedItem()) != null) {
            this.st_FILENAME.setText("<html><body><b>" + documentRow.getFilename() + "</b></body></html>");
            this.st_EXPIRED.setText(Str.getStr(142));
            this.currentDoc = documentRow;
            if (this.refresh) {
                new Thread(this).start();
            }
        }
    }

    public void run() {
        SQLMethod sQLMethod = new SQLMethod(1, "DocReviewPanel.run", 5);
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = null;
            resultSet = statement.executeQuery("SELECT REVIEWPERIOD, CHANGEDTIME FROM TIGRIS.DOCUMENTS " + "WHERE DOCIND = " + this.currentDoc.getExistingDocumentInd());
            if (resultSet.next()) {
                int n = resultSet.getInt(1);
                String string = resultSet.getString(2).trim();
                string = CDate.addMonthsToDate(string, n, 1);
                this.st_EXPIRED.setText("<html><body><b>" + Str.getStr(11087) + ":</b><br>" + DateSystem.prettyDateFromStampNoTime(string) + "</body></html>");
            } else {
                this.st_EXPIRED.setText(Str.getStr(958));
            }
            resultSet.close();
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            this.st_EXPIRED.setText(Str.getStr(958));
            sQLMethod.rollBack();
        }
        sQLMethod.close();
    }

    public DocReviewPanel(DocViewListener docViewListener) {
        Vector<String> vector = new Vector<String>(3);
        Vector vector2 = Brands.getBrands();
        CDate cDate = new CDate();
        int n = new Integer(cDate.getDate(7));
        TypeCategoryRec typeCategoryRec = TypeCategory.getCategory(PropertySystem.getInt(38));
        this.viewListener = docViewListener;
        int n2 = 1999;
        while (n2 <= n) {
            vector.addElement("" + n2);
            ++n2;
        }
        vector2.insertElementAt(Str.getStr(218), 0);
        this.st_FILENAME = new JLabel("");
        this.st_YEAR = new JLabel(Str.getStr(11069));
        this.st_MONTH = new JLabel(Str.getStr(11070));
        this.st_BRAND = new JLabel(Str.getStr(145));
        this.cb_YEAR = new JComboBox(vector);
        this.cb_BRAND = new JComboBox(vector2);
        this.pb_REFRESH = new HotLinkLabel(Str.getStr(112));
        this.pb_HELP = new HotLinkLabel(Str.getStr(10));
        this.st_REVIEW = new JLabel(Str.getStr(11071));
        this.st_EXPIRED = new JLabel("");
        this.pb_REFRESH.showSelection(false);
        this.pb_HELP.showSelection(false);
        this.st_REVIEW.setFont(FontSystem.largeTitleFont);
        this.setBackground(Color.white);
        this.setBorder(GUISystem.loweredBorder);
        this.setLayout(null);
        this.add(this.st_REVIEW);
        this.add(this.st_YEAR);
        this.add(this.cb_YEAR);
        this.add(this.st_MONTH);
        this.add(this.st_BRAND);
        this.add(this.cb_BRAND);
        this.add(this.pb_REFRESH);
        this.add(this.pb_HELP);
        this.add(this.st_FILENAME);
        this.add(this.st_EXPIRED);
        this.cb_YEAR.addActionListener(this);
        this.pb_REFRESH.addActionListener(this);
        this.pb_HELP.addActionListener(this);
        this.cb_YEAR.setSelectedItem("" + n);
        this.refreshMonths("" + n, false);
        if (typeCategoryRec != null) {
            this.cb_BRAND.setSelectedItem(typeCategoryRec);
        }
    }
}

