/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.doc.gui;

import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.FieldListener;
import com.ibm.nzna.projects.qit.app.FontSystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.LocaleRec;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.util.QuestUtil;
import com.ibm.nzna.projects.qit.doc.DocConst;
import com.ibm.nzna.projects.qit.doc.DocFileRec;
import com.ibm.nzna.projects.qit.doc.DocLinkRec;
import com.ibm.nzna.projects.qit.doc.DocPropertyRec;
import com.ibm.nzna.projects.qit.doc.DocRec;
import com.ibm.nzna.projects.qit.doc.PublishingTagsRec;
import com.ibm.nzna.projects.qit.gui.ViewerUtil;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.Text;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.Vector;
import javax.swing.JComponent;

public class DocFieldViewer
extends JComponent
implements AppConst,
DocConst,
FieldListener {
    private static final Color lightBlue = new Color(128, 128, 192);
    private static final Color lightGray = new Color(224, 224, 224);
    private static final Color valueColor = new Color(0, 0, 150);
    private static final Dimension noShowSize = new Dimension(0, 0);
    private static final int originalHeight = 100;
    private static final int infoY = 34;
    private static final int WORD_BREAK_COUNT = 78;
    private int fieldId = 0;
    private DocRec docRec = null;
    private String[] strArray = null;
    private JComponent previewPane = null;
    private String title = "";
    private int rowHeight = 18;
    private int fontHeight = 0;
    private Dimension prefSize = new Dimension(250, 110);
    private boolean showing = true;

    public void free() {
        this.docRec = null;
        this.strArray = null;
        this.title = null;
    }

    public void setDocRec(DocRec docRec) {
        if (this.docRec != null) {
            this.docRec.removeFieldListener(this);
            this.docRec = null;
        }
        this.docRec = docRec;
        if (docRec != null) {
            docRec.addFieldListener(this);
        }
        this.setFieldId(this.fieldId);
    }

    public void setFieldId(int n) {
        this.fieldId = n;
        switch (n) {
            case 2: {
                FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(FontSystem.largeTitleFont);
                this.fontHeight = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
                this.prefSize.height = 26;
                break;
            }
            case 1003: {
                this.prefSize.height = 25 + this.rowHeight * 7;
                break;
            }
            case 1001: {
                this.prefSize.height = 25 + this.rowHeight * 5;
                break;
            }
            case 1004: {
                this.prefSize.height = 25 + this.rowHeight * 5;
                break;
            }
            case 41: 
            case 68: 
            case 1012: {
                this.prefSize.height = 21;
                break;
            }
            case 1011: {
                this.prefSize.height = 25 + this.rowHeight * 5;
                break;
            }
            case 57: {
                this.prefSize.height = 21;
                break;
            }
        }
        this.fieldChanged(this.docRec, n);
    }

    public boolean isField(int n) {
        boolean bl = false;
        switch (n) {
            case 14: 
            case 29: {
                bl = this.fieldId == 1012;
                break;
            }
            case 22: 
            case 23: {
                bl = this.fieldId == 1009;
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 15: 
            case 16: 
            case 31: {
                bl = this.fieldId == 1003;
                break;
            }
            case 13: {
                bl = this.fieldId == 1004;
                break;
            }
            case 12: {
                bl = this.fieldId == 57;
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 33: 
            case 34: {
                bl = 1011 == this.fieldId;
                break;
            }
            case 32: {
                bl = 67 == this.fieldId || 32 == this.fieldId;
                break;
            }
            default: {
                bl = n == this.fieldId;
                break;
            }
        }
        return bl;
    }

    public void setShowing(boolean bl) {
        this.showing = bl;
        this.invalidate();
    }

    public Dimension getPreferredSize() {
        if (this.showing) {
            return this.prefSize;
        }
        return noShowSize;
    }

    public Dimension getMinimumSize() {
        if (this.showing) {
            return this.prefSize;
        }
        return noShowSize;
    }

    public void fieldChanged(Object object, int n) {
        if (n == 16) {
            if (this.fieldId == 1011) {
                this.setShowing(this.docRec.getSSD());
            }
            if (this.fieldId == 41) {
                this.setShowing(this.docRec.canAttachFiles());
            }
        }
        if (object != null && this.isField(n)) {
            try {
                this.docRec = (DocRec)object;
                this.title = this.docRec.getFieldDescription(n);
                switch (this.fieldId) {
                    case 24: {
                        LocaleRec localeRec = (LocaleRec)this.docRec.getFieldData(24);
                        if (localeRec == null) {
                            this.prefSize.height = 40;
                            this.strArray = new String[1];
                            this.strArray[0] = Str.getStr(198);
                            break;
                        }
                        this.strArray = Text.formatStringLineBreaks(localeRec.getLocaleList(), 78);
                        this.prefSize.height = (this.strArray.length + 2) * this.fontHeight;
                        break;
                    }
                    case 57: {
                        this.strArray = Text.formatStringLineBreaks(((PublishingTagsRec)this.docRec.getFieldData((int)57)).eMailComments, 78);
                        this.prefSize.height = (this.strArray.length + 2) * this.fontHeight;
                        break;
                    }
                    case 68: {
                        this.strArray = Text.formatStringLineBreaks((String)this.docRec.getFieldData(68), 78);
                        this.prefSize.height = (this.strArray.length + 2) * this.fontHeight;
                        break;
                    }
                    case 1009: {
                        this.strArray = Text.formatStringLineBreaks(this.docRec.createProductStr(), 78);
                        this.prefSize.height = (this.strArray.length + 2) * this.fontHeight;
                        this.title = Str.getStr(299);
                        break;
                    }
                    case 67: {
                        if (this.docRec.getFieldData(67) != null) {
                            this.strArray = Text.formatStringLineBreaks((String)this.docRec.getFieldData(67), 78);
                            this.prefSize.height = this.strArray.length * this.fontHeight + 15;
                            break;
                        }
                        this.strArray = new String[1];
                        this.strArray[0] = "-";
                        this.prefSize.height = this.fontHeight * 3;
                        break;
                    }
                    case 1003: {
                        this.title = Str.getStr(279);
                        break;
                    }
                    case 17: {
                        this.strArray = Text.formatStringLineBreaks(this.docRec.getAllCategories(), 78);
                        this.prefSize.height = (this.strArray.length + 2) * this.fontHeight;
                        break;
                    }
                    case 32: {
                        String string = this.docRec.getOriginalComments();
                        String string2 = (String)this.docRec.getFieldData(32);
                        if (string == null) {
                            string = "";
                        }
                        if (string2 == null) {
                            string2 = "";
                        }
                        string = string + "\n" + string2;
                        this.strArray = Text.formatStringLineBreaks(string + (String)this.docRec.getFieldData(n), 78);
                        this.prefSize.height = (this.strArray.length + 2) * this.fontHeight;
                        break;
                    }
                    case 2: {
                        this.strArray = Text.formatStringLineBreaks((String)this.docRec.getFieldData(2), 50);
                        this.prefSize.height = this.strArray.length * this.fontHeight + 5;
                        break;
                    }
                    case 1001: {
                        this.title = Str.getStr(263);
                        break;
                    }
                    case 1004: {
                        this.title = Str.getStr(268);
                        break;
                    }
                    case 1012: {
                        this.prefSize.height = this.getDocLinksHeight();
                        this.title = Str.getStr(295);
                        break;
                    }
                    case 26: 
                    case 1011: {
                        this.title = Str.getStr(292);
                        if (this.docRec.getFieldData(26) != null) {
                            this.strArray = Text.formatStringLineBreaks(((DocPropertyRec)this.docRec.getFieldData((int)26)).value, 78);
                        } else {
                            this.strArray = new String[1];
                            this.strArray[0] = "-";
                        }
                        this.prefSize.height = (this.strArray.length + 2) * this.fontHeight + this.rowHeight * 5;
                        break;
                    }
                    case 41: {
                        this.prefSize.height = this.getSSDHeight();
                        break;
                    }
                }
                try {
                    this.invalidate();
                    this.previewPane = (JComponent)this.getParent();
                    if (this.previewPane != null) {
                        this.previewPane.revalidate();
                        this.repaint();
                    }
                }
                catch (Exception exception) {
                    LogSystem.log(1, exception, false);
                }
            }
            catch (Exception exception) {
                LogSystem.log(1, exception, false);
            }
        }
    }

    public void paintComponent(Graphics graphics) {
        if (this.docRec != null) {
            Dimension dimension = this.getSize();
            dimension.width -= 2;
            dimension.height -= 2;
            graphics.setColor(Color.white);
            graphics.fillRect(3, 3, dimension.width - 6, dimension.height);
            if (this.fieldId != 2 && this.title != null) {
                ViewerUtil.paintTitle(graphics, dimension, this.title);
            }
            switch (this.fieldId) {
                case 17: 
                case 24: 
                case 32: 
                case 57: 
                case 67: 
                case 68: 
                case 1009: {
                    graphics.setColor(valueColor);
                    graphics.setFont(FontSystem.textFont);
                    if (this.strArray == null) break;
                    ViewerUtil.paintMultiLine(graphics, dimension, this.fontHeight, this.strArray);
                    break;
                }
                case 1011: {
                    this.paintSSDInfo(graphics, dimension);
                    break;
                }
                case 2: {
                    int n = 0;
                    graphics.setColor(Color.black);
                    graphics.setFont(FontSystem.largeTitleFont);
                    while (n < this.prefSize.height) {
                        graphics.drawImage(ImageSystem.getImageIcon((Object)this, 36).getImage(), 0, n, this);
                        n += 50;
                    }
                    ViewerUtil.paintMultiLine(20, graphics, dimension, this.fontHeight, this.strArray);
                    break;
                }
                case 1004: {
                    this.paintPublishingTags(graphics, dimension);
                    break;
                }
                case 1003: {
                    this.paintGeneralInfo(graphics, dimension);
                    break;
                }
                case 1001: {
                    this.paintDatabaseInfo(graphics, dimension);
                    break;
                }
                case 1012: {
                    this.paintDocLinks(graphics, dimension);
                    break;
                }
                case 41: {
                    this.paintFileAttachments(graphics, dimension);
                    break;
                }
            }
            dimension = null;
        }
        this.paintChildren(graphics);
    }

    private int getDocLinksHeight() {
        int n = this.rowHeight * 6 + 40;
        try {
            if (this.docRec != null) {
                int n2;
                Vector vector = (Vector)this.docRec.getFieldData(44);
                Vector vector2 = (Vector)this.docRec.getFieldData(58);
                if (vector != null) {
                    n2 = 0;
                    int n3 = vector.size();
                    while (n2 < n3) {
                        if (((DocLinkRec)vector.elementAt(n2++)).getRecStatus() == 3) continue;
                        n += this.rowHeight;
                    }
                }
                if (vector2 != null) {
                    n2 = vector2.size();
                    n += this.rowHeight * n2;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    private int getSSDHeight() {
        Vector vector;
        int n = 100;
        if (this.docRec != null && (vector = (Vector)this.docRec.getFieldData(41)) != null) {
            int n2 = 0;
            int n3 = vector.size();
            int n4 = 50;
            while (n2 < n3) {
                if (!((DocFileRec)vector.elementAt(n2++)).valid()) continue;
                n4 += this.rowHeight;
            }
            n = n4;
        }
        return n;
    }

    private void paintDatabaseInfo(Graphics graphics, Dimension dimension) {
        int n = 8;
        int n2 = 34;
        ViewerUtil.drawDescriptValuePair(graphics, Str.getStr(454), "" + this.docRec.getExistingDocInd(), 130, n, n2, FontSystem.textFont, valueColor);
        ViewerUtil.drawDescriptValuePair(graphics, Str.getStr(264), "" + this.docRec.getDocInd(), 130, n, n2 += this.rowHeight, FontSystem.textFont, valueColor);
        n2 += this.rowHeight;
        if (this.docRec.getFieldDescription(55) != null) {
            ViewerUtil.drawDescriptValuePair(graphics, this.docRec.getFieldDescription(55), this.docRec.getFieldData(55), 130, n, n2, FontSystem.textFont, valueColor);
        } else {
            ViewerUtil.drawDescriptValuePair(graphics, "Not Assigned", this.docRec.getFieldData(55), 130, n, n2, FontSystem.textFont, valueColor);
        }
        ViewerUtil.drawDescriptValuePair(graphics, this.docRec.getFieldDescription(53), this.docRec.getFieldData(62), 130, n, n2 += this.rowHeight, FontSystem.textFont, valueColor);
        ViewerUtil.drawDescriptValuePair(graphics, this.docRec.getFieldDescription(54), this.docRec.getPrettyChangedTime(), 130, n, n2 += this.rowHeight, FontSystem.textFont, valueColor);
    }

    private void paintGeneralInfo(Graphics graphics, Dimension dimension) {
        int n = 8;
        int n2 = 34;
        ViewerUtil.drawDescriptValuePair(graphics, this.docRec.getFieldDescription(16), this.docRec.getFieldData(16), 190, n, n2, FontSystem.textFont, valueColor);
        ViewerUtil.drawDescriptValuePair(graphics, this.docRec.getFieldDescription(15), this.docRec.getFieldData(15), 190, n, n2 += this.rowHeight, FontSystem.textFont, valueColor);
        ViewerUtil.drawDescriptValuePair(graphics, this.docRec.getFieldDescription(7), this.docRec.getFieldData(7), 190, n, n2 += this.rowHeight, FontSystem.textFont, valueColor);
        ViewerUtil.drawDescriptValuePair(graphics, this.docRec.getFieldDescription(31), this.docRec.getFieldData(31), 190, n, n2 += this.rowHeight, FontSystem.textFont, valueColor);
        ViewerUtil.drawDescriptValuePair(graphics, this.docRec.getFieldDescription(3), this.docRec.getFieldData(59), 190, n, n2 += this.rowHeight, FontSystem.textFont, valueColor);
        ViewerUtil.drawDescriptValuePair(graphics, this.docRec.getFieldDescription(6), this.docRec.getFieldData(60), 190, n, n2 += this.rowHeight, FontSystem.textFont, valueColor);
        ViewerUtil.drawDescriptValuePair(graphics, this.docRec.getFieldDescription(56), this.docRec.getFieldData(56), 190, n, n2 += this.rowHeight, FontSystem.textFont, valueColor);
        n2 += this.rowHeight;
    }

    private void paintPublishingTags(Graphics graphics, Dimension dimension) {
        PublishingTagsRec publishingTagsRec = (PublishingTagsRec)this.docRec.getFieldData(13);
        int n = 8;
        int n2 = 34;
        if (publishingTagsRec != null) {
            ViewerUtil.drawDescriptValuePair(graphics, Str.getStr(270), ViewerUtil.yesNoFromBool(publishingTagsRec.webable), 130, n, n2, FontSystem.textFont, valueColor);
            ViewerUtil.drawDescriptValuePair(graphics, Str.getStr(271), ViewerUtil.yesNoFromBool(publishingTagsRec.webOnly), 130, n, n2 += this.rowHeight, FontSystem.textFont, valueColor);
            ViewerUtil.drawDescriptValuePair(graphics, Str.getStr(272), ViewerUtil.yesNoFromBool(publishingTagsRec.faxable), 130, n, n2 += this.rowHeight, FontSystem.textFont, valueColor);
            ViewerUtil.drawDescriptValuePair(graphics, Str.getStr(273), ViewerUtil.yesNoFromBool(publishingTagsRec.knowledgeBase), 130, n, n2 += this.rowHeight, FontSystem.textFont, valueColor);
            ViewerUtil.drawDescriptValuePair(graphics, Str.getStr(274), ViewerUtil.yesNoFromBool(publishingTagsRec.faq), 130, n, n2 += this.rowHeight, FontSystem.textFont, valueColor);
            n2 += this.rowHeight;
            n2 = 34;
            n = 200;
            ViewerUtil.drawDescriptValuePair(graphics, Str.getStr(275), ViewerUtil.yesNoFromBool(publishingTagsRec.hotFlash), 130, n, n2, FontSystem.textFont, valueColor);
            ViewerUtil.drawDescriptValuePair(graphics, Str.getStr(276), publishingTagsRec.flashDate, 130, n, n2 += this.rowHeight, FontSystem.textFont, valueColor);
            ViewerUtil.drawDescriptValuePair(graphics, Str.getStr(277), ViewerUtil.yesNoFromBool(publishingTagsRec.eMailable), 130, n, n2 += this.rowHeight, FontSystem.textFont, valueColor);
            ViewerUtil.drawDescriptValuePair(graphics, Str.getStr(280), publishingTagsRec.eMailableDate, 130, n, n2 += this.rowHeight, FontSystem.textFont, valueColor);
            ViewerUtil.drawDescriptValuePair(graphics, Str.getStr(278), "" + publishingTagsRec.monthsToReview, 130, n, n2 += this.rowHeight, FontSystem.textFont, valueColor);
            n2 += this.rowHeight;
        }
    }

    private void paintDocLinks(Graphics graphics, Dimension dimension) {
        int n;
        int n2;
        int n3 = 8;
        int n4 = 34;
        Vector vector = (Vector)this.docRec.getFieldData(44);
        Vector vector2 = (Vector)this.docRec.getFieldData(58);
        DocLinkRec docLinkRec = null;
        Rectangle rectangle = (Rectangle)graphics.getClip();
        graphics.setFont(FontSystem.smallTitleFont);
        graphics.setColor(Color.black);
        graphics.drawString(Str.getStr(296), n3, 34);
        graphics.drawString(Str.getStr(455), n3, n4 += this.rowHeight);
        graphics.drawString(Str.getStr(318), n3 + 90, n4);
        graphics.drawLine(n3, n4 + 4, dimension.width - 4, n4 + 4);
        n4 += this.rowHeight + 3;
        graphics.setFont(FontSystem.textFont);
        graphics.setColor(valueColor);
        if (vector != null && vector.size() > 0) {
            n2 = 0;
            n = vector.size();
            while (n2 < n) {
                docLinkRec = (DocLinkRec)vector.elementAt(n2);
                if (docLinkRec != null && docLinkRec.getRecStatus() != 3) {
                    graphics.clipRect(0, 0, 90, dimension.height);
                    graphics.drawString("" + docLinkRec.docInd, n3, n4);
                    graphics.setClip(rectangle);
                    graphics.clipRect(0, 0, dimension.width - 4, dimension.height);
                    graphics.drawString("" + docLinkRec.title, n3 + 90, n4);
                    n4 += this.rowHeight;
                    graphics.setClip(rectangle);
                }
                ++n2;
            }
        }
        ++n4;
        n4 += this.rowHeight / 2;
        graphics.setFont(FontSystem.smallTitleFont);
        graphics.setColor(Color.black);
        graphics.drawString(Str.getStr(297), n3, n4 += 5);
        graphics.drawString(Str.getStr(455), n3, n4 += this.rowHeight);
        graphics.drawString(Str.getStr(318), n3 + 90, n4);
        graphics.drawLine(n3, n4 + 4, dimension.width - 4, n4 + 4);
        n4 += this.rowHeight + 3;
        graphics.setFont(FontSystem.textFont);
        graphics.setColor(valueColor);
        if (vector2 != null && vector2.size() > 0) {
            n2 = 0;
            n = vector2.size();
            while (n2 < n) {
                docLinkRec = (DocLinkRec)vector2.elementAt(n2);
                graphics.clipRect(0, 0, 90, dimension.height);
                graphics.drawString("" + docLinkRec.docInd, n3, n4);
                graphics.setClip(rectangle);
                graphics.clipRect(0, 0, dimension.width - 4, dimension.height);
                graphics.drawString("" + docLinkRec.title, n3 + 90, n4);
                n4 += this.rowHeight;
                graphics.setClip(rectangle);
                ++n2;
            }
        }
    }

    private void paintSSDInfo(Graphics graphics, Dimension dimension) {
        String string = "";
        int n = 8;
        int n2 = 34;
        DocPropertyRec docPropertyRec = this.docRec.getProperty(3);
        string = docPropertyRec != null ? docPropertyRec.value : "";
        try {
            graphics.setColor(Color.black);
            graphics.setFont(FontSystem.smallTitleFont);
            graphics.drawString(Str.getStr(100), n, n2);
            graphics.setFont(FontSystem.defaultFont);
            graphics.setColor(valueColor);
            graphics.setFont(FontSystem.textFont);
            n2 += this.rowHeight;
            n2 += ViewerUtil.paintMultiLine(n, n2, graphics, dimension, this.fontHeight, this.strArray);
            ViewerUtil.drawDescriptValuePair(graphics, this.docRec.getFieldDescription(34), this.docRec.getFieldData(34), 160, n, n2, FontSystem.textFont, valueColor);
            ViewerUtil.drawDescriptValuePair(graphics, this.docRec.getFieldDescription(33), this.docRec.getFieldData(33), 160, n, n2 += this.rowHeight, FontSystem.textFont, valueColor);
            ViewerUtil.drawDescriptValuePair(graphics, this.docRec.getFieldDescription(27), this.docRec.getFieldData(27), 160, n, n2 += this.rowHeight, FontSystem.textFont, valueColor);
            ViewerUtil.drawDescriptValuePair(graphics, this.docRec.getFieldDescription(28), string, 160, n, n2 += this.rowHeight, FontSystem.textFont, valueColor);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void paintFileAttachments(Graphics graphics, Dimension dimension) {
        int n = 5;
        int n2 = 34;
        int n3 = 0;
        int n4 = 0;
        Vector vector = QuestUtil.getValidData((Vector)this.docRec.getFieldData(41));
        DocFileRec docFileRec = null;
        Rectangle rectangle = (Rectangle)graphics.getClip();
        graphics.setFont(FontSystem.smallTitleFont);
        graphics.setColor(Color.black);
        graphics.drawString(Str.getStr(456), n, 34);
        graphics.drawString(Str.getStr(436), n + 130, 34);
        graphics.drawString(Str.getStr(100), n + 200, 34);
        graphics.drawLine(n, 40, dimension.width - 4, 40);
        n2 += this.rowHeight + 5;
        graphics.setFont(FontSystem.textFont);
        graphics.setColor(valueColor);
        if (vector != null && vector.size() > 0) {
            n4 = vector.size();
            while (n3 < n4) {
                docFileRec = (DocFileRec)vector.elementAt(n3);
                graphics.clipRect(0, 0, 130, dimension.height);
                graphics.drawString(Text.stripPath(docFileRec.sFilename), n, n2);
                graphics.setClip(rectangle);
                graphics.clipRect(0, 0, 200, dimension.height);
                graphics.drawString("" + docFileRec.fileSize, n + 130, n2);
                graphics.setClip(rectangle);
                graphics.clipRect(0, 0, dimension.width - 4, dimension.height);
                graphics.drawString(docFileRec.descript, n + 200, n2);
                graphics.setClip(rectangle);
                n2 += this.rowHeight;
                ++n3;
            }
        }
        graphics.setClip(rectangle);
    }

    public void doLayout() {
    }

    public DocFieldViewer(DocRec docRec, int n) {
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(FontSystem.textFont);
        this.fontHeight = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
        this.setDocRec(docRec);
        this.setFieldId(n);
        this.setLayout(null);
    }
}

