/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.doc.gui;

import com.ibm.nzna.projects.common.quest.doc.DocumentFile;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.shared.util.FontUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.MemoryImageSource;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

public class DocumentFileRenderer
extends Component
implements ListCellRenderer {
    private static Color selBackground = (Color)UIManager.getDefaults().get("List.selectionBackground");
    private static Color selForeground = (Color)UIManager.getDefaults().get("List.selectionForeground");
    private static Color oddColor = new Color(240, 240, 240);
    private static Image focusImage = null;
    private static FontUtil fontUtil = null;
    private boolean selected = false;
    private boolean hasFocus = false;
    private DocumentFile file = null;
    private Dimension prefSize = new Dimension(450, 34);

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        if (object instanceof DocumentFile) {
            this.file = (DocumentFile)object;
        }
        if (n / 2 * 2 != n) {
            this.setBackground(oddColor);
        } else {
            this.setBackground(Color.white);
        }
        this.selected = bl;
        this.hasFocus = bl2;
        return this;
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle = (Rectangle)graphics.getClip();
        if (rectangle == null) {
            rectangle = new Rectangle(0, 0, this.prefSize.width, this.prefSize.height);
        }
        if (!this.selected) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            graphics.setColor(selBackground);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        if (this.file != null) {
            ImageIcon imageIcon = ImageSystem.getImageIcon((Object)this, 133);
            String string = this.file.getFilename();
            int n = rectangle.width - rectangle.x;
            if (string.indexOf(".") != -1) {
                string = string.substring(string.indexOf(".") + 1).toUpperCase();
            }
            if (string.equals("EXE") || string.equals("BAT") || string.equals("CMD")) {
                imageIcon = ImageSystem.getImageIcon((Object)this, 134);
            } else if (string.equals("PDF")) {
                imageIcon = ImageSystem.getImageIcon((Object)this, 135);
            } else if (string.equals("TXT") || string.equals("1ST") || string.equals("ME") || string.equals("DAT")) {
                imageIcon = ImageSystem.getImageIcon((Object)this, 136);
            } else if (string.equals("AVI") || string.equals("WMF") || string.equals("GIF") || string.equals("JPG") || string.equals("MPEG")) {
                imageIcon = ImageSystem.getImageIcon((Object)this, 137);
            } else if (string.equals("WAV") || string.equals("MP3") || string.equals("MP4")) {
                imageIcon = ImageSystem.getImageIcon((Object)this, 138);
            }
            if (!this.selected) {
                graphics.setColor(this.getForeground());
            } else {
                graphics.setColor(selForeground);
            }
            graphics.drawImage(imageIcon.getImage(), 5, 5, this);
            graphics.drawString(this.file.getFilename() + " (" + this.file.getSize() + " bytes)", 40, 12);
            graphics.drawString(this.file.getDescription(), 40, 28);
            if (this.hasFocus) {
                if (focusImage != null) {
                    focusImage.flush();
                }
                this.createFocusImage();
                if (focusImage != null) {
                    graphics.drawImage(focusImage, 0, 0, this);
                }
            }
        }
    }

    public Dimension getPreferredSize() {
        return this.prefSize;
    }

    private void createFocusImage() {
        if (this.prefSize.height >= 0) {
            int n;
            int n2 = 0;
            MemoryImageSource memoryImageSource = null;
            int[] nArray = new int[this.prefSize.width * this.prefSize.height];
            int n3 = -16777216;
            int n4 = n = -100;
            while (n2 < this.prefSize.width) {
                nArray[n2] = n4;
                nArray[n2 + this.prefSize.width * (this.prefSize.height - 1)] = n4;
                n2 += 2;
            }
            n2 = 0;
            while (n2 < this.prefSize.height * (this.prefSize.width - 1)) {
                nArray[n2] = n4;
                nArray[n2 + this.prefSize.width - 1] = n4;
                n2 += this.prefSize.width * 2;
            }
            memoryImageSource = new MemoryImageSource(this.prefSize.width, this.prefSize.height, nArray, 0, this.prefSize.width);
            focusImage = this.createImage(memoryImageSource);
        }
    }
}

