/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.doc.history;

import com.ibm.nzna.projects.common.quest.doc.DocumentDraft;
import com.ibm.nzna.projects.common.quest.doc.DocumentRow;
import com.ibm.nzna.projects.qit.Qit;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.DateSystem;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.bookmark.AddBookmarkDlg;
import com.ibm.nzna.projects.qit.bookmark.Bookmark;
import com.ibm.nzna.projects.qit.doc.DocConst;
import com.ibm.nzna.projects.qit.doc.docedit.DocEditPanel;
import com.ibm.nzna.projects.qit.doc.docview.DocViewListener;
import com.ibm.nzna.projects.qit.doc.docview.DocViewRec;
import com.ibm.nzna.projects.qit.doc.gui.DocumentTable;
import com.ibm.nzna.projects.qit.doc.gui.SelectDocDlg;
import com.ibm.nzna.projects.qit.doc.gui.SelectDocListener;
import com.ibm.nzna.projects.qit.doc.history.DocHistNavPanel;
import com.ibm.nzna.projects.qit.doc.history.DocHistWhatsNew;
import com.ibm.nzna.projects.qit.gui.ActionButton;
import com.ibm.nzna.projects.qit.gui.AppDefaultWin;
import com.ibm.nzna.projects.qit.gui.NavPanel;
import com.ibm.nzna.projects.qit.gui.QuestPanel;
import com.ibm.nzna.projects.qit.gui.ToolBarButton;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.util.LogSystem;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class DocHistPanel
extends JPanel
implements DocViewListener,
SelectDocListener,
QuestPanel,
ActionListener,
AppConst,
DocConst,
Runnable {
    private static final String THREAD_REFRESH_PREVIEW = "RP";
    private ToolBarButton pb_FIND = null;
    private DocEditPanel docEditPanel = null;
    private ActionButton pb_CLOSE = null;
    private ActionButton pb_RESTORE = null;
    private ActionButton pb_SELECT = null;
    private DocHistNavPanel docHistNavPanel = null;
    private JToolBar toolBar = null;
    private boolean draft = false;
    private DocumentRow documentRow = null;
    private boolean showChanges = false;
    private boolean startDraft = false;
    private int startDocInd = 0;
    private QuestPanel previousPanel = null;
    private CardLayout cardLayout = null;
    private DocumentTable documents = null;
    private DocViewRec viewRec = null;
    private AppDefaultWin parentWin = null;
    private String currentPanel = "docEditPanel";

    public boolean initialize() {
        this.pb_CLOSE = new ActionButton(Str.getStr(28), ImageSystem.getImageIcon((Object)this, 8), Str.getStr(203));
        this.pb_RESTORE = new ActionButton(Str.getStr(868), ImageSystem.getImageIcon((Object)this, 59), Str.getStr(1314));
        this.pb_SELECT = new ActionButton(Str.getStr(404), ImageSystem.getImageIcon((Object)this, 62), Str.getStr(11065));
        this.docEditPanel = new DocEditPanel();
        this.docHistNavPanel = new DocHistNavPanel(this);
        this.pb_FIND = new ToolBarButton(Str.getStr(470), ImageSystem.getImageIcon((Object)this, 7), Str.getStr(470));
        this.toolBar = new JToolBar();
        this.documents = new DocumentTable();
        this.pb_FIND.addActionListener(this);
        this.pb_CLOSE.addActionListener(this);
        this.pb_RESTORE.addActionListener(this);
        this.pb_SELECT.addActionListener(this);
        this.documents.addActionListener(this);
        this.pb_SELECT.setVisible(false);
        this.toolBar.setBorder(null);
        this.toolBar.setOpaque(false);
        this.cardLayout = new CardLayout();
        this.setLayout(this.cardLayout);
        this.toolBar.add(this.pb_FIND);
        this.add((Component)this.docEditPanel, "docEditPanel");
        this.add((Component)this.documents, "documents");
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.pb_FIND) {
            new SelectDocDlg(false).getInstance().addSelectDocListener(this);
        } else if (actionEvent.getSource() == this.documents || actionEvent.getSource() == this.pb_SELECT) {
            DocumentRow documentRow = (DocumentRow)this.documents.getSelectedItem();
            if (documentRow != null) {
                this.docHistNavPanel.setDocInd(documentRow.isDraft() ? documentRow.getDocumentInd() : documentRow.getExistingDocumentInd(), documentRow.isDraft());
                this.setPanel("docEditPanel");
                this.docEditPanel.setDocument(null);
                this.docHistNavPanel.showTab("find");
            }
        } else if (actionEvent.getSource() == this.pb_CLOSE) {
            GUISystem.getParentDefWin(this).closePanel(this, this.previousPanel);
        } else if (actionEvent.getSource() == this.pb_RESTORE) {
            this.restore();
        }
    }

    public void refresh() {
        if (this.currentPanel.equals("docEditPanel")) {
            new Thread((Runnable)this, THREAD_REFRESH_PREVIEW).start();
        } else {
            this.docHistNavPanel.getDocViewPanel().refreshCurrentView();
        }
    }

    protected void refreshDocs() {
        this.viewRec.refresh();
    }

    public void run() {
        String string = Thread.currentThread().getName();
        Qit.setEnabled(false);
        try {
            if (string.equals(THREAD_REFRESH_PREVIEW)) {
                this.refreshPreview();
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
        }
        Qit.setEnabled(true);
    }

    public void selectDocComplete(Vector vector) {
        if (vector != null && vector.size() > 0) {
            System.out.println("Select Doc Complete!");
            if (vector.elementAt(0) instanceof DocumentRow) {
                DocumentRow documentRow = (DocumentRow)vector.elementAt(0);
                System.out.println("instance of document row");
                if (!documentRow.isDraft()) {
                    this.docHistNavPanel.setDocInd(documentRow.getDocumentInd(), false);
                } else {
                    this.docHistNavPanel.setDocInd(documentRow.getDocumentInd(), true);
                }
            } else if (vector.elementAt(0) instanceof Bookmark) {
                Bookmark bookmark = (Bookmark)vector.elementAt(0);
                System.out.println("instance of bookmark");
                if (bookmark.getBookmarkType() == 3) {
                    this.docHistNavPanel.setDocInd((Integer)bookmark.getObject(), false);
                }
            } else {
                System.out.println("UNknown instance!");
            }
        }
    }

    public void setDocument(DocumentRow documentRow) {
        this.documentRow = documentRow;
        if (documentRow != null) {
            this.draft = documentRow.isDraft();
            new Thread((Runnable)this, THREAD_REFRESH_PREVIEW).start();
        }
    }

    private void refreshPreview() {
        AppDefaultWin appDefaultWin = GUISystem.getParentDefWin(this);
        if (this.documentRow != null) {
            int n = -1;
            appDefaultWin.setStatus(14);
            n = this.documentRow.readDocument(false);
            if (n == 0) {
                this.docEditPanel.setDocument(this.documentRow.getDocument());
                this.docEditPanel.setEnabled(false);
            } else {
                LogSystem.log(1, "Document History could not read document. rc:" + n);
                GUISystem.printBox(7, 202);
            }
        }
        appDefaultWin.setStatus(Str.getStr(1582), 2);
    }

    public void panelDeselected() {
        GUISystem.getParentDefWin(this).removeToolbarButton(this.toolBar);
    }

    public void panelSelected() {
        GUISystem.getParentDefWin(this).addToolbarButton(this.toolBar, 1);
    }

    public boolean copyText() {
        return false;
    }

    public boolean cutText() {
        return false;
    }

    public boolean pasteText() {
        return false;
    }

    public JComponent getJComponent() {
        return this;
    }

    public NavPanel getDefaultNavPanel() {
        return this.docHistNavPanel;
    }

    public boolean stop() {
        this.panelDeselected();
        this.removeAll();
        return Qit.getEnabled();
    }

    public boolean shutdown() {
        return Qit.getEnabled();
    }

    public void start() {
        this.parentWin = GUISystem.getParentDefWin(this);
        this.parentWin.addActionComponent(this, this.pb_CLOSE);
        this.parentWin.addActionComponent(this, this.pb_RESTORE);
        this.parentWin.addActionComponent(this, this.pb_SELECT);
        this.parentWin.addToolbarButton(this.toolBar, 1);
        if (this.startDocInd != 0) {
            this.docHistNavPanel.setDocInd(this.startDocInd, this.startDraft);
        }
        new DocHistWhatsNew(this);
    }

    public ImageIcon getIcon() {
        return ImageSystem.getImageIcon((Object)this, 125);
    }

    public String getName() {
        return Str.getStr(888);
    }

    public boolean bookmark() {
        if (this.documentRow != null) {
            Bookmark bookmark = new Bookmark();
            bookmark.setDescript(this.documentRow.getTitle());
            bookmark.setObject(new Integer(this.documentRow.getExistingDocumentInd()), 3);
            bookmark.updateRecStatus(2);
            new AddBookmarkDlg((Frame)GUISystem.getParentDefWin(this), bookmark);
        } else {
            GUISystem.printBox((Frame)GUISystem.getParentDefWin(this), Str.getStr(7), Str.getStr(1028));
        }
        return false;
    }

    private void restore() {
        GUISystem.getParentDefWin(this).setStatus(1315);
        if (this.documentRow != null) {
            DocumentDraft documentDraft = (DocumentDraft)this.documentRow.getDocument();
            SQLMethod sQLMethod = new SQLMethod(1, "DocHistPanel.restore", 5);
            boolean bl = false;
            try {
                Statement statement = sQLMethod.createStatement();
                String string = null;
                if (statement != null) {
                    ResultSet resultSet = statement.executeQuery("SELECT DBUSER, CHANGEDTIME " + "FROM QUEST.DOCUMENTS " + "WHERE STOPDATE IS NULL AND " + "EXISTINGDOCIND = " + this.documentRow.getExistingDocumentInd());
                    if (resultSet.next()) {
                        String string2 = resultSet.getString(1).trim();
                        String string3 = DateSystem.prettyDateFromStamp(resultSet.getString(2).trim());
                        GUISystem.printBox(Str.getStr(7), Str.getStr(1316) + " " + UserSystem.getNameFromUserId(string2) + " " + Str.getStr(127) + " " + string3);
                        bl = false;
                    } else {
                        bl = true;
                    }
                    resultSet.close();
                    if (bl) {
                        int n = 0;
                        resultSet = statement.executeQuery("SELECT COMMENT " + "FROM QUEST.DOCUMENTS " + "WHERE DOCIND = " + this.documentRow.getDocumentInd());
                        string = resultSet.next() ? resultSet.getString(1).trim() : "";
                        resultSet.close();
                        string = string + "\n<" + Str.getStr(1318) + " " + Str.getStr(1319) + " " + UserSystem.getUserName() + " " + Str.getStr(127) + " " + DateSystem.getDate(2) + ">\n";
                        if (documentDraft.getWorkRequired() == 3) {
                            documentDraft.setWorkRequired(2);
                        }
                        statement.executeUpdate("UPDATE QUEST.DOCUMENTS " + "SET   WORKIND     = " + n + ", " + "      STOPDATE    = NULL, " + "      COMMENT     = '" + string + "', " + "      REQUESTOR   = '" + UserSystem.getUserId() + "', " + "      DBUSER      = '" + UserSystem.getUserId() + "', " + "      CHANGEDTIME = CURRENT TIMESTAMP " + "WHERE DOCIND      = " + this.documentRow.getDocumentInd());
                        GUISystem.printBox(7, 1317);
                    }
                }
            }
            catch (Exception exception) {
                sQLMethod.rollBack();
                LogSystem.log(1, exception, false);
                GUISystem.printBox(6, 202);
            }
            sQLMethod.close();
        } else {
            GUISystem.printBox(7, 358);
        }
        GUISystem.getParentDefWin(this).setStatus(null);
    }

    protected void setPanel(String string) {
        if (string.equals("documents")) {
            this.pb_RESTORE.setVisible(false);
            this.pb_SELECT.setVisible(true);
        } else if (string.equals("docEditPanel")) {
            this.pb_RESTORE.setVisible(true);
            this.pb_SELECT.setVisible(false);
        }
        this.cardLayout.show(this, string);
        this.currentPanel = string;
    }

    public void docViewStarted(DocViewRec docViewRec) {
        this.viewRec = docViewRec;
        this.parentWin.setStatus(142);
    }

    public void docViewStopped(DocViewRec docViewRec) {
        this.documents.setDocuments(docViewRec.getResults());
        this.setPanel("documents");
        this.viewRec = docViewRec;
        this.parentWin.setStatus(null);
    }

    public DocHistPanel(QuestPanel questPanel) {
        this.previousPanel = questPanel;
    }

    public DocHistPanel(int n, boolean bl, QuestPanel questPanel) {
        this.startDraft = bl;
        this.startDocInd = n;
        this.previousPanel = questPanel;
    }
}

