/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.exporter;

import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.exporter.ExportDlg;
import com.ibm.nzna.projects.qit.exporter.ExportRec;
import com.ibm.nzna.projects.qit.gui.AppDefaultWin;
import com.ibm.nzna.shared.gui.MultiListRow;
import com.ibm.nzna.shared.gui.MutableTreeWrapper;
import com.ibm.nzna.shared.gui.StringTreeNode;
import com.ibm.nzna.shared.util.LogSystem;
import java.awt.Frame;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;

public class Export
implements Runnable,
AppConst {
    private static final String TAB_STR = new Character('\t').toString();
    private ExportRec exportRec = new ExportRec();
    private AppDefaultWin parentWin = null;
    private Frame tempFrame = null;

    public void run() {
        try {
            if (this.parentWin != null) {
                new ExportDlg((Frame)this.parentWin, this.exportRec);
            } else {
                new ExportDlg(this.tempFrame, this.exportRec);
            }
            if (this.exportRec.getExportType() > 0) {
                File file = new File(this.exportRec.getFilename());
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                if (file != null && fileOutputStream != null) {
                    this.runExport(fileOutputStream);
                    fileOutputStream.close();
                } else {
                    GUISystem.printBox(7, 1201);
                }
            }
        }
        catch (Exception exception) {
            GUISystem.printBox(7, 1200);
            LogSystem.log(1, exception, false);
        }
    }

    private void setStatus(int n) {
        this.setStatus(Str.getStr(n));
    }

    private void setStatus(String string) {
        if (this.parentWin != null) {
            this.parentWin.setStatus(string);
        }
    }

    private void runExport(FileOutputStream fileOutputStream) {
        Vector vector = this.exportRec.getData();
        int n = 0;
        int n2 = vector.size();
        this.setStatus(14);
        try {
            if (this.parentWin != null) {
                this.parentWin.setValueMax(n2);
                this.parentWin.setValue(0);
            }
            while (n < n2) {
                this.writeRow(vector.elementAt(n), fileOutputStream);
                ++n;
                if (this.parentWin == null) continue;
                this.parentWin.setValue(n);
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
        }
        this.setStatus(null);
        if (this.parentWin != null) {
            this.parentWin.setValue(0);
        }
        GUISystem.printBox(7, 1203);
    }

    private void writeRow(Object object, FileOutputStream fileOutputStream) throws IOException {
        if (object instanceof StringTreeNode) {
            object = ((StringTreeNode)object).getData();
        } else if (object instanceof MutableTreeWrapper) {
            object = ((MutableTreeWrapper)object).getDataObject();
        }
        if (object instanceof MultiListRow) {
            MultiListRow multiListRow = (MultiListRow)object;
            int n = 0;
            String string = null;
            while (n < this.exportRec.getColumnCount()) {
                if (multiListRow.getColumnData(n) != null && multiListRow.getColumnData(n) instanceof String) {
                    string = (String)multiListRow.getColumnData(n);
                    this.writeColumn(fileOutputStream, string);
                }
                ++n;
            }
            fileOutputStream.write(new String("\n").getBytes());
        }
    }

    private void writeColumn(FileOutputStream fileOutputStream, String string) throws IOException {
        String string2 = null;
        switch (this.exportRec.getExportType()) {
            case 3: {
                string2 = string + "   ";
                break;
            }
            case 2: {
                string2 = string + ",";
                break;
            }
            case 1: {
                string2 = string + TAB_STR;
            }
        }
        if (string2 != null) {
            fileOutputStream.write(string2.getBytes());
        }
    }

    public Export(AppDefaultWin appDefaultWin, Vector vector) {
        this.exportRec.setData(vector);
        this.parentWin = appDefaultWin;
        if (appDefaultWin != null) {
            this.tempFrame = new Frame();
        }
        new Thread(this).start();
    }
}

