/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.ftp;

import com.ibm.nzna.projects.common.quest.Constants;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.MainWindow;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.shared.ftp.FTP.Ftp;
import com.ibm.nzna.shared.ftp.FTP.FtpListener;
import com.ibm.nzna.shared.ftp.FTP.ReplyEvent;
import com.ibm.nzna.shared.ftp.FTP.StreamGet;
import com.ibm.nzna.shared.ftp.FTP.StreamPut;
import com.ibm.nzna.shared.ftp.FTP.TransferEvent;
import com.ibm.nzna.shared.ftp.FtpError;
import com.ibm.nzna.shared.util.FileUtil;
import com.ibm.nzna.shared.util.LogSystem;
import java.io.File;

public class FTPSite
implements FtpListener,
AppConst {
    public static final int FTPSITE_FILES_PROD = 1;
    public static final int FTPSITE_FILES_TEMP = 2;
    public static final int FTPSITE_IMAGES_PROD = 3;
    public static final int FTPSITE_IMAGES_TEMP = 4;
    private String host = null;
    private String user = null;
    private String password = null;
    private String localDir = "";
    private String remoteDir = "";
    private Ftp ftp = null;

    public String getHost() {
        return this.host;
    }

    public boolean connect() {
        boolean bl = false;
        try {
            this.ftp.connect(this.host);
            LogSystem.log(1, "Connected To Server:" + this.host);
            bl = true;
        }
        catch (Exception exception) {
            this.showError(Str.getStr(244) + this.host);
            LogSystem.log(1, "FTPSite - connect ( " + this.host + " )");
            LogSystem.log(1, exception);
        }
        return bl;
    }

    public boolean login() {
        boolean bl = false;
        try {
            LogSystem.log(1, "logging into server:" + this.host);
            this.ftp.login(this.user, this.password);
            this.setBinary();
            this.ftp.cd(this.remoteDir);
            LogSystem.log(1, "Changing Directory to " + this.remoteDir);
            bl = this.setLocalDir(this.localDir);
        }
        catch (Exception exception) {
            this.showError(Str.getStr(245));
            LogSystem.log(1, "FTPSite, Loggin in with user " + this.user);
            LogSystem.log(1, exception);
        }
        return bl;
    }

    public boolean move(String string) {
        boolean bl = false;
        try {
            if (this.put(string)) {
                FileUtil.deleteFile(string);
            }
            bl = true;
        }
        catch (Exception exception) {
            this.showError(Str.getStr(246) + string);
            LogSystem.log(1, exception);
        }
        return bl;
    }

    public boolean delete(String string) {
        boolean bl = false;
        try {
            this.ftp.delete(string);
            FileUtil.deleteFile(string);
            bl = true;
        }
        catch (Exception exception) {
            this.showError(Str.getStr(247) + string);
            LogSystem.log(1, "FTPSite - delete ( " + string + " )");
            LogSystem.log(1, exception);
        }
        return bl;
    }

    public boolean equals(FTPSite fTPSite) {
        boolean bl = false;
        try {
            if (fTPSite.host.equals(this.host) && fTPSite.user.equals(this.user) && fTPSite.remoteDir.equals(this.remoteDir)) {
                bl = true;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return bl;
    }

    public boolean put(String string) {
        boolean bl = false;
        try {
            new StreamPut(this.ftp, new File(this.localDir + string), string, false).start();
            LogSystem.log(1, "Put File:" + string + "   From Local:" + this.localDir + string);
            bl = true;
        }
        catch (FtpError ftpError) {
            int n = ftpError.getReplyCode();
            if (n == 550) {
                bl = true;
            } else if (n == 452) {
                GUISystem.printBox(Str.getStr(6), Str.getStr(243));
            } else {
                LogSystem.log(1, "FTP PUT Returned an error code of:" + n);
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
        return bl;
    }

    public boolean get(String string) {
        boolean bl = false;
        try {
            LogSystem.log(1, "Getting File:" + string + "   To Local:" + this.localDir + string);
            new StreamGet(this.ftp, new File(this.localDir + "ftmp_" + string), string).start();
            FileUtil.copyFile(this.localDir + "ftmp_" + string, this.localDir + string);
            FileUtil.deleteFile(this.localDir + "ftmp_" + string);
            LogSystem.log(1, "Get File returning TRUE");
            bl = FileUtil.exists(this.localDir + string);
        }
        catch (FtpError ftpError) {
            int n = ftpError.getReplyCode();
            if (n == 550) {
                try {
                    LogSystem.log(1, "Deleting file: " + this.localDir + "ftmp_" + string + " Because 550 Error Code was received");
                    FileUtil.deleteFile(this.localDir + "ftmp_" + string);
                }
                catch (Exception exception) {
                    GUISystem.printBox(Str.getStr(7), Str.getStr(1043));
                    LogSystem.log(1, exception, false);
                }
                bl = true;
            }
            ftpError.printStackTrace();
            LogSystem.log(1, "FTP GET Returned an error code of:" + n);
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
        return bl;
    }

    public String getRemoteDir() {
        try {
            return this.ftp.pwd();
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
            return "";
        }
    }

    public boolean setBinary() {
        boolean bl = false;
        try {
            this.ftp.setType('I');
            LogSystem.log(1, "FTP Set to Binary");
            bl = true;
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
        return bl;
    }

    public boolean setAscii() {
        try {
            this.ftp.setType('A');
            LogSystem.log(1, "FTP Set to ASCII");
            return true;
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
            return false;
        }
    }

    public boolean disconnect() {
        boolean bl = false;
        try {
            this.ftp.disconnect();
            bl = true;
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
        return bl;
    }

    public boolean setRemoteDir(String string) {
        boolean bl = false;
        try {
            if (string != null) {
                this.remoteDir = string;
                this.ftp.cd(string);
                bl = true;
            }
        }
        catch (Exception exception) {
            this.showError(Str.getStr(248));
            LogSystem.log(1, "FTPSite, setRemoteDir to " + string + "  on host:" + this.host);
            LogSystem.log(1, exception);
        }
        return false;
    }

    public boolean setLocalDir(String string) {
        boolean bl = false;
        if (string != null) {
            this.localDir = string;
            if (!this.localDir.endsWith(File.separator)) {
                this.localDir = this.localDir + File.separator;
            }
            bl = true;
        }
        return bl;
    }

    public static FTPSite getFTPSite(int n) {
        FTPSite fTPSite = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        string3 = PropertySystem.getString(30);
        string2 = null;
        switch (n) {
            case 2: {
                string = Constants.getStrConst("IT_FILEHOSTTEMP");
                string4 = Constants.getStrConst("IT_FILELOCTEMP");
                if (string == null) {
                    string = Constants.getStrConst("IT_FILEHOST");
                    string4 = Constants.getStrConst("IT_FILELOC");
                }
                string2 = "quest";
                string5 = "hgra2l";
                fTPSite = new FTPSite(string, string2, string3, string4, string5);
                break;
            }
            case 1: {
                string = Constants.getStrConst("IT_FILEHOST");
                string4 = Constants.getStrConst("IT_FILELOC");
                string2 = "quest";
                string5 = "hgra2l";
                fTPSite = new FTPSite(string, string2, string3, string4, string5);
                break;
            }
            case 4: {
                string = Constants.getStrConst("IT_IMAGEHOSTTEMP");
                string4 = Constants.getStrConst("IT_IMAGELOCTEMP");
                if (string == null) {
                    string = Constants.getStrConst("IT_IMAGEHOST");
                    string4 = Constants.getStrConst("IT_IMAGELOC");
                }
                string2 = "quest";
                string5 = "hgra2l";
                fTPSite = new FTPSite(string, string2, string3, string4, string5);
                break;
            }
            case 3: {
                string = Constants.getStrConst("IT_IMAGEHOST");
                string4 = Constants.getStrConst("IT_IMAGELOC");
                string2 = "quest";
                string5 = "k1ngarthur";
                fTPSite = new FTPSite(string, string2, string3, string4, string5);
                break;
            }
        }
        return fTPSite;
    }

    public boolean delete(String string, boolean bl) {
        boolean bl2 = false;
        try {
            this.ftp.delete(string);
            if (bl) {
                FileUtil.deleteFile(string);
            }
            bl2 = true;
        }
        catch (FtpError ftpError) {
            int n = ftpError.getReplyCode();
            if (n == 550) {
                bl2 = true;
            }
            LogSystem.log(1, "FTP PUT Returned an error code of:" + n);
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
        return bl2;
    }

    public String getLocalDir() {
        return this.localDir;
    }

    public void ftpReply(ReplyEvent replyEvent) {
        MainWindow.getInstance().setStatus(replyEvent.getReply().getMessage());
    }

    public void transferEnded(TransferEvent transferEvent) {
    }

    public void transferProgress(TransferEvent transferEvent) {
    }

    public void transferStarted(TransferEvent transferEvent) {
    }

    public String[] list() {
        try {
            return this.ftp.list();
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
            return null;
        }
    }

    public String[] list(String string) {
        try {
            return this.ftp.list(string);
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
            return null;
        }
    }

    private void showError(String string) {
        GUISystem.printBox(Str.getStr(6), string);
    }

    public FTPSite(String string, String string2, String string3, String string4, String string5) {
        this.host = string;
        this.user = string2;
        this.localDir = string3;
        this.remoteDir = string4;
        this.password = string5;
        if (this.localDir == null) {
            this.localDir = "";
        }
        if (this.remoteDir == null) {
            this.remoteDir = "";
        }
        this.ftp = new Ftp();
        this.ftp.addFtpListener(this);
    }
}

