/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.gui;

import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.PropertyListener;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.gui.AppDefaultWin;
import com.ibm.nzna.projects.qit.gui.ApplicationTitlePanel;
import com.ibm.nzna.projects.qit.gui.NavHoldPanel;
import com.ibm.nzna.projects.qit.gui.NavPanel;
import com.ibm.nzna.projects.qit.gui.NavPanelHeader;
import com.ibm.nzna.projects.qit.gui.QuestPanel;
import com.ibm.nzna.shared.gui.AntiAliasPanel;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.WinUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JSplitPane;

public class ApplicationPanel
extends AntiAliasPanel
implements PropertyListener,
AppConst,
ActionListener {
    private static final Color darkGray = new Color(128, 128, 128);
    private static int GID = 1;
    private JSplitPane splitPane = null;
    private NavPanel current_NavComp = null;
    private NavHoldPanel navHoldPanel = null;
    private QuestPanel questPanel = null;
    private Vector navPanelVec = null;
    private ApplicationTitlePanel titlePane = null;
    private boolean skinned = false;
    private int id = ++GID;

    public ApplicationTitlePanel getTitlePanel() {
        return this.titlePane;
    }

    public void setPreferredNavPanelSize() {
        int n = this.splitPane.getDividerLocation();
        if (n == 0) {
            n = 200;
        } else if (n < 25) {
            n = 25;
        }
    }

    public void doLayout() {
        try {
            Dimension dimension = this.getSize();
            super.doLayout();
            this.titlePane.setBounds(0, 5, dimension.width - 1, 25);
            if (this.splitPane != null) {
                this.splitPane.setBounds(0, 32, dimension.width - 1, dimension.height - 33);
            } else {
                this.questPanel.getJComponent().setBounds(0, 32, dimension.width - 1, dimension.height - 33);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setNavPanelWidth(int n) {
        if (this.splitPane != null) {
            this.splitPane.setDividerLocation(n);
        }
    }

    public void setContentPanel(QuestPanel questPanel) {
        if (this.splitPane != null) {
            this.splitPane.add((Component)questPanel.getJComponent(), "right");
        } else {
            this.add(questPanel.getJComponent());
        }
        this.questPanel = questPanel;
        this.titlePane.setTitle(questPanel.getName());
    }

    public void setNavPanel(NavPanel navPanel) {
        if (navPanel != null) {
            this.splitPane = new JSplitPane(1);
            this.splitPane.setBorder(null);
            if (this.skinned) {
                this.splitPane.setDividerSize(1);
            } else {
                this.splitPane.setDividerSize(3);
            }
            if (this.questPanel != null) {
                this.remove(this.questPanel.getJComponent());
                this.add(this.splitPane);
                this.splitPane.add((Component)this.questPanel.getJComponent(), "right");
            }
            if (this.navPanelVec == null) {
                this.navPanelVec = new Vector(1, 1);
            }
            this.navPanelVec.addElement(navPanel);
            if (this.current_NavComp != null) {
                this.navHoldPanel.remove(navPanel.getJComponent());
            } else {
                this.initializeNavHoldPanel();
            }
            navPanel.initialize();
            this.setPreferredNavPanelSize();
            this.current_NavComp = navPanel;
            this.navHoldPanel.addNavPanel(navPanel);
        }
    }

    private void initializeNavHoldPanel() {
        NavPanelHeader navPanelHeader = new NavPanelHeader();
        this.navHoldPanel = new NavHoldPanel();
        this.navHoldPanel.addNavPanelHeader(navPanelHeader);
        navPanelHeader.addActionListener(this);
        navPanelHeader.setNavPanel(this.navHoldPanel);
        this.splitPane.add((Component)this.navHoldPanel, "left");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("NAV_POPOUT")) {
            this.popOutNavPanel();
        } else if (actionEvent.getActionCommand().equals("NAV_CLOSE")) {
            this.closeNavPanel();
        }
    }

    public boolean close() {
        AppDefaultWin appDefaultWin = GUISystem.getParentDefWin(this);
        boolean bl = false;
        if (this.questPanel != null) {
            if (this.questPanel.stop()) {
                if (this.navPanelVec != null) {
                    int n = 0;
                    int n2 = this.navPanelVec.size();
                    NavPanel navPanel = null;
                    while (n < n2) {
                        navPanel = (NavPanel)this.navPanelVec.elementAt(n);
                        if (navPanel != null) {
                            navPanel.stop();
                            if (this.splitPane != null) {
                                this.splitPane.remove(navPanel.getJComponent());
                            }
                        }
                        ++n;
                    }
                }
                if (this.navHoldPanel != null) {
                    this.navHoldPanel.free();
                }
                if (this.splitPane != null) {
                    this.remove(this.splitPane);
                }
                PropertySystem.removePropertyListener(9, this);
                PropertySystem.removePropertyListener(82, this);
                bl = true;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    public boolean containsQuestPanel(QuestPanel questPanel) {
        return this.questPanel == questPanel;
    }

    public boolean containsNavPanel(NavPanel navPanel) {
        boolean bl = false;
        if (this.navPanelVec != null) {
            int n = 0;
            int n2 = this.navPanelVec.size();
            while (!bl && n < n2) {
                bl = (NavPanel)this.navPanelVec.elementAt(n) == navPanel;
                ++n;
            }
        }
        return bl;
    }

    public void popOutNavPanel() {
        try {
            if (this.current_NavComp != null) {
                Dimension dimension = this.current_NavComp.getJComponent().getSize();
                AppDefaultWin appDefaultWin = new AppDefaultWin();
                Insets insets = appDefaultWin.getInsets();
                this.navHoldPanel.remove(this.current_NavComp.getJComponent());
                this.splitPane.remove(this.navHoldPanel);
                this.navHoldPanel.free();
                this.navHoldPanel = null;
                appDefaultWin.getContentPane().setLayout(new BorderLayout(0, 0));
                appDefaultWin.getContentPane().add(this.current_NavComp.getJComponent());
                appDefaultWin.setSize(dimension.width + insets.left + insets.right, dimension.height + insets.top + insets.bottom);
                WinUtil.centerChildInParent(appDefaultWin, GUISystem.getParentDefWin(this));
                appDefaultWin.setVisible(true);
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
    }

    public void closeNavPanel() {
        try {
            if (this.current_NavComp != null) {
                this.current_NavComp.stop();
                this.navHoldPanel.remove(this.current_NavComp.getJComponent());
                if (this.current_NavComp != this.questPanel.getDefaultNavPanel()) {
                    this.current_NavComp = this.questPanel.getDefaultNavPanel();
                    this.navHoldPanel.addNavPanel(this.current_NavComp);
                } else {
                    this.splitPane.remove(this.navHoldPanel);
                    this.navHoldPanel.free();
                    this.navHoldPanel = null;
                    this.current_NavComp = null;
                }
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
    }

    public int getNavPanelWidth() {
        return this.splitPane.getDividerLocation();
    }

    public QuestPanel getQuestPanel() {
        return this.questPanel;
    }

    public void paintComponent(Graphics graphics) {
        Dimension dimension = this.getSize();
        super.paintComponent(graphics);
        graphics.setColor(darkGray);
        graphics.drawLine(0, 0, dimension.width, 0);
        graphics.setColor(Color.white);
        graphics.drawLine(0, 1, dimension.width, 1);
    }

    public void addActionComponent(JComponent jComponent) {
        this.titlePane.addComponent(jComponent);
    }

    protected void removeActionComponent(JComponent jComponent) {
        this.titlePane.removeComponent(jComponent);
    }

    public void panelDeselected() {
        if (this.questPanel != null) {
            this.questPanel.panelDeselected();
        }
    }

    public void propertyChanged(int n, Object object) {
        if (n == 9) {
            this.skinned = (Boolean)object;
            this.revalidate();
            if (this.skinned) {
                this.splitPane.setDividerSize(1);
            } else {
                this.splitPane.setDividerSize(3);
            }
        }
        this.setAntiAlias(PropertySystem.getBool(82));
    }

    public void finalize() {
        try {
            WinUtil.finalizeComponents(this);
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean equals(Object object) {
        if (object instanceof Integer) {
            return (Integer)object == this.id;
        }
        return super.equals(object);
    }

    public int getId() {
        return this.id;
    }

    public ApplicationPanel() {
        this.titlePane = new ApplicationTitlePanel("");
        this.skinned = PropertySystem.getBool(9);
        this.setLayout(null);
        PropertySystem.addPropertyListener(9, this);
        PropertySystem.addPropertyListener(82, this);
        this.setAntiAlias(PropertySystem.getBool(82));
        this.add(this.titlePane);
    }
}

