/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.gui;

import com.ibm.nzna.projects.qit.app.EntrySystem;
import com.ibm.nzna.shared.util.CDate;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextField;

public class DateEntryField
extends JTextField
implements ActionListener,
FocusListener {
    private void init() {
        this.setDocument(EntrySystem.getDateMask(this));
        this.addActionListener(this);
        this.addFocusListener(this);
    }

    public void setText(String string) {
        if (CDate.checkDate(string, 2) == 0) {
            super.setText(CDate.createDate(CDate.parse(string, 7, 2), CDate.parse(string, 8, 2), CDate.parse(string, 9, 2), 0, 0, 0, 13));
        } else {
            super.setText("           ");
        }
    }

    public String getText() {
        String string = super.getText();
        this.formatDate();
        if (this.dateCorrect()) {
            return CDate.createDate(CDate.parse(string, 7, 13), CDate.parse(string, 8, 13), CDate.parse(string, 9, 13), 0, 0, 0, 2);
        }
        return null;
    }

    private void formatDate() {
        String string = super.getText().trim();
        String string2 = CDate.format4DigitYear(string, 13);
        if (string2 != null) {
            super.setText(string2);
        }
    }

    public boolean dateCorrect() {
        return CDate.checkDate(super.getText(), 13) == 0;
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        this.formatDate();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.formatDate();
    }

    public DateEntryField() {
        this.init();
    }

    public DateEntryField(String string) {
        this.init();
        this.setText(string);
    }
}

