/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.gui;

import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.gui.AppDefaultWin;
import com.ibm.nzna.projects.qit.gui.ApplicationPanel;
import com.ibm.nzna.projects.qit.gui.QuestPanel;
import com.ibm.nzna.shared.util.FontUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class FocusButton
extends JPanel
implements AppConst,
ActionListener,
MouseListener {
    private static final Color lightBlue = new Color(0, 0, 230);
    private String focusComponentTitle = null;
    private String labelText = null;
    private ImageIcon labelIcon = null;
    private AppDefaultWin parentWin = null;
    private boolean mouseOver = false;
    private ApplicationPanel focusPanel = null;
    private boolean workspacePanel = false;
    private boolean initialized = false;
    private boolean hasFocus = false;
    private int iconWidth = 0;
    private int closeIconWidth = 0;
    private int labelTextWidth = 0;
    private Dimension prefSize = new Dimension(150, GUISystem.getRowHeight() + 2);
    private ImageIcon closeIcon = null;
    private Font currentFont = (Font)UIManager.getDefaults().get("Button.font");

    private void initialize() {
        this.closeIcon = ImageSystem.getImageIcon((Object)this, 4);
        this.closeIconWidth = this.closeIcon.getImage().getWidth(this) + 5;
        this.addMouseListener(this);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.workspacePanel = this.focusComponentTitle.indexOf(Str.getStr(110)) >= 0;
        this.initialized = true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseOver = true;
        this.invalidate();
        this.repaint();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.mouseOver = false;
        this.invalidate();
        this.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.parentWin == null) {
            this.parentWin = GUISystem.getParentDefWin(this);
        }
        if (this.parentWin != null) {
            Dimension dimension = this.getSize();
            Point point = mouseEvent.getPoint();
            if (point.x > dimension.width - this.closeIconWidth) {
                this.parentWin.closePanel(this.focusPanel, this, true);
            } else {
                this.parentWin.setPanelFocus(this.focusComponentTitle, this.focusPanel);
            }
        }
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public Dimension getPreferredSize() {
        int n = this.iconWidth + this.labelTextWidth + this.closeIconWidth + 8;
        this.prefSize.width = n < 100 ? 100 : 150;
        return this.prefSize;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    protected boolean contains(QuestPanel questPanel) {
        return this.focusPanel.getQuestPanel() == questPanel;
    }

    protected boolean contains(ApplicationPanel applicationPanel) {
        return this.focusPanel == applicationPanel;
    }

    protected void free() {
        this.focusComponentTitle = null;
        this.parentWin = null;
        this.focusPanel = null;
    }

    public String getFocusApplicationPanelTitle() {
        return this.focusComponentTitle;
    }

    public ApplicationPanel getFocusApplicationPanel() {
        return this.focusPanel;
    }

    public void setFocus(boolean bl) {
        this.hasFocus = bl;
        this.invalidate();
        this.repaint();
    }

    public void setText(String string) {
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.currentFont);
        this.labelText = string;
        if (string.indexOf(Str.getStr(110)) != -1) {
            this.workspacePanel = true;
        }
        this.labelTextWidth = fontMetrics.stringWidth(string);
        if (this.initialized) {
            this.repaint();
        }
    }

    public void setIcon(ImageIcon imageIcon) {
        this.labelIcon = imageIcon;
        this.iconWidth = this.labelIcon.getImage().getWidth(this);
        if (this.initialized) {
            this.repaint();
        }
    }

    public void paintComponent(Graphics graphics) {
        Dimension dimension = this.getSize();
        int n = 3;
        super.paintComponent(graphics);
        if (this.hasFocus) {
            try {
                graphics.setColor(new Color(this.getBackground().getRed() + 30, this.getBackground().getGreen() + 30, this.getBackground().getBlue() + 30));
            }
            catch (Exception exception) {
                // empty catch block
            }
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            graphics.setColor(lightBlue);
        } else {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            graphics.setColor(Color.black);
        }
        if (this.labelIcon != null) {
            graphics.drawImage(this.labelIcon.getImage(), n, dimension.height / 2 - this.labelIcon.getImage().getHeight(this) / 2, this);
            n += this.iconWidth + 2;
        }
        if (this.labelText != null) {
            Shape shape = graphics.getClip();
            graphics.setClip(new Rectangle(0, 0, dimension.width - this.iconWidth - 2, dimension.height));
            graphics.drawString(this.labelText, n, FontUtil.getYCentered(this.currentFont, dimension.height));
            graphics.setClip(shape);
        }
        if (!this.workspacePanel && (this.mouseOver || this.hasFocus)) {
            graphics.drawImage(this.closeIcon.getImage(), dimension.width - this.closeIconWidth - 3, dimension.height / 2 - this.closeIcon.getImage().getHeight(this) / 2, this);
        }
        --dimension.width;
        --dimension.height;
        if (this.hasFocus) {
            graphics.setColor(Color.darkGray);
            graphics.drawLine(0, 0, 0, dimension.height);
            graphics.drawLine(0, 0, dimension.width, 0);
            graphics.setColor(Color.white);
            graphics.drawLine(1, dimension.height, dimension.width, dimension.height);
            graphics.drawLine(dimension.width, dimension.height, dimension.width, 0);
        } else if (this.mouseOver) {
            graphics.setColor(Color.white);
            graphics.drawLine(0, 0, 0, dimension.height);
            graphics.drawLine(0, 0, dimension.width, 0);
            graphics.setColor(Color.darkGray);
            graphics.drawLine(1, dimension.height, dimension.width, dimension.height);
            graphics.drawLine(dimension.width, dimension.height, dimension.width, 0);
        }
    }

    public FocusButton(String string, ImageIcon imageIcon, String string2, ApplicationPanel applicationPanel) {
        this.setText(string);
        this.setIcon(imageIcon);
        this.focusComponentTitle = string2;
        this.focusPanel = applicationPanel;
        this.initialize();
    }

    public FocusButton(String string, String string2, ApplicationPanel applicationPanel) {
        this.setText(string);
        this.focusComponentTitle = string2;
        this.focusPanel = applicationPanel;
        this.initialize();
    }

    public FocusButton(ImageIcon imageIcon, String string, ApplicationPanel applicationPanel) {
        this.setIcon(imageIcon);
        this.focusComponentTitle = string;
        this.focusPanel = applicationPanel;
        this.initialize();
    }
}

