/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.gui;

import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.gui.AppDefaultWin;
import com.ibm.nzna.projects.qit.gui.Browser;
import com.ibm.nzna.projects.qit.gui.BrowserListener;
import com.ibm.nzna.shared.gui.ButtonPanel;
import com.ibm.nzna.shared.util.FileUtil;
import com.ibm.nzna.shared.util.LogSystem;
import horst.HTMLPane;
import horst.HTMLPaneStatusEvent;
import horst.HTMLPaneStatusListener;
import horst.HTMLWindow;
import horst.LinkEvent;
import horst.LinkListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import javax.swing.JComponent;

public class HTMLPaneBrowser
extends JComponent
implements Browser,
HTMLPaneStatusListener,
LinkListener,
ActionListener,
AppConst,
Runnable {
    private static URL dummyURL = null;
    private static int nextFileNum = 1;
    private static final String VIEWPORT_NAME = "QUEST";
    private HTMLWindow pnl_BROWSER = null;
    private HTMLPane htmlPane = null;
    private AppDefaultWin appDefaultWin = null;
    private BrowserListener listener = null;
    private String currentURL = null;
    private ButtonPanel buttonPanel = null;
    private int zoom = 3;
    private boolean firstZoomSet = false;
    private boolean showZoom = true;

    private void initializeHTMLPaneBrowser() {
        this.pnl_BROWSER = new HTMLWindow();
        this.htmlPane = new HTMLPane();
        this.pnl_BROWSER.setHTMLPane(this.htmlPane);
    }

    public void back() {
        this.htmlPane.back();
    }

    public void forward() {
        this.htmlPane.forward();
    }

    public void stop() {
        this.htmlPane.stop();
        if (this.listener != null) {
            this.listener.pageStopped();
        }
    }

    public void loadURL(String string) {
        this.currentURL = string;
        new Thread(this).start();
    }

    public void run() {
        try {
            if (this.listener != null) {
                this.listener.pageStarted(this.currentURL);
            }
            this.htmlPane.openPage(new URL(this.currentURL));
        }
        catch (Exception exception) {
            if (this.listener != null) {
                this.listener.pageStopped();
            }
            GUISystem.printBox(Str.getStr(6), Str.getStr(108) + " " + this.currentURL);
        }
    }

    public void reload() {
        new Thread(this).start();
    }

    public boolean copy() {
        return false;
    }

    public void addBrowserListener(BrowserListener browserListener) {
        this.listener = browserListener;
    }

    public void removeBrowserListener(BrowserListener browserListener) {
        this.listener = null;
    }

    public void setPageContent(String string) {
        try {
            String string2 = PropertySystem.getString(30) + File.separator + nextFileNum++ + "_" + System.currentTimeMillis() + "_temp.html";
            FileUtil.saveFile(string2, string);
            this.loadURL("file:/" + string2);
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void showZoom(boolean bl) {
        bl = false;
        this.buttonPanel.setVisible(bl);
        this.revalidate();
    }

    public boolean canGoBack() {
        return this.htmlPane.canMoveBack();
    }

    public boolean canGoForward() {
        return this.htmlPane.canMoveForward();
    }

    public void mouseOverLink(LinkEvent linkEvent) {
        this.setStatus(linkEvent.getLink());
    }

    public boolean mousePressedOverLink(LinkEvent linkEvent) {
        boolean bl = true;
        if (this.listener != null) {
            bl = this.listener.linkClicked(linkEvent.getLink());
        }
        return bl;
    }

    private void setStatus(String string) {
        if (this.appDefaultWin == null) {
            this.appDefaultWin = GUISystem.getParentDefWin(this);
        }
        if (this.appDefaultWin != null) {
            this.appDefaultWin.setStatus(string, false);
        }
    }

    public boolean statusChanged(HTMLPaneStatusEvent hTMLPaneStatusEvent) {
        switch (hTMLPaneStatusEvent.getID()) {
            case 7: {
                break;
            }
            case 0: {
                this.setStatus(Str.getStr(892));
                break;
            }
            case 6: {
                break;
            }
            case 9: {
                break;
            }
            case 2: {
                break;
            }
            case 4: {
                this.setStatus(Str.getStr(137));
                break;
            }
            case 3: {
                break;
            }
            case 5: {
                if (this.listener != null) {
                    this.listener.pageStopped();
                }
                this.setStatus(null);
                break;
            }
            case 1: {
                break;
            }
            case 8: {
                break;
            }
            default: {
                this.setStatus(null);
            }
        }
        return true;
    }

    public String getSource() {
        String string = null;
        try {
            String string2 = PropertySystem.getString(30) + File.separator + "temp_sf" + nextFileNum;
            this.htmlPane.getSourceFile(string2);
            string = FileUtil.readFile(string2);
            ++nextFileNum;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public Component getComponent() {
        return this;
    }

    public HTMLPaneBrowser() {
        try {
            if (dummyURL == null) {
                dummyURL = new URL("http://localhost/");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.zoom = 3;
            this.buttonPanel = new ButtonPanel();
            this.initializeHTMLPaneBrowser();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.buttonPanel.setBackground(Color.white);
        this.buttonPanel.setArrowImage(ImageSystem.getImageIcon((Object)this, 146), ImageSystem.getImageIcon((Object)this, 147));
        this.htmlPane.addLinkListener((LinkListener)this);
        this.htmlPane.addStatusListener((HTMLPaneStatusListener)this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.pnl_BROWSER, "Center");
    }
}

