/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.gui;

import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.gui.Browser;
import com.ibm.nzna.projects.qit.gui.BrowserListener;
import com.ibm.nzna.shared.util.FileUtil;
import com.ibm.nzna.shared.util.LogSystem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.Vector;
import javax.swing.JComponent;
import nothome.mswindows.IECanvas;
import nothome.mswindows.IEEventListener;

public class IEBrowser
extends JComponent
implements IEEventListener,
Browser {
    private int nextFileNum = 1;
    private Vector browserListeners = new Vector(1);
    private IECanvas ieCanvas = new IECanvas();
    private int max = 0;
    private int value = 0;
    private String status = null;

    public void reload() {
        this.ieCanvas.rld();
    }

    public void onStatusTextChange(String string) {
        this.status = string;
        this.fireStatusEvent();
    }

    public void onTitleChange(String string) {
        System.out.println("onTitleChange:" + string);
    }

    public void onDocumentComplete(String string) {
        System.out.println("onDocumentComplete(a). Status:" + string);
        this.max = 0;
        this.value = 0;
        this.status = null;
        this.fireStatusEvent();
    }

    public void onBeforeNavigate2(String string) {
        this.firePageStarted(string);
        System.out.println("onBeforeNavigate2. URL:" + string);
    }

    public void onNavigateComplete2(String string) {
        this.firePageStopped();
        this.status = string;
        this.fireStatusEvent();
    }

    public void onDownloadComplete() {
        this.status = null;
        this.max = 0;
        this.value = 0;
        this.fireStatusEvent();
    }

    public void onProgressChange(int n, int n2) {
        System.out.println("ProgressChange. Progress:" + n + " max:" + n2);
        this.value = n;
        this.max = n2;
        this.fireStatusEvent();
    }

    public void onCommandStateChange(int n, boolean bl) {
    }

    public void onQuit() {
    }

    public boolean showContextMenu(int n, int n2) {
        return true;
    }

    public boolean canGoBack() {
        return false;
    }

    public boolean canGoForward() {
        return false;
    }

    public void forward() {
        this.ieCanvas.goForward();
    }

    public void back() {
        this.ieCanvas.goBackward();
    }

    public String getSource() {
        return "";
    }

    public void loadURL(String string) {
        this.ieCanvas.setURL(string);
    }

    public void setPageContent(String string) {
        try {
            String string2 = PropertySystem.getString(30) + File.separator + this.nextFileNum++ + "_" + System.currentTimeMillis() + "_temp.html";
            FileUtil.saveFile(string2, string);
            this.loadURL(string2);
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
        }
    }

    public void stop() {
    }

    public void addBrowserListener(BrowserListener browserListener) {
        this.browserListeners.addElement(browserListener);
    }

    public void removeBrowserListener(BrowserListener browserListener) {
        this.browserListeners.removeElement(browserListener);
    }

    public Component getComponent() {
        return this;
    }

    public boolean showContextMenu() {
        return false;
    }

    private void fireStatusEvent() {
        if (this.browserListeners != null) {
            int n = 0;
            int n2 = this.browserListeners.size();
            while (n < n2) {
                ((BrowserListener)this.browserListeners.elementAt(n)).statusChange(this.status, this.value, this.max);
                ++n;
            }
        }
    }

    private void firePageStarted(String string) {
        if (this.browserListeners != null) {
            int n = 0;
            int n2 = this.browserListeners.size();
            while (n < n2) {
                ((BrowserListener)this.browserListeners.elementAt(n)).pageStarted(string);
                ++n;
            }
        }
    }

    private void firePageStopped() {
        if (this.browserListeners != null) {
            int n = 0;
            int n2 = this.browserListeners.size();
            while (n < n2) {
                ((BrowserListener)this.browserListeners.elementAt(n)).pageStopped();
                ++n;
            }
        }
    }

    public IEBrowser() {
        this.ieCanvas.addIEEventListener((IEEventListener)this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.ieCanvas);
    }
}

