/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.gui;

import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.gui.NavList;
import com.ibm.nzna.projects.qit.gui.NavListExpandListener;
import com.ibm.nzna.shared.gui.HotLinkLabel;
import com.ibm.nzna.shared.util.LogSystem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class NavListGroup
extends JPanel
implements Runnable,
ActionListener {
    private Vector componentVec = null;
    private HotLinkLabel st_TITLE = null;
    private NavList navList = null;
    private boolean expanded = false;
    private Dimension minSize = new Dimension(0, GUISystem.getRowHeight());
    private int navListHeight = 1;
    private Vector expandListenerVec = null;
    private ImageIcon collapsedIcon = null;
    private ImageIcon expandedIcon = null;

    private void initialize(String string, ImageIcon imageIcon) {
        try {
            this.setBackground(Color.white);
            this.setOpaque(false);
            if (string != null && imageIcon == null) {
                this.st_TITLE = new HotLinkLabel(string);
            } else if (string == null && imageIcon != null) {
                this.st_TITLE = new HotLinkLabel(imageIcon);
            } else if (string != null && imageIcon != null) {
                this.st_TITLE = new HotLinkLabel(string, imageIcon);
            }
            this.st_TITLE.showSelection(false);
            this.navList = new NavList();
            this.collapsedIcon = imageIcon;
            this.expandedIcon = imageIcon;
            this.setLayout(null);
            this.navList.setVisible(false);
            this.st_TITLE.addActionListener(this);
            this.add((Component)this.st_TITLE, "North");
            this.add((Component)this.navList, "Center");
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
    }

    public void doLayout() {
        int n = GUISystem.getRowHeight();
        Dimension dimension = this.getSize();
        this.st_TITLE.setBounds(0, 0, dimension.width, n);
        if (this.expanded && this.navListHeight > 1) {
            this.navList.setBounds(18, n, dimension.width - 15, dimension.height - n - 1);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.st_TITLE) {
            if (this.expanded) {
                this.collapse();
            } else {
                this.expand();
            }
        }
    }

    public void expand() {
        if (this.navListHeight > 1) {
            if (this.getParent() instanceof NavList) {
                ((NavList)this.getParent()).scrollSmooth(this.getLocation().y + this.minSize.height, 50 - this.minSize.height);
            }
            this.navList.setVisible(true);
            this.minSize.height = this.navListHeight + GUISystem.getRowHeight();
            try {
                this.invalidate();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.expanded = true;
        this.st_TITLE.setIcon(this.expandedIcon);
        if (this.getParent() instanceof NavListGroup) {
            ((NavListGroup)this.getParent()).revalidateHeight();
        }
        if (this.expandListenerVec != null) {
            new Thread(this).start();
        }
    }

    public void collapse() {
        if (this.navListHeight > 1) {
            this.expanded = false;
            if (this.getParent() instanceof NavList) {
                ((NavList)this.getParent()).scrollSmooth(this.getLocation().y + this.minSize.height, -this.minSize.height + GUISystem.getRowHeight());
            }
            this.minSize.height = GUISystem.getRowHeight();
            this.navList.setVisible(false);
            try {
                ((JComponent)this.getParent()).revalidate();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.st_TITLE.setIcon(this.collapsedIcon);
        if (this.getParent() instanceof NavListGroup) {
            ((NavListGroup)this.getParent()).revalidateHeight();
        }
        if (this.expandListenerVec != null) {
            new Thread(this).start();
        }
    }

    public void setText(String string) {
        this.st_TITLE.setText(string);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        int n = GUISystem.getRowHeight();
        if (this.navListHeight > 1 && this.expanded) {
            this.minSize = this.navList.getPreferredSize();
            this.minSize.height += n;
        } else {
            this.minSize.height = n;
        }
        return this.minSize;
    }

    public Component add(Component component) {
        this.navList.add(component);
        this.revalidateHeight();
        return component;
    }

    public void revalidateHeight() {
        int n = this.getComponentCount();
        int n2 = 0;
        Component component = null;
        this.navListHeight = 1;
        while (n2 < n) {
            component = this.getComponent(n2);
            this.navListHeight += component.getPreferredSize().height;
            if (this.navListHeight > 1 && this.expanded) {
                this.minSize.height = GUISystem.getRowHeight() + this.navListHeight;
                try {
                    if (this.getParent() instanceof NavList) {
                        ((NavList)this.getParent()).scrollSmooth(this.getLocation().y + this.minSize.height, 50 - this.minSize.height);
                    }
                    this.minSize.height = 50;
                }
                catch (Exception exception) {
                    this.minSize.height = 50;
                    exception.printStackTrace();
                }
            }
            ++n2;
        }
        this.invalidate();
        if (this.getParent() != null) {
            ((JComponent)this.getParent()).revalidate();
        }
    }

    public void setIcon(ImageIcon imageIcon) {
        this.st_TITLE.setIcon(imageIcon);
    }

    public void addActionListener(ActionListener actionListener) {
        this.navList.addActionListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.navList.removeActionListener(this);
    }

    public boolean getExpanded() {
        return this.expanded;
    }

    public void run() {
        this.notifyExpandListeners();
    }

    private void notifyExpandListeners() {
        if (this.expandListenerVec != null) {
            int n = 0;
            int n2 = this.expandListenerVec.size();
            while (n < n2) {
                ((NavListExpandListener)this.expandListenerVec.elementAt(n)).expanded(this, this.expanded);
                ++n;
            }
        }
    }

    public void addExpandListener(NavListExpandListener navListExpandListener) {
        if (this.expandListenerVec == null) {
            this.expandListenerVec = new Vector(1);
        }
        this.expandListenerVec.addElement(navListExpandListener);
    }

    public void removeExpandListener(NavListExpandListener navListExpandListener) {
        if (this.expandListenerVec != null) {
            this.expandListenerVec.removeElement(navListExpandListener);
            if (this.expandListenerVec.size() == 0) {
                this.expandListenerVec = null;
            }
        }
    }

    public void setExpandedIcon(ImageIcon imageIcon) {
        this.expandedIcon = imageIcon;
    }

    public void setCollapsedIcon(ImageIcon imageIcon) {
        this.collapsedIcon = imageIcon;
    }

    public void setData(Object object) {
        this.st_TITLE.setData(object);
    }

    public Object getData() {
        return this.st_TITLE.getData();
    }

    public NavListGroup(String string) {
        this.initialize(string, null);
    }

    public NavListGroup(String string, ImageIcon imageIcon) {
        this.initialize(string, imageIcon);
    }
}

