/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.gui;

import com.ibm.nzna.projects.common.quest.type.TypeList;
import com.ibm.nzna.projects.common.quest.type.TypeOfferingRec;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.DataLengths;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.gui.OfferingEntryPanelListener;
import com.ibm.nzna.projects.qit.gui.SelectOfferingDlg;
import com.ibm.nzna.projects.qit.product.ProductConst;
import com.ibm.nzna.shared.gui.DButton;
import com.ibm.nzna.shared.util.LogSystem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class OfferingEntryPanel
extends JPanel
implements ActionListener,
Runnable,
AppConst,
ProductConst,
DataLengths {
    private static final String THREAD_SEARCH = "SE";
    private static final String THREAD_FIRE_EVENT = "FE";
    private JTextField ef_OFFER = new JTextField();
    private DButton pb_SELECTOFFER = null;
    private Vector listeners = new Vector(1);
    private String lastOfferingSearch = "";
    private boolean inSearch = false;
    private Vector offeringVec = null;
    private TypeOfferingRec offeringRec = null;
    private boolean showFullName = true;
    private boolean continueThread = true;
    private String curTempOffering = null;
    private boolean showManagerOnly = false;

    private void init() {
        this.createControls();
        this.offeringVec = (Vector)TypeList.getInstance().getTypeList(26).clone();
        new Thread((Runnable)this, THREAD_SEARCH).start();
    }

    private void createControls() {
        this.setLayout(null);
        this.pb_SELECTOFFER = new DButton(ImageSystem.getImageIcon((Object)this, 32));
        this.pb_SELECTOFFER.setFocusPainted(false);
        this.pb_SELECTOFFER.setBorderPainted(false);
        this.pb_SELECTOFFER.setBackground(Color.white);
        this.pb_SELECTOFFER.addActionListener(this);
        this.ef_OFFER.addActionListener(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.ef_OFFER, "Center");
        this.add((Component)this.pb_SELECTOFFER, "East");
    }

    public String getText() {
        return this.ef_OFFER.getText();
    }

    public void setText(String string) {
        if (string != null && string.length() > 0) {
            this.curTempOffering = string;
            this.offeringRec = this.findOffering(string, true);
            this.refreshOfferingField();
        } else {
            this.ef_OFFER.setText("");
        }
    }

    public void setShowFullName(boolean bl) {
        this.showFullName = bl;
        this.refreshOfferingField();
    }

    public boolean getShowFullName() {
        return this.showFullName;
    }

    public void run() {
        String string = Thread.currentThread().getName();
        if (string.equals(THREAD_SEARCH)) {
            this.search();
        } else if (string.equals(THREAD_FIRE_EVENT)) {
            this.fireEvent();
        }
    }

    private void search() {
        String string = null;
        String string2 = null;
        while (this.continueThread) {
            try {
                Thread.sleep(1500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            string = this.ef_OFFER.getText();
            if (string != null && string.length() > 0 && this.lastOfferingSearch != null) {
                try {
                    Thread.sleep(300L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                string2 = this.ef_OFFER.getText();
                if (!string2.equals(string) || string2.equals(this.lastOfferingSearch)) continue;
                this.lastOfferingSearch = string2;
                this.offeringRec = this.findOffering(string2);
                this.refreshOfferingField();
                if (this.offeringRec == null) continue;
                new Thread((Runnable)this, THREAD_FIRE_EVENT).start();
                continue;
            }
            this.offeringRec = null;
        }
    }

    private TypeOfferingRec findOffering(String string) {
        return this.findOffering(string, false);
    }

    private TypeOfferingRec findOffering(String string, boolean bl) {
        TypeOfferingRec typeOfferingRec = null;
        if (string != null && this.offeringVec != null) {
            int n = 0;
            int n2 = this.offeringVec.size();
            TypeOfferingRec typeOfferingRec2 = null;
            Vector<TypeOfferingRec> vector = new Vector<TypeOfferingRec>(1, 10);
            string = string.toUpperCase();
            while (n < n2) {
                typeOfferingRec2 = (TypeOfferingRec)this.offeringVec.elementAt(n);
                if (typeOfferingRec2 != null) {
                    if (bl) {
                        if (typeOfferingRec2.toString().toUpperCase().equals(string)) {
                            vector.addElement(typeOfferingRec2);
                        }
                    } else if (typeOfferingRec2.toString().toUpperCase().startsWith(string)) {
                        vector.addElement(typeOfferingRec2);
                    }
                }
                ++n;
            }
            vector.trimToSize();
            if (vector.size() > 1) {
                Vector vector2 = null;
                vector2 = new SelectOfferingDlg(GUISystem.getParentFrame(this), vector, false).getResult();
                if (vector2 != null && vector2.size() > 0) {
                    typeOfferingRec2 = (TypeOfferingRec)vector2.elementAt(0);
                }
                typeOfferingRec = this.offeringRec = typeOfferingRec2;
                this.refreshOfferingField();
            } else if (vector.size() == 1) {
                typeOfferingRec = (TypeOfferingRec)vector.elementAt(0);
            }
        }
        return typeOfferingRec;
    }

    private void refreshOfferingField() {
        if (this.offeringRec != null) {
            if (this.showFullName) {
                this.ef_OFFER.setText(this.offeringRec.toString());
            }
            try {
                this.ef_OFFER.setSelectionStart(this.lastOfferingSearch.length());
                this.ef_OFFER.setSelectionEnd(this.ef_OFFER.getText().length());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.lastOfferingSearch = this.ef_OFFER.getText();
        } else {
            this.ef_OFFER.setText("");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            if (actionEvent.getSource() instanceof DButton) {
                DButton dButton = (DButton)actionEvent.getSource();
                if (this.pb_SELECTOFFER == dButton) {
                    Vector vector = null;
                    vector = new SelectOfferingDlg(GUISystem.getParentFrame(this), false).getResult();
                    if (vector != null && vector.size() > 0) {
                        this.offeringRec = (TypeOfferingRec)vector.elementAt(0);
                    }
                    this.refreshOfferingField();
                }
            } else if (actionEvent.getSource() instanceof JTextField) {
                String string = this.ef_OFFER.getText();
                this.offeringRec = this.findOffering(string);
                this.refreshOfferingField();
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
    }

    public void stop() {
        this.continueThread = false;
    }

    public String getName() {
        String string = null;
        if (this.offeringRec != null) {
            string = this.offeringRec.toString();
        }
        return string;
    }

    public TypeOfferingRec getOfferingRec() {
        if (this.offeringRec == null) {
            this.offeringRec = this.findOffering(this.ef_OFFER.getText());
        }
        return this.offeringRec;
    }

    public TypeOfferingRec getOfferingRecNoLookup() {
        return this.offeringRec;
    }

    public String getDescript() {
        String string = null;
        if (this.offeringRec != null) {
            string = this.offeringRec.toString();
        }
        return string;
    }

    public void requestFocus() {
        this.ef_OFFER.requestFocus();
    }

    public void setEnabled(boolean bl) {
        this.ef_OFFER.setEnabled(bl);
        this.pb_SELECTOFFER.setEnabled(bl);
        super.setEnabled(bl);
    }

    private void fireEvent() {
        int n = 0;
        int n2 = this.listeners.size();
        while (n < n2) {
            ((OfferingEntryPanelListener)this.listeners.elementAt(n)).offeringSelected(this.offeringRec);
            ++n;
        }
    }

    public void addOfferingEntryPanelListener(OfferingEntryPanelListener offeringEntryPanelListener) {
        this.listeners.addElement(offeringEntryPanelListener);
    }

    public void removeOfferingEntryPanelListener(OfferingEntryPanelListener offeringEntryPanelListener) {
        this.listeners.removeElement(offeringEntryPanelListener);
    }

    public OfferingEntryPanel() {
        this.init();
    }
}

