/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.gui;

import com.ibm.nzna.projects.common.quest.type.TypeList;
import com.ibm.nzna.projects.common.quest.type.TypeOfferingRec;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.FontSystem;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.gui.JTitle;
import com.ibm.nzna.projects.qit.product.ProductConst;
import com.ibm.nzna.shared.gui.DButton;
import com.ibm.nzna.shared.gui.MaskDocument;
import com.ibm.nzna.shared.gui.MultiList;
import com.ibm.nzna.shared.util.ComponentPopFocus;
import com.ibm.nzna.shared.util.WinUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class SelectOfferingDlg
extends JDialog
implements ActionListener,
AppConst,
ProductConst {
    private static final String[] offeringTitle = new String[]{Str.getStr(99)};
    private JLabel st_DESCRIPT = new JLabel(Str.getStr(17096));
    private MultiList offeringList = new MultiList(GUISystem.getFontUtil());
    private JPanel pnl_OFFERINGLIST = new JPanel();
    private JTitle st_TITLE = new JTitle(Str.getStr(17023));
    private DButton pb_SELECT = new DButton(Str.getStr(404));
    private DButton pb_CANCEL = new DButton(Str.getStr(2));
    private DButton pb_SEARCH = new DButton(Str.getStr(470));
    private JPanel brd_SEARCH = new JPanel();
    private JPanel brd_OFFERING = new JPanel();
    private JTextField ef_SEARCH = new JTextField(new MaskDocument(0, 80), "", 0);
    private TypeOfferingRec offeringRec = null;
    private Vector retVec = null;
    private Vector offeringVec = null;
    private boolean multiple = false;
    private int rowHeight = 18;

    private void init() {
        this.setResizable(false);
        this.createControls();
        this.refreshList();
        ((Component)this).setSize(340, 300);
        WinUtil.centerWindow(this);
        this.addWindowListener(new ComponentPopFocus(this.ef_SEARCH));
    }

    public Vector getResult() {
        ((Component)this).setVisible(true);
        return this.retVec;
    }

    public void createControls() {
        this.offeringList.setColumnHeadings(offeringTitle);
        this.offeringList.setColumnWidth(1, 250);
        this.offeringList.setForeground(Color.black);
        this.offeringList.setRowHeight(18);
        this.brd_SEARCH.setBorder(new TitledBorder(Str.getStr(470)));
        this.brd_OFFERING.setBorder(new TitledBorder(""));
        this.brd_SEARCH.setLayout(null);
        this.brd_OFFERING.setLayout(null);
        this.offeringList.setBorder(null);
        this.offeringList.showColumnHeadings(false);
        this.pnl_OFFERINGLIST.setBackground(Color.white);
        this.pnl_OFFERINGLIST.setBorder(GUISystem.loweredBorder);
        this.st_TITLE.setFont(FontSystem.defaultFont);
        this.pnl_OFFERINGLIST.setLayout(new BorderLayout());
        this.pnl_OFFERINGLIST.add((Component)this.st_TITLE, "North");
        this.pnl_OFFERINGLIST.add(this.offeringList);
        this.brd_SEARCH.add(this.ef_SEARCH);
        this.brd_SEARCH.add(this.pb_SEARCH);
        this.brd_OFFERING.add(this.pnl_OFFERINGLIST);
        this.ef_SEARCH.setBounds(10, 15, 200, this.rowHeight);
        this.pb_SEARCH.setBounds(210, 15, 90, this.rowHeight);
        this.pnl_OFFERINGLIST.setBounds(10, 15, 300, 150);
        this.ef_SEARCH.addActionListener(this);
        this.pb_SEARCH.addActionListener(this);
        this.offeringList.addActionListener(this);
        this.pb_CANCEL.addActionListener(this);
        this.pb_SELECT.addActionListener(this);
        this.getContentPane().setLayout(null);
        this.getContentPane().add(this.brd_SEARCH);
        this.getContentPane().add(this.brd_OFFERING);
        this.getContentPane().add(this.pb_SELECT);
        this.getContentPane().add(this.pb_CANCEL);
    }

    public void refreshList() {
        if (this.offeringVec == null) {
            Vector vector = null;
            vector = (Vector)TypeList.getInstance().getTypeList(24).clone();
            if (vector != null) {
                this.offeringList.add(vector);
            }
        } else {
            this.offeringList.add(this.offeringVec);
        }
        if (this.offeringRec != null) {
            this.offeringList.setSelectedItem(this.offeringRec, true);
        }
        this.ef_SEARCH.requestFocus();
        this.offeringList.paintAll(this.offeringList.getGraphics());
    }

    public void doLayout() {
        int n = 10;
        int n2 = 10;
        Dimension dimension = this.getSize();
        super.doLayout();
        dimension.height -= 30;
        this.brd_SEARCH.setBounds(n, n2, dimension.width - n * 2, this.rowHeight * 2 + 5);
        this.brd_OFFERING.setBounds(n, n2 += this.rowHeight * 2 + 5, dimension.width - n * 2, dimension.height - 50 - n2);
        this.pb_SELECT.setBounds(n, dimension.height - 40, 70, 25);
        this.pb_CANCEL.setBounds(n + 75, dimension.height - 40, 90, 25);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.ef_SEARCH) {
            this.search();
        } else if (actionEvent.getSource() instanceof DButton) {
            DButton dButton = (DButton)actionEvent.getSource();
            if (this.pb_CANCEL == dButton) {
                this.retVec = null;
                this.dispose();
            } else if (this.pb_SEARCH == dButton) {
                this.search();
            } else if (this.pb_SELECT == dButton && this.saveData()) {
                this.dispose();
            }
        } else if (actionEvent.getSource() == this.offeringList && this.saveData()) {
            this.dispose();
        }
    }

    public boolean saveData() {
        boolean bl = false;
        this.retVec = this.offeringList.getSelection();
        if (this.retVec == null) {
            GUISystem.printBox(Str.getStr(6), Str.getStr(358));
        } else {
            bl = true;
        }
        return bl;
    }

    private void search() {
        String string = this.ef_SEARCH.getText();
        if (string != null && string.length() > 0) {
            Vector vector = (Vector)TypeList.getInstance().getTypeList(24).clone();
            int n = 0;
            string = string.toUpperCase();
            if (vector != null) {
                int n2 = 0;
                boolean bl = false;
                TypeOfferingRec typeOfferingRec = null;
                n2 = vector.size();
                while (!bl && n < n2) {
                    typeOfferingRec = (TypeOfferingRec)vector.elementAt(n);
                    if (typeOfferingRec != null && typeOfferingRec.toString().toUpperCase().indexOf(string) != -1) {
                        bl = true;
                    }
                    ++n;
                }
                if (bl) {
                    this.offeringList.setSelectedItem(typeOfferingRec, true);
                }
            }
        }
    }

    public SelectOfferingDlg(Frame frame) {
        super(frame, Str.getStr(17096), true);
        this.init();
    }

    public SelectOfferingDlg(Frame frame, boolean bl) {
        super(frame, Str.getStr(17096), true);
        this.multiple = bl;
        this.init();
    }

    public SelectOfferingDlg(Frame frame, Vector vector) {
        super(frame, Str.getStr(17096), true);
        this.offeringVec = vector;
        this.multiple = this.multiple;
        this.init();
    }

    public SelectOfferingDlg(Frame frame, Vector vector, boolean bl) {
        super(frame, Str.getStr(17096), true);
        this.offeringVec = vector;
        this.multiple = bl;
        this.init();
    }

    public SelectOfferingDlg(Frame frame, TypeOfferingRec typeOfferingRec) {
        super(frame, Str.getStr(17096), true);
        this.offeringRec = typeOfferingRec;
        this.init();
    }
}

