/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.gui;

import com.ibm.nzna.projects.qit.app.FontSystem;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.PropertyListener;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.ThemeSystem;
import com.ibm.nzna.projects.qit.dbgui.DBStatusLight;
import com.ibm.nzna.projects.qit.gui.UpdateStatusText;
import com.ibm.nzna.projects.qit.gui.UpdateStatusValue;
import com.ibm.nzna.shared.util.LogSystem;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class StatusBar
extends JPanel
implements PropertyListener {
    private static final int APPBUTTON_WIDTH = 20;
    private static final int GAUGE_WIDTH = 70;
    private static final int CONTROL_HEIGHT = 23;
    protected JProgressBar gge_STATUS = null;
    protected JLabel st_STATUS = null;
    private DBStatusLight dbStatusLight = null;
    private Dimension prefSize = new Dimension(0, 23);
    private String status = null;
    private boolean appButtonsCreated = false;
    private int appBarWidth = 0;
    private int width = 0;
    private int height = 0;
    private FontMetrics fm = null;
    private int space = 0;
    private int fontY = 0;

    public void init() {
        this.gge_STATUS = new JProgressBar();
        this.st_STATUS = new JLabel();
        this.dbStatusLight = new DBStatusLight();
        PropertySystem.addPropertyListener(21, this);
        this.gge_STATUS.setFont(FontSystem.smallFont);
        this.gge_STATUS.setForeground(new Color(0, 0, 120));
        this.propertyChanged(21, null);
        this.add(this.dbStatusLight);
        this.add(this.gge_STATUS);
        this.add(this.st_STATUS);
        this.setBorder(null);
    }

    public Dimension getPreferredSize() {
        this.prefSize.width = this.getParent().getSize().width;
        return this.prefSize;
    }

    public void setStatus(String string, boolean bl) {
        this.status = string;
        SwingUtilities.invokeLater(new UpdateStatusText(this, string, bl));
    }

    public void removeNotify() {
        PropertySystem.removePropertyListener(21, this);
        super.removeNotify();
    }

    public void propertyChanged(int n, Object object) {
        switch (n) {
            case 21: {
                String string = (String)ThemeSystem.getThemeProperty("STATUS_RECT");
                Color color = ThemeSystem.getColor("STATUS_BG_COLOR");
                Color color2 = ThemeSystem.getColor("STATUS_FG_COLOR");
                if (string.equalsIgnoreCase("LOWERED")) {
                    this.st_STATUS.setBorder(GUISystem.loweredBorder);
                    this.gge_STATUS.setBorder(GUISystem.loweredBorder);
                    this.dbStatusLight.setBorder(GUISystem.loweredBorder);
                } else if (string.equalsIgnoreCase("RAISED")) {
                    this.st_STATUS.setBorder(GUISystem.raisedBorder);
                    this.gge_STATUS.setBorder(GUISystem.raisedBorder);
                    this.dbStatusLight.setBorder(GUISystem.raisedBorder);
                } else if (string.equalsIgnoreCase("ETCHED")) {
                    this.st_STATUS.setBorder(GUISystem.etchedBorder);
                    this.gge_STATUS.setBorder(GUISystem.etchedBorder);
                    this.dbStatusLight.setBorder(GUISystem.etchedBorder);
                }
                this.gge_STATUS.setStringPainted(ThemeSystem.getBoolean("STATUS_SHOW_PERCENTAGE_TEXT"));
                if (color != null) {
                    this.setBackground(color);
                    this.setOpaque(true);
                } else {
                    this.setOpaque(false);
                }
                if (color2 != null) {
                    this.st_STATUS.setForeground(color2);
                } else {
                    this.st_STATUS.setForeground(Color.black);
                }
                this.gge_STATUS.setBackground(this.getBackground());
                break;
            }
        }
    }

    public void doLayout() {
        Dimension dimension = null;
        int n = 2;
        int n2 = 2;
        super.doLayout();
        dimension = this.getSize();
        this.height = dimension.height;
        this.width = dimension.width;
        this.dbStatusLight.setBounds(n, n2, 20, this.height - n2 * 2);
        this.st_STATUS.setBounds(n += 22, n2, this.width - 70 - n - 2, this.height - n2 * 2);
        this.gge_STATUS.setBounds(this.width - 70, n2, 66, this.height - n2 * 2);
    }

    public void setStatusValue(int n) {
        SwingUtilities.invokeLater(new UpdateStatusValue(this, n));
    }

    public void setStatusMax(int n) {
        this.gge_STATUS.setMaximum(n);
    }

    public void incrementStatusValue(int n) {
        try {
            this.gge_STATUS.setValue(this.gge_STATUS.getValue() + n);
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
    }

    public String getStatus() {
        return this.st_STATUS.getText();
    }

    public StatusBar() {
        this.init();
    }
}

