/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.gui;

import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.DataLengths;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.UserRec;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.gui.SelectUserDlg;
import com.ibm.nzna.projects.qit.gui.UserEntryPanelListener;
import com.ibm.nzna.shared.gui.DButton;
import com.ibm.nzna.shared.util.LogSystem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class UserEntryPanel
extends JPanel
implements ActionListener,
Runnable,
AppConst,
DataLengths {
    private static final String THREAD_SEARCH = "SE";
    private static final String THREAD_FIRE_EVENT = "FE";
    private JTextField ef_USERID = new JTextField();
    private DButton pb_SELECTUSER = null;
    private Vector listeners = new Vector(1);
    private String lastUserSearch = "";
    private boolean inSearch = false;
    private Vector userVec = null;
    private UserRec userRec = null;
    private boolean showFullName = true;
    private boolean continueThread = true;
    private String curTempUser = null;
    private boolean showManagerOnly = false;

    private final void init() {
        this.createControls();
        this.userVec = UserSystem.getAllUserVec();
        new Thread((Runnable)this, THREAD_SEARCH).start();
    }

    private final void createControls() {
        this.setLayout(null);
        this.pb_SELECTUSER = new DButton(ImageSystem.getImageIcon((Object)this, 32));
        this.pb_SELECTUSER.setFocusPainted(false);
        this.pb_SELECTUSER.setFocusable(false);
        this.pb_SELECTUSER.setBorderPainted(false);
        this.pb_SELECTUSER.setBackground(Color.white);
        this.pb_SELECTUSER.addActionListener(this);
        this.ef_USERID.addActionListener(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.ef_USERID, "Center");
        this.add((Component)this.pb_SELECTUSER, "East");
    }

    public String getText() {
        return this.ef_USERID.getText();
    }

    public void setText(String string) {
        if (string != null && string.length() > 0) {
            this.curTempUser = string;
            this.userRec = this.findUser(string, true);
            this.refreshUserField();
        } else {
            this.ef_USERID.setText("");
        }
    }

    public void setShowFullName(boolean bl) {
        this.showFullName = bl;
        this.refreshUserField();
    }

    public boolean getShowFullName() {
        return this.showFullName;
    }

    public void run() {
        String string = Thread.currentThread().getName();
        if (string.equals(THREAD_SEARCH)) {
            this.search();
        } else if (string.equals(THREAD_FIRE_EVENT)) {
            this.fireEvent();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void search() {
        String string = null;
        String string2 = null;
        while (this.continueThread) {
            try {
                Thread.sleep(1500L);
            }
            catch (Exception exception) {
            }
            string = this.ef_USERID.getText();
            if (string != null && string.length() > 0 && this.lastUserSearch != null) {
                try {
                    Thread.sleep(300L);
                }
                catch (Exception exception) {
                }
                string2 = this.ef_USERID.getText();
                if (!string2.equals(string) || string2.equals(this.lastUserSearch)) continue;
                this.lastUserSearch = string2;
                this.userRec = this.findUser(string2);
                this.refreshUserField();
                if (this.userRec == null) continue;
                new Thread((Runnable)this, THREAD_FIRE_EVENT).start();
                continue;
            }
            this.userRec = null;
        }
    }

    private final UserRec findUser(String string) {
        return this.findUser(string, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final UserRec findUser(String string, boolean bl) {
        UserRec userRec = null;
        try {
            if (string == null) return userRec;
            if (this.userVec == null) return userRec;
            int n = 0;
            int n2 = this.userVec.size();
            UserRec userRec2 = null;
            Vector<UserRec> vector = new Vector<UserRec>(1, 10);
            string = string.toUpperCase();
            while (true) {
                block14: {
                    if (n >= n2) {
                        vector.trimToSize();
                        if (vector.size() <= 1) {
                            if (vector.size() != 1) return userRec;
                            return (UserRec)vector.elementAt(0);
                        }
                        Vector vector2 = null;
                        vector2 = new SelectUserDlg(GUISystem.getParentFrame(this), vector, false, this.showManagerOnly).getResult();
                        if (vector2 != null && vector2.size() > 0) {
                            userRec2 = (UserRec)vector2.elementAt(0);
                        }
                        userRec = this.userRec = userRec2;
                        this.refreshUserField();
                        if (this.userRec == null) return userRec;
                        new Thread((Runnable)this, THREAD_FIRE_EVENT).start();
                        return userRec;
                    }
                    userRec2 = (UserRec)this.userVec.elementAt(n);
                    if (userRec2 != null) {
                        try {
                            if (bl) {
                                if (userRec2.getUserId() != null && userRec2.getUserId().toUpperCase().equals(string)) {
                                    vector.addElement(userRec2);
                                    break block14;
                                }
                                if (userRec2.getName() != null && userRec2.getName().toUpperCase().equals(string)) {
                                    vector.addElement(userRec2);
                                }
                                break block14;
                            }
                            if (userRec2.getUserId() != null && userRec2.getUserId().toUpperCase().startsWith(string)) {
                                vector.addElement(userRec2);
                                break block14;
                            }
                            if (userRec2.getName() != null && userRec2.getName().toUpperCase().startsWith(string)) {
                                vector.addElement(userRec2);
                            }
                        }
                        catch (Exception exception) {
                        }
                    }
                }
                ++n;
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void refreshUserField() {
        if (this.userRec == null) {
            this.ef_USERID.setText("");
            return;
        }
        if (this.showFullName) {
            this.ef_USERID.setText(this.userRec.getName());
        } else {
            this.ef_USERID.setText(this.userRec.getUserId());
        }
        try {
            this.ef_USERID.setSelectionStart(this.lastUserSearch.length());
            this.ef_USERID.setSelectionEnd(this.ef_USERID.getText().length());
        }
        catch (Exception exception) {
        }
        this.lastUserSearch = this.ef_USERID.getText();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            if (!(actionEvent.getSource() instanceof DButton)) {
                if (!(actionEvent.getSource() instanceof JTextField)) return;
                String string = this.ef_USERID.getText();
                this.userRec = this.findUser(string);
                this.refreshUserField();
                return;
            }
            DButton dButton = (DButton)actionEvent.getSource();
            if (this.pb_SELECTUSER != dButton) return;
            Vector vector = null;
            vector = new SelectUserDlg(GUISystem.getParentFrame(this), false, this.showManagerOnly).getResult();
            if (vector != null && vector.size() > 0) {
                this.userRec = (UserRec)vector.elementAt(0);
                new Thread((Runnable)this, THREAD_FIRE_EVENT).start();
            }
            this.refreshUserField();
            return;
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
    }

    public void stop() {
        this.continueThread = false;
    }

    public String getName() {
        String string = null;
        if (this.userRec != null) {
            string = this.userRec.getName();
        }
        return string;
    }

    public UserRec getUserRec() {
        if (this.userRec == null) {
            this.userRec = this.findUser(this.ef_USERID.getText());
        }
        return this.userRec;
    }

    public UserRec getUserRecNoLookup() {
        return this.userRec;
    }

    public String getUserId() {
        String string = null;
        if (this.userRec != null) {
            string = this.userRec.getUserId();
        }
        return string;
    }

    public void requestFocus() {
        this.ef_USERID.requestFocus();
    }

    public void setShowManagerOnly(boolean bl) {
        this.showManagerOnly = bl;
        this.ef_USERID.setText("");
    }

    public void setEnabled(boolean bl) {
        this.ef_USERID.setEnabled(bl);
        this.pb_SELECTUSER.setEnabled(bl);
        super.setEnabled(bl);
    }

    public void addUserEntryPanelListener(UserEntryPanelListener userEntryPanelListener) {
        this.listeners.addElement(userEntryPanelListener);
    }

    public void removeUserEntryPanelListener(UserEntryPanelListener userEntryPanelListener) {
        this.listeners.removeElement(userEntryPanelListener);
    }

    private final void fireEvent() {
        int n = 0;
        int n2 = this.listeners.size();
        while (n < n2) {
            ((UserEntryPanelListener)this.listeners.elementAt(n)).userSelected(this.userRec);
            ++n;
        }
    }

    public void addFocusListener(FocusListener focusListener) {
        super.addFocusListener(focusListener);
        if (this.ef_USERID != null) {
            this.ef_USERID.addFocusListener(focusListener);
        }
    }

    public JTextField getJTextField() {
        return this.ef_USERID;
    }

    public UserEntryPanel() {
        this.init();
    }
}

