/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.gui;

import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.DataLengths;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.help.HelpSystem;
import com.ibm.nzna.shared.gui.ButtonPanel;
import com.ibm.nzna.shared.gui.DButton;
import com.ibm.nzna.shared.gui.MaskDocument;
import com.ibm.nzna.shared.util.FileUtil;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.WinUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class UserLogonDlg
extends JDialog
implements AppConst,
Runnable,
DataLengths,
KeyListener,
ActionListener {
    private JTextField ef_USERID = new JTextField(new MaskDocument(1, 8), "", 0);
    private JPasswordField ef_PASSWORD = new JPasswordField("");
    private JLabel st_HELPTEXT = new JLabel(Str.getStr(9));
    private JLabel st_USERID = new JLabel(Str.getStr(4));
    private JLabel st_PASSWORD = new JLabel(Str.getStr(5));
    private JLabel st_IMAGE = new JLabel(ImageSystem.getImageIcon((Object)this, 20));
    private DButton pb_OK = new DButton(Str.getStr(1));
    private DButton pb_CANCEL = new DButton(Str.getStr(2));
    private DButton pb_HELP = new DButton(Str.getStr(10));
    private ButtonPanel buttonPanel = new ButtonPanel();
    private boolean rc = false;

    public boolean getResponse() {
        try {
            String string = PropertySystem.getString(10);
            String string2 = PropertySystem.getString(18);
            if (string != null && string.length() > 0 && string2 != null && string2.length() > 0) {
                this.dispose();
                this.rc = true;
            } else {
                this.createControls();
                new Thread(this).start();
                ((Component)this).setVisible(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.rc;
    }

    public void createControls() {
        Container container = this.getContentPane();
        container.setLayout(null);
        container.add(this.st_HELPTEXT);
        container.add(this.st_USERID);
        container.add(this.ef_USERID);
        container.add(this.st_PASSWORD);
        container.add(this.ef_PASSWORD);
        container.add(this.buttonPanel);
        container.add(this.st_IMAGE);
        this.buttonPanel.add(this.pb_OK);
        this.buttonPanel.add(this.pb_CANCEL);
        this.buttonPanel.add(this.pb_HELP);
        this.pb_OK.addKeyListener(this);
        this.pb_CANCEL.addKeyListener(this);
        this.pb_OK.addActionListener(this);
        this.pb_CANCEL.addActionListener(this);
        this.ef_USERID.addActionListener(this);
        this.ef_PASSWORD.addActionListener(this);
        this.pb_HELP.addActionListener(this);
        GUISystem.setPreferredButton(this.pb_OK);
        GUISystem.setPreferredButton(this.pb_CANCEL);
        GUISystem.setPreferredButton(this.pb_HELP);
        this.st_HELPTEXT.setHorizontalAlignment(0);
    }

    public void doLayout() {
        int n = 10;
        int n2 = 45;
        int n3 = GUISystem.getRowHeight();
        Dimension dimension = this.getSize();
        super.doLayout();
        this.st_IMAGE.setBounds(n, n2 - 4, 44, 44);
        this.st_HELPTEXT.setBounds(n, 0, dimension.width - 20, 45);
        this.st_USERID.setBounds(n + 50, n2, 75, n3);
        this.ef_USERID.setBounds(n + 125, n2, 100, n3);
        this.st_PASSWORD.setBounds(n + 50, n2 += n3, 75, n3);
        this.ef_PASSWORD.setBounds(n + 125, n2, 100, n3);
        n2 = dimension.height - 58;
        this.buttonPanel.setBounds(5, n2, dimension.width, 25);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.pb_OK || actionEvent.getSource() == this.ef_PASSWORD || actionEvent.getSource() == this.ef_USERID) {
            this.processOk();
        } else if (actionEvent.getSource() == this.pb_CANCEL) {
            this.dispose();
        } else if (actionEvent.getSource() == this.pb_HELP) {
            HelpSystem.showHelp("app" + File.separator + "logon.html");
        }
    }

    private void processOk() {
        if (this.saveData()) {
            this.rc = true;
            this.dispose();
        }
    }

    public boolean saveData() {
        boolean bl = false;
        String string = this.ef_USERID.getText();
        String string2 = new String(this.ef_PASSWORD.getPassword());
        if (string == null || string.length() == 0) {
            GUISystem.printBox((JDialog)this, 6, 32);
            this.ef_USERID.requestFocus();
        } else if (string2 == null || string2.length() == 0) {
            GUISystem.printBox((JDialog)this, 6, 33);
            this.ef_PASSWORD.requestFocus();
        } else {
            try {
                PropertySystem.putString(10, string.toUpperCase());
                PropertySystem.putString(18, string2.toUpperCase());
            }
            catch (Exception exception) {
                LogSystem.log(1, exception, false);
            }
            bl = true;
        }
        return bl;
    }

    public void refreshData() {
        try {
            if (PropertySystem.getString(10) != null) {
                this.ef_USERID.setText(PropertySystem.getString(10));
                this.ef_PASSWORD.requestFocus();
            } else {
                this.ef_USERID.requestFocus();
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 10: {
                if (keyEvent.getSource() == this.pb_OK) {
                    this.processOk();
                    break;
                }
                if (keyEvent.getSource() != this.pb_CANCEL) break;
                this.dispose();
                break;
            }
            case 32: {
                if (keyEvent.getSource() == this.pb_OK) {
                    this.processOk();
                    break;
                }
                if (keyEvent.getSource() != this.pb_CANCEL) break;
                this.dispose();
                break;
            }
        }
    }

    public void run() {
        try {
            Thread.currentThread();
            Thread.sleep(100L);
            this.refreshData();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public UserLogonDlg(Frame frame) {
        super(frame, Str.getStr(3), true);
        FileUtil.saveFile("closeSplash", "close");
        this.setResizable(false);
        ((Component)this).setSize(300, 170);
        WinUtil.centerWindow(this);
    }
}

