/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.gui.popup;

import com.ibm.nzna.projects.common.quest.brand.Brands;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.MainWindow;
import com.ibm.nzna.projects.qit.app.StatusRec;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.bookmark.Bookmark;
import com.ibm.nzna.projects.qit.bookmark.BookmarkDlg;
import com.ibm.nzna.projects.qit.bookmark.BookmarkDlgListener;
import com.ibm.nzna.projects.qit.doc.ProdDocRec;
import com.ibm.nzna.projects.qit.gui.popup.PopUpBrandFamilyListener;
import com.ibm.nzna.projects.qit.gui.popup.PopUpDlg;
import com.ibm.nzna.projects.qit.gui.popup.PopUpPanel;
import com.ibm.nzna.projects.qit.product.MachineRec;
import com.ibm.nzna.projects.qit.product.ProductConstants;
import com.ibm.nzna.projects.qit.product.ProductRec;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.gui.DButton;
import com.ibm.nzna.shared.gui.DList;
import com.ibm.nzna.shared.gui.MultiList;
import com.ibm.nzna.shared.util.CDate;
import com.ibm.nzna.shared.util.FontUtil;
import com.ibm.nzna.shared.util.LogSystem;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PopUpMachineModel
extends PopUpPanel
implements ProductConstants,
BookmarkDlgListener,
ListSelectionListener,
ActionListener,
AppConst {
    public static final FontUtil fontUtil = GUISystem.getFontUtil();
    public static final Insets buttonMargin = new Insets(0, 0, 0, 0);
    public static final String[] prodListTitle = new String[]{Str.getStr(334), Str.getStr(100), Str.getStr(319), Str.getStr(708)};
    private JLabel st_MACHINES = new JLabel(Str.getStr(340));
    private JLabel st_MODELS = new JLabel(Str.getStr(299));
    private JLabel st_STATUS = new JLabel("");
    private JLabel st_SELECTPRODS = new JLabel(Str.getStr(709));
    private JLabel st_SELECTHELP = new JLabel(Str.getStr(703));
    private DList cnr_MACHINES = new DList();
    private DList cnr_MODELS = new DList();
    private MultiList cnr_PRODUCTS = new MultiList(fontUtil, prodListTitle);
    private JScrollPane scr_MACHINES = new JScrollPane(this.cnr_MACHINES);
    private JScrollPane scr_MODELS = new JScrollPane(this.cnr_MODELS);
    private DButton pb_ASSOCIATEALL = new DButton(Str.getStr(705));
    private DButton pb_ASSOCIATENONE = new DButton(Str.getStr(706));
    private DButton pb_SELECT = new DButton(Str.getStr(404));
    private DButton pb_CANCEL = new DButton(Str.getStr(2));
    private DButton pb_RIGHT = new DButton(">>");
    private DButton pb_RIGHTALL = new DButton(">>");
    private DButton pb_LEFT = new DButton("<<");
    private DButton pb_BOOKMARKS = new DButton(Str.getStr(1017), ImageSystem.getImageIcon((Object)MainWindow.getInstance(), 43));
    private ProdDocRec workRec = null;
    private ProdDocRec originalRec = null;
    private boolean prodListVisible = false;
    private PopUpBrandFamilyListener listener = null;

    public PopUpMachineModel(PopUpDlg popUpDlg) {
        super(popUpDlg);
        this.setLayout(null);
        this.add(this.st_SELECTHELP);
        this.add(this.st_MACHINES);
        this.add(this.st_MODELS);
        this.add(this.st_STATUS);
        this.add(this.st_SELECTPRODS);
        this.add(this.scr_MACHINES);
        this.add(this.pb_LEFT);
        this.add(this.pb_RIGHT);
        this.add(this.pb_RIGHTALL);
        this.add(this.scr_MODELS);
        this.add(this.st_STATUS);
        this.add(this.pb_ASSOCIATEALL);
        this.add(this.pb_ASSOCIATENONE);
        this.add(this.cnr_PRODUCTS);
        this.add(this.pb_BOOKMARKS);
        this.add(this.pb_SELECT);
        this.add(this.pb_CANCEL);
        this.setProdListVisible(false);
        this.pb_ASSOCIATEALL.setVisible(false);
        this.pb_ASSOCIATENONE.setVisible(false);
        this.pb_RIGHTALL.setForeground(Color.blue);
        this.pb_RIGHTALL.setMargin(buttonMargin);
        this.pb_RIGHT.setMargin(buttonMargin);
        this.pb_LEFT.setMargin(buttonMargin);
        this.cnr_PRODUCTS.setColumnWidth(1, 450);
        this.cnr_MACHINES.addListSelectionListener(this);
        this.pb_RIGHTALL.addActionListener(this);
        this.pb_RIGHT.addActionListener(this);
        this.pb_LEFT.addActionListener(this);
        this.pb_ASSOCIATEALL.addActionListener(this);
        this.pb_ASSOCIATENONE.addActionListener(this);
        this.pb_SELECT.addActionListener(this);
        this.pb_CANCEL.addActionListener(this);
        this.cnr_MACHINES.addActionListener(this);
        this.pb_BOOKMARKS.addActionListener(this);
        this.revalidate();
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        int n = 0;
        int n2 = GUISystem.getRowHeight();
        int n3 = dimension.width / 2 - 10;
        int n4 = dimension.height / 2;
        int n5 = 10;
        int n6 = 25;
        super.doLayout();
        this.st_SELECTHELP.setBounds(n5, 0, dimension.width - n5 * 2, n2);
        this.st_MACHINES.setBounds(n5, n += n2, n3 - n6 - n5 * 2, n2);
        this.st_MODELS.setBounds(n3 + n6 + n5, n, n3 - n6 - n5, n2);
        this.scr_MACHINES.setBounds(n5, n += n2, n3 - n6 - n5 * 2, dimension.height - 80);
        this.scr_MODELS.setBounds(n3 + n6 + n5, n, n3 - n6 - n5, dimension.height - 105);
        this.pb_BOOKMARKS.setBounds(n3 + n6 + n5, dimension.height - 60, n3 - n6 - n5, n2);
        this.pb_LEFT.setBounds(n3 - n6, n4 - 50, n6 * 2, 25);
        this.pb_RIGHT.setBounds(n3 - n6, n4 - 15, n6 * 2, 25);
        this.pb_RIGHTALL.setBounds(n3 - n6, n4 + 20, n6 * 2, 25);
        this.st_STATUS.setBounds(n3 + n6 + n5, dimension.height - 30, n3 - n6 - n5, 25);
        if (!this.prodListVisible) {
            this.pb_ASSOCIATEALL.setBounds(n5, dimension.height - 30, n3 - n6 - n5, 25);
            this.pb_ASSOCIATENONE.setBounds(n5, dimension.height - 30, n3 - n6 - n5, 25);
        } else {
            this.pb_ASSOCIATEALL.setBounds(0, 0, 0, 0);
            this.pb_ASSOCIATENONE.setBounds(0, 0, 0, 0);
        }
        this.st_SELECTPRODS.setBounds(n5, 0, dimension.width - n5 * 2, n2);
        this.cnr_PRODUCTS.setBounds(n5, n2, dimension.width - n5 * 2, dimension.height - 55);
        this.pb_SELECT.setBounds(n5, dimension.height - 30, 80, 25);
        this.pb_CANCEL.setBounds(85, dimension.height - 30, 80, 25);
    }

    public Object saveData() {
        if (this.requireData && !this.workRec.hasFamilyAll() && !this.workRec.hasMachineAll() && !this.workRec.hasModels()) {
            GUISystem.printBox(7, 411);
            return null;
        }
        return this.workRec.clone();
    }

    public void setRequired(boolean bl) {
        this.requireData = bl;
    }

    public void refreshData(Object object) {
        try {
            if (object instanceof ProdDocRec) {
                ProdDocRec prodDocRec = (ProdDocRec)object;
                this.workRec = object == null ? new ProdDocRec() : (ProdDocRec)prodDocRec.clone();
            } else {
                this.workRec = new ProdDocRec();
            }
            this.setProdListVisible(false);
            this.cnr_MODELS.setListData(this.workRec.getAssociatedModels());
            this.refreshMachineList();
            this.pb_ASSOCIATEALL.setVisible(false);
            this.pb_ASSOCIATENONE.setVisible(false);
            this.revalidate();
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
    }

    public void setFocus() {
        this.cnr_MACHINES.requestFocus();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof DList) {
            this.associateMachines(true);
        } else if (actionEvent.getSource() instanceof DButton) {
            if (actionEvent.getSource() == this.pb_RIGHT) {
                this.associateMachines(true);
            } else if (actionEvent.getSource() == this.pb_CANCEL) {
                this.setProdListVisible(false);
                this.cnr_PRODUCTS.removeAll();
                this.revalidate();
            } else if (actionEvent.getSource() == this.pb_SELECT) {
                this.associateModels();
            } else if (actionEvent.getSource() == this.pb_LEFT) {
                this.deAssociateModels();
            } else if (actionEvent.getSource() == this.pb_RIGHTALL) {
                this.associateMachinesAll();
            } else if (actionEvent.getSource() == this.pb_ASSOCIATEALL) {
                this.associateMachinesAll();
            } else if (actionEvent.getSource() == this.pb_ASSOCIATENONE) {
                this.associateMachines(false);
            } else if (actionEvent.getSource() == this.pb_BOOKMARKS) {
                new BookmarkDlg((Frame)GUISystem.getParentDefWin(this), this);
            }
        }
    }

    private void applyFamilyToDups(Vector vector) {
        if (vector != null) {
            int n = 0;
            int n2 = 0;
            int n3 = vector.size();
            MachineRec machineRec = null;
            MachineRec machineRec2 = null;
            while (n < n3) {
                if (vector.elementAt(n) instanceof MachineRec) {
                    machineRec = (MachineRec)vector.elementAt(n);
                    n2 = n + 1;
                    while (n2 < n3) {
                        machineRec2 = (MachineRec)vector.elementAt(n2);
                        if (machineRec2.getMachine().equals(machineRec.getMachine())) {
                            machineRec2.setDescript(machineRec2.getMachine() + ", " + Brands.groupRecFromBrandGroupInd((int)machineRec2.getBrandGroupInd()));
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
    }

    private void highlightAssocModels() {
        Object e = this.cnr_MACHINES.getSelectedValue();
        if (e instanceof MachineRec) {
            MachineRec machineRec = (MachineRec)e;
            Vector vector = this.workRec.getAssociatedModels();
            int n = 0;
            int n2 = 0;
            int n3 = vector.size();
            int n4 = 0;
            int[] nArray = null;
            while (n < n3) {
                if (((ProductRec)vector.elementAt(n)).equals(machineRec)) {
                    ++n4;
                }
                ++n;
            }
            if (n4 > 0) {
                nArray = new int[n4];
                n = 0;
                while (n < n3) {
                    if (((ProductRec)vector.elementAt(n)).equals(machineRec)) {
                        nArray[n2] = n;
                        ++n2;
                    }
                    ++n;
                }
                this.cnr_MODELS.setSelectedIndices(nArray);
            }
        }
    }

    public void hiding() {
        this.workRec = null;
        this.cnr_MACHINES.removeAll();
        this.cnr_MODELS.removeAll();
        this.cnr_PRODUCTS.removeAll();
    }

    private void setProdListVisible(boolean bl) {
        this.cnr_PRODUCTS.setVisible(bl);
        this.pb_SELECT.setVisible(bl);
        this.pb_CANCEL.setVisible(bl);
        this.st_SELECTPRODS.setVisible(bl);
        this.scr_MACHINES.setVisible(!bl);
        this.scr_MODELS.setVisible(!bl);
        this.pb_BOOKMARKS.setVisible(!bl);
        this.st_MACHINES.setVisible(!bl);
        this.st_MODELS.setVisible(!bl);
        this.pb_RIGHT.setVisible(!bl);
        this.pb_RIGHTALL.setVisible(!bl);
        this.pb_LEFT.setVisible(!bl);
        this.st_SELECTHELP.setVisible(!bl);
        if (this.popUpDlg != null) {
            this.popUpDlg.setEnabled(!bl);
        }
        if (!bl) {
            this.add(this.pb_ASSOCIATEALL);
            this.add(this.pb_ASSOCIATENONE);
        } else {
            this.remove(this.pb_ASSOCIATEALL);
            this.remove(this.pb_ASSOCIATENONE);
        }
        this.prodListVisible = bl;
    }

    public void setEnabled(boolean bl) {
        this.pb_RIGHT.setEnabled(bl);
        this.pb_RIGHTALL.setEnabled(bl);
        this.pb_LEFT.setEnabled(bl);
        this.pb_SELECT.setEnabled(bl);
        this.pb_CANCEL.setEnabled(bl);
        this.pb_ASSOCIATEALL.setEnabled(bl);
        this.pb_ASSOCIATENONE.setEnabled(bl);
        this.cnr_PRODUCTS.setEnabled(bl);
        if (this.popUpDlg != null) {
            this.popUpDlg.setEnabled(bl);
        }
    }

    private void showProductList(MachineRec machineRec) {
        Vector vector = null;
        this.setEnabled(false);
        this.st_STATUS.setText(Str.getStr(710) + " " + machineRec.toString());
        vector = machineRec.isOption() ? this.readModelsForOptions(machineRec.getMachine(), machineRec.getBrandGroupInd()) : this.readModels(machineRec.getSubMachine(), machineRec.getBrandGroupInd());
        this.setEnabled(true);
        if (vector != null && vector.size() > 0) {
            this.cnr_PRODUCTS.removeAll();
            this.cnr_PRODUCTS.setData(vector);
            this.setProdListVisible(true);
            this.revalidate();
        }
        this.st_STATUS.setText("");
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object[] objectArray = this.cnr_MACHINES.getSelectedValues();
        int n = 0;
        int n2 = 0;
        if (objectArray != null) {
            int n3 = 0;
            while (n3 < objectArray.length) {
                if (objectArray[n3] instanceof MachineRec) {
                    if (((MachineRec)objectArray[n3]).getAll()) {
                        ++n;
                    } else {
                        ++n2;
                    }
                }
                ++n3;
            }
            this.pb_ASSOCIATEALL.setVisible(n2 > n);
            this.pb_ASSOCIATENONE.setVisible(n >= n2);
        } else {
            this.pb_ASSOCIATEALL.setVisible(false);
            this.pb_ASSOCIATENONE.setVisible(false);
        }
        this.highlightAssocModels();
    }

    private void associateMachines(boolean bl) {
        if (bl) {
            Object e = this.cnr_MACHINES.getSelectedValue();
            if (e instanceof MachineRec) {
                MachineRec machineRec = (MachineRec)e;
                if (machineRec.getAll()) {
                    this.workRec.addMachineAssociation(machineRec);
                }
                this.showProductList(machineRec);
            }
        } else {
            Object[] objectArray = this.cnr_MACHINES.getSelectedValues();
            int n = 0;
            if (objectArray != null && objectArray.length > 0) {
                while (n < objectArray.length) {
                    if (objectArray[n] instanceof MachineRec) {
                        this.workRec.addMachineAssociation((MachineRec)objectArray[n]);
                    }
                    ++n;
                }
                this.pb_ASSOCIATEALL.setVisible(true);
                this.pb_ASSOCIATENONE.setVisible(false);
                this.revalidate();
                this.repaint();
            }
        }
        this.cnr_MODELS.setListData(this.workRec.getAssociatedModels());
    }

    private void associateMachinesAll() {
        Object[] objectArray = this.cnr_MACHINES.getSelectedValues();
        if (objectArray != null && objectArray.length > 0) {
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] instanceof MachineRec) {
                    this.workRec.addMachineAllAssociation((MachineRec)objectArray[n]);
                }
                ++n;
            }
        }
        this.cnr_MODELS.setListData(this.workRec.getAssociatedModels());
        this.pb_ASSOCIATEALL.setVisible(false);
        this.pb_ASSOCIATENONE.setVisible(true);
        this.revalidate();
        this.repaint();
    }

    private void associateModels() {
        Object[] objectArray = this.cnr_PRODUCTS.getJList().getSelectedValues();
        int n = 0;
        if (objectArray != null && objectArray.length > 0) {
            while (n < objectArray.length) {
                if (objectArray[n] instanceof ProductRec) {
                    this.workRec.addModelAssociation((ProductRec)objectArray[n]);
                }
                ++n;
            }
        }
        this.cnr_MODELS.setListData(this.workRec.getAssociatedModels());
        this.setProdListVisible(false);
        this.revalidate();
    }

    private void deAssociateModels() {
        Object[] objectArray = this.cnr_MODELS.getSelectedValues();
        int n = 0;
        if (objectArray != null && objectArray.length > 0) {
            while (n < objectArray.length) {
                if (objectArray[n] instanceof ProductRec) {
                    this.workRec.deAssociateModel((ProductRec)objectArray[n]);
                }
                ++n;
            }
        }
        this.cnr_MODELS.setListData(this.workRec.getAssociatedModels());
        this.revalidate();
    }

    private void refreshMachineList() {
        Vector vector = this.workRec.getMachineFamilyList();
        this.applyFamilyToDups(vector);
        this.cnr_MACHINES.setListData(vector);
    }

    public void bookmarkSelected(Vector vector) {
        if (vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            Bookmark bookmark = null;
            while (n < n2) {
                bookmark = (Bookmark)vector.elementAt(n);
                if (bookmark.getBookmarkType() == 2) {
                    Integer n3 = (Integer)bookmark.getObject();
                    ProductRec productRec = new ProductRec(n3);
                    this.st_STATUS.setText(Str.getStr(142) + " " + n3);
                    if (productRec.readFromDatabase() == 0) {
                        this.workRec.addModelAssociation(productRec);
                        this.cnr_MODELS.setListData(this.workRec.getAssociatedModels());
                        this.refreshMachineList();
                    }
                }
                ++n;
            }
        }
        this.st_STATUS.setText("");
        if (this.listener != null) {
            this.listener.brandFamilyChanged(this);
        }
    }

    private Vector readModelsForOptions(String string, int n) {
        Vector<ProductRec> vector = new Vector<ProductRec>(1, 1);
        SQLMethod sQLMethod = new SQLMethod(1, "readModels", 10);
        Object var5_5 = null;
        try {
            Statement statement = sQLMethod.createStatement();
            ProductRec productRec = null;
            ResultSet resultSet = statement.executeQuery("SELECT A.PRODINT, A.PRODNUM, B.DESCRIPT, A.MODEL, A.PRODDESC, A.STATUSIND, A.STATUSDATE FROM TIGRIS.PRODUCTS A,      TIGRIS.PRODMACHINEDESC B WHERE A.BRANDGROUPIND = " + n + " AND " + "      B.DESCRIPT      = '" + string + "' AND " + "      A.MODEL        <> 'All' AND " + "      A.RECYCLED      = 'N' AND " + "      A.PRODINT       = B.PRODINT order by A.PRODNUM");
            while (resultSet.next()) {
                productRec = new ProductRec(resultSet.getInt(1), resultSet.getString(2).trim(), resultSet.getString(3).trim(), resultSet.getString(4).trim());
                productRec.setFieldData(5, resultSet.getString(5).trim());
                productRec.setFieldData(6, new StatusRec(resultSet.getInt(6), CDate.convertDate(10, 2, resultSet.getString(7).trim())));
                productRec.setFieldData(11, new Integer(n));
                vector.addElement(productRec);
            }
            resultSet.close();
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception, false);
            GUISystem.printBox((Frame)GUISystem.getParentDefWin(this), Str.getStr(7), Str.getStr(1269));
        }
        sQLMethod.close();
        return vector;
    }

    private Vector readModels(String string, int n) {
        Vector<ProductRec> vector = new Vector<ProductRec>(1, 1);
        SQLMethod sQLMethod = new SQLMethod(1, "readModels", 10);
        Object var5_5 = null;
        try {
            Statement statement = sQLMethod.createStatement();
            ProductRec productRec = null;
            ResultSet resultSet = statement.executeQuery("SELECT PRODINT, PRODNUM, MACHINE, MODEL, PRODDESC, STATUSIND, STATUSDATE FROM TIGRIS.PRODUCTS WHERE BRANDGROUPIND = " + n + " AND " + "      MACHINE       = '" + string + "' AND " + "      MODEL        <> 'All' AND " + "      RECYCLED      = 'N' order by PRODNUM");
            while (resultSet.next()) {
                productRec = new ProductRec(resultSet.getInt(1), resultSet.getString(2).trim(), resultSet.getString(3).trim(), resultSet.getString(4).trim());
                productRec.setFieldData(5, resultSet.getString(5).trim());
                productRec.setFieldData(6, new StatusRec(resultSet.getInt(6), CDate.convertDate(10, 2, resultSet.getString(7).trim())));
                productRec.setFieldData(11, new Integer(n));
                vector.addElement(productRec);
            }
            resultSet.close();
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception, false);
            GUISystem.printBox((Frame)GUISystem.getParentDefWin(this), Str.getStr(7), Str.getStr(1269));
        }
        sQLMethod.close();
        return vector;
    }

    public void setPopUpBrandFamilyListener(PopUpBrandFamilyListener popUpBrandFamilyListener) {
        this.listener = popUpBrandFamilyListener;
    }

    public ProdDocRec getWorkingRec() {
        return this.workRec;
    }
}

