/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.help;

import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.gui.ActionButton;
import com.ibm.nzna.projects.qit.gui.ApplicationTitlePanel;
import com.ibm.nzna.projects.qit.gui.Browser;
import com.ibm.nzna.projects.qit.gui.BrowserListener;
import com.ibm.nzna.projects.qit.gui.NavPanel;
import com.ibm.nzna.projects.qit.gui.QuestPanel;
import com.ibm.nzna.projects.qit.help.HelpNavPanel;
import com.ibm.nzna.projects.qit.help.HelpPage;
import com.ibm.nzna.projects.qit.help.HelpSystem;
import com.ibm.nzna.projects.qit.help.HelpWindow;
import com.ibm.nzna.shared.util.WinUtil;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class HelpContentPanel
extends JPanel
implements BrowserListener,
ActionListener,
AppConst,
QuestPanel {
    private Browser browser = null;
    private HelpNavPanel navPanel = null;
    private boolean enabled = true;
    private HelpPage helpPage = null;
    private ActionButton pb_CLOSE = null;
    private ActionButton pb_INDEX = null;
    private ActionButton pb_HELP = null;
    private HelpWindow helpWin = null;
    private ApplicationTitlePanel titlePanel = null;
    private String helpUrl = this.helpUrl = null;

    public boolean initialize() {
        this.browser = GUISystem.createBrowser();
        this.navPanel = new HelpNavPanel(this, this.helpPage);
        this.pb_CLOSE = new ActionButton(Str.getStr(28), ImageSystem.getImageIcon((Object)this, 8), Str.getStr(27));
        this.pb_INDEX = new ActionButton(Str.getStr(29), ImageSystem.getImageIcon((Object)this, 9), Str.getStr(30));
        this.pb_HELP = new ActionButton(Str.getStr(10), ImageSystem.getImageIcon((Object)this, 10), Str.getStr(31));
        this.browser.addBrowserListener(this);
        this.pb_CLOSE.addActionListener(this);
        this.pb_INDEX.addActionListener(this);
        this.pb_HELP.addActionListener(this);
        this.setLayout(new BorderLayout());
        this.add(this.browser.getComponent());
        return true;
    }

    public void start() {
        if (this.helpUrl == null) {
            this.setTitle(Str.getStr(10));
        }
        if (this.helpWin == null) {
            this.helpWin = HelpSystem.getHelpWindow();
        }
        this.helpWin.addActionComponent(this.pb_CLOSE);
        this.helpWin.addActionComponent(this.pb_INDEX);
        this.helpWin.addActionComponent(this.pb_HELP);
        System.out.println("Started!");
        this.invalidate();
    }

    public boolean stop() {
        this.remove(this.browser.getComponent());
        this.browser = null;
        return true;
    }

    public boolean shutdown() {
        return true;
    }

    public NavPanel getDefaultNavPanel() {
        return this.navPanel;
    }

    protected void searchAll(boolean bl) {
    }

    public JComponent getJComponent() {
        return this;
    }

    public void enableInput(boolean bl) {
        this.enabled = this.enabled;
    }

    public ImageIcon getIcon() {
        return ImageSystem.getImageIcon((Object)this, 3);
    }

    public void setPageContent(String string) {
        this.helpUrl = string;
        this.helpPage = null;
        if (this.browser != null) {
            this.browser.loadURL(string);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.pb_CLOSE) {
            WinUtil.getParentJDialog(this).dispose();
        } else if (actionEvent.getSource() == this.pb_INDEX) {
            HelpSystem.showHelp("app/index.html");
        } else if (actionEvent.getSource() == this.pb_HELP) {
            HelpSystem.showHelp("app/helponhelp.html");
        }
    }

    public boolean cutText() {
        return false;
    }

    public boolean pasteText() {
        return false;
    }

    public boolean copyText() {
        return false;
    }

    public void refresh() {
    }

    public void panelSelected() {
    }

    public void panelDeselected() {
    }

    public String getName() {
        return Str.getStr(10);
    }

    public void setHelpWin(HelpWindow helpWindow) {
        this.helpWin = helpWindow;
    }

    public boolean bookmark() {
        return false;
    }

    public void setTitlePanel(ApplicationTitlePanel applicationTitlePanel) {
        this.titlePanel = applicationTitlePanel;
    }

    public void pageStopped() {
        this.helpPage = new HelpPage(this.browser.getSource());
        if (this.helpPage.getTitle().indexOf("404") >= 0) {
            this.browser.setPageContent(Str.getStr(1288));
            this.setTitle(Str.getStr(1289));
        } else {
            if (this.navPanel != null) {
                this.navPanel.setHelpPage(this.helpPage);
                this.navPanel.refreshNavList();
            }
            this.setTitle(this.helpPage.getTitle());
        }
    }

    public void mouseLinkExit() {
    }

    public void mouseOverLink(String string) {
    }

    public void pageStarted(String string) {
        this.setTitle(Str.getStr(14));
    }

    public boolean linkClicked(String string) {
        return true;
    }

    private void setTitle(String string) {
        if (this.titlePanel != null) {
            this.titlePanel.setTitle(string);
        }
    }

    public void statusChange(String string, int n, int n2) {
    }

    public HelpContentPanel(String string) {
    }
}

