/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.help;

import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.gui.NavList;
import com.ibm.nzna.projects.qit.gui.NavListGroup;
import com.ibm.nzna.projects.qit.gui.NavPanel;
import com.ibm.nzna.projects.qit.help.HelpContentPanel;
import com.ibm.nzna.projects.qit.help.HelpPage;
import com.ibm.nzna.projects.qit.help.HelpSystem;
import com.ibm.nzna.projects.qit.help.tutor.TutorWin;
import com.ibm.nzna.shared.gui.HotLinkLabel;
import com.ibm.nzna.shared.util.LogSystem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class HelpNavPanel
extends JPanel
implements ActionListener,
AppConst,
NavPanel {
    private NavList navList = null;
    private NavListGroup searchGroup = null;
    private NavListGroup howToGroup = null;
    private NavListGroup shortCutGroup = null;
    private NavListGroup tutorialGroup = null;
    private NavListGroup seeAlsoGroup = null;
    private HelpPage helpPage = null;
    private HotLinkLabel st_HELPFULHINTS = null;
    private HotLinkLabel st_SEARCHALL = null;
    private HelpContentPanel sibPanel = null;
    private JScrollPane navListScroll = null;

    public void initialize() {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.white);
        this.refreshNavList();
    }

    public void setHelpPage(HelpPage helpPage) {
        this.helpPage = helpPage;
    }

    public void refreshNavList() {
        try {
            if (this.navListScroll == null) {
                this.navListScroll = new JScrollPane();
                this.add((Component)this.navListScroll, "Center");
            }
            if (this.navList != null) {
                this.navListScroll.remove(this.navList);
            }
            this.navList = new NavList();
            this.navListScroll.getViewport().setView(this.navList);
            if (this.helpPage != null) {
                if (this.helpPage.getHowTos() != null) {
                    this.howToGroup = new NavListGroup(Str.getStr(20));
                    this.navList.add(this.howToGroup);
                    this.addHowTos();
                }
                if (this.helpPage.getShortCuts() != null) {
                    this.shortCutGroup = new NavListGroup(Str.getStr(18));
                    this.navList.add(this.shortCutGroup);
                    this.addShortCuts();
                }
                if (this.helpPage.getSeeAlso() != null) {
                    this.seeAlsoGroup = new NavListGroup(Str.getStr(21));
                    this.navList.add(this.seeAlsoGroup);
                    this.addSeeAlso();
                }
                if (this.helpPage.getTutorial() != null) {
                    this.tutorialGroup = new NavListGroup(Str.getStr(1264));
                    this.navList.add(this.tutorialGroup);
                    this.addTutorials();
                }
                if (this.seeAlsoGroup != null) {
                    this.seeAlsoGroup.setIcon(ImageSystem.getImageIcon((Object)this, 12));
                }
                if (this.shortCutGroup != null) {
                    this.shortCutGroup.setIcon(ImageSystem.getImageIcon((Object)this, 11));
                }
                if (this.howToGroup != null) {
                    this.howToGroup.setIcon(ImageSystem.getImageIcon((Object)this, 10));
                }
                if (this.tutorialGroup != null) {
                    this.tutorialGroup.setIcon(ImageSystem.getImageIcon((Object)this, 173));
                }
                if (this.howToGroup != null) {
                    this.howToGroup.expand();
                }
                if (this.seeAlsoGroup != null) {
                    this.seeAlsoGroup.expand();
                }
                if (this.shortCutGroup != null) {
                    this.shortCutGroup.expand();
                }
                if (this.tutorialGroup != null) {
                    this.tutorialGroup.expand();
                }
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
    }

    public void start() {
    }

    public void stop() {
    }

    public String getTitle() {
        return Str.getStr(10);
    }

    public JComponent getJComponent() {
        return this;
    }

    private void addHowTos() {
        String[][] stringArray = this.helpPage.getHowTos();
        if (stringArray != null && stringArray.length > 0) {
            int n = 0;
            HotLinkLabel hotLinkLabel = null;
            while (n < stringArray.length) {
                hotLinkLabel = new HotLinkLabel(stringArray[n][1]);
                this.howToGroup.add(hotLinkLabel);
                hotLinkLabel.addActionListener(this);
                hotLinkLabel.setActionCommand("HOW_TO");
                ++n;
            }
        }
    }

    private void addShortCuts() {
        String[][] stringArray = this.helpPage.getShortCuts();
        if (stringArray != null && stringArray.length > 0) {
            int n = 0;
            HotLinkLabel hotLinkLabel = null;
            while (n < stringArray.length) {
                hotLinkLabel = new HotLinkLabel(stringArray[n][1]);
                this.shortCutGroup.add(hotLinkLabel);
                hotLinkLabel.addActionListener(this);
                hotLinkLabel.setActionCommand("SHORT_CUT");
                ++n;
            }
        }
    }

    private void addSeeAlso() {
        String[][] stringArray = this.helpPage.getSeeAlso();
        if (stringArray != null && stringArray.length > 0) {
            int n = 0;
            HotLinkLabel hotLinkLabel = null;
            while (n < stringArray.length) {
                hotLinkLabel = new HotLinkLabel(stringArray[n][1]);
                this.seeAlsoGroup.add(hotLinkLabel);
                hotLinkLabel.addActionListener(this);
                hotLinkLabel.setActionCommand("SEE_ALSO");
                ++n;
            }
        }
    }

    private void addTutorials() {
        String[][] stringArray = this.helpPage.getTutorial();
        if (stringArray != null && stringArray.length > 0) {
            int n = 0;
            HotLinkLabel hotLinkLabel = null;
            while (n < stringArray.length) {
                hotLinkLabel = new HotLinkLabel(stringArray[n][1]);
                this.tutorialGroup.add(hotLinkLabel);
                hotLinkLabel.addActionListener(this);
                hotLinkLabel.setActionCommand("TUTORIAL");
                ++n;
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.st_SEARCHALL) {
            this.sibPanel.searchAll(true);
        } else if (actionEvent.getActionCommand().equals("HOW_TO")) {
            String string = this.helpPage.destFromHowTo(((HotLinkLabel)actionEvent.getSource()).getText());
            HelpSystem.showHelp(string);
        } else if (actionEvent.getActionCommand().equals("SEE_ALSO")) {
            String string = this.helpPage.destFromSeeAlso(((HotLinkLabel)actionEvent.getSource()).getText());
            HelpSystem.showHelp(string);
        } else if (actionEvent.getActionCommand().equals("SHORT_CUT")) {
            String string = this.helpPage.destFromShortCut(((HotLinkLabel)actionEvent.getSource()).getText());
            HelpSystem.showHelp(string);
        } else if (actionEvent.getActionCommand().equals("TUTORIAL")) {
            int n = this.helpPage.destFromTutorial(((HotLinkLabel)actionEvent.getSource()).getText());
            new TutorWin(false, n);
        }
    }

    public HelpNavPanel(HelpContentPanel helpContentPanel, HelpPage helpPage) {
        this.sibPanel = helpContentPanel;
        this.setHelpPage(helpPage);
    }
}

