/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.notify;

import com.ibm.nzna.projects.common.quest.Counter;
import com.ibm.nzna.projects.common.quest.brand.Brands;
import com.ibm.nzna.projects.common.quest.type.TypeCategoryRec;
import com.ibm.nzna.projects.common.quest.type.TypeList;
import com.ibm.nzna.projects.common.quest.type.TypeResolutionRec;
import com.ibm.nzna.projects.qit.Qit;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.MainWindow;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.gui.MultiListRow;
import com.ibm.nzna.shared.gui.MultiListSort;
import com.ibm.nzna.shared.pom.PersistentRec;
import com.ibm.nzna.shared.util.CDate;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.Text;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;

public class NotificationRec
extends PersistentRec
implements MultiListSort,
MultiListRow,
Serializable,
AppConst {
    static final long serialVersionUID = 1000000L;
    private static final String bodyTemplate = "<HTML><BODY><P><FONT FACE=\"Helvetica\" SIZE=2><FONT COLOR=\"#800080\">TO: </FONT>VAL_TO<BR><FONT COLOR=\"#800080\">FROM: </FONT>VAL_FROM<BR><FONT COLOR=\"#800080\">DATE: </FONT>VAL_DATE<BR><FONT COLOR=\"#800080\">BRAND: </FONT>VAL_BRAND<BR><FONT COLOR=\"#800080\">RESOLUTION: </FONT>VAL_RESOL<BR><FONT COLOR=\"#800080\">DOCUMENT: </FONT>VAL_DOC<BR><br>VAL_BODY</P></FONT></BODY></HTML>";
    public static final int SEND_NEW = 0;
    public static final int SEND_REPLY = 1;
    public static final int SEND_FORWARD = 2;
    public String toUser = null;
    public String fromUser = null;
    public String subject = null;
    public String prettyFrom = null;
    public TypeCategoryRec brandRec = null;
    public TypeResolutionRec resolRec = null;
    public String comments = null;
    public String openDate = null;
    public String closeDate = null;
    public int docInd = 0;
    public int existingDocInd = 0;
    public int noteInd = 0;
    public boolean read = false;
    public int sendType = 0;
    public boolean notifySent = false;
    public boolean mustSend = false;
    public int brandInd = 0;
    public int resolInd = 0;

    public Object getColumnData(int n) {
        Object object = null;
        switch (n) {
            case 0: {
                if (this.read) {
                    object = ImageSystem.getImageIcon((Object)MainWindow.getInstance(), 99).getImage();
                    break;
                }
                object = ImageSystem.getImageIcon((Object)MainWindow.getInstance(), 100).getImage();
                break;
            }
            case 1: {
                object = this.subject;
                break;
            }
            case 2: {
                object = this.prettyFrom;
                break;
            }
            case 3: {
                object = this.openDate;
                break;
            }
        }
        if (object == null) {
            object = new String("");
        }
        return object;
    }

    public String getBody(NotificationRec notificationRec) {
        String string = null;
        if (notificationRec != null) {
            String string2 = null;
            string2 = Text.replaceAllStrInStr(notificationRec.comments, "\n", "<br>");
            string = Text.replaceInStr(bodyTemplate, "TO", Str.getStr(657));
            string = Text.replaceInStr(string, "FROM", Str.getStr(658));
            string = Text.replaceInStr(string, "DATE", Str.getStr(655));
            string = Text.replaceInStr(string, "BRAND", Str.getStr(145));
            string = Text.replaceInStr(string, "RESOLUTION", Str.getStr(169));
            string = Text.replaceInStr(string, "DOCUMENT", Str.getStr(204));
            string = Text.replaceInStr(string, "VAL_TO", UserSystem.getNameFromUserId(notificationRec.toUser));
            string = Text.replaceInStr(string, "VAL_FROM", notificationRec.prettyFrom);
            string = Text.replaceInStr(string, "VAL_DATE", notificationRec.openDate);
            string = Text.replaceInStr(string, "VAL_BRAND", notificationRec.brandRec.toString());
            string = Text.replaceInStr(string, "VAL_RESOL", notificationRec.resolRec.toString());
            string = Text.replaceInStr(string, "VAL_DOC", "<a href=\"quest://" + notificationRec.docInd + "\">" + notificationRec.docInd + " (" + this.getDocTitle(notificationRec.docInd) + ") </a>");
            string = Text.replaceInStr(string, "VAL_BODY", string2);
        }
        return string;
    }

    public String getDocIndStr() {
        String string = "NULL";
        if (this.docInd != 0) {
            string = "" + this.docInd;
        }
        return string;
    }

    public String getCloseDateStr() {
        String string = "NULL";
        if (this.closeDate != null && this.closeDate.length() > 6) {
            string = "'" + this.closeDate + "'";
        }
        return string;
    }

    public void copyToClipboard(Clipboard clipboard) {
        if (clipboard != null) {
            StringSelection stringSelection = new StringSelection(this.getBody(this));
            clipboard.setContents(stringSelection, stringSelection);
        } else {
            LogSystem.log(1, "Clipboard Not Available");
        }
    }

    public static void cleanDBChars(NotificationRec notificationRec) {
        notificationRec.toUser = Text.cleanDBString(notificationRec.toUser);
        notificationRec.subject = Text.cleanDBString(notificationRec.subject);
        notificationRec.fromUser = Text.cleanDBString(notificationRec.fromUser);
        notificationRec.comments = Text.cleanDBString(notificationRec.comments);
        notificationRec.openDate = Text.cleanDBString(notificationRec.openDate);
        notificationRec.closeDate = Text.cleanDBString(notificationRec.closeDate);
    }

    public boolean saveToDatabase(NotificationRec notificationRec) {
        String string = "saveToDatabase (Notification)";
        SQLMethod sQLMethod = new SQLMethod(1, string, 5);
        boolean bl = false;
        String string2 = null;
        Qit.setEnabled(false);
        if (notificationRec != null && notificationRec.getRecStatus() != 4 && notificationRec.getRecStatus() != 0) {
            try {
                Statement statement = sQLMethod.createStatement();
                String string3 = notificationRec.read ? "Y" : "N";
                NotificationRec.cleanDBChars(notificationRec);
                switch (notificationRec.getRecStatus()) {
                    case 2: {
                        if (notificationRec.noteInd == 0) {
                            notificationRec.noteInd = Counter.getCounter(LogSystem.getInstance(), "NOTEIND");
                        }
                        string2 = "INSERT INTO QUEST.NOTIFICATION " + "( NOTEIND, SUBJECT,  BRANDIND,  RESOLIND, COMMENT, TOUSER, " + "  DOCIND,  OPENDATE, CLOSEDATE, READ,     DBUSER,  CHANGEDTIME )" + "values (  " + notificationRec.noteInd + ",                     " + "         '" + notificationRec.subject + "',                    " + "          " + notificationRec.brandRec.getInd() + ",           " + "          " + notificationRec.resolRec.getInd() + ",           " + "         '" + notificationRec.comments + "',                   " + "         '" + notificationRec.toUser + "',                     " + "          " + notificationRec.getDocIndStr() + ",              " + "         '" + notificationRec.openDate + "',                   " + "          " + notificationRec.getCloseDateStr() + ",           " + "         '" + string3 + "', " + "         '" + UserSystem.getUserId() + "',               " + "         CURRENT TIMESTAMP )";
                        break;
                    }
                    case 1: {
                        string2 = "UPDATE QUEST.NOTIFICATION " + "SET   SUBJECT      = '" + notificationRec.subject + "', " + "      BRANDIND     =  " + notificationRec.brandRec.getInd() + ", " + "      RESOLIND     =  " + notificationRec.resolRec.getInd() + ", " + "      COMMENT      = '" + notificationRec.comments + "', " + "      TOUSER       = '" + notificationRec.toUser + "', " + "      DOCIND       =  " + notificationRec.getDocIndStr() + ", " + "      OPENDATE     = '" + notificationRec.openDate + "', " + "      CLOSEDATE    =  " + notificationRec.getCloseDateStr() + ", " + "      READ         = '" + string3 + "'  " + "WHERE NOTEIND      = " + notificationRec.noteInd;
                        break;
                    }
                    case 3: {
                        boolean bl2 = GUISystem.printBox(8, 1324);
                        string2 = "DELETE FROM QUEST.NOTIFICATION " + "WHERE NOTEIND = " + notificationRec.noteInd;
                        if (!bl2) break;
                        statement.executeUpdate(string2);
                        string2 = "UPDATE QUEST.DOCUMENT " + "SET RECYCLED = 'Y', " + "DBUSER       = '" + UserSystem.getUserId() + "', " + "CHANGEDTIME  = CURRENT TIMESTAMP " + "WHERE DOCIND = " + this.docInd;
                        break;
                    }
                }
                statement.executeUpdate(string2);
                bl = true;
            }
            catch (Exception exception) {
                sQLMethod.rollBack();
                LogSystem.log(1, exception);
            }
        }
        sQLMethod.close();
        Qit.setEnabled(true);
        return bl;
    }

    public static Vector readListFromDatabase(String string) {
        Vector<NotificationRec> vector = new Vector<NotificationRec>(1);
        SQLMethod sQLMethod = new SQLMethod(1, "NotifyReader.read", 3);
        try {
            Statement statement = sQLMethod.createStatement();
            String string2 = null;
            ResultSet resultSet = null;
            NotificationRec notificationRec = null;
            string2 = "SELECT NOTEIND, SUBJECT, BRANDIND, RESOLIND,  COMMENT, " + "       TOUSER,  DOCIND,  OPENDATE, CLOSEDATE, READ,    " + "       DBUSER,  CHANGEDTIME " + "FROM QUEST.NOTIFICATION " + "WHERE TOUSER = '" + string + "' " + "ORDER BY OPENDATE FOR FETCH ONLY";
            resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                notificationRec = new NotificationRec();
                notificationRec.noteInd = resultSet.getInt(1);
                notificationRec.subject = resultSet.getString(2).trim();
                notificationRec.brandInd = resultSet.getInt(3);
                notificationRec.resolInd = resultSet.getInt(4);
                notificationRec.comments = resultSet.getString(5).trim();
                notificationRec.toUser = resultSet.getString(6).trim();
                notificationRec.docInd = resultSet.getInt(7);
                notificationRec.openDate = CDate.convertDate(10, 2, resultSet.getString(8).trim());
                notificationRec.closeDate = resultSet.getString(9);
                notificationRec.read = resultSet.getString(10).equals("Y");
                notificationRec.fromUser = resultSet.getString(11).trim();
                notificationRec.brandRec = Brands.getBrand(notificationRec.brandInd);
                notificationRec.resolRec = (TypeResolutionRec)TypeList.getInstance().objectFromInd(notificationRec.resolInd, 16);
                notificationRec.prettyFrom = UserSystem.getNameFromUserId(notificationRec.fromUser);
                if (notificationRec.closeDate != null) {
                    notificationRec.closeDate = notificationRec.closeDate.trim();
                }
                vector.addElement(notificationRec);
            }
            resultSet.close();
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception);
        }
        sQLMethod.close();
        return vector;
    }

    public int getDocInd() {
        return this.docInd;
    }

    public int compareTo(MultiListSort multiListSort, int n) {
        int n2 = 0;
        switch (n) {
            case 1: {
                n2 = this.subject.compareTo(((NotificationRec)multiListSort).subject);
                break;
            }
            case 2: {
                n2 = this.prettyFrom.compareTo(((NotificationRec)multiListSort).prettyFrom);
                break;
            }
            case 3: {
                n2 = CDate.compareDate(this.openDate, ((NotificationRec)multiListSort).openDate, 2);
                break;
            }
        }
        return n2;
    }

    private String getDocTitle(int n) {
        SQLMethod sQLMethod = new SQLMethod(1, "getDocTitle", 5);
        String string = "";
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT TITLE FROM QUEST.DOCUMENTS WHERE DOCIND = " + n);
            if (resultSet.next()) {
                string = resultSet.getString(1).trim();
            }
            resultSet.close();
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception, false);
        }
        sQLMethod.close();
        return string;
    }

    public NotificationRec() {
    }

    public NotificationRec(NotificationRec notificationRec) {
        this.toUser = notificationRec.toUser;
        this.fromUser = notificationRec.fromUser;
        this.subject = notificationRec.subject;
        this.prettyFrom = notificationRec.prettyFrom;
        this.brandRec = notificationRec.brandRec;
        this.resolRec = notificationRec.resolRec;
        this.comments = notificationRec.comments;
        this.openDate = notificationRec.openDate;
        this.closeDate = notificationRec.closeDate;
        this.docInd = notificationRec.docInd;
        this.existingDocInd = notificationRec.existingDocInd;
        this.noteInd = notificationRec.noteInd;
        this.read = notificationRec.read;
        this.sendType = notificationRec.sendType;
        this.notifySent = notificationRec.notifySent;
        this.mustSend = notificationRec.mustSend;
        this.brandInd = notificationRec.brandInd;
        this.resolInd = notificationRec.resolInd;
    }
}

