/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.product;

import com.ibm.nzna.projects.common.quest.Counter;
import com.ibm.nzna.projects.common.quest.brand.Brands;
import com.ibm.nzna.projects.common.quest.type.TypeBrandRec;
import com.ibm.nzna.projects.common.quest.type.TypeCountryCodeRec;
import com.ibm.nzna.projects.common.quest.type.TypeGeoRec;
import com.ibm.nzna.projects.common.quest.type.TypeGroupRec;
import com.ibm.nzna.projects.common.storedProc.sqlRunner.SqlRunner;
import com.ibm.nzna.projects.qit.Qit;
import com.ibm.nzna.projects.qit.app.AppSQL;
import com.ibm.nzna.projects.qit.app.DateSystem;
import com.ibm.nzna.projects.qit.app.FieldListener;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.LocaleRec;
import com.ibm.nzna.projects.qit.app.MainWindow;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.QITRec;
import com.ibm.nzna.projects.qit.app.StatusRec;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserRec;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.doc.DocFamilyRec;
import com.ibm.nzna.projects.qit.product.MachineRec;
import com.ibm.nzna.projects.qit.product.ProdStatusRec;
import com.ibm.nzna.projects.qit.product.ProductConstants;
import com.ibm.nzna.projects.qit.storedProc.sqlRunner.QITSqlRunner;
import com.ibm.nzna.projects.qit.type.QITTypeList;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.db.SQLParse;
import com.ibm.nzna.shared.gui.ExtendedMultiListRow;
import com.ibm.nzna.shared.gui.MultiListSort;
import com.ibm.nzna.shared.pom.PersistentRec;
import com.ibm.nzna.shared.util.CDate;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.StoreUtil;
import com.ibm.nzna.shared.util.Text;
import java.awt.Graphics;
import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public final class ProductRec
extends QITRec
implements Serializable,
MultiListSort,
Runnable,
ProductConstants,
ExtendedMultiListRow {
    static final long serialVersionUID = 1000000L;
    private static final String THREAD_FIREFIELDCHANGE = "FFC";
    public static final int LENGTH_MACHINE = 4;
    public static final int LENGTH_MODEL = 3;
    public static final int LENGTH_PRODDESC = 254;
    public static final int LENGTH_PRODNUM = 8;
    private String productNumber = null;
    private String model = null;
    private String dbUser = null;
    private String changedTime = null;
    private String descript = null;
    private String maintLock = null;
    private TypeBrandRec brandRec = null;
    private TypeGroupRec groupRec = null;
    private ProdStatusRec statusRec = null;
    private Vector statusHistory = null;
    private LocaleRec locRec = null;
    private MachineRec machineRec = null;
    private int prodInt = 0;
    private int graphicGrpInd = 0;
    private int multimediaGrpInd = 0;
    private int lastDescriptPixelWidth = 0;
    private String[] descriptArray = null;
    private boolean optionInfoRead = false;
    private boolean recycled = false;
    private String prettydbUser = null;
    private String prettyChangedTime = null;
    private boolean isOption = false;
    private Vector listenerVec = null;
    private int changedField = 0;
    private boolean autoSetProductNumber = true;
    private boolean hasChanged = false;

    private void init() {
        this.initializeMachineRec();
    }

    public void setData(ProductRec productRec) {
        try {
            if (productRec != null) {
                PersistentRec persistentRec;
                this.setFieldData(4, productRec.getFieldData(4));
                this.setFieldData(2, productRec.getFieldData(2));
                this.setFieldData(3, productRec.getFieldData(3));
                this.setFieldData(9, productRec.getFieldData(9));
                this.setFieldData(10, productRec.getFieldData(10));
                this.setFieldData(17, productRec.getFieldData(17));
                this.setFieldData(0, productRec.getFieldData(0));
                this.setFieldData(1, productRec.getFieldData(1));
                this.setFieldData(16, productRec.getFieldData(16));
                this.setFieldData(12, productRec.getFieldData(12));
                this.setFieldData(13, productRec.getFieldData(13));
                this.setFieldData(5, productRec.getFieldData(5));
                if (productRec.getFieldData(7) != null) {
                    persistentRec = (LocaleRec)productRec.getFieldData(7);
                    this.setFieldData(7, ((LocaleRec)persistentRec).clone());
                }
                if (productRec.getFieldData(6) != null) {
                    persistentRec = (ProdStatusRec)productRec.getFieldData(6);
                    this.setFieldData(6, ((StatusRec)persistentRec).clone());
                }
                if (productRec.statusHistory != null) {
                    int n = productRec.statusHistory.size();
                    int n2 = 0;
                    this.statusHistory = new Vector(productRec.statusHistory.size());
                    while (n2 < n) {
                        this.statusHistory.addElement(new ProdStatusRec((ProdStatusRec)productRec.statusHistory.elementAt(n2)));
                        ++n2;
                    }
                }
                this.recycled = productRec.recycled;
                this.optionInfoRead = productRec.optionInfoRead;
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof ProductRec) {
            ProductRec productRec = (ProductRec)object;
            try {
                bl = this.productNumber.equals(productRec.productNumber) && this.machineRec.equals(productRec.machineRec) && this.model.equals(productRec.model) && this.brandRec.ind == productRec.brandRec.ind && this.groupRec.ind == productRec.groupRec.ind;
            }
            catch (NullPointerException nullPointerException) {
                if (this.productNumber != null && productRec.productNumber != null) {
                    bl = this.productNumber.equals(productRec.productNumber);
                }
            }
        } else if (object instanceof DocFamilyRec) {
            bl = ((DocFamilyRec)object).getBrandGroupInd() == this.getBrandGroupInd();
        } else if (object instanceof MachineRec) {
            bl = this.machineRec.equals(object);
        } else if (object instanceof TypeGroupRec) {
            bl = this.groupRec.equals(object);
        }
        return bl;
    }

    public char[] getDisplayDescript(int n) {
        String string = null;
        try {
            switch (n) {
                case 0: {
                    string = (String)this.getFieldData(4);
                    break;
                }
                case 1: {
                    string = (String)this.getFieldData(5);
                    break;
                }
                case 2: {
                    if (this.recycled) {
                        string = (String)this.getFieldData(15);
                        break;
                    }
                    if (this.statusRec != null) {
                        string = this.getFieldData(6).toString();
                    }
                    break;
                }
                case 3: {
                    if (this.recycled) {
                        string = (String)this.getFieldData(14);
                        break;
                    }
                    if (this.statusRec != null) {
                        string = ((ProdStatusRec)this.getFieldData(6)).getDate();
                    }
                    break;
                }
                case 4: {
                    string = ((MachineRec)this.getFieldData(2)).getMachine();
                    break;
                }
                case 5: {
                    string = (String)this.getFieldData(3);
                    break;
                }
                case 6: {
                    string = (String)this.getFieldData(15);
                    break;
                }
                case 7: {
                    string = (String)this.getFieldData(14);
                    break;
                }
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, "getDisplayDescript ( " + n + " )");
            LogSystem.log(1, exception);
        }
        if (string == null) {
            string = "";
        }
        return string.toCharArray();
    }

    public int columnCount() {
        return 5;
    }

    public void free() {
        this.productNumber = "";
        this.model = "";
        this.machineRec = null;
        this.dbUser = "";
        this.changedTime = "";
        this.descript = "";
        this.maintLock = "";
        this.brandRec = null;
        this.groupRec = null;
        this.statusRec = null;
        this.statusHistory = null;
        this.prodInt = 0;
        this.graphicGrpInd = 0;
        this.multimediaGrpInd = 0;
        this.recycled = false;
    }

    public int statusHistoryCount() {
        if (this.statusHistory != null) {
            return this.statusHistory.size();
        }
        return 0;
    }

    private static void setStatus(ProductRec productRec, ProdStatusRec prodStatusRec) {
        try {
            if (productRec.statusRec != null) {
                if (!prodStatusRec.equals(productRec.statusRec)) {
                    if (productRec.statusHistory != null) {
                        int n = 0;
                        int n2 = productRec.statusHistory.size();
                        ProdStatusRec prodStatusRec2 = null;
                        boolean bl = false;
                        while (n < n2 && !bl) {
                            prodStatusRec2 = (ProdStatusRec)productRec.statusHistory.elementAt(n);
                            if (prodStatusRec2 != null) {
                                bl = prodStatusRec2.equals(productRec.statusRec);
                            }
                            ++n;
                        }
                        if (!bl) {
                            productRec.statusHistory.addElement(productRec.statusRec);
                            productRec.statusRec.updateRecStatus(0);
                            productRec.statusRec.updateRecStatus(2);
                        }
                        productRec.statusRec = prodStatusRec;
                    } else {
                        productRec.statusHistory = new Vector(1, 1);
                        productRec.statusHistory.addElement(productRec.statusRec);
                        productRec.statusRec.updateRecStatus(0);
                        productRec.statusRec.updateRecStatus(2);
                        productRec.statusRec = prodStatusRec;
                    }
                }
            } else {
                productRec.statusRec = prodStatusRec;
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
    }

    public Object clone() {
        ProductRec productRec = new ProductRec();
        productRec.setData(this);
        return productRec;
    }

    public boolean valid() {
        boolean bl = false;
        bl = !this.isOption() ? this.productNumber.length() > 0 && this.brandRec != null && this.groupRec != null && this.statusRec != null : this.brandRec != null && this.groupRec != null && this.statusRec != null;
        return bl;
    }

    public boolean isOption() {
        return this.isOption;
    }

    public void setRecycled(boolean bl) {
        this.recycled = bl;
    }

    public boolean getRecycled(boolean bl) {
        return bl;
    }

    public String toString() {
        if (this.descript.length() > 0) {
            return this.productNumber + ", " + this.descript;
        }
        return this.productNumber;
    }

    public boolean getOptionInfoRead() {
        return this.optionInfoRead;
    }

    public void setOptionInfoRead(boolean bl) {
        this.optionInfoRead = bl;
    }

    public void autoSetProductNumber() {
        if (this.autoSetProductNumber && !this.isOption) {
            this.initializeMachineRec();
            if (this.machineRec.getMachine() != null && this.machineRec.getMachine().length() > 0 && this.model != null && this.model.length() > 0) {
                this.productNumber = this.machineRec.getMachine() + "-" + this.model;
            }
        }
    }

    private void initializeMachineRec() {
        if (this.machineRec == null) {
            this.machineRec = new MachineRec();
        }
    }

    public void setFieldData(int n, Object object) {
        if (object != null) {
            switch (n) {
                case 4: {
                    if (!(object instanceof String)) break;
                    this.productNumber = (String)object;
                    break;
                }
                case 2: {
                    if (object instanceof String) {
                        this.initializeMachineRec();
                        if (this.brandRec != null && this.groupRec != null) {
                            this.machineRec.setBrandGroupInd(Brands.brandGroupIndFromBrandGroup((int)this.brandRec.getInd(), (int)this.groupRec.getInd()));
                        }
                        this.machineRec.setMachine((String)object);
                    } else {
                        this.machineRec = (MachineRec)object;
                    }
                    this.autoSetProductNumber();
                    break;
                }
                case 3: {
                    this.model = (String)object;
                    this.autoSetProductNumber();
                    break;
                }
                case 6: {
                    ProdStatusRec prodStatusRec = new ProdStatusRec(((StatusRec)object).getStatusInd(), ((StatusRec)object).getDate());
                    if (prodStatusRec == null) break;
                    boolean bl = false;
                    if (!prodStatusRec.valid()) break;
                    if (this.statusRec != null) {
                        if (this.statusRec.equals(prodStatusRec)) {
                            this.statusRec = prodStatusRec;
                            bl = false;
                        } else {
                            bl = true;
                        }
                    } else {
                        bl = true;
                    }
                    if (!bl) break;
                    this.addStatusToHistory(this.statusRec);
                    this.statusRec = prodStatusRec;
                    break;
                }
                case 5: {
                    this.descript = (String)object;
                    this.refreshDescriptArray();
                    break;
                }
                case 7: {
                    this.locRec = (LocaleRec)object;
                    break;
                }
                case 8: {
                    this.statusHistory = (Vector)object;
                    break;
                }
                case 9: {
                    UserRec userRec = UserSystem.getUserRecFromUserId((String)object);
                    this.dbUser = (String)object;
                    if (userRec != null) {
                        this.prettydbUser = userRec.getName();
                        break;
                    }
                    this.prettydbUser = (String)object;
                    break;
                }
                case 10: {
                    this.changedTime = (String)object;
                    this.prettyChangedTime = DateSystem.prettyDateFromStamp(this.changedTime);
                    break;
                }
                case 0: {
                    this.brandRec = (TypeBrandRec)object;
                    if (this.brandRec != null) {
                        boolean bl = this.isOption = this.brandRec.getInd() == 6;
                    }
                    if (this.groupRec == null) break;
                    this.machineRec.setBrandGroupInd(Brands.brandGroupIndFromBrandGroup((int)this.brandRec.getInd(), (int)this.groupRec.getInd()));
                    break;
                }
                case 1: {
                    this.groupRec = (TypeGroupRec)object;
                    if (this.brandRec == null || this.machineRec == null) break;
                    this.machineRec.setBrandGroupInd(Brands.brandGroupIndFromBrandGroup((int)this.brandRec.getInd(), (int)this.groupRec.getInd()));
                    break;
                }
                case 11: {
                    int n2 = (Integer)object;
                    this.setFieldData(0, Brands.brandRecFromBrandGroupInd((int)n2));
                    this.setFieldData(1, Brands.groupRecFromBrandGroupInd((int)n2));
                    break;
                }
                case 12: {
                    break;
                }
                case 13: {
                    break;
                }
                case 16: {
                    this.prodInt = (Integer)object;
                    break;
                }
                case 17: {
                    if (object instanceof String) {
                        this.maintLock = (String)object;
                        break;
                    }
                    if (!(object instanceof Boolean)) break;
                    this.maintLock = (Boolean)object != false ? "Y" : "N";
                    break;
                }
            }
            this.changedField = n;
            if (this.listenerVec != null) {
                new Thread((Runnable)this, THREAD_FIREFIELDCHANGE).start();
            }
            this.hasChanged = true;
        }
    }

    public Object getFieldData(int n) {
        Object object = null;
        switch (n) {
            case 4: {
                object = this.productNumber;
                break;
            }
            case 2: {
                object = this.machineRec;
                break;
            }
            case 3: {
                object = this.model;
                break;
            }
            case 6: {
                object = this.statusRec;
                break;
            }
            case 5: {
                object = this.descript;
                break;
            }
            case 7: {
                object = this.locRec;
                break;
            }
            case 8: {
                object = this.statusHistory;
                break;
            }
            case 9: {
                object = this.dbUser;
                break;
            }
            case 10: {
                object = this.changedTime;
                break;
            }
            case 0: {
                object = this.brandRec;
                break;
            }
            case 1: {
                object = this.groupRec;
                break;
            }
            case 11: {
                object = new Integer(Brands.brandGroupIndFromBrandGroup((int)this.brandRec.ind, (int)this.groupRec.ind));
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                break;
            }
            case 15: {
                object = this.prettydbUser;
                break;
            }
            case 14: {
                object = this.prettyChangedTime;
                break;
            }
            case 16: {
                object = new Integer(this.prodInt);
                break;
            }
            case 17: {
                object = this.maintLock;
                break;
            }
            default: {
                GUISystem.printBox("Programmer Error", "You passed an unsupported field id of " + n + " to product rec's getFieldData ");
                break;
            }
        }
        return object;
    }

    public String getFieldDescription(int n) {
        String string = null;
        switch (n) {
            case 4: {
                if (this.isOption()) {
                    string = Str.getStr(293);
                    break;
                }
                string = Str.getStr(334);
                break;
            }
            case 2: {
                if (this.isOption()) {
                    string = Str.getStr(335);
                    break;
                }
                string = Str.getStr(340);
                break;
            }
            case 3: {
                string = Str.getStr(341);
                break;
            }
            case 6: {
                string = Str.getStr(319);
                break;
            }
            case 5: {
                string = Str.getStr(100);
                break;
            }
            case 7: {
                string = Str.getStr(298);
                break;
            }
            case 8: {
                string = Str.getStr(337);
                break;
            }
            case 9: {
                string = Str.getStr(266);
                break;
            }
            case 10: {
                string = Str.getStr(267);
                break;
            }
            case 0: {
                string = Str.getStr(145);
                break;
            }
            case 1: {
                string = Str.getStr(149);
                break;
            }
            case 11: {
                string = "";
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                break;
            }
            case 15: {
                string = Str.getStr(266);
                break;
            }
            case 14: {
                string = Str.getStr(267);
                break;
            }
            case 16: {
                string = Str.getStr(264);
                break;
            }
            case 17: {
                string = "";
                break;
            }
            case 1000: {
                string = Str.getStr(336);
                break;
            }
            case 1001: {
                string = Str.getStr(263);
                break;
            }
            default: {
                GUISystem.printBox("Programmer Error", "You passed an unsupported field id of " + n + " to product rec's getFieldDescript ");
                break;
            }
        }
        return string;
    }

    public int getIdFromFieldDescription(String string) {
        int n = -1;
        if (string.equals(Str.getStr(293))) {
            n = 4;
        } else if (string.equals(Str.getStr(334))) {
            n = 4;
        } else if (string.equals(Str.getStr(335))) {
            n = 2;
        } else if (string.equals(Str.getStr(340))) {
            n = 2;
        } else if (string.equals(Str.getStr(341))) {
            n = 3;
        } else if (string.equals(Str.getStr(319))) {
            n = 6;
        } else if (string.equals(Str.getStr(100))) {
            n = 5;
        } else if (string.equals(Str.getStr(298))) {
            n = 7;
        } else if (string.equals(Str.getStr(337))) {
            n = 8;
        } else if (string.equals(Str.getStr(266))) {
            n = 9;
        } else if (string.equals(Str.getStr(267))) {
            n = 10;
        } else if (string.equals(Str.getStr(145))) {
            n = 0;
        } else if (string.equals(Str.getStr(149))) {
            n = 1;
        } else if (string.equals(Str.getStr(266))) {
            n = 15;
        } else if (string.equals(Str.getStr(267))) {
            n = 14;
        } else if (string.equals(Str.getStr(264))) {
            n = 16;
        } else if (string.equals(Str.getStr(336))) {
            n = 1000;
        } else if (string.equals(Str.getStr(263))) {
            n = 1001;
        }
        return n;
    }

    private void addStatusToHistory(ProdStatusRec prodStatusRec) {
        if (this.statusHistory == null) {
            this.statusHistory = new Vector(10, 10);
        }
        if (prodStatusRec != null && prodStatusRec.valid()) {
            this.statusHistory.addElement(prodStatusRec);
        }
    }

    private void createProdInt() {
        this.prodInt = Counter.getCounter(LogSystem.getInstance(), "PRODIND");
    }

    public int getProdInt() {
        return this.prodInt;
    }

    public boolean isLocked() {
        if (this.dbUser != null && this.maintLock != null) {
            return this.maintLock.equals("Y") && !this.dbUser.equals(UserSystem.getUserId());
        }
        return false;
    }

    public void setLocked(boolean bl) {
        this.maintLock = bl ? "Y" : "N";
    }

    public void addFieldListener(FieldListener fieldListener) {
        this.initializeListenerVec();
        this.listenerVec.addElement(fieldListener);
    }

    private void initializeListenerVec() {
        if (this.listenerVec == null) {
            this.listenerVec = new Vector(10, 10);
        }
    }

    private void fireFieldEvent(int n) {
        if (this.listenerVec != null) {
            int n2 = 0;
            int n3 = this.listenerVec.size();
            while (n2 < n3) {
                if (((FieldListener)this.listenerVec.elementAt(n2)).isField(n)) {
                    ((FieldListener)this.listenerVec.elementAt(n2)).fieldChanged(this, n);
                    if (n == 6) {
                        this.fireFieldEvent(8);
                    }
                }
                ++n2;
            }
        }
    }

    public void removeFieldListener(FieldListener fieldListener) {
        if (this.listenerVec != null) {
            this.listenerVec.removeElement(fieldListener);
        }
    }

    public void run() {
        String string = Thread.currentThread().getName();
        if (string.equals(THREAD_FIREFIELDCHANGE)) {
            this.fireFieldEvent(this.changedField);
        }
    }

    public void autoSetProductNumber(boolean bl) {
        this.autoSetProductNumber = bl;
    }

    public boolean isAllModel() {
        return this.model.equals("All");
    }

    public boolean isAllMachine() {
        if (this.machineRec != null) {
            return this.machineRec.getMachine().equals("All");
        }
        return false;
    }

    public int getBrandGroupInd() {
        return Brands.brandGroupIndFromBrandGroup((int)this.brandRec.getInd(), (int)this.groupRec.getInd());
    }

    public String getStrMachine() {
        try {
            return this.machineRec.getMachine();
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public Object getColumnData(int n) {
        if (n == 0) {
            return this.productNumber;
        }
        if (n == 1) {
            if (this.descriptArray == null) {
                this.refreshDescriptArray();
            }
            return this.descriptArray;
        }
        if (n == 2) {
            if (this.recycled) {
                return (String)this.getFieldData(15);
            }
            if (this.statusRec != null) {
                return this.getFieldData(6).toString();
            }
        } else if (n == 3) {
            if (this.recycled) {
                return (String)this.getFieldData(14);
            }
            if (this.statusRec != null) {
                return ((ProdStatusRec)this.getFieldData(6)).getDate();
            }
        }
        return "";
    }

    public boolean hasStatus(ProdStatusRec prodStatusRec) {
        boolean bl = false;
        if (this.statusHistory != null) {
            bl = StoreUtil.vectorContains(this.statusHistory, prodStatusRec);
        }
        return bl;
    }

    public int readFromDatabase() {
        int n = -1;
        if (this.isOption()) {
            n = this.readFromDatabaseOption();
        } else {
            SQLMethod sQLMethod = new SQLMethod(1, "ProductRec.readFromDatabase", 5);
            try {
                Statement statement = sQLMethod.createStatement();
                ResultSet resultSet = null;
                String string = null;
                if (this.prodInt != 0) {
                    string = "PRODINT = " + this.prodInt;
                } else if (this.productNumber != null) {
                    string = "PRODNUM = '" + this.productNumber + "'";
                } else {
                    sQLMethod.close();
                    return -3;
                }
                resultSet = statement.executeQuery("SELECT BRANDGROUPIND,    PRODINT,   MACHINE,    MODEL,     " + "       PRODDESC,         STATUSIND, STATUSDATE, GRAPHICGRPIND, " + "       MULTIMEDIAGRPIND, MAINTLOCK, DBUSER,     CHANGEDTIME, " + "       RECYCLED " + "FROM TIGRIS.PRODUCTS " + "WHERE " + string + " FOR FETCH ONLY");
                if (resultSet.next()) {
                    String string2 = resultSet.getString(7).trim();
                    string2 = CDate.convertDate(10, 2, string2);
                    this.setFieldData(11, new Integer(resultSet.getInt(1)));
                    this.setFieldData(16, new Integer(resultSet.getInt(2)));
                    this.setFieldData(2, resultSet.getString(3).trim());
                    this.setFieldData(3, resultSet.getString(4).trim());
                    this.setFieldData(5, resultSet.getString(5).trim());
                    this.setFieldData(6, new ProdStatusRec(resultSet.getInt(6), string2));
                    this.setFieldData(13, new Integer(resultSet.getInt(8)));
                    this.setFieldData(12, new Integer(resultSet.getInt(9)));
                    this.setFieldData(17, resultSet.getString(10).trim());
                    this.setFieldData(9, resultSet.getString(11).trim());
                    this.setFieldData(10, resultSet.getString(12).trim());
                    if (resultSet.getString(13).trim().equals("Y")) {
                        GUISystem.printBox(Str.getStr(7), Str.getStr(1275) + " " + UserSystem.getNameFromUserId(this.dbUser) + Str.getStr(127) + DateSystem.prettyDateFromStamp(this.changedTime));
                        n = -5;
                    } else {
                        n = 0;
                    }
                    resultSet.close();
                    sQLMethod.close();
                    if (n == 0) {
                        n = this.readStatusHistory();
                    }
                    if (n == 0) {
                        n = this.readProductLocale();
                    }
                } else {
                    n = -4;
                }
            }
            catch (Exception exception) {
                sQLMethod.rollBack();
                LogSystem.log(1, exception, false);
                GUISystem.printBox(7, 1274);
                n = -2;
            }
            sQLMethod.close();
        }
        return n;
    }

    private int readFromDatabaseOption() {
        SQLMethod sQLMethod = new SQLMethod(1, "ProductRec.readFromDatabaseOption", 5);
        int n = -1;
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = null;
            String string = null;
            String string2 = null;
            if (this.prodInt != 0) {
                string = "A.PRODINT = " + this.prodInt;
            } else if (this.productNumber != null) {
                string = "PRODNUM = '" + this.productNumber + "'";
            } else {
                sQLMethod.close();
                return -3;
            }
            string2 = "SELECT A.BRANDGROUPIND,    A.PRODINT,   B.DESCRIPT,   A.MODEL,     " + "       A.PRODDESC,         A.STATUSIND, A.STATUSDATE, A.GRAPHICGRPIND, " + "       A.MULTIMEDIAGRPIND, A.MAINTLOCK, A.DBUSER,     A.CHANGEDTIME, " + "       A.RECYCLED " + "FROM TIGRIS.PRODUCTS A, " + "     TIGRIS.PRODMACHINEDESC B " + "WHERE " + string + " AND A.PRODINT = B.PRODINT FOR FETCH ONLY";
            LogSystem.log(1, "Executing Query:" + string2);
            resultSet = statement.executeQuery(string2);
            if (resultSet.next()) {
                this.setFieldData(11, new Integer(resultSet.getInt(1)));
                this.setFieldData(16, new Integer(resultSet.getInt(2)));
                this.setFieldData(2, resultSet.getString(3).trim());
                this.setFieldData(3, resultSet.getString(4).trim());
                this.setFieldData(5, resultSet.getString(5).trim());
                this.setFieldData(6, new ProdStatusRec(resultSet.getInt(6), resultSet.getString(7).trim()));
                this.setFieldData(13, new Integer(resultSet.getInt(8)));
                this.setFieldData(12, new Integer(resultSet.getInt(9)));
                this.setFieldData(17, resultSet.getString(10).trim());
                this.setFieldData(9, resultSet.getString(11).trim());
                this.setFieldData(10, resultSet.getString(12).trim());
                if (resultSet.getString(13).trim().equals("Y")) {
                    GUISystem.printBox(Str.getStr(7), Str.getStr(1275) + " " + UserSystem.getNameFromUserId(this.dbUser) + Str.getStr(127) + DateSystem.prettyDateFromStamp(this.changedTime));
                    n = -5;
                } else {
                    n = 0;
                }
                resultSet.close();
                sQLMethod.close();
                if (n == 0) {
                    n = this.readStatusHistory();
                }
                if (n == 0) {
                    n = this.readProductLocale();
                }
            } else {
                n = -4;
            }
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception, false);
            GUISystem.printBox(7, 1274);
            n = -2;
        }
        return n;
    }

    private int readStatusHistory() {
        SQLMethod sQLMethod = new SQLMethod(1, "ProductRec.readStatusHistory", 5);
        int n = -1;
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = null;
            ProdStatusRec prodStatusRec = null;
            resultSet = statement.executeQuery("SELECT STATUSIND, STATUSDATE " + "FROM TIGRIS.PRODSTATUS " + "WHERE PRODINT = " + this.prodInt);
            while (resultSet.next()) {
                prodStatusRec = new ProdStatusRec(resultSet.getInt(1), resultSet.getString(2).trim());
                this.addStatusToHistory(prodStatusRec);
            }
            resultSet.close();
            n = 0;
        }
        catch (Exception exception) {
            n = -2;
            sQLMethod.rollBack();
            LogSystem.log(1, exception, false);
        }
        sQLMethod.close();
        return n;
    }

    private int readProductLocale() {
        int n = -1;
        SQLMethod sQLMethod = new SQLMethod(1, "ProductRec.readProductLocale()", 5);
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = null;
            resultSet = statement.executeQuery("SELECT GEOIND " + "FROM TIGRIS.PRODGEO " + "WHERE PRODINT = " + this.prodInt);
            this.locRec = new LocaleRec();
            while (resultSet.next() && !this.locRec.isWorldWide()) {
                if (resultSet.getInt(1) != 6) {
                    this.locRec.addGeography(resultSet.getInt(1));
                    continue;
                }
                this.locRec.setWorldWide();
            }
            resultSet.close();
            if (!this.locRec.isWorldWide()) {
                Statement statement2 = sQLMethod.createStatement();
                ResultSet resultSet2 = null;
                resultSet2 = statement2.executeQuery("SELECT COUNTRYCODEIND " + "FROM TIGRIS.PRODCOUNTRY " + "WHERE PRODINT = " + this.prodInt);
                while (resultSet2.next() && !this.locRec.isWorldWide()) {
                    this.locRec.addCountry(resultSet2.getInt(1));
                }
                resultSet2.close();
                statement2.close();
            }
            n = 0;
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception, false);
            n = -2;
        }
        sQLMethod.close();
        return n;
    }

    public synchronized boolean readProductForEdit() {
        boolean bl = false;
        int n = this.readFromDatabase();
        if (n == 0) {
            bl = ProductRec.setProductLock(this.prodInt, true, this.dbUser);
        } else {
            LogSystem.log(1, "readFromDatabase returned " + n);
        }
        return bl;
    }

    private synchronized boolean readProductFromDatabase() {
        String string = "readProductInfo";
        SQLMethod sQLMethod = new SQLMethod(1, string, 5);
        int n = 0;
        boolean bl = true;
        ProductRec.setStatus(Str.getStr(142) + " " + this.prodInt);
        if (sQLMethod != null) {
            try {
                CallableStatement callableStatement = sQLMethod.createStoredProc("product", 21);
                boolean bl2 = false;
                String string2 = null;
                callableStatement.setString(1, UserSystem.getUserId());
                callableStatement.setString(2, "1");
                callableStatement.setString(3, this.productNumber);
                callableStatement.setString(4, "" + PropertySystem.getInt(2));
                callableStatement.setString(5, "N");
                callableStatement.registerOutParameter(6, -1);
                callableStatement.registerOutParameter(7, -1);
                callableStatement.registerOutParameter(8, -1);
                callableStatement.registerOutParameter(9, -1);
                callableStatement.registerOutParameter(10, -1);
                callableStatement.registerOutParameter(11, -1);
                callableStatement.registerOutParameter(12, -1);
                callableStatement.registerOutParameter(13, -1);
                callableStatement.registerOutParameter(14, -1);
                callableStatement.registerOutParameter(15, -1);
                callableStatement.registerOutParameter(16, -1);
                callableStatement.registerOutParameter(17, -1);
                callableStatement.registerOutParameter(18, -1);
                callableStatement.registerOutParameter(19, -1);
                callableStatement.registerOutParameter(20, -1);
                callableStatement.registerOutParameter(21, 4);
                callableStatement.execute();
                n = callableStatement.getInt(21);
                if (n == 0) {
                    this.locRec = new LocaleRec();
                    this.locRec.setDataFromDatabase(callableStatement.getString(17), callableStatement.getString(18));
                    this.setFieldData(11, new Integer(callableStatement.getString(10)));
                    this.setFieldData(16, new Integer(callableStatement.getString(6)));
                    this.setFieldData(2, callableStatement.getString(7));
                    this.setFieldData(3, callableStatement.getString(8));
                    this.setFieldData(5, callableStatement.getString(9));
                    this.setFieldData(6, new ProdStatusRec(new Integer(callableStatement.getString(11)), callableStatement.getString(12)));
                    this.setFieldData(13, new Integer(callableStatement.getString(13)));
                    this.setFieldData(12, new Integer(callableStatement.getString(14)));
                    this.setFieldData(17, callableStatement.getString(15));
                    this.setFieldData(9, callableStatement.getString(19));
                    this.setFieldData(10, callableStatement.getString(20));
                    this.optionInfoRead = false;
                    string2 = callableStatement.getString(16);
                    if (this.statusHistory != null) {
                        this.statusHistory.removeAllElements();
                    }
                    this.statusHistory = new Vector(10, 1);
                    if (string2.length() > 1) {
                        SQLParse sQLParse = new SQLParse(string2);
                        ProdStatusRec prodStatusRec = null;
                        while (sQLParse.next()) {
                            prodStatusRec = new ProdStatusRec(sQLParse.readShort(0), sQLParse.readString(1));
                            prodStatusRec.setCountry((TypeCountryCodeRec)QITTypeList.getInstance().objectFromInd(sQLParse.readInt(2), 3));
                            prodStatusRec.setComment(sQLParse.readString(3));
                            this.addStatusToHistory(prodStatusRec);
                        }
                        sQLParse.close();
                        sQLParse = null;
                    }
                    bl = true;
                }
                if (this.isOption() && !this.getOptionInfoRead()) {
                    this.readOptionInfo();
                }
                this.hasChanged = false;
            }
            catch (Exception exception) {
                sQLMethod.rollBack();
                LogSystem.log(1, exception);
            }
        }
        sQLMethod.close();
        ProductRec.setStatus(null);
        return bl;
    }

    public boolean readOptionInfo() {
        String string = "readOptionInfo (" + this.productNumber + ")";
        SQLMethod sQLMethod = new SQLMethod(1, string, 5);
        String string2 = "SELECT DESCRIPT FROM TIGRIS.PRODMACHINEDESC WHERE PRODINT = " + this.prodInt + " FOR FETCH ONLY";
        boolean bl = false;
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery(string2);
            if (resultSet.next()) {
                this.machineRec.setMachine(resultSet.getString(1).trim());
                this.setOptionInfoRead(true);
            }
            bl = true;
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception);
        }
        sQLMethod.close();
        return bl;
    }

    public static boolean setProductLock(int n, boolean bl, String string) {
        String string2 = "setProductLock ( " + n + ", " + bl + " ) ";
        SQLMethod sQLMethod = new SQLMethod(1, string2, 5);
        boolean bl2 = false;
        String string3 = "";
        if (bl) {
            ProductRec.setStatus(Str.getStr(338) + " " + n);
        } else {
            ProductRec.setStatus(Str.getStr(339) + " " + n);
        }
        if (sQLMethod != null && n != 0) {
            try {
                Statement statement = sQLMethod.createStatement();
                string3 = bl ? "UPDATE TIGRIS.PRODUCTS SET MAINTLOCK = 'Y', DBUSER = '" + UserSystem.getUserId() + "' WHERE PRODINT = " + n + " AND MAINTLOCK = 'N'" : "UPDATE TIGRIS.PRODUCTS SET MAINTLOCK = 'N', dbuser = '" + string + "' WHERE PRODINT = " + n + " AND MAINTLOCK='Y' AND DBUSER = '" + UserSystem.getUserId() + "'";
                statement.executeUpdate(string3);
                bl2 = true;
            }
            catch (Exception exception) {
                sQLMethod.rollBack();
                LogSystem.log(1, exception);
            }
        } else {
            bl2 = true;
        }
        sQLMethod.close();
        ProductRec.setStatus(null);
        return bl2;
    }

    public boolean getHasChanged() {
        return this.hasChanged;
    }

    private boolean saveProduct() {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        boolean bl2 = false;
        MainWindow mainWindow = MainWindow.getInstance();
        LogSystem.beginLogSection("Saving Product Information");
        mainWindow.setStatus(Str.getStr(342) + " " + this.productNumber);
        mainWindow.setStatusLock(true);
        if (this.valid()) {
            int n = Brands.brandGroupIndFromBrandGroup((int)this.brandRec.ind, (int)this.groupRec.ind);
            String string2 = null;
            this.productNumber = Text.cleanDBString(this.productNumber);
            this.descript = Text.cleanDBString(this.descript);
            string2 = this.machineRec.getMachine();
            this.model = Text.cleanDBString(this.model);
            if (this.isOption()) {
                string = string2;
                string2 = Text.cleanDBString(this.machineRec.getSubMachine());
                this.model = "";
            }
            LogSystem.log(1, "Saving Product Number:" + this.productNumber);
            LogSystem.log(1, "Brand Group Ind:" + n + "  Option:" + this.isOption());
            LogSystem.log(1, "Machine/Model/OptMachine:" + string2 + "/" + this.model + "  Opt Machine:" + string);
            LogSystem.log(1, "RecStatus:" + this.getRecStatus());
            try {
                switch (this.getRecStatus()) {
                    case 2: {
                        this.createProdInt();
                        if (this.prodInt > 0) {
                            stringBuffer.append("INSERT INTO TIGRIS.PRODUCTS " + "( PRODINT,       PRODNUM,   MACHINE,    MODEL,         PRODDESC, " + "  BRANDGROUPIND, STATUSIND, STATUSDATE, GRAPHICGRPIND, MULTIMEDIAGRPIND, " + "  MAINTLOCK,     RECYCLED,  DBUSER,     CHANGEDTIME ) " + "values " + "(  " + this.prodInt + ", " + "  '" + this.productNumber + "', " + "  '" + string2 + "', " + "  '" + this.model + "', " + "  '" + this.descript + "', " + "  " + n + ", " + "  " + this.statusRec.getStatusInd() + ", " + "  '" + this.statusRec.getDate() + "', " + "  null, " + "  null, " + "  'N', " + "  'N', " + "  '" + UserSystem.getUserId() + "', " + "  CURRENT TIMESTAMP )" + SqlRunner.END_DELIM);
                            if (this.isOption()) {
                                stringBuffer.append("INSERT INTO TIGRIS.PRODMACHINEDESC " + " ( PRODINT, DESCRIPT, DBUSER, CHANGEDTIME ) " + "values " + "(  " + this.prodInt + ", " + "  '" + string + "', " + "  '" + UserSystem.getUserId() + "', " + "  CURRENT TIMESTAMP )" + SqlRunner.END_DELIM);
                            }
                            bl2 = true;
                            break;
                        }
                        GUISystem.printBox(Str.getStr(6), Str.getStr(332));
                        LogSystem.log(1, "Could not generate a PRODINT internal number. getCounter returned" + this.prodInt);
                        break;
                    }
                    case 1: {
                        stringBuffer.append("UPDATE TIGRIS.PRODUCTS " + "SET PRODNUM          = '" + this.productNumber + "', " + "    MACHINE          = '" + string2 + "', " + "    MODEL            = '" + this.model + "', " + "    PRODDESC         = '" + this.descript + "', " + "    BRANDGROUPIND    =  " + n + ", " + "    STATUSIND        =  " + this.statusRec.getStatusInd() + ", " + "    STATUSDATE       = '" + this.statusRec.getDate() + "', " + "    GRAPHICGRPIND    = null, " + "    MULTIMEDIAGRPIND = null, " + "    MAINTLOCK        = 'N', " + "    RECYCLED         = 'N', " + "    DBUSER           = '" + UserSystem.getUserId() + "', " + "    CHANGEDTIME      = CURRENT TIMESTAMP " + "WHERE PRODINT        = " + this.prodInt + "" + SqlRunner.END_DELIM);
                        if (this.isOption()) {
                            stringBuffer.append("UPDATE TIGRIS.PRODMACHINEDESC " + "SET DESCRIPT    = '" + string + "', " + "    DBUSER      = '" + UserSystem.getUserId() + "', " + "    CHANGEDTIME = CURRENT TIMESTAMP " + "WHERE PRODINT   = " + this.prodInt + "" + SqlRunner.END_DELIM);
                        }
                        bl2 = true;
                        break;
                    }
                }
                LogSystem.log(1, "Process After initial Product SQL:" + bl2);
                if (bl2) {
                    bl = this.saveProductStatusHistory(stringBuffer);
                }
                LogSystem.log(1, "RC After SaveProductStatusHistory rc:" + bl);
                if (bl && bl2) {
                    bl = this.saveProductLocale(stringBuffer);
                }
                LogSystem.log(1, "RC After saveProductLocale rc:" + bl);
                if (bl && bl2) {
                    bl = this.saveProductSpecial(stringBuffer);
                }
                LogSystem.log(1, "RC After saveProductSpecial rc:" + bl);
                if (bl && bl2) {
                    int n2 = QITSqlRunner.sqlRunnerCode(stringBuffer.toString());
                    switch (n2) {
                        case 0: {
                            this.hasChanged = false;
                            bl = true;
                            this.updateRecStatus(0);
                            this.updateRecStatus(1);
                            break;
                        }
                        case -803: 
                        case 803: {
                            GUISystem.printBox(7, 333);
                            this.hasChanged = true;
                            bl = false;
                            break;
                        }
                        default: {
                            LogSystem.log(1, "SQLRunner returned SQL Code:" + n2);
                            GUISystem.printBox(7, 202);
                            break;
                        }
                    }
                }
            }
            catch (Exception exception) {
                LogSystem.log(1, exception, false);
                GUISystem.printBox(7, 202);
            }
            LogSystem.endLogSection();
        }
        mainWindow.setStatusLock(false);
        mainWindow.setStatus(null);
        return bl;
    }

    private boolean saveProductStatusHistory(StringBuffer stringBuffer) throws Exception {
        boolean bl = false;
        if (this.statusHistory != null) {
            int n = 0;
            int n2 = this.statusHistory.size();
            ProdStatusRec prodStatusRec = null;
            boolean bl2 = false;
            stringBuffer.append("DELETE FROM TIGRIS.PRODSTATUS WHERE PRODINT = " + this.prodInt + "" + SqlRunner.END_DELIM);
            while (n < n2) {
                prodStatusRec = (ProdStatusRec)this.statusHistory.elementAt(n);
                if (prodStatusRec != null) {
                    stringBuffer.append("INSERT INTO TIGRIS.PRODSTATUS " + "( PRODINT, STATUSIND, COUNTRYCODEIND, STATUSDATE, REFERENCE, DBUSER, CHANGEDTIME ) " + "VALUES " + "(  " + this.prodInt + ", " + "   " + prodStatusRec.getStatusInd() + ", " + "   " + PropertySystem.getInt(2) + ", " + "  '" + prodStatusRec.getDate() + "', " + "  '" + prodStatusRec.getComment() + "', " + "  '" + UserSystem.getUserId() + "', " + "  CURRENT TIMESTAMP )" + SqlRunner.END_DELIM);
                    prodStatusRec.updateRecStatus(0);
                }
                ++n;
            }
            bl = true;
        } else {
            bl = true;
        }
        return bl;
    }

    private boolean saveProductLocale(StringBuffer stringBuffer) throws Exception {
        boolean bl = false;
        if (this.locRec != null) {
            String string = "TIGRIS.PRODGEO";
            String string2 = "TIGRIS.PRODCOUNTRY";
            Object var5_5 = null;
            Object var6_6 = null;
            Object var7_7 = null;
            stringBuffer.append("DELETE FROM " + string + " WHERE PRODINT = " + this.prodInt + "" + SqlRunner.END_DELIM);
            stringBuffer.append("DELETE FROM " + string2 + " WHERE PRODINT = " + this.prodInt + "" + SqlRunner.END_DELIM);
            if (this.locRec.isWorldWide()) {
                stringBuffer.append("INSERT INTO " + string + " " + "( PRODINT, GEOIND, DBUSER, CHANGEDTIME )" + "VALUES " + " ( " + this.prodInt + ", " + "   6, " + "   '" + UserSystem.getUserId() + "', " + "   CURRENT TIMESTAMP )" + SqlRunner.END_DELIM);
            } else {
                int n;
                Vector vector = this.locRec.getGeoListContainingAll();
                Vector vector2 = this.locRec.getSingleCountryList();
                int n2 = 0;
                if (vector != null && vector.size() > 0) {
                    n = vector.size();
                    while (n2 < n) {
                        stringBuffer.append("INSERT INTO " + string + " " + "(PRODINT, GEOIND, DBUSER, CHANGEDTIME )" + "VALUES " + "( " + this.prodInt + ", " + "  " + ((TypeGeoRec)vector.elementAt((int)n2)).ind + ", " + "  '" + UserSystem.getUserId() + "', " + "  CURRENT TIMESTAMP )" + SqlRunner.END_DELIM);
                        ++n2;
                    }
                }
                if (vector2 != null && vector2.size() > 0) {
                    n = vector2.size();
                    n2 = 0;
                    while (n2 < n) {
                        stringBuffer.append("INSERT INTO " + string2 + " " + "(PRODINT, COUNTRYCODEIND, DBUSER, CHANGEDTIME )" + "VALUES " + "( " + this.prodInt + ", " + "  " + ((TypeCountryCodeRec)vector2.elementAt((int)n2)).ind + ", " + "  '" + UserSystem.getUserId() + "', " + "  CURRENT TIMESTAMP )" + SqlRunner.END_DELIM);
                        ++n2;
                    }
                }
            }
            bl = true;
        } else {
            bl = true;
        }
        return bl;
    }

    public synchronized boolean saveToDatabase(boolean bl) {
        boolean bl2 = false;
        if (bl) {
            if (this.saveProduct()) {
                bl2 = ProductRec.setProductLock(this.prodInt, false, this.dbUser);
            }
        } else {
            bl2 = ProductRec.setProductLock(this.prodInt, false, this.dbUser);
        }
        return bl2;
    }

    public boolean checkProductLock() {
        String string = "checkProductLock";
        SQLMethod sQLMethod = new SQLMethod(1, string, 5);
        String string2 = "SELECT MAINTLOCK, DBUSER FROM TIGRIS.PRODUCTS WHERE PRODINT = " + this.prodInt;
        boolean bl = false;
        Qit.setEnabled(false);
        ProductRec.setStatus(Str.getStr(331));
        try {
            Statement statement;
            ResultSet resultSet;
            if (sQLMethod != null && (resultSet = (statement = sQLMethod.createStatement()).executeQuery(string2)).next()) {
                bl = resultSet.getString(1).equals("Y") && !resultSet.getString(2).equals(UserSystem.getUserId());
            }
        }
        catch (SQLException sQLException) {
            sQLMethod.rollBack();
            LogSystem.log(1, sQLException);
        }
        sQLMethod.close();
        ProductRec.setStatus(null);
        Qit.setEnabled(true);
        return bl;
    }

    public void prepareForSerialize() {
        if (this.listenerVec != null) {
            this.listenerVec.removeAllElements();
            this.listenerVec = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean saveProductSpecial(StringBuffer stringBuffer) throws Exception {
        boolean bl = false;
        if (this.getRecStatus() == 3) return true;
        if (this.getRecStatus() == 2) {
            AppSQL.getAllModelProdInt((String)this.machineRec.getSubMachine(), (int)this.getBrandGroupInd());
            AppSQL.getAllModelProdInt((String)"All", (int)this.getBrandGroupInd());
            bl = true;
        }
        if (this.statusRec.getStatusInd() == 0) {
            stringBuffer.append("UPDATE TIGRIS.PRODUCTS " + "SET STATUSIND = 0, " + "    STATUSDATE = '" + this.statusRec.getDate() + "' " + "WHERE (MACHINE = 'All' or MODEL = 'All') AND " + "      BRANDGROUPIND = " + this.getBrandGroupInd() + "" + SqlRunner.END_DELIM);
            return true;
        }
        SQLMethod sQLMethod = new SQLMethod(1, "ProductRec.saveProductSpecial", 5);
        try {
            boolean bl2 = true;
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT STATUSIND, MACHINE, MODEL FROM TIGRIS.PRODUCTS " + "WHERE MACHINE       = '" + this.machineRec.getSubMachine() + "' AND " + "      MODEL         <> 'All' AND " + "      BRANDGROUPIND = " + this.getBrandGroupInd() + " AND " + "      RECYCLED      = 'N' " + "FOR FETCH ONLY ");
            while (resultSet.next() && bl2) {
                if (resultSet.getInt(1) == this.statusRec.getStatusInd()) continue;
                bl2 = false;
            }
            resultSet.close();
            if (bl2) {
                stringBuffer.append("UPDATE TIGRIS.PRODUCTS " + "SET STATUSIND = " + this.statusRec.getStatusInd() + ", " + "    STATUSDATE = '" + this.statusRec.getDate() + "' " + "WHERE (MACHINE = 'All' or MODEL = 'All') AND " + "      BRANDGROUPIND = " + this.getBrandGroupInd() + "" + SqlRunner.END_DELIM);
            }
            sQLMethod.close();
            return true;
        }
        catch (SQLException sQLException) {
            sQLMethod.close();
            if (sQLException.getErrorCode() == -99999) return bl;
            if (sQLException.getSQLState().equals("07005")) return bl;
            throw sQLException;
        }
    }

    private static void setStatus(String string) {
        MainWindow mainWindow = MainWindow.getInstance();
        if (mainWindow != null) {
            mainWindow.setStatus(string);
        }
    }

    public void columnSized(int n, int n2) {
        if (n == 1) {
            this.lastDescriptPixelWidth = n2;
            this.refreshDescriptArray();
        }
    }

    public void adjustColumnGraphics(int n, Graphics graphics) {
    }

    private void refreshDescriptArray() {
        if (this.descript != null) {
            this.descriptArray = Text.formatStringLines(this.descript, this.lastDescriptPixelWidth / 6);
        } else {
            this.descriptArray = new String[1];
            this.descriptArray[0] = new String("");
        }
    }

    public void setHasChanged(boolean bl) {
        this.hasChanged = bl;
    }

    public int compareTo(MultiListSort multiListSort, int n) {
        int n2 = 0;
        ProductRec productRec = null;
        if (multiListSort instanceof ProductRec) {
            productRec = (ProductRec)multiListSort;
        }
        try {
            if (productRec != null) {
                switch (n) {
                    case 0: {
                        n2 = this.productNumber.compareTo(productRec.productNumber);
                        break;
                    }
                    case 1: {
                        n2 = this.descript.compareTo(productRec.descript);
                        break;
                    }
                    case 2: {
                        if (this.recycled) {
                            n2 = this.dbUser.compareTo(productRec.dbUser);
                            break;
                        }
                        n2 = this.statusRec.toString().compareTo(productRec.statusRec.toString());
                        break;
                    }
                    case 3: {
                        if (this.recycled) {
                            n2 = CDate.compareDate(this.changedTime, productRec.changedTime, 1);
                            break;
                        }
                        n2 = CDate.compareDate(this.statusRec.getDate(), productRec.statusRec.getDate(), 2);
                        break;
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n2;
    }

    public ProductRec() {
        this.init();
    }

    public ProductRec(int n) {
        this.prodInt = n;
        this.init();
    }

    public ProductRec(String string) {
        this.setFieldData(4, string);
        this.setFieldData(3, string.substring(string.indexOf("-"), string.length()));
        this.setFieldData(2, string.substring(0, string.indexOf("-")));
        this.init();
    }

    public ProductRec(String string, String string2, String string3) {
        this.setFieldData(4, string);
        this.setFieldData(2, string2);
        this.setFieldData(3, string3);
        this.init();
    }

    public ProductRec(int n, String string, String string2, String string3) {
        this.prodInt = n;
        this.setFieldData(4, string);
        this.setFieldData(2, string2);
        this.setFieldData(3, string3);
        this.init();
    }

    public ProductRec(int n, String string, String string2, String string3, int n2) {
        this.prodInt = n;
        this.setFieldData(11, new Integer(n2));
        this.setFieldData(4, string);
        this.setFieldData(2, string2);
        this.setFieldData(3, string3);
        this.init();
    }

    public ProductRec(int n, String string) {
        this.prodInt = n;
        this.setFieldData(4, string);
        this.init();
    }

    public ProductRec(int n, String string, String string2, String string3, String string4) {
        this.prodInt = n;
        this.setFieldData(4, string);
        this.setFieldData(2, string2);
        this.setFieldData(3, string3);
        this.setFieldData(10, string4);
        this.init();
    }

    public ProductRec(int n, String string, String string2, String string3, String string4, String string5) {
        this.prodInt = n;
        this.setFieldData(4, string);
        this.setFieldData(2, string2);
        this.setFieldData(3, string3);
        this.setFieldData(10, string4);
        this.setFieldData(9, string5);
        this.init();
    }

    public ProductRec(ProductRec productRec) {
        this.setData(productRec);
    }
}

