/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.product.compare;

import com.ibm.nzna.projects.common.quest.LocaleRec;
import com.ibm.nzna.projects.common.quest.product.Product;
import com.ibm.nzna.projects.common.quest.product.ProductDraft;
import com.ibm.nzna.projects.common.quest.type.TypeCategoryRec;
import com.ibm.nzna.shared.util.LogSystem;
import java.util.Vector;

public class ProductComparePOMRecCompare {
    private static final int OPTION = 6;
    private Product leftProduct = null;
    private Product rightProduct = null;
    private String L_baseModel = null;
    private String R_baseModel = null;
    private TypeCategoryRec L_brand = null;
    private TypeCategoryRec R_brand = null;
    private String L_created = null;
    private String R_created = null;
    private String L_createdBy = null;
    private String R_createdBy = null;
    private int L_customer = 0;
    private int R_customer = 0;
    private Vector L_dates = null;
    private Vector R_dates = null;
    private TypeCategoryRec L_family = null;
    private TypeCategoryRec R_family = null;
    private TypeCategoryRec L_familyType = null;
    private TypeCategoryRec R_familyType = null;
    private String L_input = null;
    private String R_input = null;
    private String L_lastTouchedBy = null;
    private String R_lastTouchedBy = null;
    private String L_lastTouchedOn = null;
    private String R_lastTouchedOn = null;
    private TypeCategoryRec L_machine = null;
    private TypeCategoryRec R_machine = null;
    private TypeCategoryRec L_model = null;
    private TypeCategoryRec R_model = null;
    private int L_offering = 0;
    private int R_offering = 0;
    private TypeCategoryRec L_partNum = null;
    private TypeCategoryRec R_partNum = null;
    private int L_productInd = 0;
    private int R_productInd = 0;
    private int L_draftProductInd = 0;
    private int R_draftProductInd = 0;
    private TypeCategoryRec L_projectName = null;
    private TypeCategoryRec R_projectName = null;
    private String L_questDescript = null;
    private String R_questDescript = null;
    private String L_opicmDescript = null;
    private String R_opicmDescript = null;
    private String L_source = null;
    private String R_source = null;
    private int L_warranty = 0;
    private int R_warranty = 0;
    private LocaleRec L_locale = null;
    private LocaleRec R_locale = null;
    private int L_brandInd = 0;
    private int R_brandInd = 0;
    private String L_draftCreatedOn = null;
    private String R_draftCreatedOn = null;
    private String L_prodNum = null;
    private String R_prodNum = null;
    public boolean BASE_MODEL = true;
    public boolean BRAND = true;
    public boolean CREATED = true;
    public boolean CREATED_BY = true;
    public boolean CUSTOMER = true;
    public boolean DATES_FOR_COUNTRY = true;
    public boolean FAMILY = true;
    public boolean FAMILYTYPE = true;
    public boolean INPUT = true;
    public boolean LAST_TOUCHED_BY = true;
    public boolean MACHINE = true;
    public boolean MODEL = true;
    public boolean OFFERING = true;
    public boolean OPICM_DESCRIPT = true;
    public boolean PARTNUM = true;
    public boolean PRODUCT_DRAFT_IND = true;
    public boolean PRODUCT_IND = true;
    public boolean PROJECTNAME = true;
    public boolean QUEST_DESCRIPT = true;
    public boolean SOURCE = true;
    public boolean WARRANTY = true;
    public boolean LOCATION = true;
    public boolean DRAFT_CREATED_ON = true;
    public boolean LAST_TOUCHED_ON = true;
    public boolean PROD_NUM = true;

    private void recCompare() {
        LogSystem.log(1, "Started: Comparing Values");
        this.BASE_MODEL = this.stringCompare(this.L_baseModel, this.R_baseModel);
        this.BRAND = this.typeCategoryRecCompare(this.L_brand, this.R_brand);
        if (this.L_brandInd != 6) {
            if (this.R_brandInd != 6) {
                this.MACHINE = this.typeCategoryRecCompare(this.L_machine, this.R_machine);
                this.MODEL = this.typeCategoryRecCompare(this.L_model, this.R_model);
            } else if (this.R_brandInd == 6) {
                this.MACHINE = false;
                this.MODEL = false;
            }
        } else if (this.R_brandInd == 6) {
            this.PARTNUM = this.typeCategoryRecCompare(this.L_partNum, this.R_partNum);
            this.FAMILYTYPE = this.typeCategoryRecCompare(this.L_familyType, this.R_familyType);
        } else {
            this.MACHINE = false;
            this.MODEL = false;
        }
        this.CREATED = this.stringCompare(this.L_created, this.R_created);
        this.CREATED_BY = this.stringCompare(this.L_createdBy, this.R_createdBy);
        this.CUSTOMER = this.intCompare(this.L_customer, this.R_customer);
        this.DATES_FOR_COUNTRY = this.vectorCompare(this.L_dates, this.R_dates);
        this.FAMILY = this.typeCategoryRecCompare(this.L_family, this.R_family);
        this.INPUT = this.stringCompare(this.L_input, this.R_input);
        this.LAST_TOUCHED_BY = this.stringCompare(this.L_lastTouchedBy, this.R_lastTouchedBy);
        this.LAST_TOUCHED_ON = this.stringCompare(this.L_lastTouchedOn, this.R_lastTouchedOn);
        this.OFFERING = this.intCompare(this.L_offering, this.R_offering);
        this.OPICM_DESCRIPT = this.stringCompare(this.L_opicmDescript, this.R_opicmDescript);
        this.PRODUCT_IND = this.intCompare(this.L_productInd, this.R_productInd);
        this.PROJECTNAME = this.typeCategoryRecCompare(this.L_projectName, this.R_projectName);
        this.QUEST_DESCRIPT = this.stringCompare(this.L_questDescript, this.R_questDescript);
        this.SOURCE = this.stringCompare(this.L_source, this.R_source);
        this.WARRANTY = this.intCompare(this.L_warranty, this.R_warranty);
        this.LOCATION = this.localeRecCompare(this.L_locale, this.R_locale);
        this.DRAFT_CREATED_ON = this.stringCompare(this.L_draftCreatedOn, this.R_draftCreatedOn);
        this.PRODUCT_DRAFT_IND = this.intCompare(this.L_draftProductInd, this.R_draftProductInd);
        this.PROD_NUM = this.stringCompare(this.L_prodNum, this.R_prodNum);
        LogSystem.log(1, "Finished: Comparing Values");
    }

    private void getValues() {
        LogSystem.log(1, "Started:  Populating Product Values");
        this.L_baseModel = this.leftProduct.getBaseModel();
        this.R_baseModel = this.rightProduct.getBaseModel();
        this.L_brand = this.leftProduct.getBrand();
        this.R_brand = this.rightProduct.getBrand();
        this.L_created = this.leftProduct.getCreatedOn();
        this.R_created = this.rightProduct.getCreatedOn();
        this.L_createdBy = this.leftProduct.getCreatedBy();
        this.R_createdBy = this.rightProduct.getCreatedBy();
        this.L_customer = this.leftProduct.getCustomer();
        this.R_customer = this.rightProduct.getCustomer();
        this.L_dates = this.leftProduct.getDates();
        this.R_dates = this.rightProduct.getDates();
        this.L_family = this.leftProduct.getFamily();
        this.R_family = this.rightProduct.getFamily();
        this.L_input = this.leftProduct.getInput();
        this.R_input = this.rightProduct.getInput();
        this.L_lastTouchedBy = this.leftProduct.getLastTouchedBy();
        this.R_lastTouchedBy = this.rightProduct.getLastTouchedBy();
        this.L_lastTouchedOn = this.leftProduct.getLastTouchedOn();
        this.R_lastTouchedOn = this.rightProduct.getLastTouchedOn();
        this.L_offering = this.leftProduct.getOffering();
        this.R_offering = this.rightProduct.getOffering();
        this.L_projectName = this.leftProduct.getProject();
        this.R_projectName = this.rightProduct.getProject();
        this.L_questDescript = this.leftProduct.getDescription();
        this.R_questDescript = this.rightProduct.getDescription();
        this.L_source = this.leftProduct.getSource();
        this.R_source = this.rightProduct.getSource();
        this.L_warranty = this.leftProduct.getWarranty();
        this.R_warranty = this.rightProduct.getWarranty();
        this.L_locale = this.leftProduct.getLocale();
        this.R_locale = this.rightProduct.getLocale();
        this.L_prodNum = this.leftProduct.getProdNum();
        this.R_prodNum = this.rightProduct.getProdNum();
        this.L_brandInd = this.L_brand.getInd();
        this.R_brandInd = this.R_brand.getInd();
        if (this.L_brandInd != 6) {
            this.L_machine = this.leftProduct.getMachine();
            this.L_model = this.leftProduct.getModel();
        } else {
            this.L_familyType = this.leftProduct.getSubCategory();
            this.L_partNum = this.leftProduct.getPartNumber();
        }
        if (this.R_brandInd != 6) {
            this.R_machine = this.rightProduct.getMachine();
            this.R_model = this.rightProduct.getModel();
        } else {
            this.R_familyType = this.rightProduct.getSubCategory();
            this.R_partNum = this.rightProduct.getPartNumber();
        }
        if (this.leftProduct instanceof ProductDraft) {
            this.L_draftProductInd = ((ProductDraft)this.leftProduct).getProductInd();
            this.L_productInd = ((ProductDraft)this.leftProduct).getExistingProductInd();
        } else {
            this.L_draftProductInd = 0;
            this.L_productInd = this.leftProduct.getProductInd();
        }
        if (this.rightProduct instanceof ProductDraft) {
            this.R_draftProductInd = ((ProductDraft)this.rightProduct).getProductInd();
            this.R_productInd = ((ProductDraft)this.rightProduct).getExistingProductInd();
        } else {
            this.R_draftProductInd = 0;
            this.R_productInd = this.rightProduct.getProductInd();
        }
        if (this.leftProduct instanceof ProductDraft) {
            this.L_opicmDescript = ((ProductDraft)this.leftProduct).getOPICMDescript();
            this.L_draftCreatedOn = ((ProductDraft)this.leftProduct).getStartDate();
        }
        if (this.rightProduct instanceof ProductDraft) {
            this.R_opicmDescript = ((ProductDraft)this.rightProduct).getOPICMDescript();
            this.R_draftCreatedOn = ((ProductDraft)this.rightProduct).getStartDate();
        }
        LogSystem.log(1, "Finished:  Product Values Populated");
    }

    private boolean stringCompare(String string, String string2) {
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        return string.compareTo(string2) == 0;
    }

    private boolean intCompare(int n, int n2) {
        return n == n2;
    }

    private boolean typeCategoryRecCompare(TypeCategoryRec typeCategoryRec, TypeCategoryRec typeCategoryRec2) {
        return this.stringCompare(typeCategoryRec.getDescript(), typeCategoryRec2.getDescript());
    }

    private boolean localeRecCompare(LocaleRec localeRec, LocaleRec localeRec2) {
        return this.stringCompare(localeRec.getLocaleList(), localeRec2.getLocaleList());
    }

    private boolean vectorCompare(Vector vector, Vector vector2) {
        return this.stringCompare(vector.toString(), vector2.toString());
    }

    public Product leftMoveChanges() {
        LogSystem.beginLogSection(" LeftMoveChanges...");
        if (this.L_brandInd != 6 && this.R_brandInd != 6) {
            if (!this.MACHINE) {
                this.rightProduct.setMachine(this.L_machine);
            }
            if (!this.MODEL) {
                this.rightProduct.setModel(this.L_model);
            }
        } else if (this.L_brandInd == 6 && this.R_brandInd == 6) {
            if (!this.FAMILYTYPE) {
                this.rightProduct.setSubCategory(this.L_familyType);
            }
            if (!this.PARTNUM) {
                this.rightProduct.setPartNumber(this.L_partNum);
            }
        }
        if (!this.BRAND) {
            this.rightProduct.setBrand(this.L_brand);
        }
        if (!this.FAMILY) {
            this.rightProduct.setFamily(this.L_family);
        }
        if (!this.PROJECTNAME) {
            this.rightProduct.setProject(this.L_projectName);
        }
        if (!this.BASE_MODEL) {
            this.rightProduct.setBaseModel(this.L_baseModel);
        }
        if (!this.CUSTOMER) {
            this.rightProduct.setCustomer(this.L_customer);
        }
        if (!this.DATES_FOR_COUNTRY) {
            this.rightProduct.setDates(this.L_dates);
        }
        if (!this.INPUT) {
            this.rightProduct.setInput(this.L_input);
        }
        if (!this.OFFERING) {
            this.rightProduct.setOffering(this.L_offering);
        }
        if (!this.PROJECTNAME) {
            this.rightProduct.setProject(this.L_projectName);
        }
        if (!this.QUEST_DESCRIPT) {
            this.rightProduct.setDescription(this.L_questDescript);
        }
        if (!this.WARRANTY) {
            this.rightProduct.setWarranty(this.L_warranty);
        }
        if (!this.LOCATION) {
            this.rightProduct.setLocale(this.L_locale);
        }
        LogSystem.log(1, "MovedChanges");
        LogSystem.endLogSection();
        return this.rightProduct;
    }

    public Product rightMoveChanges() {
        LogSystem.beginLogSection(" RightMoveChanges...");
        if (this.L_brandInd != 6 && this.R_brandInd != 6) {
            if (!this.MACHINE) {
                this.leftProduct.setMachine(this.R_machine);
            }
            if (!this.MODEL) {
                this.leftProduct.setModel(this.R_model);
            }
        } else if (this.L_brandInd == 6 && this.R_brandInd == 6) {
            if (!this.FAMILYTYPE) {
                this.leftProduct.setSubCategory(this.R_familyType);
            }
            if (!this.PARTNUM) {
                this.leftProduct.setPartNumber(this.R_partNum);
            }
        }
        if (!this.BRAND) {
            this.leftProduct.setBrand(this.R_brand);
        }
        if (!this.FAMILY) {
            this.leftProduct.setFamily(this.R_family);
        }
        if (!this.PROJECTNAME) {
            this.leftProduct.setProject(this.R_projectName);
        }
        if (!this.BASE_MODEL) {
            this.leftProduct.setBaseModel(this.R_baseModel);
        }
        if (!this.CUSTOMER) {
            this.leftProduct.setCustomer(this.R_customer);
        }
        if (!this.DATES_FOR_COUNTRY) {
            this.leftProduct.setDates(this.R_dates);
        }
        if (!this.FAMILYTYPE) {
            this.leftProduct.setSubCategory(this.R_familyType);
        }
        if (!this.INPUT) {
            this.leftProduct.setInput(this.R_input);
        }
        if (!this.OFFERING) {
            this.leftProduct.setOffering(this.R_offering);
        }
        if (!this.PROJECTNAME) {
            this.leftProduct.setProject(this.R_projectName);
        }
        if (!this.QUEST_DESCRIPT) {
            this.leftProduct.setDescription(this.R_questDescript);
        }
        if (!this.WARRANTY) {
            this.leftProduct.setWarranty(this.R_warranty);
        }
        if (!this.LOCATION) {
            this.leftProduct.setLocale(this.R_locale);
        }
        LogSystem.log(1, "MovedChanges");
        LogSystem.endLogSection();
        return this.leftProduct;
    }

    public ProductComparePOMRecCompare(Product product, Product product2) {
        this.leftProduct = product;
        this.rightProduct = product2;
        LogSystem.beginLogSection("Comparing Products...");
        this.getValues();
        this.recCompare();
        LogSystem.endLogSection();
    }
}

