/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.product.compare;

import com.ibm.nzna.projects.common.quest.product.Product;
import com.ibm.nzna.projects.common.quest.product.ProductDraft;
import com.ibm.nzna.projects.common.quest.product.ProductRow;
import com.ibm.nzna.projects.qit.Qit;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.Authority;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.gui.ActionButton;
import com.ibm.nzna.projects.qit.gui.AppDefaultWin;
import com.ibm.nzna.projects.qit.gui.NavPanel;
import com.ibm.nzna.projects.qit.gui.QuestPanel;
import com.ibm.nzna.projects.qit.product.ProductConst;
import com.ibm.nzna.projects.qit.product.compare.ProductCompareEditPanel;
import com.ibm.nzna.projects.qit.product.compare.ProductComparePOMRecCompare;
import com.ibm.nzna.projects.qit.product.gui.FindProductListener;
import com.ibm.nzna.projects.qit.product.gui.ProductSearchDlg;
import com.ibm.nzna.projects.qit.product.productEdit.ProductEditPanelListener;
import com.ibm.nzna.projects.qit.product.productEdit.ProductSaveDlg;
import com.ibm.nzna.shared.gui.DButton;
import com.ibm.nzna.shared.gui.HotLinkLabel;
import com.ibm.nzna.shared.gui.ListPanel;
import com.ibm.nzna.shared.util.LogSystem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ProductComparePanel
extends JPanel
implements Authority,
ProductEditPanelListener,
AdjustmentListener,
QuestPanel,
ProductConst,
AppConst,
ActionListener,
FindProductListener,
Runnable {
    private static final String THREAD_REFRESH_PREVIEW = "RP";
    private static final String THREAD_REFRESH_RIGHT_PRODUCT = "RIGHT_PRODUCT_THREAD";
    private static final String THREAD_REFRESH_LEFT_PRODUCT = "LEFT_PRODUCT_THREAD";
    private static final String left = "LEFT";
    private static final String right = "RIGHT";
    private JPanel leftPanel = null;
    private JScrollPane leftScrollPanel = null;
    private JScrollPane rightScrollPanel = null;
    private JPanel rightPanel = null;
    private ListPanel leftListPanel = null;
    private ListPanel rightListPanel = null;
    private HotLinkLabel hll_LEFT_TITLE = null;
    private HotLinkLabel hll_RIGHT_TITLE = null;
    private HotLinkLabel hll_LEFT_CHANGE_PRODUCT = null;
    private HotLinkLabel hll_RIGHT_CHANGE_PRODUCT = null;
    private HotLinkLabel hll_LEFT_MOVE_CHANGES = null;
    private HotLinkLabel hll_RIGHT_MOVE_CHANGES = null;
    private HotLinkLabel hll_LEFT_SAVE = null;
    private HotLinkLabel hll_RIGHT_SAVE = null;
    private ActionButton pb_CLOSE = null;
    private ProductSaveDlg saveDialog = null;
    private QuestPanel previousPanel = null;
    private boolean initialized = false;
    private boolean leftDraft = false;
    private boolean leftActive = false;
    private boolean rightDraft = false;
    private boolean rightActive = false;
    private boolean leftChangeProduct = false;
    private boolean rightChangeProduct = false;
    private int saveType = 0;
    private int returnCode = 0;
    private ProductCompareEditPanel leftEditPanel = null;
    private ProductCompareEditPanel rightEditPanel = null;
    private ProductComparePOMRecCompare recCompare = null;
    private Product leftProduct = null;
    private Product rightProduct = null;

    public boolean initialize() {
        LogSystem.log(1, "Initializing the ProductComparePanel");
        this.pb_CLOSE = new ActionButton(Str.getStr(28), ImageSystem.getImageIcon((Object)this, 8), Str.getStr(203));
        this.leftPanel = new JPanel();
        this.rightPanel = new JPanel();
        this.leftListPanel = new ListPanel();
        this.rightListPanel = new ListPanel();
        this.hll_LEFT_TITLE = new HotLinkLabel(Str.getStr(19009));
        this.hll_RIGHT_TITLE = new HotLinkLabel(Str.getStr(19009));
        this.hll_LEFT_CHANGE_PRODUCT = new HotLinkLabel(Str.getStr(19002));
        this.hll_RIGHT_CHANGE_PRODUCT = new HotLinkLabel(Str.getStr(19002));
        this.hll_LEFT_MOVE_CHANGES = new HotLinkLabel(Str.getStr(19003));
        this.hll_RIGHT_MOVE_CHANGES = new HotLinkLabel(Str.getStr(19004));
        this.hll_LEFT_SAVE = new HotLinkLabel(Str.getStr(515));
        this.hll_RIGHT_SAVE = new HotLinkLabel(Str.getStr(515));
        this.leftEditPanel = new ProductCompareEditPanel();
        this.rightEditPanel = new ProductCompareEditPanel();
        LogSystem.log(1, "Setting up controls on ProductComparePanel");
        this.leftListPanel.add(this.hll_LEFT_TITLE);
        this.leftListPanel.add(this.hll_LEFT_CHANGE_PRODUCT);
        this.leftListPanel.add(this.hll_LEFT_MOVE_CHANGES);
        this.leftListPanel.add(this.hll_LEFT_SAVE);
        this.rightListPanel.add(this.hll_RIGHT_TITLE);
        this.rightListPanel.add(this.hll_RIGHT_CHANGE_PRODUCT);
        this.rightListPanel.add(this.hll_RIGHT_MOVE_CHANGES);
        this.rightListPanel.add(this.hll_RIGHT_SAVE);
        this.leftListPanel.setBackground(new Color(240, 240, 240));
        this.rightListPanel.setBackground(new Color(240, 240, 240));
        this.leftListPanel.doLayout();
        this.rightListPanel.doLayout();
        this.leftPanel.setLayout(new BorderLayout());
        this.rightPanel.setLayout(new BorderLayout());
        this.leftPanel.add((Component)this.leftEditPanel.getFormPanel(), "Center");
        this.rightPanel.add((Component)this.rightEditPanel.getFormPanel(), "Center");
        LogSystem.log(1, "Adding Components to the ProductComparePanel");
        this.setLayout(null);
        this.setBackground(Color.white);
        this.add(this.leftListPanel);
        this.add(this.rightListPanel);
        this.leftScrollPanel = new JScrollPane(this.leftPanel);
        this.add(this.leftScrollPanel);
        this.rightScrollPanel = new JScrollPane(this.rightPanel);
        this.add(this.rightScrollPanel);
        LogSystem.log(1, "Adjusting Properties on the ProductComparePanel");
        this.hll_LEFT_TITLE.setVisible(false);
        this.hll_LEFT_TITLE.setEnabled(false);
        this.hll_LEFT_TITLE.showSelection(false);
        this.hll_RIGHT_TITLE.setVisible(false);
        this.hll_RIGHT_TITLE.setEnabled(false);
        this.hll_RIGHT_TITLE.showSelection(false);
        this.hll_LEFT_CHANGE_PRODUCT.setEnabled(true);
        this.hll_LEFT_CHANGE_PRODUCT.showSelection(false);
        this.hll_RIGHT_CHANGE_PRODUCT.setEnabled(true);
        this.hll_RIGHT_CHANGE_PRODUCT.showSelection(false);
        this.hll_LEFT_MOVE_CHANGES.setVisible(false);
        this.hll_LEFT_MOVE_CHANGES.showSelection(false);
        this.hll_RIGHT_MOVE_CHANGES.setVisible(false);
        this.hll_RIGHT_MOVE_CHANGES.showSelection(false);
        this.hll_LEFT_SAVE.setVisible(false);
        this.hll_LEFT_SAVE.showSelection(false);
        this.hll_RIGHT_SAVE.setVisible(false);
        this.hll_RIGHT_SAVE.showSelection(false);
        LogSystem.log(1, "Adding Listeners to ProductComparePanel");
        this.pb_CLOSE.addActionListener(this);
        this.hll_LEFT_CHANGE_PRODUCT.addActionListener(this);
        this.hll_RIGHT_CHANGE_PRODUCT.addActionListener(this);
        this.hll_LEFT_MOVE_CHANGES.addActionListener(this);
        this.hll_RIGHT_MOVE_CHANGES.addActionListener(this);
        this.hll_LEFT_SAVE.addActionListener(this);
        this.hll_RIGHT_SAVE.addActionListener(this);
        this.leftEditPanel.getPanel().addProductEditPanelListener(this);
        this.leftScrollPanel.getVerticalScrollBar().addAdjustmentListener(this);
        this.leftScrollPanel.getHorizontalScrollBar().addAdjustmentListener(this);
        this.rightScrollPanel.getVerticalScrollBar().addAdjustmentListener(this);
        this.rightScrollPanel.getHorizontalScrollBar().addAdjustmentListener(this);
        this.setProperties();
        return true;
    }

    public void doLayout() {
        LogSystem.log(1, "doLayout: ProductComparePanel");
        Dimension dimension = this.getSize();
        int n = (int)this.leftListPanel.getPreferredSize().getHeight();
        int n2 = dimension.width / 2;
        this.leftListPanel.setBounds(0, 0, n2 - 2, n);
        this.rightListPanel.setBounds(n2 + 2, 0, n2 - 2, n);
        this.leftListPanel.setPreferredSize(new Dimension(n2 - 2, GUISystem.getRowHeight() * 4));
        this.rightListPanel.setPreferredSize(new Dimension(n2 - 2, GUISystem.getRowHeight() * 4));
        this.leftScrollPanel.setBounds(0, n, n2 - 2, dimension.height - n);
        this.rightScrollPanel.setBounds(n2 + 2, n, n2 - 2, dimension.height - n);
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent.getSource() == this.leftScrollPanel.getVerticalScrollBar()) {
            this.rightScrollPanel.getVerticalScrollBar().setValue(this.leftScrollPanel.getVerticalScrollBar().getValue());
        } else if (adjustmentEvent.getSource() == this.rightScrollPanel.getVerticalScrollBar()) {
            this.leftScrollPanel.getVerticalScrollBar().setValue(this.rightScrollPanel.getVerticalScrollBar().getValue());
        } else if (adjustmentEvent.getSource() == this.leftScrollPanel.getHorizontalScrollBar()) {
            this.rightScrollPanel.getHorizontalScrollBar().setValue(this.leftScrollPanel.getHorizontalScrollBar().getValue());
        } else if (adjustmentEvent.getSource() == this.rightScrollPanel.getHorizontalScrollBar()) {
            this.leftScrollPanel.getHorizontalScrollBar().setValue(this.rightScrollPanel.getHorizontalScrollBar().getValue());
        }
    }

    private void changeHotLinkLabelStatus() {
        LogSystem.beginLogSection("ChangingHotLinkLabelStatus");
        if (this.leftActive && this.rightActive) {
            this.hll_LEFT_TITLE.setText(Str.getStr(716));
            this.hll_LEFT_TITLE.setVisible(true);
            this.hll_RIGHT_TITLE.setText(Str.getStr(716));
            this.hll_RIGHT_TITLE.setVisible(true);
            this.hll_LEFT_MOVE_CHANGES.setVisible(false);
            this.hll_LEFT_MOVE_CHANGES.setEnabled(false);
            this.hll_RIGHT_MOVE_CHANGES.setVisible(false);
            this.hll_RIGHT_MOVE_CHANGES.setEnabled(false);
            this.hll_LEFT_SAVE.setVisible(false);
            this.hll_LEFT_SAVE.setEnabled(false);
            this.hll_RIGHT_SAVE.setVisible(false);
            this.hll_RIGHT_SAVE.setEnabled(false);
            LogSystem.log(1, "Both Active");
        } else if (this.leftDraft && this.rightDraft) {
            this.hll_LEFT_TITLE.setText(Str.getStr(1066));
            this.hll_LEFT_TITLE.setVisible(true);
            this.hll_RIGHT_TITLE.setText(Str.getStr(1066));
            this.hll_RIGHT_TITLE.setVisible(true);
            if (UserSystem.hasAuthority(5)) {
                this.hll_LEFT_SAVE.setVisible(true);
                this.hll_LEFT_SAVE.setEnabled(true);
                this.hll_RIGHT_SAVE.setVisible(true);
                this.hll_RIGHT_SAVE.setEnabled(true);
                this.hll_LEFT_MOVE_CHANGES.setVisible(true);
                this.hll_LEFT_MOVE_CHANGES.setEnabled(true);
                this.hll_RIGHT_MOVE_CHANGES.setVisible(true);
                this.hll_RIGHT_MOVE_CHANGES.setEnabled(true);
            } else {
                this.hll_LEFT_SAVE.setVisible(false);
                this.hll_LEFT_SAVE.setEnabled(false);
                this.hll_RIGHT_SAVE.setVisible(false);
                this.hll_RIGHT_SAVE.setEnabled(false);
                this.hll_LEFT_MOVE_CHANGES.setVisible(false);
                this.hll_LEFT_MOVE_CHANGES.setEnabled(false);
                this.hll_RIGHT_MOVE_CHANGES.setVisible(false);
                this.hll_RIGHT_MOVE_CHANGES.setEnabled(false);
            }
            LogSystem.log(1, "Both Draft");
        } else if (this.leftActive && this.rightDraft) {
            this.hll_LEFT_TITLE.setText(Str.getStr(716));
            this.hll_LEFT_TITLE.setVisible(true);
            this.hll_RIGHT_TITLE.setText(Str.getStr(1066));
            this.hll_RIGHT_TITLE.setVisible(true);
            this.hll_RIGHT_MOVE_CHANGES.setVisible(false);
            this.hll_RIGHT_MOVE_CHANGES.setEnabled(false);
            this.hll_LEFT_SAVE.setVisible(false);
            this.hll_LEFT_SAVE.setEnabled(false);
            if (UserSystem.hasAuthority(5)) {
                this.hll_RIGHT_SAVE.setVisible(true);
                this.hll_RIGHT_SAVE.setEnabled(true);
                this.hll_LEFT_MOVE_CHANGES.setVisible(true);
                this.hll_LEFT_MOVE_CHANGES.setEnabled(true);
            } else {
                this.hll_RIGHT_SAVE.setVisible(false);
                this.hll_RIGHT_SAVE.setEnabled(false);
                this.hll_LEFT_MOVE_CHANGES.setVisible(false);
                this.hll_LEFT_MOVE_CHANGES.setEnabled(false);
            }
            LogSystem.log(1, "Active/Draft");
        } else if (this.leftDraft && this.rightActive) {
            this.hll_LEFT_TITLE.setText(Str.getStr(1066));
            this.hll_LEFT_TITLE.setVisible(true);
            this.hll_RIGHT_TITLE.setText(Str.getStr(716));
            this.hll_RIGHT_TITLE.setVisible(true);
            this.hll_LEFT_MOVE_CHANGES.setVisible(false);
            this.hll_LEFT_MOVE_CHANGES.setEnabled(false);
            if (UserSystem.hasAuthority(5)) {
                this.hll_LEFT_SAVE.setVisible(true);
                this.hll_LEFT_SAVE.setEnabled(true);
                this.hll_RIGHT_MOVE_CHANGES.setVisible(true);
                this.hll_RIGHT_MOVE_CHANGES.setEnabled(true);
            } else {
                this.hll_LEFT_SAVE.setVisible(false);
                this.hll_RIGHT_MOVE_CHANGES.setVisible(false);
                this.hll_RIGHT_MOVE_CHANGES.setEnabled(false);
            }
            this.hll_RIGHT_SAVE.setVisible(false);
            this.hll_RIGHT_SAVE.setEnabled(false);
            LogSystem.log(1, "Draft/Active");
        } else if (this.leftActive && !this.rightActive && !this.rightDraft) {
            this.hll_LEFT_TITLE.setText(Str.getStr(716));
            this.hll_LEFT_TITLE.setVisible(true);
            this.hll_LEFT_MOVE_CHANGES.setVisible(false);
            this.hll_LEFT_SAVE.setVisible(false);
            LogSystem.log(1, "Just Left Active");
        } else if (this.leftDraft && !this.rightActive && !this.rightDraft) {
            this.hll_LEFT_TITLE.setText(Str.getStr(1066));
            this.hll_LEFT_TITLE.setVisible(true);
            this.hll_LEFT_MOVE_CHANGES.setVisible(false);
            this.hll_LEFT_MOVE_CHANGES.setEnabled(false);
            if (UserSystem.hasAuthority(5)) {
                this.hll_LEFT_SAVE.setVisible(true);
                this.hll_LEFT_SAVE.setEnabled(true);
            } else {
                this.hll_LEFT_SAVE.setVisible(false);
                this.hll_LEFT_SAVE.setEnabled(false);
            }
            LogSystem.log(1, "Just Left Draft");
        } else if (this.rightActive && !this.leftActive && !this.leftDraft) {
            this.hll_RIGHT_TITLE.setText(Str.getStr(716));
            this.hll_RIGHT_TITLE.setVisible(true);
            this.hll_RIGHT_MOVE_CHANGES.setVisible(false);
            this.hll_RIGHT_MOVE_CHANGES.setEnabled(false);
            this.hll_RIGHT_SAVE.setVisible(false);
            this.hll_RIGHT_SAVE.setEnabled(false);
            LogSystem.log(1, "Just Right Active");
        } else if (this.rightDraft && !this.leftActive && !this.leftDraft) {
            this.hll_RIGHT_TITLE.setText(Str.getStr(1066));
            this.hll_RIGHT_TITLE.setVisible(true);
            this.hll_RIGHT_MOVE_CHANGES.setVisible(false);
            if (UserSystem.hasAuthority(5)) {
                this.hll_RIGHT_SAVE.setVisible(true);
                this.hll_RIGHT_SAVE.setEnabled(true);
            } else {
                this.hll_RIGHT_SAVE.setVisible(false);
                this.hll_RIGHT_SAVE.setEnabled(false);
            }
            LogSystem.log(1, "Just Left Draft");
        }
        LogSystem.endLogSection();
    }

    private void findProductStatus() {
        LogSystem.log(1, "Finding Product Status: Draft or Active");
        this.leftDraft = false;
        this.leftActive = false;
        this.rightDraft = false;
        this.rightActive = false;
        if (this.leftProduct != null) {
            if (this.leftProduct instanceof ProductDraft) {
                this.leftDraft = true;
            } else if (this.leftProduct instanceof Product) {
                this.leftActive = true;
            }
        }
        if (this.rightProduct != null) {
            if (this.rightProduct instanceof ProductDraft) {
                this.rightDraft = true;
            } else if (this.rightProduct instanceof Product) {
                this.rightActive = true;
            }
        }
    }

    public void start() {
        AppDefaultWin appDefaultWin = GUISystem.getParentDefWin(this);
        appDefaultWin.addActionComponent(this, this.pb_CLOSE);
        if (this.leftProduct != null) {
            this.leftEditPanel.setProduct(this.leftProduct);
        }
        if (this.rightProduct != null) {
            this.rightEditPanel.setProduct(this.rightProduct);
        }
    }

    public boolean shutdown() {
        return Qit.getEnabled();
    }

    public boolean stop() {
        this.panelDeselected();
        this.removeAll();
        return Qit.getEnabled();
    }

    public void findProductComplete(Vector vector) {
        ProductRow productRow;
        int n;
        LogSystem.beginLogSection("FindProductComplete");
        if (vector != null && vector.size() > 0 && (n = (productRow = (ProductRow)vector.elementAt(0)).readProduct(true)) == 0) {
            if (productRow.isDraft()) {
                ProductDraft productDraft = (ProductDraft)productRow.getProduct();
                if (this.leftChangeProduct) {
                    this.setLeftProduct(productDraft);
                } else if (this.rightChangeProduct) {
                    this.setRightProduct(productDraft);
                }
            } else if (!productRow.isDraft()) {
                Product product = productRow.getProduct();
                if (this.leftChangeProduct) {
                    this.setLeftProduct(product);
                } else if (this.rightChangeProduct) {
                    this.setRightProduct(product);
                }
            }
        }
        this.refresh();
        LogSystem.endLogSection();
    }

    public void run() {
        String string = Thread.currentThread().getName();
        Qit.setEnabled(false);
        try {
            if (string.equals(THREAD_REFRESH_PREVIEW)) {
                this.refreshPreview();
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
        }
        Qit.setEnabled(true);
    }

    private void refreshPreview() {
        if (this.leftProduct != null) {
            this.leftEditPanel.setProduct(this.getLeftProduct());
        }
        if (this.rightProduct != null) {
            this.rightEditPanel.setProduct(this.getRightProduct());
        }
        this.setProperties();
    }

    public void refresh() {
        new Thread((Runnable)this, THREAD_REFRESH_PREVIEW).start();
    }

    public void panelSelected() {
    }

    public void panelDeselected() {
    }

    private void setProperties() {
        LogSystem.log(1, "Setting Properties: ProductComparePanel ");
        this.findProductStatus();
        this.changeHotLinkLabelStatus();
        this.revalidate();
        this.leftChangeProduct = false;
        this.rightChangeProduct = false;
    }

    public ImageIcon getIcon() {
        return ImageSystem.getImageIcon((Object)this, 239);
    }

    public ImageIcon getSmallIcon() {
        return ImageSystem.getImageIcon((Object)this, 239);
    }

    public NavPanel getDefaultNavPanel() {
        return null;
    }

    public String getName() {
        return Str.getStr(19000);
    }

    public JComponent getJComponent() {
        return this;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JComponent jComponent;
        if (Qit.getEnabled() && actionEvent.getSource() instanceof HotLinkLabel) {
            jComponent = (HotLinkLabel)actionEvent.getSource();
            if (jComponent == this.hll_LEFT_CHANGE_PRODUCT) {
                this.leftChangeProduct = true;
                new ProductSearchDlg().addFindProductListener(this);
            }
            if (jComponent == this.hll_RIGHT_CHANGE_PRODUCT) {
                this.rightChangeProduct = true;
                new ProductSearchDlg().addFindProductListener(this);
            }
            if (jComponent == this.hll_LEFT_MOVE_CHANGES) {
                this.moveChanges(left);
                this.rightEditPanel.setProduct(this.rightProduct);
            }
            if (jComponent == this.hll_RIGHT_MOVE_CHANGES) {
                this.moveChanges(right);
                this.leftEditPanel.setProduct(this.leftProduct);
            }
            if (jComponent == this.hll_LEFT_SAVE) {
                this.saveType = this.leftEditPanel.saveProduct();
            }
            if (jComponent == this.hll_RIGHT_SAVE) {
                this.saveType = this.rightEditPanel.saveProduct();
            }
        }
        if (Qit.getEnabled() && actionEvent.getSource() instanceof DButton && (jComponent = (DButton)actionEvent.getSource()) == this.pb_CLOSE) {
            GUISystem.getParentDefWin(this).closePanel(this, this.previousPanel);
        }
    }

    public boolean bookmark() {
        return false;
    }

    public boolean copyText() {
        return false;
    }

    public boolean cutText() {
        return false;
    }

    public boolean pasteText() {
        return false;
    }

    public void setRightProduct(Product product) {
        this.rightProduct = product;
    }

    public void setLeftProduct(Product product) {
        this.leftProduct = product;
    }

    public Product getRightProduct() {
        return this.rightProduct;
    }

    public Product getLeftProduct() {
        return this.leftProduct;
    }

    private boolean findActive(ProductDraft productDraft) {
        GUISystem.getParentDefWin(this).setStatus(19005);
        int n = 0;
        if (productDraft != null) {
            n = productDraft.getExistingProductInd();
            if (n != 0) {
                LogSystem.beginLogSection("Searching for an Active Product.....");
                Product product = new Product(n);
                this.returnCode = product.readFromDatabase();
                switch (this.returnCode) {
                    case 0: {
                        LogSystem.log(1, "Found Active Product");
                        this.rightProduct = product;
                        break;
                    }
                    case 100: {
                        LogSystem.log(1, "Could not find the Active Product");
                        break;
                    }
                    default: {
                        LogSystem.log(1, "Return Code: " + this.returnCode);
                        break;
                    }
                }
            }
            LogSystem.endLogSection();
            if (this.returnCode != 0) {
                GUISystem.getParentDefWin(this).setStatus(19006);
                return false;
            }
            GUISystem.getParentDefWin(this).setStatus(19007);
            return true;
        }
        return false;
    }

    private void moveChanges(String string) {
        LogSystem.log(1, "MoveChanges: ProductComparePanel");
        if (string.equals(left)) {
            this.rightProduct = this.recCompare.leftMoveChanges();
            this.hll_LEFT_MOVE_CHANGES.setVisible(false);
            this.hll_LEFT_MOVE_CHANGES.setEnabled(false);
            this.hll_RIGHT_MOVE_CHANGES.setVisible(false);
            this.hll_RIGHT_MOVE_CHANGES.setEnabled(false);
            this.setRightProduct(this.rightProduct);
        }
        if (string.equals(right)) {
            this.leftProduct = this.recCompare.rightMoveChanges();
            this.hll_LEFT_MOVE_CHANGES.setVisible(false);
            this.hll_LEFT_MOVE_CHANGES.setEnabled(false);
            this.hll_RIGHT_MOVE_CHANGES.setVisible(false);
            this.hll_RIGHT_MOVE_CHANGES.setEnabled(false);
            this.setLeftProduct(this.leftProduct);
        }
        this.revalidate();
    }

    private void recordCompare() {
        LogSystem.beginLogSection("ProductComparePanel - recordCompare");
        this.recCompare = new ProductComparePOMRecCompare(this.leftProduct, this.rightProduct);
        if (!this.recCompare.PROD_NUM) {
            this.leftEditPanel.setChangedLabel(26);
        }
        if (!this.recCompare.BASE_MODEL) {
            this.leftEditPanel.setChangedLabel(0);
        }
        if (!this.recCompare.BRAND) {
            this.leftEditPanel.setChangedLabel(1);
        }
        if (!this.recCompare.CREATED) {
            this.leftEditPanel.setChangedLabel(2);
        }
        if (!this.recCompare.CREATED_BY) {
            this.leftEditPanel.setChangedLabel(3);
        }
        if (!this.recCompare.CUSTOMER) {
            this.leftEditPanel.setChangedLabel(4);
        }
        if (!this.recCompare.DATES_FOR_COUNTRY) {
            this.leftEditPanel.setChangedLabel(5);
        }
        if (!this.recCompare.FAMILY) {
            this.leftEditPanel.setChangedLabel(6);
        }
        if (!this.recCompare.FAMILYTYPE) {
            this.leftEditPanel.setChangedLabel(7);
        }
        if (!this.recCompare.INPUT) {
            this.leftEditPanel.setChangedLabel(8);
        }
        if (!this.recCompare.LAST_TOUCHED_BY) {
            this.leftEditPanel.setChangedLabel(10);
        }
        if (!this.recCompare.MACHINE) {
            this.leftEditPanel.setChangedLabel(11);
        }
        if (!this.recCompare.MODEL) {
            this.leftEditPanel.setChangedLabel(12);
        }
        if (!this.recCompare.OFFERING) {
            this.leftEditPanel.setChangedLabel(13);
        }
        if (!this.recCompare.OPICM_DESCRIPT) {
            this.leftEditPanel.setChangedLabel(14);
        }
        if (!this.recCompare.PARTNUM) {
            this.leftEditPanel.setChangedLabel(15);
        }
        if (!this.recCompare.PRODUCT_IND) {
            this.leftEditPanel.setChangedLabel(17);
        }
        if (!this.recCompare.PROJECTNAME) {
            this.leftEditPanel.setChangedLabel(18);
        }
        if (!this.recCompare.QUEST_DESCRIPT) {
            this.leftEditPanel.setChangedLabel(19);
        }
        if (!this.recCompare.SOURCE) {
            this.leftEditPanel.setChangedLabel(20);
        }
        if (!this.recCompare.WARRANTY) {
            this.leftEditPanel.setChangedLabel(21);
        }
        if (!this.recCompare.DRAFT_CREATED_ON) {
            this.leftEditPanel.setChangedLabel(24);
        }
        if (!this.recCompare.PRODUCT_DRAFT_IND) {
            this.leftEditPanel.setChangedLabel(23);
        }
        if (!this.recCompare.LAST_TOUCHED_ON) {
            this.leftEditPanel.setChangedLabel(25);
        }
        LogSystem.log(1, "finished compare");
        LogSystem.endLogSection();
    }

    public void refreshComplete() {
        LogSystem.log(1, "RefreshComplete: ProductComparePanel");
        if (this.leftProduct != null && this.rightProduct != null) {
            this.recordCompare();
        }
    }

    public ProductComparePanel() {
        this.leftProduct = null;
        this.rightProduct = null;
    }

    public ProductComparePanel(QuestPanel questPanel) {
        this.leftProduct = null;
        this.rightProduct = null;
        this.previousPanel = questPanel;
    }

    public ProductComparePanel(Product product, QuestPanel questPanel) {
        if (product instanceof ProductDraft && !this.findActive((ProductDraft)product)) {
            this.rightProduct = null;
        }
        this.leftProduct = product;
        this.previousPanel = questPanel;
    }

    public ProductComparePanel(Product product, Product product2, QuestPanel questPanel) {
        this.leftProduct = product;
        this.rightProduct = product2;
        this.previousPanel = questPanel;
    }
}

